/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.scm.common.ISMSDBillConfig;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.SMSDBillConfigCollection;
import com.kingdee.eas.scm.common.SMSDBillConfigFactory;
import com.kingdee.eas.scm.common.SMSDBillConfigInfo;
import com.kingdee.eas.scm.common.loadmass.SCMLockInvDataVO;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.IInventory;
import com.kingdee.eas.scm.im.inv.ILockInventory;
import com.kingdee.eas.scm.im.inv.InventoryFactory;
import com.kingdee.eas.scm.im.inv.LockInventoryCollection;
import com.kingdee.eas.scm.im.inv.LockInventoryFactory;
import com.kingdee.eas.scm.im.inv.LockInventoryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.app.AbstractSaleOrderLockUIHandler;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SaleOrderLockUIHandler
extends AbstractSaleOrderLockUIHandler {
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
    }

    private void commonOprt(RequestContext request, ResponseContext response, Context context) throws Exception {
        IObjectPK[] idList = (IObjectPK[])request.get("idList");
        SCMLockInvDataVO vo = new SCMLockInvDataVO();
        vo.setIdList(idList);
        vo.setType("top");
        vo.setTableNether(false);
        SCMLockInvDataVO resultVO = SCMGroupFacadeFactory.getLocalInstance((Context)context).loadSaleLockInvData(vo);
        SCMLockInvDataVO voa = new SCMLockInvDataVO();
        voa.setTableNether(true);
        voa.setType("bottom");
        EntityViewInfo viewInfo = this.makeInvEntityViewInfo(resultVO, this.getFirstExistObjectPK(resultVO, idList));
        if (viewInfo != null) {
            FilterInfo filter = new FilterInfo();
            FilterItemInfo billClassNameFilter = new FilterItemInfo("billClassName", (Object)"com.kingdee.eas.scm.sd.sale.client.SaleOrderLockUI", CompareType.EQUALS);
            FilterItemInfo userIDFilter = new FilterItemInfo("userID", (Object)context.getCaller().toString(), CompareType.EQUALS);
            FilterItemInfo configTypeFilter = new FilterItemInfo("configType", (Object)"orderRule", CompareType.EQUALS);
            filter.getFilterItems().add(billClassNameFilter);
            filter.getFilterItems().add(userIDFilter);
            filter.getFilterItems().add(configTypeFilter);
            EntityViewInfo ev = new EntityViewInfo();
            ev.setFilter(filter);
            ISMSDBillConfig iSMSDBillConfig = SMSDBillConfigFactory.getLocalInstance((Context)context);
            SMSDBillConfigCollection aSMSDBillConfigCollection = iSMSDBillConfig.getSMSDBillConfigCollection(ev);
            SMSDBillConfigInfo aSMSDBillConfig = null;
            String result = null;
            SorterItemCollection sorterIc = new SorterItemCollection();
            if (aSMSDBillConfigCollection.size() > 0 && (aSMSDBillConfig = aSMSDBillConfigCollection.get(0)).getConfigValue() != null) {
                result = aSMSDBillConfig.getConfigValue().toString();
                if ("0".equals(result)) {
                    sorterIc.add(new SorterItemInfo("warehouse"));
                    sorterIc.add(new SorterItemInfo("lot"));
                } else if ("1".equals(result)) {
                    sorterIc.add(new SorterItemInfo("lot"));
                }
            }
            viewInfo.setSorter(sorterIc);
        }
        if (viewInfo == null) {
            return;
        }
        voa.setViewInfo(viewInfo);
        SCMGroupFacadeFactory.getLocalInstance((Context)context).loadSaleLockInvData(voa);
        ILockInventory iLockInventory = LockInventoryFactory.getLocalInstance((Context)context);
        EntityViewInfo viewInfo1 = this.makeGettingInvCollecitonEntityView(resultVO, this.getFirstExistObjectPK(resultVO, idList));
        if (viewInfo1 == null) {
            return;
        }
        iLockInventory.getLockInventoryCollection(viewInfo1);
    }

    private IObjectPK getFirstExistObjectPK(SCMLockInvDataVO resultVO, IObjectPK[] idList) {
        IObjectPK pk = null;
        for (int i = 0; i < idList.length; ++i) {
            pk = idList[i];
            if (resultVO.getEntryInfoMap().containsKey(pk.toString())) break;
        }
        return pk;
    }

    private EntityViewInfo makeGettingInvCollecitonEntityView(SCMLockInvDataVO resultVO, IObjectPK pk) {
        Map infoMap = resultVO.getInfoMap();
        SaleOrderInfo saleOrderInfo = (SaleOrderInfo)infoMap.get(pk.toString());
        if (saleOrderInfo == null) {
            return null;
        }
        String billentryid = pk.toString();
        String billid = saleOrderInfo.getId().toString();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo billidFilter = new FilterItemInfo("BILLID", (Object)billid, CompareType.EQUALS);
        FilterItemInfo billEntryidFilter = new FilterItemInfo("BILLENTRYID", (Object)billentryid, CompareType.EQUALS);
        filter.getFilterItems().add(billidFilter);
        filter.getFilterItems().add(billEntryidFilter);
        ev.setFilter(filter);
        return ev;
    }

    private EntityViewInfo makeInvEntityViewInfo(SCMLockInvDataVO resultVO, IObjectPK pk) {
        WarehouseInfo wareHouseInfo;
        SaleOrderEntryInfo saleOrderEntryInfo = (SaleOrderEntryInfo)resultVO.getEntryInfoMap().get(pk.toString());
        if (saleOrderEntryInfo == null) {
            return null;
        }
        Map materialMap = resultVO.getMaterialMap();
        Map assitAttrMap = resultVO.getAssitAttrMap();
        EntityViewInfo ev = new EntityViewInfo();
        MaterialInfo aMaterialInfo = (MaterialInfo)materialMap.get(saleOrderEntryInfo.getId().toString());
        AsstAttrValueInfo asstAttrValueInfo = (AsstAttrValueInfo)assitAttrMap.get(saleOrderEntryInfo.getId().toString());
        FilterInfo filter = new FilterInfo();
        FilterItemInfo companyFilter = new FilterItemInfo("STORAGEORGUNIT.ID", (Object)saleOrderEntryInfo.getStorageOrgUnit().getId().toString(), CompareType.EQUALS);
        FilterItemInfo materialFilter = new FilterItemInfo("MATERIAL.ID", (Object)aMaterialInfo.getId().toString(), CompareType.EQUALS);
        FilterItemInfo storeTypeFilter = new FilterItemInfo("STORETYPE.ID", (Object)"181875d5-0105-1000-e000-0111c0a812fd97D461A6", CompareType.EQUALS);
        FilterItemInfo storeStatusFilter = new FilterItemInfo("STORESTATUS.ID", (Object)"181875d5-0105-1000-e000-012ec0a812fd62A73FA5", CompareType.EQUALS);
        filter.getFilterItems().add(companyFilter);
        filter.getFilterItems().add(materialFilter);
        filter.getFilterItems().add(storeTypeFilter);
        filter.getFilterItems().add(storeStatusFilter);
        if (asstAttrValueInfo != null) {
            FilterItemInfo assistFilter = new FilterItemInfo("assistProperty.ID", (Object)asstAttrValueInfo.getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(assistFilter);
        }
        if ((wareHouseInfo = (WarehouseInfo)resultVO.getWareHouseMap().get(saleOrderEntryInfo.getId().toString())) != null) {
            FilterItemInfo wareHouseFilter = new FilterItemInfo("WAREHOUSE.ID", (Object)wareHouseInfo.getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(wareHouseFilter);
        }
        ev.setFilter(filter);
        return ev;
    }

    private boolean checkQty(RequestContext request) {
        BigDecimal fLockQty = (BigDecimal)request.get("FLockQty");
        if (fLockQty != null) {
            BigDecimal fLockBaseQty = (BigDecimal)request.get("FLockBaseQty");
            BigDecimal fCanLockBaseQty = (BigDecimal)request.get("FCanLockBaseQty");
            if (fLockBaseQty == null) {
                return false;
            }
            return fLockBaseQty.compareTo(fCanLockBaseQty) == 0;
        }
        return false;
    }

    @Override
    protected void _handleActionLock(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    public void dealWithActionLock(RequestContext request, ResponseContext response, Context context) throws Exception {
        HashMap LockMap = (HashMap)request.get("LockMap");
        if (LockMap == null || LockMap != null && LockMap.size() == 0) {
            return;
        }
        if (this.checkQty(request)) {
            this.saveCurLockInfo(request, context);
            HashMap[] hms = (HashMap[])request.get("convertdHms");
            IInventory ii = InventoryFactory.getLocalInstance((Context)context);
            ii.lockInventory(hms);
            this.commonOprt(request, response, context);
        }
    }

    private void saveCurLockInfo(RequestContext request, Context context) throws Exception {
        HashMap LockMap = (HashMap)request.get("LockMap");
        if (LockMap == null) {
            return;
        }
        Set key = LockMap.keySet();
        String keyID2 = null;
        HashMap tempHm = null;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)context);
        MultiMeasureUnitInfo mNnitInfo = null;
        MultiMeasureUnitInfo mBaseUnitInfo = null;
        MeasureUnitInfo unitInfo = null;
        MeasureUnitInfo baseUnitInfo = null;
        MaterialInfo amaterialInfo = null;
        BigDecimal curLockQty = null;
        BigDecimal lockBaseQty = null;
        for (String keyID2 : key) {
            tempHm = (HashMap)LockMap.get(keyID2);
            amaterialInfo = (MaterialInfo)tempHm.get("tblOrderMaterialInfo");
            unitInfo = (MeasureUnitInfo)tempHm.get("lockUnit");
            baseUnitInfo = (MeasureUnitInfo)tempHm.get("orderBaseUnit");
            if (mNnitInfo == null) {
                mNnitInfo = multiUnit.getMultiUnit(amaterialInfo.getId().toString(), unitInfo.getId().toString());
            }
            if (mBaseUnitInfo == null) {
                mBaseUnitInfo = multiUnit.getMultiUnit(amaterialInfo.getId().toString(), baseUnitInfo.getId().toString());
            }
            curLockQty = (BigDecimal)tempHm.get("FCurLockQty");
            lockBaseQty = this.getConvertedQtyByMunit(curLockQty, mNnitInfo, mBaseUnitInfo);
            lockBaseQty = lockBaseQty.setScale(curLockQty.scale(), 4);
            tempHm.put("FLockBaseQty", lockBaseQty);
        }
        HashMap[] hms = new HashMap[LockMap.size()];
        Iterator keyValuePairs1 = LockMap.entrySet().iterator();
        for (int i = 0; i < LockMap.size(); ++i) {
            HashMap hm;
            Map.Entry entry = keyValuePairs1.next();
            Object value = entry.getValue();
            hms[i] = hm = (HashMap)value;
        }
        request.put("convertdHms", (Object)hms);
    }

    @Override
    protected void _handleActionUnLock(RequestContext request, ResponseContext response, Context context) throws Exception {
        int rowCount = (Integer)request.get("rowCount");
        if (rowCount == 0) {
            return;
        }
        List list = (List)request.get("list");
        HashMap LockMap = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            String[] ids = (String[])list.get(i);
            this.getInventroy(LockMap, request, ids, context);
        }
        if (LockMap.size() == 0) {
            return;
        }
        HashMap[] hms = new HashMap[LockMap.size()];
        Iterator keyValuePairs1 = LockMap.entrySet().iterator();
        for (int i = 0; i < LockMap.size(); ++i) {
            HashMap hm;
            Map.Entry entry = keyValuePairs1.next();
            Object value = entry.getValue();
            hms[i] = hm = (HashMap)value;
        }
        IInventory ii = InventoryFactory.getLocalInstance((Context)context);
        ii.unLockInventory(hms);
        IObjectPK[] idList = (IObjectPK[])request.get("idList");
        SCMLockInvDataVO vo = new SCMLockInvDataVO();
        vo.setIdList(idList);
        vo.setType("top");
        vo.setTableNether(false);
        SCMLockInvDataVO resultVO = SCMGroupFacadeFactory.getLocalInstance((Context)context).loadSaleLockInvData(vo);
        SCMLockInvDataVO voa = new SCMLockInvDataVO();
        voa.setTableNether(true);
        voa.setType("bottom");
        voa.setViewInfo(this.makeInvEntityViewInfo(resultVO, idList[0]));
        SCMGroupFacadeFactory.getLocalInstance((Context)context).loadSaleLockInvData(voa);
    }

    private void getInventroy(HashMap LockMap, RequestContext request, String[] ids, Context context) throws Exception {
        String billentryid = ids[0];
        String billid = ids[1];
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo billidFilter = new FilterItemInfo("BILLID", (Object)billid, CompareType.EQUALS);
        FilterItemInfo billEntryidFilter = new FilterItemInfo("BILLENTRYID", (Object)billentryid, CompareType.EQUALS);
        filter.getFilterItems().add(billidFilter);
        filter.getFilterItems().add(billEntryidFilter);
        ev.setFilter(filter);
        ILockInventory iLockInventory = LockInventoryFactory.getLocalInstance((Context)context);
        LockInventoryCollection aLockInventoryCollection = iLockInventory.getLockInventoryCollection(ev);
        int n = aLockInventoryCollection.size();
        for (int i = 0; i < n; ++i) {
            LockInventoryInfo aInventoryInfo = (LockInventoryInfo)aLockInventoryCollection.getObject(i);
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("FBillID", billid);
            hm.put("FBillEntryID", billentryid);
            hm.put("FInventoryID", aInventoryInfo.getInventoryID().toString());
            hm.put("FLockQty", aInventoryInfo.getLockQty());
            hm.put("FLockBaseQty", aInventoryInfo.getLockBaseQty());
            hm.put("FLockAssistQty", aInventoryInfo.getLockAssistQty());
            LockMap.put(billentryid + aInventoryInfo.getInventoryID().toString(), hm);
        }
    }

    private BigDecimal getConvertedQtyByMunit(BigDecimal qty, MultiMeasureUnitInfo fromUnit, MultiMeasureUnitInfo toUnit) {
        BigDecimal targetQty = null;
        if (fromUnit != null && toUnit != null) {
            BigDecimal fromERate = fromUnit.getBaseConvsRate();
            BigDecimal toERate = toUnit.getBaseConvsRate();
            if (fromERate == null) {
                fromERate = new BigDecimal("1.00");
            }
            if (toERate == null) {
                toERate = new BigDecimal("1.00");
            }
            targetQty = SCMUtils.effectualNumeric((BigDecimal)qty).multiply(fromERate);
            int scale = 10;
            if (targetQty != null && qty != null) {
                scale = targetQty.scale() + qty.scale();
            }
            targetQty = SCMUtils.effectualNumeric((BigDecimal)targetQty).divide(SCMUtils.effectualExchangeRate((BigDecimal)toERate), scale != 0 ? scale : 10, 4);
        }
        return targetQty;
    }
}

