/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceParam;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceProvider;
import com.kingdee.eas.basedata.scm.sd.sale.PriceCondition;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamException;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyException;
import com.kingdee.eas.basedata.scm.sd.sale.PriceProviderFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SalePriceTO;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.sd.sale.ISaleInnerDealPrice;
import com.kingdee.eas.scm.sd.sale.SaleInnerDealPriceFactory;
import com.kingdee.eas.scm.sd.sale.SaleInnerDealPriceInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnInnerDealPriceCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import com.kingdee.eas.scm.sd.sale.app.AbstractSaleReturnInnerDealPriceControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SaleReturnInnerDealPriceControllerBean
extends AbstractSaleReturnInnerDealPriceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.SaleReturnInnerDealPriceControllerBean");

    @Override
    protected IObjectValue _getInnerDealPrice(Context ctx, String saleReturnEntryId) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("saleRetrunEntry.id", (Object)saleReturnEntryId));
        viewInfo.setFilter(filterInfo);
        SaleReturnInnerDealPriceCollection collection = this.getSaleReturnInnerDealPriceCollection(ctx, viewInfo);
        if (collection.size() > 0) {
            return collection.get(0);
        }
        return null;
    }

    @Override
    protected IObjectValue _getInnerDealPrice(Context ctx, String saleRetrunID, String saleRetrunEntryID, String companyOrgUnitID) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("saleRetrun.id", (Object)saleRetrunID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("saleRetrunEntry.id", (Object)saleRetrunEntryID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyOrgUnitID, CompareType.EQUALS));
        view.setFilter(filter);
        SaleReturnInnerDealPriceCollection collection = this.getSaleReturnInnerDealPriceCollection(ctx, view);
        if (collection.size() > 0) {
            return collection.get(0);
        }
        return null;
    }

    private String getVerifyCentralSQL(String params) {
        StringBuffer sql = new StringBuffer();
        sql.append("select sr.Fid from T_SD_SaleReturns sr ");
        sql.append(" inner join T_SD_SaleReturnsEntry se on se.FParentID = sr.FID ");
        sql.append(" where sr.FID in (").append(params).append(") ");
        sql.append(" and sr.FIsCentralBalance = 1 and sr.FIsSquareBalance = 0 and se.FIsBetweenCompanySend = 1 ");
        return sql.toString();
    }

    private String getVerifySquareSQL(String params) {
        StringBuffer sql = new StringBuffer();
        sql.append("select sr.Fid from T_SD_SaleReturns sr ");
        sql.append(" inner join T_SD_SaleReturnsEntry se on se.FParentID = sr.FID ");
        sql.append(" where sr.FID in (").append(params).append(") ");
        sql.append(" and sr.FIsCentralBalance = 1 and sr.FIsSquareBalance = 1 and se.FIsBetweenCompanySend = 1 ");
        return sql.toString();
    }

    private String getCentralBalanceSQL(String params) {
        StringBuffer sql = new StringBuffer();
        sql.append("select sr.fid id,sr.fsourcebilltypeid sourcebilltypeid,sr.FBizDate bizDate,se.fid entryid,sr.FSaleOrgUnitID saleOrgUntiID,");
        sql.append(" se.FCompanyOrgUnitID companyOrgUntiID,sr.FCurrencyID currencyid,se.FMaterialID materialid,se.FUnitID unitid,");
        sql.append(" se.FBaseUnitID baseUnitID, se.FAssistPropertyID assistProperyID,cus.fid customerid,se.FQty qty,se.FTaxRate taxrate,");
        sql.append(" se.FCheapRate secheaprate,se.FPrice price,-1 discounttype,0.0000 discount, se.FTaxRate actualprice,");
        sql.append(" se.FTaxPrice actualtaxprice,se.FTaxPrice taxprice,se.fsourcebillid sourcebillid,se.fsourcebillentryid sourcebillentryid,");
        sql.append(" material.FPricePrecision priceprecision ,mi.FCheapRate cheapRate ,ms.FCheapRate scheapRate");
        sql.append("  from T_SD_SaleReturns sr ");
        sql.append(" inner join T_SD_SaleReturnsEntry se on se.FParentID = sr.FID ");
        sql.append(" inner join T_BD_Customer cus on cus.FInternalCompanyID = sr.FCompanyOrgUnitID  and cus.fusedstatus = 1");
        sql.append(" inner join T_BD_Material material on se.FMaterialID = material.FID ");
        sql.append(" inner join T_BD_MaterialInventory mi on se.FMaterialID = mi.FMaterialID and se.FStorageOrgUnitID = mi.FOrgUnit");
        sql.append(" left join T_BD_MaterialSales ms on se.FMaterialID = ms.FMaterialID and sr.FSaleOrgUnitID = ms.FOrgUnit");
        sql.append(" where sr.FID in (").append(params).append(")");
        sql.append(" and sr.FIsCentralBalance = 1 and se.FIsBetweenCompanySend = 1 ");
        return sql.toString();
    }

    private String getSquareBalanceSQL(String params) {
        StringBuffer sql = new StringBuffer();
        sql.append("select sr.fid id,se.fid entryid,sr.FBizDate bizDate,sr.FSaleOrgUnitID saleOrgUntiID,sr.FBalanceCompanyOrgUnitID companyOrgUntiID,");
        sql.append(" sr.FCurrencyID currencyid,se.FMaterialID materialid,se.FUnitID unitid,se.FBaseUnitID baseUnitID,se.FAssistPropertyID assistProperyID,");
        sql.append(" cus.fid customerid,se.FQty qty,se.FTaxRate taxrate,se.FPrice price,-1 discounttype,0.0000 discount,");
        sql.append(" se.FTaxRate actualprice,se.FTaxPrice actualtaxprice,se.FTaxPrice taxprice ,material.FPricePrecision priceprecision,mi.FCheapRate cheapRate ");
        sql.append("  from T_SD_SaleReturns sr ");
        sql.append(" inner join T_SD_SaleReturnsEntry se on se.FParentID = sr.FID ");
        sql.append(" inner join T_BD_Customer cus on cus.FInternalCompanyID = sr.FCompanyOrgUnitID  and cus.fusedstatus = 1");
        sql.append(" inner join T_BD_Material material on se.FMaterialID = material.FID ");
        sql.append(" inner join T_BD_MaterialInventory mi on se.FMaterialID = mi.FMaterialID and se.FStorageOrgUnitID = mi.FOrgUnit");
        sql.append(" where sr.FID in (").append(params).append(")");
        sql.append(" and sr.FIsCentralBalance = 1 and sr.FIsSquareBalance = 1 and se.FIsBetweenCompanySend = 1 ");
        return sql.toString();
    }

    private String getSquareBalance4BalanceSQL(String params) {
        StringBuffer sql = new StringBuffer();
        sql.append("select sr.fid id,se.fid entryid,sr.FBizDate bizDate,sr.FSaleOrgUnitID saleOrgUntiID,se.FCompanyOrgUnitID companyOrgUntiID,");
        sql.append(" sr.FCurrencyID currencyid,se.FMaterialID materialid,se.FUnitID unitid,se.FBaseUnitID baseUnitID,se.FAssistPropertyID assistProperyID,");
        sql.append(" cus.fid customerid,se.FQty qty,se.FTaxRate taxrate,se.FPrice price,-1 discounttype,0.0000 discount, se.FTaxRate actualprice,");
        sql.append(" se.FTaxPrice actualtaxprice,se.FTaxPrice taxprice ,material.FPricePrecision priceprecision, mi.FCheapRate cheapRate ");
        sql.append("  from T_SD_SaleReturns sr ");
        sql.append(" inner join T_SD_SaleReturnsEntry se on se.FParentID = sr.FID ");
        sql.append(" inner join T_BD_Customer cus on cus.FInternalCompanyID = sr.FBalanceCompanyOrgUnitID  and cus.fusedstatus = 1");
        sql.append(" inner join T_BD_Material material on se.FMaterialID = material.FID ");
        sql.append(" inner join T_BD_MaterialInventory mi on se.FMaterialID = mi.FMaterialID and se.FStorageOrgUnitID = mi.FOrgUnit");
        sql.append(" where sr.FID in (").append(params).append(")");
        sql.append(" and sr.FIsCentralBalance = 1 and sr.FIsSquareBalance = 1 and se.FIsBetweenCompanySend = 1 ");
        return sql.toString();
    }

    @Override
    protected void _caculateInnerDealPrice(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        IRowSet verifyResult = null;
        IRowSet centralBalanceResult = null;
        IRowSet squareBalanceResult1 = null;
        IRowSet squareBalanceResult2 = null;
        String params = StringUtil.getKeyIdList((Object[])pks);
        String verifySQL = this.getVerifySquareSQL(params);
        String verifyCentralSQL = this.getVerifyCentralSQL(params);
        String centralBalanceSQL = this.getCentralBalanceSQL(params);
        String squareBalanceSQL1 = this.getSquareBalance4BalanceSQL(params);
        String squareBalanceSQL2 = this.getSquareBalanceSQL(params);
        this._clearInnerDealPrice(ctx, pks);
        try {
            verifyResult = DbUtil.executeQuery((Context)ctx, (String)verifySQL.toString());
            if (verifyResult.next()) {
                squareBalanceResult1 = DbUtil.executeQuery((Context)ctx, (String)squareBalanceSQL1);
                this.processSaleReturnInnerDealPrice(ctx, (ResultSet)squareBalanceResult1, true);
                squareBalanceResult2 = DbUtil.executeQuery((Context)ctx, (String)squareBalanceSQL2);
                this.processSaleReturnInnerDealPrice(ctx, (ResultSet)squareBalanceResult2, true);
            }
            if ((verifyResult = DbUtil.executeQuery((Context)ctx, (String)verifyCentralSQL)).next()) {
                centralBalanceResult = DbUtil.executeQuery((Context)ctx, (String)centralBalanceSQL);
                this.processSaleReturnInnerDealPrice(ctx, (ResultSet)centralBalanceResult, false);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
    }

    @Override
    protected void _clearInnerDealPrice(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        StringBuffer str = new StringBuffer();
        String params = StringUtil.getKeyIdList((Object[])pks);
        str.append(" delete from T_SD_SaleReturnInnerDealPrice where FSaleRetrunId in (").append(params).append(")");
        DbUtil.execute((Context)ctx, (String)str.toString());
    }

    @Override
    protected Map _isPricePolicyPriceExist(Context ctx, IObjectValue objectValue) throws BOSException, EASBizException {
        return this.processPolicyPrice(ctx, objectValue);
    }

    private Map processPolicyPrice(Context ctx, IObjectValue objectValue) throws BOSException, EASBizException {
        HashMap<String, String> retMap;
        block9: {
            IPriceProvider iProvider;
            HashMap<String, MaterialInfo> map;
            CustomerCollection customerColl;
            ICustomer icus;
            String companyID;
            boolean isCentralBalance;
            SaleReturnsInfo saleReturnsInfo;
            CustomerInfo customerInfo;
            block8: {
                retMap = new HashMap<String, String>();
                customerInfo = null;
                CustomerInfo balanceCustomerInfo = null;
                saleReturnsInfo = (SaleReturnsInfo)objectValue;
                isCentralBalance = saleReturnsInfo.isIsCentralBalance();
                companyID = null;
                icus = CustomerFactory.getLocalInstance((Context)ctx);
                customerColl = null;
                SaleReturnsEntryCollection saleReturnEntryCollection = saleReturnsInfo.getEntries();
                Object[] repks = new ObjectUuidPK[saleReturnEntryCollection.size()];
                int n = saleReturnEntryCollection.size();
                for (int i = 0; i < n; ++i) {
                    repks[i] = new ObjectUuidPK(saleReturnEntryCollection.get(i).getMaterial().getId().toString());
                }
                CoreBaseCollection coreBaseCollection = MaterialFactory.getLocalInstance((Context)ctx).getCollection(" where id in  (" + StringUtil.getKeyIdList((Object[])repks) + ")");
                map = new HashMap<String, MaterialInfo>();
                for (int i = 0; i < coreBaseCollection.size(); ++i) {
                    MaterialInfo materialInfo = (MaterialInfo)coreBaseCollection.get(i);
                    if (materialInfo == null) continue;
                    map.put(materialInfo.getId().toString(), materialInfo);
                }
                if (!isCentralBalance || !saleReturnsInfo.isIsSquareBalance()) break block8;
                customerColl = icus.getCustomerCollection("select id,number where internalCompany.id = '" + saleReturnsInfo.getBalanceCompanyOrgUnit().getId().toString() + "'");
                if (customerColl.isEmpty()) {
                    return retMap;
                }
                balanceCustomerInfo = customerColl.get(0);
                customerColl = icus.getCustomerCollection("select id,number where internalCompany.id = '" + saleReturnsInfo.getCompanyOrgUnit().getId().toString() + "'");
                if (customerColl.isEmpty()) {
                    return retMap;
                }
                customerInfo = customerColl.get(0);
                PriceCondition priceCondition = new PriceCondition();
                iProvider = PriceProviderFactory.getLocalInstance((Context)ctx);
                Calendar cal = Calendar.getInstance();
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                priceCondition.setSaleOrg(saleReturnsInfo.getSaleOrgUnit());
                priceCondition.setCurrencyInfo(saleReturnsInfo.getCurrency());
                priceCondition.setCurDate((Date)ts);
                priceCondition.setPriceTypeID("00000000-0000-0000-0000-0000000000036A61CE8D");
                SaleReturnsEntryCollection entryColl = saleReturnsInfo.getEntries();
                String issueToBalance = ResourceBase.getString((String)"com.kingdee.eas.scm.common.SDSMResource", (String)"IssueToBalance", (Locale)ctx.getLocale());
                String balanceToSale = ResourceBase.getString((String)"com.kingdee.eas.scm.common.SDSMResource", (String)"BalanceToSale", (Locale)ctx.getLocale());
                int n2 = entryColl.size();
                for (int i = 0; i < n2; ++i) {
                    String msgStr;
                    String keyStr;
                    MaterialInfo materialInfo;
                    SaleReturnsEntryInfo saleReturnsEntryInfo = entryColl.get(i);
                    if (!saleReturnsEntryInfo.isIsBetweenCompanySend()) continue;
                    priceCondition.setMaterialInfo(saleReturnsEntryInfo.getMaterial());
                    priceCondition.setMeasureUnit(saleReturnsEntryInfo.getUnit().getId().toString());
                    priceCondition.setCustomerInfo(balanceCustomerInfo);
                    priceCondition.setCompanyOrg(saleReturnsEntryInfo.getCompanyOrgUnit());
                    priceCondition.setOrderQty(saleReturnsEntryInfo.getQty());
                    priceCondition.setAssiProperty(saleReturnsEntryInfo.getAssistProperty());
                    List[] priceList = iProvider.getPrices(new PriceCondition[]{priceCondition});
                    if ((priceList == null || priceList.length < 1 || priceList[0] == null || priceList[0].size() < 1) && map.containsKey(saleReturnsEntryInfo.getMaterial().getId().toString())) {
                        materialInfo = (MaterialInfo)map.get(saleReturnsEntryInfo.getMaterial().getId().toString());
                        keyStr = "number_" + i + saleReturnsEntryInfo.getCompanyOrgUnit().getId().toString();
                        msgStr = issueToBalance + materialInfo.getNumber() + "," + materialInfo.getName();
                        retMap.put(keyStr, msgStr);
                    }
                    priceCondition.setCustomerInfo(customerInfo);
                    priceCondition.setCompanyOrg(saleReturnsInfo.getBalanceCompanyOrgUnit());
                    priceList = iProvider.getPrices(new PriceCondition[]{priceCondition});
                    if (priceList != null && priceList.length >= 1 && priceList[0] != null && priceList[0].size() >= 1 || !map.containsKey(saleReturnsEntryInfo.getMaterial().getId().toString())) continue;
                    materialInfo = (MaterialInfo)map.get(saleReturnsEntryInfo.getMaterial().getId().toString());
                    keyStr = "number_" + i + saleReturnsInfo.getBalanceCompanyOrgUnit().getId().toString();
                    msgStr = balanceToSale + materialInfo.getNumber() + "," + materialInfo.getName();
                    retMap.put(keyStr, msgStr);
                }
                break block9;
            }
            if (!isCentralBalance) break block9;
            companyID = saleReturnsInfo.getCompanyOrgUnit().getId().toString();
            customerColl = icus.getCustomerCollection("select id,number where internalCompany.id = '" + companyID + "'");
            if (customerColl.isEmpty()) {
                return retMap;
            }
            customerInfo = customerColl.get(0);
            PriceCondition priceCondition = new PriceCondition();
            iProvider = PriceProviderFactory.getLocalInstance((Context)ctx);
            Calendar cal = Calendar.getInstance();
            Timestamp ts = new Timestamp(cal.getTimeInMillis());
            priceCondition.setCustomerInfo(customerInfo);
            priceCondition.setSaleOrg(saleReturnsInfo.getSaleOrgUnit());
            priceCondition.setCurrencyInfo(saleReturnsInfo.getCurrency());
            priceCondition.setCurDate((Date)ts);
            priceCondition.setPriceTypeID("00000000-0000-0000-0000-0000000000036A61CE8D");
            SaleReturnsEntryCollection entryColl = saleReturnsInfo.getEntries();
            int n = entryColl.size();
            for (int i = 0; i < n; ++i) {
                SaleReturnsEntryInfo saleReturnsEntryInfo = entryColl.get(i);
                if (!saleReturnsEntryInfo.isIsBetweenCompanySend()) continue;
                priceCondition.setMaterialInfo(saleReturnsEntryInfo.getMaterial());
                priceCondition.setMeasureUnit(saleReturnsEntryInfo.getUnit().getId().toString());
                priceCondition.setCompanyOrg(saleReturnsEntryInfo.getCompanyOrgUnit());
                priceCondition.setOrderQty(saleReturnsEntryInfo.getQty());
                priceCondition.setAssiProperty(saleReturnsEntryInfo.getAssistProperty());
                List[] priceList = iProvider.getPrices(new PriceCondition[]{priceCondition});
                if (priceList != null && priceList.length >= 1 && priceList[0] != null && priceList[0].size() >= 1 || !map.containsKey(saleReturnsEntryInfo.getMaterial().getId().toString())) continue;
                MaterialInfo materialInfo = (MaterialInfo)map.get(saleReturnsEntryInfo.getMaterial().getId().toString());
                String keyStr = "number_" + i;
                String msgStr = materialInfo.getNumber() + "," + materialInfo.getName();
                retMap.put(keyStr, msgStr);
            }
        }
        return retMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processSaleReturnInnerDealPrice(Context ctx, ResultSet result, boolean flag) throws BOSException, EASBizException {
        Connection con = null;
        Statement batchStatement = null;
        Statement paramStatement = null;
        try {
            con = this.getConnection(ctx);
            batchStatement = con.createStatement();
            paramStatement = con.createStatement();
            CustomerInfo customerInfo = new CustomerInfo();
            MaterialInfo materialInfo = new MaterialInfo();
            CurrencyInfo currencyInfo = new CurrencyInfo();
            CompanyOrgUnitInfo companyOrgInfo = new CompanyOrgUnitInfo();
            MeasureUnitInfo baseUnitInfo = new MeasureUnitInfo();
            SaleOrgUnitInfo saleOrgInfo = new SaleOrgUnitInfo();
            PriceCondition priceCondition = new PriceCondition();
            IPriceProvider iProvider = PriceProviderFactory.getLocalInstance((Context)ctx);
            IPriceParam iPriceParam = PriceParamFactory.getLocalInstance((Context)ctx);
            Calendar cal = Calendar.getInstance();
            Timestamp ts = new Timestamp(cal.getTimeInMillis());
            StringBuffer insertStr = new StringBuffer();
            BigDecimal HUNDRED_NUM = new BigDecimal("100");
            BigDecimal ONE_NUM = new BigDecimal("1.0");
            BigDecimal DEFAULT_NUM = new BigDecimal("0.0");
            boolean isControlSaleInnerPrice = false;
            int resultCount = 0;
            while (result.next()) {
                block52: {
                    BigDecimal price;
                    BigDecimal actualPrice;
                    BigDecimal actualTaxPrice;
                    BigDecimal taxrate;
                    BigDecimal discountValue;
                    BigDecimal dPriceValue;
                    block53: {
                        String sourceBillTypeID;
                        if (!flag && !StringUtil.isEmpty((String)(sourceBillTypeID = result.getString("sourcebilltypeid"))) && "510b6503-0105-1000-e000-0113c0a812fd463ED552".equalsIgnoreCase(sourceBillTypeID)) {
                            this.fatchSourceEntryInnerDealPrice(ctx, result);
                            continue;
                        }
                        int precision = result.getInt("priceprecision");
                        customerInfo.setId(BOSUuid.read((String)result.getString("customerid")));
                        priceCondition.setCustomerInfo(customerInfo);
                        materialInfo.setId(BOSUuid.read((String)result.getString("materialid")));
                        baseUnitInfo.setId(BOSUuid.read((String)result.getString("baseUnitID")));
                        materialInfo.setBaseUnit(baseUnitInfo);
                        priceCondition.setMaterialInfo(materialInfo);
                        priceCondition.setMeasureUnit(result.getString("unitid"));
                        companyOrgInfo.setId(BOSUuid.read((String)result.getString("companyOrgUntiID")));
                        priceCondition.setCompanyOrg(companyOrgInfo);
                        saleOrgInfo.setId(BOSUuid.read((String)result.getString("saleOrgUntiID")));
                        priceCondition.setSaleOrg(saleOrgInfo);
                        priceCondition.setOrderQty(result.getBigDecimal("qty"));
                        currencyInfo.setId(BOSUuid.read((String)result.getString("currencyid")));
                        priceCondition.setCurrencyInfo(currencyInfo);
                        priceCondition.setCurDate(result.getDate("bizDate") != null ? result.getDate("bizDate") : ts);
                        priceCondition.setPriceTypeID("00000000-0000-0000-0000-0000000000036A61CE8D");
                        if (!StringUtils.isEmpty((String)result.getString("assistProperyID"))) {
                            AsstAttrValueInfo asstAttrValueInfo = new AsstAttrValueInfo();
                            asstAttrValueInfo.setId(BOSUuid.read((String)result.getString("assistProperyID")));
                            priceCondition.setAssiProperty(asstAttrValueInfo);
                        }
                        List[] priceLists = iProvider.getPrices(new PriceCondition[]{priceCondition});
                        insertStr.delete(0, insertStr.length());
                        insertStr.append(" insert T_SD_SaleReturnInnerDealPrice(FID,FSaleRetrunID,FSaleRetrunEntryID,FCompanyOrgUnitID,FPrice,FDiscountMode,FDiscount,FActualPrice ,FTaxRate,FTaxPrice,FActualTaxPrice)");
                        dPriceValue = DEFAULT_NUM.setScale(precision, 4);
                        discountValue = DEFAULT_NUM.setScale(precision, 4);
                        taxrate = DEFAULT_NUM.setScale(precision, 4);
                        actualTaxPrice = DEFAULT_NUM.setScale(precision, 4);
                        actualPrice = DEFAULT_NUM.setScale(precision, 4);
                        price = DEFAULT_NUM.setScale(precision, 4);
                        BigDecimal cheapRate = DEFAULT_NUM.setScale(precision, 4);
                        insertStr.append(" values(newbosid('").append("21AFFF6B'),'" + result.getString("id") + "','" + result.getString("entryid") + "'");
                        if (flag) {
                            insertStr.append(",'" + result.getString("companyOrgUntiID") + "'");
                        } else {
                            insertStr.append(",''");
                        }
                        if (resultCount == 0) {
                            ++resultCount;
                            PriceParamInfo parameter = iPriceParam.getParameterInfo(result.getString("saleOrgUntiID"));
                            isControlSaleInnerPrice = parameter.getBoolValue("PricePa023");
                        }
                        if (isControlSaleInnerPrice && !flag) {
                            int priceprecision = result.getInt("priceprecision");
                            discountValue = result.getBigDecimal("discount").unscaledValue().intValue() == 0 ? DEFAULT_NUM : result.getBigDecimal("discount");
                            taxrate = result.getBigDecimal("taxrate").unscaledValue().intValue() == 0 ? DEFAULT_NUM : result.getBigDecimal("taxrate");
                            cheapRate = result.getBigDecimal("secheaprate");
                            if (result.getBigDecimal("taxprice").unscaledValue().intValue() == 0) {
                                price = DEFAULT_NUM;
                            } else {
                                price = result.getBigDecimal("taxprice");
                                if (cheapRate.unscaledValue().intValue() != 0 && (price = price.multiply(ONE_NUM.subtract(cheapRate.divide(HUNDRED_NUM, priceprecision, 4)))).unscaledValue().intValue() == 0) {
                                    price = DEFAULT_NUM;
                                }
                            }
                            if (result.getBigDecimal("actualtaxprice").unscaledValue().intValue() == 0) {
                                actualTaxPrice = DEFAULT_NUM;
                            } else {
                                actualTaxPrice = result.getBigDecimal("actualtaxprice");
                                if (cheapRate.unscaledValue().intValue() != 0 && (actualTaxPrice = actualTaxPrice.multiply(ONE_NUM.subtract(cheapRate.divide(HUNDRED_NUM, priceprecision, 4)))).unscaledValue().intValue() == 0) {
                                    actualTaxPrice = DEFAULT_NUM;
                                }
                            }
                            dPriceValue = price.divide(ONE_NUM.add(taxrate.divide(HUNDRED_NUM, priceprecision, 4)), priceprecision, 4);
                            if (dPriceValue.unscaledValue().intValue() == 0) {
                                dPriceValue = DEFAULT_NUM;
                            }
                            actualPrice = dPriceValue;
                            insertStr.append("," + dPriceValue + "," + result.getInt("discounttype") + "," + discountValue).append("," + actualPrice + "," + taxrate + "," + price).append("," + actualTaxPrice + ")");
                            batchStatement.addBatch(insertStr.toString());
                            continue;
                        }
                        PriceParamInfo priceparamInfo = null;
                        SalePriceTO priceTo = null;
                        if (priceLists != null && priceLists.length > 0 && priceLists[0] != null) {
                            List priceToList = priceLists[0];
                            priceTo = (SalePriceTO)priceToList.get(0);
                        }
                        if (priceTo == null) break block53;
                        if (priceTo.priceType != null && priceTo.priceType.equals("basePrice")) {
                            BigDecimal transferRate;
                            OrgUnitCollection orgUnitCollection = SCMGroupServerUtils.getOrgsByRelation((Context)ctx, (OrgType)OrgType.Company, (OrgType)OrgType.Sale, (String)priceCondition.getCompanyOrg().getId().toString());
                            int c = orgUnitCollection.size();
                            for (int i = 0; i < c; ++i) {
                                String cuid = orgUnitCollection.get(i).getId().toString();
                                PriceParamInfo tempInfo = iPriceParam.getParameter(cuid);
                                if (!tempInfo.isStartPriceDiscountM()) continue;
                                priceparamInfo = tempInfo;
                                break;
                            }
                            BigDecimal bigDecimal = dPriceValue = priceTo.price != null ? priceTo.price : SCMConstant.BIGDECIMAL_ZERO;
                            if (dPriceValue.unscaledValue().intValue() == 0) {
                                dPriceValue = DEFAULT_NUM;
                            }
                            String discountMode = priceTo.discountMode != null ? String.valueOf(priceTo.discountMode) : "0";
                            BigDecimal bigDecimal2 = discountValue = priceTo.discountValue != null ? priceTo.discountValue : DEFAULT_NUM;
                            if (discountValue.unscaledValue().intValue() == 0) {
                                discountValue = DEFAULT_NUM;
                            }
                            if (result.getBigDecimal("taxrate").unscaledValue().intValue() != 0) {
                                taxrate = result.getBigDecimal("taxrate");
                            }
                            BigDecimal transferTaxRate = taxrate.divide(HUNDRED_NUM, 10, 4).add(ONE_NUM);
                            if (priceparamInfo != null && priceparamInfo.isContainTax()) {
                                price = dPriceValue.divide(transferTaxRate, dPriceValue.scale(), 4);
                                if (discountMode.equals("0")) {
                                    transferRate = HUNDRED_NUM.subtract(discountValue).divide(HUNDRED_NUM, 10, 4);
                                    actualPrice = price.multiply(transferRate).setScale(price.scale(), 4);
                                    actualTaxPrice = dPriceValue.multiply(transferRate).setScale(dPriceValue.scale(), 4);
                                } else if (discountMode.equals("1")) {
                                    actualPrice = price.subtract(discountValue.divide(transferTaxRate, price.scale(), 4));
                                    actualTaxPrice = dPriceValue.subtract(discountValue.divide(transferTaxRate, dPriceValue.scale(), 4));
                                } else {
                                    actualPrice = price;
                                    actualTaxPrice = dPriceValue;
                                }
                                insertStr.append("," + price + "," + discountMode + "," + discountValue).append("," + actualPrice + "," + taxrate + "," + dPriceValue).append("," + actualTaxPrice + ")");
                                break block52;
                            } else {
                                price = dPriceValue.multiply(transferTaxRate).setScale(dPriceValue.scale(), 4);
                                if (discountMode.equals("0")) {
                                    transferRate = HUNDRED_NUM.subtract(discountValue).divide(HUNDRED_NUM, 10, 4);
                                    actualPrice = dPriceValue.multiply(transferRate).setScale(dPriceValue.scale(), 4);
                                    actualTaxPrice = price.multiply(transferRate).setScale(price.scale(), 4);
                                } else if (discountMode.equals("1")) {
                                    actualPrice = dPriceValue.subtract(discountValue.divide(transferTaxRate, dPriceValue.scale(), 4));
                                    actualTaxPrice = price.subtract(discountValue.divide(transferTaxRate, price.scale(), 4));
                                } else {
                                    actualPrice = dPriceValue;
                                    actualTaxPrice = price;
                                }
                                insertStr.append("," + dPriceValue + "," + discountMode + "," + discountValue).append("," + actualPrice + "," + taxrate + "," + price).append("," + actualTaxPrice + ")");
                            }
                            break block52;
                        } else {
                            BigDecimal transferRate2;
                            priceparamInfo = iPriceParam.getParameter(priceTo.saleOrgUniID);
                            BigDecimal bigDecimal = dPriceValue = priceTo.price != null ? priceTo.price : SCMConstant.BIGDECIMAL_ZERO;
                            if (dPriceValue.unscaledValue().intValue() == 0) {
                                dPriceValue = DEFAULT_NUM;
                            }
                            String discountMode = String.valueOf(priceTo.discountMode);
                            BigDecimal bigDecimal3 = discountValue = priceTo.discountValue != null ? priceTo.discountValue : DEFAULT_NUM;
                            if (discountValue.unscaledValue().intValue() == 0) {
                                discountValue = DEFAULT_NUM;
                            }
                            if (result.getBigDecimal("taxrate").unscaledValue().intValue() != 0) {
                                taxrate = result.getBigDecimal("taxrate");
                            }
                            BigDecimal transferTaxRate = taxrate.divide(HUNDRED_NUM, 10, 4).add(ONE_NUM);
                            if (priceparamInfo.isContainTax()) {
                                price = dPriceValue.divide(transferTaxRate, dPriceValue.scale(), 4);
                                if (discountMode.equals("0")) {
                                    transferRate2 = HUNDRED_NUM.subtract(discountValue).divide(HUNDRED_NUM, 10, 4);
                                    actualPrice = price.multiply(transferRate2).setScale(price.scale(), 4);
                                    actualTaxPrice = dPriceValue.multiply(transferRate2).setScale(dPriceValue.scale(), 4);
                                } else if (discountMode.equals("1")) {
                                    actualPrice = price.subtract(discountValue.divide(transferTaxRate, price.scale(), 4));
                                    actualTaxPrice = dPriceValue.subtract(discountValue.divide(transferTaxRate, dPriceValue.scale(), 4));
                                } else {
                                    actualPrice = price;
                                    actualTaxPrice = dPriceValue;
                                }
                                insertStr.append("," + price + "," + discountMode + "," + discountValue).append("," + actualPrice + "," + taxrate + "," + dPriceValue).append("," + actualTaxPrice + ")");
                                break block52;
                            } else {
                                price = dPriceValue.multiply(transferTaxRate).setScale(dPriceValue.scale(), 4);
                                if (discountMode.equals("0")) {
                                    transferRate2 = HUNDRED_NUM.subtract(discountValue).divide(HUNDRED_NUM, 10, 4);
                                    actualPrice = dPriceValue.multiply(transferRate2).setScale(dPriceValue.scale(), 4);
                                    actualTaxPrice = price.multiply(transferRate2).setScale(price.scale(), 4);
                                } else if (discountMode.equals("1")) {
                                    actualPrice = dPriceValue.subtract(discountValue.divide(transferTaxRate, dPriceValue.scale(), 4));
                                    actualTaxPrice = price.subtract(discountValue.divide(transferTaxRate, price.scale(), 4));
                                } else {
                                    actualPrice = dPriceValue;
                                    actualTaxPrice = price;
                                }
                                insertStr.append("," + dPriceValue + "," + discountMode + "," + discountValue).append("," + actualPrice + "," + taxrate + "," + price).append("," + actualTaxPrice + ")");
                            }
                        }
                        break block52;
                    }
                    dPriceValue = result.getBigDecimal("price").unscaledValue().intValue() == 0 ? DEFAULT_NUM : result.getBigDecimal("price");
                    discountValue = result.getBigDecimal("discount").unscaledValue().intValue() == 0 ? DEFAULT_NUM : result.getBigDecimal("discount");
                    actualPrice = result.getBigDecimal("actualprice").unscaledValue().intValue() == 0 ? DEFAULT_NUM : result.getBigDecimal("actualprice");
                    taxrate = result.getBigDecimal("taxrate").unscaledValue().intValue() == 0 ? DEFAULT_NUM : result.getBigDecimal("taxrate");
                    price = result.getBigDecimal("taxprice").unscaledValue().intValue() == 0 ? DEFAULT_NUM : result.getBigDecimal("taxprice");
                    actualTaxPrice = result.getBigDecimal("actualtaxprice").unscaledValue().intValue() == 0 ? DEFAULT_NUM : result.getBigDecimal("actualtaxprice");
                    insertStr.append("," + dPriceValue + "," + result.getInt("discounttype") + "," + discountValue).append("," + actualPrice + "," + taxrate + "," + price).append("," + actualTaxPrice + ")");
                }
                batchStatement.addBatch(insertStr.toString());
            }
            batchStatement.executeBatch();
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
                catch (PricePolicyException e) {
                    throw new BOSException((Throwable)e);
                }
                catch (BOSException e) {
                    throw new BOSException((Throwable)e);
                }
                catch (PriceParamException e) {
                    throw new BOSException((Throwable)e);
                }
                catch (EASBizException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)con);
                SQLUtils.cleanup(paramStatement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        SQLUtils.cleanup((Statement)paramStatement, (Connection)con);
    }

    private void fatchSourceEntryInnerDealPrice(Context ctx, ResultSet result) throws BOSException, EASBizException {
        BigDecimal DEFAULT_NUM = new BigDecimal("0");
        try {
            String sourceBillEntryID = result.getString("sourcebillentryid");
            String sourceBillID = result.getString("sourcebillid");
            ISaleInnerDealPrice iPriceFactory = SaleInnerDealPriceFactory.getLocalInstance(ctx);
            SaleInnerDealPriceInfo saleInnerDealPriceInfo = iPriceFactory.getInnerDealPrice(sourceBillID, sourceBillEntryID);
            BigDecimal price = saleInnerDealPriceInfo.getPrice();
            BigDecimal discount = saleInnerDealPriceInfo.getDiscount();
            BigDecimal actualPrice = saleInnerDealPriceInfo.getActualPrice();
            BigDecimal taxRate = saleInnerDealPriceInfo.getTaxRate();
            BigDecimal taxPrice = saleInnerDealPriceInfo.getTaxPrice();
            BigDecimal actualTaxPrice = saleInnerDealPriceInfo.getActualTaxPrice();
            int discountMode = saleInnerDealPriceInfo.getDiscountMode().getValue();
            if (price.compareTo(DEFAULT_NUM) == 0) {
                price = DEFAULT_NUM;
            }
            if (discount.compareTo(DEFAULT_NUM) == 0) {
                discount = DEFAULT_NUM;
            }
            if (actualPrice.compareTo(DEFAULT_NUM) == 0) {
                actualPrice = DEFAULT_NUM;
            }
            if (taxRate.compareTo(DEFAULT_NUM) == 0) {
                taxRate = DEFAULT_NUM;
            }
            if (taxPrice.compareTo(DEFAULT_NUM) == 0) {
                taxPrice = DEFAULT_NUM;
            }
            if (actualTaxPrice.compareTo(DEFAULT_NUM) == 0) {
                actualTaxPrice = DEFAULT_NUM;
            }
            StringBuffer insertStr = new StringBuffer();
            insertStr.append(" insert T_SD_SaleReturnInnerDealPrice(FID,FSaleRetrunID,FSaleRetrunEntryID,FCompanyOrgUnitID,FPrice,FDiscountMode,FDiscount,FActualPrice ,FTaxRate,FTaxPrice,FActualTaxPrice)");
            insertStr.append(" values(newbosid('").append("21AFFF6B'),'" + result.getString("id") + "','" + result.getString("entryid") + "',");
            insertStr.append("'',");
            insertStr.append(price + "," + discountMode + "," + discount + "," + actualPrice + "," + taxRate + "," + taxPrice + "," + actualTaxPrice).append(")");
            DbUtil.execute((Context)ctx, (String)insertStr.toString());
        }
        catch (SQLException e) {
            throw new BOSException("sql Execute Error :", (Throwable)e);
        }
    }
}

