/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBizType;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceProvider;
import com.kingdee.eas.basedata.scm.sd.sale.PriceCondition;
import com.kingdee.eas.basedata.scm.sd.sale.PriceProviderFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainExecutorFactory;
import com.kingdee.eas.dynbusiness.adv.chain.app.IBusinessChainExecutor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ParamEntryExecuteContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMGroupFacade;
import com.kingdee.eas.scm.common.ISMSDBillConfig;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.SMSDBillConfigCollection;
import com.kingdee.eas.scm.common.SMSDBillConfigFactory;
import com.kingdee.eas.scm.common.SMSDBillConfigInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.loadmass.SCMBizDataVO;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.loadmass.SaleOrderDataVO;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.SCMCommonUtil;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.credit.CreditBalanceUpdateFacadeFactory;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.im.inv.ISaleIssueEntry;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.sd.sale.ISaleOrderEntry;
import com.kingdee.eas.scm.sd.sale.OrderException;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsException;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import com.kingdee.eas.scm.sd.sale.app.AbstractSaleReturnsControllerBean;
import com.kingdee.eas.scm.sm.pur.calculate.SaleContractCal;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.util.BaseException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SaleReturnsControllerBean
extends AbstractSaleReturnsControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.SaleReturnsControllerBean");

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SaleReturnsInfo info = this.getSaleReturnsInfo(ctx, pk, SCMSelectorFactory.getSaleReturnsSelector((boolean)true));
        this.passAudit(ctx, pk, (CoreBillBaseInfo)info);
    }

    protected void updateOrder(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        BigDecimal zero = new BigDecimal("0.00");
        SaleReturnsInfo returnInfo = (SaleReturnsInfo)info;
        SaleReturnsEntryCollection s = returnInfo.getEntries();
        ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance(ctx);
        int size = s.size();
        for (int i = 0; i < size; ++i) {
            SaleReturnsEntryInfo sEntryInfo = s.get(i);
            if (sEntryInfo.getSourceBillEntryId() == null) continue;
            ObjectStringPK orderEntryPK = new ObjectStringPK(sEntryInfo.getSourceBillEntryId().toString());
            SaleOrderEntryInfo orderEntryInfo = iSaleOrderEntry.getSaleOrderEntryInfo((IObjectPK)orderEntryPK);
            BigDecimal qty = orderEntryInfo.getTotalReturnedQty();
            BigDecimal baseQty = orderEntryInfo.getTotalReBaseQty();
            BigDecimal returnQty = sEntryInfo.getQty();
            if (!sEntryInfo.getUnit().getId().toString().equals(orderEntryInfo.getUnit().getId().toString())) {
                returnQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)orderEntryInfo.getMaterial().getId().toString(), (String)orderEntryInfo.getBaseUnit().getId().toString(), (BigDecimal)sEntryInfo.getBaseQty(), (String)orderEntryInfo.getUnit().getId().toString());
            }
            if (qty.compareTo(zero) == 0) {
                orderEntryInfo.setTotalReturnedQty(returnQty);
                orderEntryInfo.setTotalReBaseQty(sEntryInfo.getBaseQty());
                orderEntryInfo.setTotalUnReturnBaseQty(orderEntryInfo.getQty().subtract(returnQty));
            } else {
                orderEntryInfo.setTotalReturnedQty(qty.add(returnQty));
                orderEntryInfo.setTotalReBaseQty(baseQty.add(sEntryInfo.getBaseQty()));
                orderEntryInfo.setTotalUnReturnBaseQty(orderEntryInfo.getQty().subtract(returnQty));
            }
            iSaleOrderEntry.update((IObjectPK)orderEntryPK, (CoreBaseInfo)orderEntryInfo);
        }
    }

    protected void updateSaleIssueToOrder(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        BigDecimal zero = new BigDecimal("0.00");
        SaleReturnsInfo returnInfo = (SaleReturnsInfo)info;
        SaleReturnsEntryCollection s = returnInfo.getEntries();
        ISaleIssueEntry iIssueEntry = SaleIssueEntryFactory.getLocalInstance((Context)ctx);
        ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance(ctx);
        CoreBaseCollection saleIEntryColl = new CoreBaseCollection();
        CoreBaseCollection saleOEntryColl = new CoreBaseCollection();
        int size = s.size();
        for (int i = 0; i < size; ++i) {
            SaleReturnsEntryInfo sEntryInfo = s.get(i);
            if (sEntryInfo.getSourceBillEntryId() == null) continue;
            BigDecimal returnQty = zero;
            ObjectStringPK issueEntryPK = new ObjectStringPK(sEntryInfo.getSourceBillEntryId().toString());
            SaleIssueEntryInfo issueEntryInfo = iIssueEntry.getSaleIssueEntryInfo((IObjectPK)issueEntryPK);
            if (issueEntryInfo.getSourceBillType() != null && issueEntryInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-0113c0a812fd463ED552")) {
                ObjectStringPK orderEntryPK = new ObjectStringPK(issueEntryInfo.getSaleOrderEntry());
                SaleOrderEntryInfo orderEntryInfo = iSaleOrderEntry.getSaleOrderEntryInfo((IObjectPK)orderEntryPK);
                BigDecimal qty = orderEntryInfo.getTotalReturnedQty();
                BigDecimal baseQty = orderEntryInfo.getTotalReBaseQty();
                returnQty = sEntryInfo.getQty();
                if (!sEntryInfo.getUnit().getId().toString().equals(orderEntryInfo.getUnit().getId().toString())) {
                    returnQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)orderEntryInfo.getMaterial().getId().toString(), (String)orderEntryInfo.getBaseUnit().getId().toString(), (BigDecimal)sEntryInfo.getBaseQty(), (String)orderEntryInfo.getUnit().getId().toString());
                }
                if (qty.compareTo(zero) == 0) {
                    orderEntryInfo.setTotalReturnedQty(returnQty);
                    orderEntryInfo.setTotalReBaseQty(sEntryInfo.getBaseQty());
                } else {
                    orderEntryInfo.setTotalReturnedQty(qty.add(returnQty));
                    orderEntryInfo.setTotalReBaseQty(baseQty.add(sEntryInfo.getBaseQty()));
                }
                saleOEntryColl.add((CoreBaseInfo)orderEntryInfo);
            }
            returnQty = sEntryInfo.getQty();
            if (!issueEntryInfo.getUnit().getId().toString().equals(sEntryInfo.getUnit().getId().toString())) {
                returnQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)issueEntryInfo.getMaterial().getId().toString(), (String)issueEntryInfo.getBaseUnit().getId().toString(), (BigDecimal)sEntryInfo.getBaseQty(), (String)issueEntryInfo.getUnit().getId().toString());
            }
            issueEntryInfo.setReturnsQty(issueEntryInfo.getReturnsQty().add(returnQty));
            issueEntryInfo.setUnReturnedBaseQty((issueEntryInfo.getUnReturnedBaseQty() == null ? issueEntryInfo.getBaseQty() : issueEntryInfo.getUnReturnedBaseQty()).subtract(sEntryInfo.getBaseQty()).abs());
            saleIEntryColl.add((CoreBaseInfo)issueEntryInfo);
        }
        iSaleOrderEntry.updateBatchData(saleOEntryColl);
        iIssueEntry.updateBatchData(saleIEntryColl);
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SaleReturnsInfo info = (SaleReturnsInfo)this.getValue(ctx, pk);
        if (!info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new SaleReturnsException(SaleReturnsException.STATECANNOTCANCEL);
        }
        info.setBaseStatus(BillBaseStatusEnum.DELETED);
        this.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SaleReturnsInfo info = (SaleReturnsInfo)this.getValue(ctx, pk);
        if (info.getBaseStatus().equals((Object)BillBaseStatusEnum.DELETED) || info.getBaseStatus().equals((Object)BillBaseStatusEnum.BLOCKED)) {
            throw new SaleReturnsException(SaleReturnsException.CANNOT_DELETED);
        }
        this.clearInnerDealPrice(ctx, pk);
        if (info.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(new Object[]{pk}, CreditOperationEnum.DELETE);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _close(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SaleReturnsInfo info = (SaleReturnsInfo)this.getValue(ctx, pk);
        if (!info.getBaseStatus().equals((Object)BillBaseStatusEnum.BLOCKED) && !info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new SaleReturnsException(SaleReturnsException.STATECANNOTCLOSE);
        }
        info.setBaseStatus(BillBaseStatusEnum.CLOSED);
        this.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _freeze(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        SaleReturnsInfo info = (SaleReturnsInfo)model;
        if (!info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new SaleReturnsException(SaleReturnsException.STATECANNOTFREEZELINE);
        }
        info.setBaseStatus(BillBaseStatusEnum.BLOCKED);
        this.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _unfreeze(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        SaleReturnsInfo info = (SaleReturnsInfo)model;
        if (!info.getBaseStatus().equals((Object)BillBaseStatusEnum.BLOCKED)) {
            throw new SaleReturnsException(SaleReturnsException.STATECANNOTUNFREEZELINE);
        }
        info.setBaseStatus(BillBaseStatusEnum.AUDITED);
        this.update(ctx, pk, (CoreBaseInfo)info);
    }

    public void _reverseSave(Context ctx, IObjectPK pk, CoreBillBaseInfo model) throws BOSException, EASBizException {
        SaleReturnsInfo retInfo = (SaleReturnsInfo)model;
        SaleReturnsEntryCollection col = retInfo.getEntries();
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            SaleReturnsEntryInfo info = col.get(i);
            if (!info.getReturnsQty().equals(info.getQty())) continue;
            info.setBaseStatus(EntryBaseStatusEnum.CLOSED);
        }
        super._reverseSave(ctx, pk, (IObjectValue)model);
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return new CompanyOrgUnitInfo();
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.submitWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSubmitRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.saveWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSaveRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    @Override
    protected void _freeze(Context ctx, IObjectPK model) throws BOSException, EASBizException {
        SaleReturnsInfo info = (SaleReturnsInfo)this.getValue(ctx, model);
        if (!info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new SaleReturnsException(SaleReturnsException.STATECANNOTFREEZELINE);
        }
        info.setBaseStatus(BillBaseStatusEnum.BLOCKED);
        this.update(ctx, model, (CoreBaseInfo)info);
    }

    @Override
    protected void _unfreeze(Context ctx, IObjectPK model) throws BOSException, EASBizException {
        SaleReturnsInfo info = (SaleReturnsInfo)this.getValue(ctx, model);
        if (!info.getBaseStatus().equals((Object)BillBaseStatusEnum.BLOCKED)) {
            throw new SaleReturnsException(SaleReturnsException.STATECANNOTUNFREEZELINE);
        }
        info.setBaseStatus(BillBaseStatusEnum.AUDITED);
        this.update(ctx, model, (CoreBaseInfo)info);
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK pk, IObjectValue reasonInfo) throws BOSException, EASBizException {
        if (pk == null || reasonInfo == null) {
            return;
        }
        ReasonCodeInfo rInfo = (ReasonCodeInfo)reasonInfo;
        this.cancelBill(ctx, pk, rInfo.getName());
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK pk, String reason) throws BOSException, EASBizException {
        this.cancelBill(ctx, pk, reason);
    }

    protected void cancelBill(Context ctx, IObjectPK pk, String reason) throws BOSException, EASBizException {
        SaleReturnsEntryCollection entryCol;
        SaleReturnsInfo info = null;
        if (pk == null || reason == null) {
            return;
        }
        String rInfo = reason;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.baseStatus"));
        sic.add(new SelectorItemInfo("entries.reason"));
        String tableName = "T_SD_SaleReturnsEntry";
        boolean isHasFlow = false;
        if (SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)ctx, (String)tableName, (String)pk.toString())) {
            info = (SaleReturnsInfo)this.getValue(ctx, pk);
            isHasFlow = true;
        } else {
            info = (SaleReturnsInfo)this.getValue(ctx, pk, sic);
        }
        if (!info.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED) && !info.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED)) {
            throw new SaleReturnsException(SaleReturnsException.STATECANNOTCANCEL);
        }
        if (isHasFlow) {
            SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.CANCEL);
        }
        if ((entryCol = info.getEntries()) != null) {
            int size = entryCol.size();
            for (int j = 0; j < size; ++j) {
                SaleReturnsEntryInfo entryInfo = entryCol.get(j);
                entryInfo.setReason(rInfo);
                entryInfo.setBaseStatus(EntryBaseStatusEnum.DELETED);
            }
        }
        info.setBaseStatus(BillBaseStatusEnum.DELETED);
        CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(new Object[]{pk}, CreditOperationEnum.DISCARD);
        super.cancelWithLog(ctx, info);
        this.updatePartial(ctx, (CoreBaseInfo)info, sic);
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _cancelWithLog(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected String _getBizUnitOrgID(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SaleOrgUnitInfo unitInfo;
        if (model != null && (unitInfo = ((SaleReturnsInfo)model).getSaleOrgUnit()) != null && unitInfo.getId() != null) {
            return unitInfo.getId().toString();
        }
        return null;
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int cont = pks.length;
        for (int i = 0; i < cont; ++i) {
            this._unAudit(ctx, pks[i]);
        }
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        SaleReturnsInfo info = this.getSaleReturnsInfo(ctx, pk, SCMSelectorFactory.getSaleReturnsSelector((boolean)true));
        entries[0] = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info});
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    private void clearInnerDealPrice(Context ctx, IObjectPK pk) throws BOSException {
        Connection con = null;
        Statement statement = null;
        StringBuffer str = new StringBuffer();
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            str.append(" delete ").append(" T_SD_SaleReturnInnerDealPrice ").append(" where FSaleRetrunId ='").append(pk).append("'");
            statement.executeUpdate(str.toString());
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        this.checkBillStatusForBotp(ctx, collection, new String[]{SCMConstant.BOSTYPE_SALEISSUE}, true);
        ICurrency currency = CurrencyFactory.getLocalInstance((Context)ctx);
        ISCMGroupFacade scmGroupFacade = SCMGroupFacadeFactory.getLocalInstance((Context)ctx);
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            SaleReturnsInfo srInfo = (SaleReturnsInfo)collection.getObject(i);
            this.calByUnitSource(ctx, srInfo, (IObjectCollection)srInfo.getEntries());
            this.handleCompanyOrgUnit(ctx, srInfo);
            if (this.isBotpBill(srInfo)) {
                ObjectUuidPK pk;
                if (srInfo.getPaymentType() == null && srInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-0113c0a812fd463ED552")) {
                    throw new SaleReturnsException(SaleReturnsException.UNSET_PAYMENTTYPE);
                }
                if (srInfo.getReturnsCustomer() != null && srInfo.getReturnsCustomer().getNumber() == null) {
                    CustomerInfo customer = CustomerFactory.getLocalInstance((Context)ctx).getCustomerInfo((IObjectPK)new ObjectUuidPK(srInfo.getReturnsCustomer().getId()));
                    srInfo.setReturnsCustomer(customer);
                }
                if (srInfo.getBillType() == null) {
                    pk = new ObjectUuidPK("50957179-0105-1000-e008-8152c0a812fd463ED552");
                    BillTypeInfo billTypeInfo = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)pk);
                    srInfo.setBillType(billTypeInfo);
                }
                if (srInfo.getBizType() == null) {
                    pk = new ObjectUuidPK("d8e80652-0110-1000-e000-04c5c0a812202407435C");
                    BizTypeInfo bizTypeInfo = BizTypeFactory.getLocalInstance((Context)ctx).getBizTypeInfo((IObjectPK)pk);
                    srInfo.setBizType(bizTypeInfo);
                }
            }
            if (srInfo.getCurrency() != null) {
                CurrencyInfo currencyInfo = currency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(srInfo.getCurrency().getId()));
                srInfo.setCurrency(currencyInfo);
            }
            SCMBizDataVO paramScmBizDataVO = this.getParamSCMBizDataVO(ctx, srInfo);
            SCMBizDataVO resultScmBizDataVO = scmGroupFacade.loadSCMBizDataVO(paramScmBizDataVO);
            if (this.isBotpBill(srInfo) && srInfo.getAdminOrgUnit() == null) {
                AdminOrgUnitInfo adminOrgUnitInfo = this.getAdminOrgUnitByPerson(ctx, srInfo, resultScmBizDataVO);
                srInfo.setAdminOrgUnit(adminOrgUnitInfo);
            }
            Object warehsInfo = null;
            Object materialInfo = null;
            HashSet<String> idsSet = new HashSet<String>();
            IMaterialInventory imaterialInventory = MaterialInventoryFactory.getLocalInstance((Context)ctx);
            EntityViewInfo warehouseView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            for (int row = 0; row < srInfo.getEntries().size(); ++row) {
                idsSet.add(srInfo.getEntries().get(row).getMaterial().getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("Material.id", idsSet, CompareType.INCLUDE));
            warehouseView.getSelector().add(new SelectorItemInfo("Material.id"));
            warehouseView.getSelector().add(new SelectorItemInfo("defaultWarehouse.*"));
            warehouseView.getSelector().add(new SelectorItemInfo("orgUnit.id"));
            warehouseView.setFilter(filter);
            MaterialInventoryCollection collections = imaterialInventory.getMaterialInventoryCollection(warehouseView);
            for (int row = 0; row < srInfo.getEntries().size(); ++row) {
                if (srInfo.getEntries().get(row).getStorageOrgUnit() == null || srInfo.getEntries().get(row).getWarehouse() != null) continue;
                for (int j = 0; j < collections.size(); ++j) {
                    if (!srInfo.getEntries().get(row).getMaterial().getId().equals((Object)collections.get(j).getMaterial().getId()) || collections.get(j).getDefaultWarehouse() == null || !collections.get(j).getOrgUnit().getId().toString().equals(srInfo.getEntries().get(row).getStorageOrgUnit().getId().toString())) continue;
                    srInfo.getEntries().get(row).setWarehouse(collections.get(j).getDefaultWarehouse());
                }
            }
            this.reCalcAmount(ctx, srInfo, resultScmBizDataVO);
            this.handleEntries(ctx, srInfo);
        }
    }

    private void handleCompanyOrgUnit(Context ctx, SaleReturnsInfo info) throws EASBizException, BOSException {
        if (null == info || null != info.getCompanyOrgUnit()) {
            return;
        }
        if (null != info.getSaleOrgUnit()) {
            info.setCompanyOrgUnit(this.getCouBySou(ctx, info.getSaleOrgUnit().getId().toString()));
        }
    }

    public CompanyOrgUnitInfo getCouBySou(Context ctx, String souId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection coll = iOrgUnitRelation.getToUnit(souId, 2, 1);
        if (coll != null && coll.size() > 0) {
            company = (CompanyOrgUnitInfo)coll.get(0);
        }
        return company;
    }

    private void handleEntries(Context ctx, SaleReturnsInfo info) throws EASBizException, BOSException {
        boolean qtyUnctrl = this.takeConfigType(ctx, "com.kingdee.eas.scm.sd.sale.client.SaleReturnsEditUI", "isQtyUnctrl", false);
        int n = info.getEntries().size();
        for (int i = 0; i < n; ++i) {
            BigDecimal baseUnitQty;
            SaleReturnsEntryInfo saleReturnsEntryInfo = info.getEntries().get(i);
            if (saleReturnsEntryInfo.get("quantityUnCtrl") != null) continue;
            saleReturnsEntryInfo.setQuantityUnCtrl(qtyUnctrl);
            if (saleReturnsEntryInfo.getMaterial().getId() == null || (baseUnitQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)saleReturnsEntryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)saleReturnsEntryInfo.getUnit(), (MeasureUnitInfo)saleReturnsEntryInfo.getBaseUnit(), (BigDecimal)saleReturnsEntryInfo.getQty())) == null) continue;
            saleReturnsEntryInfo.setBaseQty(baseUnitQty);
        }
    }

    protected int getMaterialPrecision(Context ctx, String materialId) throws BOSException {
        int precision = 8;
        if (materialId == null || materialId.length() == 0) {
            return precision;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("pricePrecision"));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)materialId, CompareType.EQUALS));
        view.setFilter(filter);
        MaterialCollection collection = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
        if (collection.size() > 0) {
            precision = collection.get(0).getPricePrecision();
        }
        return precision;
    }

    protected AdminOrgUnitInfo getAdminOrgUnitByPerson(Context ctx, SaleReturnsInfo info, SCMBizDataVO resultScmBizDataVO) throws BOSException, EASBizException {
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        SaleOrgUnitInfo saleOrgUnifInfo = info.getSaleOrgUnit();
        if (saleOrgUnifInfo != null) {
            boolean isAdminOrgUnitByPerson = Boolean.valueOf(resultScmBizDataVO.getParametersMap().get("SALEORDER001").toString());
            if (isAdminOrgUnitByPerson) {
                if (info.getSalePerson() != null && info.getSalePerson().getId() != null) {
                    adminOrgUnitInfo = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(info.getSalePerson().getId());
                }
            } else {
                adminOrgUnitInfo = (AdminOrgUnitInfo)resultScmBizDataVO.getDefaultDelegatedOrg().get(OrgType.Admin);
            }
        }
        return adminOrgUnitInfo;
    }

    private boolean takeConfigType(Context ctx, String uiClassStr, String configTypeValue, boolean defaultValue) throws BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo billClassNameFilter = new FilterItemInfo("billClassName", (Object)uiClassStr, CompareType.EQUALS);
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        FilterItemInfo userIDFilter = new FilterItemInfo("userID", (Object)user.getId().toString(), CompareType.EQUALS);
        FilterItemInfo configTypeFilter = new FilterItemInfo("configType", (Object)configTypeValue, CompareType.EQUALS);
        filter.getFilterItems().add(billClassNameFilter);
        filter.getFilterItems().add(userIDFilter);
        filter.getFilterItems().add(configTypeFilter);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        ISMSDBillConfig iSMSDBillConfig = SMSDBillConfigFactory.getLocalInstance((Context)ctx);
        SMSDBillConfigCollection aSMSDBillConfigCollection = iSMSDBillConfig.getSMSDBillConfigCollection(ev);
        SMSDBillConfigInfo aSMSDBillConfig = null;
        if (aSMSDBillConfigCollection.size() > 0) {
            aSMSDBillConfig = aSMSDBillConfigCollection.get(0);
            return !aSMSDBillConfig.getConfigValue().toString().equals("0");
        }
        return defaultValue;
    }

    protected SCMBizDataVO getParamSCMBizDataVO(Context ctx, SaleReturnsInfo srInfo) {
        SCMBizDataVO scmBizDataVO = new SCMBizDataVO(this.getMainBizOrgType(), this.getMainBizOrgUnit(ctx, (CoreBillBaseInfo)srInfo), 0, this.getLoginUserInfo(ctx), null);
        scmBizDataVO.setBOSType(this.getBOSType().toString());
        scmBizDataVO.setParameters(new String[]{"SALEORDER001"});
        scmBizDataVO.setDelegatedOrgTypes(this.getDelegatedOrgTypes());
        SaleOrderDataVO scmEntryDataVO = new SaleOrderDataVO();
        scmEntryDataVO.setCurrencyInfo(srInfo.getCurrency());
        scmEntryDataVO.setIsLoadingCurrency(true);
        scmEntryDataVO.setMainOrg((OrgUnitInfo)srInfo.getSaleOrgUnit());
        scmEntryDataVO.setMainOrgType(OrgType.Sale);
        scmBizDataVO.setScmEntryDataVO((SCMEntryDataVO)scmEntryDataVO);
        this.initSCMBizDataVO(ctx, scmBizDataVO, srInfo.getEntries());
        return scmBizDataVO;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Sale;
    }

    protected HashSet getDelegatedOrgTypes() {
        HashSet<OrgType> delegateOrgTypeSet = new HashSet<OrgType>();
        delegateOrgTypeSet.add(OrgType.Admin);
        delegateOrgTypeSet.add(OrgType.Company);
        delegateOrgTypeSet.add(OrgType.Storage);
        return delegateOrgTypeSet;
    }

    protected void reCalcAmount(Context ctx, SaleReturnsInfo srInfo, SCMBizDataVO vo) throws BOSException, EASBizException {
        BigDecimal ZERO = new BigDecimal("0.00");
        BigDecimal HUNDRED = new BigDecimal("100.00");
        BigDecimal ONE = new BigDecimal("1.00");
        CurrencyInfo baseCurrencyInfo = vo.getBaseCurrInfo();
        CurrencyInfo currencyInfo = srInfo.getCurrency();
        BigDecimal exchangeRate = srInfo.getExchangeRate();
        ExchangeAuxInfo exchangeAuxInfo = vo.getScmEntryDataVO().getExchangeAuxInfo();
        boolean isContainsTax = srInfo.isIsInTax();
        int localScale = baseCurrencyInfo.getPrecision();
        int scale = 2;
        if (currencyInfo != null) {
            scale = currencyInfo.getPrecision();
        }
        BigDecimal totalAmount = ZERO;
        BigDecimal totalTax = ZERO;
        BigDecimal totalTaxAmount = ZERO;
        CompanyOrgUnitInfo companyOrg = null;
        OrgUnitCollection orgUnitCol = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(srInfo.getSaleOrgUnit().getId().toString(), 2, 1);
        if (orgUnitCol != null && orgUnitCol.size() > 0) {
            companyOrg = (CompanyOrgUnitInfo)orgUnitCol.get(0);
        }
        SaleReturnsEntryCollection sreCollection = srInfo.getEntries();
        if (currencyInfo != null) {
            if (baseCurrencyInfo.getId().equals((Object)currencyInfo.getId())) {
                srInfo.setExchangeRate(ONE);
                exchangeRate = ONE;
            } else {
                String sourceBillTypeID;
                String sourceBillID = sreCollection.get(0).getSourceBillId();
                ExchangeRateInfo newExRateInfo = this.getNewExchangeRate(ctx, exchangeRate, sourceBillID, sourceBillTypeID = srInfo.getSourceBillType().getId().toString(), companyOrg, currencyInfo, baseCurrencyInfo);
                if (newExRateInfo != null) {
                    srInfo.setExchangeRate(newExRateInfo.getConvertRate());
                    exchangeRate = newExRateInfo.getConvertRate();
                }
            }
        }
        int m = sreCollection.size();
        for (int j = 0; j < m; ++j) {
            SaleReturnsEntryInfo srEntryInfo = sreCollection.get(j);
            MaterialInfo materialInfo = srEntryInfo.getMaterial();
            if (materialInfo == null) continue;
            BigDecimal qty = SCMUtils.effectualNumeric((BigDecimal)srEntryInfo.getQty());
            BigDecimal price = SCMUtils.effectualNumeric((BigDecimal)srEntryInfo.getPrice());
            BigDecimal taxRate = SCMUtils.effectualNumeric((BigDecimal)srEntryInfo.getTaxRate());
            BigDecimal taxPrice = SCMUtils.effectualNumeric((BigDecimal)srEntryInfo.getTaxPrice());
            int priceScale = this.getMaterialPrecision(ctx, materialInfo.getId().toString());
            BigDecimal amount = ZERO;
            BigDecimal tax = ZERO;
            BigDecimal taxAmount = ZERO;
            BigDecimal localAmount = ZERO;
            BigDecimal localTax = ZERO;
            BigDecimal localTaxAmount = ZERO;
            if (isContainsTax || srInfo.getSourceBillType() != null && srInfo.getSourceBillType().getId() != null && srInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-0113c0a812fd463ED552")) {
                taxAmount = CalculateUtils.calAmount((BigDecimal)qty, (BigDecimal)taxPrice, (int)scale);
                tax = taxAmount.multiply(taxRate).divide(HUNDRED.add(taxRate), scale, 4);
                amount = taxAmount.subtract(tax);
                price = CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)priceScale);
                srEntryInfo.setPrice(price);
            } else {
                amount = CalculateUtils.calAmount((BigDecimal)qty, (BigDecimal)price, (int)scale);
                tax = CalculateUtils.calTax((BigDecimal)amount, (BigDecimal)taxRate, (int)scale);
                taxAmount = CalculateUtils.calTotalTaxAmount((BigDecimal)amount, (BigDecimal)tax, (int)scale);
                if (qty.compareTo(ZERO) != 0) {
                    taxPrice = taxAmount.divide(qty, priceScale, 4);
                }
                srEntryInfo.setTaxPrice(taxPrice);
            }
            localAmount = CalculateUtils.calcByExchangeRate((ExchangeAuxInfo)exchangeAuxInfo, (BigDecimal)exchangeRate, (BigDecimal)amount, (int)localScale);
            localTax = CalculateUtils.calcByExchangeRate((ExchangeAuxInfo)exchangeAuxInfo, (BigDecimal)exchangeRate, (BigDecimal)tax, (int)localScale);
            localTaxAmount = CalculateUtils.calcByExchangeRate((ExchangeAuxInfo)exchangeAuxInfo, (BigDecimal)exchangeRate, (BigDecimal)taxAmount, (int)localScale);
            totalAmount = totalAmount.add(amount);
            totalTax = totalTax.add(tax);
            totalTaxAmount = totalTaxAmount.add(taxAmount);
            srEntryInfo.setAmount(amount);
            srEntryInfo.setTax(tax);
            srEntryInfo.setTaxAmount(taxAmount);
            srEntryInfo.setRemainingQty(qty);
            srEntryInfo.setLocalAmount(localAmount);
            srEntryInfo.setLocalTax(localTax);
            srEntryInfo.setLocalTaxAmount(localTaxAmount);
        }
        srInfo.setTotalAmount(totalAmount);
        srInfo.setTotalTax(totalTax);
        srInfo.setTotalTaxAmount(totalTaxAmount);
    }

    protected String getBillTypeId() {
        return "50957179-0105-1000-e008-8152c0a812fd463ED552";
    }

    private String convertToString(Object[] objs) {
        if (objs == null || objs.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int count = objs.length;
        for (int i = 0; i < count; ++i) {
            if (objs[i] == null) continue;
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'");
            sb.append(objs[i].toString());
            sb.append("'");
        }
        return sb.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _isPricePolicyPriceExist(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        HashMap retMap = new HashMap();
        Connection con = null;
        Statement statement = null;
        ResultSet verifyResult = null;
        ResultSet centralBalanceResult = null;
        ResultSet squareBalanceResult1 = null;
        ResultSet squareBalanceResult2 = null;
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            StringBuffer sql = new StringBuffer();
            String params = this.convertToString(pks);
            sql.append("select sr.Fid from T_SD_SaleReturns sr ").append(" inner join T_SD_SaleReturnsEntry se on se.FParentID = sr.FID ").append(" where sr.FID in(").append(params).append(") and sr.FIsSquareBalance = 1 and sr.FIsCentralBalance = 1 and se.FIsBetweenCompanySend = 1 ");
            String verifySQL = sql.toString();
            sql.setLength(0);
            sql.append("select sr.fid id,sr.fsourcebilltypeid sourcebilltypeid,sr.fnumber number,se.fid entryid,sr.FBizDate bizDate,sr.FSaleOrgUnitID saleOrgUntiID,se.FCompanyOrgUnitID companyOrgUntiID,sr.FCurrencyID currencyid,se.FMaterialID materialid,material.fnumber materialNumber,material.FName_l2 materialName,se.FUnitID unitid,se.FBaseUnitID baseUnitID,se.FAssistPropertyID assistProperyID,cus.fid customerid,se.FQty qty,se.FTaxRate taxrate,se.FPrice price,-1 discounttype,0.0000 discount,se.FTaxRate actualprice,se.FTaxPrice actualtaxprice,se.FTaxPrice taxprice ,material.FPricePrecision priceprecision ").append("  from T_SD_SaleReturns sr ").append(" inner join T_SD_SaleReturnsEntry se on se.FParentID = sr.FID ").append(" inner join T_BD_Customer cus on cus.FInternalCompanyID = sr.FCompanyOrgUnitID  and cus.fusedstatus = 1").append(" inner join T_BD_Material material on se.FMaterialID = material.FID ").append(" where sr.FID in(").append(params).append(") and sr.FIsCentralBalance = 1 and se.FIsBetweenCompanySend = 1 ");
            String centralBalanceSQL = sql.toString();
            sql.setLength(0);
            sql.append("select sr.fid id,sr.fnumber number,se.fid entryid,sr.FBizDate bizDate,sr.FSaleOrgUnitID saleOrgUntiID,se.FCompanyOrgUnitID companyOrgUntiID,sr.FCurrencyID currencyid,se.FMaterialID materialid,material.fnumber materialNumber,material.FName_l2 materialName,se.FUnitID unitid,se.FBaseUnitID baseUnitID,se.FAssistPropertyID assistProperyID,cus.fid customerid,se.FQty qty,se.FTaxRate taxrate,se.FPrice price,-1 discounttype,0.0000 discount,se.FTaxRate actualprice,se.FTaxPrice actualtaxprice,se.FTaxPrice taxprice ,material.FPricePrecision priceprecision ").append("  from T_SD_SaleReturns sr ").append(" inner join T_SD_SaleReturnsEntry se on se.FParentID = sr.FID ").append(" inner join T_BD_Customer cus on cus.FInternalCompanyID = sr.FBalanceCompanyOrgUnitID  and cus.fusedstatus = 1").append(" inner join T_BD_Material material on se.FMaterialID = material.FID ").append(" where sr.FID in(").append(params).append(") and sr.FIsCentralBalance = 1 and sr.FIsSquareBalance = 1 and se.FIsBetweenCompanySend = 1 ");
            String squareBalanceSQL1 = sql.toString();
            sql.setLength(0);
            sql.append("select sr.fid id,sr.fnumber number,se.fid entryid,sr.FBizDate bizDate,sr.FSaleOrgUnitID saleOrgUntiID,sr.FBalanceCompanyOrgUnitID companyOrgUntiID,sr.FCurrencyID currencyid,se.FMaterialID materialid,material.fnumber materialNumber,material.FName_l2 materialName,se.FUnitID unitid,se.FBaseUnitID baseUnitID,se.FAssistPropertyID assistProperyID,cus.fid customerid,se.FQty qty,se.FTaxRate taxrate,se.FPrice price,-1 discounttype,0.0000 discount,se.FTaxRate actualprice,se.FTaxPrice actualtaxprice,se.FTaxPrice taxprice ,material.FPricePrecision priceprecision ").append("  from T_SD_SaleReturns sr ").append(" inner join T_SD_SaleReturnsEntry se on se.FParentID = sr.FID ").append(" inner join T_BD_Customer cus on cus.FInternalCompanyID = sr.FCompanyOrgUnitID  and cus.fusedstatus = 1").append(" inner join T_BD_Material material on se.FMaterialID = material.FID ").append(" where sr.FID in(").append(params).append(") and sr.FIsCentralBalance = 1 and sr.FIsSquareBalance = 1 and se.FIsBetweenCompanySend = 1 ");
            String squareBalanceSQL2 = sql.toString();
            verifyResult = statement.executeQuery(verifySQL);
            if (verifyResult.next()) {
                String issueToBalance = EASResource.getString((String)"com.kingdee.eas.scm.common.SDSMResource", (String)"IssueToBalance", (Locale)ctx.getOriginLocale());
                String balanceToSale = EASResource.getString((String)"com.kingdee.eas.scm.common.SDSMResource", (String)"BalanceToSale", (Locale)ctx.getOriginLocale());
                squareBalanceResult1 = statement.executeQuery(squareBalanceSQL1);
                this.processPricePolicy(ctx, squareBalanceResult1, retMap, issueToBalance);
                squareBalanceResult2 = statement.executeQuery(squareBalanceSQL2);
                this.processPricePolicy(ctx, squareBalanceResult2, retMap, balanceToSale);
            } else {
                centralBalanceResult = statement.executeQuery(centralBalanceSQL);
                this.processPricePolicy(ctx, centralBalanceResult, retMap, "centralBalance");
            }
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
                catch (BOSException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(centralBalanceResult);
                SQLUtils.cleanup(squareBalanceResult1);
                SQLUtils.cleanup(squareBalanceResult2);
                SQLUtils.cleanup((Statement)statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)centralBalanceResult);
        SQLUtils.cleanup(squareBalanceResult1);
        SQLUtils.cleanup(squareBalanceResult2);
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        return retMap;
    }

    private Map processPricePolicy(Context ctx, ResultSet result, Map retMap, String msg) throws BOSException {
        try {
            CustomerInfo customerInfo = new CustomerInfo();
            MaterialInfo materialInfo = new MaterialInfo();
            CurrencyInfo currencyInfo = new CurrencyInfo();
            CompanyOrgUnitInfo companyOrgInfo = new CompanyOrgUnitInfo();
            SaleOrgUnitInfo saleOrgInfo = new SaleOrgUnitInfo();
            PriceCondition priceCondition = new PriceCondition();
            IPriceProvider iProvider = PriceProviderFactory.getLocalInstance((Context)ctx);
            Calendar cal = Calendar.getInstance();
            Timestamp ts = new Timestamp(cal.getTimeInMillis());
            while (result.next()) {
                if ("centralBalance".equalsIgnoreCase(msg)) {
                    msg = null;
                    String sourceBillTypeID = result.getString("sourcebilltypeid");
                    if (!StringUtil.isEmpty((String)sourceBillTypeID) && "510b6503-0105-1000-e000-0113c0a812fd463ED552".equalsIgnoreCase(sourceBillTypeID)) continue;
                }
                customerInfo.setId(BOSUuid.read((String)result.getString("customerid")));
                priceCondition.setCustomerInfo(customerInfo);
                materialInfo.setId(BOSUuid.read((String)result.getString("materialid")));
                priceCondition.setMaterialInfo(materialInfo);
                priceCondition.setMeasureUnit(result.getString("unitid"));
                companyOrgInfo.setId(BOSUuid.read((String)result.getString("companyOrgUntiID")));
                priceCondition.setCompanyOrg(companyOrgInfo);
                saleOrgInfo.setId(BOSUuid.read((String)result.getString("saleOrgUntiID")));
                priceCondition.setSaleOrg(saleOrgInfo);
                priceCondition.setOrderQty(result.getBigDecimal("qty"));
                currencyInfo.setId(BOSUuid.read((String)result.getString("currencyid")));
                priceCondition.setCurrencyInfo(currencyInfo);
                priceCondition.setCurDate((Date)ts);
                priceCondition.setPriceTypeID("00000000-0000-0000-0000-0000000000036A61CE8D");
                Map resultMap = iProvider.calculatePrice(priceCondition);
                if (!resultMap.isEmpty()) continue;
                String keyStr = result.getString("number") + "_" + result.getString("entryid") + "_" + result.getString("companyOrgUntiID");
                String msgStr = null;
                msgStr = msg != null ? msg + result.getString("materialNumber") + "," + result.getString("materialName") : result.getString("materialNumber") + "," + result.getString("materialName");
                retMap.put(keyStr, msgStr);
            }
        }
        catch (SQLException er) {
            throw new BOSException("sql Execute Error :", (Throwable)er);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            logger.equals((Object)e);
        }
        return retMap;
    }

    protected Map _isPricePolicyPriceExist1(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        HashMap<String, String> retMap = new HashMap<String, String>();
        Connection con = null;
        Statement statement = null;
        ResultSet result = null;
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            StringBuffer sql = new StringBuffer();
            String params = this.convertToString(pks);
            sql.append("select sr.fid id,sr.fnumber number,se.fid entryid,sr.FBizDate bizDate,sr.FSaleOrgUnitID saleOrgUntiID,se.FCompanyOrgUnitID companyOrgUntiID,sr.FCurrencyID currencyid,se.FMaterialID materialid,material.fnumber materialNumber,material.FName_l2 materialName,se.FUnitID unitid,se.FBaseUnitID baseUnitID,se.FAssistPropertyID assistProperyID,cus.fid customerid,se.FQty qty,se.FTaxRate taxrate,se.FPrice price,-1 discounttype,0.0000 discount,se.FTaxRate actualprice,se.FTaxPrice actualtaxprice,se.FTaxPrice taxprice ,material.FPricePrecision priceprecision ").append("  from T_SD_SaleReturns sr ").append(" inner join T_SD_SaleReturnsEntry se on se.FParentID = sr.FID ").append(" inner join T_BD_Customer cus on cus.FInternalCompanyID = sr.FCompanyOrgUnitID ").append(" inner join T_BD_Material material on se.FMaterialID = material.FID ").append(" where sr.FID in(").append(params).append(") and sr.FIsCentralBalance = 1 and se.FIsBetweenCompanySend = 1 ");
            result = statement.executeQuery(sql.toString());
            CustomerInfo customerInfo = new CustomerInfo();
            MaterialInfo materialInfo = new MaterialInfo();
            CurrencyInfo currencyInfo = new CurrencyInfo();
            CompanyOrgUnitInfo companyOrgInfo = new CompanyOrgUnitInfo();
            SaleOrgUnitInfo saleOrgInfo = new SaleOrgUnitInfo();
            PriceCondition priceCondition = new PriceCondition();
            IPriceProvider iProvider = PriceProviderFactory.getLocalInstance((Context)ctx);
            Calendar cal = Calendar.getInstance();
            Timestamp ts = new Timestamp(cal.getTimeInMillis());
            while (result.next()) {
                customerInfo.setId(BOSUuid.read((String)result.getString("customerid")));
                priceCondition.setCustomerInfo(customerInfo);
                materialInfo.setId(BOSUuid.read((String)result.getString("materialid")));
                priceCondition.setMaterialInfo(materialInfo);
                priceCondition.setMeasureUnit(result.getString("unitid"));
                companyOrgInfo.setId(BOSUuid.read((String)result.getString("companyOrgUntiID")));
                priceCondition.setCompanyOrg(companyOrgInfo);
                saleOrgInfo.setId(BOSUuid.read((String)result.getString("saleOrgUntiID")));
                priceCondition.setSaleOrg(saleOrgInfo);
                priceCondition.setOrderQty(result.getBigDecimal("qty"));
                currencyInfo.setId(BOSUuid.read((String)result.getString("currencyid")));
                priceCondition.setCurrencyInfo(currencyInfo);
                priceCondition.setCurDate((Date)ts);
                priceCondition.setPriceTypeID("00000000-0000-0000-0000-0000000000036A61CE8D");
                Map resultMap = iProvider.calculatePrice(priceCondition);
                if (!resultMap.isEmpty()) continue;
                String keyStr = result.getString("number") + "_" + result.getString("entryid");
                String msgStr = result.getString("materialNumber") + "," + result.getString("materialName");
                retMap.put(keyStr, msgStr);
            }
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(result, statement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)result, (Statement)statement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
        return retMap;
    }

    @Override
    protected Map _isPricePolicyPriceExist(Context ctx, IObjectValue objectValue) throws BOSException, EASBizException {
        Map map = null;
        map = this.processPolicyPrice(ctx, objectValue);
        return map;
    }

    private Map processPolicyPrice(Context ctx, IObjectValue objectValue) throws BOSException, EASBizException {
        HashMap<String, String> retMap;
        block9: {
            IPriceProvider iProvider;
            HashMap<String, MaterialInfo> map;
            CustomerCollection customerColl;
            ICustomer icus;
            String companyID;
            boolean isCentralBalance;
            SaleReturnsInfo saleReturnsInfo;
            CustomerInfo customerInfo;
            block8: {
                retMap = new HashMap<String, String>();
                customerInfo = null;
                CustomerInfo balanceCustomerInfo = null;
                saleReturnsInfo = (SaleReturnsInfo)objectValue;
                isCentralBalance = saleReturnsInfo.isIsCentralBalance();
                companyID = null;
                icus = CustomerFactory.getLocalInstance((Context)ctx);
                customerColl = null;
                SaleReturnsEntryCollection saleReturnEntryCollection = saleReturnsInfo.getEntries();
                Object[] repks = new ObjectUuidPK[saleReturnEntryCollection.size()];
                int n = saleReturnEntryCollection.size();
                for (int i = 0; i < n; ++i) {
                    repks[i] = new ObjectUuidPK(saleReturnEntryCollection.get(i).getMaterial().getId().toString());
                }
                CoreBaseCollection coreBaseCollection = MaterialFactory.getLocalInstance((Context)ctx).getCollection(" where id in  (" + this.convertToString(repks) + ")");
                map = new HashMap<String, MaterialInfo>();
                for (int i = 0; i < coreBaseCollection.size(); ++i) {
                    MaterialInfo materialInfo = (MaterialInfo)coreBaseCollection.get(i);
                    if (materialInfo == null) continue;
                    map.put(materialInfo.getId().toString(), materialInfo);
                }
                if (!isCentralBalance || !saleReturnsInfo.isIsSquareBalance()) break block8;
                customerColl = icus.getCustomerCollection("select id,number where internalCompany.id = '" + saleReturnsInfo.getBalanceCompanyOrgUnit().getId().toString() + "'");
                if (customerColl.isEmpty()) {
                    return retMap;
                }
                balanceCustomerInfo = customerColl.get(0);
                customerColl = icus.getCustomerCollection("select id,number where internalCompany.id = '" + saleReturnsInfo.getCompanyOrgUnit().getId().toString() + "'");
                if (customerColl.isEmpty()) {
                    return retMap;
                }
                customerInfo = customerColl.get(0);
                PriceCondition priceCondition = new PriceCondition();
                iProvider = PriceProviderFactory.getLocalInstance((Context)ctx);
                priceCondition.setSaleOrg(saleReturnsInfo.getSaleOrgUnit());
                priceCondition.setCurrencyInfo(saleReturnsInfo.getCurrency());
                priceCondition.setCurDate(saleReturnsInfo.getBizDate());
                priceCondition.setPriceTypeID("00000000-0000-0000-0000-0000000000036A61CE8D");
                SaleReturnsEntryCollection entryColl = saleReturnsInfo.getEntries();
                String issueToBalance = EASResource.getString((String)"com.kingdee.eas.scm.common.SDSMResource", (String)"IssueToBalance", (Locale)ctx.getOriginLocale());
                String balanceToSale = EASResource.getString((String)"com.kingdee.eas.scm.common.SDSMResource", (String)"BalanceToSale", (Locale)ctx.getOriginLocale());
                int n2 = entryColl.size();
                for (int i = 0; i < n2; ++i) {
                    String msgStr;
                    String keyStr;
                    MaterialInfo materialInfo;
                    SaleReturnsEntryInfo saleReturnsEntryInfo = entryColl.get(i);
                    if (!saleReturnsEntryInfo.isIsBetweenCompanySend()) continue;
                    priceCondition.setMaterialInfo(saleReturnsEntryInfo.getMaterial());
                    priceCondition.setMeasureUnit(saleReturnsEntryInfo.getUnit().getId().toString());
                    priceCondition.setCustomerInfo(balanceCustomerInfo);
                    priceCondition.setCompanyOrg(saleReturnsEntryInfo.getCompanyOrgUnit());
                    priceCondition.setOrderQty(saleReturnsEntryInfo.getQty());
                    priceCondition.setAssiProperty(saleReturnsEntryInfo.getAssistProperty());
                    List[] priceList = iProvider.getPrices(new PriceCondition[]{priceCondition});
                    if ((priceList == null || priceList.length < 1 || priceList[0] == null || priceList[0].size() < 1) && map.containsKey(saleReturnsEntryInfo.getMaterial().getId().toString())) {
                        materialInfo = (MaterialInfo)map.get(saleReturnsEntryInfo.getMaterial().getId().toString());
                        keyStr = "number_" + i + saleReturnsEntryInfo.getCompanyOrgUnit().getId().toString();
                        msgStr = issueToBalance + materialInfo.getNumber() + "," + materialInfo.getName();
                        retMap.put(keyStr, msgStr);
                    }
                    priceCondition.setCustomerInfo(customerInfo);
                    priceCondition.setCompanyOrg(saleReturnsInfo.getBalanceCompanyOrgUnit());
                    priceList = iProvider.getPrices(new PriceCondition[]{priceCondition});
                    if (priceList != null && priceList.length >= 1 && priceList[0] != null && priceList[0].size() >= 1 || !map.containsKey(saleReturnsEntryInfo.getMaterial().getId().toString())) continue;
                    materialInfo = (MaterialInfo)map.get(saleReturnsEntryInfo.getMaterial().getId().toString());
                    keyStr = "number_" + i + saleReturnsInfo.getBalanceCompanyOrgUnit().getId().toString();
                    msgStr = balanceToSale + materialInfo.getNumber() + "," + materialInfo.getName();
                    retMap.put(keyStr, msgStr);
                }
                break block9;
            }
            if (!isCentralBalance) break block9;
            companyID = saleReturnsInfo.getCompanyOrgUnit().getId().toString();
            customerColl = icus.getCustomerCollection("select id,number where internalCompany.id = '" + companyID + "'");
            if (customerColl.isEmpty()) {
                return retMap;
            }
            customerInfo = customerColl.get(0);
            PriceCondition priceCondition = new PriceCondition();
            iProvider = PriceProviderFactory.getLocalInstance((Context)ctx);
            Calendar cal = Calendar.getInstance();
            Timestamp ts = new Timestamp(cal.getTimeInMillis());
            priceCondition.setCustomerInfo(customerInfo);
            priceCondition.setSaleOrg(saleReturnsInfo.getSaleOrgUnit());
            priceCondition.setCurrencyInfo(saleReturnsInfo.getCurrency());
            priceCondition.setCurDate((Date)ts);
            priceCondition.setPriceTypeID("00000000-0000-0000-0000-0000000000036A61CE8D");
            SaleReturnsEntryCollection entryColl = saleReturnsInfo.getEntries();
            int n = entryColl.size();
            for (int i = 0; i < n; ++i) {
                SaleReturnsEntryInfo saleReturnsEntryInfo = entryColl.get(i);
                if (!saleReturnsEntryInfo.isIsBetweenCompanySend()) continue;
                priceCondition.setMaterialInfo(saleReturnsEntryInfo.getMaterial());
                priceCondition.setMeasureUnit(saleReturnsEntryInfo.getUnit().getId().toString());
                priceCondition.setCompanyOrg(saleReturnsEntryInfo.getCompanyOrgUnit());
                priceCondition.setOrderQty(saleReturnsEntryInfo.getQty());
                priceCondition.setAssiProperty(saleReturnsEntryInfo.getAssistProperty());
                List[] priceList = iProvider.getPrices(new PriceCondition[]{priceCondition});
                if (priceList != null && priceList.length >= 1 && priceList[0] != null && priceList[0].size() >= 1 || !map.containsKey(saleReturnsEntryInfo.getMaterial().getId().toString())) continue;
                MaterialInfo materialInfo = (MaterialInfo)map.get(saleReturnsEntryInfo.getMaterial().getId().toString());
                String keyStr = "number_" + i;
                String msgStr = materialInfo.getNumber() + "," + materialInfo.getName();
                retMap.put(keyStr, msgStr);
            }
        }
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map _isPricePolicyPriceExist1(Context ctx, IObjectValue saleReturnInfo) throws BOSException, EASBizException {
        HashMap<String, String> retMap = new HashMap<String, String>();
        Connection con = null;
        Statement statement = null;
        try {
            if (saleReturnInfo.get("id") != null && !"".equals(saleReturnInfo.get("id").toString().trim())) {
                ObjectUuidPK[] pks = new ObjectUuidPK[1];
                SaleReturnsInfo srInfo = (SaleReturnsInfo)saleReturnInfo;
                pks[0] = new ObjectUuidPK(srInfo.getId().toString());
                Map map = this._isPricePolicyPriceExist(ctx, (IObjectPK[])pks);
                return map;
            }
            SaleReturnsInfo srInfo = (SaleReturnsInfo)saleReturnInfo;
            boolean isCentralBalance = srInfo.isIsCentralBalance();
            String companyID = srInfo.getCompanyOrgUnit().getId().toString();
            ICustomer icus = CustomerFactory.getLocalInstance((Context)ctx);
            CustomerCollection customerColl = icus.getCustomerCollection("select id,number where internalCompany.id = '" + companyID + "'");
            if (customerColl.isEmpty()) {
                HashMap<String, String> hashMap = retMap;
                return hashMap;
            }
            CustomerInfo customerInfo = null;
            customerInfo = customerColl.get(0);
            if (isCentralBalance) {
                PriceCondition priceCondition = new PriceCondition();
                IPriceProvider iProvider = PriceProviderFactory.getLocalInstance((Context)ctx);
                Calendar cal = Calendar.getInstance();
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                priceCondition.setCustomerInfo(customerInfo);
                priceCondition.setSaleOrg(srInfo.getSaleOrgUnit());
                priceCondition.setCurrencyInfo(srInfo.getCurrency());
                priceCondition.setCurDate((Date)ts);
                priceCondition.setPriceTypeID("00000000-0000-0000-0000-0000000000036A61CE8D");
                SaleReturnsEntryCollection entryColl = srInfo.getEntries();
                int n = entryColl.size();
                for (int i = 0; i < n; ++i) {
                    SaleReturnsEntryInfo srEntry = entryColl.get(i);
                    if (!srEntry.isIsBetweenCompanySend()) continue;
                    priceCondition.setMaterialInfo(srEntry.getMaterial());
                    priceCondition.setMeasureUnit(srEntry.getUnit().toString());
                    priceCondition.setCompanyOrg(srEntry.getCompanyOrgUnit());
                    priceCondition.setOrderQty(srEntry.getQty());
                    Map resultMap = iProvider.calculatePrice(priceCondition);
                    if (!resultMap.isEmpty()) continue;
                    String keyStr = "number_" + i;
                    String msgStr = srEntry.getMaterial().getNumber() + "," + srEntry.getMaterial().getName();
                    retMap.put(keyStr, msgStr);
                }
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            logger.equals((Object)e);
        }
        finally {
            SQLUtils.cleanup(statement, con);
            SQLUtils.cleanup(con);
        }
        return retMap;
    }

    protected void _reverseSave(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    protected ExchangeRateInfo getNewExchangeRate(Context ctx, BigDecimal oldRate, String sourceBillID, String sourceBillTypeID, CompanyOrgUnitInfo companyOrg, CurrencyInfo currencyInfo, CurrencyInfo baseCurrencyInfo) throws BOSException, EASBizException {
        OrgUnitCollection orgUnitCol = null;
        CompanyOrgUnitInfo companyOrgFromInfo = null;
        if (sourceBillTypeID.equals("510b6503-0105-1000-e000-0113c0a812fd463ED552")) {
            SaleOrderInfo saleOrderInfo = SaleOrderFactory.getLocalInstance(ctx).getSaleOrderInfo("select saleOrgUnit.id where id='" + sourceBillID + "'");
            orgUnitCol = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(saleOrderInfo.getSaleOrgUnit().getId().toString(), 2, 1);
        }
        if (orgUnitCol != null && orgUnitCol.size() > 0 && companyOrg != null) {
            ObjectUuidPK sourceCurrPK;
            companyOrgFromInfo = (CompanyOrgUnitInfo)orgUnitCol.get(0);
            if (companyOrgFromInfo != null && companyOrgFromInfo.getId().toString().equals(companyOrg.getId().toString())) {
                if (oldRate == null) {
                    ObjectUuidPK destCurrPK;
                    sourceCurrPK = new ObjectUuidPK(currencyInfo.getId());
                    ExchangeRateInfo tempexrateinfo = SCMServerUtils.getExchangeRate((Context)ctx, (CompanyOrgUnitInfo)companyOrg, (IObjectPK)sourceCurrPK, (IObjectPK)(destCurrPK = new ObjectUuidPK(baseCurrencyInfo.getId())));
                    if (tempexrateinfo == null) {
                        throw new OrderException(OrderException.NOT_FOUNT_RATE);
                    }
                    return tempexrateinfo;
                }
            } else {
                ObjectUuidPK destCurrPK;
                sourceCurrPK = new ObjectUuidPK(currencyInfo.getId());
                ExchangeRateInfo tempexrateinfo = SCMServerUtils.getExchangeRate((Context)ctx, (CompanyOrgUnitInfo)companyOrg, (IObjectPK)sourceCurrPK, (IObjectPK)(destCurrPK = new ObjectUuidPK(baseCurrencyInfo.getId())));
                if (tempexrateinfo == null) {
                    throw new OrderException(OrderException.NOT_FOUNT_RATE);
                }
                return tempexrateinfo;
            }
        }
        return null;
    }

    public String getParamCon4Audit() {
        return "SALEBILL002";
    }

    public String getParamCon4UnAudit() {
        return "SALEBILL003";
    }

    protected IObjectValue _createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        SaleReturnsInfo saleReturnsInfo = new SaleReturnsInfo();
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        saleReturnsInfo.setBizDate(curDate);
        saleReturnsInfo.setCreateTime(new Timestamp(cal.getTimeInMillis()));
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e008-8152c0a812fd463ED552"));
        saleReturnsInfo.setBillType(billTypeInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isDefault"));
        sic.add(new SelectorItemInfo("bizCategory"));
        sic.add(new SelectorItemInfo("billBizType"));
        sic.add(new SelectorItemInfo("rowBizType"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        IBizType iBizType = BizTypeFactory.getLocalInstance((Context)ctx);
        BizTypeInfo bizTypeInfo = iBizType.getBizTypeInfo((IObjectPK)new ObjectUuidPK("d8e80652-0110-1000-e000-04c5c0a812202407435C"), sic);
        if (bizTypeInfo != null) {
            saleReturnsInfo.setBizType(bizTypeInfo);
        }
        if (!this.isBizTypeValid(ctx, (IObjectValue)saleReturnsInfo, "50957179-0105-1000-e008-8152c0a812fd463ED552", bizTypeInfo).booleanValue()) {
            saleReturnsInfo.setBizType(null);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        IPaymentType iPaymentType = PaymentTypeFactory.getLocalInstance((Context)ctx);
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        PaymentTypeInfo paymentTypeInfo = iPaymentType.getPaymentTypeInfo((IObjectPK)new ObjectUuidPK("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5"), selector);
        if (paymentTypeInfo != null) {
            saleReturnsInfo.setPaymentType(paymentTypeInfo);
        }
        return saleReturnsInfo;
    }

    protected String getBatchMethodName(Context ctx, String name) throws BaseException {
        if (Boolean.FALSE.equals(ctx.get((Object)"CONTEXT_KEY_ISBATCHACTION"))) {
            return null;
        }
        return "batch" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected void _submit(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        Class[] parameterTypes = new Class[]{IObjectValue.class};
        SaleReturnsInfo model = null;
        model = this.getSaleReturnsInfo(ctx, (IObjectPK)new ObjectUuidPK(id), SCMSelectorFactory.getSaleReturnsSelector((boolean)true));
        entries[0] = new BatchExecuteParamsEntry(parameterTypes, new Object[]{model});
        this.batchExecute(ctx, entries, BatchActionEnum.SUBMIT);
    }

    public BatchActionResults batchSubmitOrSave(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchAction) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, batchAction);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{model})};
        this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    protected BatchActionResults batchExecute(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        IBusinessChainExecutor executor = BusinessChainExecutorFactory.getBusinessChainExecutor();
        ParamEntryExecuteContext executeContext = new ParamEntryExecuteContext(ctx, this.getBOSType(), batchActionEnum, (BizController)this, entries);
        executeContext.setBillTypeID(this.getBillTypeId());
        BatchActionResults batchResults = executor.batchExecute((ExecuteContext)executeContext);
        if (BatchActionEnum.AUDIT.equals((Object)batchActionEnum)) {
            SCMServerUtils.setBizFlowRelationField((Context)ctx, (String)"T_SD_SaleReturnsEntry");
            SCMServerUtils.setBizFlowRelationField((Context)ctx, (String)"T_SD_SaleOrderEntry");
            SCMServerUtils.setBizFlowRelationField((Context)ctx, (String)"T_IM_SaleIssueEntry");
        }
        if (batchResults == null) {
            return super.batchExecute(ctx, entries, batchActionEnum);
        }
        return batchResults;
    }

    protected void calByUnitSource(Context ctx, SCMBillBaseInfo scmBillBaseInfo, SCMBillEntryBaseInfo scmBillEntryBaseInfo) throws BOSException, EASBizException {
        String sourceUnitId;
        super.calByUnitSource(ctx, scmBillBaseInfo, scmBillEntryBaseInfo);
        SaleReturnsEntryInfo saleReturnsEntryInfo = (SaleReturnsEntryInfo)scmBillEntryBaseInfo;
        String sourceBillEntryId = saleReturnsEntryInfo.getSourceBillEntryId();
        if (StringUtil.isEmpty((String)sourceBillEntryId)) {
            return;
        }
        if (!(this.sourceBillEntryMap.get(sourceBillEntryId) instanceof SCMBillEntryBaseInfo)) {
            return;
        }
        SCMBillEntryBaseInfo sourceBillEntryInfo = (SCMBillEntryBaseInfo)this.sourceBillEntryMap.get(sourceBillEntryId);
        String unitId = saleReturnsEntryInfo.getUnit().getId().toString();
        if (unitId.equals(sourceUnitId = sourceBillEntryInfo.getUnit().getId().toString())) {
            return;
        }
        BigDecimal qty = BigDecimal.ZERO;
        qty = saleReturnsEntryInfo.getBaseQty() != null ? SCMCommonUtil.calQtyByBaseQty((Context)ctx, (BigDecimal)saleReturnsEntryInfo.getBaseQty(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo) : SCMCommonUtil.reCalQty((Context)ctx, (BigDecimal)saleReturnsEntryInfo.getQty(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo, (String)sourceUnitId);
        saleReturnsEntryInfo.setQty(qty);
        SaleReturnsInfo saleReturnsInfo = (SaleReturnsInfo)scmBillBaseInfo;
        SaleContractCal saleContractCal = new SaleContractCal();
        saleContractCal.setInTax(saleReturnsInfo.isIsInTax());
        BigDecimal price = null;
        if (saleReturnsInfo.isIsInTax()) {
            price = SCMCommonUtil.reCalPrice((Context)ctx, (BigDecimal)saleReturnsEntryInfo.getTaxPrice(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo, (String)sourceUnitId);
            saleReturnsEntryInfo.setTaxPrice(price);
            saleContractCal.calByEntryTaxPriceChange((SCMBillBaseInfo)saleReturnsInfo, (SCMBillEntryBaseInfo)saleReturnsEntryInfo);
        } else {
            price = SCMCommonUtil.reCalPrice((Context)ctx, (BigDecimal)saleReturnsEntryInfo.getPrice(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo, (String)sourceUnitId);
            saleReturnsEntryInfo.setPrice(price);
            saleContractCal.calByEntryPriceChange((SCMBillBaseInfo)saleReturnsInfo, (SCMBillEntryBaseInfo)saleReturnsEntryInfo);
        }
    }
}

