/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.IReasonCode;
import com.kingdee.eas.basedata.scm.common.ReasonCodeFactory;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.sd.sale.ISaleReturns;
import com.kingdee.eas.scm.sd.sale.SaleReturnsCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsFactory;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;

public class SaleReturnsEntryDataImport
extends AbstractDataTransmission {
    String[] BIGDECIMAL_FIELDS = new String[]{"FPrice", "FTaxPrice", "FAmount", "FTaxRate", "FTax", "FTaxAmount", "FQty", "FAssistQty", "FInvoicedQty", "FRemainingQty", "FInvoicePrice", "FLocalAmount", "FReturnedQty", "FBaseQty"};
    String[] BIGDECIMAL_OBJ = new String[]{"price", "taxPrice", "amount", "taxRate", "tax", "taxAmount", "qty", "assistQty", "invoicedQty", "remainingQty", "invoicePrice", "localAmount", "returnedQty", "baseQty"};
    String[] STRING_FIELDS = new String[]{"FRemark"};
    String[] STRING_OBJS = new String[]{"remark"};
    String[] DATE_FIELDS = new String[]{"FReturnsDate"};
    String[] DATE_OBJS = new String[]{"returnsDate"};
    String[] BOOLEAN_FIELDS = new String[]{"FIsPresent"};
    String[] BOOLEAN_OBJS = new String[]{"isPresent"};

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return SaleReturnsEntryFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase isaleReturnsEntry = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !isaleReturnsEntry.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                isaleReturnsEntry.addnew(coreBaseInfo);
            } else {
                isaleReturnsEntry.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Object value;
        Object o;
        int i;
        Object value2;
        SaleReturnsEntryInfo entryInfo;
        block29: {
            entryInfo = new SaleReturnsEntryInfo();
            try {
                Object data = ((DataToken)hsData.get((Object)"FSaleReturnsID")).data;
                if (data != null) {
                    String str = data.toString();
                    if (str != null && str.trim().length() > 0) {
                        ISaleReturns isaleReturns = SaleReturnsFactory.getLocalInstance(ctx);
                        SaleReturnsCollection collection = isaleReturns.getSaleReturnsCollection("where number ='" + str + "'");
                        if (collection == null || collection.size() == 0) {
                            throw new TaskExternalException("the SaleReturns  not found in database!!!!");
                        }
                        SaleReturnsInfo saleReturnsInfo = collection.get(0);
                        SaleReturnsEntryCollection entryCollection = saleReturnsInfo.getEntries();
                        entryInfo.setParent(saleReturnsInfo);
                        if (entryCollection != null && entryCollection.size() > 0) {
                            entryInfo.setSeq(this.getMaxRowNum(entryCollection));
                        } else {
                            entryInfo.setSeq(1);
                        }
                    }
                    break block29;
                }
                throw new TaskExternalException("FSaleReturnsID  not found!");
            }
            catch (BOSException bex) {
                Logger.error((Throwable)bex);
                throw new TaskExternalException("process saleReturnsid  error!");
            }
        }
        for (int i2 = 0; i2 < this.BIGDECIMAL_FIELDS.length; ++i2) {
            try {
                Object o2 = ((DataToken)hsData.get((Object)this.BIGDECIMAL_FIELDS[i2])).data;
                if (o2 == null || o2.toString().trim().length() <= 0 || (value2 = new BigDecimal(o2.toString())) == null) continue;
                entryInfo.setBigDecimal(this.BIGDECIMAL_OBJ[i2], (BigDecimal)value2);
                continue;
            }
            catch (NumberFormatException nex) {
                Logger.error((Throwable)nex);
                throw new TaskExternalException(this.BIGDECIMAL_OBJ[i2] + " format error, it must be a number!!!");
            }
        }
        DateFormat formater = DateFormat.getInstance();
        for (i = 0; i < this.DATE_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.DATE_FIELDS[i])).data;
            if (o != null && o instanceof Date) {
                value = (Date)o;
                if (value == null) continue;
                entryInfo.setDate(this.DATE_OBJS[i], (Date)value);
                continue;
            }
            if (o == null || o.toString() != null) continue;
            throw new TaskExternalException(this.DATE_FIELDS[i] + " format error, it must be a date String, xxxx-xx-xx!!!");
        }
        for (i = 0; i < this.BOOLEAN_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.BOOLEAN_FIELDS[i])).data;
            if (o == null || o.toString().trim().length() <= 0 || (value = o.toString()) == null) continue;
            entryInfo.setBoolean(this.BOOLEAN_OBJS[i], this.getBooleanValue((String)value));
        }
        for (i = 0; i < this.STRING_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.STRING_FIELDS[i])).data;
            if (o == null) continue;
            value = o.toString();
            entryInfo.setString(this.STRING_OBJS[i], (String)value);
        }
        Object data = ((DataToken)hsData.get((Object)"FBaseStatus")).data;
        value2 = null;
        if (data != null && (value2 = data.toString()) != null) {
            entryInfo.setBaseStatus(this.getBaseStatusValue((String)value2));
        }
        try {
            IReasonCode iReasonCode;
            MeasureUnitInfo info;
            IMeasureUnit iunit;
            MeasureUnitCollection collection;
            MaterialInfo info2;
            MaterialCollection collection2;
            FilterInfo filter;
            EntityViewInfo viewInfo;
            String str = null;
            data = ((DataToken)hsData.get((Object)"FMaterialID")).data;
            if (data != null && (str = data.toString()) != null && str.trim().length() > 0) {
                IMaterial imaterial = MaterialFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                collection2 = imaterial.getMaterialCollection(viewInfo);
                if (collection2 != null && collection2.size() > 0 && (info2 = collection2.get(0)) != null) {
                    entryInfo.setMaterial(info2);
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FUnitID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection = (iunit = MeasureUnitFactory.getLocalInstance((Context)ctx)).getMeasureUnitCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                entryInfo.setUnit(info);
            }
            if ((data = ((DataToken)hsData.get((Object)"FBaseUnitID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection = (iunit = MeasureUnitFactory.getLocalInstance((Context)ctx)).getMeasureUnitCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                entryInfo.setBaseUnit(info);
            }
            if ((data = ((DataToken)hsData.get((Object)"FAssistantUnitID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection = (iunit = MeasureUnitFactory.getLocalInstance((Context)ctx)).getMeasureUnitCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                entryInfo.setAssistUnit(info);
            }
            if ((data = ((DataToken)hsData.get((Object)"FReasonCodeID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection = (iReasonCode = ReasonCodeFactory.getLocalInstance((Context)ctx)).getReasonCodeCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                entryInfo.setReasonCode((ReasonCodeInfo)info);
            }
            if ((data = ((DataToken)hsData.get((Object)"FStorageOrgUnitID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                IStorageOrgUnit iStorageOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                collection2 = iStorageOrgUnit.getStorageOrgUnitCollection(viewInfo);
                if (collection2 != null && collection2.size() > 0 && (info2 = collection2.get(0)) != null) {
                    entryInfo.setStorageOrgUnit((StorageOrgUnitInfo)info2);
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FCompanyOrgUnitID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                collection2 = iCompanyOrgUnit.getCompanyOrgUnitCollection(viewInfo);
                if (collection2 != null && collection2.size() > 0 && (info2 = collection2.get(0)) != null) {
                    entryInfo.setCompanyOrgUnit((CompanyOrgUnitInfo)info2);
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FWarehouseID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                IWarehouse iWarehouse = WarehouseFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                collection2 = iWarehouse.getWarehouseCollection(viewInfo);
                if (collection2 != null && collection2.size() > 0 && (info2 = collection2.get(0)) != null) {
                    entryInfo.setWarehouse((WarehouseInfo)info2);
                }
            }
        }
        catch (Exception ex) {
            Logger.error((Throwable)ex);
        }
        return entryInfo;
    }

    private int getMaxRowNum(SaleReturnsEntryCollection entryCollection) {
        int max = 0;
        int temp = 0;
        int num = entryCollection.size();
        for (int i = 0; i < num; ++i) {
            SaleReturnsEntryInfo info = entryCollection.get(i);
            if (info == null || (temp = info.getSeq()) <= max) continue;
            max = temp;
        }
        return max;
    }

    private boolean getBooleanValue(String value) {
        return !(value = value.trim()).equalsIgnoreCase("N") && !value.equalsIgnoreCase("NO") && !value.equalsIgnoreCase("0");
    }

    private EntryBaseStatusEnum getBaseStatusValue(String value) {
        EntryBaseStatusEnum tSaved = EntryBaseStatusEnum.TEMPORARILYSAVED;
        if (value != null) {
            value = value.trim();
            List EnumList = EntryBaseStatusEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                EntryBaseStatusEnum enums = (EntryBaseStatusEnum)EnumList.get(i);
                String enumValue = String.valueOf(enums.getValue());
                String enumName = enums.getName();
                String enumAlias = enums.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                tSaved = enums;
                break;
            }
        }
        return tSaved;
    }
}

