/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.ReversingStateEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.sd.sale.ISalesExpenseInvoice;
import com.kingdee.eas.scm.sd.sale.SaleExpenseInvoiceException;
import com.kingdee.eas.scm.sd.sale.SalesExpenseInvoiceEntryCollection;
import com.kingdee.eas.scm.sd.sale.SalesExpenseInvoiceEntryInfo;
import com.kingdee.eas.scm.sd.sale.SalesExpenseInvoiceFactory;
import com.kingdee.eas.scm.sd.sale.SalesExpenseInvoiceInfo;
import com.kingdee.eas.scm.sd.sale.app.AbstractSalesExpenseInvoiceControllerBean;
import com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class SalesExpenseInvoiceControllerBean
extends AbstractSalesExpenseInvoiceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.SalesExpenseInvoiceControllerBean");

    @Override
    protected void _audit(Context ctx, IObjectPK model) throws BOSException, EASBizException {
        SalesExpenseInvoiceInfo saleInfo = (SalesExpenseInvoiceInfo)this.getValue(ctx, model);
        if (this.isCheckCloseAccount() && this.isCloseAccount(ctx, model)) {
            throw new SCMBillException(SCMBillException.CLOSEACCOUNT_AUDIT);
        }
        if (saleInfo != null) {
            if (saleInfo.getBaseStatus().getValue() != 2) {
                throw new SaleExpenseInvoiceException(SaleExpenseInvoiceException.STATECANNOTAUDIT);
            }
        } else {
            throw new SaleExpenseInvoiceException(SaleExpenseInvoiceException.ENTITYNOTEXISTS);
        }
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        saleInfo.setAuditor(user);
        saleInfo.setAuditTime(new Timestamp(System.currentTimeMillis()));
        saleInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
        super.update(ctx, model, (CoreBaseInfo)saleInfo);
    }

    @Override
    protected void _createOtherBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CoreBaseInfo info = this.getValue(ctx, pk);
        if (info != null && info instanceof SalesExpenseInvoiceInfo) {
            SalesExpenseInvoiceInfo saleInfo = (SalesExpenseInvoiceInfo)info;
            if (saleInfo.getBaseStatus().getValue() != 2) {
                throw new SaleExpenseInvoiceException(SaleExpenseInvoiceException.STATECANNOTCANCELBILL);
            }
            saleInfo.setBaseStatus(BillBaseStatusEnum.DELETED);
            this.update(ctx, pk, (CoreBaseInfo)saleInfo);
            if (saleInfo.isIsReversed()) {
                SalesExpenseInvoiceInfo srcInfo = (SalesExpenseInvoiceInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(saleInfo.getSourceBillId()));
                srcInfo.setIsReversed(false);
                srcInfo.setReversingStatus(ReversingStateEnum.UNREVERSED);
                super._update(ctx, (IObjectPK)new ObjectUuidPK(srcInfo.getId()), (IObjectValue)srcInfo);
            }
        } else {
            throw new SaleExpenseInvoiceException(SaleExpenseInvoiceException.ENTITYNOTEXISTS);
        }
    }

    @Override
    protected void _cancel(Context ctx, List list) throws EASBizException, BOSException {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object obj = list.get(i);
            if (obj == null || !(obj instanceof String)) {
                throw new SaleExpenseInvoiceException(SaleExpenseInvoiceException.LISTMUSTBESTRING);
            }
            ObjectUuidPK pk = new ObjectUuidPK((String)obj);
            this._cancel(ctx, (IObjectPK)pk);
        }
    }

    private boolean checkPropertyEquals(AbstractObjectValue value1, AbstractObjectValue value2, String[] args) {
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            Object obj1 = value1.get(args[i]);
            Object obj2 = value2.get(args[i]);
            if (obj1 != null && obj2 != null) {
                if (obj1.equals(obj2)) continue;
                return false;
            }
            if (obj1 == null && obj2 != null) {
                return false;
            }
            if (obj1 == null || obj2 != null) continue;
            return false;
        }
        return true;
    }

    private boolean checkPropertyNegative(AbstractObjectValue value1, AbstractObjectValue value2, String[] args) {
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            Object obj1 = value1.get(args[i]);
            Object obj2 = value2.get(args[i]);
            if (obj1 != null && obj2 != null) {
                BigDecimal bd2;
                BigDecimal bd1;
                if (!(obj1 instanceof BigDecimal) || !(obj2 instanceof BigDecimal) || (bd1 = (BigDecimal)obj1).equals((bd2 = (BigDecimal)obj2).negate())) continue;
                return false;
            }
            if (obj1 == null && obj2 != null) {
                return false;
            }
            if (obj1 == null || obj2 != null) continue;
            return false;
        }
        return true;
    }

    private boolean checkIdenticalOfTwoInfo(SalesExpenseInvoiceInfo info1, SalesExpenseInvoiceInfo info2) {
        boolean isEqualHead = this.checkPropertyEquals((AbstractObjectValue)info1, (AbstractObjectValue)info2, new String[]{"customer", "fiOrgUnit", "saleOrgUnit"});
        if (!isEqualHead) {
            return false;
        }
        SalesExpenseInvoiceEntryCollection collection1 = info1.getEntries();
        SalesExpenseInvoiceEntryCollection collection2 = info2.getEntries();
        if (collection1.size() != collection2.size()) {
            return false;
        }
        int n = collection1.size();
        for (int i = 0; i < n; ++i) {
            SalesExpenseInvoiceEntryInfo entryInfo1 = collection1.get(i);
            SalesExpenseInvoiceEntryInfo entryInfo2 = collection2.get(i);
            if (!this.checkPropertyEquals((AbstractObjectValue)entryInfo1, (AbstractObjectValue)entryInfo2, new String[]{"expenseItem", "measureUnit", "price", "expenseItemName", "taxRatio"})) {
                return false;
            }
            if (this.checkPropertyNegative((AbstractObjectValue)entryInfo1, (AbstractObjectValue)entryInfo2, new String[]{"amount", "amountHome", "amountPaid", "amountTax", "amountTaxHome", "amountUnPaid", "amountWithoutTa", "amountNoTaxHome", "quantity"})) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean _checkCancelVerify(Context ctx, IObjectPK pk1, IObjectPK pk2) throws BOSException, SaleExpenseInvoiceException, EASBizException {
        CoreBaseInfo info1 = this.getValue(ctx, pk1);
        CoreBaseInfo info2 = this.getValue(ctx, pk2);
        if (info1 != null && info1 instanceof SalesExpenseInvoiceInfo && info2 != null && info2 instanceof SalesExpenseInvoiceInfo) {
            return this.checkIdenticalOfTwoInfo((SalesExpenseInvoiceInfo)info1, (SalesExpenseInvoiceInfo)info2);
        }
        throw new SaleExpenseInvoiceException(SaleExpenseInvoiceException.CHECKCANCELVERIFYPKNOTFIND);
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SalesExpenseInvoiceInfo salesExpInvoiceInfo = (SalesExpenseInvoiceInfo)model;
        if (salesExpInvoiceInfo.getCompanyOrgUnit() != null) {
            ICompanyOrgUnit icompanyOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo info = icompanyOrg.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(salesExpInvoiceInfo.getCompanyOrgUnit().getId()));
            return info;
        }
        return null;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SalesExpenseInvoiceInfo info = (SalesExpenseInvoiceInfo)model;
        if (info.getBizDate() == null) {
            info.setBizDate(new Date(System.currentTimeMillis()));
        }
        SalesExpenseInvoiceEntryCollection entrys = info.getEntries();
        int length = entrys.size();
        for (int i = 0; i < length; ++i) {
            this.setZero(entrys.get(i));
        }
        IObjectPK pk = super._submit(ctx, model);
        if (SCMServerUtils.isAuditAfterSubmitSaleInv((Context)ctx, (String)info.getCompanyOrgUnit().getId().toString())) {
            this._audit(ctx, pk);
        }
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SalesExpenseInvoiceInfo info = (SalesExpenseInvoiceInfo)model;
        if (info.getInvoiceDate() == null) {
            info.setBizDate(info.getInvoiceDate());
        } else {
            info.setBizDate(new Date(System.currentTimeMillis()));
        }
        SalesExpenseInvoiceEntryCollection entrys = info.getEntries();
        int length = entrys.size();
        for (int i = 0; i < length; ++i) {
            this.setZero(entrys.get(i));
        }
        IObjectPK pk = super._save(ctx, model);
        return pk;
    }

    private void setZero(SalesExpenseInvoiceEntryInfo entry) {
        String[] fields = new String[]{"amount", "localAmount", "tax", "localTax", "nonTaxAmount", "localNonTaxAmount", "price", "qty", "taxRate"};
        this.setBigDecimalZeros(entry, fields);
    }

    private void setBigDecimalZeros(SalesExpenseInvoiceEntryInfo entry, String[] fields) {
        BigDecimal zero = new BigDecimal("0.00");
        Object[] zeros = new BigDecimal[]{zero};
        int length = fields.length;
        for (int i = 0; i < length; ++i) {
            String getMethodName = "get" + fields[i].substring(0, 1).toUpperCase() + fields[i].substring(1);
            String setMethodName = "set" + fields[i].substring(0, 1).toUpperCase() + fields[i].substring(1);
            try {
                Method getMethod = SalesExpenseInvoiceEntryInfo.class.getMethod(getMethodName, null);
                Method setMethod = SalesExpenseInvoiceEntryInfo.class.getMethod(setMethodName, BigDecimal.class);
                if (getMethod == null || getMethod.invoke((Object)entry, null) != null) continue;
                setMethod.invoke((Object)entry, zeros);
                continue;
            }
            catch (SecurityException e) {
                logger.error((Object)e);
                continue;
            }
            catch (NoSuchMethodException e) {
                logger.error((Object)e);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK pk, IObjectValue reasonInfo) throws BOSException, EASBizException {
        CoreBaseInfo info = this.getValue(ctx, pk);
        ReasonCodeInfo rInfo = (ReasonCodeInfo)reasonInfo;
        if (info != null && info instanceof SalesExpenseInvoiceInfo) {
            SalesExpenseInvoiceInfo saleInfo = (SalesExpenseInvoiceInfo)info;
            if (saleInfo.getBaseStatus().getValue() != 2) {
                throw new SaleExpenseInvoiceException(SaleExpenseInvoiceException.STATECANNOTCANCELBILL);
            }
            saleInfo.setBaseStatus(BillBaseStatusEnum.DELETED);
            saleInfo.setReason(rInfo.getName());
            this.update(ctx, pk, (CoreBaseInfo)saleInfo);
            if (saleInfo.isIsReversed()) {
                SalesExpenseInvoiceInfo srcInfo = (SalesExpenseInvoiceInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(saleInfo.getSourceBillId()));
                srcInfo.setIsReversed(false);
                srcInfo.setReversingStatus(ReversingStateEnum.UNREVERSED);
                super.cancelWithLog(ctx, srcInfo);
                super._update(ctx, (IObjectPK)new ObjectUuidPK(srcInfo.getId()), (IObjectValue)srcInfo);
            }
        } else {
            throw new SaleExpenseInvoiceException(SaleExpenseInvoiceException.ENTITYNOTEXISTS);
        }
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK pk, String reason) throws BOSException, EASBizException {
        CoreBaseInfo info = this.getValue(ctx, pk);
        String rInfo = reason;
        if (info != null && info instanceof SalesExpenseInvoiceInfo) {
            SalesExpenseInvoiceInfo saleInfo = (SalesExpenseInvoiceInfo)info;
            if (saleInfo.getBaseStatus().getValue() != 2) {
                throw new SaleExpenseInvoiceException(SaleExpenseInvoiceException.STATECANNOTCANCELBILL);
            }
            saleInfo.setBaseStatus(BillBaseStatusEnum.DELETED);
            saleInfo.setReason(rInfo);
            this.update(ctx, pk, (CoreBaseInfo)saleInfo);
            if (saleInfo.isIsReversed()) {
                SalesExpenseInvoiceInfo srcInfo = (SalesExpenseInvoiceInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(saleInfo.getSourceBillId()));
                srcInfo.setIsReversed(false);
                srcInfo.setReversingStatus(ReversingStateEnum.UNREVERSED);
                super.cancelWithLog(ctx, srcInfo);
                super._update(ctx, (IObjectPK)new ObjectUuidPK(srcInfo.getId()), (IObjectValue)srcInfo);
            }
        } else {
            throw new SaleExpenseInvoiceException(SaleExpenseInvoiceException.ENTITYNOTEXISTS);
        }
    }

    public static boolean isInvoiceSettled(SalesExpenseInvoiceInfo salesExpenseInvoiceInfo) {
        boolean isSettled = false;
        return isSettled;
    }

    private void canReverse(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SalesExpenseInvoiceInfo info = (SalesExpenseInvoiceInfo)this.getValue(ctx, pk);
        if (!info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new SaleExpenseInvoiceException(SaleExpenseInvoiceException.REVERSE_NEED_AUDIT);
        }
        if (SalesExpenseInvoiceControllerBean.isInvoiceSettled(info)) {
            throw new SaleExpenseInvoiceException(SaleExpenseInvoiceException.REVERSE_NEED_UNSETTL);
        }
        if (info.getReversingStatus().equals((Object)ReversingStateEnum.REVERSED)) {
            throw new SaleExpenseInvoiceException(SaleExpenseInvoiceException.CANNOT_REVERSE);
        }
        if (info.isIsReversed()) {
            throw new SaleExpenseInvoiceException(SaleExpenseInvoiceException.REVERSE_NEED_BLUE);
        }
    }

    @Override
    protected IObjectPK[] _createReverse(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        SalesExpenseInvoiceInfo srcInfo = null;
        SalesExpenseInvoiceInfo destInfo = null;
        IObjectPK[] newPKs = new IObjectPK[pks.length];
        for (int i = 0; i < pks.length; ++i) {
            srcInfo = this.getSalesExpenseInvoiceInfo(ctx, pks[i]);
            this.canReverse(ctx, pks[i]);
            destInfo = (SalesExpenseInvoiceInfo)srcInfo.clone();
            String oldnumber = srcInfo.getNumber();
            destInfo.setId(null);
            destInfo.setNumber(oldnumber + "-R");
            if (this.isSameNumber(ctx, pks[i], (IObjectValue)destInfo)) {
                destInfo.setNumber(oldnumber + "-R-1");
            }
            destInfo.setIsReversed(true);
            destInfo.setInvoiceDate(new Timestamp(System.currentTimeMillis()));
            if (destInfo.getTotalAmount() != null) {
                destInfo.setTotalAmount(destInfo.getTotalAmount().negate());
            }
            if (destInfo.getTotalTax() != null) {
                destInfo.setTotalTax(destInfo.getTotalTax().negate());
            }
            if (destInfo.getTotalTaxAmount() != null) {
                destInfo.setTotalTaxAmount(destInfo.getTotalTaxAmount().negate());
            }
            destInfo.setSourceBillId(srcInfo.getId().toString());
            BillTypeInfo billTypeInfo = new BillTypeInfo();
            destInfo.setSourceBillType(billTypeInfo);
            destInfo.setAuditor(null);
            destInfo.setAuditTime(null);
            destInfo.setModifier(null);
            destInfo.setModificationTime(null);
            destInfo.setLastUpdateUser(null);
            destInfo.setLastUpdateTime(null);
            destInfo.setCreator(null);
            destInfo.setCreateTime(null);
            SalesExpenseInvoiceEntryCollection collection = destInfo.getEntries();
            SalesExpenseInvoiceEntryInfo entryInfo = null;
            int num = collection.size();
            for (int j = 0; j < num; ++j) {
                entryInfo = collection.get(j);
                entryInfo.setId(null);
                entryInfo.setParent(null);
                if (entryInfo.getQty() != null) {
                    entryInfo.setQty(entryInfo.getQty().negate());
                }
                if (entryInfo.getAmount() != null) {
                    entryInfo.setAmount(entryInfo.getAmount().negate());
                }
                if (entryInfo.getLocalAmount() != null) {
                    entryInfo.setLocalAmount(entryInfo.getLocalAmount().negate());
                }
                if (entryInfo.getLocalNonTaxAmount() != null) {
                    entryInfo.setLocalNonTaxAmount(entryInfo.getLocalNonTaxAmount().negate());
                }
                if (entryInfo.getTax() != null) {
                    entryInfo.setTax(entryInfo.getTax().negate());
                }
                if (entryInfo.getLocalTax() != null) {
                    entryInfo.setLocalTax(entryInfo.getLocalTax().negate());
                }
                if (entryInfo.getNonTaxAmount() == null) continue;
                entryInfo.setNonTaxAmount(entryInfo.getNonTaxAmount().negate());
            }
            ISalesExpenseInvoice is = SalesExpenseInvoiceFactory.getLocalInstance(ctx);
            newPKs[i] = is.submit((CoreBaseInfo)destInfo);
            srcInfo.setIsReversed(true);
            srcInfo.setReversingStatus(ReversingStateEnum.REVERSED);
            this._update(ctx, pks[i], (IObjectValue)srcInfo);
            super.createReverseWithLog(ctx, srcInfo);
            String strid = newPKs[i].toString();
            String bosType = strid.substring(strid.length() - 8);
            BOTRelationInfo info = new BOTRelationInfo();
            info.setSrcObjectID(pks[i].toString());
            info.setDestEntityID(bosType);
            info.setSrcEntityID(bosType);
            info.setDestObjectID(strid);
            info.setOperatorID("unknown");
            info.setType(0);
            BOTRelationFactory.getLocalInstance((Context)ctx).addnew(info);
        }
        return newPKs;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.canDelete(ctx, pk);
        SalesExpenseInvoiceInfo info = (SalesExpenseInvoiceInfo)this.getValue(ctx, pk);
        super._delete(ctx, pk);
        if (info.isIsReversed()) {
            SalesExpenseInvoiceInfo srcInfo = (SalesExpenseInvoiceInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
            srcInfo.setIsReversed(false);
            srcInfo.setReversingStatus(ReversingStateEnum.UNREVERSED);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(srcInfo.getId()), (IObjectValue)srcInfo);
        }
    }

    private void canDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SalesExpenseInvoiceInfo info = (SalesExpenseInvoiceInfo)this.getValue(ctx, pk);
        if (!info.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED) && !info.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED)) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.DELETE_NEED_SUBMIT);
        }
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("companyOrgUnit.*"));
        SalesExpenseInvoiceInfo sInfo = this.getSalesExpenseInvoiceInfo(ctx, pk, selectors);
        return sInfo.getCompanyOrgUnit();
    }

    protected boolean isCheckCloseAccount() throws EASBizException, BOSException {
        return true;
    }

    @Override
    protected void _createReverseWithLog(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _cancelWithLog(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected String _getBizUnitOrgID(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CompanyOrgUnitInfo unitInfo;
        if (model != null && (unitInfo = ((SalesExpenseInvoiceInfo)model).getCompanyOrgUnit()) != null) {
            return unitInfo.getId().toString();
        }
        return null;
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo botRelation = (BOTRelationInfo)bOTRelationInfo;
        if (botRelation != null && !"2652E01E".equals(botRelation.getDestEntityID())) {
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
            return;
        }
        if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
            SalesExpenseInvoiceInfo salesExpInvInfo = (SalesExpenseInvoiceInfo)srcBillVO;
            IVoucher iv = VoucherFactory.getLocalInstance((Context)ctx);
            VoucherInfo vinfo = (VoucherInfo)iv.getValue((IObjectPK)new ObjectStringPK(botRelation.getDestObjectID()));
            salesExpInvInfo.setVoucherNumber(vinfo.getNumber());
            salesExpInvInfo.setFiVouchered(true);
        } else if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
            SalesExpenseInvoiceInfo salesExpInvInfo = (SalesExpenseInvoiceInfo)srcBillVO;
            salesExpInvInfo.setVoucherNumber(null);
            salesExpInvInfo.setFiVouchered(false);
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }
}

