/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.ExpenseItemCollection;
import com.kingdee.eas.basedata.scm.common.ExpenseItemFactory;
import com.kingdee.eas.basedata.scm.common.ExpenseItemInfo;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.basedata.scm.common.IBizType;
import com.kingdee.eas.basedata.scm.common.IExpenseItem;
import com.kingdee.eas.basedata.scm.common.IReasonCode;
import com.kingdee.eas.basedata.scm.common.ReasonCodeFactory;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.RedBlueEnum;
import com.kingdee.eas.scm.common.SettlementStateEnum;
import com.kingdee.eas.scm.sd.sale.ISalesExpenseInvoice;
import com.kingdee.eas.scm.sd.sale.SalesExpenseInvoiceCollection;
import com.kingdee.eas.scm.sd.sale.SalesExpenseInvoiceEntryCollection;
import com.kingdee.eas.scm.sd.sale.SalesExpenseInvoiceEntryInfo;
import com.kingdee.eas.scm.sd.sale.SalesExpenseInvoiceFactory;
import com.kingdee.eas.scm.sd.sale.SalesExpenseInvoiceInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;

public class SalesExpenseInvoiceDataImport
extends AbstractDataTransmission {
    String[] BIGDECIMAL_FIELDS = new String[]{"FExchageRate", "FTotalAmount", "FTotalTax", "FTotalTaxAmount"};
    String[] BIGDECIMAL_OBJ = new String[]{"exchangeRate", "totalAmount", "totalTax", "totalTaxAmount"};
    String[] STRING_FIELDS = new String[]{"FNumber", "FSummary", "FRemark", "FVoucherNumber", "FReverseInvNumber", "FDescription"};
    String[] STRING_OBJS = new String[]{"number", "summary", "remark", "voucherNumber", "reverseInvNumber", "description"};
    String[] DATE_FIELDS = new String[]{"FAuditTime", "FInvoiceDate", "FAccountDate", "FModificationTime", "FCreateTime", "FLastUpdateTime", "FBizDate"};
    String[] DATE_OBJS = new String[]{"auditTime", "invoiceDate", "accountDate", "modificationTime", "createTime", "lastUpdateTime", "bizDate"};
    String[] BOOLEAN_FIELDS = new String[]{"FFiVouchered", "FIsReversed"};
    String[] BOOLEAN_OBJS = new String[]{"fiVouchered", "isReversed"};
    String[] INTEGER_FIELDS = new String[]{"FYear", "FPeriod"};
    String[] INTEGER_OBJS = new String[]{"year", "period"};
    String[] BIGDECIMAL_FIELDS_EN = new String[]{"FQty", "FPrice", "FAmount", "FLocalAmount", "FTaxRate", "FTax", "FLocalTax", "FNonTaxAmount", "FLocalNonTaxAmount"};
    String[] BIGDECIMAL_OBJ_EN = new String[]{"qty", "price", "amount", "localAmount", "taxRate", "tax", "localTax", "nonTaxAmount", "localNonTaxAmount"};
    String[] STRING_FIELDS_EN = new String[]{"FEntryRemark"};
    String[] STRING_OBJS_EN = new String[]{"remark"};

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return SalesExpenseInvoiceFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase isalesExpenseInvoice = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !isalesExpenseInvoice.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                isalesExpenseInvoice.addnew(coreBaseInfo);
            } else {
                isalesExpenseInvoice.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Object value;
        Object o;
        int i;
        Object value2;
        SalesExpenseInvoiceInfo salesExpenseInvoiceInfo = new SalesExpenseInvoiceInfo();
        Object numberdata = ((DataToken)hsData.get((Object)"FNumber")).data;
        String str = null;
        if (numberdata != null) {
            str = numberdata.toString();
            if (str != null && str.trim().length() > 0) {
                salesExpenseInvoiceInfo.setNumber(str);
                try {
                    ISalesExpenseInvoice iExpenseInvoice = SalesExpenseInvoiceFactory.getLocalInstance(ctx);
                    SalesExpenseInvoiceCollection collection = iExpenseInvoice.getSalesExpenseInvoiceCollection("where number ='" + str + "'");
                    if (collection != null && collection.size() > 0) {
                        salesExpenseInvoiceInfo = iExpenseInvoice.getSalesExpenseInvoiceInfo((IObjectPK)new ObjectUuidPK(collection.get(0).getId()));
                    }
                }
                catch (Exception e) {
                    Logger.error((Throwable)e);
                }
            }
        } else {
            throw new TaskExternalException("number  not found!!!!");
        }
        for (int i2 = 0; i2 < this.BIGDECIMAL_FIELDS.length; ++i2) {
            try {
                Object o2 = ((DataToken)hsData.get((Object)this.BIGDECIMAL_FIELDS[i2])).data;
                if (o2 == null || o2.toString().trim().length() <= 0 || (value2 = new BigDecimal(o2.toString())) == null) continue;
                salesExpenseInvoiceInfo.setBigDecimal(this.BIGDECIMAL_OBJ[i2], (BigDecimal)value2);
                continue;
            }
            catch (NumberFormatException nex) {
                Logger.error((Throwable)nex);
                throw new TaskExternalException(this.BIGDECIMAL_OBJ[i2] + " format error, it must be a number!!!");
            }
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        for (i = 0; i < this.DATE_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.DATE_FIELDS[i])).data;
            if (o == null || o.toString().length() <= 0) continue;
            try {
                o = df.parse(o.toString());
            }
            catch (ParseException pex) {
                Logger.error((Throwable)pex);
                throw new TaskExternalException(this.DATE_FIELDS[i] + " format error, it must be a date String, xxxx-xx-xx!!!current date is " + o.toString());
            }
            if (o == null || !(o instanceof Date) || (value = (Date)o) == null) continue;
            salesExpenseInvoiceInfo.setDate(this.DATE_OBJS[i], (Date)value);
        }
        for (i = 0; i < this.BOOLEAN_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.BOOLEAN_FIELDS[i])).data;
            if (o == null || o.toString().trim().length() <= 0 || (value = o.toString()) == null) continue;
            salesExpenseInvoiceInfo.setBoolean(this.BOOLEAN_OBJS[i], this.getBooleanValue((String)value));
        }
        for (i = 0; i < this.STRING_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.STRING_FIELDS[i])).data;
            if (o == null) continue;
            value = o.toString();
            salesExpenseInvoiceInfo.setString(this.STRING_OBJS[i], (String)value);
        }
        for (i = 0; i < this.INTEGER_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.INTEGER_FIELDS[i])).data;
            if (o == null || o.toString().equals("")) continue;
            value = new Integer(o.toString());
            salesExpenseInvoiceInfo.setInt(this.INTEGER_OBJS[i], (Integer)value);
        }
        Object data = ((DataToken)hsData.get((Object)"FBaseStatus")).data;
        value2 = null;
        if (data != null && (value2 = data.toString()) != null) {
            salesExpenseInvoiceInfo.setBaseStatus(this.getBaseStatusValue((String)value2));
        }
        if ((data = ((DataToken)hsData.get((Object)"FRedBlueType")).data) != null && (value2 = data.toString()) != null) {
            salesExpenseInvoiceInfo.setRedBlueType(this.getRedBlueEnum((String)value2));
        }
        try {
            IBillType iBillType;
            IBizType ibizType;
            IReasonCode iReasonCode;
            ICustomer icustomer;
            ICompanyOrgUnit icompanyOrg;
            SettlementTypeInfo info;
            SettlementTypeCollection collection;
            FilterInfo filter;
            EntityViewInfo viewInfo;
            CurrencyInfo info2;
            ICurrency icurreny;
            CurrencyCollection collection2;
            CtrlUnitInfo cuinfo;
            ICtrlUnit ictrlUnit;
            CtrlUnitCollection cuCollection;
            IUser iuser = UserFactory.getLocalInstance((Context)ctx);
            UserInfo userInfo = null;
            data = ((DataToken)hsData.get((Object)"FCreatorID")).data;
            if (data != null && (userInfo = this.getUserFromNumber(iuser, str = data.toString())) != null) {
                salesExpenseInvoiceInfo.setCreator(userInfo);
            }
            if ((data = ((DataToken)hsData.get((Object)"FLastUpdateUserID")).data) != null && (userInfo = this.getUserFromNumber(iuser, str = data.toString())) != null) {
                salesExpenseInvoiceInfo.setLastUpdateUser(userInfo);
            }
            if ((data = ((DataToken)hsData.get((Object)"FControlUnitID")).data) != null && (str = ((DataToken)hsData.get((Object)"FControlUnitID")).data.toString()) != null && str.length() > 0 && (cuCollection = (ictrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx)).getCtrlUnitCollection("where number='" + str + "'")) != null && cuCollection.size() > 0 && (cuinfo = cuCollection.get(0)) != null) {
                salesExpenseInvoiceInfo.setCU(cuinfo);
            }
            if ((data = ((DataToken)hsData.get((Object)"FAuditorID")).data) != null && (userInfo = this.getUserFromNumber(iuser, str = data.toString())) != null) {
                salesExpenseInvoiceInfo.setAuditor(userInfo);
            }
            if ((data = ((DataToken)hsData.get((Object)"FCurrencyID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection2 = (icurreny = CurrencyFactory.getLocalInstance((Context)ctx)).getCurrencyCollection("where number='" + str + "'")) != null && collection2.size() > 0 && (info2 = collection2.get(0)) != null) {
                salesExpenseInvoiceInfo.setCurrency(info2);
            }
            if ((data = ((DataToken)hsData.get((Object)"FSettlementTypeID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                ISettlementType isettlement = SettlementTypeFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                collection = isettlement.getSettlementTypeCollection(viewInfo);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    salesExpenseInvoiceInfo.setSettlementType(info);
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FCompanyOrgUnitID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection2 = (icompanyOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx)).getCompanyOrgUnitCollection("where number='" + str + "'")) != null && collection2.size() > 0 && (info2 = collection2.get(0)) != null) {
                salesExpenseInvoiceInfo.setCompanyOrgUnit((CompanyOrgUnitInfo)info2);
            }
            if ((data = ((DataToken)hsData.get((Object)"FSaleOrgUnitID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                ISaleOrgUnit isaleOrg = SaleOrgUnitFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                collection = isaleOrg.getSaleOrgUnitCollection(viewInfo);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    salesExpenseInvoiceInfo.setSaleOrgUnit((SaleOrgUnitInfo)info);
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FCustomerID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection2 = (icustomer = CustomerFactory.getLocalInstance((Context)ctx)).getCustomerCollection("where number='" + str + "'")) != null && collection2.size() > 0 && (info2 = collection2.get(0)) != null) {
                salesExpenseInvoiceInfo.setCustomer((CustomerInfo)info2);
            }
            if ((data = ((DataToken)hsData.get((Object)"FPaymentTypeID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                IPaymentType ipaymentType = PaymentTypeFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                collection = ipaymentType.getPaymentTypeCollection(viewInfo);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    salesExpenseInvoiceInfo.setPaymentType((PaymentTypeInfo)info);
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FReasonCodeID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection2 = (iReasonCode = ReasonCodeFactory.getLocalInstance((Context)ctx)).getReasonCodeCollection("where number='" + str + "'")) != null && collection2.size() > 0 && (info2 = collection2.get(0)) != null) {
                salesExpenseInvoiceInfo.setReasonCode((ReasonCodeInfo)info2);
            }
            if ((data = ((DataToken)hsData.get((Object)"FAdminOrgUnitID")).data) != null && (str = data.toString()) != null && str.length() > 0) {
                IAdminOrgUnit iadminorg = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                collection = iadminorg.getAdminOrgUnitCollection(viewInfo);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    salesExpenseInvoiceInfo.setAdminOrgUnit((AdminOrgUnitInfo)info);
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FBizTypeID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection2 = (ibizType = BizTypeFactory.getLocalInstance((Context)ctx)).getBizTypeCollection("where number='" + str + "'")) != null && collection2.size() > 0 && (info2 = collection2.get(0)) != null) {
                salesExpenseInvoiceInfo.setBizType((BizTypeInfo)info2);
            }
            if ((data = ((DataToken)hsData.get((Object)"FBillTypeID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection2 = (iBillType = BillTypeFactory.getLocalInstance((Context)ctx)).getBillTypeCollection("where number='" + str + "'")) != null && collection2.size() > 0 && (info2 = collection2.get(0)) != null) {
                salesExpenseInvoiceInfo.setBillType((BillTypeInfo)info2);
            }
            if ((data = ((DataToken)hsData.get((Object)"FModifierID")).data) != null && (userInfo = this.getUserFromNumber(iuser, str = data.toString())) != null) {
                salesExpenseInvoiceInfo.setModifier(userInfo);
            }
        }
        catch (Exception ex) {
            Logger.error((Throwable)ex);
        }
        SalesExpenseInvoiceEntryInfo entryInfo = null;
        boolean isUpdateEntry = false;
        data = ((DataToken)hsData.get((Object)"FSeq")).data;
        if (data != null && data.toString().trim().length() > 0) {
            int seq = Integer.parseInt(data.toString());
            SalesExpenseInvoiceEntryCollection entryCollection = salesExpenseInvoiceInfo.getEntries();
            int num = entryCollection.size();
            for (int i3 = 0; i3 < num; ++i3) {
                SalesExpenseInvoiceEntryInfo tempentryInfo = entryCollection.get(i3);
                if (tempentryInfo.getSeq() != seq) continue;
                entryInfo = tempentryInfo;
                isUpdateEntry = true;
            }
            if (!isUpdateEntry) {
                entryInfo = new SalesExpenseInvoiceEntryInfo();
                entryInfo.setParent(salesExpenseInvoiceInfo);
                entryInfo.setSeq(seq);
                entryCollection.add(entryInfo);
            }
        } else {
            SalesExpenseInvoiceEntryCollection entryCollection = salesExpenseInvoiceInfo.getEntries();
            int seq = entryCollection.size() + 1;
            entryInfo = new SalesExpenseInvoiceEntryInfo();
            entryInfo.setParent(salesExpenseInvoiceInfo);
            entryInfo.setSeq(seq);
            entryCollection.add(entryInfo);
        }
        this.handleEntry(entryInfo, hsData, ctx);
        return salesExpenseInvoiceInfo;
    }

    private void handleEntry(SalesExpenseInvoiceEntryInfo entryInfo, Hashtable hsData, Context ctx) throws TaskExternalException {
        Object value;
        Object o;
        int i;
        for (i = 0; i < this.BIGDECIMAL_FIELDS_EN.length; ++i) {
            try {
                o = ((DataToken)hsData.get((Object)this.BIGDECIMAL_FIELDS_EN[i])).data;
                if (o == null || o.toString().trim().length() <= 0 || (value = new BigDecimal(o.toString())) == null) continue;
                entryInfo.setBigDecimal(this.BIGDECIMAL_OBJ_EN[i], (BigDecimal)value);
                continue;
            }
            catch (NumberFormatException nex) {
                Logger.error((Throwable)nex);
                throw new TaskExternalException(this.BIGDECIMAL_OBJ_EN[i] + " format error, it must be a number!!!");
            }
        }
        for (i = 0; i < this.STRING_FIELDS_EN.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.STRING_FIELDS_EN[i])).data;
            if (o == null) continue;
            value = o.toString();
            entryInfo.setString(this.STRING_OBJS_EN[i], (String)value);
        }
        Object data = ((DataToken)hsData.get((Object)"FSettlementStatus")).data;
        String value2 = null;
        if (data != null && (value2 = data.toString()) != null) {
            entryInfo.setSettlementStatus(this.getSettlementStateValue(value2));
        }
        try {
            IMeasureUnit iunit;
            ExpenseItemInfo info;
            IExpenseItem iExpenseItem;
            ExpenseItemCollection collection;
            data = ((DataToken)hsData.get((Object)"FReasonCodeID")).data;
            String str = null;
            data = ((DataToken)hsData.get((Object)"FExpenseItemID")).data;
            if (data != null && (str = data.toString()) != null && str.length() > 0 && (collection = (iExpenseItem = ExpenseItemFactory.getLocalInstance((Context)ctx)).getExpenseItemCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                entryInfo.setExpenseItem(info);
            }
            if ((data = ((DataToken)hsData.get((Object)"FMeasureUnitID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection = (iunit = MeasureUnitFactory.getLocalInstance((Context)ctx)).getMeasureUnitCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                entryInfo.setMeasureUnit((MeasureUnitInfo)info);
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    private boolean getBooleanValue(String value) {
        return !(value = value.trim()).equalsIgnoreCase("N") && !value.equalsIgnoreCase("NO") && !value.equalsIgnoreCase("0");
    }

    private BillBaseStatusEnum getBaseStatusValue(String value) {
        BillBaseStatusEnum tSaved = BillBaseStatusEnum.TEMPORARILYSAVED;
        if (value != null) {
            value = value.trim();
            List EnumList = BillBaseStatusEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                BillBaseStatusEnum enumList = (BillBaseStatusEnum)EnumList.get(i);
                String enumValue = String.valueOf(enumList.getValue());
                String enumName = enumList.getName();
                String enumAlias = enumList.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                tSaved = enumList;
                break;
            }
        }
        return tSaved;
    }

    private RedBlueEnum getRedBlueEnum(String value) {
        RedBlueEnum color = RedBlueEnum.BLUE;
        if (value != null) {
            value = value.trim();
            List EnumList = RedBlueEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                RedBlueEnum enumList = (RedBlueEnum)EnumList.get(i);
                String enumValue = String.valueOf(enumList.getValue());
                String enumName = enumList.getName();
                String enumAlias = enumList.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                color = enumList;
                break;
            }
        }
        return color;
    }

    private UserInfo getUserFromNumber(IUser iuser, String number) throws BOSException {
        UserCollection users;
        UserInfo userInfo = null;
        if (number != null && number.trim().length() > 0 && (users = iuser.getUserCollection("where number='" + number + "'")) != null && users.size() > 0) {
            userInfo = users.get(0);
        }
        return userInfo;
    }

    private SettlementStateEnum getSettlementStateValue(String value) {
        SettlementStateEnum unsettled = SettlementStateEnum.UNSETTLED;
        if (value != null) {
            value = value.trim();
            List EnumList = SettlementStateEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                SettlementStateEnum enumList = (SettlementStateEnum)EnumList.get(i);
                String enumValue = String.valueOf(enumList.getValue());
                String enumName = enumList.getName();
                String enumAlias = enumList.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                unsettled = enumList;
                break;
            }
        }
        return unsettled;
    }
}

