/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryInfo;
import com.kingdee.eas.scm.im.inv.SerialNumberStatusEnum;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.sd.sale.report.app.AbstractConsignIssueBalanceFacadeControllerBean;
import com.kingdee.eas.scm.util.constant.RecIssueTypeConstant;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConsignIssueBalanceFacadeControllerBean
extends AbstractConsignIssueBalanceFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private String resFile = "com.kingdee.eas.scm.sd.sale.report.ConsignSaleBalanceResource";
    private String sp = "\r\n";
    private String language = "L2";
    private RptParams result = null;
    private static HashMap map = new HashMap();

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        return null;
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        String id;
        int i;
        int length;
        Object[] obj;
        String storageOrgUnitIDs = null;
        String saleOrgUnitIDs = null;
        String customerID = null;
        String balanceCustomerID = null;
        String materialNumberFrom = null;
        String materialNumberTo = null;
        this.language = this.getLoc(ctx);
        Object object = params.getObject("index");
        Object storageOrgUnit = params.getObject("storageOrgUnit");
        Object saleOrgUnit = params.getObject("saleOrgUnit");
        CustomerInfo customer = null;
        CustomerInfo balanceCustomer = null;
        if (params.getObject("customer") != null) {
            customer = (CustomerInfo)params.getObject("customer");
            customerID = customer.getId().toString();
        }
        if (params.getObject("balanceCustomer") != null) {
            balanceCustomer = (CustomerInfo)params.getObject("balanceCustomer");
            balanceCustomerID = balanceCustomer.getId().toString();
        }
        MaterialInfo materialFrom = null;
        if (params.getObject("materialFrom") != null) {
            materialFrom = (MaterialInfo)params.getObject("materialFrom");
            materialNumberFrom = materialFrom.getNumber();
        }
        MaterialInfo materialTo = null;
        if (params.getObject("materialTo") != null) {
            materialTo = (MaterialInfo)params.getObject("materialTo");
            materialNumberTo = materialTo.getNumber();
        }
        Date verifyDate = (Date)params.getObject("verifyDate");
        boolean flag = false;
        StringBuffer bf = new StringBuffer();
        if (storageOrgUnit instanceof Object[]) {
            obj = (Object[])storageOrgUnit;
            if (obj != null) {
                bf.append("(");
                length = obj.length;
                for (i = 0; i < length; ++i) {
                    if (null == obj[i]) {
                        flag = false;
                        break;
                    }
                    id = ((OrgUnitInfo)obj[i]).getId().toString();
                    bf.append("'").append(id).append("'");
                    if (i != length - 1) {
                        bf.append(",");
                    }
                    flag = true;
                }
                bf.append(")");
                storageOrgUnitIDs = flag ? bf.toString() : null;
                flag = false;
            }
        } else if (storageOrgUnit instanceof StorageOrgUnitInfo) {
            StringBuffer storageID = new StringBuffer();
            storageID.append("('").append(((StorageOrgUnitInfo)storageOrgUnit).getId().toString()).append("')");
            storageOrgUnitIDs = storageID.toString();
        }
        if (saleOrgUnit instanceof Object[]) {
            bf.setLength(0);
            obj = (Object[])saleOrgUnit;
            if (obj != null) {
                bf.append("(");
                length = obj.length;
                for (i = 0; i < length; ++i) {
                    if (null == obj[i]) {
                        flag = false;
                        break;
                    }
                    id = ((OrgUnitInfo)obj[i]).getId().toString();
                    bf.append("'").append(id).append("'");
                    if (i != length - 1) {
                        bf.append(",");
                    }
                    flag = true;
                }
                bf.append(")");
                saleOrgUnitIDs = flag ? bf.toString() : null;
                flag = false;
            }
        }
        if (customer != null) {
            CustomerInfo customerInfo = customer;
            customerID = customerInfo.getId().toString();
        }
        params.setString("storageOrgUnitIDs", null == storageOrgUnit ? "('')" : storageOrgUnitIDs);
        params.setString("saleOrgUnitIDs", saleOrgUnitIDs);
        params.setString("customerID", customerID);
        params.setString("balanceCustomerID", balanceCustomerID);
        params.setString("materialNumberFrom", materialNumberFrom);
        params.setString("materialNumberTo", materialNumberTo);
        params.setObject("verifyDate", (Object)verifyDate);
        if (null != object && "topTable".equals(object)) {
            this.createTopTable(ctx, params);
        } else if (null != object && "bottomTable".equals(object)) {
            this.createBottomTable(ctx, params);
        }
        return this.result;
    }

    protected RptParams _query(Context ctx, RptParams params, int start, int length) throws BOSException, EASBizException {
        this.language = this.getLoc(ctx);
        String index = params.getString("index");
        RptParams para = new RptParams();
        if ("topTable".equals(index)) {
            StringBuffer totalsql = new StringBuffer();
            totalsql.append("select FCurStoreQty,FCurBalanceQty from ").append(params.getString("tempTable1"));
            totalsql.append(" where FIsTotal='1'");
            RptRowSet tatalrs1 = this.executeQuery(totalsql.toString(), null, ctx);
            String sql = this.topQuerySQL(params);
            RptRowSet rs1 = this.executeQuery(sql, null, start, length, ctx);
            para.setObject("rowset1", (Object)rs1);
            para.setObject("totalrowset", (Object)tatalrs1);
        } else if ("bottomTable".equals(index)) {
            String sql = this.bottomQuerySQL(ctx, params);
            RptRowSet rs2 = this.executeQuery(sql, null, start, length == 0 ? 1 : length, ctx);
            para.setObject("rowset2", (Object)rs2);
        }
        return para;
    }

    private void createTopTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTable(params.getString("tempTable1"), ctx);
        String tempTable1 = this.getTempTableName("tempTable1", ctx);
        this.executeSQL(ctx, this.getInventoryTempTableSQL(tempTable1));
        params.setString("tempTable1", tempTable1);
        String sql = this.getInventorySQL(ctx, params, tempTable1);
        this.executeSQL(ctx, sql);
        String countSql = "select count(1) cc from " + tempTable1;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count1 = rs.getInt(0);
        this.subtotal(ctx, tempTable1);
        if (null == this.result) {
            this.result = new RptParams();
        }
        this.result.setString("index", "topTable");
        this.result.setString("tempTable1", tempTable1);
        this.result.setObject("header1", (Object)this.createTopRptHeader(ctx));
        this.result.setInt("verticalCount1", count1);
        map.put("tempTable1", tempTable1);
    }

    private RptTableHeader createTopRptHeader(Context ctx) {
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        ArrayList<String> list = new ArrayList<String>();
        col = new RptTableColumn("FMaterialNumber");
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"materialNumber", (Context)ctx));
        col = new RptTableColumn("FMaterial");
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"material", (Context)ctx));
        col = new RptTableColumn("FModel");
        col.setWidth(100);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"model", (Context)ctx));
        col = new RptTableColumn("FCurStoreQty");
        col.setAligment(2);
        col.setWidth(100);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"curStoreQty", (Context)ctx));
        col = new RptTableColumn("FCurBalanceQty");
        col.setAligment(2);
        col.setWidth(100);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"curBalanceQty", (Context)ctx));
        col = new RptTableColumn("FAssistProperty");
        col.setWidth(100);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"assistProperty", (Context)ctx));
        col = new RptTableColumn("FBaseUnit");
        col.setWidth(100);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"baseUnit", (Context)ctx));
        col = new RptTableColumn("FStorageOrgUnit");
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"storageOrgUnit", (Context)ctx));
        col = new RptTableColumn("FCustomerNumber");
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"customerNumber", (Context)ctx));
        col = new RptTableColumn("FCustomer");
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"customer", (Context)ctx));
        col = new RptTableColumn("FQtyPrecision");
        col.setHided(true);
        col.setWidth(-1);
        header.addColumn(col);
        list.add("FQtyPrecision");
        col = new RptTableColumn("FStorageOrgUnitID");
        col.setHided(true);
        col.setWidth(-1);
        header.addColumn(col);
        list.add("FStorageOrgUnitID");
        col = new RptTableColumn("FMaterialID");
        col.setHided(true);
        col.setWidth(-1);
        header.addColumn(col);
        list.add("FMaterialID");
        col = new RptTableColumn("FCustomerID");
        col.setHided(true);
        col.setWidth(-1);
        header.addColumn(col);
        list.add("FCustomerID");
        col = new RptTableColumn("FAssistPropertyID");
        col.setHided(true);
        col.setWidth(-1);
        header.addColumn(col);
        list.add("FAssistPropertyID");
        int length = list.size();
        Object[][] obj = new Object[1][length];
        for (int i = 0; i < length; ++i) {
            obj[0][i] = list.get(i);
        }
        header.setLabels(obj, true);
        return header;
    }

    private String getInventorySQL(Context ctx, RptParams params, String tempTable) throws BOSException, EASBizException {
        StringBuffer bf = new StringBuffer();
        bf.append("INSERT INTO ").append(tempTable);
        bf.append(" (FID,FStorageOrgUnitID,FCompanyOrgUnitID,FMaterialID,FCustomerID,");
        bf.append("FAssistPropertyID,FBaseUnitID,FCurStoreQty,FCurBalanceQty,");
        bf.append("FQtyPrecision)").append(this.sp);
        bf.append("SELECT ").append(this.sp);
        bf.append("NEWBOSID('88888888'),").append(this.sp);
        bf.append("INVENTORY.FStorageOrgUnitID,").append(this.sp);
        bf.append("INVENTORY.FCompanyOrgUnitID,").append(this.sp);
        bf.append("INVENTORY.FMaterialID,").append(this.sp);
        bf.append("case when INVENTORY.FCustomerID = '").append("EgkAAABc3Xu/DAQO").append("' then ");
        bf.append(" null else INVENTORY.FCustomerID end ,").append(this.sp);
        bf.append("case when INVENTORY.FAssistPropertyID = '").append("EgkAAAA5EWALxvQu").append("' then ");
        bf.append(" null else INVENTORY.FAssistPropertyID end ,").append(this.sp);
        bf.append("INVENTORY.FBaseUnitID,").append(this.sp);
        bf.append("SUM(INVENTORY.FBaseQty) - sum(isnull(res.FReservationBaseQty,0)) AS FCurStoreQty,").append(this.sp);
        bf.append("0 AS FCurBalanceQty,").append(this.sp);
        bf.append("MULTIUNIT.FQtyPrecision").append(this.sp);
        bf.append(" FROM T_IM_Inventory INVENTORY").append(this.sp);
        bf.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIUNIT");
        bf.append(" ON (INVENTORY.FMaterialID = MULTIUNIT.FMaterialID");
        bf.append(" AND INVENTORY.FBaseUnitID = MULTIUNIT.FMeasureUnitID)").append(this.sp);
        bf.append(" INNER JOIN T_BD_Material materail ");
        bf.append(" ON INVENTORY.FMaterialID = materail.FID ");
        bf.append("LEFT JOIN (");
        bf.append("  Select FInventoryID, sum(FReservationBaseQty) as FReservationBaseQty");
        bf.append("  from T_IM_Reservation where FInventoryID IN (select FID from T_IM_Inventory) group by FInventoryID");
        bf.append(") res on res.FInventoryID = INVENTORY.FID ");
        bf.append(" WHERE INVENTORY.FStoreTypeID = '").append("181875d5-0105-1000-e000-011ac0a812fd97D461A6").append("'");
        bf.append(" AND INVENTORY.FBaseQty <> 0");
        bf.append(" AND FCurStoreQty <> 0");
        if (null != params.getString("storageOrgUnitIDs") && !params.getString("storageOrgUnitIDs").equalsIgnoreCase("")) {
            bf.append(" AND INVENTORY.FStorageOrgUnitID IN ").append(params.getString("storageOrgUnitIDs"));
        }
        if (null != params.getString("customerID") && !params.getString("customerID").equalsIgnoreCase("")) {
            bf.append(" AND INVENTORY.FCustomerID = '").append(params.getString("customerID")).append("'");
        }
        if (null != params.getString("materialNumberFrom") && !params.getString("materialNumberFrom").equalsIgnoreCase("")) {
            bf.append(" AND materail.FNumber >= '").append(params.getString("materialNumberFrom")).append("'");
        }
        if (null != params.getString("materialNumberTo") && !params.getString("materialNumberTo").equalsIgnoreCase("")) {
            bf.append(" AND materail.FNumber <= '").append(params.getString("materialNumberTo")).append("'");
        }
        bf.append(this.sp);
        bf.append("GROUP BY INVENTORY.FStorageOrgUnitID,INVENTORY.FCompanyOrgUnitID,INVENTORY.FCustomerID,");
        bf.append(this.sp);
        bf.append("INVENTORY.FMaterialID,INVENTORY.FAssistPropertyID,");
        bf.append("INVENTORY.FBaseUnitID,MULTIUNIT.FQtyPrecision");
        return bf.toString();
    }

    private void createBottomTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTable(params.getString("tempTable2"), ctx);
        String tempTable2 = this.getTempTableName("tempTable2", ctx);
        this.executeSQL(ctx, this.getSaleIssueTempTableSQL(tempTable2));
        params.setString("tempTable2", tempTable2);
        String sql = this.getSaleIssueSQL(ctx, params, tempTable2);
        this.executeSQL(ctx, sql);
        String countSql = "select count(1) cc from " + tempTable2;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count2 = rs.getInt(0);
        if (null == this.result) {
            this.result = new RptParams();
        }
        this.result.setString("tempTable2", tempTable2);
        this.result.setString("index", "bottomTable");
        this.result.setObject("header2", (Object)this.createBottomRptHeader(ctx));
        this.result.setInt("verticalCount2", count2);
        map.put("tempTable2", tempTable2);
    }

    private RptTableHeader createBottomRptHeader(Context ctx) {
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        ArrayList<String> list = new ArrayList<String>();
        col = new RptTableColumn("FSourceBillNumber");
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"billNumber", (Context)ctx));
        col = new RptTableColumn("FSourceBillSeq");
        col.setWidth(110);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"billEntrySeq", (Context)ctx));
        col = new RptTableColumn("FMaterialNumber");
        col.setWidth(110);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"materialNumber", (Context)ctx));
        col = new RptTableColumn("FMaterialName");
        col.setWidth(110);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"material", (Context)ctx));
        col = new RptTableColumn("FModel");
        col.setWidth(100);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"model", (Context)ctx));
        col = new RptTableColumn("FUnBalanceQty");
        col.setAligment(2);
        col.setWidth(100);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"unBalanceQty", (Context)ctx));
        col = new RptTableColumn("FApportionBalanceQty");
        col.setAligment(2);
        col.setWidth(100);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"apportionBalanceQty", (Context)ctx));
        col = new RptTableColumn("FApportionBalanceBaseQty");
        col.setAligment(2);
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"apportionBalanceBaseQty", (Context)ctx));
        col = new RptTableColumn("FApportionBalanceAssistQty");
        col.setAligment(2);
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"apportionBalanceAssistQty", (Context)ctx));
        col = new RptTableColumn("FIsPresent");
        col.setAligment(2);
        col.setWidth(50);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"isPresent", (Context)ctx));
        col = new RptTableColumn("FPresentQty");
        col.setAligment(2);
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"presentQty", (Context)ctx));
        col = new RptTableColumn("FVerifyPrice");
        col.setAligment(2);
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"verifyPrice", (Context)ctx));
        col = new RptTableColumn("FTips");
        col.setHided(true);
        col.setWidth(-1);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"FTips", (Context)ctx));
        col = new RptTableColumn("FVerifyTaxPrice");
        col.setAligment(2);
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"verifyTaxPrice", (Context)ctx));
        col = new RptTableColumn("FVerifyDiscount");
        col.setAligment(2);
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"verifyDiscount", (Context)ctx));
        col = new RptTableColumn("FPrice");
        col.setAligment(2);
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"price", (Context)ctx));
        col = new RptTableColumn("FTaxPrice");
        col.setAligment(2);
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"taxPrice", (Context)ctx));
        col = new RptTableColumn("FDiscount");
        col.setAligment(2);
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"discount", (Context)ctx));
        col = new RptTableColumn("FDiscountType");
        col.setWidth(100);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"discountType", (Context)ctx));
        col = new RptTableColumn("FAmount");
        col.setAligment(2);
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"taxAmount", (Context)ctx));
        col = new RptTableColumn("FAssistPropertyName");
        col.setWidth(100);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"assistProperty", (Context)ctx));
        col = new RptTableColumn("FLot");
        col.setWidth(100);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"lot", (Context)ctx));
        col = new RptTableColumn("FBizDate");
        col.setWidth(100);
        col.setFormatPattern("YYYY-MM-DD");
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"bizDate", (Context)ctx));
        col = new RptTableColumn("FTaxRate");
        col.setAligment(2);
        col.setFormatPattern("%{0.##########}f");
        col.setWidth(100);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"taxRate", (Context)ctx));
        col = new RptTableColumn("FUnitName");
        col.setWidth(100);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"unit", (Context)ctx));
        col = new RptTableColumn("FBaseUnitName");
        col.setWidth(100);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"baseUnit", (Context)ctx));
        col = new RptTableColumn("FAssistUnitName");
        col.setWidth(100);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"assistUnit", (Context)ctx));
        col = new RptTableColumn("FUnBalanceBaseQty");
        col.setAligment(2);
        col.setWidth(160);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"unBalanceBaseQty", (Context)ctx));
        col = new RptTableColumn("FQty");
        col.setAligment(2);
        col.setWidth(100);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"qty", (Context)ctx));
        col = new RptTableColumn("FBaseQty");
        col.setAligment(2);
        col.setWidth(130);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"baseQty", (Context)ctx));
        col = new RptTableColumn("FStorageOrgUnitName");
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"storageOrgUnit", (Context)ctx));
        col = new RptTableColumn("FWareHouseName");
        col.setWidth(120);
        col.setHided(true);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"warehouse", (Context)ctx));
        col = new RptTableColumn("FStoragelocation");
        col.setWidth(120);
        col.setHided(true);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"Storagelocation", (Context)ctx));
        col = new RptTableColumn("FCustomerNumber");
        col.setWidth(110);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"customerNumber", (Context)ctx));
        col = new RptTableColumn("FCustomerName");
        col.setWidth(110);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"customer", (Context)ctx));
        col = new RptTableColumn("FBalanceCustomerName");
        col.setWidth(110);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"balanceCustomer", (Context)ctx));
        col = new RptTableColumn("FQtyPrecision");
        col.setHided(true);
        col.setWidth(-1);
        header.addColumn(col);
        list.add("FQtyPrecision");
        col = new RptTableColumn("FBaseQtyPrecision");
        col.setHided(true);
        col.setWidth(-1);
        header.addColumn(col);
        list.add("FBaseQtyPrecision");
        col = new RptTableColumn("FAssistQtyPrecision");
        col.setHided(true);
        col.setWidth(-1);
        header.addColumn(col);
        list.add("FAssistQtyPrecision");
        col = new RptTableColumn("FPricePrecision");
        col.setHided(true);
        col.setWidth(-1);
        header.addColumn(col);
        list.add("FPricePrecision");
        col = new RptTableColumn("FCoefficient");
        col.setHided(true);
        col.setWidth(-1);
        header.addColumn(col);
        list.add("FCoefficient");
        col = new RptTableColumn("FAssistCoefficient");
        col.setHided(true);
        col.setWidth(-1);
        header.addColumn(col);
        list.add("FAssistCoefficient");
        col = new RptTableColumn("FIsInTax");
        col.setHided(true);
        col.setWidth(-1);
        header.addColumn(col);
        list.add("FIsInTax");
        col = new RptTableColumn("FStorageOrgUnitID");
        col.setHided(true);
        col.setWidth(-1);
        header.addColumn(col);
        list.add("FStorageOrgUnitID");
        col = new RptTableColumn("FMaterialID");
        col.setHided(true);
        col.setWidth(-1);
        header.addColumn(col);
        list.add("FMaterialID");
        col = new RptTableColumn("FCustomerID");
        col.setHided(true);
        col.setWidth(-1);
        header.addColumn(col);
        list.add("FCustomerID");
        col = new RptTableColumn("FBalanceCustomerID");
        col.setHided(true);
        col.setWidth(-1);
        header.addColumn(col);
        list.add("FBalanceCustomerID");
        col = new RptTableColumn("FAssistPropertyID");
        col.setHided(true);
        col.setWidth(-1);
        header.addColumn(col);
        list.add("FAssistPropertyID");
        col = new RptTableColumn("FWarehouseID");
        col.setHided(true);
        col.setWidth(-1);
        header.addColumn(col);
        list.add("FWarehouseID");
        col = new RptTableColumn("FAssistUnitID");
        col.setHided(true);
        col.setWidth(-1);
        header.addColumn(col);
        list.add("FAssistUnitID");
        col = new RptTableColumn("FID");
        col.setHided(true);
        col.setWidth(-1);
        header.addColumn(col);
        list.add("FID");
        col = new RptTableColumn("FEntryID");
        col.setHided(true);
        col.setWidth(-1);
        header.addColumn(col);
        list.add("FEntryID");
        col = new RptTableColumn("FISSN");
        col.setWidth(100);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"SN", (Context)ctx));
        int length = list.size();
        Object[][] obj = new Object[1][length];
        for (int i = 0; i < length; ++i) {
            obj[0][i] = list.get(i);
        }
        header.setLabels(obj, true);
        return header;
    }

    private String getSaleIssueSQL(Context ctx, RptParams params, String tempTable) throws BOSException, EASBizException {
        StringBuffer bf = new StringBuffer();
        bf.append("INSERT INTO ").append(params.getString("tempTable2"));
        bf.append(" (FID,FEntryID,FSourceBillNumber,FSourceBillSeq,FStorageOrgUnitID,FCompanyOrgUnitID,FMaterialID,FWarehouseID,FLocationID,FCustomerID,FBalanceCustomerID,");
        bf.append("FAssistPropertyID,FUnitID,FBaseUnitID,FAssistUnitID,FLot,FUnBalanceQty,FUnBalanceBaseQty,FQty,FBaseQty,FPrice,FTaxPrice,FAmount,FIsPresent,FPresentQty,");
        bf.append("FQtyPrecision,FBaseQtyPrecision,FAssistQtyPrecision,FBizDate,FCoefficient,FAssistCoefficient,FPrecision,FPricePrecision,FIsNevigate,FTaxRate,FIsInTax,FDiscount,FDiscountType)").append(this.sp);
        bf.append("SELECT ").append(this.sp);
        bf.append("BILL.FID,").append(this.sp);
        bf.append("ENTRY.FID,").append(this.sp);
        bf.append("BILL.FNumber,").append(this.sp);
        bf.append("ENTRY.FSeq,").append(this.sp);
        bf.append("BILL.FStorageOrgUnitID,").append(this.sp);
        bf.append("ENTRY.FCompanyOrgUnitID,").append(this.sp);
        bf.append("ENTRY.FMaterialID,").append(this.sp);
        bf.append("ENTRY.FWarehouseID,").append(this.sp);
        bf.append("ENTRY.FLocationID,").append(this.sp);
        bf.append("BILL.FCustomerID,").append(this.sp);
        bf.append("ENTRY.FBalanceCustomerID,").append(this.sp);
        bf.append("ENTRY.FAssistPropertyID,").append(this.sp);
        bf.append("ENTRY.FUnitID,").append(this.sp);
        bf.append("ENTRY.FBaseUnitID,").append(this.sp);
        bf.append("ENTRY.FAssistUnitID,").append(this.sp);
        bf.append("ENTRY.FLot,").append(this.sp);
        bf.append("ENTRY.FUnSettleQty as FUnBalanceQty, ").append(this.sp);
        bf.append("ENTRY.FUnSettleBaseQty as FUnBalanceBaseQty, ").append(this.sp);
        bf.append("ENTRY.FQty as FQty, ").append(this.sp);
        bf.append("ENTRY.FBaseQty as FBaseQty, ").append(this.sp);
        bf.append("ENTRY.FSalePrice as FPrice, ").append(this.sp);
        bf.append("ENTRY.FTaxPrice as FTaxPrice, ").append(this.sp);
        bf.append("ENTRY.FAmount as FAmount, ").append(this.sp);
        bf.append("ENTRY.FIsPresent as FIsPresent, ").append(this.sp);
        bf.append(" CASE WHEN ENTRY.FIsPresent = 1 THEN ENTRY.FUnSettleQty ELSE 0 END AS FPresentQty, ").append(this.sp);
        bf.append("MULTIUNIT.FQtyPrecision,").append(this.sp);
        bf.append("MULTIBASEUNIT.FQtyPrecision AS FBaseQtyPrecision,").append(this.sp);
        bf.append("MULTIASSISTUNIT.FQtyPrecision AS FAssistQtyPrecision,").append(this.sp);
        bf.append("BILL.FBizDate,").append(this.sp);
        bf.append("MULTIUNIT.FBaseConvsRate AS FCoefficient,");
        bf.append("ISNULL(MULTIASSISTUNIT.FBaseConvsRate,0) AS FAssistCoefficient,");
        bf.append("BASECURRENCY.FPrecision AS FPrecision,");
        bf.append("material.FPricePrecision AS FPricePrecision,");
        bf.append("CASE WHEN ENTRY.FUnSettleQty >=0 THEN 1 ELSE 0 END");
        bf.append(" AS FIsNevigate,");
        bf.append("ENTRY.FTaxRate AS FTaxRate,").append(this.sp);
        bf.append("BILL.FIsInTax AS FIsInTax,").append(this.sp);
        bf.append("ENTRY.FDiscount as FDiscount, ").append(this.sp);
        bf.append("ENTRY.FDiscountType as FDiscountType ").append(this.sp);
        bf.append(" FROM T_IM_SaleIssueBill BILL");
        bf.append(" INNER JOIN T_IM_SaleIssueEntry ENTRY ON BILL.FID = ENTRY.FParentID");
        bf.append(" LEFT OUTER JOIN T_SCM_TransactionType AS TRANSACTIONTYPE ON");
        bf.append(" BILL.FTransactionTypeID = TRANSACTIONTYPE.FID").append(this.sp);
        bf.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIUNIT ");
        bf.append(" ON (ENTRY.FMaterialID = MULTIUNIT.FMaterialID AND ENTRY.FUnitID = MULTIUNIT.FMeasureUnitID)");
        bf.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIBASEUNIT");
        bf.append(" ON (ENTRY.FMaterialID = MULTIBASEUNIT.FMaterialID AND ENTRY.FBaseUnitID = MULTIBASEUNIT.FMeasureUnitID)");
        bf.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIASSISTUNIT");
        bf.append(" ON (ENTRY.FMaterialID = MULTIASSISTUNIT.FMaterialID AND ENTRY.FAssistUnitID = MULTIASSISTUNIT.FMeasureUnitID)");
        bf.append(" LEFT OUTER JOIN T_ORG_Company AS COMPANYORGUNIT ON ENTRY.FCompanyOrgUnitID = COMPANYORGUNIT.FID ");
        bf.append(" LEFT OUTER JOIN T_BD_Currency AS BASECURRENCY ON COMPANYORGUNIT.FBaseCurrencyID = BASECURRENCY.FID");
        bf.append(" INNER JOIN T_BD_Material AS material ON ENTRY.FMaterialID = material.FID");
        bf.append(" WHERE BILL.FBizTypeID = '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("'");
        bf.append(" AND TRANSACTIONTYPE.FRITypeid = '").append(RecIssueTypeConstant.CONSIGNOUT_RITYPEID).append("'").append(this.sp);
        bf.append(" AND BILL.FIsReversed = 0");
        bf.append(" AND BILL.FBaseStatus = ").append(4);
        bf.append(" AND ENTRY.FUnSettleQty <> 0").append(this.sp);
        if (null != params.getString("storageOrgUnitIDs") && !params.getString("storageOrgUnitIDs").equalsIgnoreCase("")) {
            bf.append(" AND ENTRY.FStorageOrgUnitID IN ").append(params.getString("storageOrgUnitIDs"));
        }
        if (null != params.getString("customerID") && !params.getString("customerID").equalsIgnoreCase("")) {
            bf.append(" AND BILL.FCustomerID = '").append(params.getString("customerID")).append("'");
        }
        if (null != params.getString("balanceCustomerID") && !params.getString("balanceCustomerID").equalsIgnoreCase("")) {
            bf.append(" AND ENTRY.FBALANCECUSTOMERID = '").append(params.getString("balanceCustomerID")).append("'");
        }
        if (null != params.getString("materialNumberFrom") && !params.getString("materialNumberFrom").equalsIgnoreCase("")) {
            bf.append(" AND material.FNumber >= '").append(params.getString("materialNumberFrom")).append("'");
        }
        if (null != params.getString("materialNumberTo") && !params.getString("materialNumberTo").equalsIgnoreCase("")) {
            bf.append(" AND material.FNumber <= '").append(params.getString("materialNumberTo")).append("'");
        }
        if (null != params.getObject("verifyDate")) {
            bf.append(" AND BILL.FBizDate <= TO_DATE('" + IMRptUtils.getFilterEndDate((Date)((Date)params.getObject("verifyDate"))) + "')");
        }
        if (null != params.getString("saleOrgUnitIDs") && !"".equals(params.getString("saleOrgUnitIDs"))) {
            bf.append(" AND (ENTRY.FSALEORGUNITID IN ").append(params.getString("saleOrgUnitIDs")).append(" OR ENTRY.FSALEORGUNITID IS NULL)");
        }
        return bf.toString();
    }

    private String getInventoryTempTableSQL(String tempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table ").append(tempTable).append(" (");
        sql.append("FID Varchar(44),").append(this.sp);
        sql.append("FStorageOrgUnitID Varchar(44),").append(this.sp);
        sql.append("FCompanyOrgUnitID Varchar(44),").append(this.sp);
        sql.append("FMaterialID Varchar(44),").append(this.sp);
        sql.append("FWarehouseID Varchar(44),").append(this.sp);
        sql.append("FCustomerID Varchar(44),").append(this.sp);
        sql.append("FAssistPropertyID Varchar(44),").append(this.sp);
        sql.append("FUnitID Varchar(44),").append(this.sp);
        sql.append("FBaseUnitID Varchar(44),").append(this.sp);
        sql.append("FLot Nvarchar(80),").append(this.sp);
        sql.append("FCurStoreQty Decimal(28,10) Not Null Default 0,").append(this.sp);
        sql.append("FCurBalanceQty Decimal(28,10) Not Null Default 0,").append(this.sp);
        sql.append("FQtyPrecision int,").append(this.sp);
        sql.append("FBaseQtyPrecision int,").append(this.sp);
        sql.append("FIsTotal varchar(2)").append(this.sp);
        sql.append(" );");
        return sql.toString();
    }

    private void subtotal(Context ctx, String tempTable) throws BOSException, EASBizException {
        StringBuffer bf = new StringBuffer();
        String sumQtyColumn = "sum(FCurStoreQty),sum(FCurBalanceQty)";
        bf.append("INSERT INTO ").append(tempTable);
        bf.append(" (FID,FIsTotal,");
        bf.append("FCurStoreQty)").append(this.sp);
        bf.append(" SELECT  ");
        bf.append("NEWBOSID('88888888'),").append(this.sp);
        bf.append("'1',");
        bf.append("isnull(sum(temp.FCurStoreQty),0)").append(this.sp);
        bf.append(" FROM ").append(tempTable).append(" as temp");
        this.executeUpdate(bf.toString(), null, ctx);
    }

    private String getSaleIssueTempTableSQL(String tempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table ").append(tempTable).append(" (");
        sql.append("FID Varchar(44),").append(this.sp);
        sql.append("FBillID Varchar(44),").append(this.sp);
        sql.append("FEntryID Varchar(44),").append(this.sp);
        sql.append("FSourceBillNumber Varchar(80),").append(this.sp);
        sql.append("FSourceBillSeq int,").append(this.sp);
        sql.append("FStorageOrgUnitID Varchar(44),").append(this.sp);
        sql.append("FCompanyOrgUnitID Varchar(44),").append(this.sp);
        sql.append("FMaterialID Varchar(44),").append(this.sp);
        sql.append("FWarehouseID Varchar(44),").append(this.sp);
        sql.append("FLocationID Varchar(44),").append(this.sp);
        sql.append("FCustomerID Varchar(44),").append(this.sp);
        sql.append("FBalanceCustomerID Varchar(44),").append(this.sp);
        sql.append("FAssistPropertyID Varchar(44),").append(this.sp);
        sql.append("FUnitID Varchar(44),").append(this.sp);
        sql.append("FBaseUnitID Varchar(44),").append(this.sp);
        sql.append("FAssistUnitID Varchar(44),").append(this.sp);
        sql.append("FLot Nvarchar(80),").append(this.sp);
        sql.append("FBizDate datetime,").append(this.sp);
        sql.append("FUnBalanceQty Decimal(28,10) Not Null Default 0,").append(this.sp);
        sql.append("FUnBalanceBaseQty Decimal(28,10) Not Null Default 0,").append(this.sp);
        sql.append("FQty Decimal(28,10) Not Null Default 0,").append(this.sp);
        sql.append("FBaseQty Decimal(28,10) Not Null Default 0,").append(this.sp);
        sql.append("FApportionBalanceQty Decimal(28,10) Not Null Default 0,").append(this.sp);
        sql.append("FIsPresent int,").append(this.sp);
        sql.append("FPresentQty Decimal(28,10) Not Null Default 0,").append(this.sp);
        sql.append("FPrice Decimal(28,10) Not Null Default 0,").append(this.sp);
        sql.append("FTaxPrice Decimal(28,10) Not Null Default 0,").append(this.sp);
        sql.append("FAmount Decimal(28,10) Not Null Default 0,").append(this.sp);
        sql.append("FQtyPrecision int,").append(this.sp);
        sql.append("FBaseQtyPrecision int,").append(this.sp);
        sql.append("FAssistQtyPrecision int,").append(this.sp);
        sql.append("FCoefficient Decimal(28,10) Not Null Default 0,").append(this.sp);
        sql.append("FAssistCoefficient Decimal(28,10) Not Null Default 0,").append(this.sp);
        sql.append("FPrecision int,").append(this.sp);
        sql.append("FPricePrecision int,").append(this.sp);
        sql.append("FIsNevigate int,").append(this.sp);
        sql.append("FTaxRate Decimal(28,10) Not Null Default 0,").append(this.sp);
        sql.append("FIsInTax int,").append(this.sp);
        sql.append("FDiscount Decimal(28,10),").append(this.sp);
        sql.append("FDiscountType int").append(this.sp);
        sql.append(" );");
        return sql.toString();
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    private String topQuerySQL(RptParams params) {
        StringBuffer bf = new StringBuffer();
        bf.append("SELECT ").append(this.sp);
        bf.append("MATERIAL.FNumber AS FMaterialNumber,").append(this.sp);
        bf.append("MATERIAL.FName_").append(this.language).append(" As FMaterialName,").append(this.sp);
        bf.append("MATERIAL.FModel AS FModel,").append(this.sp);
        bf.append("TempT.FCurStoreQty, ").append(this.sp);
        bf.append("FCurBalanceQty,").append(this.sp);
        bf.append("ASSISTPROPERTY.FName_").append(this.language).append(" AS FAssistPropertyName,").append(this.sp);
        bf.append("BASEUNIT.FName_").append(this.language).append(" AS FBaseUnitName,").append(this.sp);
        bf.append("STORAGEORGUNIT.FName_").append(this.language).append(" AS FStorageOrgUnitName,").append(this.sp);
        bf.append("CUSTOMER.FNumber AS FCustomerNumber,").append(this.sp);
        bf.append("CUSTOMER.FName_").append(this.language).append(" AS FCustomerName,").append(this.sp);
        bf.append("TempT.FQtyPrecision AS FQtyPrecision,").append(this.sp);
        bf.append("TempT.FStorageOrgUnitID AS FStorageOrgUnitID,").append(this.sp);
        bf.append("TempT.FMaterialID AS FMaterialID,").append(this.sp);
        bf.append("TempT.FCustomerID AS FCustomerID,").append(this.sp);
        bf.append("TempT.FAssistPropertyID AS FAssistPropertyID").append(this.sp);
        bf.append(" FROM ").append(params.getString("tempTable1")).append(" AS TempT").append(this.sp);
        bf.append(" left JOIN T_ORG_Storage AS STORAGEORGUNIT ON TempT.FStorageOrgUnitID = STORAGEORGUNIT.FID");
        bf.append(" left JOIN T_BD_Material AS MATERIAL ON TempT.FMaterialID = MATERIAL.FID").append(this.sp);
        bf.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS BASEUNIT ON TempT.FBaseUnitID = BASEUNIT.FID").append(this.sp);
        bf.append(" LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ON TempT.FCustomerID = CUSTOMER.FID").append(this.sp);
        bf.append(" LEFT OUTER JOIN T_BD_AsstAttrValue AS ASSISTPROPERTY ON TempT.FAssistPropertyID = ASSISTPROPERTY.FID").append(this.sp);
        bf.append(" WHERE TempT.FIsTotal is null  ORDER BY MATERIAL.FNumber,STORAGEORGUNIT.FName_").append(this.language).append(",ASSISTPROPERTY.FName_").append(this.language);
        return bf.toString();
    }

    private String bottomQuerySQL(Context ctx, RptParams params) {
        StringBuffer bf = new StringBuffer();
        bf.append("SELECT ");
        bf.append("TempT.FSourceBillNumber AS FSourceBillNumber,").append(this.sp);
        bf.append("TempT.FSourceBillSeq AS FSourceBillSeq,").append(this.sp);
        bf.append("STORAGEORGUNIT.FName_").append(this.language).append(" AS FStorageOrgUnitName,").append(this.sp);
        bf.append("WAREHOUSE.FName_").append(this.language).append(" AS FWAREHOUSEName,").append(this.sp);
        bf.append("LOCATION.FName_").append(this.language).append(" AS FLOCATIONNAME,").append(this.sp);
        bf.append("CUSTOMER.FNumber AS FCustomerNumber,").append(this.sp);
        bf.append("CUSTOMER.FName_").append(this.language).append(" AS FCustomerName,").append(this.sp);
        bf.append("BALANCECUSTOMER.FName_").append(this.language).append(" AS FBalanceCustomerName,").append(this.sp);
        bf.append("MATERIAL.FNumber AS FMaterialNumber,").append(this.sp);
        bf.append("MATERIAL.FName_").append(this.language).append(" As FMaterialName,").append(this.sp);
        bf.append("ASSISTPROPERTY.FName_").append(this.language).append(" AS FAssistPropertyName,").append(this.sp);
        bf.append("MATERIAL.FModel AS FModel,").append(this.sp);
        bf.append("TempT.FUnBalanceQty AS FUnBalanceQty,").append(this.sp);
        bf.append("TempT.FApportionBalanceQty AS FApportionBalanceQty,").append(this.sp);
        bf.append(" 0 AS FApportionBalanceBaseQty,").append(this.sp);
        bf.append(" 0 AS FApportionBalanceAssistQty,").append(this.sp);
        bf.append("TempT.FIsPresent AS FIsPresent,").append(this.sp);
        bf.append("TempT.FPresentQty AS FPresentQty,").append(this.sp);
        bf.append(" TempT.FPrice AS FPrice,").append(this.sp);
        bf.append(" TempT.FTaxPrice AS FTaxPrice,").append(this.sp);
        bf.append(" TempT.FDiscount AS FDiscount,").append(this.sp);
        bf.append(" TempT.FDiscountType AS FDiscountType,").append(this.sp);
        bf.append(" TempT.FAmount AS FAmount,").append(this.sp);
        bf.append("TempT.FLot AS FLot,").append(this.sp);
        bf.append("TempT.FBizDate AS FBizDate,").append(this.sp);
        bf.append("UNIT.FName_").append(this.language).append(" AS FUnitName,").append(this.sp);
        bf.append("TempT.FTaxRate AS FTaxRate,").append(this.sp);
        bf.append("BASEUNIT.FName_").append(this.language).append(" AS FBaseUnitName,").append(this.sp);
        bf.append("ASSISTUNIT.FName_").append(this.language).append(" AS FAssistUnitName,").append(this.sp);
        bf.append("TempT.FUnBalanceBaseQty AS FUnBalanceBaseQty,TempT.FQty AS FQty,TempT.FBaseQty AS FBaseQty,").append(this.sp);
        bf.append("TempT.FQtyPrecision AS FQtyPrecision,").append(this.sp);
        bf.append("TempT.FBaseQtyPrecision AS FBaseQtyPrecision,").append(this.sp);
        bf.append("TempT.FAssistQtyPrecision AS FAssistQtyPrecision,").append(this.sp);
        bf.append("TempT.FCoefficient AS FCoefficient,").append(this.sp);
        bf.append("TempT.FAssistCoefficient AS FAssistCoefficient,").append(this.sp);
        bf.append("TempT.FPricePrecision AS FPricePrecision,").append(this.sp);
        bf.append("TempT.FPrecision AS FPrecision,").append(this.sp);
        bf.append("TempT.FStorageOrgUnitID AS FStorageOrgUnitID,").append(this.sp);
        bf.append("TempT.FMaterialID AS FMaterialID,").append(this.sp);
        bf.append("TempT.FCustomerID AS FCustomerID,").append(this.sp);
        bf.append("TempT.FBalanceCustomerID AS FBalanceCustomerID,").append(this.sp);
        bf.append("TempT.FAssistPropertyID AS FAssistPropertyID,").append(this.sp);
        bf.append("TempT.FWarehouseID AS FWarehouseID,").append(this.sp);
        bf.append("TempT.FID AS FID,").append(this.sp);
        bf.append("TempT.FEntryID AS FEntryID,").append(this.sp);
        bf.append("TempT.FIsInTax AS FIsInTax, ").append(this.sp);
        bf.append("TempT.FAssistUnitID AS FAssistUnitID ").append(this.sp);
        bf.append(", '").append(SCMUtils.getResource((String)this.resFile, (String)"FTips", (Context)ctx)).append("' AS FTips ").append(this.sp);
        bf.append(", (CASE WHEN ISNULL(MI.FISSEQUENCENO, 0) = 1 AND MATERIAL.FSEQUNITID = TempT.FUnitID ").append(this.sp);
        bf.append(" THEN '" + SCMUtils.getResource((String)this.resFile, (String)"SelectSN", (Context)ctx) + "' ELSE '' END) AS FISSN ").append(this.sp);
        bf.append(" FROM ").append(params.getString("tempTable2")).append(" AS TempT").append(this.sp);
        bf.append(" INNER JOIN T_ORG_Storage AS STORAGEORGUNIT ON TempT.FStorageOrgUnitID = STORAGEORGUNIT.FID");
        bf.append(" INNER JOIN T_BD_Material AS MATERIAL ON TempT.FMaterialID = MATERIAL.FID").append(this.sp);
        bf.append(" LEFT OUTER JOIN  T_DB_LOCATION AS LOCATION ON TempT.FLocationID = LOCATION.FID").append(this.sp);
        bf.append(" LEFT OUTER JOIN T_DB_WAREHOUSE AS WAREHOUSE ON TempT.FWarehouseID = WAREHOUSE.FID").append(this.sp);
        bf.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS BASEUNIT ON TempT.FBaseUnitID = BASEUNIT.FID").append(this.sp);
        bf.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ON TempT.FUnitID = UNIT.FID").append(this.sp);
        bf.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS ASSISTUNIT ON TempT.FAssistUnitID = ASSISTUNIT.FID").append(this.sp);
        bf.append(" LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ON TempT.FCustomerID = CUSTOMER.FID").append(this.sp);
        bf.append(" LEFT OUTER JOIN T_BD_Customer AS BALANCECUSTOMER ON TempT.FBalanceCustomerID = BALANCECUSTOMER.FID").append(this.sp);
        bf.append(" LEFT OUTER JOIN T_BD_AsstAttrValue AS ASSISTPROPERTY ON TempT.FAssistPropertyID = ASSISTPROPERTY.FID").append(this.sp);
        bf.append(" LEFT OUTER JOIN T_BD_MATERIALINVENTORY MI ON MI.FORGUNIT = TempT.FStorageOrgUnitID AND MI.FMATERIALID = TempT.FMaterialID").append(this.sp);
        bf.append(" ORDER BY TempT.FIsNevigate,TempT.FBizDate,TempT.FSourceBillNumber,TempT.FSourceBillSeq,").append("TempT.FLot");
        return bf.toString();
    }

    @Override
    protected List _getSNS(Context ctx, String entryId, List selectedSNList) throws BOSException {
        ArrayList<MaterialSNInventoryInfo> snList = new ArrayList<MaterialSNInventoryInfo>();
        MaterialSNInventoryInfo snInfo = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select ms.FSERIALNUMBER as snumber ,ms.FSNSTATUS as snStatus from T_IV_MaterialSerialNumber b ");
        sql.append("inner join T_IV_MATERIALSERIALNUMBERENTRY en on b.FID = en.FPARENTID ");
        sql.append("inner join T_IV_MATERIALSNINVENTORY ms on (b.FMATERIALID = ms.FMATERIALID and ms.FSERIALNUMBER = en.FSERIALNUMBER) ");
        sql.append("INNER JOIN T_IM_INVENTORY inv on inv.FID = ms.FINVENTORYID ");
        sql.append("where b.FBILLENTRYID = '" + entryId + "' and ms.FSNSTATUS in (2,3) ");
        sql.append("and inv.FSTORETYPEID = '181875d5-0105-1000-e000-011ac0a812fd97D461A6' ");
        sql.append("order by en.FSEQ ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                snInfo = new MaterialSNInventoryInfo();
                if (rs.getInt("snStatus") == 2) {
                    snInfo.setSnStatus(SerialNumberStatusEnum.INWAREHOUSE);
                } else {
                    snInfo.setSnStatus(SerialNumberStatusEnum.OUTTHENIN);
                }
                String sNumber = rs.getString("snumber");
                snInfo.setSerialNumber(sNumber);
                if (selectedSNList != null && selectedSNList.contains(sNumber)) {
                    snInfo.put("selected", (Object)true);
                }
                snList.add(snInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return snList;
    }

    @Override
    protected void _execute(Context ctx, Map topMap, Map bottomMap) throws BOSException, EASBizException {
    }

    @Override
    protected void _genWritteOffRecord(Context ctx, String headSQL, List billEntrySQLList) throws BOSException, EASBizException {
    }
}

