/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArSysFacadeFactory;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.sd.sale.report.app.AbstractCustomerTradeFacadeControllerBean;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.scm.util.PermissionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CustomerTradeFacadeControllerBean
extends AbstractCustomerTradeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.report.app.CustomerTradeFacadeControllerBean");
    private String leafCompanyOrgUnit = "leafCompanyOrgUnit";
    private String maxLevelStr = "maxLevelStr";
    private static final String resClassName = "com.kingdee.eas.scm.sd.sale.report.SDReportResource";
    private int precision = 2;

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTempTable(params.getString("TempResultTable"), ctx);
        this.dropTempTable(params.getString("CompanyTempTable"), ctx);
        this.dropTempTable(params.getString("LastReceiveTable"), ctx);
        this.dropTempTable(params.getString("CompanyTempTable"), ctx);
        String resultTB = this.getTempTableName(this.getServerResource("RPTTempTable", ctx), ctx);
        String lsSaleTB = this.getTempTableName(this.getServerResource("RPTTempTable", ctx), ctx);
        String lsReceiveTB = this.getTempTableName(this.getServerResource("RPTTempTable", ctx), ctx);
        String companyTB = this.getTempTableName(this.getServerResource("ORGUintTempTable", ctx), ctx);
        String beginDate = params.getString("dateStart");
        String endDate = params.getString("dateEnd");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            beginDate = sdf.format(sdf.parse(beginDate));
            endDate = sdf.format(sdf.parse(endDate));
        }
        catch (ParseException e1) {
            throw new BOSException((Throwable)e1);
        }
        params.setString("dateStart", beginDate);
        params.setString("dateEnd", endDate);
        this.buildCompanyOrgTable(ctx, companyTB, params);
        Connection conn = null;
        DBUtil.createTempTableIndex((Context)ctx, (String)params.getString("CompanyTempTable"), (String)"fid", (boolean)false);
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            DBUtil.AnalyseTable((Context)ctx, (Connection)conn, (String)params.getString("CompanyTempTable"));
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        this.buildLastSaleTable(ctx, lsSaleTB, params);
        this.buildLastReceiveTable(ctx, lsReceiveTB, params);
        this.createTempTableAndInsertData(ctx, resultTB, params);
        this.updateTotal(ctx, params.getString("TempResultTable"), params.getString("CompanyTempTable"), params);
        String countSql = "select count(1) from (" + this.querySql(params, ctx) + "\t where o.FLEVEL = 1 ) AS TEMP";
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        RptTableHeader header = new RptTableHeader();
        this.setWMRptHead(header, params, ctx);
        RptParams result = new RptParams();
        result.setString("TempResultTable", params.getString("TempResultTable"));
        result.setString("LastSaleTable", params.getString("LastSaleTable"));
        result.setString("LastReceiveTable", params.getString("LastReceiveTable"));
        result.setString("CompanyTempTable", params.getString("CompanyTempTable"));
        result.setObject("header", (Object)header);
        result.setInt("verticalCount", count);
        return result;
    }

    private void buildCompanyOrgTable(Context ctx, String orgTempTable, RptParams params) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + orgTempTable + " (");
        sqlbf.append("fid varchar(44),");
        sqlbf.append("fname_");
        sqlbf.append(ctx.getLocale().getLanguage());
        sqlbf.append(" varchar(100),");
        sqlbf.append("fparentid varchar(44),");
        sqlbf.append("flevel int,");
        sqlbf.append("fisleaf int");
        sqlbf.append(")");
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            String tableName = pool.createTempTable(sqlbf.toString());
            params.remove("CompanyTempTable");
            params.setString("CompanyTempTable", tableName);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        Vector<String> v = new Vector<String>();
        int maxLevel = 0;
        Object[] companyOrgUnit = (Object[])params.getObject("fullCompanyOrgUnit");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            sqlbf.setLength(0);
            conn = EJBFactory.getConnection((Context)ctx);
            sqlbf.append("insert into " + params.getString("CompanyTempTable") + "(");
            sqlbf.append("fid,fname_");
            sqlbf.append(ctx.getLocale().getLanguage());
            sqlbf.append(",fparentid,flevel,fisleaf) ");
            sqlbf.append("values(?,?,?,?,?);");
            pstmt = conn.prepareStatement(sqlbf.toString());
            int n = companyOrgUnit.length;
            for (int i = 0; i < n; ++i) {
                String fid = ((FullOrgUnitInfo)companyOrgUnit[i]).get("id").toString();
                Integer flevel = (Integer)((FullOrgUnitInfo)companyOrgUnit[i]).get("level");
                String fname = (String)((FullOrgUnitInfo)companyOrgUnit[i]).get("name");
                FullOrgUnitInfo parent = (FullOrgUnitInfo)((FullOrgUnitInfo)companyOrgUnit[i]).get("parent");
                Boolean isleaf = (Boolean)((FullOrgUnitInfo)companyOrgUnit[i]).get("isleaf");
                int fisleaf = isleaf != false ? 1 : 0;
                if (fisleaf == 1) {
                    v.add(fid);
                }
                if (flevel > maxLevel) {
                    maxLevel = flevel;
                }
                pstmt.setString(1, fid);
                if (fname != null) {
                    pstmt.setString(2, fname);
                } else {
                    pstmt.setString(2, null);
                }
                if (parent != null) {
                    pstmt.setString(3, parent.getId().toString());
                } else {
                    pstmt.setString(3, null);
                }
                pstmt.setInt(4, flevel);
                pstmt.setInt(5, fisleaf);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            params.setObject(this.leafCompanyOrgUnit, (Object)v.toArray());
            params.setObject(this.maxLevelStr, (Object)new Integer(maxLevel));
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void buildLastSaleTable(Context ctx, String lsSaleTB, RptParams params) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + lsSaleTB + " (");
        sqlbf.append(" \r\n fid varchar(44)");
        sqlbf.append(" \r\n ,FCustomerID Varchar(44)");
        sqlbf.append(" \r\n ,FCompanyORGUnitID Varchar(44)");
        sqlbf.append(" \r\n ,FLastSaleAmount Decimal(28,10) not null default(0) ");
        sqlbf.append(" \r\n ,FLastSaleDate DateTime");
        sqlbf.append(")");
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            String tableName = pool.createTempTable(sqlbf.toString());
            params.remove("LastSaleTable");
            params.setString("LastSaleTable", tableName);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void buildLastReceiveTable(Context ctx, String lsReceiveTB, RptParams params) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + lsReceiveTB + " (");
        sqlbf.append(" \r\n fid varchar(44)");
        sqlbf.append(" \r\n ,FCustomerID Varchar(44)");
        sqlbf.append(" \r\n ,FCompanyORGUnitID Varchar(44)");
        sqlbf.append(" \r\n ,FLastReceiveAmount Decimal(28,10) not null default(0) ");
        sqlbf.append(" \r\n ,FLastReceiveDate DateTime");
        sqlbf.append(")");
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            String tableName = pool.createTempTable(sqlbf.toString());
            params.remove("LastReceiveTable");
            params.setString("LastReceiveTable", tableName);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void createTempTableAndInsertData(Context ctx, String resultTableName, RptParams params) throws BOSException, EASBizException {
        Set cuUnitSets;
        String sql = this.getCreateTempTable(resultTableName, params);
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            String tableName = pool.createTempTable(sql);
            params.remove("TempResultTable");
            params.setString("TempResultTable", tableName);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        Object[] companyOrg = (Object[])params.getObject("fullCompanyOrgUnit");
        Set havePermOrgUnitSet = null;
        if (companyOrg != null && companyOrg.length > 0 && (havePermOrgUnitSet = InvServerUtils.getSelAuthorUnit((Set)(cuUnitSets = PermissionUtil.getAuthorizedf7Orgs((Context)ctx, (IObjectPK)ctx.getCaller(), (String)"CustomerTrade_view")), (Object[])companyOrg)) != null && havePermOrgUnitSet.size() > 0) {
            this.insertData(params, params.getString("TempResultTable"), ctx);
        }
    }

    private String getCreateTempTable(String tempSumTable, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table " + tempSumTable + "(\r\n");
        sql.append("FID Varchar(44)\r\n");
        sql.append(",FCustomerID Varchar(44)\r\n");
        sql.append(",FCompanyORGUnitID Varchar(44)\r\n");
        sql.append(",FFlag varchar(44)\r\n");
        sql.append(",FLevel int\r\n");
        sql.append(",FAccountReceiveAmount Decimal(28,10) not null default(0) \r\n");
        sql.append(",FLastSaleAmount Decimal(28,10) not null default(0) \r\n");
        sql.append(",FLastSaleDate DateTime\r\n");
        sql.append(",FLastReceivedAmount Decimal(28,10) not null default(0) \r\n");
        sql.append(",FLastReceivedDate DateTime\r\n");
        sql.append(",FSaleAmount Decimal(28,10) not null default(0) \r\n");
        sql.append(",FReturnRequestAmount Decimal(28,10) not null default(0) \r\n");
        sql.append(",FSaleIssueAmount Decimal(28,10) not null default(0) \r\n");
        sql.append(",FInvoiceAmount Decimal(28,10) not null default(0) \r\n");
        sql.append(",FReceivedAmount Decimal(28,10) not null default(0) \r\n");
        sql.append(",FReturnOrderAmount Decimal(28,10) not null default(0) \r\n");
        sql.append(",FReceivedCount int  not null default(0) \r\n");
        sql.append(",FAllSaleAmount Decimal(28,10) not null default(0) \r\n");
        sql.append(",FAllReturnRequestAmount Decimal(28,10) not null default(0) \r\n");
        sql.append(",FAllSaleIssueAmount Decimal(28,10) not null default(0) \r\n");
        sql.append(",FAllInvoiceAmount Decimal(28,10) not null default(0) \r\n");
        sql.append(",FAllReceivedAmount Decimal(28,10) not null default(0) \r\n");
        sql.append(",FAllReturnOrderAmount Decimal(28,10) not null default(0) \r\n");
        sql.append(",FAllReceivedCount int not null default(0) \r\n");
        sql.append(",FMaxTime varchar(50) null);\r\n");
        return sql.toString();
    }

    private void insertData(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        if (params.getString("CustomerType") == null) {
            params.setString("CustomerType", "1");
        }
        this.getAccountReceiveAmount(tableName, params, ctx);
        this.getLastSaleAmount(tableName, params, ctx);
        this.getLastReceivedAmount(tableName, params, ctx);
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("insert into " + tableName);
        sqlbf.append("(FID,FCustomerID,FCompanyORGUnitID,FFlag,FLevel,FAccountReceiveAmount,FLastSaleAmount,");
        sqlbf.append("FLastReceivedAmount,FSaleAmount,FReturnRequestAmount,FSaleIssueAmount,FInvoiceAmount,");
        sqlbf.append("FReceivedAmount,FReturnOrderAmount,FReceivedCount,FAllSaleAmount,FAllReturnRequestAmount,FAllSaleIssueAmount,");
        sqlbf.append("FAllInvoiceAmount,FAllReceivedAmount,FAllReturnOrderAmount,FAllReceivedCount)");
        sqlbf.append(" select t1.fid,customer.fid,t1.companyId");
        sqlbf.append(",t1.flag,t1.level2,t1.AccountReceive");
        sqlbf.append(",t1.LastSaleAmount,t1.LastReceivedAmount");
        sqlbf.append(",t1.SaleAmount,t1.ReturnRequestAmount,t1.SaleIssueAmount,t1.InvoiceAmount");
        sqlbf.append(",t1.ReceivedAmount,t1.ReturnOrderAmoun,t1.ReceivedCount");
        sqlbf.append(",t1.TotalSaleAmount,t1.TotalReturnRequestAmount,t1.TotalSaleIssueAmount");
        sqlbf.append(",t1.TotalInvoiceAmount,t1.TotalReceivedAmount,t1.TotalReturnOrderAmoun,t1.TotalReceivedCount ");
        sqlbf.append(" from (");
        sqlbf.append(this.getSaleAmount(params, ctx));
        sqlbf.append(" union all ");
        sqlbf.append(this.getReturnRequestAmount(params, ctx));
        sqlbf.append(" union all ");
        sqlbf.append(this.getSaleIssueAmount(params, ctx));
        sqlbf.append(" union all ");
        sqlbf.append(this.getOtherBillAmount(params, ctx));
        sqlbf.append(" union all ");
        sqlbf.append(this.getReceivedAmount(params, ctx));
        String receivedCountSql = this.getReceivedCount(params, ctx);
        if (!StringUtils.isEmpty((String)receivedCountSql)) {
            sqlbf.append(" union all ");
            sqlbf.append(this.getReceivedCount(params, ctx));
        }
        sqlbf.append(") as t1 ");
        sqlbf.append(" inner join t_bd_customer customer on customer.fid = t1.customerid  ");
        sqlbf.append(" where 1 = 1 ");
        this.setCustomerFromQuery(params, sqlbf);
        if (params.getString("CustomerTo") != null) {
            sqlbf.append(" and Customer.FNumber <= '").append(params.getString("CustomerTo")).append("'");
        }
        this.executeUpdate(sqlbf.toString(), null, ctx);
        sqlbf.setLength(0);
    }

    private void getAccountReceiveAmount(String tempTableName, RptParams params, Context ctx) throws BOSException, EASBizException {
        StringBuffer queryStr = new StringBuffer();
        this.setCustomerFromQuery(params, queryStr);
        if (params.getString("CustomerTo") != null) {
            queryStr.append(" and Customer.FNumber <= '");
            queryStr.append(params.getString("CustomerTo"));
            queryStr.append("'");
        }
        String customerTempTable = null;
        try {
            customerTempTable = TempTablePool.getInstance((Context)ctx).createTempTable("create table customerTemp(FID VARCHAR(44))");
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        Object[] companyOrg = (Object[])params.getObject("fullCompanyOrgUnit");
        StringBuffer customerSQL = new StringBuffer();
        customerSQL.append(" insert into ").append(customerTempTable);
        customerSQL.append(" select customercompanyInfo.FcustomerID CustomerID");
        customerSQL.append(" from t_bd_customercompanyInfo customercompanyInfo ");
        customerSQL.append(" inner join t_bd_customer customer on customercompanyInfo.FcustomerID= customer.fid ");
        customerSQL.append(" inner join ");
        customerSQL.append(params.getString("CompanyTempTable"));
        customerSQL.append(" company on customercompanyInfo.fcomorgID = company.fid");
        customerSQL.append(" where company.fid in (");
        customerSQL.append(this.getOrgListId(companyOrg));
        customerSQL.append(")");
        customerSQL.append(queryStr.toString());
        customerSQL.append(" group by customercompanyInfo.FcustomerID");
        DbUtil.execute((Context)ctx, (String)customerSQL.toString());
        String companyIDTemp = this.getOrgListId(companyOrg);
        ArrayList<String> companyIDList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(companyIDTemp, ",");
        while (st.hasMoreTokens()) {
            companyIDList.add(st.nextToken().replaceAll("'", ""));
        }
        Calendar tempCalendar = Calendar.getInstance();
        String ed = params.getString("dateEnd");
        tempCalendar.set(new Integer(ed.substring(0, 4)), new Integer(ed.substring(5, 7)), new Integer(ed.substring(8, 10)));
        Date pEndDate = tempCalendar.getTime();
        String AccountReceiveTable = ArSysFacadeFactory.getLocalInstance((Context)ctx).getComsCustsCreditBalTable(companyIDList, customerTempTable, pEndDate, true);
        TempTablePool.getInstance((Context)ctx).releaseTable(customerTempTable);
        StringBuffer saleAmount = new StringBuffer();
        saleAmount.append(" insert into ").append(tempTableName);
        saleAmount.append(" select '88888888',customer.fid,company.fid");
        saleAmount.append(",'DEL' flag,company.FLevel level2");
        saleAmount.append(",sum(AccountReceive.FBalance) AccountReceive");
        saleAmount.append(",0 LastSaleAmount,null LastSaleDate,0 LastReceivedAmount,null LastReceivedDate");
        saleAmount.append(",0 SaleAmount,0 ReturnRequestAmount,0 SaleIssueAmount,0 InvoiceAmount");
        saleAmount.append(",0 ReceivedAmount,0 ReturnOrderAmoun,0 ReceivedCount");
        saleAmount.append(",0 TotalSaleAmount,0 TotalReturnRequestAmount,0 TotalSaleIssueAmount");
        saleAmount.append(",0 TotalInvoiceAmount,0 TotalReceivedAmount,0 TotalReturnOrderAmoun,0 TotalReceivedCount,null");
        saleAmount.append(" from " + AccountReceiveTable + " AccountReceive ");
        saleAmount.append(" inner join t_bd_customer customer on AccountReceive.FCustomerId = customer.fid ");
        saleAmount.append(" inner join ");
        saleAmount.append(params.getString("CompanyTempTable"));
        saleAmount.append(" company on AccountReceive.FCompanyId=company.fid ");
        saleAmount.append(" where 1 = 1 ").append(queryStr.toString());
        saleAmount.append(" group by customer.fid,company.fid,company.FLevel");
        DbUtil.execute((Context)ctx, (String)saleAmount.toString());
    }

    private void getLastSaleAmount(String tempTableName, RptParams params, Context ctx) throws BOSException {
        String beginDate = params.getString("dateStart");
        String endDate = params.getString("dateEnd");
        StringBuffer lastSaleAmount = new StringBuffer(5000);
        lastSaleAmount.append(" /*dialect*/insert into ").append(tempTableName);
        lastSaleAmount.append(" select '88888888',dateAndAmt.customerid,dateAndAmt.companyid ");
        lastSaleAmount.append(" ,'DEL' flag,dateAndAmt.level2 ");
        lastSaleAmount.append(" ,0 AccountReceiveAmount,dateAndAmt.lastSaleAmt LastSaleAmount ");
        lastSaleAmount.append(" ,dateAndAmt.lastSaleDate LastSaleDate ");
        if (KsqlUtil.isDB2((Context)ctx)) {
            lastSaleAmount.append(" ,0 LastReceivedAmount, CASE 1 WHEN 1 THEN NULL ELSE 'Stupid DB2!' END LastReceivedDate ");
        } else {
            lastSaleAmount.append(" ,0 LastReceivedAmount, null LastReceivedDate ");
        }
        lastSaleAmount.append(" ,0 SaleAmount,0 ReturnRequestAmount,0 SaleIssueAmount,0 InvoiceAmount ");
        lastSaleAmount.append(" ,0 ReceivedAmount,0 ReturnOrderAmoun,0 ReceivedCount ");
        lastSaleAmount.append(" ,0 TotalSaleAmount,0 TotalReturnRequestAmount,0 TotalSaleIssueAmount ");
        lastSaleAmount.append(" ,0 TotalInvoiceAmount,0 TotalReceivedAmount,0 TotalReturnOrderAmoun,0 TotalReceivedCount,");
        if (KsqlUtil.isDB2((Context)ctx)) {
            lastSaleAmount.append(" CASE 1 WHEN 1 THEN NULL ELSE 'Stupid DB2!' END ");
        } else {
            lastSaleAmount.append(" null ");
        }
        lastSaleAmount.append("  from ( select ");
        if (KsqlUtil.isOracle((Context)ctx)) {
            lastSaleAmount.append(" row_number() over(partition by customer.fid,company.fid,company.FLevel order by saleOrder.FBizDate desc, saleOrder.FNumber desc) as rownumer,");
        } else if (KsqlUtil.isSQLServer((Context)ctx)) {
            lastSaleAmount.append(" rownumer = row_number() over(partition by customer.fid,company.fid,company.FLevel order by saleOrder.FBizDate desc, saleOrder.FNumber desc),");
        } else {
            lastSaleAmount.append(" row_number() over(partition by customer.fid,company.fid,company.FLevel order by saleOrder.FBizDate desc, saleOrder.FNumber desc) as rownumer,");
        }
        lastSaleAmount.append(" customer.fid customerid ,company.fid companyid,company.FLevel level2, ");
        lastSaleAmount.append(" saleOrder.FLocalTotalTaxAmount lastSaleAmt, ");
        lastSaleAmount.append(" saleOrder.FBizDate lastSaleDate ");
        lastSaleAmount.append(" from t_sd_saleorder saleorder ");
        lastSaleAmount.append(" inner join t_sd_saleorderentry entry on saleOrder.FID = entry.FParentID ");
        switch (new Integer(params.getString("CustomerType"))) {
            case 1: {
                lastSaleAmount.append(" inner join t_bd_customer customer ");
                lastSaleAmount.append(" on Entry.FReceiveCustomerID = customer.fid ");
                break;
            }
            case 2: {
                lastSaleAmount.append(" inner join t_bd_customer customer ");
                lastSaleAmount.append(" on Entry.FDeliveryCustomerID = customer.fid ");
                break;
            }
            case 3: {
                lastSaleAmount.append(" inner join t_bd_customer customer ");
                lastSaleAmount.append(" on saleorder.FOrderCustomerID = customer.fid ");
            }
        }
        lastSaleAmount.append(" inner join ");
        lastSaleAmount.append(params.getString("CompanyTempTable"));
        lastSaleAmount.append(" company on saleorder.FCompanyOrgUnitID=company.fid");
        lastSaleAmount.append(" where ");
        lastSaleAmount.append(" (entry.FBaseStatus =4 or  entry.FBaseStatus =6 or entry.FBaseStatus =7 )");
        if (KsqlUtil.isOracle((Context)ctx)) {
            lastSaleAmount.append(" and saleorder.FBizDate  >= to_date('").append(beginDate).append("','yyyy-MM-dd hh24:mi:ss') ");
            lastSaleAmount.append(" and saleorder.FBizDate  <= to_date('").append(endDate).append("','yyyy-MM-dd hh24:mi:ss') ");
        } else if (KsqlUtil.isSQLServer((Context)ctx)) {
            lastSaleAmount.append(" and saleorder.FBizDate  >= '").append(beginDate).append("' ");
            lastSaleAmount.append(" and saleorder.FBizDate  <= '").append(endDate).append("'");
        } else {
            lastSaleAmount.append(" and saleorder.FBizDate  >= '").append(beginDate).append("' ");
            lastSaleAmount.append(" and saleorder.FBizDate  <= '").append(endDate).append("'");
        }
        lastSaleAmount.append(" and company.FIsLeaf = 1 ");
        this.setCustomerFromQuery(params, lastSaleAmount);
        if (params.getString("CustomerTo") != null) {
            lastSaleAmount.append(" and customer.FNumber <= '" + params.getString("CustomerTo") + "'");
        }
        lastSaleAmount.append(" ) dateAndAmt where rownumer = 1 ");
        DbUtil.execute((Context)ctx, (String)lastSaleAmount.toString());
    }

    private void getLastReceivedAmount(String tempTableName, RptParams params, Context ctx) throws BOSException {
        String beginDate = params.getString("dateStart");
        String endDate = params.getString("dateEnd");
        StringBuffer queryStr = new StringBuffer();
        queryStr.append("ReceivingBill.FBizDate  >= {" + beginDate + "} ");
        queryStr.append(" and ReceivingBill.FBizDate <= {" + endDate + "}");
        queryStr.append(" AND ReceivingBill.FBillStatus IN (14) ");
        queryStr.append(" and company.FIsleaf = 1 ");
        this.setCustomerFromQuery(params, queryStr);
        if (params.getString("CustomerTo") != null) {
            queryStr.append(" and customer.FNumber <= '" + params.getString("CustomerTo") + "'");
        }
        StringBuffer lastReceivedAmount = new StringBuffer();
        lastReceivedAmount.append(" insert into ").append(tempTableName);
        lastReceivedAmount.append(" select '88888888',t.customerid,t.companyid,t.flag,t.level2");
        lastReceivedAmount.append(",0 AccountReceiveAmount,0 LastSaleAmount,null LastSaleDate");
        lastReceivedAmount.append(" ,sum(t.FActRecLocAmt) LastReceivedAmount,Max(t.FBizDate) LastReceivedDate");
        lastReceivedAmount.append(",0 SaleAmount,0 ReturnRequestAmount,0 SaleIssueAmount,0 InvoiceAmount");
        lastReceivedAmount.append(",0 ReceivedAmount,0 ReturnOrderAmoun,0 ReceivedCount");
        lastReceivedAmount.append(",0 TotalSaleAmount,0 TotalReturnRequestAmount,0 TotalSaleIssueAmount");
        lastReceivedAmount.append(",0 TotalInvoiceAmount,0 TotalReceivedAmount,0 TotalReturnOrderAmoun,0 TotalReceivedCount,Max(t.FMaxTime) ");
        lastReceivedAmount.append("\n  from( ");
        lastReceivedAmount.append("\n select  customer.fid customerid ,company.fid companyid");
        lastReceivedAmount.append(",'DEL' flag,company.FLevel level2");
        lastReceivedAmount.append(" ,0 as LastSaleAmount,null as saleOrderBizDate ");
        lastReceivedAmount.append(" ,0 as FActRecLocAmt,max(ReceivingBill.FBizDate) FBizDate ");
        lastReceivedAmount.append(" ,max(TO_CHAR(ReceivingBill.FBizDate, 'YYYY-MM-DD HH24:MI:SS') || TO_CHAR(ReceivingBill.FLastupdateTime, 'YYYY-MM-DD HH24:MI:SS')) FMaxTime ");
        lastReceivedAmount.append("\n from T_CAS_ReceivingBill ReceivingBill ");
        lastReceivedAmount.append("\n inner join ");
        lastReceivedAmount.append(params.getString("CompanyTempTable"));
        lastReceivedAmount.append(" company on ReceivingBill.FCompanyID=company.fid ");
        lastReceivedAmount.append(" inner join T_CAS_ReceivingBillType recBillType on ReceivingBill.FRecBillTypeID = recBillType.FID ");
        lastReceivedAmount.append(" and ( recBillType.fnumber ='100'  or recBillType.fnumber ='101') ");
        lastReceivedAmount.append("\n inner join t_bd_customer customer on ReceivingBill.FPayerID = customer.fid ");
        lastReceivedAmount.append("\n where ");
        lastReceivedAmount.append(queryStr.toString());
        lastReceivedAmount.append("\n group by customer.fid,company.fid,company.FLevel ");
        lastReceivedAmount.append("\n union all ");
        lastReceivedAmount.append("\n select  customer.fid customerid,company.fid companyid,'DEL' flag,company.FLevel level2");
        lastReceivedAmount.append(",0 LastSaleAmount,null saleOrderBizDate,ReceivingBill.FActRecLocAmt FActRecLocAmt,null FBizDate,null FMaxTime ");
        lastReceivedAmount.append("\n from T_CAS_ReceivingBill ReceivingBill ");
        lastReceivedAmount.append("\n inner join ");
        lastReceivedAmount.append(params.getString("CompanyTempTable"));
        lastReceivedAmount.append(" company on ReceivingBill.FCompanyID=company.fid ");
        lastReceivedAmount.append("\n inner join t_bd_customer customer on ReceivingBill.FPayerID = customer.fid ");
        lastReceivedAmount.append("\n inner join (select  customer.fid customerid ,company.fid companyid, ");
        lastReceivedAmount.append(" max(TO_CHAR(ReceivingBill.FBizDate, 'YYYY-MM-DD HH24:MI:SS') || TO_CHAR(ReceivingBill.FLastupdateTime, 'YYYY-MM-DD HH24:MI:SS')) FMaxTime ");
        lastReceivedAmount.append("\n from T_CAS_ReceivingBill ReceivingBill ");
        lastReceivedAmount.append("\n inner join ");
        lastReceivedAmount.append(params.getString("CompanyTempTable"));
        lastReceivedAmount.append(" company on ReceivingBill.FCompanyID=company.fid ");
        lastReceivedAmount.append(" inner join T_CAS_ReceivingBillType recBillType on ReceivingBill.FRecBillTypeID = recBillType.FID ");
        lastReceivedAmount.append(" and ( recBillType.fnumber ='100'  or recBillType.fnumber ='101') ");
        lastReceivedAmount.append("\n inner join t_bd_customer customer on ReceivingBill.FPayerID = customer.fid ");
        lastReceivedAmount.append("\n where ");
        lastReceivedAmount.append(queryStr.toString());
        lastReceivedAmount.append("\n\tgroup by customer.fid,company.fid) d on  customer.fid = d.customerid");
        lastReceivedAmount.append("\tand  company.fid = d.companyid ");
        lastReceivedAmount.append(" and (TO_CHAR(ReceivingBill.FBizDate, 'YYYY-MM-DD HH24:MI:SS') || TO_CHAR(ReceivingBill.FLastupdateTime, 'YYYY-MM-DD HH24:MI:SS')) = d.FMaxTime ");
        lastReceivedAmount.append("\n ) t ");
        lastReceivedAmount.append("\n group by t.customerid,t.companyid,t.flag,t.level2 ");
        DbUtil.execute((Context)ctx, (String)lastReceivedAmount.toString());
    }

    private String getSaleAmount(RptParams params, Context ctx) throws BOSException {
        String beginDate = params.getString("dateStart");
        String endDate = params.getString("dateEnd");
        StringBuffer queryStr = new StringBuffer();
        queryStr.append(" and (entry.FBaseStatus =4 or  entry.FBaseStatus =6 or entry.FBaseStatus =7 ) ");
        if (!"true".equals(params.getString("IsTotalWithAll"))) {
            queryStr.append(" and saleorder.FBizDate >= {").append(beginDate).append("} ");
        }
        queryStr.append(" and saleorder.FBizDate <= {").append(endDate).append("}");
        queryStr.append(" and company.FIsleaf = 1 ");
        StringBuffer saleAmount = new StringBuffer();
        saleAmount.append(" select '88888888' fid,");
        switch (new Integer(params.getString("CustomerType"))) {
            case 1: {
                saleAmount.append("Entry.FReceiveCustomerID customerId ");
                break;
            }
            case 2: {
                saleAmount.append("Entry.FDeliveryCustomerID customerId ");
                break;
            }
            case 3: {
                saleAmount.append("saleorder.FOrderCustomerID customerId ");
            }
        }
        saleAmount.append(",company.fid companyId,'DEL' flag,company.FLevel level2");
        saleAmount.append(",0 AccountReceive");
        saleAmount.append(",0 LastSaleAmount,0 LastReceivedAmount");
        if ("true".equals(params.getString("IsTotalWithAll"))) {
            saleAmount.append(",sum(case when saleorder.FBizDate >= {").append(beginDate).append("} then entry.FLocalTaxAmount else 0 end) SaleAmount");
        } else {
            saleAmount.append(",sum(entry.FLocalTaxAmount) SaleAmount");
        }
        saleAmount.append(",0 ReturnRequestAmount,0 SaleIssueAmount,0 InvoiceAmount");
        saleAmount.append(",0 ReceivedAmount,0 ReturnOrderAmoun,0 ReceivedCount");
        if ("true".equals(params.getString("IsTotalWithAll"))) {
            saleAmount.append(",sum(entry.FLocalTaxAmount) TotalSaleAmount");
        } else {
            saleAmount.append(",0 TotalSaleAmount");
        }
        saleAmount.append(",0 TotalReturnRequestAmount,0 TotalSaleIssueAmount");
        saleAmount.append(",0 TotalInvoiceAmount,0 TotalReceivedAmount,0 TotalReturnOrderAmoun,0 TotalReceivedCount ");
        saleAmount.append("\n from t_sd_saleorder saleorder ");
        saleAmount.append("\n inner join t_sd_saleorderentry entry on saleOrder.FID = entry.FParentID ");
        saleAmount.append("\n inner join ");
        saleAmount.append(params.getString("CompanyTempTable"));
        saleAmount.append(" company on saleorder.FCompanyOrgUnitID=company.fid");
        saleAmount.append("\n where 1 = 1");
        saleAmount.append(queryStr.toString());
        saleAmount.append("\n group by ");
        switch (new Integer(params.getString("CustomerType"))) {
            case 1: {
                saleAmount.append("Entry.FReceiveCustomerID");
                break;
            }
            case 2: {
                saleAmount.append("Entry.FDeliveryCustomerID");
                break;
            }
            case 3: {
                saleAmount.append("saleorder.FOrderCustomerID");
            }
        }
        saleAmount.append(",company.fid,company.FLevel");
        return saleAmount.toString();
    }

    private String getReturnRequestAmount(RptParams params, Context ctx) throws BOSException {
        String beginDate = params.getString("dateStart");
        String endDate = params.getString("dateEnd");
        StringBuffer queryStr = new StringBuffer();
        if (!"true".equals(params.getString("IsTotalWithAll"))) {
            queryStr.append(" and saleReturn.FBizDate  >= {").append(beginDate).append("}");
            queryStr.append(" and (entry.FBaseStatus =4 or  entry.FBaseStatus =6 ");
            queryStr.append(" or entry.FBaseStatus =7 ) ");
        }
        queryStr.append(" and saleReturn.FBizDate  <= {").append(endDate).append("}");
        queryStr.append(" and company.FIsleaf = 1 ");
        StringBuffer returnRequestAmount = new StringBuffer();
        returnRequestAmount.append("select '88888888' fid,saleReturn.fReturnscustomerid customerId,company.fid companyId");
        returnRequestAmount.append(",'DEL' flag,company.FLevel level2");
        returnRequestAmount.append(",0 AccountReceive");
        returnRequestAmount.append(",0 LastSaleAmount,0 LastReceivedAmount");
        returnRequestAmount.append(",0 SaleAmount");
        if ("true".equals(params.getString("IsTotalWithAll"))) {
            returnRequestAmount.append(",sum(case when saleReturn.FBizDate  >= {").append(beginDate).append("} then entry.FLocalTaxAmount else 0 end) ReturnRequestAmount");
        } else {
            returnRequestAmount.append(",sum(entry.FLocalTaxAmount) ReturnRequestAmount");
        }
        returnRequestAmount.append(",0 SaleIssueAmount,0 InvoiceAmount");
        returnRequestAmount.append(",0 ReceivedAmount,0 ReturnOrderAmoun,0 ReceivedCount");
        returnRequestAmount.append(",0 TotalSaleAmount");
        if ("true".equals(params.getString("IsTotalWithAll"))) {
            returnRequestAmount.append(",sum(entry.FLocalTaxAmount) TotalReturnRequestAmount");
        } else {
            returnRequestAmount.append(",0 TotalReturnRequestAmount");
        }
        returnRequestAmount.append(",0 TotalSaleIssueAmount");
        returnRequestAmount.append(",0 TotalInvoiceAmount,0 TotalReceivedAmount,0 TotalReturnOrderAmoun,0 TotalReceivedCount ");
        returnRequestAmount.append("\n from T_SD_SaleReturns saleReturn ");
        returnRequestAmount.append("\n inner join T_SD_SaleReturnsentry entry on saleReturn.FID = entry.FParentID ");
        returnRequestAmount.append("\n inner join ");
        returnRequestAmount.append(params.getString("CompanyTempTable"));
        returnRequestAmount.append(" company on saleReturn.FCompanyOrgUnitID=company.fid");
        returnRequestAmount.append("\n where 1 = 1 ");
        returnRequestAmount.append(queryStr.toString());
        returnRequestAmount.append("\n group by saleReturn.fReturnscustomerid,company.fid,company.flevel ");
        return returnRequestAmount.toString();
    }

    private String getSaleIssueAmount(RptParams params, Context ctx) throws BOSException {
        String beginDate = params.getString("dateStart");
        String endDate = params.getString("dateEnd");
        StringBuffer queryStr = new StringBuffer();
        if (!"true".equals(params.getString("IsTotalWithAll"))) {
            queryStr.append(" and saleIssue.FBizDate  >= {").append(beginDate).append("}");
        } else {
            queryStr.append(" and abs(entry.FBaseQty) > abs(entry.FreverseBaseQty) ");
            queryStr.append(" and abs(entry.FBaseQty) >0 ");
        }
        queryStr.append(" and saleIssue.FBaseStatus = 4");
        queryStr.append(" and saleIssue.FBizDate <= {").append(endDate).append("}");
        queryStr.append(" and saleIssue.FTransactionTypeid <> 'DawAAAAPoBKwCNyn'");
        queryStr.append(" and company.FIsleaf = 1 ");
        StringBuffer saleIssueAmount = new StringBuffer();
        saleIssueAmount.append("select '88888888' fid");
        switch (new Integer(params.getString("CustomerType"))) {
            case 1: {
                saleIssueAmount.append(",entry.FBalanceCustomerID customerid ");
                break;
            }
            case 2: {
                saleIssueAmount.append(",saleIssue.FCustomerID customerid ");
                break;
            }
            case 3: {
                saleIssueAmount.append(",entry.FOrderCustomerID customerid ");
            }
        }
        saleIssueAmount.append(",company.fid companyId");
        saleIssueAmount.append(",'DEL' flag,company.FLevel level2");
        saleIssueAmount.append(",0 AccountReceive");
        saleIssueAmount.append(",0 LastSaleAmount,0 LastReceivedAmount,0 SaleAmount,0 ReturnRequestAmount");
        if ("true".equals(params.getString("IsTotalWithAll"))) {
            saleIssueAmount.append(",sum(case when saleIssue.FBizDate  >= {").append(beginDate).append("} then entry.FLocalAmount else 0 end) SaleIssueAmount");
        } else {
            saleIssueAmount.append(",sum(entry.FLocalAmount) SaleIssueAmount");
        }
        saleIssueAmount.append(",0 InvoiceAmount,0 ReceivedAmount,0 ReturnOrderAmoun,0 ReceivedCount,0 TotalSaleAmount,0 TotalReturnRequestAmount");
        if ("true".equals(params.getString("IsTotalWithAll"))) {
            saleIssueAmount.append(",sum(entry.FLocalAmount) TotalSaleIssueAmount");
        } else {
            saleIssueAmount.append(",0 TotalSaleIssueAmount");
        }
        saleIssueAmount.append(",0 TotalInvoiceAmount,0 TotalReceivedAmount,0 TotalReturnOrderAmoun,0 TotalReceivedCount ");
        saleIssueAmount.append("\n from T_IM_SaleIssueBill saleIssue ");
        saleIssueAmount.append("\n inner join T_IM_SaleIssueentry entry on saleIssue.fid = entry.fparentid ");
        saleIssueAmount.append("\n LEFT OUTER join T_ORG_Storage storage on saleIssue.FStorageOrgUnitID = storage.fid ");
        saleIssueAmount.append("\n  inner join T_ORG_UnitRelation r on saleIssue.FStorageOrgUnitID=r.FFromUnitID ");
        saleIssueAmount.append("\n LEFT OUTER join ");
        saleIssueAmount.append(params.getString("CompanyTempTable"));
        saleIssueAmount.append(" company on r.FToUnitID=company.fid ");
        saleIssueAmount.append("\n where 1 = 1");
        saleIssueAmount.append(queryStr.toString());
        saleIssueAmount.append(" and r.ftyperelationid='").append("00000000-0000-0000-0000-0000000000070FE9F8B5").append("' ");
        saleIssueAmount.append("\n group by ");
        switch (new Integer(params.getString("CustomerType"))) {
            case 1: {
                saleIssueAmount.append(" entry.FBalanceCustomerID");
                break;
            }
            case 2: {
                saleIssueAmount.append(" saleIssue.FCustomerID");
                break;
            }
            case 3: {
                saleIssueAmount.append(" entry.FOrderCustomerID");
            }
        }
        saleIssueAmount.append(",company.fid,company.flevel ");
        return saleIssueAmount.toString();
    }

    private String getOtherBillAmount(RptParams params, Context ctx) throws BOSException {
        String beginDate = params.getString("dateStart");
        String endDate = params.getString("dateEnd");
        StringBuffer queryStr = new StringBuffer();
        if (!"true".equals(params.getString("IsTotalWithAll"))) {
            queryStr.append(" and OtherBill.FBizDate  >= {").append(beginDate).append("} ");
        }
        queryStr.append(" and OtherBill.FBizDate <= {").append(endDate).append("}");
        queryStr.append(" and company.FIsleaf = 1 ");
        queryStr.append(" and OtherBill.FBillStatus = 3 ");
        if (!"true".equals(params.getString("IsIncludeExInvoice"))) {
            queryStr.append(" and OtherBill.FBillType = '102' ");
        } else {
            queryStr.append(" and (OtherBill.FBillType in (102,103,104)) ");
        }
        StringBuffer otherBillAmount = new StringBuffer();
        otherBillAmount.append("select '88888888' fid, OtherBill.FAssTActID customerId,company.fid companyId");
        otherBillAmount.append(",'DEL' flag,company.FLevel level2");
        otherBillAmount.append(",0 AccountReceive");
        otherBillAmount.append(",0 LastSaleAmount,0 LastReceivedAmount");
        otherBillAmount.append(",0 SaleAmount,0 ReturnRequestAmount,0 SaleIssueAmount");
        if ("true".equals(params.getString("IsTotalWithAll"))) {
            otherBillAmount.append(",sum(case when OtherBill.FBizDate  >= {").append(beginDate).append("} then OtherBill.FAmountLocal else 0 end) InvoiceAmount");
        } else {
            otherBillAmount.append(",sum(OtherBill.FAmountLocal) InvoiceAmount");
        }
        otherBillAmount.append(",0 ReceivedAmount,0 ReturnOrderAmoun,0 ReceivedCount");
        otherBillAmount.append(",0 TotalSaleAmount,0 TotalReturnRequestAmount,0 TotalSaleIssueAmount");
        if ("true".equals(params.getString("IsTotalWithAll"))) {
            otherBillAmount.append(",sum(OtherBill.FAmountLocal) TotalInvoiceAmount");
        } else {
            otherBillAmount.append(",0 TotalInvoiceAmount");
        }
        otherBillAmount.append(",0 TotalReceivedAmount,0 TotalReturnOrderAmoun,0 TotalReceivedCount ");
        otherBillAmount.append("\n from T_AR_OtherBill OtherBill  ");
        otherBillAmount.append("\n inner join ");
        otherBillAmount.append(params.getString("CompanyTempTable"));
        otherBillAmount.append(" company on OtherBill.FCompanyID=company.fid ");
        otherBillAmount.append("\n where 1 = 1 ");
        otherBillAmount.append(queryStr.toString());
        otherBillAmount.append("\n group by OtherBill.FAssTActID,company.fid,company.flevel ");
        otherBillAmount.append("\n having sum(OtherBill.FAmountLocal) >0");
        return otherBillAmount.toString();
    }

    private String getReceivedAmount(RptParams params, Context ctx) throws BOSException {
        String beginDate = params.getString("dateStart");
        String endDate = params.getString("dateEnd");
        StringBuffer queryStr = new StringBuffer();
        if (!"true".equals(params.getString("IsTotalWithAll"))) {
            queryStr.append(" and ReceivingBill.FBizDate >= {").append(beginDate).append("}");
        }
        queryStr.append(" and ReceivingBill.FBizDate <= {").append(endDate).append("}");
        queryStr.append(" and ( ReceivingBill.FBillStatus = 14 ) ");
        queryStr.append(" and company.FIsleaf = 1 ");
        StringBuffer receivedAmount = new StringBuffer();
        receivedAmount.append("select '88888888' fid,ReceivingBill.FPayerID customerid,company.fid companyId");
        receivedAmount.append(",'DEL' flag,company.FLevel level2");
        receivedAmount.append(",0 AccountReceive");
        receivedAmount.append(",0 LastSaleAmount,0 LastReceivedAmount");
        receivedAmount.append(",0 SaleAmount,0 ReturnRequestAmount,0 SaleIssueAmount,0 InvoiceAmount");
        if ("true".equals(params.getString("IsTotalWithAll"))) {
            receivedAmount.append("\n,sum(CASE WHEN ((recBillType.FNumber = '100') or (recBillType.FNumber = '101')) ");
            receivedAmount.append("   and (ReceivingBill.FBizDate >= {").append(beginDate).append("})");
            receivedAmount.append(" THEN ReceivingBill.FActRecLocAmt ELSE 0 END) ReceivedAmount");
            receivedAmount.append("\n ,sum(CASE  WHEN ((recBillType.FNumber = '102') or (recBillType.FNumber = '103')) ");
            receivedAmount.append("   and (ReceivingBill.FBizDate >= {").append(beginDate).append("})");
            receivedAmount.append(" THEN ReceivingBill.FActRecLocAmt ELSE 0 END) ReturnOrderAmoun");
        } else {
            receivedAmount.append("\n,sum(CASE WHEN ((recBillType.FNumber = '100') or (recBillType.FNumber = '101')) ");
            receivedAmount.append(" THEN ReceivingBill.FActRecLocAmt ELSE 0 END) ReceivedAmount");
            receivedAmount.append("\n ,sum(CASE  WHEN ((recBillType.FNumber = '102') or (recBillType.FNumber = '103')) ");
            receivedAmount.append(" THEN ReceivingBill.FActRecLocAmt ELSE 0 END) ReturnOrderAmoun");
        }
        receivedAmount.append(",0 ReceivedCount,0 TotalSaleAmount,0 TotalReturnRequestAmount,0 TotalSaleIssueAmount,0 TotalInvoiceAmount");
        if ("true".equals(params.getString("IsTotalWithAll"))) {
            receivedAmount.append("\n,sum(CASE WHEN ((recBillType.FNumber = '100') or (recBillType.FNumber = '101')) ");
            receivedAmount.append(" THEN ReceivingBill.FActRecLocAmt ELSE 0 END) TotalReceivedAmount");
            receivedAmount.append("\n ,sum(CASE  WHEN ((recBillType.FNumber = '102') or (recBillType.FNumber = '103')) ");
            receivedAmount.append(" THEN ReceivingBill.FActRecLocAmt ELSE 0 END) TotalReturnOrderAmoun");
        } else {
            receivedAmount.append(",0 TotalReceivedAmount,0 TotalReturnOrderAmoun");
        }
        receivedAmount.append(",0 TotalReceivedCount ");
        receivedAmount.append("\n from T_CAS_ReceivingBill ReceivingBill ");
        receivedAmount.append("\n inner join ");
        receivedAmount.append(params.getString("CompanyTempTable"));
        receivedAmount.append(" company on ReceivingBill.FCompanyID=company.fid ");
        receivedAmount.append(" inner join T_CAS_ReceivingBillType recBillType on ReceivingBill.FRecBillTypeID = recBillType.FID ");
        receivedAmount.append("\n where 1 = 1 ");
        receivedAmount.append(queryStr.toString());
        receivedAmount.append("\n group by ReceivingBill.FPayerID,company.fid,company.flevel");
        return receivedAmount.toString();
    }

    private String getReceivedCount(RptParams params, Context ctx) throws BOSException {
        boolean isTotalWithAll;
        String beginDate = params.getString("dateStart");
        String endDate = params.getString("dateEnd");
        StringBuffer queryStr = new StringBuffer("where 1 = 1 ");
        boolean bl = isTotalWithAll = "true".equals(params.getString("IsTotalWithAll"));
        if (!isTotalWithAll) {
            queryStr.append(" and saleIssue.FBizDate >= {").append(beginDate).append("}");
        }
        queryStr.append(" and saleIssue.FBizDate <= {").append(endDate).append("}");
        queryStr.append(" and saleIssue.FBaseStatus =4 ");
        queryStr.append(" and (saleIssue.FIsReversed=0 or  saleIssue.FIsReversed is null ) ");
        queryStr.append(" and ritype.FBizDirection = 1");
        queryStr.append(" and r.ftyperelationid='").append("00000000-0000-0000-0000-0000000000070FE9F8B5").append("' ");
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select saleIssue.fid FBillID,saleIssue.FBizDate FBizDate");
        switch (new Integer(params.getString("CustomerType"))) {
            case 1: {
                selectSql.append(",entry.FBalanceCustomerID  customerid ");
                break;
            }
            case 2: {
                selectSql.append(",saleIssue.FCustomerID customerid ");
                break;
            }
            case 3: {
                selectSql.append(",entry.FOrderCustomerID customerid ");
            }
        }
        selectSql.append(",company.fid companyId,company.FLevel level2");
        selectSql.append("\n from T_IM_SaleIssueBill saleIssue ");
        selectSql.append("\n inner join  t_scm_transactiontype transtype on saleIssue.ftransactiontypeid =  transtype.fid ");
        selectSql.append("\n inner join T_IM_RecIssueType riType on transtype.fritypeid = ritype.fid ");
        switch (new Integer(params.getString("CustomerType"))) {
            case 1: {
                selectSql.append("inner join t_im_saleIssueentry entry  on saleIssue.fid =entry.fparentid ");
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                selectSql.append("inner join t_im_saleIssueentry entry  on saleIssue.fid =entry.fparentid ");
            }
        }
        selectSql.append("\n inner join T_ORG_Storage storage on saleIssue.FStorageOrgUnitID = storage.fid ");
        selectSql.append("\n  inner join T_ORG_UnitRelation r on saleIssue.FStorageOrgUnitID=r.FFromUnitID ");
        selectSql.append("\n inner join ");
        selectSql.append(params.getString("CompanyTempTable"));
        selectSql.append(" company on r.FToUnitID=company.fid ");
        StringBuffer groupBySql = new StringBuffer("");
        groupBySql.append("\n group by ");
        switch (new Integer(params.getString("CustomerType"))) {
            case 1: {
                groupBySql.append("entry.FBalanceCustomerID");
                break;
            }
            case 2: {
                groupBySql.append("saleIssue.FCustomerID");
                break;
            }
            case 3: {
                groupBySql.append("entry.FOrderCustomerID");
            }
        }
        groupBySql.append(",company.fid,company.flevel,saleIssue.fid,saleIssue.FBizDate ");
        String companyTable = params.getString("CompanyTempTable");
        IParamItem iParamItem = ParamItemFactory.getLocalInstance((Context)ctx);
        FilterInfo i = new FilterInfo();
        i.getFilterItems().add(new FilterItemInfo("keyID.number", (Object)"CONSIGNSALES", CompareType.EQUALS));
        i.getFilterItems().add(new FilterItemInfo("orgUnitID.id", (Object)(" select FID from " + companyTable), CompareType.INNER));
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("orgUnitID"));
        evi.getSelector().add(new SelectorItemInfo("value"));
        evi.setFilter(i);
        ParamItemCollection paramItemColl = iParamItem.getParamItemCollection(evi);
        if (paramItemColl == null || paramItemColl.size() == 0) {
            return "";
        }
        StringBuffer companyOrgIds_yes = new StringBuffer("");
        StringBuffer companyOrgIds_no = new StringBuffer("");
        int size = paramItemColl.size();
        for (int j = 0; j < size; ++j) {
            if ("false".equals(paramItemColl.get(j).getValue())) {
                companyOrgIds_no.append("'").append(paramItemColl.get(j).getOrgUnitID().getId().toString()).append("',");
                continue;
            }
            if (!"true".equals(paramItemColl.get(j).getValue())) continue;
            companyOrgIds_yes.append("'").append(paramItemColl.get(j).getOrgUnitID().getId().toString()).append("',");
        }
        StringBuffer subSql_no = new StringBuffer("");
        if (companyOrgIds_no.length() > 0) {
            companyOrgIds_no = companyOrgIds_no.deleteCharAt(companyOrgIds_no.length() - 1);
            selectSql.append("\n left outer join  T_SCM_TransactionBizType tbizType on tbizType.ftransactiontypeid =  transtype.fid ");
            selectSql.append("\n left outer join  T_SCM_BizType bizType on bizType.fid =  tbizType.FBizTypeID ");
            subSql_no.append(selectSql).append(queryStr);
            subSql_no.append(" and company.fid in (").append(companyOrgIds_no).append(")");
            subSql_no.append(" and ((ritype.FBizDirection = 1 and bizType.FNumber = '230' ) or (bizType.FNumber <> '230'))");
            subSql_no.append(groupBySql);
        }
        StringBuffer subSql_yes = new StringBuffer("");
        if (companyOrgIds_yes.length() > 0) {
            companyOrgIds_yes = companyOrgIds_yes.deleteCharAt(companyOrgIds_yes.length() - 1);
            subSql_yes.append(selectSql).append(queryStr);
            subSql_yes.append(" and company.fid in (").append(companyOrgIds_yes).append(")");
            subSql_yes.append(groupBySql);
        }
        StringBuffer receivedCount = new StringBuffer();
        receivedCount.append("select '88888888' fid, TMP.customerid customerid,TMP.companyId companyId,'DEL' flag,TMP.level2 level2");
        receivedCount.append(",0 AccountReceive");
        receivedCount.append(",0 LastSaleAmount,0 LastReceivedAmount");
        receivedCount.append(",0 SaleAmount,0 ReturnRequestAmount,0 SaleIssueAmount,0 InvoiceAmount");
        receivedCount.append(",0 ReceivedAmount,0 ReturnOrderAmoun");
        if (isTotalWithAll) {
            receivedCount.append(",sum(case when TMP.FBizDate >= {").append(beginDate).append("} then 1 else 0 end) ReceivedCount");
        } else {
            receivedCount.append(",count(TMP.FBillID) ReceivedCount");
        }
        receivedCount.append(",0 TotalSaleAmount,0 TotalReturnRequestAmount,0 TotalSaleIssueAmount");
        receivedCount.append(",0 TotalInvoiceAmount,0 TotalReceivedAmount,0 TotalReturnOrderAmoun");
        if (isTotalWithAll) {
            receivedCount.append(",count(TMP.FBillID) TotalReceivedCount");
        } else {
            receivedCount.append(",0 TotalReceivedCount");
        }
        if (subSql_no.length() > 0) {
            receivedCount.append(" from (").append(subSql_no);
            if (subSql_yes.length() > 0) {
                receivedCount.append(" union all ").append(subSql_yes);
            }
            receivedCount.append(") as TMP GROUP BY TMP.customerid,TMP.companyId,TMP.level2 ");
        } else if (subSql_yes.length() > 0) {
            receivedCount.append(" from (").append(subSql_yes).append(") as TMP GROUP BY TMP.customerid,TMP.companyId,TMP.level2 ");
        }
        return receivedCount.toString();
    }

    private String getTotalSaleAmount(RptParams params, Context ctx) throws BOSException {
        String endDate = params.getString("dateEnd");
        StringBuffer queryStr = new StringBuffer();
        queryStr.append(" (entry.FBaseStatus =4 or  entry.FBaseStatus =6 ");
        queryStr.append(" or entry.FBaseStatus =7 ) and ");
        if ("true".equals(params.getString("IsTotalWithAll"))) {
            queryStr.append("saleorder.FBizDate <= {" + endDate + "}");
        } else {
            queryStr.append("saleorder.FBizDate >= {" + endDate + "}");
            queryStr.append(" and saleorder.FBizDate <= {" + endDate + "}");
        }
        queryStr.append(" and company.FIsleaf = 1 ");
        if (params.getString("CustomerFrom") != null) {
            queryStr.append(" and Customer.FNumber >= ? ");
        }
        if (params.getString("CustomerTo") != null) {
            queryStr.append(" and Customer.FNumber <= ? ");
        }
        StringBuffer saleAmount = new StringBuffer();
        saleAmount.append(" select '88888888',customer.fid,company.fid");
        saleAmount.append(",'DEL' flag,company.FLevel level2");
        saleAmount.append(",0 AccountReceiveAmount,0 LastSaleAmount,null LastSaleDate");
        saleAmount.append(" ,0 LastReceivedAmount,null LastReceivedDate");
        saleAmount.append(",0 SaleAmount,0 ReturnRequestAmount,0 SaleIssueAmount,0 InvoiceAmount");
        saleAmount.append(",0 ReceivedAmount,0 ReturnOrderAmoun,0 ReceivedCount");
        saleAmount.append(",sum(entry.FLocalTaxAmount) TotalSaleAmount,0 TotalReturnRequestAmount,0 TotalSaleIssueAmount");
        saleAmount.append(",0 TotalInvoiceAmount,0 TotalReceivedAmount,0 TotalReturnOrderAmoun,0 TotalReceivedCount,null ");
        saleAmount.append("\n from t_sd_saleorder saleorder ");
        saleAmount.append("\n inner join t_sd_saleorderentry entry on saleOrder.FID = entry.FParentID ");
        switch (new Integer(params.getString("CustomerType"))) {
            case 1: {
                saleAmount.append("\n inner join t_bd_customer customer ");
                saleAmount.append("on Entry.FReceiveCustomerID = customer.fid ");
                break;
            }
            case 2: {
                saleAmount.append("\n inner join t_bd_customer customer ");
                saleAmount.append("on Entry.FDeliveryCustomerID = customer.fid ");
                break;
            }
            case 3: {
                saleAmount.append("\n inner join t_bd_customer customer ");
                saleAmount.append("on saleorder.FOrderCustomerID = customer.fid ");
            }
        }
        saleAmount.append("\n inner join ");
        saleAmount.append(params.getString("CompanyTempTable"));
        saleAmount.append(" company on entry.FCompanyOrgUnitID=company.fid ");
        saleAmount.append("\n where ");
        saleAmount.append(queryStr.toString());
        saleAmount.append("\n group by customer.fid,company.fid,company.flevel");
        return saleAmount.toString();
    }

    private String getTotalReturnRequestAmount(RptParams params, Context ctx) throws BOSException {
        String endDate = params.getString("dateEnd");
        StringBuffer queryStr = new StringBuffer();
        if ("true".equals(params.getString("IsTotalWithAll"))) {
            queryStr.append("saleReturn.FBizDate <= {" + endDate + "}");
        } else {
            queryStr.append("saleReturn.FBizDate >= {" + endDate + "}");
            queryStr.append(" and saleReturn.FBizDate <= {" + endDate + "}");
        }
        queryStr.append(" and company.FIsleaf = 1 ");
        if (params.getString("CustomerFrom") != null) {
            queryStr.append(" and Customer.FNumber >= ? ");
        }
        if (params.getString("CustomerTo") != null) {
            queryStr.append(" and Customer.FNumber <= ? ");
        }
        String returnRequestAmount = "select '88888888',customer.fid,company.fid,'DEL' flag,company.FLevel level2,0 AccountReceiveAmount,0 LastSaleAmount,null LastSaleDate ,0 LastReceivedAmount,null LastReceivedDate,0 SaleAmount,0 ReturnRequestAmount,0 SaleIssueAmount,0 InvoiceAmount,0 ReceivedAmount,0 ReturnOrderAmoun,0 ReceivedCount,0 TotalSaleAmount,sum(entry.FLocalTaxAmount) TotalReturnRequestAmount,0 TotalSaleIssueAmount,0 TotalInvoiceAmount,0 TotalReceivedAmount,0 TotalReturnOrderAmoun,0 TotalReceivedCount,null \n from T_SD_SaleReturns saleReturn \n inner join T_SD_SaleReturnsentry entry on saleReturn.FID = entry.FParentID \n inner join t_bd_customer customer on saleReturn.fReturnscustomerid = customer.fid \n inner join " + params.getString("CompanyTempTable") + " company on entry.FCompanyOrgUnitID=company.fid \n where " + queryStr.toString() + "\n group by customer.fid,company.fid,company.flevel";
        return returnRequestAmount;
    }

    private String getTotalSaleIssueAmount(RptParams params, Context ctx) throws BOSException {
        String endDate = params.getString("dateEnd");
        StringBuffer queryStr = new StringBuffer();
        if ("true".equals(params.getString("IsTotalWithAll"))) {
            queryStr.append(" saleIssue.FBizDate <= {" + endDate + "}");
        } else {
            queryStr.append(" saleIssue.FBizDate >= {" + endDate + "}");
            queryStr.append(" and saleIssue.FBizDate <= {" + endDate + "}");
        }
        queryStr.append(" and company.FIsleaf = 1 ");
        queryStr.append(" and  ( saleIssue.FBaseStatus = 4 )  and abs(entry.FBaseQty) > abs(entry.FreverseBaseQty)  and entry.FBaseQty >0 ");
        if (params.getString("CustomerFrom") != null) {
            queryStr.append(" and Customer.FNumber >= ? ");
        }
        if (params.getString("CustomerTo") != null) {
            queryStr.append(" and Customer.FNumber <= ? ");
        }
        StringBuffer saleIssueAmount = new StringBuffer();
        saleIssueAmount.append("select '88888888',customer.fid,company.fid");
        saleIssueAmount.append(",'DEL' flag,company.FLevel level2");
        saleIssueAmount.append(",0 AccountReceiveAmount,0 LastSaleAmount,null LastSaleDate");
        saleIssueAmount.append(" ,0 LastReceivedAmount,null LastReceivedDate");
        saleIssueAmount.append(",0 SaleAmount,0 ReturnRequestAmount,0 SaleIssueAmount,0 InvoiceAmount");
        saleIssueAmount.append(",0 ReceivedAmount,0 ReturnOrderAmoun,0 ReceivedCount");
        saleIssueAmount.append(",0 TotalSaleAmount,0 TotalReturnRequestAmount,sum(entry.FLocalAmount) TotalSaleIssueAmount");
        saleIssueAmount.append(",0 TotalInvoiceAmount,0 TotalReceivedAmount,0 TotalReturnOrderAmoun,0 TotalReceivedCount,null ");
        saleIssueAmount.append("\n from T_IM_SaleIssueBill saleIssue ");
        saleIssueAmount.append("\n inner join T_IM_SaleIssueentry entry on saleIssue.fid = entry.fparentid ");
        switch (new Integer(params.getString("CustomerType"))) {
            case 1: {
                saleIssueAmount.append("\n inner join t_bd_customer customer ");
                saleIssueAmount.append("on entry.FBalanceCustomerID = customer.fid ");
                break;
            }
            case 2: {
                saleIssueAmount.append("\n inner join t_bd_customer customer ");
                saleIssueAmount.append("on saleIssue.FCustomerID = customer.fid ");
                break;
            }
            case 3: {
                saleIssueAmount.append("\n inner join t_bd_customer customer ");
                saleIssueAmount.append("on entry.FOrderCustomerID = customer.fid ");
            }
        }
        saleIssueAmount.append("\n LEFT OUTER join T_ORG_Storage storage on saleIssue.FStorageOrgUnitID = storage.fid ");
        saleIssueAmount.append("\n  inner join T_ORG_UnitRelation r on saleIssue.FStorageOrgUnitID=r.FFromUnitID ");
        saleIssueAmount.append("\n LEFT OUTER join ");
        saleIssueAmount.append(params.getString("CompanyTempTable"));
        saleIssueAmount.append(" company on r.FToUnitID=company.fid ");
        saleIssueAmount.append("\n where ");
        saleIssueAmount.append(queryStr.toString());
        saleIssueAmount.append(" and r.ftyperelationid='").append("00000000-0000-0000-0000-0000000000070FE9F8B5").append("' ");
        saleIssueAmount.append("\n group by customer.fid,company.fid,company.flevel ");
        return saleIssueAmount.toString();
    }

    private String getTotalOtherBillAmount(RptParams params, Context ctx) throws BOSException {
        String endDate = params.getString("dateEnd");
        StringBuffer queryStr = new StringBuffer();
        if ("true".equals(params.getString("IsTotalWithAll"))) {
            queryStr.append(" OtherBill.FBizDate <= {" + endDate + "}");
        } else {
            queryStr.append(" OtherBill.FBizDate >= {" + endDate + "}");
            queryStr.append(" and OtherBill.FBizDate <= {" + endDate + "}");
        }
        queryStr.append(" and company.FIsleaf = 1 ");
        queryStr.append(" and OtherBill.FBillStatus = 3 ");
        if (!"true".equals(params.getString("IsIncludeExInvoice"))) {
            queryStr.append(" and  OtherBill.FBillType = '102' ");
        } else {
            queryStr.append(" and (OtherBill.FBillType in (102,103,104)) ");
        }
        if (params.getString("CustomerFrom") != null) {
            queryStr.append(" and Customer.FNumber >= ? ");
        }
        if (params.getString("CustomerTo") != null) {
            queryStr.append(" and Customer.FNumber <= ? ");
        }
        String otherBillAmount = "select '88888888',customer.fid,company.fid,'DEL' flag,company.FLevel level2,0 AccountReceiveAmount,0 LastSaleAmount,null LastSaleDate ,0 LastReceivedAmount,null LastReceivedDate,0 SaleAmount,0 ReturnRequestAmount,0 SaleIssueAmount,0 InvoiceAmount,0 ReceivedAmount,0 ReturnOrderAmoun,0 ReceivedCount,0 TotalSaleAmount,0 TotalReturnRequestAmount,0 TotalSaleIssueAmount,sum(OtherBill.FAmountLocal) TotalInvoiceAmount,0 TotalReceivedAmount,0 TotalReturnOrderAmoun,0 TotalReceivedCount,null \n from T_AR_OtherBill OtherBill  \n inner join t_bd_customer customer on OtherBill.FAssTActID = customer.fid \n inner join " + params.getString("CompanyTempTable") + " company on OtherBill.FCompanyID=company.fid \n where " + queryStr.toString() + "\n group by customer.fid,company.fid,company.flevel \n having sum(OtherBill.FAmountLocal) >0";
        return otherBillAmount;
    }

    private String getTotalReceivedAmount(RptParams params, Context ctx) throws BOSException {
        String endDate = params.getString("dateEnd");
        StringBuffer queryStr = new StringBuffer();
        if ("true".equals(params.getString("IsTotalWithAll"))) {
            queryStr.append(" ReceivingBill.FBizDate <= {" + endDate + "}");
        } else {
            queryStr.append(" ReceivingBill.FBizDate >= {" + endDate + "}");
            queryStr.append(" and ReceivingBill.FBizDate <= {" + endDate + "}");
        }
        queryStr.append(" and ( ReceivingBill.FBillStatus = 14 ) ");
        queryStr.append(" and company.FIsleaf = 1 ");
        if (params.getString("CustomerFrom") != null) {
            queryStr.append(" and Customer.FNumber >= ? ");
        }
        if (params.getString("CustomerTo") != null) {
            queryStr.append(" and Customer.FNumber <= ? ");
        }
        String receivedAmount = "select '88888888',customer.fid,company.fid,'DEL' flag,company.FLevel level2,0 AccountReceiveAmount,0 LastSaleAmount,null LastSaleDate ,0 LastReceivedAmount,null LastReceivedDate,0 SaleAmount,0 ReturnRequestAmount,0 SaleIssueAmount,0 InvoiceAmount,0 ReceivedAmount,0 ReturnOrderAmoun,0 ReceivedCount,0 TotalSaleAmount,0 TotalReturnRequestAmount,0 TotalSaleIssueAmount,0 TotalInvoiceAmount,sum(CASE  WHEN ((recBillType.fnumber = '100')  or (recBillType.fnumber = '101'))  THEN ReceivingBill.FActRecLocAmt ELSE 0 END) TotalReceivedAmount,sum(CASE  WHEN ((recBillType.fnumber = '102')  or (recBillType.fnumber = '103'))  THEN ReceivingBill.FActRecLocAmt ELSE 0 END) TotalReturnOrderAmoun,0 TotalReceivedCount,null\n from T_CAS_ReceivingBill ReceivingBill  inner join T_CAS_ReceivingBillType recBillType on ReceivingBill.FRecBillTypeID = recBillType.FID \n inner join t_bd_customer customer on ReceivingBill.FPayerID = customer.fid \n inner join " + params.getString("CompanyTempTable") + " company on ReceivingBill.FCompanyID=company.fid \n where " + queryStr.toString() + "\n group by customer.fid,company.fid,company.flevel ";
        return receivedAmount;
    }

    private void setCustomerTradeData(SqlParams sqlParams, RptParams params, int n) {
        int count = sqlParams.size() + 1;
        for (int i = 1; i <= n; ++i) {
            if (params.getString("CustomerFrom") != null) {
                sqlParams.setString(count++, params.getString("CustomerFrom"));
            }
            if (params.getString("CustomerTo") == null) continue;
            sqlParams.setString(count++, params.getString("CustomerTo"));
        }
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    private void updateTotal(Context ctx, String tempSumTable, String orgTable, RptParams params) throws BOSException {
        String totalByCusAndCompsql = this.getInsertByIsLeafSql(tempSumTable, orgTable, params);
        DbUtil.execute((Context)ctx, (String)totalByCusAndCompsql);
        DbUtil.execute((Context)ctx, (String)("delete " + tempSumTable + " where FFlag = 'DEL'"));
        int level = (Integer)params.getObject(this.maxLevelStr);
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        DBUtil.createTempTableIndex((Context)ctx, (String)params.getString("TempResultTable"), (String)"FCustomerID,FCompanyORGUnitID", (boolean)false);
        DBUtil.createTempTableIndex((Context)ctx, (String)params.getString("LastSaleTable"), (String)"FCustomerID,FCompanyORGUnitID", (boolean)false);
        DBUtil.createTempTableIndex((Context)ctx, (String)params.getString("LastReceiveTable"), (String)"FCustomerID,FCompanyORGUnitID", (boolean)false);
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            DBUtil.AnalyseTable((Context)ctx, (Connection)conn, (String)params.getString("TempResultTable"));
            for (int i = level; i > 1; --i) {
                sql.append(this.getInstLastReceiveSql(tempSumTable, orgTable, params, i));
                DbUtil.execute((Context)ctx, (String)sql.toString());
                DBUtil.AnalyseTable((Context)ctx, (Connection)conn, (String)params.getString("LastReceiveTable"));
                sql.setLength(0);
                sql.append(this.getInstLastSaleSql(tempSumTable, orgTable, params, i));
                DbUtil.execute((Context)ctx, (String)sql.toString());
                DBUtil.AnalyseTable((Context)ctx, (Connection)conn, (String)params.getString("LastSaleTable"));
                sql.setLength(0);
                String insertCusAndCompsql = this.getInsResultTBSql(tempSumTable, orgTable, params, i);
                DbUtil.execute((Context)ctx, (String)insertCusAndCompsql.toString());
                DBUtil.AnalyseTable((Context)ctx, (Connection)conn, (String)params.getString("TempResultTable"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private String getInsResultTBSql(String tempSumTable, String orgTable, RptParams params, int i) {
        StringBuffer insertCusAndCompsql = new StringBuffer();
        String lsSaleTBName = params.getString("LastSaleTable");
        String lsReceiveTBName = params.getString("LastReceiveTable");
        insertCusAndCompsql.append(" insert into " + tempSumTable);
        insertCusAndCompsql.append("  select '88888888',temBaseData.FCustomerID,temBaseData.FOrgID");
        insertCusAndCompsql.append(",temBaseData.FFlag,temBaseData.FLevel");
        insertCusAndCompsql.append(",temBaseData.FAccountReceiveAmount");
        insertCusAndCompsql.append(",LsSaleTB.FLastSaleAmount,LsSaleTB.FLastSaleDate");
        insertCusAndCompsql.append(",lsreceivetb.FLastReceiveAmount,lsreceivetb.FLastReceiveDate");
        insertCusAndCompsql.append(",temBaseData.FSaleAmount,temBaseData.FReturnRequestAmount");
        insertCusAndCompsql.append(",temBaseData.FSaleIssueAmount,temBaseData.FInvoiceAmount");
        insertCusAndCompsql.append(",temBaseData.FReceivedAmount,temBaseData.FReturnOrderAmount");
        insertCusAndCompsql.append(",temBaseData.Freceivedcount");
        insertCusAndCompsql.append(",temBaseData.FAllSaleAmount,temBaseData.FAllReturnRequestAmount");
        insertCusAndCompsql.append(",temBaseData.FAllSaleIssueAmount,temBaseData.FAllInvoiceAmount");
        insertCusAndCompsql.append(",temBaseData.FAllReceivedAmount,temBaseData.FAllReturnOrderAmount");
        insertCusAndCompsql.append(",temBaseData.FAllReceivedCount,null ");
        insertCusAndCompsql.append(" from (");
        insertCusAndCompsql.append("  select a.FCustomerID FCustomerID,org.fparentid FOrgID");
        insertCusAndCompsql.append(",'DISPLAY' FFlag,org.FLevel FLevel");
        insertCusAndCompsql.append(",sum(a.FAccountReceiveAmount) FAccountReceiveAmount");
        insertCusAndCompsql.append(",sum(a.FSaleAmount) FSaleAmount,sum(a.FReturnRequestAmount) FReturnRequestAmount");
        insertCusAndCompsql.append(",sum(a.FSaleIssueAmount) FSaleIssueAmount,sum(a.FInvoiceAmount) FInvoiceAmount");
        insertCusAndCompsql.append(",sum(a.FReceivedAmount) FReceivedAmount,sum(a.FReturnOrderAmount) FReturnOrderAmount");
        insertCusAndCompsql.append(",sum(a.FReceivedCount) Freceivedcount");
        insertCusAndCompsql.append(",sum(a.FAllSaleAmount) FAllSaleAmount,sum(a.FAllReturnRequestAmount) FAllReturnRequestAmount");
        insertCusAndCompsql.append(",sum(a.FAllSaleIssueAmount) FAllSaleIssueAmount,sum(a.FAllInvoiceAmount) FAllInvoiceAmount");
        insertCusAndCompsql.append(",sum(a.FAllReceivedAmount) FAllReceivedAmount,sum(a.FAllReturnOrderAmount) FAllReturnOrderAmount");
        insertCusAndCompsql.append(",sum(a.FAllReceivedCount) FAllReceivedCount");
        insertCusAndCompsql.append(" from  " + tempSumTable + " a ");
        insertCusAndCompsql.append(" inner join  " + orgTable);
        insertCusAndCompsql.append(" org  on a.FCompanyORGUnitID = org.fid and org.flevel = " + i);
        insertCusAndCompsql.append(" group by a.FCustomerID,org.fparentid,org.flevel ");
        insertCusAndCompsql.append(" ) temBaseData ");
        insertCusAndCompsql.append(" inner join " + lsSaleTBName + " LsSaleTB ");
        insertCusAndCompsql.append(" on temBaseData.FCustomerID = LsSaleTB.FCustomerID ");
        insertCusAndCompsql.append(" and temBaseData.FOrgID = LsSaleTB .FCompanyORGUnitID ");
        insertCusAndCompsql.append(" inner join " + lsReceiveTBName + " LsReceiveTB ");
        insertCusAndCompsql.append(" on temBaseData.FCustomerID = LsReceiveTB.FCustomerID ");
        insertCusAndCompsql.append(" and temBaseData.FOrgID = LsReceiveTB.FCompanyORGUnitID ");
        return insertCusAndCompsql.toString();
    }

    private String getInstLastSaleSql(String tempSumTable, String orgTable, RptParams params, int i) {
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("insert into " + params.getString("LastSaleTable"));
        insertSQL.append(" select '88888888',t.Fcustomerid Fcustomerid,T.Fcompanyid ");
        insertSQL.append(" Fcompanyid,sum(t.FLastsaleAmount) ");
        insertSQL.append(" FLastsaleAmount,max(t.FLastsaleDate) FLastsaleDate ");
        insertSQL.append(" from ( ");
        insertSQL.append(" SELECT tempLsDate.Fcustomerid Fcustomerid,org.fparentid Fcompanyid");
        insertSQL.append(",0 FLastsaleAmount, max(tempLsDate.FLastsaleDate) FLastsaleDate");
        insertSQL.append(" FROM " + tempSumTable + " tempLsDate ");
        insertSQL.append(" inner join " + orgTable + " org on tempLsDate.FCompanyORGUnitID=org.fid ");
        insertSQL.append(" WHERE  org.FLevel = " + i);
        insertSQL.append(" GROUP BY tempLsDate.FCustomerID,org.FParentID,tempLsDate.FLevel");
        insertSQL.append(" union all ");
        insertSQL.append(" SELECT a.Fcustomerid Fcustomerid,d.Fcompanyid Fcompanyid");
        insertSQL.append(",a.FLastsaleAmount FLastsaleAmount ,null FLastsaleDate ");
        insertSQL.append(" from " + tempSumTable + " a ");
        insertSQL.append(" inner join " + orgTable + " org on a.FCompanyORGUnitID=org.fid");
        insertSQL.append(" inner join ( ");
        insertSQL.append(" SELECT tempLsDate.Fcustomerid Fcustomerid,org.FParentID Fcompanyid");
        insertSQL.append(" ,0 FLastsaleAmount, max(tempLsDate.FLastsaleDate) FLastsaleDate");
        insertSQL.append(" FROM " + tempSumTable + " tempLsDate");
        insertSQL.append(" inner join " + orgTable + " org on tempLsDate.FCompanyORGUnitID=org.fid");
        insertSQL.append(" WHERE org.FLevel =" + i);
        insertSQL.append(" GROUP BY tempLsDate.FCustomerID,org.FParentID,tempLsDate.FLevel");
        insertSQL.append(" ) d on d.Fcustomerid =a.FCustomerID and d.Fcompanyid = org.FParentID");
        insertSQL.append(" and d.FLastsaleDate = a.FLastsaleDate ");
        insertSQL.append(" ) t group by t.Fcustomerid,t.Fcompanyid ");
        return insertSQL.toString();
    }

    private String getInstLastReceiveSql(String tempSumTable, String orgTable, RptParams params, int i) {
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("insert into " + params.getString("LastReceiveTable"));
        insertSQL.append(" select '88888888',t.Fcustomerid Fcustomerid,T.Fcompanyid ");
        insertSQL.append(" Fcompanyid,sum(t.FLastReceivedAmount) ");
        insertSQL.append(" FLastReceivedAmount,max(t.FLastReceivedDate) FLastReceivedDate ");
        insertSQL.append(" from ( ");
        insertSQL.append(" SELECT tempLsDate.Fcustomerid Fcustomerid,org.fparentid Fcompanyid");
        insertSQL.append(",0 FLastReceivedAmount, max(tempLsDate.FLastReceivedDate) FLastReceivedDate");
        insertSQL.append(" FROM " + tempSumTable + " tempLsDate ");
        insertSQL.append(" inner join " + orgTable + " org on tempLsDate.FCompanyORGUnitID=org.fid ");
        insertSQL.append(" WHERE  org.FLevel = " + i);
        insertSQL.append(" GROUP BY tempLsDate.FCustomerID,org.FParentID,tempLsDate.FLevel");
        insertSQL.append(" union all ");
        insertSQL.append(" SELECT a.Fcustomerid Fcustomerid,d.Fcompanyid Fcompanyid");
        insertSQL.append(",a.FLastReceivedAmount FLastReceivedAmount ,null FLastReceivedDate ");
        insertSQL.append(" from " + tempSumTable + " a ");
        insertSQL.append(" inner join " + orgTable + " org on a.FCompanyORGUnitID=org.fid");
        insertSQL.append(" inner join ( ");
        insertSQL.append(" SELECT tempLsDate.Fcustomerid Fcustomerid,org.FParentID Fcompanyid");
        insertSQL.append(" ,max(tempLsDate.FLastReceivedDate) FLastReceivedDate");
        insertSQL.append(" FROM " + tempSumTable + " tempLsDate");
        insertSQL.append(" inner join " + orgTable + " org on tempLsDate.FCompanyORGUnitID=org.fid");
        insertSQL.append(" WHERE org.FLevel =" + i);
        insertSQL.append(" GROUP BY tempLsDate.FCustomerID,org.FParentID ");
        insertSQL.append(" ) d on d.Fcustomerid =a.FCustomerID and d.Fcompanyid = org.FParentID");
        insertSQL.append(" and d.FLastReceivedDate = a.FLastReceivedDate ");
        insertSQL.append(" ) t group by t.Fcustomerid,t.Fcompanyid ");
        return insertSQL.toString();
    }

    private String getInsertByIsLeafSql(String tempSumTable, String orgTable, RptParams params) {
        StringBuffer insertByIsLeafSql = new StringBuffer();
        insertByIsLeafSql.append("insert into " + tempSumTable);
        insertByIsLeafSql.append("  select '88888888',a.FCustomerID,a.FCompanyORGUnitID ");
        insertByIsLeafSql.append(",'NOTDISPLAY',org.FLevel");
        insertByIsLeafSql.append(",sum(a.FAccountReceiveAmount),sum(a.FLastSaleAmount)");
        insertByIsLeafSql.append(",max(a.FLastSaleDate),sum(a.FLastReceivedAmount),max(a.FLastReceivedDate) ");
        insertByIsLeafSql.append(",sum(a.FSaleAmount),sum(a.FReturnRequestAmount)");
        insertByIsLeafSql.append(",sum(a.FSaleIssueAmount),sum(a.FInvoiceAmount)");
        insertByIsLeafSql.append(",sum(a.FReceivedAmount),sum(a.FReturnOrderAmount)");
        insertByIsLeafSql.append(",sum(a.FReceivedCount)");
        insertByIsLeafSql.append(",sum(a.FAllSaleAmount),sum(a.FAllReturnRequestAmount)");
        insertByIsLeafSql.append(",sum(a.FAllSaleIssueAmount),sum(a.FAllInvoiceAmount)");
        insertByIsLeafSql.append(",sum(a.FAllReceivedAmount),sum(a.FAllReturnOrderAmount)");
        insertByIsLeafSql.append(",sum(a.FAllReceivedCount),max(a.FMaxTime) ");
        insertByIsLeafSql.append(" from  " + tempSumTable + " a ");
        insertByIsLeafSql.append(" inner join  " + orgTable);
        insertByIsLeafSql.append(" org  on a.FCompanyORGUnitID = org.fid and org.fIsleaf= 1 ");
        insertByIsLeafSql.append(" group by a.FCustomerID,a.FCompanyORGUnitID,org.FLevel ");
        return insertByIsLeafSql.toString();
    }

    private RptTableHeader setWMRptHead(RptTableHeader header, RptParams params, Context ctx) {
        String customerName = this.getServerResource("CustomerName", ctx);
        String customerNumber = this.getServerResource("CUSTOMERNUMBER", ctx);
        String companyName = this.getServerResource("CompanyName", ctx);
        String accountReceiveAmount = this.getServerResource("AccountReceiveAmount", ctx);
        String lastSaleAmount = this.getServerResource("LastSaleAmount", ctx);
        String lastSaleDate = this.getServerResource("LastSaleDate", ctx);
        String lastReceivedAmount = this.getServerResource("LastReceivedAmount", ctx);
        String lastReceivedDate = this.getServerResource("LastReceivedDate", ctx);
        String saleAmount = this.getServerResource("SaleAmount", ctx);
        String saleIssueAmount = this.getServerResource("SaleIssueAmount", ctx);
        String otherBillAmount = this.getServerResource("OtherBillAmount", ctx);
        String receivedAmount = this.getServerResource("ReceivedAmount", ctx);
        String receivedCount = this.getServerResource("ReceivedCount", ctx);
        int i = 17;
        Object[][] labels = new Object[2][i + 6];
        String[] cols = new String[i + 6];
        cols[0] = "CUSTOMER_NAME";
        cols[1] = "CUSTOMER_NUMBER";
        cols[2] = "COMPANY_NAME";
        cols[3] = "ACCOUNTRECEIVEAMOUNT";
        cols[4] = "LastSaleAmount";
        cols[5] = "FLastSaleDate";
        cols[6] = "FLastReceivedAmount";
        cols[7] = "FLastReceivedDate";
        cols[8] = "SaleAmount";
        cols[9] = "SaleIssueAmount";
        cols[10] = "InvoiceAmount";
        cols[11] = "ReceivedAmount";
        cols[12] = "ReceivedCount";
        cols[13] = "SaleTOTALAmount";
        cols[14] = "SaleIssueTOTALAmount";
        cols[15] = "InvoiceATOTALmount";
        cols[16] = "ReceivedTOTALAmount";
        cols[17] = "ReceivedTOTALCount";
        cols[i + 1] = "COMPANYORG_ISLEAF";
        cols[i + 2] = "COMPANYORG_LEVEL";
        cols[i + 3] = "COMPANYORG_PARENTID";
        cols[i + 4] = "COMPANYORG_FID";
        cols[i + 5] = "CUSTOMER_FID";
        this.setHeaderColumns(header, cols, params);
        labels[0][0] = customerName;
        labels[1][0] = customerName;
        labels[0][1] = customerNumber;
        labels[1][1] = customerNumber;
        labels[0][2] = companyName;
        labels[1][2] = companyName;
        labels[0][3] = accountReceiveAmount;
        labels[1][3] = accountReceiveAmount;
        labels[0][4] = lastSaleAmount;
        labels[1][4] = lastSaleAmount;
        labels[0][5] = lastSaleDate;
        labels[1][5] = lastSaleDate;
        labels[0][6] = lastReceivedAmount;
        labels[1][6] = lastReceivedAmount;
        labels[0][7] = lastReceivedDate;
        labels[1][7] = lastReceivedDate;
        labels[0][8] = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"21_CustomerTradeFacadeControllerBean", (Locale)ctx.getLocale());
        labels[1][8] = saleAmount;
        labels[0][9] = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"21_CustomerTradeFacadeControllerBean", (Locale)ctx.getLocale());
        labels[1][9] = saleIssueAmount;
        labels[0][10] = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"21_CustomerTradeFacadeControllerBean", (Locale)ctx.getLocale());
        labels[1][10] = otherBillAmount;
        labels[0][11] = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"21_CustomerTradeFacadeControllerBean", (Locale)ctx.getLocale());
        labels[1][11] = receivedAmount;
        labels[0][12] = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"21_CustomerTradeFacadeControllerBean", (Locale)ctx.getLocale());
        labels[1][12] = receivedCount;
        labels[0][13] = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"22_CustomerTradeFacadeControllerBean", (Locale)ctx.getLocale());
        labels[1][13] = saleAmount;
        labels[0][14] = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"22_CustomerTradeFacadeControllerBean", (Locale)ctx.getLocale());
        labels[1][14] = saleIssueAmount;
        labels[0][15] = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"22_CustomerTradeFacadeControllerBean", (Locale)ctx.getLocale());
        labels[1][15] = otherBillAmount;
        labels[0][16] = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"22_CustomerTradeFacadeControllerBean", (Locale)ctx.getLocale());
        labels[1][16] = receivedAmount;
        labels[0][17] = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"22_CustomerTradeFacadeControllerBean", (Locale)ctx.getLocale());
        labels[1][17] = receivedCount;
        labels[0][i + 1] = "COMPANYORG_ISLEAF";
        labels[1][i + 1] = "COMPANYORG_ISLEAF";
        labels[0][i + 2] = "COMPANYORG_LEVEL";
        labels[1][i + 2] = "COMPANYORG_LEVEL";
        labels[0][i + 3] = "COMPANYORG_PARENTID";
        labels[1][i + 3] = "COMPANYORG_PARENTID";
        labels[0][i + 4] = "COMPANYORG_FID";
        labels[1][i + 4] = "COMPANYORG_FID";
        labels[0][i + 5] = "CUSTOMER_FID";
        labels[1][i + 5] = "CUSTOMER_FID";
        header.setLabels(labels, true);
        return header;
    }

    private void setHeaderColumns(RptTableHeader header, String[] columns, RptParams params) {
        String prcFormat = SaleUtil.getFormatPattern(this.precision, true);
        String dateFormat = RptCellFormatter.getDateFormat((String)"yyyy-MM-dd");
        String intFormat = SaleUtil.getFormatPattern(0, true);
        RptTableColumn col = null;
        int k = "true".equals(params.getString("IsTotalWithAll")) ? 18 : 13;
        int c = columns.length;
        for (int i = 0; i < c; ++i) {
            col = new RptTableColumn(columns[i]);
            if (i < 3) {
                col.setWidth(-1);
            } else {
                if (i == 5 | i == 7) {
                    col.setFormatPattern(dateFormat);
                } else if (i == 12 || i == 17) {
                    col.setWidth(120);
                    col.setAligment(2);
                    col.setFormatPattern(intFormat);
                } else {
                    col.setWidth(120);
                    col.setAligment(2);
                    col.setFormatPattern(prcFormat);
                }
                if (i >= k) {
                    col.setWidth(-1);
                    col.setHided(true);
                }
            }
            header.addColumn(col);
        }
    }

    protected void _dropTempTable(Context ctx, String tableName) throws BOSException, EASBizException {
        super._dropTempTable(ctx, tableName);
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)resClassName, (String)key, (Context)ctx);
    }

    public RptParams getDataForIdList(Context ctx, List idList, RptParams params) throws BOSException, EASBizException {
        return this.getDatas(ctx, params, idList, false);
    }

    protected IRowSet _getIdList(Context ctx, RptParams param) throws BOSException {
        String tempSumTable = param.getString("TempResultTable");
        String companyTempTable = param.getString("CompanyTempTable");
        String rsList = "select  a.fid fid from " + tempSumTable + " a INNER JOIN " + companyTempTable + " o ON a.FCompanyORGUnitID = o.FID  INNER JOIN T_BD_Customer AS customer ON a.FCustomerID = Customer.FID   where o.FLevel = 1 order by customer.FName_" + ctx.getLocale().getLanguage() + ",o.FName_" + ctx.getLocale().getLanguage();
        return DbUtil.executeQuery((Context)ctx, (String)rsList);
    }

    private RptParams getDatas(Context ctx, RptParams params, List idList, boolean first) throws BOSException {
        String subWhere;
        if (first) {
            subWhere = " o.flevel = 1 ";
        } else {
            StringBuffer fid = new StringBuffer("a.FId IN (  '").append(idList.get(0).toString()).append("'");
            int n = idList.size();
            for (int i = 1; i < n; ++i) {
                fid.append(", '").append(idList.get(i).toString()).append("'");
            }
            fid.append(" ) ");
            subWhere = fid.toString();
        }
        String sqlStr = this.querySql(params, ctx) + "\t where " + subWhere + " order by customer.FName_" + ctx.getLocale().getLanguage() + ",o.FName_" + ctx.getLocale().getLanguage();
        RptRowSet rs = this.executeQuery(sqlStr, null, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        RptTableHeader header = new RptTableHeader();
        header = this.setWMRptHead(header, params, ctx);
        CurrencyInfo cc = this.getCurrencyInfo(ctx, params);
        if (cc != null) {
            this.precision = cc.getPrecision();
        }
        String sqlStr = this.querySql(params, ctx) + "\t where o.FLEVEL = 1    order by  customer.FName_" + ctx.getLocale().getLanguage() + ",o.FName_" + ctx.getLocale().getLanguage();
        RptRowSet rs = this.executeQuery(sqlStr, null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("Currency", (Object)cc);
        pp.setObject("rowset", (Object)rs);
        pp.setObject("header", (Object)header);
        IRowSet Irs = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
        pp.setObject("IRowSet", (Object)Irs);
        return pp;
    }

    protected RptParams _findData(Context ctx, RptParams param, int start, int count, String tempTableName, Object treeTypeObject) throws BOSException, EASBizException {
        RptRowSet rs;
        String sql = "";
        if (start <= -1 && count <= -1) {
            sql = this.querySql(param, ctx) + " where  a.FCustomerID ='" + param.getString("CUSTOMER_FID") + "' and o.FParentID='" + param.getString("fparentid") + "' order by  customer.FName_" + ctx.getLocale().getLanguage() + ",o.FName_" + ctx.getLocale().getLanguage();
            rs = this.executeQuery(sql, null, ctx);
        } else {
            sql = this.querySql(param, ctx) + " where  a.FCustomerID ='" + param.getString("CUSTOMER_FID") + "' and o.FParentID='" + param.getString("fparentid") + "' order by  customer.FName_" + ctx.getLocale().getLanguage() + ",o.FName_" + ctx.getLocale().getLanguage();
            rs = this.executeQuery(sql, null, ctx);
        }
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private CurrencyInfo getCurrencyInfo(Context ctx, RptParams params) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currCom = null;
        Object obj = null;
        Object[] infos = (Object[])params.getObject("fullCompanyOrgUnit");
        int n = infos.length;
        for (int i = 0; i < n; ++i) {
            Boolean isleaf = (Boolean)((FullOrgUnitInfo)infos[i]).get("isleaf");
            boolean fisleaf = isleaf != false;
            if (!fisleaf) continue;
            obj = infos[i];
        }
        try {
            if (obj == null) {
                return null;
            }
            ICompanyOrgUnit ie = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            currCom = ie.getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK(((FullOrgUnitInfo)obj).getId().toString()));
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        CurrencyInfo c = currCom.getBaseCurrency();
        if (currCom.getBaseCurrency() != null && currCom.getBaseCurrency().getId() != null && (currCom.getBaseCurrency().getName() == null || currCom.getBaseCurrency().getPrecision() <= 0)) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("id"));
            selectors.add(new SelectorItemInfo("name"));
            selectors.add(new SelectorItemInfo("precision"));
            ICurrency ie = null;
            ie = ctx == null ? CurrencyFactory.getRemoteInstance() : CurrencyFactory.getLocalInstance((Context)ctx);
            c = ie.getCurrencyInfo((IObjectPK)new ObjectStringPK(currCom.getBaseCurrency().getId().toString()), selectors);
        }
        return c;
    }

    private String querySql(RptParams params, Context ctx) {
        StringBuffer sql = new StringBuffer();
        String tempSumTable = params.getString("TempResultTable");
        String companyTempTable = params.getString("CompanyTempTable");
        sql.append(" SELECT customer.FName_").append(ctx.getLocale().getLanguage());
        sql.append(" AS CUSTOMER_NAME, customer.fnumber AS CUSTOMER_NUMBER,o.FName_").append(ctx.getLocale().getLanguage());
        sql.append(" AS COMPANY_NAME");
        sql.append(",a.FAccountReceiveAmount as  ACCOUNTRECEIVEAMOUNT");
        sql.append(",a.FLastSaleAmount as LASTSALEAMOUNT");
        sql.append(",a.FLastSaleDate as LASTSALEDATE");
        sql.append(",a.FLastReceivedAmount AS LASTRECEIVEDAMOUNT");
        sql.append(",a.FLastReceivedDate AS LASTRECEIVEDDATE");
        sql.append(",( a.FSaleAmount - a.FReturnRequestAmount ) AS SALEAMOUNT");
        sql.append(",a.FSaleIssueAmount AS SALEISSUEAMOUNT");
        sql.append(",a.FInvoiceAmount as INVOICEAMOUNT");
        sql.append(",(a.FReceivedAmount + a.FReturnOrderAmount) AS RECEIVEDAMOUNT");
        sql.append(",a.FReceivedCount AS RECEIVEDCOUNT");
        sql.append(",( a.FAllSaleAmount - a.FAllReturnRequestAmount ) AS AllSALEAMOUNT");
        sql.append(",a.FAllSaleIssueAmount AS AllSALEISSUEAMOUNT");
        sql.append(",a.FAllInvoiceAmount as AllINVOICEAMOUNT");
        sql.append(",(a.FAllReceivedAmount + a.FAllReturnOrderAmount) AS AllRECEIVEDAMOUNT");
        sql.append(",a.FAllReceivedCount AS AllRECEIVEDCOUNT");
        sql.append(",o.FIsleaf AS COMPANYORG_ISLEAF");
        sql.append(",o.FLEVEL AS COMPANYORG_LEVEL");
        sql.append(",o.Fparentid as COMPANYORG_FPARENTID");
        sql.append(",o.Fid AS COMPANYORG_FID");
        sql.append(",customer.Fid as CUSTOMER_FID");
        sql.append(" from  " + tempSumTable + " AS a INNER JOIN ");
        sql.append(companyTempTable).append(" AS o ON a.FCompanyORGUnitID = o.FID ");
        sql.append(" INNER JOIN T_BD_Customer AS customer ON a.FCustomerID = Customer.FID ");
        return sql.toString();
    }

    @Override
    protected int _check_Currency_unique(Context ctx, RptParams params) throws BOSException, EASBizException {
        return 0;
    }

    protected String getOrgListId(Object[] infos) {
        StringBuffer OrgunitId = new StringBuffer();
        int n = infos.length;
        for (int i = 0; i < n; ++i) {
            Boolean isleaf = (Boolean)((FullOrgUnitInfo)infos[i]).get("isleaf");
            boolean fisleaf = isleaf != false;
            if (!fisleaf) continue;
            OrgunitId.append(",'" + ((FullOrgUnitInfo)infos[i]).getId().toString() + "'");
        }
        if (OrgunitId.length() <= 0) {
            return "'QZF6mRrNQnioTkE6MQPQkcznrtQ='";
        }
        String orgunitListId = OrgunitId.toString().substring(1, OrgunitId.toString().length());
        return orgunitListId;
    }

    private void setCustomerFromQuery(RptParams params, StringBuffer queryStr) {
        Object customerObject = params.getObject("CustomerFrom");
        if (customerObject == null) {
            return;
        }
        if (customerObject instanceof String) {
            queryStr.append(" and Customer.FNumber >= '").append(customerObject.toString()).append("' ");
        } else if (customerObject instanceof List && ((List)customerObject).size() > 0) {
            List customerList = (List)customerObject;
            StringBuffer customerQuery = new StringBuffer();
            customerQuery.append(" and Customer.FNumber in (");
            for (String number : customerList) {
                customerQuery.append("'").append(number).append("',");
            }
            queryStr.append(customerQuery.substring(0, customerQuery.length() - 1)).append(") ");
        } else if (customerObject instanceof Object[]) {
            Object[] customers = (Object[])customerObject;
            if (customers.length == 1) {
                queryStr.append(" and Customer.FNumber >= '").append(((CustomerInfo)customers[0]).getNumber()).append("' ");
            } else {
                StringBuffer customerQuery = new StringBuffer();
                customerQuery.append(" and Customer.FNumber in (");
                for (Object customer : customers) {
                    customerQuery.append("'").append(((CustomerInfo)customer).getNumber()).append("',");
                }
                queryStr.append(customerQuery.substring(0, customerQuery.length() - 1)).append(") ");
            }
        } else if (customerObject instanceof CustomerInfo) {
            queryStr.append(" and Customer.FNumber >= '").append(((CustomerInfo)customerObject).getNumber()).append("' ");
        }
    }
}

