/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.sd.sale.SaleReportBillStatusEnum;
import com.kingdee.eas.scm.sd.sale.SaleReportBizTypeEnum;
import com.kingdee.eas.scm.sd.sale.SaleReportClassificationEnum;
import com.kingdee.eas.scm.sd.sale.report.SaleImcomEnum;
import com.kingdee.eas.scm.sd.sale.report.app.AbstractSaleGrossProfitsControllerBean;
import com.kingdee.eas.scm.util.PermissionUtil;
import com.kingdee.eas.scm.util.constant.RecIssueTypeConstant;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SaleGrossProfitsControllerBean
extends AbstractSaleGrossProfitsControllerBean {
    private static final long serialVersionUID = 6884251906121719078L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.report.app.SaleGrossProfitsControllerBean");
    private static final String ResClassName = "com.kingdee.eas.scm.sd.sale.report.SDReportResource";
    private String sp = "\r\n";
    private String locString = "L2";
    private String SubLabel = "";
    private String tempTable;
    RptParams params = new RptParams();
    private String tempColsForSelect = null;
    private String tempColsForGroup = null;
    private String groupCols = null;
    private int minLevel = 1;
    private int defaultPre = 2;
    SaleReportBizTypeEnum bizType;
    SaleReportClassificationEnum classficationType;
    SaleReportBillStatusEnum billStatus;
    private boolean isAssistSum = false;
    boolean isFromOUTSTORE = false;
    private String saleOrgIDs = null;
    private String companyOrgIDs = null;
    private boolean isBySaleOrg = true;

    protected RptParams _query(Context ctx, RptParams params, int FROM, int len) throws BOSException, EASBizException {
        if (params.getBoolean("AuxiliaryProperties")) {
            this.isAssistSum = true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"28_SaleGrossProfitsControllerBean", (Locale)ctx.getLocale()) + params.getString("tempTable")));
        }
        String tempTable = params.getString("tempTable");
        SaleReportClassificationEnum classficationType = SaleReportClassificationEnum.getEnum(new Integer(params.getString("classification")));
        int level = params.getInt("levelCount");
        StringBuffer selectTotalColBuff = new StringBuffer();
        for (int i = 1; i <= level; ++i) {
            if ((classficationType.equals((Object)SaleReportClassificationEnum.materialGroup) || classficationType.equals((Object)SaleReportClassificationEnum.customerGroup)) && params.getString("action") != null) {
                selectTotalColBuff.append("FNumber_").append(String.valueOf(i)).append("Name").append(" FGroup").append(String.valueOf(i)).append(",");
                continue;
            }
            selectTotalColBuff.append("FNumber_").append(String.valueOf(i)).append("Name,");
        }
        StringBuffer orderByTotalColBuff = new StringBuffer();
        for (int i = 1; i <= level; ++i) {
            orderByTotalColBuff.append("isnull(FNumber_").append(String.valueOf(i)).append(",'!') desc, ").append("isnull(FNumber_").append(String.valueOf(i)).append("Name,'!') desc,");
        }
        if (orderByTotalColBuff.length() > 0) {
            orderByTotalColBuff.setLength(orderByTotalColBuff.length() - 1);
        }
        StringBuffer selectCol = new StringBuffer(300).append("fid id,");
        StringBuffer orderByCol = new StringBuffer();
        if (classficationType.equals((Object)SaleReportClassificationEnum.material)) {
            if (this.isAssistSum) {
                selectCol.append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,");
            } else {
                selectCol.append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,");
            }
            orderByCol.append("fmaterialNum desc ");
            if (this.isAssistSum) {
                orderByCol.append(", FassistPropertyName desc ");
            }
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.customer)) {
            selectCol.append("fcustomerNumber,fcustomerName,").append(this.defaultPre).append(" FQtyPrecision,");
            orderByCol.append("fcustomerNumber desc ");
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.materialGroup) || classficationType.equals((Object)SaleReportClassificationEnum.customerGroup)) {
            selectCol.append(selectTotalColBuff).append(this.defaultPre).append(" FQtyPrecision,");
            orderByCol.append(orderByTotalColBuff);
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustGroup)) {
            if (this.isAssistSum) {
                selectCol.append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,").append(selectTotalColBuff);
            } else {
                selectCol.append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,").append(selectTotalColBuff);
            }
            orderByCol.append("fmaterialNum desc ,baseUnitName,").append(orderByTotalColBuff);
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustomer)) {
            if (this.isAssistSum) {
                selectCol.append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,");
                selectCol.append("fcustomerNumber,fcustomerName,");
            } else {
                selectCol.append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,");
                selectCol.append("fcustomerNumber,fcustomerName,");
            }
            orderByCol.append("fmaterialNum desc ,baseUnitName,fcustomerNumber desc");
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.customerPlusmaterial)) {
            if (this.isAssistSum) {
                selectCol.append("fcustomerNumber,fcustomerName,");
                selectCol.append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,");
            } else {
                selectCol.append("fcustomerNumber,fcustomerName,").append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,");
            }
            orderByCol.append("fcustomerNumber desc ,fmaterialNum desc,baseUnitName");
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroup)) {
            selectCol.append("fcustomerNumber,fcustomerName,").append(this.defaultPre).append(" FQtyPrecision,").append(selectTotalColBuff);
            orderByCol.append("fcustomerNumber,").append(orderByTotalColBuff);
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.custGroupPlusMaterial)) {
            if (this.isAssistSum) {
                selectCol.append(selectTotalColBuff).append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,");
            } else {
                selectCol.append(selectTotalColBuff).append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,");
            }
            orderByCol.append(orderByTotalColBuff).append(",fmaterialNum desc,baseUnitName");
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.materGroupPlusCustomer)) {
            selectCol.append(selectTotalColBuff).append("fcustomerNumber,fcustomerName,").append(this.defaultPre).append(" FQtyPrecision,");
            orderByCol.append(orderByTotalColBuff).append(",fcustomerNumber desc");
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.departmentplusmaterial)) {
            if (this.isAssistSum) {
                selectCol.append("fadminunitName,fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,");
            } else {
                selectCol.append("fadminunitName,fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,");
            }
            orderByCol.append("fadminunitName,fmaterialNum desc,baseUnitName");
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroupPerson)) {
            selectCol.append("fsalePersonNum,fSalePersonName,fcustomerNumber,fcustomerName,");
            selectCol.append(selectTotalColBuff).append(this.defaultPre).append(" FQtyPrecision,");
            orderByCol.append(" fsalePersonNum,fSalePersonName,fcustomerNumber desc ,fcustomerName, ");
            orderByCol.append(orderByTotalColBuff);
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterPerson)) {
            if (this.isAssistSum) {
                selectCol.append("fsalePersonNum,fSalePersonName,fcustomerNumber,fcustomerName,");
                selectCol.append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,");
            } else {
                selectCol.append("fsalePersonNum,fSalePersonName,fcustomerNumber,fcustomerName,");
                selectCol.append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,");
            }
            orderByCol.append(" fsalePersonNum,fSalePersonName,fcustomerNumber desc ,fcustomerName ");
            orderByCol.append(",fmaterialNum desc ,baseUnitName");
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.saleOrgPlusCustomerPlusMaterial)) {
            if (this.isAssistSum) {
                selectCol.append("fSaleOrgNum,fSaleOrgName,fcustomerNumber,fcustomerName,");
                selectCol.append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,");
            } else {
                selectCol.append("fSaleOrgNum,fSaleOrgName,fcustomerNumber,fcustomerName,");
                selectCol.append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,");
            }
            orderByCol.append(" fSaleOrgNum,fSaleOrgName,fcustomerNumber desc ,fcustomerName ");
            orderByCol.append(",fmaterialNum desc ,baseUnitName");
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.saleorder)) {
            selectCol.append("fsoNumber,").append(this.defaultPre).append(" FQtyPrecision,");
            orderByCol.append("fsoNumber desc ");
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.salecontract)) {
            selectCol.append("fscNumber,").append(this.defaultPre).append(" FQtyPrecision,");
            orderByCol.append("fscNumber desc");
        }
        int qtyPrecision1 = Integer.valueOf(params.getObject("spnPrecision").toString());
        int amountPrecision1 = Integer.valueOf(params.getObject("amountPrecision1").toString());
        int qtyPrecision2 = Integer.valueOf(params.getObject("qtyPrecision").toString());
        int amountPrecision2 = Integer.valueOf(params.getObject("amountPrecision2").toString());
        StringBuffer sqlBuff = new StringBuffer();
        if (classficationType.equals((Object)SaleReportClassificationEnum.material) || classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustGroup) || classficationType.equals((Object)SaleReportClassificationEnum.custGroupPlusMaterial) || classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustomer) || classficationType.equals((Object)SaleReportClassificationEnum.customerPlusmaterial) || classficationType.equals((Object)SaleReportClassificationEnum.departmentplusmaterial) || classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterPerson) || classficationType.equals((Object)SaleReportClassificationEnum.saleOrgPlusCustomerPlusMaterial)) {
            sqlBuff.append("SELECT ").append(selectCol);
            sqlBuff.append("round(saleQty," + qtyPrecision2 + ") saleQty,");
            sqlBuff.append("round(outQty," + qtyPrecision2 + ") outQty, ");
            sqlBuff.append("statUnitName, ");
            sqlBuff.append("round(statSaleQty," + qtyPrecision2 + ") statSaleQty, ");
            sqlBuff.append("round(statOutQty," + qtyPrecision2 + ") statOutQty,");
            sqlBuff.append("round(saleAmount," + amountPrecision2 + ") saleAmount,");
            sqlBuff.append("round(saleCost," + amountPrecision2 + ") saleCost,");
            sqlBuff.append("round(totalSaleFee," + amountPrecision2 + ") totalSaleFee,");
            sqlBuff.append("round(profit," + amountPrecision2 + ") profit,");
            sqlBuff.append("round(profitRate,2) profitRate,");
            sqlBuff.append("round(unitProfit," + amountPrecision2 + ") unitProfit,");
            sqlBuff.append("round(statProfit," + amountPrecision2 + ") statProfit");
            sqlBuff.append(" FROM ").append(tempTable).append(" ORDER BY ").append(orderByCol);
        } else {
            if (classficationType.equals((Object)SaleReportClassificationEnum.saleorder) || classficationType.equals((Object)SaleReportClassificationEnum.salecontract)) {
                selectCol.append("custormer,adminOrgUnit,saleGroup,salePerson,");
            }
            sqlBuff.append("SELECT ").append(selectCol);
            sqlBuff.append("round(saleQty," + qtyPrecision1 + ") saleQty,");
            sqlBuff.append("round(outQty," + qtyPrecision1 + ") outQty,");
            sqlBuff.append("round(saleAmount," + amountPrecision1 + ") saleAmount,");
            sqlBuff.append("round(saleCost," + amountPrecision1 + ") saleCost,");
            sqlBuff.append("round(totalSaleFee," + amountPrecision2 + ") totalSaleFee,");
            sqlBuff.append("round(profit," + amountPrecision1 + ") profit,");
            sqlBuff.append("round(profitRate,2) profitRate FROM ").append(tempTable).append(" ORDER BY ").append(orderByCol);
        }
        RptRowSet rs = this.executeQuery(sqlBuff.toString(), null, FROM, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        IRowSet Irs = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
        pp.setObject("IRowSet", (Object)Irs);
        return pp;
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        Set havePermOrgUnitSet;
        Set cuUnitSets;
        this.locString = this.getLoc(ctx);
        this.params = params;
        this.SubLabel = SCMUtils.getResource((String)ResClassName, (String)"SUB_STRING", (Context)ctx);
        this.dropTable(params.getString("tempTable"), ctx);
        this.tempTable = this.getTempTableName(this.getServerResource("RPTTempTable", ctx), ctx);
        this.bizType = SaleReportBizTypeEnum.all;
        if (params.containsKey("billType")) {
            this.bizType = SaleReportBizTypeEnum.getEnum(new Integer(params.getString("billType")));
        }
        this.billStatus = SaleReportBillStatusEnum.all;
        if (params.containsKey("billStatus")) {
            this.billStatus = SaleReportBillStatusEnum.getEnum(new Integer(params.getString("billStatus")));
        }
        this.classficationType = SaleReportClassificationEnum.material;
        if (params.containsKey("classification")) {
            this.classficationType = SaleReportClassificationEnum.getEnum(new Integer(params.getString("classification")));
        }
        if (params.containsKey("byOrgType")) {
            this.isBySaleOrg = params.getBoolean("byOrgType");
        }
        if (this.isBySaleOrg) {
            Object[] saleOrgs = (Object[])params.getObject("fullSaleOrgUnit");
            if (saleOrgs != null && saleOrgs.length > 0) {
                cuUnitSets = PermissionUtil.getAuthorizedf7Orgs((Context)ctx, (IObjectPK)ctx.getCaller(), (String)"SaleGrossProfits_view");
                havePermOrgUnitSet = InvServerUtils.getSelAuthorUnit((Set)cuUnitSets, (Object[])saleOrgs);
                saleOrgs = havePermOrgUnitSet.toArray();
            }
            this.saleOrgIDs = this.getOrgIds(saleOrgs);
        } else {
            Object[] companyOrgs = (Object[])params.getObject("fullCompanyOrgUnit");
            if (companyOrgs != null && companyOrgs.length > 0) {
                cuUnitSets = PermissionUtil.getAuthorizedf7Orgs((Context)ctx, (IObjectPK)ctx.getCaller(), (String)"SaleGrossProfits_view");
                havePermOrgUnitSet = InvServerUtils.getSelAuthorUnit((Set)cuUnitSets, (Object[])companyOrgs);
                companyOrgs = havePermOrgUnitSet.toArray();
            }
            this.companyOrgIDs = this.getOrgIds(companyOrgs);
        }
        if (params.getBoolean("AuxiliaryProperties")) {
            this.isAssistSum = true;
        }
        this.processData(ctx, params);
        int rowCount = this.totalRowCount(ctx);
        boolean saleQtyFlag = this.getUserPremission(ctx, "saleQty");
        boolean outQtyFalg = this.getUserPremission(ctx, "outQty");
        boolean saleIncomeFlag = this.getUserPremission(ctx, "saleIncome");
        boolean saleCostFlag = this.getUserPremission(ctx, "saleCost");
        boolean SaleProfitFlag = this.getUserPremission(ctx, "saleProfit");
        boolean saleProfitRateFalg = this.getUserPremission(ctx, "saleProfitRate");
        RptParams result = new RptParams();
        RptRowSet totalRs = null;
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustomer)) {
            totalRs = this.totalGroupData(ctx, "fcustomerNumber");
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusmaterial) || this.classficationType.equals((Object)SaleReportClassificationEnum.departmentplusmaterial) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterPerson)) {
            totalRs = this.totalGroupData(ctx, "fmaterialNum");
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroupPerson)) {
            totalRs = this.totalGroupData(ctx, "FNumber_1Name");
        }
        if (totalRs != null) {
            result.setObject("totalRs", (Object)totalRs);
        }
        result.setString("tempTable", this.tempTable);
        result.setInt("levelCount", this.minLevel);
        result.setInt("rowCount", rowCount);
        result.setBoolean("SaleQty", saleQtyFlag);
        result.setBoolean("OutQty", outQtyFalg);
        result.setBoolean("SaleIncome", saleIncomeFlag);
        result.setBoolean("SaleCost", saleCostFlag);
        result.setBoolean("SaleProfit", SaleProfitFlag);
        result.setBoolean("SaleProfitRate", saleProfitRateFalg);
        return result;
    }

    public boolean getUserPremission(Context ctx, String permission) throws EASBizException, BOSException {
        boolean Flag = false;
        UserInfo curUseInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        FullOrgUnitCollection orgUnitCollection = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrg((IObjectPK)new ObjectUuidPK(curUseInfo.getId()), OrgType.Sale, null, permission);
        OrgUnitInfo info = ContextUtil.getCurrentOrgUnit((Context)ctx);
        for (int k = 0; k < orgUnitCollection.size(); ++k) {
            if (!info.getId().toString().equals(orgUnitCollection.get(k).getId().toString())) continue;
            Flag = true;
            return Flag;
        }
        return Flag;
    }

    private int totalRowCount(Context ctx) throws BOSException, EASBizException {
        String countSql = "SELECT count(1) cc FROM " + this.tempTable;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = 0;
        if (rs.getObject(0) != null) {
            count = rs.getInt(0);
        }
        return count;
    }

    private int getLevel() {
        int reqLevel = 1;
        if (this.params.getObject("grade") instanceof String) {
            reqLevel = Integer.parseInt(this.params.getString("grade"));
        } else if (this.params.getObject("grade") instanceof Integer) {
            reqLevel = this.params.getInt("grade");
        }
        return reqLevel;
    }

    public void processData(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.createTempData(ctx, params);
        this.updateTempForStatColumn(ctx);
        this.twoTotalData(ctx, params);
        this.updateTempForProfit(ctx);
    }

    private void updateTempForProfit(Context ctx) throws BOSException, EASBizException {
        StringBuffer updateSql = new StringBuffer();
        updateSql.setLength(0);
        updateSql.append(" update ").append(this.tempTable);
        updateSql.append(" set profit = saleAmount - saleCost - totalSaleFee,");
        updateSql.append(" profitRate= Case When saleAmount = 0 Then 0.00 ");
        updateSql.append(" Else case when (saleAmount - saleCost - totalSaleFee) < 0 and saleAmount < 0 then -1*to_decimal((saleAmount - saleCost - totalSaleFee)/saleAmount*100,31,8) ");
        updateSql.append(" else to_decimal((saleAmount - saleCost - totalSaleFee)/saleAmount*100,31,8) end END ");
        this.executeUpdate(updateSql.toString(), null, ctx);
    }

    private void updateTempForStatColumn(Context ctx) throws BOSException, EASBizException {
        StringBuffer updateSql = new StringBuffer();
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.material) || this.classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.custGroupPlusMaterial) || this.classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustomer) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusmaterial) || this.classficationType.equals((Object)SaleReportClassificationEnum.departmentplusmaterial) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroupPerson) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterPerson) || this.classficationType.equals((Object)SaleReportClassificationEnum.saleOrgPlusCustomerPlusMaterial)) {
            updateSql.append(" update ").append(this.tempTable).append(" set statUnitName = null");
            this.executeUpdate(updateSql.toString(), null, ctx);
            updateSql.setLength(0);
            updateSql.append(" update ").append(this.tempTable);
            updateSql.append(" set (statUnitName,FBaseConvsRate) = ");
            updateSql.append(" (select statUnit.fname_").append(this.locString).append(",statMmUnit.FBaseConvsRate ");
            updateSql.append("    from T_BD_MultiMeasureUnit statMmUnit ");
            updateSql.append("    left outer join T_BD_MeasureUnit statUnit on statMmUnit.fmeasureunitid = statUnit.fid ");
            updateSql.append("    where statMmUnit.FMaterialID = ").append(this.tempTable).append(".fmaterialid and statMmUnit.FIsStatUnit = 1)");
            this.executeUpdate(updateSql.toString(), null, ctx);
            updateSql.setLength(0);
            updateSql.append(" update ").append(this.tempTable);
            updateSql.append(" set profit = saleAmount - saleCost - totalSaleFee,");
            updateSql.append(" profitRate= Case When saleAmount = 0 Then 0.00 ");
            updateSql.append(" Else case when (saleAmount - saleCost - totalSaleFee) < 0 and saleAmount < 0 then -1*to_decimal((saleAmount - saleCost - totalSaleFee)/saleAmount*100,31,8) else ");
            updateSql.append("  to_decimal((saleAmount - saleCost - totalSaleFee)/saleAmount*100,31,8) END END, ");
            updateSql.append(" statSaleQty = case when FBaseConvsRate <> -1 and FBaseConvsRate is not null then to_decimal(saleQty/FBaseConvsRate,31,8) ");
            updateSql.append(" else saleQty end, ");
            updateSql.append(" statOutQty = case when FBaseConvsRate <> -1 and FBaseConvsRate is not null then to_decimal(outQty/FBaseConvsRate,31,8) ");
            updateSql.append(" else outQty end, ");
            updateSql.append(" unitProfit = case when saleQty = 0 then null else ");
            updateSql.append("   case when (saleAmount - saleCost - totalSaleFee) <0 and saleQty < 0 then -1*to_decimal((saleAmount - saleCost - totalSaleFee)/saleQty,31,8) else ");
            updateSql.append("  to_decimal((saleAmount - saleCost - totalSaleFee)/saleQty,31,8) end end, ");
            updateSql.append(" statProfit = case when FBaseConvsRate <> -1 and FBaseConvsRate is not null and saleQty <> 0 then ");
            updateSql.append("   case when (saleAmount - saleCost - totalSaleFee) <0 and to_decimal(saleQty/FBaseConvsRate,31,8) < 0 then -1*to_decimal((saleAmount - saleCost - totalSaleFee)/to_decimal(saleQty/FBaseConvsRate,31,8),31,8) ");
            updateSql.append("    else to_decimal((saleAmount - saleCost - totalSaleFee)/to_decimal(saleQty/FBaseConvsRate,31,8),31,8) end ");
            updateSql.append(" else case when saleQty = 0 then null else ");
            updateSql.append("   case when (saleAmount - saleCost - totalSaleFee) < 0 and saleQty < 0 then -1*to_decimal((saleAmount - saleCost - totalSaleFee)/saleQty,31,8) ");
            updateSql.append("   else to_decimal((saleAmount - saleCost - totalSaleFee)/saleQty,31,8) end end end ");
            updateSql.append(" where statUnitName is not null ");
            this.executeUpdate(updateSql.toString(), null, ctx);
        }
    }

    private void createTempData(Context ctx, RptParams params) throws BOSException, EASBizException {
        StringBuffer sumOut = new StringBuffer();
        StringBuffer createField = new StringBuffer();
        StringBuffer insertField = new StringBuffer();
        createField.append("create table temp(");
        createField.append("fid varchar(44),");
        sumOut.append("to_decimal(saleQty,31,8) saleQty,to_decimal(outQty,31,8) outQty,").append(this.sp);
        createField.append(" saleQty decimal(31,8), outQty decimal(31,8),").append(this.sp);
        insertField.append(" saleQty,outQty,");
        sumOut.append("to_decimal(0.0,31,8) statSaleQty,to_decimal(0.0,31,8) statOutQty,").append(this.sp);
        createField.append(" statSaleQty decimal(31,8), statOutQty decimal(31,8),").append(this.sp);
        insertField.append(" statSaleQty,statOutQty,");
        sumOut.append("to_decimal(saleAmount,31,8) saleAmount,to_decimal(saleCost,31,8) saleCost,").append(this.sp);
        createField.append(" saleAmount decimal(31,8), saleCost decimal(31,8),").append(this.sp);
        insertField.append(" saleAmount,saleCost,");
        sumOut.append("to_decimal(totalSaleFee,31,8) totalSaleFee,").append(this.sp);
        createField.append(" totalSaleFee decimal(31,8),").append(this.sp);
        insertField.append(" totalSaleFee,");
        sumOut.append("to_decimal(0.0,31,8) profit,to_decimal(0.0,31,8) profitRate, ").append(this.sp);
        createField.append(" profit decimal(31,8), profitRate decimal(31,8),").append(this.sp);
        insertField.append(" profit,profitRate,");
        sumOut.append("to_decimal(0.0,31,8) unitProfit,to_decimal(0.0,31,8) statProfit ").append(this.sp);
        createField.append(" unitProfit decimal(31,8), statProfit decimal(31,8)").append(this.sp);
        insertField.append(" unitProfit,statProfit");
        StringBuffer setNullSql = null;
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.materGroupPlusCustomer) || this.classficationType.equals((Object)SaleReportClassificationEnum.custGroupPlusMaterial) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroupPerson) || this.classficationType.equals((Object)SaleReportClassificationEnum.materialGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerGroup)) {
            int reqLevel = this.getLevel();
            setNullSql = new StringBuffer();
            for (int i = 1; i <= reqLevel; ++i) {
                sumOut.append(",FLongNumber FNumber_").append(i).append(",FLongNumber FNumber_").append(i).append("Name");
                createField.append(" ,FNumber_").append(i).append(" nvarchar(255)").append(this.sp);
                createField.append(" ,FNumber_").append(i).append("Name nvarchar(255)").append(this.sp);
                insertField.append(",FNumber_").append(i);
                insertField.append(",FNumber_").append(i).append("Name");
                setNullSql.append("FNumber_").append(i).append(" = NULL,");
                if (i < reqLevel) {
                    setNullSql.append("FNumber_").append(i).append("Name = NULL, ");
                    continue;
                }
                setNullSql.append("FNumber_").append(i).append("Name = NULL ");
            }
        }
        StringBuffer sumIn = new StringBuffer();
        sumIn.append("to_decimal(sum(saleQty),31,8) saleQty,to_decimal(sum(outQty),31,8) outQty,").append(this.sp);
        sumIn.append("to_decimal(sum(saleAmount),31,8) saleAmount,to_decimal(sum(saleCost),31,8) saleCost,to_decimal(sum(totalSaleFee),31,8) totalSaleFee ").append(this.sp);
        String querySql = null;
        try {
            if (!this.isBySaleOrg && params.containsKey("isContainCost") && params.getBoolean("isContainCost") && this.billStatus.equals((Object)SaleReportBillStatusEnum.cal)) {
                HashMap dateMap = new HashMap();
                String periodYear = params.getString("periodYear");
                String periodYearTo = params.getString("periodYearTo");
                String periodMonth = params.getString("periodMonth");
                String periodMonthTo = params.getString("periodMonthTo");
                String[] companyId = this.companyOrgIDs.split(",");
                int size = companyId.length - 1;
                for (int i = 0; i < size; ++i) {
                    HashMap<String, String> tempMap = new HashMap<String, String>();
                    String companyOrgId = companyId[i];
                    String sqlFromDate = "select fbegindate from T_BD_Period p inner join T_ORG_Company c on p.FTypeID = c.FAccountPeriodID where p.fperiodyear = '" + periodYear + "' and p.fperiodnumber='" + periodMonth + "' and c.fid=" + companyOrgId;
                    String sqlToDate = "select fenddate from T_BD_Period p inner join T_ORG_Company c on p.FTypeID = c.FAccountPeriodID where p.fperiodyear = '" + periodYearTo + "' and p.fperiodnumber='" + periodMonthTo + "' and c.fid=" + companyOrgId;
                    IRowSet rs1 = DBUtil.executeQuery((Context)ctx, (String)sqlFromDate, null);
                    IRowSet rs2 = DBUtil.executeQuery((Context)ctx, (String)sqlToDate, null);
                    while (rs1.next()) {
                        tempMap.put("beginDateByCal", rs1.getString(1));
                    }
                    while (rs2.next()) {
                        tempMap.put("endDateByCal", rs2.getString(1));
                    }
                    dateMap.put(companyOrgId, tempMap);
                }
                params.setObject("dateByCal", dateMap);
            }
            querySql = this.buildSql(ctx, params);
            StringBuffer insertSql = new StringBuffer();
            String tempStr = this.tempColsForSelect.replace("to_decimal(FBaseConvsRate,21,8)", "");
            String[] split = tempStr.split(",");
            for (int i = 0; i < split.length; ++i) {
                if (split[i].contains("FLevel")) {
                    createField.append(" ,FLevel int");
                    continue;
                }
                if (split[i].toLowerCase().contains("id")) {
                    createField.append(",").append(split[i]).append(" varchar(44)");
                    continue;
                }
                if (split[i].contains("FBaseConvsRate")) {
                    createField.append(" ,FBaseConvsRate decimal(21,8)");
                    continue;
                }
                createField.append(",").append(split[i]).append(" nvarchar(255)");
            }
            createField.append(")");
            this.tempTable = DBUtil.createTempTable((Context)ctx, (String)createField.toString());
            insertSql.append(" insert into ").append(this.tempTable).append("(");
            insertSql.append("fid,");
            insertSql.append(tempStr).append(",");
            insertSql.append(insertField).append(")");
            insertSql.append(" SELECT ").append("newbosid('88888888') fid, " + this.tempColsForSelect).append(",").append(sumOut).append(this.sp).append(" FROM (SELECT ").append(this.sp).append(this.tempColsForGroup).append(",").append(sumIn).append(this.sp).append(" FROM (").append(querySql).append(") as temp0____").append(this.sp).append(" GROUP BY ").append(this.groupCols).append(this.sp).append(") as temp3_____");
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
        }
        catch (BOSException e) {
            throw e;
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        if (setNullSql != null) {
            this.executeUpdate("UPDATE " + this.tempTable + " SET " + setNullSql.toString(), null, ctx);
        }
    }

    private void twoTotalData(Context ctx, RptParams params) throws BOSException, EASBizException {
        StringBuffer totalSql;
        String selPersTotalCols;
        String insPersTotalCols;
        String selectCols;
        String insertCols;
        String groupByMaterial = null;
        groupByMaterial = this.isAssistSum ? "fmaterialid,fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName " : "fmaterialid,fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName ";
        String groupByCustomer = "fcustomerid,fcustomerNumber,fcustomerName";
        String groupByDepartment = "fadminunitid,fadminunitName";
        String groupByPersonCustomer = "fSalePersonid,fSalePersonNum,fSalePersonName,fcustomerid,fcustomerNumber,fcustomerName";
        String groupBySaleOrgCustomer = "fSaleOrgid,fSaleOrgNum,fSaleOrgName,fcustomerid,fcustomerNumber,fcustomerName";
        String groupByPerson = "fSalePersonid,fSalePersonNum,fSalePersonName";
        String groupBySaleOrg = "fSaleOrgid,fSaleOrgNum,fSaleOrgName";
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustomer)) {
            insertCols = groupByMaterial + ",fcustomerNumber";
            selectCols = groupByMaterial + ",' " + this.SubLabel + "' ";
            this.insertGroupData(ctx, insertCols, selectCols, groupByMaterial, true);
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustGroup)) {
            this.classficationGroup(ctx, params, groupByMaterial, null, true);
            this.updateTempForStatColumn(ctx);
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusmaterial)) {
            insertCols = groupByCustomer + ",fmaterialNum";
            selectCols = groupByCustomer + ",' " + this.SubLabel + "' ";
            this.insertGroupData(ctx, insertCols, selectCols, groupByCustomer, true);
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroup)) {
            this.classficationGroup(ctx, params, groupByCustomer, null, false);
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.materGroupPlusCustomer)) {
            this.classficationGroup(ctx, params, null, groupByCustomer, false);
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.custGroupPlusMaterial)) {
            this.classficationGroup(ctx, params, null, groupByMaterial, true);
            this.updateTempForStatColumn(ctx);
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.materialGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerGroup)) {
            this.classficationGroup(ctx, params, null, null, false);
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.material)) {
            this.subtotal(ctx, params, "fmaterialNum", true);
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.customer)) {
            this.subtotal(ctx, params, "fcustomerNumber", false);
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.saleorder)) {
            this.subtotal(ctx, params, "fsoNumber", false);
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.salecontract)) {
            this.subtotal(ctx, params, "fscNumber", false);
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.departmentplusmaterial)) {
            insertCols = groupByDepartment + ",fmaterialNum";
            selectCols = groupByDepartment + ",' " + this.SubLabel + "' ";
            this.insertGroupData(ctx, insertCols, selectCols, groupByDepartment, true);
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterPerson)) {
            String insPersCusTotalCols = groupByPersonCustomer + ",fmaterialNum";
            String selPersCusTotalCols = groupByPersonCustomer + ",' " + this.SubLabel + "' ";
            this.insertGroupData(ctx, insPersCusTotalCols, selPersCusTotalCols, groupByPersonCustomer, true);
            insPersTotalCols = groupByPerson + ",fcustomerNumber";
            selPersTotalCols = groupByPerson + ",' " + this.SubLabel + "' ";
            totalSql = new StringBuffer();
            totalSql.append("insert into ");
            totalSql.append(this.tempTable).append("\n (");
            totalSql.append(insPersTotalCols);
            totalSql.append(",saleQty,outQty,saleCost,totalSaleFee,saleAmount) ");
            totalSql.append(this.sp);
            totalSql.append("\n SELECT ");
            totalSql.append(selPersTotalCols);
            totalSql.append(",sum(saleQty),sum(outQty),sum(saleCost),sum(totalSaleFee),sum(saleAmount) ");
            totalSql.append(this.sp);
            totalSql.append("\n FROM ").append(this.tempTable);
            totalSql.append(this.sp);
            totalSql.append("\n where fmaterialNum <>' ");
            totalSql.append(this.SubLabel).append("'");
            totalSql.append("\n GROUP BY ");
            totalSql.append(groupByPerson).append(this.sp);
            this.executeUpdate(totalSql.toString(), null, ctx);
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.saleOrgPlusCustomerPlusMaterial)) {
            String insOrgCusTotalCols = groupBySaleOrgCustomer + ",fmaterialNum";
            String selOrgCusTotalCols = groupBySaleOrgCustomer + ",' " + this.SubLabel + "' ";
            this.insertGroupData(ctx, insOrgCusTotalCols, selOrgCusTotalCols, groupBySaleOrgCustomer, true);
            insPersTotalCols = groupBySaleOrg + ",fcustomerNumber";
            selPersTotalCols = groupBySaleOrg + ",' " + this.SubLabel + "' ";
            totalSql = new StringBuffer();
            totalSql.append("insert into ");
            totalSql.append(this.tempTable).append("\n (");
            totalSql.append(insPersTotalCols);
            totalSql.append(",saleQty,outQty,saleCost,saleAmount,totalSaleFee,statSaleQty, statOutQty) ");
            totalSql.append(this.sp);
            totalSql.append("\n SELECT ");
            totalSql.append(selPersTotalCols);
            totalSql.append(",sum(saleQty),sum(outQty),sum(saleCost),sum(saleAmount),sum(totalSaleFee),sum(statSaleQty),sum(statOutQty) ");
            totalSql.append(this.sp);
            totalSql.append("\n FROM ").append(this.tempTable);
            totalSql.append(this.sp);
            totalSql.append("\n where fmaterialNum <>' ");
            totalSql.append(this.SubLabel).append("'");
            totalSql.append("\n GROUP BY ");
            totalSql.append(groupBySaleOrg).append(this.sp);
            this.executeUpdate(totalSql.toString(), null, ctx);
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroupPerson)) {
            this.classficationGroup(ctx, params, groupByPersonCustomer, null, false);
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.material) || this.classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustomer) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusmaterial) || this.classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.custGroupPlusMaterial) || this.classficationType.equals((Object)SaleReportClassificationEnum.departmentplusmaterial) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroupPerson) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterPerson) || this.classficationType.equals((Object)SaleReportClassificationEnum.saleOrgPlusCustomerPlusMaterial)) {
            String updateSql = "UPDATE " + this.tempTable + " SET FQtyPrecision = " + String.valueOf(this.defaultPre) + " WHERE FQtyPrecision IS NULL";
            this.executeUpdate(updateSql, null, ctx);
        }
    }

    private void insertGroupData(Context ctx, String insertCol, String selectBy, String groupBy, boolean isIncludeStatUnit) throws BOSException, EASBizException {
        StringBuffer totalSql = new StringBuffer();
        totalSql.append("insert into ").append(this.tempTable).append(" (").append(insertCol);
        if (isIncludeStatUnit) {
            totalSql.append(",saleQty,outQty,saleCost,totalSaleFee,saleAmount,statSaleQty, statOutQty) ").append(this.sp);
        } else {
            totalSql.append(",saleQty,outQty,saleCost,totalSaleFee,saleAmount) ").append(this.sp);
        }
        totalSql.append(" SELECT ").append(selectBy).append(",sum(saleQty),sum(outQty),sum(saleCost),sum(totalSaleFee),sum(saleAmount) ").append(this.sp);
        if (isIncludeStatUnit) {
            totalSql.append(",sum(statSaleQty),sum(statOutQty)");
        }
        totalSql.append(" FROM ").append(this.tempTable).append(this.sp);
        totalSql.append(" GROUP BY ").append(groupBy).append(this.sp);
        this.executeUpdate(totalSql.toString(), null, ctx);
    }

    private String buildSql(Context ctx, RptParams params) {
        SaleImcomEnum saleImcom;
        this.tempColsForSelect = null;
        this.tempColsForGroup = null;
        this.groupCols = null;
        this.isFromOUTSTORE = false;
        if (params.containsKey("imcomeFrom") && (saleImcom = SaleImcomEnum.getEnum(new Integer(params.getString("imcomeFrom")))).equals((Object)SaleImcomEnum.FROM_OUTSTORE)) {
            this.isFromOUTSTORE = true;
        }
        StringBuffer querySql = new StringBuffer();
        if (this.isFromOUTSTORE) {
            String imCostSql = this.buildImCost(ctx, params);
            querySql.append(imCostSql);
        } else {
            String imCostSql;
            String mainSql = this.buildSaleAmount(ctx, params, "sourceBillType");
            querySql.append(mainSql).append(this.sp);
            if (this.bizType.equals((Object)SaleReportBizTypeEnum.all)) {
                imCostSql = this.buildImCost(ctx, params);
                String apCostSql = this.buildApCost(ctx, params);
                querySql.append(" UNION ALL ").append(this.sp).append(imCostSql).append(this.sp);
                querySql.append(" UNION ALL ").append(this.sp).append(apCostSql);
            } else if (this.bizType.equals((Object)SaleReportBizTypeEnum.sale)) {
                String apCostSql = this.buildApCost(ctx, params);
                querySql.append(" UNION ALL ").append(this.sp).append(apCostSql);
            } else {
                imCostSql = this.buildImCost(ctx, params);
                querySql.append(" UNION ALL ").append(this.sp).append(imCostSql);
            }
        }
        if (!this.isBySaleOrg && !this.classficationType.equals((Object)SaleReportClassificationEnum.saleorder) && !this.classficationType.equals((Object)SaleReportClassificationEnum.salecontract) && params.containsKey("isContainCost") && params.getBoolean("isContainCost")) {
            if (this.billStatus.equals((Object)SaleReportBillStatusEnum.cal)) {
                String[] companyId = this.companyOrgIDs.split(",");
                int size = companyId.length - 1;
                for (int i = 0; i < size; ++i) {
                    if (params.containsKey("currentOrgId")) {
                        params.remove("currentOrgId");
                    }
                    String companyOrgId = companyId[i];
                    params.setString("currentOrgId", companyOrgId);
                    String costAdjSql = this.buildCostAdjBillQuery(ctx, params);
                    querySql.append(" UNION ALL ").append(this.sp).append(costAdjSql).append(this.sp);
                }
                if (params.containsKey("currentOrgId")) {
                    params.remove("currentOrgId");
                }
            } else if (!this.classficationType.equals((Object)SaleReportClassificationEnum.saleOrgPlusCustomerPlusMaterial)) {
                String costAdjSql = this.buildCostAdjBillQuery(ctx, params);
                querySql.append(" UNION ALL ").append(this.sp).append(costAdjSql).append(this.sp);
            }
        }
        return querySql.toString();
    }

    private List buildSqlList(Context ctx, RptParams params) {
        SaleImcomEnum saleImcom;
        this.tempColsForSelect = null;
        this.tempColsForGroup = null;
        this.groupCols = null;
        this.isFromOUTSTORE = false;
        if (params.containsKey("imcomeFrom") && (saleImcom = SaleImcomEnum.getEnum(new Integer(params.getString("imcomeFrom")))).equals((Object)SaleImcomEnum.FROM_OUTSTORE)) {
            this.isFromOUTSTORE = true;
        }
        ArrayList<String> querySql = new ArrayList<String>();
        if (this.isFromOUTSTORE) {
            String imCostSql = this.buildImCost(ctx, params);
            querySql.add(imCostSql);
        } else {
            String imCostSql;
            String mainSql = this.buildSaleAmount(ctx, params, "sourceBillType");
            querySql.add(mainSql);
            if (params.containsKey("containInvoice") && params.getBoolean("containInvoice")) {
                String mainSqlNull = this.buildSaleAmount(ctx, params, "null");
                querySql.add(mainSqlNull);
            }
            if (this.bizType.equals((Object)SaleReportBizTypeEnum.all)) {
                imCostSql = this.buildImCost(ctx, params);
                String apCostSql = this.buildApCost(ctx, params);
                querySql.add(imCostSql);
                querySql.add(apCostSql);
            } else if (this.bizType.equals((Object)SaleReportBizTypeEnum.sale)) {
                String apCostSql = this.buildApCost(ctx, params);
                querySql.add(apCostSql);
            } else {
                imCostSql = this.buildImCost(ctx, params);
                querySql.add(imCostSql);
            }
        }
        if (!this.isBySaleOrg && !this.classficationType.equals((Object)SaleReportClassificationEnum.saleorder) && !this.classficationType.equals((Object)SaleReportClassificationEnum.salecontract) && params.containsKey("isContainCost") && params.getBoolean("isContainCost")) {
            String costAdjSql = this.buildCostAdjBillQuery(ctx, params);
            querySql.add(costAdjSql);
        }
        return querySql;
    }

    private String buildSaleAmount(Context ctx, RptParams params, String sourceBillType) {
        StringBuffer sql = new StringBuffer();
        if (this.billStatus.equals((Object)SaleReportBillStatusEnum.cal)) {
            if (this.bizType.equals((Object)SaleReportBizTypeEnum.all)) {
                QuerySql mainQuery = this.buildSaleQuery(ctx, params, 2, sourceBillType);
                QuerySql calQuery = this.buildSaleQuery(ctx, params, 3, sourceBillType);
                sql.append(mainQuery.getSql()).append(this.sp);
                sql.append(" union all ").append(this.sp);
                sql.append(calQuery.getSql()).append(this.sp);
            } else if (this.bizType.equals((Object)SaleReportBizTypeEnum.sale)) {
                QuerySql calQuery = this.buildSaleQuery(ctx, params, 3, sourceBillType);
                sql.append(calQuery.getSql()).append(this.sp);
            } else {
                QuerySql mainQuery = this.buildSaleQuery(ctx, params, 2, sourceBillType);
                sql.append(mainQuery.getSql()).append(this.sp);
            }
        } else {
            QuerySql mainQuery = this.buildSaleQuery(ctx, params, 1, sourceBillType);
            sql.append(mainQuery.getSql()).append(this.sp);
        }
        return sql.toString();
    }

    private QuerySql buildSaleQuery(Context ctx, RptParams params, int type, String sourceBillType) {
        QuerySql querySql = new QuerySql();
        boolean isCalStatus = false;
        String fromDate = params.getString("dateStart");
        String toDate = params.getString("dateEnd");
        String periodYear = params.getString("periodYear");
        String periodYearTo = params.getString("periodYearTo");
        String periodMonth = params.getString("periodMonth");
        String periodMonthTo = params.getString("periodMonthTo");
        if (type == 2) {
            isCalStatus = true;
        }
        String amountColumn = "";
        String qtyColumn = "";
        if (isCalStatus) {
            amountColumn = "cl_entry.FCurrWrittenOffAmount";
            qtyColumn = "cl_entry.FCurrWrittenOffQty";
        } else {
            amountColumn = "ar_entry.famountlocal";
            qtyColumn = " case when ar_entry.fmaterialID is not null then ar_entry.fbaseqty else ar_entry.fquantity end as ";
        }
        querySql.aliasName = "AR";
        querySql.selectPart.append(" SELECT ");
        if (!isCalStatus) {
            querySql.fromPart.append(" FROM t_ar_otherbill ar_otherbill ").append(this.sp);
            querySql.fromPart.append(" INNER JOIN t_ar_otherbillentry ar_entry ");
            querySql.fromPart.append(" on ar_otherbill.fid = ar_entry.FParentID ").append(this.sp);
        } else {
            querySql.fromPart.append(" FROM T_CL_WriteOffRecord cl_entry  ").append(this.sp);
            querySql.fromPart.append(" INNER JOIN T_CL_WriteOffGroup cl_writeoff on cl_entry.FParentID = cl_writeoff.FID ").append(this.sp);
            querySql.fromPart.append(" INNER JOIN t_ar_otherbillentry ar_entry on ar_entry.FID = cl_entry.FBillEntryID ");
            querySql.fromPart.append(" INNER JOIN  t_ar_otherbill ar_otherbill on ar_otherbill.fid = ar_entry.FParentID").append(this.sp);
        }
        if ("null".equals(sourceBillType)) {
            if (params.containsKey("containInvoice") && params.getBoolean("containInvoice")) {
                querySql.wherePart.append(" WHERE ar_otherbill.FIsTransBill = 0 AND (ar_otherbill.FBillType = 102 or ar_otherbill.FBillType = 104");
            } else {
                querySql.wherePart.append(" WHERE ar_otherbill.FIsTransBill = 0 AND (ar_otherbill.FBillType = 102 ");
            }
        } else if (params.containsKey("containInvoice") && params.getBoolean("containInvoice")) {
            querySql.wherePart.append(" WHERE ar_otherbill.FIsTransBill = 0 AND (ar_otherbill.FBillType = 102 or ar_otherbill.FBillType = 104");
        } else {
            querySql.wherePart.append(" WHERE ar_otherbill.FIsTransBill = 0 AND (ar_otherbill.FBillType = 102 ");
        }
        if (!"null".equals(sourceBillType) && params.containsKey("containInvoice") && params.getBoolean("containInvoice")) {
            querySql.wherePart.append(" or ar_otherbill.FBillType = 103 ");
        }
        querySql.wherePart.append(" )");
        if (params.containsKey("containBizBill") && params.getBoolean("containBizBill")) {
            querySql.wherePart.append("  ");
        } else {
            querySql.wherePart.append(" and ar_otherbill.FisBizBill = 0 ");
        }
        if ("null".equals(sourceBillType)) {
            this.buildSelectPartNull(querySql);
        } else {
            this.buildSelectPart(querySql);
        }
        querySql.selectPart.append(qtyColumn).append(" saleQty,0.0 outQty,").append(amountColumn).append(" saleAmount,0.0 saleCost,0.0 TotalSaleFee ").append(this.sp);
        if (2 != type) {
            if (fromDate != null) {
                querySql.wherePart.append(" AND ar_otherbill.FBizDate >= to_date('").append(fromDate).append("') ");
            }
            if (toDate != null) {
                querySql.wherePart.append(" AND ar_otherbill.FBizDate <= to_date('").append(toDate).append("') ");
            }
        }
        if (3 == type) {
            this.appendTable(querySql, "T_SCM_BizType");
            querySql.wherePart.append(" AND billType.FNumber = '").append(220).append("'");
        } else {
            this.appendTable(querySql, "T_SCM_BizType");
            if (!this.bizType.equals((Object)SaleReportBizTypeEnum.all)) {
                if (this.bizType.equals((Object)SaleReportBizTypeEnum.generalSale)) {
                    querySql.wherePart.append(" AND billType.FNumber in ('210','211','212','213') ");
                } else if (this.bizType.equals((Object)SaleReportBizTypeEnum.consignSale)) {
                    querySql.wherePart.append(" AND billType.FNumber in ('230','231') ");
                } else if (this.bizType.equals((Object)SaleReportBizTypeEnum.sale)) {
                    querySql.wherePart.append(" AND billType.FNumber in ('220') ");
                }
            }
        }
        if (1 == type) {
            if (this.billStatus.equals((Object)SaleReportBillStatusEnum.audit)) {
                querySql.wherePart.append(" AND ar_otherbill.FBillStatus = 3 ");
            } else if (this.billStatus.equals((Object)SaleReportBillStatusEnum.unAudit)) {
                querySql.wherePart.append(" AND ar_otherbill.FBillStatus =2 ");
            } else {
                querySql.wherePart.append(" AND ar_otherbill.FBillStatus <> 1 ");
            }
        } else if (2 == type) {
            if (fromDate != null) {
                querySql.wherePart.append(" AND cl_writeoff.FWriteOffDate >=to_date('").append(fromDate.toString()).append("') ");
            }
            if (toDate != null) {
                querySql.wherePart.append(" AND cl_writeoff.FWriteOffDate <= to_date('").append(toDate.toString()).append("') ");
            }
            querySql.wherePart.append(" AND ( (cl_writeoff.FWriteOffYear > ").append(Integer.valueOf(periodYear));
            querySql.wherePart.append(" AND cl_writeoff.FWriteOffYear < ").append(Integer.valueOf(periodYearTo)).append(")");
            querySql.wherePart.append(" OR ( cl_writeoff.FWriteOffYear >= ").append(Integer.valueOf(periodYear));
            querySql.wherePart.append(" AND cl_writeoff.FWriteOffYear < ").append(Integer.valueOf(periodYearTo));
            querySql.wherePart.append(" AND cl_writeoff.FWriteOffPeriod >= ").append(Integer.valueOf(periodMonth)).append(")");
            querySql.wherePart.append(" OR ( cl_writeoff.FWriteOffYear > ").append(Integer.valueOf(periodYear));
            querySql.wherePart.append(" AND cl_writeoff.FWriteOffYear <= ").append(Integer.valueOf(periodYearTo));
            querySql.wherePart.append(" AND cl_writeoff.FWriteOffPeriod <= ").append(Integer.valueOf(periodMonthTo)).append(")");
            querySql.wherePart.append(" OR ( cl_writeoff.FWriteOffYear = ").append(Integer.valueOf(periodYear));
            querySql.wherePart.append(" AND cl_writeoff.FWriteOffYear = ").append(Integer.valueOf(periodYearTo));
            querySql.wherePart.append(" AND cl_writeoff.FWriteOffPeriod <= ").append(Integer.valueOf(periodMonthTo));
            querySql.wherePart.append(" AND cl_writeoff.FWriteOffPeriod >= ").append(Integer.valueOf(periodMonth)).append(")");
            querySql.wherePart.append(")");
        } else if (3 == type) {
            querySql.wherePart.append(" AND ar_otherbill.FBillStatus = 3 ");
        }
        querySql = this.buildConditionPart2(ctx, querySql, params);
        return querySql;
    }

    private String buildCostAdjBillQuery(Context ctx, RptParams params) {
        QuerySql costAdjBillSql = new QuerySql();
        costAdjBillSql.aliasName = "costAdjBill";
        costAdjBillSql.selectPart.append(" SELECT ");
        costAdjBillSql.fromPart.append(" FROM  T_CL_CostAdjustBillEntry costAdjBillEntry ");
        costAdjBillSql.fromPart.append(" INNER JOIN T_CL_CostAdjustBill costAdjBill on costAdjBill.FID = costAdjBillEntry.FParentID ").append(this.sp);
        costAdjBillSql.wherePart.append(" WHERE costAdjBill.FIssueType = 0 and costAdjBill.FCalculateKind = 1 ");
        this.buildSelectPart(costAdjBillSql);
        costAdjBillSql.selectPart.append(" 0.0 saleQty,costAdjBillEntry.fbaseqty outQty,").append(this.sp);
        costAdjBillSql.selectPart.append(" 0.0 saleAmount,costAdjBillEntry.factualcost saleCost,0.0 TotalSaleFee  ").append(this.sp);
        String fromDate = null;
        String toDate = null;
        if (this.billStatus.equals((Object)SaleReportBillStatusEnum.cal)) {
            HashMap tempMap;
            String currentOrgId = params.getString("currentOrgId");
            HashMap dateMap = (HashMap)params.getObject("dateByCal");
            if (dateMap != null && (tempMap = (HashMap)dateMap.get(currentOrgId)) != null) {
                fromDate = (String)tempMap.get("beginDateByCal");
                toDate = (String)tempMap.get("endDateByCal");
            }
        } else {
            fromDate = params.getString("dateStart");
            toDate = params.getString("dateEnd");
        }
        if (fromDate != null) {
            costAdjBillSql.wherePart.append(" AND costAdjBill.FBizDate >= to_date('").append(fromDate.toString()).append("') ");
        }
        if (toDate != null) {
            costAdjBillSql.wherePart.append(" AND costAdjBill.FBizDate <= to_date('").append(toDate.toString()).append("') ");
        }
        if (fromDate != null) {
            costAdjBillSql.wherePart.append(" AND costAdjBillEntry.FBizDate >= to_date('").append(fromDate.toString()).append("') ");
        }
        if (toDate != null) {
            costAdjBillSql.wherePart.append(" AND costAdjBillEntry.FBizDate <= to_date('").append(toDate.toString()).append("') ");
        }
        if (this.billStatus.equals((Object)SaleReportBillStatusEnum.audit) || this.billStatus.equals((Object)SaleReportBillStatusEnum.cal)) {
            costAdjBillSql.wherePart.append(" AND costAdjBill.FBaseStatus = ").append(4).append(this.sp);
        } else if (this.billStatus.equals((Object)SaleReportBillStatusEnum.unAudit)) {
            costAdjBillSql.wherePart.append(" AND costAdjBill.FBaseStatus = ").append(2).append(this.sp);
        } else {
            costAdjBillSql.wherePart.append(" AND costAdjBill.FBaseStatus <> ").append(1).append(this.sp);
        }
        costAdjBillSql = this.buildConditionPart2(ctx, costAdjBillSql, params);
        return costAdjBillSql.getSql();
    }

    private void buildSelectPart(QuerySql querySql) {
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.material) || this.classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.custGroupPlusMaterial) || this.classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustomer) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusmaterial) || this.classficationType.equals((Object)SaleReportClassificationEnum.departmentplusmaterial) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroupPerson) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterPerson) || this.classficationType.equals((Object)SaleReportClassificationEnum.saleOrgPlusCustomerPlusMaterial)) {
            if (querySql.aliasName.equalsIgnoreCase("AR")) {
                querySql.selectPart.append(" case when ar_entry.fmaterialID is not null then material.fid else ei.FID end AS fmaterialid,");
                querySql.selectPart.append(" case when ar_entry.fmaterialID is not null then material.Fnumber else ei.Fnumber end AS fmaterialNum,");
                querySql.selectPart.append(" case when ar_entry.fmaterialID is not null then ");
                querySql.selectPart.append(" material.fname_").append(this.locString).append(" else ei.FName_").append(this.locString).append(" end AS fmaterialName,");
                querySql.selectPart.append(" case when ar_entry.fmaterialID is not null then material.fshortname else  ei.FName_").append(this.locString).append(" end as fmaterialShortName, ");
                if (this.isAssistSum) {
                    querySql.selectPart.append(" material.Fmodel,assistProperty.FName_").append(this.locString).append(" AS FassistPropertyName,mmUnit.FQtyPrecision,").append(this.sp);
                } else {
                    querySql.selectPart.append(" material.Fmodel,mmUnit.FQtyPrecision,").append(this.sp);
                }
                querySql.selectPart.append(" case when ar_entry.fmaterialID is not null then baseUnit.fname_").append(this.locString).append(" else unit.FName_").append(this.locString).append(" end AS baseUnitName,");
                if (this.isAssistSum) {
                    querySql.otherPart1.append("fmaterialid,fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,");
                    querySql.otherPartAlias1.append("fmaterialid,max(fmaterialNum) fmaterialNum,max(fmaterialName) fmaterialName,max(fmaterialShortName) fmaterialShortName,max(Fmodel) Fmodel,FassistPropertyName,FQtyPrecision,max(baseUnitName) baseUnitName,");
                    querySql.groupPart.append("fmaterialid,FassistPropertyName,FQtyPrecision,");
                } else {
                    querySql.otherPart1.append("fmaterialid,fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,");
                    querySql.otherPartAlias1.append("fmaterialid,max(fmaterialNum) fmaterialNum,max(fmaterialName) fmaterialName,max(fmaterialShortName) fmaterialShortName,max(Fmodel) Fmodel,FQtyPrecision,max(baseUnitName) baseUnitName,");
                    querySql.groupPart.append("fmaterialid,FQtyPrecision,");
                }
                querySql.selectPart.append(" case when ar_entry.fmaterialID is not null then baseUnit.fname_").append(this.locString);
                querySql.selectPart.append(" else unit.FName_").append(this.locString).append(" end AS statUnitName, -1.0 as FBaseConvsRate, ");
                querySql.otherPart1.append(" statUnitName, to_decimal(FBaseConvsRate,21,8) FBaseConvsRate, ");
                querySql.otherPartAlias1.append(" max(statUnitName) statUnitName, to_decimal(FBaseConvsRate,21,8) FBaseConvsRate, ");
                querySql.groupPart.append("FBaseConvsRate,");
                this.appendTable(querySql, "t_bd_material");
                this.appendTable(querySql, "T_SCM_ExpenseItem");
                this.appendTable(querySql, "T_BD_MultiMeasureUnit");
            } else {
                querySql.selectPart.append(" material.fid fmaterialid,material.Fnumber fmaterialNum,material.fname_").append(this.locString);
                if (this.isAssistSum) {
                    querySql.selectPart.append(" as fmaterialName,material.FShortName fmaterialShortName,material.Fmodel,assistProperty.FName_").append(this.locString).append(" AS FassistPropertyName,mmUnit.FQtyPrecision,baseUnit.Fname_").append(this.locString);
                } else {
                    querySql.selectPart.append(" as fmaterialName,material.FShortName fmaterialShortName,material.Fmodel,mmUnit.FQtyPrecision,baseUnit.Fname_").append(this.locString);
                }
                querySql.selectPart.append(" as baseUnitName, ").append(this.sp);
                if (this.isAssistSum) {
                    querySql.otherPart1.append("fmaterialid,fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,");
                    querySql.otherPartAlias1.append("fmaterialid,max(fmaterialNum) fmaterialNum,max(fmaterialName) fmaterialName,max(fmaterialShortName) fmaterialShortName,max(Fmodel) Fmodel,FassistPropertyName,FQtyPrecision,max(baseUnitName) baseUnitName,");
                    querySql.groupPart.append("fmaterialid,FassistPropertyName,FQtyPrecision,");
                } else {
                    querySql.otherPart1.append("fmaterialid,fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,");
                    querySql.otherPartAlias1.append("fmaterialid,max(fmaterialNum) fmaterialNum,max(fmaterialName) fmaterialName,max(fmaterialShortName) fmaterialShortName,max(Fmodel) Fmodel,FQtyPrecision,max(baseUnitName) baseUnitName,");
                    querySql.groupPart.append("fmaterialid,FQtyPrecision,");
                }
                querySql.selectPart.append(" baseUnit.Fname_").append(this.locString).append(" as statUnitName,-1.0 as FBaseConvsRate,");
                querySql.otherPart1.append(" statUnitName, to_decimal(FBaseConvsRate,21,8) FBaseConvsRate, ");
                querySql.otherPartAlias1.append(" max(statUnitName) statUnitName, to_decimal(FBaseConvsRate,21,8) FBaseConvsRate, ");
                querySql.groupPart.append("FBaseConvsRate,");
                this.appendTable(querySql, "t_bd_material");
                this.appendTable(querySql, "T_BD_MultiMeasureUnit");
            }
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.customer) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.materGroupPlusCustomer) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusmaterial) || this.classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustomer) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterPerson) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroupPerson) || this.classficationType.equals((Object)SaleReportClassificationEnum.saleOrgPlusCustomerPlusMaterial)) {
            querySql.selectPart.append(" customer.Fid fcustomerid,customer.Fnumber fcustomerNumber,customer.FName_").append(this.locString).append(" as fcustomerName,").append(this.sp);
            querySql.otherPart1.append("fcustomerid,fcustomerNumber,fcustomerName,");
            querySql.otherPartAlias1.append("fcustomerid,max(fcustomerNumber) fcustomerNumber,max(fcustomerName) fcustomerName,");
            querySql.groupPart.append("fcustomerid,");
            this.appendTable(querySql, "t_bd_customer");
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.materialGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.materGroupPlusCustomer) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroupPerson) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroup)) {
            querySql.selectPart.append("mg.FGroupStandard STDID,mg.Fid FGID,mg.FLevel,mg.FLongNumber,mg.FNumber FGNumber,").append(this.sp);
            querySql.otherPart1.append("STDID,FGID,FLevel,FLongNumber,FGNumber,");
            querySql.otherPartAlias1.append("max(STDID) STDID,FGID,max(FLevel) FLevel,max(FLongNumber) FLongNumber,max(FGNumber) FGNumber,");
            querySql.groupPart.append("FGID,");
            this.appendTable(querySql, "t_bd_material");
            this.appendTable(querySql, "t_bd_MaterialGroupDetial");
            this.appendTable(querySql, "t_bd_materialgroup");
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.customerGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.custGroupPlusMaterial)) {
            querySql.selectPart.append(" cbg.FCSSPGroupStandardID STDID,cbg.Fid FGID,cbg.FLevel,cbg.FLongNumber,cbg.FNumber FGNumber,").append(this.sp);
            querySql.otherPart1.append("STDID,FGID,FLevel,FLongNumber,FGNumber,");
            querySql.otherPartAlias1.append("max(STDID) STDID,FGID,max(FLevel) FLevel,max(FLongNumber) FLongNumber,max(FGNumber) FGNumber,");
            querySql.groupPart.append("FGID,");
            this.appendTable(querySql, "t_bd_customer");
            this.appendTable(querySql, "t_bd_csspgroup");
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.saleorder)) {
            if (querySql.aliasName.equalsIgnoreCase("SALEISSUE")) {
                querySql.selectPart.append(" im_entry1.FSaleOrderNumber fsoNumber,");
                querySql.wherePart.append(" AND im_entry1.FCoreBillTypeID = '").append("510b6503-0105-1000-e000-0113c0a812fd463ED552").append("' ").append(this.sp);
                querySql.fromPart.append(" INNER JOIN (select a.* from  T_SD_SALEORDER a left join T_SD_SALEORDER b on a.fnumber = b.fnumber and a.fversion < b.fversion where b.fversion is null )  so ON so.Fnumber = im_entry1.FSaleOrderNumber ").append(this.sp);
            } else if (querySql.aliasName.equalsIgnoreCase("AP")) {
                querySql.selectPart.append(" ap_entry1.FCoreBillNumber  fsoNumber,");
                querySql.wherePart.append(" AND ap_entry1.FCoreBillTypeID = '").append("510b6503-0105-1000-e000-0113c0a812fd463ED552").append("' ").append(this.sp);
                querySql.fromPart.append(" INNER JOIN (select a.* from  T_SD_SALEORDER a left join T_SD_SALEORDER b on a.fnumber = b.fnumber and a.fversion < b.fversion where b.fversion is null )  so ON so.Fnumber = ap_entry1.FCoreBillNumber ").append(this.sp);
            } else if (querySql.aliasName.equalsIgnoreCase("AR")) {
                querySql.selectPart.append(" ar_entry.FCoreBillNumber  fsoNumber,");
                querySql.wherePart.append(" AND ar_entry.FCoreBillTypeID = '").append("510b6503-0105-1000-e000-0113c0a812fd463ED552").append("' ").append(this.sp);
                querySql.fromPart.append(" INNER JOIN (select a.* from  T_SD_SALEORDER a left join T_SD_SALEORDER b on a.fnumber = b.fnumber and a.fversion < b.fversion where b.fversion is null )  so ON so.Fnumber = ar_entry.FCoreBillNumber ").append(this.sp);
            }
            this.appendTable(querySql, "t_bd_customer");
            this.appendTable(querySql, "T_ORG_Admin");
            this.appendTable(querySql, "t_bd_salegroup");
            this.appendTable(querySql, "t_bd_saleperson");
            querySql.selectPart.append(" customer.fname_").append(this.locString).append(" custormer,");
            querySql.selectPart.append(" adminunit.fname_").append(this.locString).append(" adminOrgUnit,");
            querySql.selectPart.append(" saleGroup.fname_").append(this.locString).append(" saleGroup,");
            querySql.selectPart.append(" salePerson.fname_").append(this.locString).append(" salePerson,");
            querySql.otherPart1.append(" fsoNumber,custormer,adminOrgUnit,saleGroup,salePerson,");
            querySql.otherPartAlias1.append(" fsoNumber,custormer,adminOrgUnit,saleGroup,salePerson,");
            querySql.groupPart.append("fsoNumber,custormer,adminOrgUnit,saleGroup,salePerson,");
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.salecontract)) {
            querySql.otherPart1.append(" fscNumber,custormer,adminOrgUnit,saleGroup,salePerson,");
            querySql.otherPartAlias1.append(" fscNumber,custormer,adminOrgUnit,saleGroup,salePerson,");
            querySql.groupPart.append("fscNumber,custormer,adminOrgUnit,saleGroup,salePerson,");
            querySql.selectPart.append(" soEntry.FSourceBillNumber fscNumber,");
            querySql.tables.add("T_SD_SaleOrderEntry");
            if (querySql.aliasName.equalsIgnoreCase("SALEISSUE")) {
                querySql.wherePart.append(" AND im_entry1.FCoreBillTypeID = '").append("510b6503-0105-1000-e000-0113c0a812fd463ED552").append("' ").append(this.sp);
                querySql.fromPart.append(" INNER JOIN T_SD_SaleOrderEntry soEntry ON im_entry1.FSaleOrderEntryID = soEntry.FID ").append(this.sp);
                querySql.fromPart.append(" INNER JOIN T_SD_SALECONTRACT so ON so.FID = soEntry.FsourceBillID ").append(this.sp);
                this.appendTable(querySql, "t_bd_customer");
                this.appendTable(querySql, "T_ORG_Admin");
                this.appendTable(querySql, "t_bd_salegroup");
                this.appendTable(querySql, "t_bd_saleperson");
                querySql.selectPart.append(" customer.fname_").append(this.locString).append(" custormer,");
                querySql.selectPart.append(" adminunit.fname_").append(this.locString).append(" adminOrgUnit,");
                querySql.selectPart.append(" saleGroup.fname_").append(this.locString).append(" saleGroup,");
                querySql.selectPart.append(" salePerson.fname_").append(this.locString).append(" salePerson,");
            } else if (querySql.aliasName.equalsIgnoreCase("AP")) {
                querySql.wherePart.append(" AND ap_entry1.FCoreBillTypeID = '").append("510b6503-0105-1000-e000-010bc0a812fd463ED552").append("' ").append(this.sp);
                querySql.fromPart.append(" INNER JOIN T_SM_PurOrderEntry soEntry ON ap_entry1.FCoreBillEntryId = soEntry.FID ").append(this.sp);
                querySql.selectPart.append(" null,");
                querySql.selectPart.append(" null,");
                querySql.selectPart.append(" null,");
                querySql.selectPart.append(" null,");
            } else if (querySql.aliasName.equalsIgnoreCase("AR")) {
                querySql.wherePart.append(" AND ar_entry.FCoreBillTypeID = '").append("510b6503-0105-1000-e000-0113c0a812fd463ED552").append("' ").append(this.sp);
                querySql.fromPart.append(" INNER JOIN T_SD_SaleOrderEntry soEntry ON ar_entry.FCoreBillEntryId = soEntry.FID ").append(this.sp);
                querySql.fromPart.append(" INNER JOIN T_SD_SALECONTRACT so ON so.FID = soEntry.FsourceBillID ").append(this.sp);
                this.appendTable(querySql, "t_bd_customer");
                this.appendTable(querySql, "T_ORG_Admin");
                this.appendTable(querySql, "t_bd_salegroup");
                this.appendTable(querySql, "t_bd_saleperson");
                querySql.selectPart.append(" customer.fname_").append(this.locString).append(" custormer,");
                querySql.selectPart.append(" adminunit.fname_").append(this.locString).append(" adminOrgUnit,");
                querySql.selectPart.append(" saleGroup.fname_").append(this.locString).append(" saleGroup,");
                querySql.selectPart.append(" salePerson.fname_").append(this.locString).append(" salePerson,");
            }
            querySql.wherePart.append(" AND soEntry.FSourceBillTypeID = '").append("DEZBNUYZRM6ieHZ5GGlRc0Y+1VI=").append("' ").append(this.sp);
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.departmentplusmaterial)) {
            querySql.selectPart.append("adminunit.fid fadminunitid,adminunit.FName_").append(this.locString).append(" as fadminunitName,").append(this.sp);
            querySql.otherPart1.append("fadminunitid,fadminunitName,");
            querySql.otherPartAlias1.append("fadminunitid,max(fadminunitName) fadminunitName,");
            querySql.groupPart.append("fadminunitid,");
            this.appendTable(querySql, "T_ORG_Admin");
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterPerson) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroupPerson)) {
            querySql.selectPart.append("salePerson.fid fSalePersonid");
            querySql.selectPart.append(",salePerson.FNumber fSalePersonNum");
            querySql.selectPart.append(",salePerson.FName_").append(this.locString).append(" as fSalePersonName,").append(this.sp);
            querySql.otherPart1.append("fSalepersonid,fSalePersonNum,fSalePersonName,");
            querySql.otherPartAlias1.append("fSalepersonid,max(fSalePersonNum) fSalePersonNum,max(fSalePersonName) fSalePersonName,");
            querySql.groupPart.append("fSalepersonid,");
            this.appendTable(querySql, "T_BD_Person");
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.saleOrgPlusCustomerPlusMaterial)) {
            querySql.selectPart.append("saleOrg.fid fSaleOrgId");
            querySql.selectPart.append(",saleOrg.FNumber fSaleOrgNum");
            querySql.selectPart.append(",saleOrg.FName_").append(this.locString).append(" as fSaleOrgName,").append(this.sp);
            querySql.otherPart1.append("fSaleOrgId,fSaleOrgNum,fSaleOrgName,");
            querySql.otherPartAlias1.append("fSaleOrgId,max(fSaleOrgNum) fSaleOrgNum,max(fSaleOrgName) fSaleOrgName,");
            querySql.groupPart.append("fSaleOrgId,");
            this.appendTable(querySql, "t_org_baseUnit");
        }
        if (this.tempColsForSelect == null) {
            this.tempColsForSelect = querySql.otherPart1.toString().substring(0, querySql.otherPart1.lastIndexOf(","));
        }
        if (this.tempColsForGroup == null) {
            this.tempColsForGroup = querySql.otherPartAlias1.toString().substring(0, querySql.otherPartAlias1.lastIndexOf(","));
        }
        if (this.groupCols == null) {
            this.groupCols = querySql.groupPart.toString().substring(0, querySql.groupPart.lastIndexOf(","));
        }
        querySql.groupPart.setLength(0);
    }

    private String buildApCost(Context ctx, RptParams params) {
        QuerySql costApSql = new QuerySql();
        costApSql.aliasName = "AP";
        costApSql.selectPart.append(" SELECT ");
        costApSql.fromPart.append(" FROM t_ap_otherbillentry  ap_entry1 ").append(this.sp);
        costApSql.fromPart.append(" INNER JOIN t_ap_otherbill ap_other1 on ap_other1.FID = ap_entry1.FParentID ").append(this.sp);
        costApSql.wherePart.append(" WHERE  ap_other1.FBizTypeID = '").append("d8e80652-010b-1001-e000-04c5c0a812202407435C").append("' ");
        this.buildSelectPart(costApSql);
        costApSql.selectPart.append(" 0.0 saleQty,ap_entry1.fbaseqty outQty,").append("0.0 saleAmount,ap_entry1.famountlocal saleCost,0.0 TotalSaleFee  ").append(this.sp);
        String fromDate = params.getString("dateStart");
        String toDate = params.getString("dateEnd");
        if (fromDate != null) {
            costApSql.wherePart.append(" AND ap_other1.FBizDate >= to_date('").append(fromDate).append("') ").append(this.sp);
        }
        if (toDate != null) {
            costApSql.wherePart.append(" AND ap_other1.FBizDate <= to_date('").append(toDate).append("') ").append(this.sp);
        }
        if (fromDate != null) {
            costApSql.wherePart.append(" AND ap_entry1.FBillDate >= to_date('").append(fromDate).append("') ").append(this.sp);
        }
        if (toDate != null) {
            costApSql.wherePart.append(" AND ap_entry1.FBillDate <= to_date('").append(toDate).append("') ").append(this.sp);
        }
        if (this.billStatus.equals((Object)SaleReportBillStatusEnum.audit) || this.billStatus.equals((Object)SaleReportBillStatusEnum.cal)) {
            costApSql.wherePart.append(" AND ap_other1.FBillStatus = ").append(3);
        } else if (this.billStatus.equals((Object)SaleReportBillStatusEnum.unAudit)) {
            costApSql.wherePart.append(" AND ap_other1.FBillStatus = ").append(2);
        } else {
            costApSql.wherePart.append(" AND ap_other1.FBillStatus <> ").append(1);
        }
        costApSql = this.buildConditionPart2(ctx, costApSql, params);
        return costApSql.getSql();
    }

    private String buildImCost(Context ctx, RptParams params) {
        QuerySql costImSql = new QuerySql();
        costImSql.aliasName = "SALEISSUE";
        String qtyColumn = "";
        String amountColumn = "";
        String fromDate = params.getString("dateStart");
        String toDate = params.getString("dateEnd");
        String periodYear = params.getString("periodYear");
        String periodYearTo = params.getString("periodYearTo");
        String periodMonth = params.getString("periodMonth");
        String periodMonthTo = params.getString("periodMonthTo");
        if (this.billStatus.equals((Object)SaleReportBillStatusEnum.cal)) {
            qtyColumn = "cl_entry1.FCurrWrittenOffQty";
            amountColumn = "cl_entry1.FCurrWrittenOffAmount";
        } else {
            qtyColumn = "im_entry1.fbaseqty";
            amountColumn = "im_entry1.factualcost";
        }
        String totalSaleFeeColumn = " ,im_entry1.FTotalSaleFee totalSaleFee ";
        String saleQtyColumn = " 0.0 ";
        String saleAmountloc = " 0.0 ";
        if (this.isFromOUTSTORE) {
            saleQtyColumn = " im_entry1.fbaseqty ";
            saleAmountloc = " im_entry1.FLocalNonTaxAmount ";
        }
        costImSql.selectPart.append(" SELECT ");
        if (!this.billStatus.equals((Object)SaleReportBillStatusEnum.cal)) {
            costImSql.fromPart.append(" FROM t_im_saleissueentry im_entry1 ");
            costImSql.fromPart.append(" INNER JOIN T_IM_SaleIssueBill im_saleissue1 on im_saleissue1.FID = im_entry1.FParentID ").append(this.sp);
        } else {
            costImSql.fromPart.append(" FROM  T_CL_WriteOffRecord cl_entry1   ").append(this.sp);
            costImSql.fromPart.append(" INNER JOIN T_CL_WriteOffGroup cl_writeoff1 on cl_entry1.FParentID = cl_writeoff1.FID  ").append(this.sp);
            costImSql.fromPart.append(" INNER JOIN t_im_saleissueentry im_entry1 on im_entry1.FID = cl_entry1.FBillEntryID").append(this.sp);
            costImSql.fromPart.append(" INNER JOIN T_IM_SaleIssueBill im_saleissue1 on im_saleissue1.FID = im_entry1.FParentID ").append(this.sp);
        }
        costImSql.fromPart.append(" INNER JOIN T_IM_INVUPDATETYPE UPTYPE ON IM_ENTRY1.FINVUPDATETYPEID = UPTYPE.FID ");
        costImSql.wherePart.append(" WHERE 1=1 ");
        costImSql.wherePart.append(" AND  UPTYPE.FSTORETYPEPREID <> '").append("181875d5-0105-1000-e000-0114c0a812fd97D461A6").append("' ");
        this.buildSelectPart(costImSql);
        costImSql.selectPart.append(saleQtyColumn).append(" saleQty,").append(qtyColumn).append(" outQty,").append(this.sp);
        costImSql.selectPart.append(saleAmountloc).append(" saleAmount,").append(amountColumn).append(" saleCost  ").append(totalSaleFeeColumn).append(this.sp);
        if (!this.billStatus.equals((Object)SaleReportBillStatusEnum.cal)) {
            if (fromDate != null) {
                costImSql.wherePart.append(" AND im_saleissue1.FBizDate >= to_date('").append(fromDate).append("') ");
            }
            if (toDate != null) {
                costImSql.wherePart.append(" AND im_saleissue1.FBizDate <= to_date('").append(toDate).append("') ");
            }
            if (fromDate != null) {
                costImSql.wherePart.append(" AND im_entry1.FBizDate >= to_date('").append(fromDate).append("') ");
            }
            if (toDate != null) {
                costImSql.wherePart.append(" AND im_entry1.FBizDate <= to_date('").append(toDate).append("') ");
            }
        }
        if (this.bizType.equals((Object)SaleReportBizTypeEnum.consignSale) || this.bizType.equals((Object)SaleReportBizTypeEnum.generalSale)) {
            costImSql.fromPart.append("INNER JOIN T_SCM_TransactionType t12 ON im_saleissue1.FTransactionTypeID = t12.FID ");
            if (this.bizType.equals((Object)SaleReportBizTypeEnum.consignSale)) {
                costImSql.wherePart.append(" AND im_saleissue1.fbiztypeid = '");
                costImSql.wherePart.append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("' ").append(this.sp);
                costImSql.wherePart.append(" AND t12.FRITypeID='").append(RecIssueTypeConstant.SALEOUT_RITYPEID).append("'").append(this.sp);
            } else if (this.bizType.equals((Object)SaleReportBizTypeEnum.generalSale)) {
                costImSql.wherePart.append(" AND im_saleissue1.fbiztypeid in ('");
                costImSql.wherePart.append("d8e80652-010e-1000-e000-04c5c0a812202407435C").append("', '");
                costImSql.wherePart.append("d8e80652-0110-1000-e000-04c5c0a812202407435C").append("', '");
                costImSql.wherePart.append("wIZPS7oOQaOl1CeE/8cZOSQHQ1w=").append("', '");
                costImSql.wherePart.append("7eD9TwIyTMmt7ELiDSC65CQHQ1w=").append("')");
                costImSql.wherePart.append(this.sp);
            }
        }
        if (this.bizType.equals((Object)SaleReportBizTypeEnum.all)) {
            costImSql.fromPart.append("INNER JOIN T_SCM_TransactionType t12 ON im_saleissue1.FTransactionTypeID = t12.FID ");
            costImSql.wherePart.append(" AND ((t12.FID NOT IN ");
            costImSql.wherePart.append("  (SELECT FID FROM T_SCM_TransactionType transType WHERE ");
            costImSql.wherePart.append("      t12.FRITypeID='").append(RecIssueTypeConstant.CONSIGNOUT_RITYPEID).append("'");
            costImSql.wherePart.append("   OR t12.FRITypeID='").append(RecIssueTypeConstant.CONSIGNRT_RITYPEID).append("')").append(this.sp);
            costImSql.wherePart.append(")) ");
        }
        if (this.billStatus.equals((Object)SaleReportBillStatusEnum.cal)) {
            if (fromDate != null) {
                costImSql.wherePart.append(" AND cl_writeoff1.FWriteOffDate >=to_date('").append(fromDate.toString()).append("') ").append(this.sp);
            }
            if (toDate != null) {
                costImSql.wherePart.append(" AND cl_writeoff1.FWriteOffDate <= to_date('").append(toDate.toString()).append("') ").append(this.sp);
            }
            costImSql.wherePart.append(" AND ( ");
            costImSql.wherePart.append(" (cl_writeoff1.FWriteOffYear > ").append(Integer.valueOf(periodYear));
            costImSql.wherePart.append("   AND cl_writeoff1.FWriteOffYear < ").append(Integer.valueOf(periodYearTo)).append(")");
            costImSql.wherePart.append(" OR ( cl_writeoff1.FWriteOffYear >= ").append(Integer.valueOf(periodYear));
            costImSql.wherePart.append("   AND cl_writeoff1.FWriteOffYear < ").append(Integer.valueOf(periodYearTo));
            costImSql.wherePart.append("   AND cl_writeoff1.FWriteOffPeriod >= ").append(Integer.valueOf(periodMonth) + ")");
            costImSql.wherePart.append(" OR ( cl_writeoff1.FWriteOffYear > ").append(Integer.valueOf(periodYear));
            costImSql.wherePart.append("   AND cl_writeoff1.FWriteOffYear <= ").append(Integer.valueOf(periodYearTo));
            costImSql.wherePart.append("   AND cl_writeoff1.FWriteOffPeriod <= ").append(Integer.valueOf(periodMonthTo) + ")");
            costImSql.wherePart.append(" OR ( cl_writeoff1.FWriteOffYear = ").append(Integer.valueOf(periodYear));
            costImSql.wherePart.append("   AND cl_writeoff1.FWriteOffYear = ").append(Integer.valueOf(periodYearTo));
            costImSql.wherePart.append("   AND cl_writeoff1.FWriteOffPeriod <= ").append(Integer.valueOf(periodMonthTo));
            costImSql.wherePart.append("   AND cl_writeoff1.FWriteOffPeriod >= " + Integer.valueOf(periodMonth) + ")");
            costImSql.wherePart.append("    )");
        } else if (this.billStatus.equals((Object)SaleReportBillStatusEnum.audit)) {
            costImSql.wherePart.append(" AND im_saleissue1.FBaseStatus = ").append(4).append(this.sp);
        } else if (this.billStatus.equals((Object)SaleReportBillStatusEnum.unAudit)) {
            costImSql.wherePart.append(" AND im_saleissue1.FBaseStatus = ").append(2).append(this.sp);
        } else {
            StringBuffer status = new StringBuffer();
            status.append(4).append(",");
            status.append(2);
            costImSql.wherePart.append(" AND im_saleissue1.FBaseStatus IN (").append(status.toString()).append(")");
        }
        costImSql = this.buildConditionPart2(ctx, costImSql, params);
        return costImSql.getSql();
    }

    private QuerySql buildConditionPart2(Context ctx, QuerySql querySql, RptParams params) {
        if (params.getObject("customerClassfiled") != null) {
            querySql.wherePart.append(" AND csss.fname_").append(this.locString).append(" = '").append(params.getObject("customerClassfiled").toString().trim()).append("'").append(this.sp);
            this.appendTable(querySql, "T_BD_CSSPGroupStandard");
        }
        if (params.getObject("materialFrom") != null && !params.getObject("materialFrom").toString().trim().equals("")) {
            StringBuffer materialSB;
            if (params.getObject("materialFrom") instanceof ArrayList && ((ArrayList)params.getObject("materialFrom")).size() > 0) {
                ArrayList materialList = (ArrayList)params.getObject("materialFrom");
                materialSB = new StringBuffer();
                for (Map material : materialList) {
                    materialSB.append("'").append(material.get("number")).append("',");
                }
                querySql.wherePart.append(" AND material.FNumber in (").append(materialSB.toString().substring(0, materialSB.length() - 1)).append(")").append(this.sp);
            } else if (params.getObject("materialFrom") instanceof Object[]) {
                Object[] materials = (Object[])params.getObject("materialFrom");
                if (materials.length == 1) {
                    querySql.wherePart.append(" AND material.FNumber >= '").append(((MaterialInfo)materials[0]).getNumber()).append("'").append(this.sp);
                } else {
                    materialSB = new StringBuffer();
                    for (Object material : materials) {
                        materialSB.append("'").append(((MaterialInfo)material).getNumber()).append("',");
                    }
                    querySql.wherePart.append(" AND material.FNumber in (").append(materialSB.toString().substring(0, materialSB.length() - 1)).append(")").append(this.sp);
                }
            } else {
                querySql.wherePart.append(" AND material.FNumber >= '").append(params.getObject("materialFrom").toString().trim()).append("'").append(this.sp);
            }
            this.appendTable(querySql, "t_bd_material");
        }
        if (params.getObject("materialTo") != null && !params.getObject("materialTo").toString().trim().equals("")) {
            querySql.wherePart.append(" AND material.FNumber <= '").append(params.getObject("materialTo").toString().trim()).append("'").append(this.sp);
            this.appendTable(querySql, "t_bd_material");
        }
        if (params.getObject("shortNameFrom") != null && !params.getObject("shortNameFrom").toString().trim().equals("")) {
            String shortNameFrom = (String)params.getObject("shortNameFrom");
            if (shortNameFrom.indexOf("'") != -1) {
                shortNameFrom = shortNameFrom.replaceAll("'", "''");
            }
            querySql.wherePart.append(" AND material.FShortName >= '").append(shortNameFrom.trim()).append("'").append(this.sp);
            this.appendTable(querySql, "t_bd_material");
        }
        if (params.getObject("shortNameTo") != null && !params.getObject("shortNameTo").toString().trim().equals("")) {
            String shortNameTo = (String)params.getObject("shortNameTo");
            if (shortNameTo.indexOf("'") != -1) {
                shortNameTo = shortNameTo.replaceAll("'", "''");
            }
            querySql.wherePart.append(" AND material.FShortName <= '").append(shortNameTo).append("'").append(this.sp);
            this.appendTable(querySql, "t_bd_material");
        }
        if (params.getObject("materialGroupFrom") != null && !params.getObject("materialGroupFrom").toString().trim().equals("") || params.getObject("materialGroupTo") != null && !params.getObject("materialGroupTo").toString().trim().equals("")) {
            this.appendTable(querySql, "t_bd_material");
            this.appendTable(querySql, "t_bd_MaterialGroupDetial");
            this.appendTable(querySql, "t_bd_materialgroup");
            querySql.wherePart.append(this.getMaterialTypeWhere(ctx, params));
        }
        if ((this.classficationType.equals((Object)SaleReportClassificationEnum.materGroupPlusCustomer) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroupPerson) || this.classficationType.equals((Object)SaleReportClassificationEnum.materialGroup) || params.getObject("materialGroupFrom") != null && !params.getObject("materialGroupFrom").toString().trim().equals("") || params.getObject("materialGroupTo") != null && !params.getObject("materialGroupTo").toString().trim().equals("")) && params.getObject("materialClassfiled") != null) {
            querySql.wherePart.append(" AND mas.fname_l2= '").append(params.getObject("materialClassfiled").toString().trim()).append("'").append(this.sp);
            this.appendTable(querySql, "T_BD_MaterialGroupStandard");
        }
        if (params.getObject("customerFrom") != null && !params.getObject("customerFrom").toString().trim().equals("")) {
            StringBuffer customerSB;
            if (params.getObject("customerFrom") instanceof ArrayList && ((ArrayList)params.getObject("customerFrom")).size() > 0) {
                ArrayList customerList = (ArrayList)params.getObject("customerFrom");
                customerSB = new StringBuffer();
                for (Map customer : customerList) {
                    customerSB.append("'").append(customer.get("number")).append("',");
                }
                querySql.wherePart.append(" AND customer.FNumber in (").append(customerSB.toString().substring(0, customerSB.length() - 1)).append(")").append(this.sp);
            } else if (params.getObject("customerFrom") instanceof Object[]) {
                Object[] customers = (Object[])params.getObject("customerFrom");
                if (customers.length == 1) {
                    querySql.wherePart.append(" AND customer.FNumber >= '").append(((CustomerInfo)customers[0]).getNumber()).append("'").append(this.sp);
                } else {
                    customerSB = new StringBuffer();
                    for (Object customer : customers) {
                        customerSB.append("'").append(((CustomerInfo)customer).getNumber()).append("',");
                    }
                    querySql.wherePart.append(" AND customer.FNumber in (").append(customerSB.toString().substring(0, customerSB.length() - 1)).append(")").append(this.sp);
                }
            } else if (params.getObject("customerFrom") instanceof CustomerInfo) {
                querySql.wherePart.append(" AND customer.FNumber >= '").append(((CustomerInfo)params.getObject("customerFrom")).getNumber()).append("'").append(this.sp);
            } else {
                querySql.wherePart.append(" AND customer.FNumber >='").append(params.getObject("customerFrom").toString().trim()).append("'").append(this.sp);
            }
            this.appendTable(querySql, "t_bd_customer");
        }
        if (params.getObject("customerTo") != null && !params.getObject("customerTo").toString().trim().equals("")) {
            querySql.wherePart.append(" AND customer.FNumber <='").append(params.getObject("customerTo").toString().trim()).append("'").append(this.sp);
            this.appendTable(querySql, "t_bd_customer");
        }
        if (params.getObject("customerGroupFrom") != null && !params.getObject("customerGroupFrom").toString().trim().equals("")) {
            querySql.wherePart.append(" AND cbg.FNumber >= '").append(params.getObject("customerGroupFrom").toString().trim()).append("'").append(this.sp);
            this.appendTable(querySql, "t_bd_customer");
            this.appendTable(querySql, "t_bd_csspgroup");
        }
        if (params.getObject("customerGroupTo") != null && !params.getObject("customerGroupTo").toString().trim().equals("")) {
            querySql.wherePart.append(" AND cbg.FNumber <='").append(params.getObject("customerGroupTo").toString().trim()).append("'").append(this.sp);
            this.appendTable(querySql, "t_bd_customer");
            this.appendTable(querySql, "t_bd_csspgroup");
        }
        if (this.isBySaleOrg) {
            querySql.wherePart.append(" AND saleOrg.FID IN (").append(this.saleOrgIDs).append(") ").append(this.sp);
            this.appendTable(querySql, "t_org_baseUnit");
        } else if (this.billStatus.equals((Object)SaleReportBillStatusEnum.cal) && params.containsKey("currentOrgId")) {
            String currentOrgId = params.getString("currentOrgId");
            querySql.wherePart.append(" AND companyOrg.FID IN (").append(currentOrgId).append(") ").append(this.sp);
            this.appendTable(querySql, "t_org_Company");
        } else {
            querySql.wherePart.append(" AND companyOrg.FID IN (").append(this.companyOrgIDs).append(") ").append(this.sp);
            this.appendTable(querySql, "t_org_Company");
        }
        if (!querySql.aliasName.equalsIgnoreCase("costAdjBill")) {
            if (params.getObject("saleGroupFrom") != null && !params.getObject("saleGroupFrom").toString().trim().equals("")) {
                if (params.getObject("saleGroupFrom") instanceof ArrayList && ((ArrayList)params.getObject("saleGroupFrom")).size() > 0) {
                    ArrayList saleGroupList = (ArrayList)params.getObject("saleGroupFrom");
                    StringBuffer saleGroupSB = new StringBuffer();
                    for (Map saleGroup : saleGroupList) {
                        saleGroupSB.append("'").append(saleGroup.get("number")).append("',");
                    }
                    querySql.wherePart.append(" AND saleGroup.FNumber in (").append(saleGroupSB.toString().substring(0, saleGroupSB.length() - 1)).append(")").append(this.sp);
                } else {
                    querySql.wherePart.append(" AND saleGroup.FNumber >='").append(params.getObject("saleGroupFrom").toString().trim()).append("'").append(this.sp);
                }
                this.appendTable(querySql, "t_bd_salegroup");
            }
            if (params.getObject("saleGroupTo") != null && !params.getObject("saleGroupTo").toString().trim().equals("")) {
                querySql.wherePart.append(" AND saleGroup.FNumber <='").append(params.getObject("saleGroupTo").toString().trim()).append("'").append(this.sp);
                this.appendTable(querySql, "t_bd_salegroup");
            }
            if (params.getObject("salePersonFrom") != null && !params.getObject("salePersonFrom").toString().trim().equals("")) {
                StringBuffer salePersonSB;
                if (params.getObject("salePersonFrom") instanceof ArrayList && ((ArrayList)params.getObject("salePersonFrom")).size() > 0) {
                    ArrayList salePersonList = (ArrayList)params.getObject("salePersonFrom");
                    salePersonSB = new StringBuffer();
                    for (String salePersonNum : salePersonList) {
                        salePersonSB.append("'").append(salePersonNum).append("',");
                    }
                    querySql.wherePart.append(" AND salePerson.FNumber in (").append(salePersonSB.toString().substring(0, salePersonSB.length() - 1)).append(")").append(this.sp);
                } else if (params.getObject("salePersonFrom") instanceof Object[]) {
                    Object[] salePersons = (Object[])params.getObject("salePersonFrom");
                    if (salePersons.length == 1) {
                        querySql.wherePart.append(" AND salePerson.FNumber >= '").append(((PersonInfo)salePersons[0]).get("number")).append("'").append(this.sp);
                    } else {
                        salePersonSB = new StringBuffer();
                        for (Object salePerson : salePersons) {
                            salePersonSB.append("'").append(((PersonInfo)salePerson).get("number")).append("',");
                        }
                        querySql.wherePart.append(" AND salePerson.FNumber in (").append(salePersonSB.toString().substring(0, salePersonSB.length() - 1)).append(")").append(this.sp);
                    }
                } else if (params.getObject("salePersonFrom") instanceof PersonInfo) {
                    querySql.wherePart.append(" AND customer.FNumber >= '").append(((PersonInfo)params.getObject("salePersonFrom")).getNumber()).append("'").append(this.sp);
                } else {
                    querySql.wherePart.append(" AND salePerson.FNumber >='").append(params.getObject("salePersonFrom").toString().trim()).append("'").append(this.sp);
                }
                this.appendTable(querySql, "t_bd_saleperson");
            }
            if (params.getObject("salePersonTo") != null && !params.getObject("salePersonTo").toString().trim().equals("")) {
                querySql.wherePart.append(" AND salePerson.FNumber <='").append(params.getObject("salePersonTo").toString().trim()).append("'").append(this.sp);
                this.appendTable(querySql, "t_bd_saleperson");
            }
        }
        if (new Integer(params.getString("CustomerType")) == 2 && querySql.tables.contains("t_im_saleissuebill")) {
            querySql.wherePart.append(" AND im_saleissue1.FTransactionTypeID <>'wxI1pBHYRwCcMmgJoF8w5rAI3Kc=' ");
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.material) || this.classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.custGroupPlusMaterial) || this.classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustomer) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusmaterial) || this.classficationType.equals((Object)SaleReportClassificationEnum.departmentplusmaterial) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroupPerson) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterPerson) || this.classficationType.equals((Object)SaleReportClassificationEnum.saleOrgPlusCustomerPlusMaterial)) {
            this.appendTable(querySql, "T_BD_AsstAttrValue");
        }
        return querySql;
    }

    private String getMaterialTypeWhere(Context ctx, RptParams params) {
        StringBuffer sqlWhere = new StringBuffer();
        String materialTypeFrom = null;
        String materialTypeTo = null;
        if (params.getObject("materialGroupFrom") != null) {
            materialTypeFrom = params.getObject("materialGroupFrom").toString().trim();
        }
        if (params.getObject("materialGroupTo") != null) {
            materialTypeTo = params.getObject("materialGroupTo").toString().trim();
        }
        if (materialTypeFrom != null || materialTypeTo != null) {
            StringBuffer sql2 = new StringBuffer();
            StringBuffer sql22 = new StringBuffer();
            sql2.append("select flongnumber from t_bd_materialGroup where ");
            if (params.getObject("materialGroupFrom") instanceof ArrayList && ((ArrayList)params.getObject("materialGroupFrom")).size() > 0) {
                ArrayList materialGroupList = (ArrayList)params.getObject("materialGroupFrom");
                StringBuffer materialGroupSB = new StringBuffer();
                for (Map materialGroup : materialGroupList) {
                    materialGroupSB.append("'").append(materialGroup.get("number")).append("',");
                }
                sql2.append("fnumber in (").append(materialGroupSB.toString().substring(0, materialGroupSB.length() - 1)).append(") ");
                sql22.append(" mg.fnumber in (").append(materialGroupSB.toString().substring(0, materialGroupSB.length() - 1)).append(") ");
            } else {
                if (materialTypeFrom != null) {
                    sql2.append("fnumber >= '").append(materialTypeFrom).append("' ");
                    sql22.append(" mg.fnumber >= '").append(materialTypeFrom).append("' ");
                }
                if (materialTypeTo != null) {
                    if (materialTypeFrom != null) {
                        sql2.append("and ");
                        sql22.append("and ");
                    }
                    sql2.append("fnumber <= '").append(materialTypeTo).append("' ");
                    sql22.append("mg.fnumber <= '").append(materialTypeTo).append("' ");
                }
            }
            try {
                RptRowSet rs = this.executeQuery(sql2.toString(), null, ctx);
                StringBuffer sql3 = new StringBuffer();
                int count = 0;
                while (rs.next()) {
                    if (count > 0) {
                        sql3.append(" or ");
                    }
                    sql3.append(" (mg.flongnumber = '").append(rs.getString("flongnumber")).append("' ");
                    sql3.append("or mg.flongnumber like '").append(rs.getString("flongnumber")).append("!%') ");
                    ++count;
                }
                if (count > 0) {
                    if (count < 30) {
                        sqlWhere.append(" and (").append(sql3).append(") ");
                    } else {
                        sqlWhere.append(" and (").append(sql22).append(") ");
                    }
                } else {
                    sqlWhere.append(" and 1 = 2 ");
                }
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        return sqlWhere.toString();
    }

    private void appendTable(QuerySql querySql, String tableName) {
        if (tableName.equalsIgnoreCase("T_SCM_ExpenseItem")) {
            if (!querySql.tables.contains("T_SCM_ExpenseItem")) {
                querySql.tables.add("T_SCM_ExpenseItem");
                querySql.fromPart.append(" LEFT OUTER JOIN T_SCM_ExpenseItem ei on ei.fid = ar_entry.fexpenseitemid ").append(this.sp);
            }
        } else if (tableName.equalsIgnoreCase("t_bd_material")) {
            if (!querySql.tables.contains("t_bd_material")) {
                querySql.tables.add("t_bd_material");
                if (querySql.aliasName.equals("AR")) {
                    querySql.fromPart.append(" LEFT OUTER JOIN t_bd_material material on material.fid = ar_entry.fmaterialID ").append(this.sp);
                } else if (querySql.aliasName.equals("AP")) {
                    querySql.fromPart.append(" LEFT OUTER JOIN t_bd_material material on material.fid = ap_entry1.fmaterialID ").append(this.sp);
                } else if (querySql.aliasName.equals("SALEISSUE")) {
                    querySql.fromPart.append(" INNER JOIN t_bd_material material on material.fid = im_entry1.fmaterialID ").append(this.sp);
                } else if (querySql.aliasName.equals("costAdjBill")) {
                    querySql.fromPart.append(" LEFT OUTER JOIN t_bd_material material on material.fid = costAdjBillEntry.fmaterialID ").append(this.sp);
                }
            }
        } else if (tableName.equalsIgnoreCase("T_BD_AsstAttrValue")) {
            if (!querySql.tables.contains("T_BD_AsstAttrValue")) {
                querySql.tables.add("T_BD_AsstAttrValue");
                if (querySql.aliasName.equals("AR")) {
                    querySql.fromPart.append(" LEFT OUTER JOIN T_BD_AsstAttrValue assistProperty on assistProperty.fid = ar_entry.fassistPropertyID ").append(this.sp);
                } else if (querySql.aliasName.equals("AP")) {
                    querySql.fromPart.append(" LEFT OUTER JOIN T_BD_AsstAttrValue assistProperty on assistProperty.fid = ap_entry1.fassistPropertyID ").append(this.sp);
                } else if (querySql.aliasName.equals("SALEISSUE")) {
                    querySql.fromPart.append(" LEFT OUTER JOIN T_BD_AsstAttrValue assistProperty on assistProperty.fid = im_entry1.fassistPropertyID ").append(this.sp);
                } else if (querySql.aliasName.equals("costAdjBill")) {
                    querySql.fromPart.append(" LEFT OUTER JOIN T_BD_AsstAttrValue assistProperty on assistProperty.fid = costAdjBillEntry.fassistPropertyID ").append(this.sp);
                }
            }
        } else if (tableName.equalsIgnoreCase("T_BD_MultiMeasureUnitNull")) {
            if (!querySql.tables.contains("T_BD_MultiMeasureUnitNull")) {
                querySql.tables.add("t_bd_material");
                if (querySql.aliasName.equals("AR")) {
                    querySql.fromPart.append(" LEFT OUTER JOIN t_bd_measureUnit baseUnit ");
                    querySql.fromPart.append("on material.FBaseUnit = baseUnit.FID ").append(this.sp);
                    querySql.fromPart.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit mmUnit ");
                    querySql.fromPart.append(" on ar_entry.fmaterialID =  mmUnit.FMaterialID ");
                    querySql.fromPart.append(" AND baseUnit.FID = mmUnit.FMeasureUnitID ").append(this.sp);
                    querySql.fromPart.append(" left outer join T_BD_MeasureUnit unit on unit.fid = ar_entry.FMeasureUnitID ").append(this.sp);
                } else if (querySql.aliasName.equals("AP")) {
                    querySql.fromPart.append(" inner join t_bd_measureUnit baseUnit on material.FBaseUnit = baseUnit.FID ").append(this.sp);
                    querySql.fromPart.append(" INNER JOIN T_BD_MultiMeasureUnit mmUnit on ap_entry1.fmaterialID =  mmUnit.FMaterialID AND baseUnit.FID = mmUnit.FMeasureUnitID ").append(this.sp);
                } else if (querySql.aliasName.equals("SALEISSUE")) {
                    querySql.fromPart.append(" inner join t_bd_measureUnit baseUnit on material.FBaseUnit = baseUnit.FID ").append(this.sp);
                    querySql.fromPart.append(" INNER JOIN T_BD_MultiMeasureUnit mmUnit on im_entry1.fmaterialID =  mmUnit.FMaterialID AND baseUnit.FID = mmUnit.FMeasureUnitID ").append(this.sp);
                } else if (querySql.aliasName.equals("costAdjBill")) {
                    querySql.fromPart.append(" inner join t_bd_measureUnit baseUnit on material.FBaseUnit = baseUnit.FID ").append(this.sp);
                    querySql.fromPart.append(" INNER JOIN T_BD_MultiMeasureUnit mmUnit on costAdjBillEntry.fmaterialID =  mmUnit.FMaterialID AND baseUnit.FID = mmUnit.FMeasureUnitID ").append(this.sp);
                }
            }
        } else if (tableName.equalsIgnoreCase("T_BD_CSSPGroupStandard")) {
            if (!querySql.tables.contains("T_BD_CSSPGroupStandard")) {
                querySql.tables.add("T_BD_CSSPGroupStandard");
                querySql.fromPart.append(" inner  join T_BD_CSSPGroupStandard csss on csss.fid=cbg.FCSSPGroupStandardID").append(this.sp);
            }
        } else if (tableName.equalsIgnoreCase("T_BD_MaterialGroupStandard")) {
            if (!querySql.tables.contains("T_BD_MaterialGroupStandard")) {
                querySql.tables.add("T_BD_MaterialGroupStandard");
                querySql.fromPart.append(" inner  join T_BD_MaterialGroupStandard mas on mas.fid=mg.FGroupStandard").append(this.sp);
            }
        } else if (tableName.equalsIgnoreCase("T_BD_MultiMeasureUnit")) {
            if (!querySql.tables.contains("T_BD_MultiMeasureUnit")) {
                querySql.tables.add("t_bd_material");
                if (querySql.aliasName.equals("AR")) {
                    querySql.fromPart.append(" LEFT OUTER JOIN t_bd_measureUnit baseUnit ");
                    querySql.fromPart.append("on material.FBaseUnit = baseUnit.FID ").append(this.sp);
                    querySql.fromPart.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit mmUnit ");
                    querySql.fromPart.append(" on ar_entry.fmaterialID =  mmUnit.FMaterialID ");
                    querySql.fromPart.append(" AND baseUnit.FID = mmUnit.FMeasureUnitID ").append(this.sp);
                    querySql.fromPart.append(" left outer join T_BD_MeasureUnit unit on unit.fid = ar_entry.FMeasureUnitID ").append(this.sp);
                } else if (querySql.aliasName.equals("AP")) {
                    querySql.fromPart.append(" inner join t_bd_measureUnit baseUnit on material.FBaseUnit = baseUnit.FID ").append(this.sp);
                    querySql.fromPart.append(" INNER JOIN T_BD_MultiMeasureUnit mmUnit on ap_entry1.fmaterialID =  mmUnit.FMaterialID AND baseUnit.FID = mmUnit.FMeasureUnitID ").append(this.sp);
                } else if (querySql.aliasName.equals("SALEISSUE")) {
                    querySql.fromPart.append(" inner join t_bd_measureUnit baseUnit on material.FBaseUnit = baseUnit.FID ").append(this.sp);
                    querySql.fromPart.append(" INNER JOIN T_BD_MultiMeasureUnit mmUnit on im_entry1.fmaterialID =  mmUnit.FMaterialID AND baseUnit.FID = mmUnit.FMeasureUnitID ").append(this.sp);
                } else if (querySql.aliasName.equals("costAdjBill")) {
                    querySql.fromPart.append(" inner join t_bd_measureUnit baseUnit on material.FBaseUnit = baseUnit.FID ").append(this.sp);
                    querySql.fromPart.append(" INNER JOIN T_BD_MultiMeasureUnit mmUnit on costAdjBillEntry.fmaterialID =  mmUnit.FMaterialID AND baseUnit.FID = mmUnit.FMeasureUnitID ").append(this.sp);
                }
            }
        } else if (tableName.equalsIgnoreCase("t_bd_MaterialGroupDetial")) {
            if (!querySql.tables.contains("t_bd_MaterialGroupDetial")) {
                querySql.tables.add("t_bd_MaterialGroupDetial");
                querySql.fromPart.append(" inner  join t_bd_MaterialGroupDetial mgd on material.fid = mgd.fmaterialid").append(this.sp);
            }
        } else if (tableName.equalsIgnoreCase("t_bd_materialgroup")) {
            if (!querySql.tables.contains("t_bd_materialgroup")) {
                querySql.tables.add("t_bd_materialgroup");
                querySql.fromPart.append(" inner  join t_bd_materialgroup mg on mgd.FMaterialGroupID = mg.fid ").append(this.sp);
            }
        } else if (tableName.equalsIgnoreCase("t_bd_customer")) {
            if (!querySql.tables.contains("t_bd_customer")) {
                querySql.tables.add("t_bd_customer");
                if (new Integer(this.params.getString("CustomerType")) == 1 && querySql.aliasName.equals("AR")) {
                    querySql.fromPart.append(" INNER JOIN t_bd_customer customer ");
                    querySql.fromPart.append(" on ar_otherbill.FAsstActID = customer.fid ");
                    querySql.fromPart.append(this.sp);
                }
                if (new Integer(this.params.getString("CustomerType")) == 2 && querySql.aliasName.equals("AR")) {
                    querySql.fromPart.append(" INNER JOIN t_bd_customer customer ");
                    querySql.fromPart.append(" on ar_entry.FServiceCustomerID = customer.fid ");
                    querySql.fromPart.append(this.sp);
                }
                if (new Integer(this.params.getString("CustomerType")) == 3) {
                    if (querySql.aliasName.equals("SALEISSUE")) {
                        querySql.fromPart.append(" INNER JOIN t_bd_customer customer ");
                        querySql.fromPart.append(" on im_entry1.FOrderCustomerID = customer.fid ");
                        querySql.fromPart.append(this.sp);
                    } else if (querySql.aliasName.equals("AR")) {
                        querySql.fromPart.append(" INNER JOIN t_bd_customer customer ");
                        querySql.fromPart.append(" on ar_entry.FOrderCustomerID = customer.fid ");
                        querySql.fromPart.append(this.sp);
                    } else if (querySql.aliasName.equals("AP")) {
                        querySql.fromPart.append(" INNER JOIN t_bd_customer customer ");
                        querySql.fromPart.append(" on ap_other1.FAsstActID = customer.fid ");
                        querySql.fromPart.append(this.sp);
                    } else if (querySql.aliasName.equals("costAdjBill")) {
                        querySql.fromPart.append(" INNER JOIN t_bd_customer customer ");
                        querySql.fromPart.append(" on costAdjBill.FCustomerID = customer.fid ");
                        querySql.fromPart.append(this.sp);
                    }
                } else if (querySql.aliasName.equals("AP")) {
                    querySql.tables.add("T_SM_PURORDER");
                    querySql.fromPart.append(" INNER JOIN T_SM_PURORDER purOrder ").append(this.sp);
                    querySql.fromPart.append(" on purOrder.FNumber = ap_entry1.FCoreBillNumber ").append(this.sp);
                    querySql.fromPart.append(" inner join T_SM_PURORDERENTRY purentry1 ").append(this.sp);
                    querySql.fromPart.append(" on purOrder.FID = purentry1.FParentID ").append(this.sp);
                    querySql.fromPart.append(" AND purentry1.fid = ap_entry1.fsourcebillentryid ").append(this.sp);
                    querySql.fromPart.append(" INNER JOIN T_SD_SALEORDER saleOrder ").append(this.sp);
                    querySql.fromPart.append(" on saleOrder.fnumber = purentry1.fsourcebillnumber ").append(this.sp);
                    querySql.fromPart.append(" INNER JOIN T_SD_SALEORDERENTRY soEntry1 ").append(this.sp);
                    querySql.fromPart.append(" on soEntry1.fparentid = saleOrder.fid AND soEntry1.fid = purentry1.fsourcebillentryid").append(this.sp);
                    querySql.fromPart.append(this.sp);
                    if (new Integer(this.params.getString("CustomerType")) == 1) {
                        querySql.fromPart.append(" INNER JOIN t_bd_customer customer ");
                        querySql.fromPart.append(" on soEntry1.FReceiveCustomerID = customer.fid ");
                        querySql.fromPart.append(this.sp);
                    }
                    if (new Integer(this.params.getString("CustomerType")) == 2) {
                        querySql.fromPart.append(" INNER JOIN t_bd_customer customer ");
                        querySql.fromPart.append(" on soEntry1.FDeliveryCustomerID = customer.fid ");
                        querySql.fromPart.append(this.sp);
                    }
                    if (new Integer(this.params.getString("CustomerType")) == 3) {
                        querySql.fromPart.append(" INNER JOIN t_bd_customer customer ");
                        querySql.fromPart.append(" on saleOrder.FOrderCustomerID = customer.fid ");
                        querySql.fromPart.append(this.sp);
                    }
                } else if (querySql.aliasName.equals("SALEISSUE")) {
                    if (new Integer(this.params.getString("CustomerType")) == 1) {
                        querySql.fromPart.append(" INNER JOIN t_bd_customer customer ");
                        querySql.fromPart.append(" on im_entry1.FBalanceCustomerID = customer.fid ");
                        querySql.fromPart.append(this.sp);
                    }
                    if (new Integer(this.params.getString("CustomerType")) == 2) {
                        querySql.fromPart.append(" INNER JOIN t_bd_customer customer ");
                        querySql.fromPart.append(" on im_saleissue1.FCustomerID = customer.fid ");
                        querySql.fromPart.append(this.sp);
                    }
                    if (new Integer(this.params.getString("CustomerType")) == 3) {
                        querySql.fromPart.append(" INNER JOIN t_bd_customer customer ");
                        querySql.fromPart.append("on im_entry1.FOrderCustomerID = customer.fid ");
                        querySql.fromPart.append(this.sp);
                    }
                } else if (querySql.aliasName.equals("costAdjBill")) {
                    querySql.fromPart.append(" INNER JOIN t_bd_customer customer ");
                    querySql.fromPart.append(" on costAdjBill.FCustomerID = customer.fid ");
                    querySql.fromPart.append(this.sp);
                }
            }
        } else if (tableName.equalsIgnoreCase("t_bd_csspgroup")) {
            if (!querySql.tables.contains("t_bd_csspgroup")) {
                querySql.tables.add("t_bd_csspgroup");
                querySql.fromPart.append(" INNER JOIN T_BD_CustomerGroupDetail cstD on cstD.FCustomerID = customer.fid").append(this.sp);
                querySql.fromPart.append(" INNER JOIN t_bd_csspgroup cbg on cstD.FCustomerGroupID = cbg.fid ").append(this.sp);
            }
        } else if (tableName.equalsIgnoreCase("t_org_baseUnit")) {
            if (!querySql.tables.contains("t_org_baseUnit")) {
                querySql.tables.add("t_org_baseUnit");
                if (querySql.aliasName.equals("AR")) {
                    querySql.fromPart.append(" INNER JOIN t_org_baseUnit saleOrg on saleOrg.FID = ar_otherbill.FSaleOrgID").append(this.sp);
                } else if (querySql.aliasName.equals("AP")) {
                    if (!querySql.tables.contains("T_SM_PURORDER")) {
                        querySql.tables.add("T_SM_PURORDER");
                        querySql.fromPart.append(" INNER JOIN T_SM_PURORDER purOrder ").append(this.sp);
                        querySql.fromPart.append(" on purOrder.FNumber = ap_entry1.FCoreBillNumber ").append(this.sp);
                        querySql.fromPart.append(" inner join T_SM_PURORDERENTRY purentry1 ").append(this.sp);
                        querySql.fromPart.append(" on purOrder.FID = purentry1.FParentID ").append(this.sp);
                        querySql.fromPart.append(" AND purentry1.fid = ap_entry1.fsourcebillentryid ").append(this.sp);
                        querySql.fromPart.append(" INNER JOIN T_SD_SALEORDER saleOrder ").append(this.sp);
                        querySql.fromPart.append(" on saleOrder.fnumber = purentry1.fsourcebillnumber ").append(this.sp);
                        querySql.fromPart.append(" INNER JOIN T_SD_SALEORDERENTRY soEntry1 ").append(this.sp);
                        querySql.fromPart.append(" on soEntry1.fparentid = saleOrder.fid AND soEntry1.fid = purentry1.fsourcebillentryid").append(this.sp);
                    }
                    querySql.fromPart.append(" INNER JOIN t_org_baseUnit saleOrg on saleOrg.FID = saleOrder.FSaleOrgUnitID").append(this.sp);
                } else if (querySql.aliasName.equals("SALEISSUE")) {
                    querySql.fromPart.append(" INNER JOIN t_org_baseUnit saleOrg on saleOrg.FID = im_entry1.FSaleOrgUnitID").append(this.sp);
                }
            }
        } else if (tableName.equalsIgnoreCase("t_org_Company")) {
            if (!querySql.tables.contains("t_org_Company")) {
                querySql.tables.add("t_org_Company");
                if (querySql.aliasName.equals("AR")) {
                    querySql.fromPart.append(" INNER JOIN t_org_Company companyOrg on companyOrg.FID = ar_otherbill.FCompanyID").append(this.sp);
                } else if (querySql.aliasName.equals("AP")) {
                    if (!querySql.tables.contains("T_SM_PURORDER")) {
                        querySql.tables.add("T_SM_PURORDER");
                        querySql.fromPart.append(" INNER JOIN T_SM_PURORDER purOrder ").append(this.sp);
                        querySql.fromPart.append(" on purOrder.FNumber = ap_entry1.FCoreBillNumber ").append(this.sp);
                        querySql.fromPart.append(" inner join T_SM_PURORDERENTRY purentry1 ").append(this.sp);
                        querySql.fromPart.append(" on purOrder.FID = purentry1.FParentID ").append(this.sp);
                        querySql.fromPart.append(" AND purentry1.fid = ap_entry1.fsourcebillentryid ").append(this.sp);
                        querySql.fromPart.append(" INNER JOIN T_SD_SALEORDER saleOrder ").append(this.sp);
                        querySql.fromPart.append(" on saleOrder.fnumber = purentry1.fsourcebillnumber ").append(this.sp);
                        querySql.fromPart.append(" INNER JOIN T_SD_SALEORDERENTRY soEntry1 ").append(this.sp);
                        querySql.fromPart.append(" on soEntry1.fparentid = saleOrder.fid AND soEntry1.fid = purentry1.fsourcebillentryid").append(this.sp);
                    }
                    querySql.fromPart.append(" INNER JOIN t_org_Company companyOrg on companyOrg.FID = saleOrder.FCompanyOrgUnitID").append(this.sp);
                } else if (querySql.aliasName.equals("SALEISSUE")) {
                    querySql.fromPart.append(" INNER JOIN t_org_Company companyOrg on companyOrg.FID = im_entry1.FCompanyOrgUnitID").append(this.sp);
                } else if (querySql.aliasName.equals("costAdjBill")) {
                    querySql.fromPart.append("LEFT OUTER JOIN T_ORG_UnitRelation orgRe ON orgRe.FFromUnitID = costAdjBill.FStorageOrgUnitID ");
                    querySql.fromPart.append("     AND orgRe.FTypeRelationID = '").append("00000000-0000-0000-0000-0000000000070FE9F8B5").append("' ").append(this.sp);
                    querySql.fromPart.append("inner join t_org_Company companyOrg on orgRe.FToUnitID = companyOrg.FID  ").append(this.sp);
                }
            }
        } else if (tableName.equalsIgnoreCase("t_bd_salegroup")) {
            if (!querySql.tables.contains("t_bd_salegroup")) {
                querySql.tables.add("t_bd_salegroup");
                if (querySql.aliasName.equals("AR")) {
                    querySql.fromPart.append(" left JOIN T_BD_SaleGroup saleGroup on saleGroup.fid = ar_otherbill.FSaleGroupID").append(this.sp);
                } else if (querySql.aliasName.equals("AP")) {
                    if (!querySql.tables.contains("T_SM_PURORDER")) {
                        querySql.tables.add("T_SM_PURORDER");
                        querySql.fromPart.append(" INNER JOIN T_SM_PURORDER purOrder ").append(this.sp);
                        querySql.fromPart.append(" on purOrder.FNumber = ap_entry1.FCoreBillNumber ").append(this.sp);
                        querySql.fromPart.append(" inner join T_SM_PURORDERENTRY purentry1 ").append(this.sp);
                        querySql.fromPart.append(" on purOrder.FID = purentry1.FParentID ").append(this.sp);
                        querySql.fromPart.append(" AND purentry1.fid = ap_entry1.fsourcebillentryid ").append(this.sp);
                        querySql.fromPart.append(" INNER JOIN T_SD_SALEORDER saleOrder ").append(this.sp);
                        querySql.fromPart.append(" on saleOrder.fnumber = purentry1.fsourcebillnumber ").append(this.sp);
                        querySql.fromPart.append(" INNER JOIN T_SD_SALEORDERENTRY soEntry1 ").append(this.sp);
                        querySql.fromPart.append(" on soEntry1.fparentid = saleOrder.fid AND soEntry1.fid = purentry1.fsourcebillentryid").append(this.sp);
                    }
                    querySql.fromPart.append(" left JOIN T_BD_SaleGroup saleGroup on saleGroup.fid = saleOrder.FSaleGroupID").append(this.sp);
                } else if (querySql.aliasName.equals("SALEISSUE")) {
                    querySql.fromPart.append(" left JOIN T_BD_SaleGroup saleGroup on saleGroup.fid = im_entry1.FSaleGroupID").append(this.sp);
                }
            }
        } else if (tableName.equalsIgnoreCase("t_bd_saleperson")) {
            if (!querySql.tables.contains("t_bd_saleperson")) {
                querySql.tables.add("t_bd_saleperson");
                if (querySql.aliasName.equals("AR") && querySql.fromPart.toString().indexOf(" T_BD_Person ") == -1) {
                    querySql.fromPart.append(" INNER JOIN T_BD_Person salePerson on salePerson.fid = ar_otherbill.FPersonId").append(this.sp);
                } else if (querySql.aliasName.equals("AP") && querySql.fromPart.toString().indexOf(" T_BD_Person ") == -1) {
                    if (querySql.fromPart.toString().indexOf("T_SM_PURORDER") <= 0) {
                        querySql.fromPart.append(" INNER JOIN T_SM_PURORDER purOrder ").append(this.sp);
                        querySql.fromPart.append(" on purOrder.FNumber = ap_entry1.FCoreBillNumber ").append(this.sp);
                        querySql.fromPart.append(" inner join T_SM_PURORDERENTRY purentry1 ").append(this.sp);
                        querySql.fromPart.append(" on purOrder.FID = purentry1.FParentID ").append(this.sp);
                        querySql.fromPart.append(" AND purentry1.fid = ap_entry1.fsourcebillentryid ").append(this.sp);
                        querySql.fromPart.append(" INNER JOIN T_SD_SALEORDER saleOrder ").append(this.sp);
                        querySql.fromPart.append(" on saleOrder.fnumber = purentry1.fsourcebillnumber ").append(this.sp);
                        querySql.fromPart.append(" INNER JOIN T_SD_SALEORDERENTRY soEntry1 ").append(this.sp);
                        querySql.fromPart.append(" on soEntry1.fparentid = saleOrder.fid AND soEntry1.fid = purentry1.fsourcebillentryid").append(this.sp);
                    }
                    querySql.fromPart.append(" INNER JOIN T_BD_Person salePerson on salePerson.fid = saleOrder.FSalePersonID").append(this.sp);
                } else if (querySql.aliasName.equals("SALEISSUE") && querySql.fromPart.toString().indexOf(" T_BD_Person ") == -1) {
                    querySql.fromPart.append(" INNER JOIN T_BD_Person salePerson on salePerson.fid = im_entry1.FSalePersonID").append(this.sp);
                }
            }
        } else if (tableName.equalsIgnoreCase("t_scm_biztype")) {
            if (!querySql.tables.contains("t_scm_biztype")) {
                querySql.tables.add("t_scm_biztype");
                if (querySql.aliasName.equals("AR")) {
                    querySql.fromPart.append(" INNER JOIN T_SCM_BizType billType on billType.fid  = ar_otherbill.FBizTypeID").append(this.sp);
                } else if (querySql.aliasName.equals("AP")) {
                    querySql.fromPart.append(" INNER JOIN T_SCM_BizType billType on billType.fid  = ap_other1.FBizTypeID").append(this.sp);
                }
            }
        } else if (tableName.equalsIgnoreCase("T_ORG_Admin")) {
            if (!querySql.tables.contains("T_ORG_Admin")) {
                querySql.tables.add("T_ORG_Admin");
                if (querySql.aliasName.equals("AR")) {
                    querySql.fromPart.append(" LEFT OUTER JOIN T_ORG_Admin adminunit on adminunit.fid = ar_otherbill.FAdminOrgUnitID ").append(this.sp);
                } else if (querySql.aliasName.equals("AP")) {
                    querySql.fromPart.append(" LEFT OUTER JOIN T_ORG_Admin adminunit on adminunit.fid = ap_other1.FAdminOrgUnitID ").append(this.sp);
                } else if (querySql.aliasName.equals("SALEISSUE")) {
                    querySql.fromPart.append(" LEFT OUTER JOIN T_ORG_Admin adminunit on adminunit.fid = im_saleissue1.FAdminOrgUnitID ").append(this.sp);
                } else if (querySql.aliasName.equals("costAdjBill")) {
                    querySql.fromPart.append(" LEFT OUTER JOIN T_ORG_Admin adminunit on adminunit.fid = costAdjBill.FAdminOrgUnitID ").append(this.sp);
                }
            }
        } else if (tableName.equalsIgnoreCase("T_BD_Person") && !querySql.tables.contains("T_BD_Person")) {
            querySql.tables.add("T_BD_Person");
            if (querySql.aliasName.equals("AR")) {
                querySql.fromPart.append(" LEFT OUTER JOIN T_BD_Person salePerson on salePerson.fid = ar_otherbill.Fpersonid ").append(this.sp);
            } else if (querySql.aliasName.equals("AP")) {
                querySql.fromPart.append(" LEFT OUTER JOIN T_BD_Person salePerson on salePerson.fid = ap_other1.Fpersonid ").append(this.sp);
            } else if (querySql.aliasName.equals("SALEISSUE")) {
                querySql.fromPart.append(" LEFT OUTER JOIN T_BD_Person salePerson on salePerson.fid = im_entry1.fsalepersonid ").append(this.sp);
            } else if (querySql.aliasName.equals("costAdjBill")) {
                querySql.fromPart.append(" LEFT OUTER JOIN T_BD_Person salePerson on salePerson.fid = costAdjBill.FCustomerID ").append(this.sp);
            }
        }
    }

    private void classficationGroup(Context ctx, RptParams params, String prefixFlds, String suffix, boolean isIncludeStatUnit) throws BOSException, EASBizException {
        this.minLevel = this.minLevel(ctx, params);
        String[] splitSqls = this.splitLongNumber(ctx, this.minLevel, params);
        String[] sbuTotalSqls = this.subTotal(prefixFlds, suffix, this.minLevel, isIncludeStatUnit);
        String deleteSql = "DELETE FROM " + this.tempTable + " WHERE FGID IS NOT NULL";
        String totalSql = null;
        if (this.minLevel >= 1) {
            StringBuffer totalBuff = new StringBuffer();
            totalBuff.append("insert into ").append(this.tempTable);
            totalBuff.append(" (");
            if (prefixFlds != null && !this.classficationType.equals((Object)SaleReportClassificationEnum.custGroupPlusMaterial)) {
                totalBuff.append(prefixFlds).append(",");
            }
            totalBuff.append("FNumber_1,FNumber_1Name");
            if (isIncludeStatUnit) {
                totalBuff.append(",saleQty,outQty,saleCost,totalSaleFee,saleAmount,statSaleQty,statOutQty ");
            } else {
                totalBuff.append(",saleQty,outQty,saleCost,totalSaleFee,saleAmount ");
            }
            totalBuff.append(") ");
            totalBuff.append(" SELECT ");
            if (prefixFlds != null && !this.classficationType.equals((Object)SaleReportClassificationEnum.custGroupPlusMaterial)) {
                totalBuff.append(prefixFlds).append(",");
            }
            totalBuff.append("' ").append(this.SubLabel).append("',' ").append(this.SubLabel).append("'");
            if (isIncludeStatUnit) {
                totalBuff.append(",sum(saleQty),sum(outQty),sum(saleCost),sum(totalSaleFee),sum(saleAmount),sum(statSaleQty),sum(statOutQty) ");
            } else {
                totalBuff.append(",sum(saleQty),sum(outQty),sum(saleCost),sum(totalSaleFee),sum(saleAmount) ");
            }
            totalBuff.append(" FROM ").append(this.tempTable).append(this.sp);
            totalBuff.append(" WHERE FGID is not null ").append(this.sp);
            if (prefixFlds != null && !this.classficationType.equals((Object)SaleReportClassificationEnum.custGroupPlusMaterial)) {
                totalBuff.append(" GROUP BY ").append(prefixFlds).append(this.sp);
            }
            totalSql = totalBuff.toString();
        }
        this.executeBatchUpdate(ctx, splitSqls);
        if (totalSql != null) {
            this.executeUpdate(totalSql, null, ctx);
        }
        this.executeBatchUpdate(ctx, sbuTotalSqls);
        this.executeUpdate(deleteSql, null, ctx);
    }

    private void subtotal(Context ctx, RptParams params, String fld, boolean isIncludeStatUnit) throws BOSException, EASBizException {
        int rowCount = this.totalRowCount(ctx);
        if (rowCount > 0) {
            StringBuffer sql = new StringBuffer();
            String qtyColumn = "saleQty,outQty,saleAmount,saleCost,totalSaleFee" + (isIncludeStatUnit ? ",statSaleQty,statOutQty" : "");
            String sumQtyColumn = "sum(saleQty),sum(outQty),sum(saleAmount),sum(saleCost),sum(totalSaleFee)" + (isIncludeStatUnit ? ",sum(statSaleQty),sum(statOutQty)" : "");
            if ("fmaterialNum".equals(fld)) {
                sql.append("INSERT INTO ").append(this.tempTable).append(" (").append(fld).append(",Fmaterialid,").append(qtyColumn).append(")");
                sql.append(" SELECT ' ").append(this.SubLabel).append("','zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz',").append(sumQtyColumn);
                sql.append(" FROM ").append(this.tempTable);
            } else if ("fcustomerNumber".equals(fld)) {
                sql.append("INSERT INTO ").append(this.tempTable).append(" (").append(fld).append(",Fcustomerid,").append(qtyColumn).append(")");
                sql.append(" SELECT ' ").append(this.SubLabel).append("','zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz',");
                sql.append(sumQtyColumn).append(" FROM ").append(this.tempTable);
            } else {
                sql.append("INSERT INTO ").append(this.tempTable).append(" (").append(fld).append(",").append(qtyColumn).append(")");
                sql.append(" SELECT ' ").append(this.SubLabel).append("',");
                sql.append(sumQtyColumn).append(" FROM ").append(this.tempTable);
            }
            this.executeUpdate(sql.toString(), null, ctx);
        }
    }

    private int minLevel(Context ctx, RptParams params) throws BOSException, EASBizException {
        int minLevel = 0;
        String countSql = "SELECT max(Flevel) resultLevel FROM " + this.tempTable;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        if (rs.getObject(0) == null) {
            return 1;
        }
        int resultLevel = rs.getInt(0);
        int reqLevel = this.getLevel();
        minLevel = Math.min(resultLevel, reqLevel);
        return minLevel;
    }

    private String[] splitLongNumber(Context ctx, int level, RptParams params) {
        StringBuffer sql;
        int i;
        ArrayList<String> sqlList = new ArrayList<String>();
        for (i = 1; i <= level; ++i) {
            StringBuffer sql2;
            StringBuffer lenBuffer;
            String levelString = String.valueOf(i);
            StringBuffer sql3 = new StringBuffer();
            if (this.classficationType.equals((Object)SaleReportClassificationEnum.materialGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroupPerson) || this.classficationType.equals((Object)SaleReportClassificationEnum.materGroupPlusCustomer)) {
                sql3.append("update ").append(this.tempTable).append(" set FNumber_").append(levelString).append(" = FLongNumber ");
                sql3.append(" WHERE Flevel = ").append(levelString);
                sqlList.add(sql3.toString());
            } else {
                sql3.append("update ").append(this.tempTable).append(" set FNumber_").append(levelString).append(" = FGNumber ");
                sql3.append(" WHERE Flevel = ").append(levelString);
                sqlList.add(sql3.toString());
            }
            if (this.classficationType.equals((Object)SaleReportClassificationEnum.materialGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroupPerson) || this.classficationType.equals((Object)SaleReportClassificationEnum.materGroupPlusCustomer)) {
                if (i > level) continue;
                lenBuffer = new StringBuffer();
                if (i == 1) {
                    lenBuffer.append(i);
                } else {
                    lenBuffer.append("len(FNumber_");
                    lenBuffer.append(i - 1);
                    lenBuffer.append(") + 2 ");
                }
                sql2 = new StringBuffer();
                sql2.append("update ").append(this.tempTable);
                sql2.append(" set FNumber_").append(levelString).append("= substring(FLongNumber,1,charindex('!',FLongNumber,").append(lenBuffer).append(") -1)");
                sql2.append(" WHERE FLevel > ").append(levelString);
                sqlList.add(sql2.toString());
                continue;
            }
            if (i > level) continue;
            lenBuffer = new StringBuffer();
            for (int j = 1; j < i; ++j) {
                lenBuffer.append("len(FNumber_").append(String.valueOf(j)).append(") + ");
            }
            sql2 = new StringBuffer();
            sql2.append("update ").append(this.tempTable).append(" set FNumber_").append(levelString).append("= substring(FLongNumber,").append(lenBuffer).append(levelString).append(",charindex('!',FLongNumber,").append(lenBuffer).append(levelString).append(") - (").append(lenBuffer).append(levelString).append(")) WHERE FLevel > ").append(levelString);
            sqlList.add(sql2.toString());
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.materialGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroupPerson) || this.classficationType.equals((Object)SaleReportClassificationEnum.materGroupPlusCustomer)) {
            for (i = 1; i <= level; ++i) {
                sql = new StringBuffer();
                sql.append("update ").append(this.tempTable).append(" as t1 ");
                sql.append(" set (FNumber_" + String.valueOf(i)).append("Name) = ");
                sql.append("  (SELECT bb.FName_").append(this.locString).append(" FROM t_bd_materialgroup as bb,T_BD_MaterialGroupStandard s ");
                sql.append("    WHERE bb.FGroupStandard = s.FID AND t1.STDID = s.FID ");
                sql.append("      AND bb.fid = t1.fgid");
                sql.append("      AND t1.FNumber_").append(String.valueOf(i)).append(" = bb.FLongNumber ");
                sql.append("      AND t1.FLevel = ").append(String.valueOf(i));
                sql.append("      AND t1.FNumber_").append(String.valueOf(i)).append("Name IS NULL ").append(") ");
                sqlList.add(sql.toString());
                int count = 0;
                try {
                    count = this._getMaxLevel(ctx);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
                for (int j = i + 1; j <= count; ++j) {
                    StringBuffer sql1 = new StringBuffer();
                    sql1.append("update ").append(this.tempTable).append(" as t1 ");
                    sql1.append(" set (FNumber_" + String.valueOf(i)).append("Name) = ");
                    sql1.append(" (SELECT bb.FName_").append(this.locString).append(" FROM t_bd_materialgroup as bb,T_BD_MaterialGroupStandard s ");
                    sql1.append("   WHERE bb.FGroupStandard = s.FID ");
                    sql1.append("     AND t1.STDID = s.FID ");
                    sql1.append("     AND t1.FNumber_").append(String.valueOf(i)).append(" = bb.FLongNumber ");
                    sql1.append("     AND t1.FLevel = ").append(String.valueOf(j));
                    sql1.append("     AND t1.FNumber_").append(String.valueOf(i)).append("Name IS NULL GROUP BY t1.FGID").append(" , bb.FName_").append(this.locString).append(") ");
                    sql1.append("     WHERE t1.FLevel = ").append(String.valueOf(j));
                    sql1.append("     AND t1.FNumber_").append(String.valueOf(i)).append("Name IS NULL ");
                    sqlList.add(sql1.toString());
                }
            }
        } else {
            for (i = 1; i <= level; ++i) {
                sql = new StringBuffer();
                sql.append("update ").append(this.tempTable).append(" AS t1 ");
                sql.append(" set (FNumber_" + String.valueOf(i)).append("Name) = ");
                sql.append(" (SELECT bb.FName_").append(this.locString).append(" FROM T_BD_CSSPGroup as bb,T_BD_CSSPGroupStandard s ");
                sql.append("   WHERE bb.FCSSPGroupStandardID = s.FID AND t1.STDID = s.FID  ");
                sql.append("     AND t1.FNumber_").append(String.valueOf(i)).append(" = bb.FNumber ");
                sql.append("     AND bb.FLevel = ").append(String.valueOf(i));
                sql.append("     AND t1.FNumber_").append(String.valueOf(i)).append("Name IS NULL ").append(") ");
                sqlList.add(sql.toString());
            }
        }
        String[] sqls = sqlList.toArray(new String[sqlList.size()]);
        return sqls;
    }

    protected int _getMaxLevel(Context ctx) throws BOSException {
        String sqllen = null;
        sqllen = "SELECT MAX(FLevel) AS cc FROM  ";
        sqllen = sqllen + this.tempTable;
        RptRowSet rs = this.executeQuery(sqllen, null, ctx);
        int max = 0;
        if (rs.next() && rs.getObject(0) != null) {
            max = rs.getInt(0);
        }
        return max;
    }

    private String[] subTotal(String prefixFlds, String suffix, int level, boolean isIncludeStatUnit) {
        ArrayList<String> sqlList = new ArrayList<String>();
        StringBuffer totalSql = new StringBuffer();
        if (suffix != null) {
            ++level;
        }
        for (int i = 1; i < level; ++i) {
            int j;
            totalSql.setLength(0);
            totalSql.append("insert into ").append(this.tempTable).append(" (");
            if (prefixFlds != null) {
                totalSql.append(prefixFlds).append(",");
            }
            for (int i1 = 1; i1 <= i; ++i1) {
                totalSql.append("FNumber_").append(String.valueOf(i1)).append(",").append("FNumber_").append(String.valueOf(i1)).append("Name,");
                if (i1 == i && i == level - 1 && suffix != null) {
                    if (this.classficationType.equals((Object)SaleReportClassificationEnum.materGroupPlusCustomer)) {
                        totalSql.append("fcustomerNumber").append(",");
                        continue;
                    }
                    if (!this.classficationType.equals((Object)SaleReportClassificationEnum.custGroupPlusMaterial)) continue;
                    totalSql.append("fmaterialNum").append(",");
                    continue;
                }
                if (i1 != i) continue;
                totalSql.append("FNumber_").append(String.valueOf(i + 1)).append("Name,");
            }
            if (isIncludeStatUnit) {
                totalSql.append("saleQty,outQty,saleCost,totalSaleFee,saleAmount,statSaleQty,statOutQty) ");
            } else {
                totalSql.append("saleQty,outQty,saleCost,totalSaleFee,saleAmount) ");
            }
            totalSql.append(" SELECT ");
            if (prefixFlds != null) {
                totalSql.append(prefixFlds).append(",");
            }
            for (j = 1; j <= i; ++j) {
                totalSql.append("FNumber_").append(String.valueOf(j)).append(",FNumber_").append(String.valueOf(j)).append("Name,");
                if (j == i && i == level - 1 && suffix != null) {
                    totalSql.append("' ").append(this.SubLabel).append("',");
                    continue;
                }
                if (j != i) continue;
                totalSql.append("' ").append(this.SubLabel).append("',");
            }
            if (isIncludeStatUnit) {
                totalSql.append("sum(saleQty),sum(outQty),sum(saleCost),sum(totalSaleFee),sum(saleAmount),sum(statSaleQty),sum(statOutQty) ");
            } else {
                totalSql.append("sum(saleQty),sum(outQty),sum(saleCost),sum(totalSaleFee),sum(saleAmount) ");
            }
            totalSql.append(" FROM ").append(this.tempTable).append(" WHERE FGID IS NOT NULL AND flevel >= ").append(String.valueOf(i)).append(" group by ");
            if (prefixFlds != null) {
                totalSql.append(prefixFlds).append(",");
            }
            if (isIncludeStatUnit) {
                // empty if block
            }
            for (j = 1; j < i; ++j) {
                totalSql.append("FNumber_").append(String.valueOf(j)).append(",").append("FNumber_").append(String.valueOf(j)).append("Name, ");
            }
            totalSql.append("FNumber_").append(String.valueOf(i)).append(",").append("FNumber_").append(String.valueOf(i)).append("Name ");
            sqlList.add(totalSql.toString());
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustGroup)) {
            sqlList.add(" update " + this.tempTable + " set fmaterialid = null where FGID IS NULL ");
        }
        sqlList.add(this.getDetailDataSql(prefixFlds, suffix, level, isIncludeStatUnit));
        String[] sqlSubtotals = sqlList.toArray(new String[sqlList.size()]);
        return sqlSubtotals;
    }

    private String getDetailDataSql(String prefixFlds, String suffix, int level, boolean isIncludeStatUnit) {
        int j;
        StringBuffer totalSql = new StringBuffer();
        if (suffix != null) {
            --level;
        }
        totalSql.append("insert into ").append(this.tempTable).append(" (");
        if (prefixFlds != null) {
            totalSql.append(prefixFlds).append(",");
        }
        for (int i1 = 1; i1 <= level; ++i1) {
            totalSql.append("FNumber_").append(String.valueOf(i1)).append(",").append("FNumber_").append(String.valueOf(i1)).append("Name,");
        }
        if (suffix != null) {
            totalSql.append(suffix).append(",");
        }
        if (isIncludeStatUnit) {
            totalSql.append("statUnitName,FBaseConvsRate,");
            totalSql.append("saleQty,outQty,saleCost,totalSaleFee,saleAmount,statSaleQty,statOutQty) ");
        } else {
            totalSql.append("saleQty,outQty,saleCost,totalSaleFee,saleAmount) ");
        }
        totalSql.append(" SELECT ");
        if (prefixFlds != null) {
            totalSql.append(prefixFlds).append(",");
        }
        for (j = 1; j <= level; ++j) {
            totalSql.append("FNumber_").append(String.valueOf(j)).append(",FNumber_").append(String.valueOf(j)).append("Name,");
        }
        if (suffix != null) {
            totalSql.append(suffix).append(",");
        }
        if (isIncludeStatUnit) {
            totalSql.append("statUnitName,FBaseConvsRate,");
            totalSql.append("sum(saleQty),sum(outQty),sum(saleCost),sum(totalSaleFee),sum(saleAmount),sum(statSaleQty),sum(statOutQty) ");
        } else {
            totalSql.append("sum(saleQty),sum(outQty),sum(saleCost),sum(totalSaleFee),sum(saleAmount) ");
        }
        totalSql.append(" FROM ").append(this.tempTable).append(" WHERE FGID IS NOT NULL ");
        totalSql.append(" group by ");
        if (prefixFlds != null) {
            totalSql.append(prefixFlds).append(",");
        }
        if (isIncludeStatUnit) {
            totalSql.append("statUnitName,FBaseConvsRate,");
        }
        for (j = 1; j < level; ++j) {
            totalSql.append("FNumber_").append(String.valueOf(j)).append(",").append("FNumber_").append(String.valueOf(j)).append("Name, ");
        }
        totalSql.append("FNumber_").append(String.valueOf(level)).append(",").append("FNumber_").append(String.valueOf(level)).append("Name ");
        if (suffix != null) {
            totalSql.append(",").append(suffix);
        }
        return totalSql.toString();
    }

    @Override
    protected int _getMaxCustomerLevel(Context ctx) throws BOSException {
        String sql = "SELECT max(flevel) cc FROM t_bd_csspgroup  ";
        RptRowSet rs = this.executeQuery(sql, null, ctx);
        int max = 1;
        if (rs.next() && rs.getObject(0) != null) {
            max = rs.getInt(0);
        }
        return max;
    }

    @Override
    protected int _getMaxMaterialLevel(Context ctx) throws BOSException {
        String sql = "SELECT max(flevel) cc FROM t_bd_materialgroup ";
        RptRowSet rs = this.executeQuery(sql, null, ctx);
        int max = 1;
        if (rs.next() && rs.getObject(0) != null) {
            max = rs.getInt(0);
        }
        return max;
    }

    protected String getOrgIds(Object[] infos) {
        StringBuffer OrgunitId = new StringBuffer();
        if (infos != null && infos.length > 0) {
            int n = infos.length;
            for (int i = 0; i < n; ++i) {
                Boolean isleaf = (Boolean)((FullOrgUnitInfo)infos[i]).get("isleaf");
                boolean fisleaf = isleaf != false;
                if (!fisleaf) continue;
                OrgunitId.append("'" + ((FullOrgUnitInfo)infos[i]).getId().toString() + "',");
            }
        }
        OrgunitId.append("'XXXX_XXXX'");
        return OrgunitId.toString();
    }

    @Override
    protected int[] _getMaxLevels(Context ctx) throws BOSException {
        int[] levels = new int[]{this._getMaxCustomerLevel(ctx), this._getMaxMaterialLevel(ctx)};
        return levels;
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)ResClassName, (String)key, (Context)ctx);
    }

    private void buildSelectPartNull(QuerySql querySql) {
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.material) || this.classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.custGroupPlusMaterial) || this.classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustomer) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusmaterial) || this.classficationType.equals((Object)SaleReportClassificationEnum.departmentplusmaterial) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroupPerson) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterPerson) || this.classficationType.equals((Object)SaleReportClassificationEnum.saleOrgPlusCustomerPlusMaterial)) {
            querySql.selectPart.append(" case when ar_entry.fmaterialID is not null then material.fid else ei.FID end AS fmaterialid,").append(" case when ar_entry.fmaterialID is not null then material.Fnumber else ei.Fnumber end AS fmaterialNum,").append(" case when ar_entry.fmaterialID is not null then ").append(" material.fname_").append(this.locString).append(" else ei.FName_").append(this.locString).append(" end AS fmaterialName,").append(" case when ar_entry.fmaterialID is not null then material.fshortname else  ei.FName_").append(this.locString).append(" end as fmaterialShortName, ");
            if (this.isAssistSum) {
                querySql.selectPart.append(" material.Fmodel,assistProperty.FName_").append(this.locString).append(" AS FassistPropertyName,mmUnit.FQtyPrecision,").append(this.sp);
            } else {
                querySql.selectPart.append(" material.Fmodel,mmUnit.FQtyPrecision,").append(this.sp);
            }
            querySql.selectPart.append(" case when ar_entry.fmaterialID is not null then baseUnit.fname_").append(this.locString).append(" else unit.FName_").append(this.locString).append(" end AS baseUnitName,");
            if (this.isAssistSum) {
                querySql.otherPart1.append("fmaterialid,fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,");
                querySql.otherPartAlias1.append("fmaterialid,max(fmaterialNum) fmaterialNum,max(fmaterialName) fmaterialName,max(fmaterialShortName) fmaterialShortName,max(Fmodel) Fmodel,FassistPropertyName,FQtyPrecision,max(baseUnitName) baseUnitName,");
                querySql.groupPart.append("fmaterialid,FassistPropertyName,FQtyPrecision,");
            } else {
                querySql.otherPart1.append("fmaterialid,fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,");
                querySql.otherPartAlias1.append("fmaterialid,max(fmaterialNum) fmaterialNum,max(fmaterialName) fmaterialName,max(fmaterialShortName) fmaterialShortName,max(Fmodel) Fmodel,FQtyPrecision,max(baseUnitName) baseUnitName,");
                querySql.groupPart.append("fmaterialid,FQtyPrecision,");
            }
            querySql.selectPart.append(" case when ar_entry.fmaterialID is not null then baseUnit.fname_").append(this.locString);
            querySql.selectPart.append(" else unit.FName_").append(this.locString).append(" end AS statUnitName,-1.0 as FBaseConvsRate,");
            querySql.otherPart1.append(" statUnitName, to_decimal(FBaseConvsRate,21,8) FBaseConvsRate, ");
            querySql.otherPartAlias1.append(" max(statUnitName) statUnitName, to_decimal(FBaseConvsRate,21,8) FBaseConvsRate, ");
            querySql.groupPart.append("FBaseConvsRate, ");
            this.appendTable(querySql, "t_bd_material");
            this.appendTable(querySql, "T_SCM_ExpenseItem");
            this.appendTable(querySql, "T_BD_MultiMeasureUnitNull");
            this.appendTable(querySql, "T_BD_AsstAttrValue");
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.customer) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.materGroupPlusCustomer) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusmaterial) || this.classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustomer) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterPerson) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroupPerson) || this.classficationType.equals((Object)SaleReportClassificationEnum.saleOrgPlusCustomerPlusMaterial)) {
            querySql.selectPart.append(" customer.Fid fcustomerid,customer.Fnumber fcustomerNumber,customer.FName_").append(this.locString).append(" as fcustomerName,").append(this.sp);
            querySql.otherPart1.append("fcustomerid,fcustomerNumber,fcustomerName,");
            querySql.otherPartAlias1.append("fcustomerid,max(fcustomerNumber) fcustomerNumber,max(fcustomerName) fcustomerName,");
            querySql.groupPart.append("fcustomerid,");
            this.appendTable(querySql, "t_bd_customer");
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.materialGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.materGroupPlusCustomer) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroupPerson) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroup)) {
            querySql.selectPart.append("mg.FGroupStandard STDID,mg.Fid FGID,mg.FLevel,mg.FLongNumber,mg.FNumber FGNumber,").append(this.sp);
            querySql.otherPart1.append("STDID,FGID,FLevel,FLongNumber,FGNumber,");
            querySql.otherPartAlias1.append("max(STDID) STDID,FGID,max(FLevel) FLevel,max(FLongNumber) FLongNumber,max(FGNumber) FGNumber,");
            querySql.groupPart.append("FGID,");
            this.appendTable(querySql, "t_bd_material");
            this.appendTable(querySql, "t_bd_MaterialGroupDetial");
            this.appendTable(querySql, "t_bd_materialgroup");
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.customerGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.custGroupPlusMaterial)) {
            querySql.selectPart.append(" cbg.FCSSPGroupStandardID STDID,cbg.Fid FGID,cbg.FLevel,cbg.FLongNumber,cbg.FNumber FGNumber,").append(this.sp);
            querySql.otherPart1.append("STDID,FGID,FLevel,FLongNumber,FGNumber,");
            querySql.otherPartAlias1.append("max(STDID) STDID,FGID,max(FLevel) FLevel,max(FLongNumber) FLongNumber,max(FGNumber) FGNumber,");
            querySql.groupPart.append("FGID,");
            this.appendTable(querySql, "t_bd_customer");
            this.appendTable(querySql, "t_bd_csspgroup");
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.saleorder)) {
            if (querySql.aliasName.equalsIgnoreCase("SALEISSUE")) {
                querySql.selectPart.append(" im_entry1.FSaleOrderNumber fsoNumber,");
                querySql.wherePart.append(" AND im_entry1.FCoreBillTypeID = '").append("510b6503-0105-1000-e000-0113c0a812fd463ED552").append("' ").append(this.sp);
            } else if (querySql.aliasName.equalsIgnoreCase("AP")) {
                querySql.selectPart.append(" ap_entry1.FCoreBillNumber  fsoNumber,");
                querySql.wherePart.append(" AND ap_entry1.FCoreBillTypeID = '").append("510b6503-0105-1000-e000-0113c0a812fd463ED552").append("' ").append(this.sp);
            } else if (querySql.aliasName.equalsIgnoreCase("AR")) {
                querySql.selectPart.append(" ar_entry.FCoreBillNumber  fsoNumber,");
                querySql.wherePart.append(" AND ar_entry.FCoreBillTypeID = '").append("510b6503-0105-1000-e000-0113c0a812fd463ED552").append("' ").append(this.sp);
            }
            querySql.otherPart1.append(" fsoNumber,");
            querySql.otherPartAlias1.append(" fsoNumber,");
            querySql.groupPart.append("fsoNumber,");
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.salecontract)) {
            querySql.otherPart1.append(" fscNumber,");
            querySql.otherPartAlias1.append(" fscNumber,");
            querySql.groupPart.append("fscNumber,");
            querySql.selectPart.append(" soEntry.FSourceBillNumber fscNumber,");
            querySql.tables.add("T_SD_SaleOrderEntry");
            if (querySql.aliasName.equalsIgnoreCase("SALEISSUE")) {
                querySql.wherePart.append(" AND im_entry1.FCoreBillTypeID = '").append("510b6503-0105-1000-e000-0113c0a812fd463ED552").append("' ").append(this.sp);
                querySql.fromPart.append(" INNER JOIN T_SD_SaleOrderEntry soEntry ON im_entry1.FSaleOrderEntryID = soEntry.FID ").append(this.sp);
            } else if (querySql.aliasName.equalsIgnoreCase("AP")) {
                querySql.wherePart.append(" AND ap_entry1.FCoreBillTypeID = '").append("510b6503-0105-1000-e000-0113c0a812fd463ED552").append("' ").append(this.sp);
                querySql.fromPart.append(" INNER JOIN T_SM_PurOrderEntry soEntry ON ap_entry1.FCoreBillEntryId = soEntry.FID ").append(this.sp);
            } else if (querySql.aliasName.equalsIgnoreCase("AR")) {
                querySql.wherePart.append(" AND ar_entry.FCoreBillTypeID = '").append("510b6503-0105-1000-e000-0113c0a812fd463ED552").append("' ").append(this.sp);
                querySql.fromPart.append(" INNER JOIN T_SD_SaleOrderEntry soEntry ON ar_entry.FCoreBillEntryId = soEntry.FID ").append(this.sp);
            }
            querySql.wherePart.append(" AND soEntry.FSourceBillTypeID = '").append("DEZBNUYZRM6ieHZ5GGlRc0Y+1VI=").append("' ").append(this.sp);
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.departmentplusmaterial)) {
            querySql.selectPart.append("adminunit.fid fadminunitid,adminunit.FName_").append(this.locString).append(" as fadminunitName,").append(this.sp);
            querySql.otherPart1.append("fadminunitid,fadminunitName,");
            querySql.otherPartAlias1.append("fadminunitid,max(fadminunitName) fadminunitName,");
            querySql.otherPart1.append("fadminunitid,");
            this.appendTable(querySql, "T_ORG_Admin");
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterPerson) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroupPerson)) {
            querySql.selectPart.append("salePerson.fid fSalePersonid");
            querySql.selectPart.append(",salePerson.FNumber fSalePersonNum");
            querySql.selectPart.append(",salePerson.FName_").append(this.locString).append(" as fSalePersonName,").append(this.sp);
            querySql.otherPart1.append("fSalepersonid,fSalePersonNum,fSalePersonName,");
            querySql.otherPart1.append("fSalepersonid,max(fSalePersonNum) fSalePersonNum,max(fSalePersonName) fSalePersonName,");
            querySql.groupPart.append("fSalepersonid,");
            this.appendTable(querySql, "T_BD_Person");
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.saleOrgPlusCustomerPlusMaterial)) {
            querySql.selectPart.append("saleOrg.fid fSaleOrgId");
            querySql.selectPart.append(",saleOrg.FNumber fSaleOrgNum");
            querySql.selectPart.append(",saleOrg.FName_").append(this.locString).append(" as fSaleOrgName,").append(this.sp);
            querySql.otherPart1.append("fSaleOrgId,fSaleOrgNum,fSaleOrgName,");
            querySql.otherPartAlias1.append("fSaleOrgId,max(fSaleOrgNum) fSaleOrgNum,max(fSaleOrgName) fSaleOrgName,");
            querySql.groupPart.append("fSaleOrgId,");
            this.appendTable(querySql, "t_org_baseUnit");
        }
        if (this.tempColsForSelect == null) {
            this.tempColsForSelect = querySql.otherPart1.toString().substring(0, querySql.otherPart1.lastIndexOf(","));
        }
        if (this.tempColsForGroup == null) {
            this.tempColsForGroup = querySql.otherPartAlias1.toString().substring(0, querySql.otherPartAlias1.lastIndexOf(","));
        }
        if (this.groupCols == null) {
            this.groupCols = querySql.groupPart.toString().substring(0, querySql.groupPart.lastIndexOf(","));
        }
        querySql.groupPart.setLength(0);
    }

    protected boolean isUseRWSplit() {
        return true;
    }

    private RptRowSet totalGroupData(Context ctx, String fld) throws BOSException, EASBizException {
        StringBuffer selectCol = new StringBuffer();
        selectCol.append("fid id,");
        if (this.params.getBoolean("AuxiliaryProperties")) {
            this.isAssistSum = true;
        }
        StringBuffer selectTotalColBuff = new StringBuffer();
        for (int i = 1; i <= this.minLevel; ++i) {
            selectTotalColBuff.append("FNumber_").append(String.valueOf(i)).append("Name,");
        }
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustGroup)) {
            if (this.isAssistSum) {
                selectCol.append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,").append(selectTotalColBuff);
            } else {
                selectCol.append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,").append(selectTotalColBuff);
            }
        } else if (this.classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustomer)) {
            if (this.isAssistSum) {
                selectCol.append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,");
                selectCol.append("fcustomerNumber,fcustomerName,");
            } else {
                selectCol.append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,");
                selectCol.append("fcustomerNumber,fcustomerName,");
            }
        } else if (this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusmaterial)) {
            if (this.isAssistSum) {
                selectCol.append("fcustomerNumber,fcustomerName,");
                selectCol.append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,");
            } else {
                selectCol.append("fcustomerNumber,fcustomerName,").append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,");
            }
        } else if (this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroup)) {
            selectCol.append("fcustomerNumber,fcustomerName,").append(this.defaultPre).append(" FQtyPrecision,").append(selectTotalColBuff);
        } else if (this.classficationType.equals((Object)SaleReportClassificationEnum.custGroupPlusMaterial)) {
            if (this.isAssistSum) {
                selectCol.append(selectTotalColBuff).append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,");
            } else {
                selectCol.append(selectTotalColBuff).append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,");
            }
        } else if (this.classficationType.equals((Object)SaleReportClassificationEnum.materGroupPlusCustomer)) {
            selectCol.append(selectTotalColBuff).append("fcustomerNumber,fcustomerName,").append(this.defaultPre).append(" FQtyPrecision,");
        } else if (this.classficationType.equals((Object)SaleReportClassificationEnum.departmentplusmaterial)) {
            if (this.isAssistSum) {
                selectCol.append("fadminunitName,fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,");
            } else {
                selectCol.append("fadminunitName,fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,");
            }
        } else if (this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroupPerson)) {
            selectCol.append("fsalePersonNum,fSalePersonName,fcustomerNumber,fcustomerName,").append(this.defaultPre).append(" FQtyPrecision,").append(selectTotalColBuff);
        } else if (this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterPerson)) {
            if (this.isAssistSum) {
                selectCol.append("fsalePersonNum,fSalePersonName,fcustomerNumber,fcustomerName,");
                selectCol.append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,");
            } else {
                selectCol.append("fsalePersonNum,fSalePersonName,fcustomerNumber,fcustomerName,");
                selectCol.append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,");
            }
        }
        StringBuffer totalSql = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        StringBuffer deleteSql = new StringBuffer();
        RptRowSet totalRs = null;
        int qtyPrecision1 = Integer.valueOf(this.params.getObject("spnPrecision").toString());
        int amountPrecision1 = Integer.valueOf(this.params.getObject("amountPrecision1").toString());
        int qtyPrecision2 = Integer.valueOf(this.params.getObject("qtyPrecision").toString());
        int amountPrecision2 = Integer.valueOf(this.params.getObject("amountPrecision2").toString());
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroup)) {
            totalSql.append("insert into ").append(this.tempTable).append(" (").append("FCUSTOMERID,");
            sql.append(" else to_decimal((saleAmount - saleCost - totalSaleFee)/saleAmount*100,31,8) end END  where FCUSTOMERID='total' ");
            deleteSql.append(" delete ");
            deleteSql.append(" FROM ").append(this.tempTable).append(this.sp);
            deleteSql.append(" where FCUSTOMERID='total'");
        } else {
            totalSql.append("insert into ").append(this.tempTable).append(" (").append("Fmaterialid,");
            sql.append(" else to_decimal((saleAmount - saleCost - totalSaleFee)/saleAmount*100,31,8) end END  where Fmaterialid='total' ");
            deleteSql.append(" delete ");
            deleteSql.append(" FROM ").append(this.tempTable).append(this.sp);
            deleteSql.append(" where Fmaterialid='total'");
        }
        totalSql.append("saleQty,outQty,saleCost,totalSaleFee,saleAmount,statSaleQty, statOutQty) ").append(this.sp);
        totalSql.append(" SELECT 'total',");
        totalSql.append("sum(saleQty),sum(outQty),sum(saleCost),sum(totalSaleFee),sum(saleAmount) ").append(this.sp);
        totalSql.append(",sum(statSaleQty),sum(statOutQty)");
        totalSql.append(" FROM ").append(this.tempTable).append(this.sp);
        totalSql.append(" where ").append(fld).append("=' ").append(this.SubLabel).append("'");
        this.executeUpdate(totalSql.toString(), null, ctx);
        totalSql.setLength(0);
        totalSql.append(" update ").append(this.tempTable);
        totalSql.append(" set profit = saleAmount - saleCost  - totalSaleFee,");
        totalSql.append(" profitRate= Case When saleAmount = 0 Then 0.00 ");
        totalSql.append(" Else case when (saleAmount - saleCost  - totalSaleFee) < 0 and saleAmount < 0 then -1*to_decimal((saleAmount - saleCost  - totalSaleFee)/saleAmount*100,31,8) ");
        totalSql.append(sql.toString());
        this.executeUpdate(totalSql.toString(), null, ctx);
        totalSql.setLength(0);
        if (this.classficationType.equals((Object)SaleReportClassificationEnum.material) || this.classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustGroup) || this.classficationType.equals((Object)SaleReportClassificationEnum.custGroupPlusMaterial) || this.classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustomer) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusmaterial) || this.classficationType.equals((Object)SaleReportClassificationEnum.departmentplusmaterial) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroupPerson) || this.classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterPerson)) {
            totalSql.append("SELECT ").append(selectCol);
            totalSql.append("round(saleQty," + qtyPrecision2 + ") saleQty,");
            totalSql.append("round(outQty," + qtyPrecision2 + ") outQty, ");
            totalSql.append("statUnitName, ");
            totalSql.append("round(statSaleQty," + qtyPrecision2 + ") statSaleQty, ");
            totalSql.append("round(statOutQty," + qtyPrecision2 + ") statOutQty,");
            totalSql.append("round(saleAmount," + amountPrecision2 + ") saleAmount,");
            totalSql.append("round(saleCost," + amountPrecision2 + ") saleCost,");
            totalSql.append("round(totalSaleFee," + amountPrecision2 + ") totalSaleFee,");
            totalSql.append("round(profit," + amountPrecision2 + ") profit,");
            totalSql.append("round(profitRate,2) profitRate,");
            totalSql.append("round(unitProfit," + amountPrecision2 + ") unitProfit,");
            totalSql.append("round(statProfit," + amountPrecision2 + ") statProfit");
            totalSql.append(" FROM ").append(this.tempTable).append(" where Fmaterialid='total' ");
        } else {
            totalSql.append("SELECT ").append(selectCol);
            totalSql.append("round(saleQty," + qtyPrecision1 + ") saleQty,");
            totalSql.append("round(outQty," + qtyPrecision1 + ") outQty,");
            totalSql.append("round(saleAmount," + amountPrecision1 + ") saleAmount,");
            totalSql.append("round(saleCost," + amountPrecision1 + ") saleCost,");
            totalSql.append("round(totalSaleFee," + amountPrecision1 + ") totalSaleFee,");
            totalSql.append("round(profit," + amountPrecision1 + ") profit,");
            totalSql.append("round(profitRate,2) profitRate FROM ").append(this.tempTable).append(" where FCUSTOMERID='total' ");
        }
        totalRs = this.executeQuery(totalSql.toString(), null, ctx);
        this.executeUpdate(deleteSql.toString(), null, ctx);
        return totalRs;
    }

    static class QuerySql {
        StringBuffer selectPart = new StringBuffer();
        StringBuffer fromPart = new StringBuffer();
        StringBuffer wherePart = new StringBuffer();
        StringBuffer groupPart = new StringBuffer();
        StringBuffer otherPart1 = new StringBuffer();
        StringBuffer otherPartAlias1 = new StringBuffer();
        int unionCount = 0;
        Set tables = new HashSet();
        String aliasName = "";

        QuerySql() {
        }

        String getSql() {
            StringBuffer sql = new StringBuffer();
            for (int i = 0; i <= this.unionCount; ++i) {
                if (i > 0) {
                    sql.append(" union all ");
                }
                sql.append(this.selectPart.toString()).append(this.fromPart.toString()).append(this.wherePart.toString()).append(this.groupPart.toString());
            }
            return sql.toString();
        }
    }
}

