/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.util;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.client.SCMBillEditUI;
import com.kingdee.eas.scm.sd.sale.client.SaleOrderEditUI;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DistributeNodeList {
    private static final String TB_ID = "id";
    private static final String TB_MATERIAL = "material";
    private static final String TB_MATERIALNAME = "materialName";
    private static final String TB_MATERIALSIZE = "size";
    private static final String TB_UNIT = "unit";
    private static final String TB_DISCOUNTCOND = "discountCondition";
    public static final String TB_TOTALINVOICEAMT = "totalInvoiceAmt";
    public static final String TB_TOTALARAMOUNT = "totalArAmount";
    private static final String TB_TOTALRECEIVEDAMOUNT = "totalReceivedAmount";
    private static final String TB_PRERECEIVED = "preReceived";
    private static final String TB_UNPRERECEIVEDAMOUNT = "unPrereceivedAmount";
    private static final String TB_PREPAYMENT = "prepayment";
    private static final String TB_ORDEREDQTY = "orderedQty";
    private static final String TB_TOTALISSUEQTY = "totalIssueQty";
    public static final String TB_TOTALCANCELLINGSTOCKQTY = "totalCancellingStockQty";
    private static final String TB_TOTALINVOICEDQTY = "totalInvoicedQty";
    private static final String TB_TOTALRETURNEDQTY = "totalReturnedQty";
    private static final String TB_TOTALSHIPPINGQTY = "totalShippingQty";
    private static final String TB_TOTALTRANSFERQTY = "totalTransferQty";
    private static final String TB_TOTALTRANSFERBASEQTY = "totalTransferBaseQty";
    private static final String TB_TOTALUNTRANSFERQTY = "totalUnTransferQty";
    private static final String TB_TOTALUNTRANSFERBASEQTY = "totalUnTransferBaseQty";
    private static final String TB_QTY = "qty";
    private static final String TB_STORAGEORGUNIT = "storageOrgUnit";
    private static final String TB_PROSTORAGEORGUNIT = "proStorageOrgUnit";
    private static final String TB_WAREHOUSE = "warehouse";
    private static final String TB_DELIVERYDATE = "deliveryDate";
    private static final String TB_SENDDATE = "sendDate";
    private static final String TB_TAXAMOUNT = "taxAmount";
    public static final String TB_REMARK = "remark";
    public static final String IF_SUBMIT = "is_submit";
    private static final String TB_ISPRESENT = "isPresent";
    KDTable table = null;
    protected SCMBillEditUI editUi;
    BigDecimal ZERO = new BigDecimal("0.00");
    private Map errors = new HashMap();
    private boolean isAutoCal = false;
    private boolean isDistribute = false;
    private Map rowIndexMap = new HashMap();
    private List parentList;
    Node header;

    public DistributeNodeList(KDTable table, SCMBillEditUI editUi, boolean isDistribute) {
        this.table = table;
        this.editUi = editUi;
        this.isDistribute = isDistribute;
        this.distributeInitialize();
    }

    public void distributeInitialize() {
        if (this.isDistribute) {
            this.parentList = new ArrayList();
            this.initParentList();
            this.lockTableColWhenDistribute();
            this.initParentLinkNode();
            this.hideEditUITool();
            this.initErrorsMap();
        }
    }

    private void initErrorsMap() {
        this.errors.put(TB_QTY, SaleUtil.getUIResource("QTY_NOT_EQUAL_ORIGINAL"));
        this.errors.put(TB_TAXAMOUNT, SaleUtil.getUIResource("TAXAMOUNT_NOT_EQUAL_ORIGINAL"));
        this.errors.put(TB_PREPAYMENT, SaleUtil.getUIResource("PREPAYMENT_NOT_EQUAL_ORIGINAL"));
        this.errors.put(IF_SUBMIT, SaleUtil.getUIResource("ASK_IF_SUBMIT_WHEN_DISTRIBUTE"));
    }

    private void hideEditUITool() {
        if (this.editUi instanceof SaleOrderEditUI) {
            ((SaleOrderEditUI)this.editUi).handleDistributeFieldVisible();
        }
    }

    private void initParentList() {
        Node node = null;
        SCMBillEntryBaseInfo info = null;
        HashSet rowIndexSet = null;
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            info = (SCMBillEntryBaseInfo)this.table.getRow(i).getUserObject();
            rowIndexSet = new HashSet();
            this.rowIndexMap.put(info.getId().toString(), rowIndexSet);
            node = new Node(info);
            node.setQty(this.getBigDecimalValueFromTable(i, TB_QTY));
            node.setTaxAmount(this.getBigDecimalValueFromTable(i, TB_TAXAMOUNT));
            node.setPrepayment(this.getBigDecimalValueFromTable(i, TB_PREPAYMENT));
            this.parentList.add(node);
        }
    }

    private void initParentLinkNode() {
        Node pNode2 = null;
        for (Node pNode2 : this.parentList) {
            if (this.isEmpty()) {
                this.header = pNode2;
                continue;
            }
            this.getLastNode().next = pNode2;
        }
    }

    private Node findParentNodeFromParentList(SCMBillEntryBaseInfo pinfo) {
        Node node2 = null;
        for (Node node2 : this.parentList) {
            if (node2.info.getId().toString().equals(pinfo.getId().toString())) {
                return node2;
            }
            node2 = null;
        }
        return node2;
    }

    public boolean checkIsInParentList(Integer[] rows) {
        boolean ifCanDel = true;
        int rowIndex = 0;
        SCMBillEntryBaseInfo delInfo = null;
        SCMBillEntryBaseInfo tempInfo = null;
        BigDecimal qty = this.ZERO;
        for (int j = 0; j < rows.length; ++j) {
            rowIndex = rows[j];
            qty = this.getBigDecimalValueFromTable(rowIndex, TB_QTY);
            delInfo = (SCMBillEntryBaseInfo)this.table.getRow(rowIndex).getUserObject();
            Iterator it = this.parentList.iterator();
            while (it.hasNext()) {
                tempInfo = ((Node)it.next()).info;
                if (!delInfo.getId().toString().equals(tempInfo.getId().toString())) continue;
                MsgBox.showWarning((String)SaleUtil.getUIResource("ONLY_CAN_DEL_SPLIT_LINE"));
                return false;
            }
        }
        return ifCanDel;
    }

    public void removeNode(int rowIndex) {
        if (!this.isDistribute) {
            return;
        }
        if (this.isAutoCal) {
            this.autoCalWhenRemoveNode(rowIndex);
        } else {
            this.unAutoCalWhenRemoveNode(rowIndex);
        }
        this.lockTableColWhenDistribute();
    }

    private void unAutoCalWhenRemoveNode(int rowIndex) {
        SCMBillEntryBaseInfo delInfo = (SCMBillEntryBaseInfo)this.table.getRow(rowIndex).getUserObject();
        Node cnode = this.findNode(delInfo.getId().toString());
        Node pnode = cnode.parent;
        pnode.removeChild(cnode);
    }

    private void autoCalWhenRemoveNode(int rowIndex) {
        SCMBillEntryBaseInfo delInfo = null;
        Node pnode = null;
        Node cnode = null;
        BigDecimal cqty = this.ZERO;
        BigDecimal pqty = this.ZERO;
        delInfo = (SCMBillEntryBaseInfo)this.table.getRow(rowIndex).getUserObject();
        cnode = this.findNode(delInfo.getId().toString());
        pnode = cnode.parent;
        pqty = this.getBigDecimalValueFromTable(this.findRowByNode(pnode).getRowIndex(), TB_QTY);
        cqty = this.getBigDecimalValueFromTable(this.findRowByNode(cnode).getRowIndex(), TB_QTY);
        this.setBigDecimalValueIntoTable(this.findRowByNode(pnode).getRowIndex(), TB_QTY, pqty.add(cqty));
    }

    public boolean checkChildFiledValueSumEqualsPFieldValue(String[] fieldNames) {
        boolean result = true;
        for (int i = 0; i < fieldNames.length && (result = this.checkFieldValueEquals(fieldNames[i])); ++i) {
        }
        return result;
    }

    public void fieldChanged(int rowIndex, String fieldName) {
        if (!this.isDistribute) {
            return;
        }
        String id = this.table.getRow(rowIndex).getCell(TB_ID).getValue().toString();
        Node node = this.findNode(id);
        Node pNode = null;
        pNode = node.isChildNode() ? node.parent : node;
        BigDecimal childSum = this.getAllHisChildValueSum(pNode, fieldName);
        BigDecimal parentValue = this.getBigDecimalValueFromTable(this.findRowByNode(pNode).getRowIndex(), fieldName);
        BigDecimal parentOriginalValue = pNode.getValue(fieldName);
        BigDecimal currValue = this.getBigDecimalValueFromTable(rowIndex, fieldName);
        BigDecimal diff = this.ZERO;
        diff = parentOriginalValue.subtract(childSum.add(parentValue));
        this.setBigDecimalValueIntoTable(rowIndex, fieldName, currValue.add(diff));
    }

    private boolean checkFieldValueEquals(String fieldName) {
        int yOrNo;
        Node pNode2 = null;
        boolean flag = true;
        BigDecimal curRowValue = this.ZERO;
        IRow row = null;
        BigDecimal allChildSum = this.ZERO;
        for (Node pNode2 : this.parentList) {
            row = this.findRowByNode(pNode2);
            curRowValue = this.getBigDecimalValueFromTable(row.getRowIndex(), fieldName);
            allChildSum = this.getAllHisChildValueSum(pNode2, fieldName).add(curRowValue);
            if (pNode2.getValue(fieldName).compareTo(allChildSum) == 0) continue;
            flag = false;
            break;
        }
        if (!flag && fieldName.equals(TB_QTY)) {
            MsgBox.showWarning((String)this.makeNotValidErrorMsg(pNode2, fieldName));
        } else if (!flag && (fieldName.equals(TB_TAXAMOUNT) || fieldName.equals(TB_PREPAYMENT)) && (yOrNo = MsgBox.showConfirm2((String)(this.makeNotValidErrorMsg(pNode2, fieldName) + " , " + this.errors.get(IF_SUBMIT)))) == 0) {
            flag = true;
        }
        return flag;
    }

    private String makeNotValidErrorMsg(Node pNode, String fieldName) {
        if (pNode == null) {
            return "";
        }
        StringBuffer errorMsg = new StringBuffer("[");
        HashSet rowIndexSet = (HashSet)this.rowIndexMap.get(pNode.getID());
        Object[] rowIndexs = rowIndexSet.toArray(new Integer[rowIndexSet.size()]);
        Arrays.sort(rowIndexs);
        Object rowIndex = null;
        for (int i = 0; i < rowIndexs.length; ++i) {
            rowIndex = rowIndexs[i];
            errorMsg.append((Integer)rowIndex + 1);
            if (i == rowIndexs.length - 1) continue;
            errorMsg.append(",");
        }
        errorMsg.append("]");
        errorMsg.append(this.errors.get(fieldName).toString()).append(pNode.getValue(fieldName).toString());
        return errorMsg.toString();
    }

    public HashMap getBotpRelationMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.header == null) {
            return map;
        }
        Node node = this.header;
        Node cnode2 = null;
        Iterator it = null;
        while (node.next != null) {
            for (Node cnode2 : node.childList) {
                map.put(cnode2.getID(), node.getID());
            }
            node = node.next;
        }
        return map;
    }

    private Node getLastNode() {
        if (this.isEmpty()) {
            return null;
        }
        Node cur = this.header;
        while (cur.next != null) {
            cur = cur.next;
        }
        return cur;
    }

    public boolean isEmpty() {
        return this.header == null;
    }

    private IRow findRowByNode(Node node) {
        String nodeID = node.info.getId().toString();
        String tempID = null;
        IRow row = null;
        for (int i = 0; i < this.table.getRowCount() && !nodeID.equals(tempID = (row = this.table.getRow(i)).getCell(TB_ID).getValue().toString()); ++i) {
            row = null;
        }
        return row;
    }

    private BigDecimal getAllHisChildValueSum(Node node, String fieldName) {
        BigDecimal sum = this.ZERO;
        BigDecimal value = this.ZERO;
        Node cnode2 = null;
        int rowIndex = -1;
        HashSet rowIndexSet = (HashSet)this.rowIndexMap.get(node.getID());
        rowIndexSet.clear();
        for (Node cnode2 : node.childList) {
            rowIndex = this.findRowByNode(cnode2).getRowIndex();
            value = this.getBigDecimalValueFromTable(rowIndex, fieldName);
            sum = sum.add(value);
            rowIndexSet.add(new Integer(rowIndex));
        }
        rowIndexSet.add(new Integer(this.findRowByNode(node).getRowIndex()));
        return sum;
    }

    public void qtyChange(int rowIndex, String qty_name) throws Exception {
        if (!this.isDistribute) {
            return;
        }
        if (this.isAutoCal) {
            this.autoCalWhenQtyChange(rowIndex, qty_name);
        } else {
            this.unAutoCalWhenQtyChange(rowIndex, qty_name);
        }
    }

    private void unAutoCalWhenQtyChange(int rowIndex, String qty_name) {
        String id = this.table.getRow(rowIndex).getCell(TB_ID).getValue().toString();
        IRow row = null;
        BigDecimal pqty = this.ZERO;
        Node node = this.findNode(id);
        if (node.isParentNode() && (pqty = this.getBigDecimalValueFromTable((row = this.findRowByNode(node)).getRowIndex(), TB_QTY)).compareTo(this.getMaxExecuteQty(row.getRowIndex())) < 0) {
            this.setBigDecimalValueIntoTable(row.getRowIndex(), qty_name, node.qty);
            MsgBox.showInfo((String)SaleUtil.getUIResource("CAN_NOT_GREATER_THAN_MAX_EXE_QTY"));
        }
    }

    private void autoCalWhenQtyChange(int rowIndex, String qty_name) {
        BigDecimal qty = (BigDecimal)this.table.getRow(rowIndex).getCell(qty_name).getValue();
        String id = this.table.getRow(rowIndex).getCell(TB_ID).getValue().toString();
        IRow row = null;
        BigDecimal pqty = this.ZERO;
        Node node = this.findNode(id);
        if (node != null) {
            Node pNode = node.parent;
            row = this.findRowByNode(pNode);
            pqty = this.getBigDecimalValueFromTable(row.getRowIndex(), TB_QTY);
            BigDecimal diff = pNode.qty.subtract(this.getAllHisChildValueSum(pNode, TB_QTY));
            if (diff.compareTo(this.ZERO) <= 0) {
                this.setBigDecimalValueIntoTable(row.getRowIndex(), qty_name, pqty);
                this.setBigDecimalValueIntoTable(rowIndex, qty_name, node.qty);
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"49_DistributeNodeList"));
            } else if (diff.compareTo(this.getMaxExecuteQty(rowIndex)) < 0) {
                this.setBigDecimalValueIntoTable(row.getRowIndex(), qty_name, pqty);
                this.setBigDecimalValueIntoTable(rowIndex, qty_name, node.qty);
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"50_DistributeNodeList"));
            } else {
                this.setBigDecimalValueIntoTable(row.getRowIndex(), qty_name, diff);
                node.qty = qty;
            }
        }
    }

    private Node findNode(String id) {
        Node node2 = null;
        for (Node node2 : this.parentList) {
            if (node2.info.getId().toString().equals(id)) {
                return node2;
            }
            if (!node2.hasChild() || node2.getChild(id) == null) continue;
            return node2.getChild(id);
        }
        return null;
    }

    private BigDecimal getMaxExecuteQty(int rowIndex) {
        String[] qtyS = new String[]{TB_ORDEREDQTY, TB_TOTALISSUEQTY, TB_TOTALINVOICEDQTY, TB_TOTALRETURNEDQTY, TB_TOTALSHIPPINGQTY, TB_TOTALCANCELLINGSTOCKQTY, TB_TOTALTRANSFERQTY};
        BigDecimal maxQty = this.getMax(qtyS, rowIndex);
        return maxQty;
    }

    private BigDecimal getMax(String[] names, int rowIndex) {
        BigDecimal max = this.ZERO;
        BigDecimal value = this.ZERO;
        for (int i = 0; i < names.length; ++i) {
            value = this.getBigDecimalValueFromTable(rowIndex, names[i]);
            max = max.max(value);
        }
        return max;
    }

    private BigDecimal getBigDecimalValueFromTable(int rowIndex, String name) {
        if (rowIndex == -1) {
            return this.ZERO;
        }
        BigDecimal value = (BigDecimal)this.table.getRow(rowIndex).getCell(name).getValue();
        if (value == null) {
            return this.ZERO;
        }
        return value;
    }

    private void setBigDecimalValueIntoTable(int rowIndex, String name, BigDecimal value) {
        this.table.getRow(rowIndex).getCell(name).setValue((Object)value);
    }

    public void lockTableColWhenDistribute() {
        Node pNode = null;
        Node curNode = null;
        SCMBillEntryBaseInfo info = null;
        IRow curRow = null;
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            BigDecimal lockQty;
            boolean isPresent;
            for (int j = 0; j < this.table.getColumnCount(); ++j) {
                this.table.getRow(i).getCell(j).getStyleAttributes().setLocked(true);
            }
            EntryBaseStatusEnum entryStatus = (EntryBaseStatusEnum)this.table.getRow(i).getCell("baseStatus").getValue();
            if (!entryStatus.equals((Object)EntryBaseStatusEnum.AUDITED)) continue;
            curRow = this.table.getRow(i);
            info = (SCMBillEntryBaseInfo)this.table.getRow(i).getUserObject();
            pNode = this.findParentNodeFromParentList(info);
            this.lockCellByNames(new String[]{TB_QTY, TB_STORAGEORGUNIT, TB_PROSTORAGEORGUNIT, TB_DELIVERYDATE, TB_SENDDATE, TB_TAXAMOUNT, TB_WAREHOUSE, TB_PREPAYMENT, TB_REMARK}, curRow, false);
            boolean bl = isPresent = curRow.getCell(TB_ISPRESENT).getValue() == null ? false : (Boolean)curRow.getCell(TB_ISPRESENT).getValue();
            if (isPresent) {
                this.lockCellByNames(new String[]{TB_TAXAMOUNT, TB_PREPAYMENT}, curRow, true);
            }
            if (this.isExecute(i)) {
                if (pNode != null && !pNode.hasChild()) {
                    this.lockCellByNames(new String[]{TB_QTY, TB_STORAGEORGUNIT, TB_PROSTORAGEORGUNIT, TB_TAXAMOUNT, TB_PREPAYMENT}, curRow, true);
                } else {
                    this.lockCellByNames(new String[]{TB_STORAGEORGUNIT, TB_PROSTORAGEORGUNIT}, curRow, true);
                }
            } else if (pNode != null && !pNode.hasChild()) {
                this.lockCellByNames(new String[]{TB_QTY, TB_TAXAMOUNT, TB_PREPAYMENT}, curRow, true);
            }
            if (this.isDistribute) {
                this.lockCellByNames(new String[]{TB_TAXAMOUNT}, curRow, true);
            }
            if ((lockQty = (BigDecimal)curRow.getCell("lockQty").getValue()).compareTo(this.ZERO) > 0) {
                curRow.getCell(TB_STORAGEORGUNIT).getStyleAttributes().setLocked(true);
                curRow.getCell(TB_PROSTORAGEORGUNIT).getStyleAttributes().setLocked(true);
            }
            if ((curNode = this.findNode(info.getId().toString())) == null || !curNode.isParentNode() || this.getBigDecimalValueFromTable(curRow.getRowIndex(), TB_QTY).compareTo(curNode.getValue(TB_QTY)) == 0) continue;
            this.lockCellByNames(new String[]{TB_QTY}, curRow, false);
        }
    }

    private void lockCellByNames(String[] fieldNames, IRow row, boolean isLock) {
        for (int i = 0; i < fieldNames.length; ++i) {
            row.getCell(fieldNames[i]).getStyleAttributes().setLocked(isLock);
        }
    }

    public void addNode(SCMBillEntryBaseInfo pInfo, SCMBillEntryBaseInfo cInfo, int rowIndex) throws Exception {
        if (!this.isDistribute) {
            this.resetSomeColumn(rowIndex);
            this.afterCal(rowIndex);
            this.handleLockColumnWhenNotDistribute(rowIndex);
            return;
        }
        Node pNode = this.findNode(pInfo.getId().toString());
        Node cNode = new Node(cInfo);
        if (pNode.isChildNode()) {
            pNode.parent.addChild(cNode);
        } else {
            pNode.addChild(cNode);
        }
        this.resetSomeColumn(rowIndex);
        this.afterCal(rowIndex);
        this.lockTableColWhenDistribute();
    }

    private void handleLockColumnWhenNotDistribute(int rowIndex) {
        this.table.getRow(rowIndex).getCell(TB_MATERIAL).getStyleAttributes().setLocked(true);
        this.table.getRow(rowIndex).getCell(TB_UNIT).getStyleAttributes().setLocked(false);
    }

    private void afterCal(int rowIndex) throws Exception {
        this.editUi.calByEntryQtyChange(rowIndex, 0);
        ((SaleOrderEditUI)this.editUi).calEntryLocalAmount();
        ((SaleOrderEditUI)this.editUi).calEntryUnOrderQty(rowIndex, 0);
        ((SaleOrderEditUI)this.editUi).setDicountPrecision(rowIndex);
    }

    private void resetSomeColumn(int rowIndex) {
        String[] temp = new String[]{TB_QTY, TB_ORDEREDQTY, TB_TOTALISSUEQTY, TB_TOTALRETURNEDQTY, TB_TOTALINVOICEDQTY, TB_TOTALINVOICEAMT, TB_TOTALARAMOUNT, TB_TOTALRECEIVEDAMOUNT, TB_PRERECEIVED, TB_UNPRERECEIVEDAMOUNT, TB_PREPAYMENT, TB_TOTALSHIPPINGQTY, TB_TOTALTRANSFERQTY, TB_TOTALTRANSFERBASEQTY, TB_TOTALUNTRANSFERQTY, TB_TOTALUNTRANSFERBASEQTY};
        for (int i = 0; i < temp.length; ++i) {
            this.table.getRow(rowIndex).getCell(temp[i]).setValue((Object)this.ZERO);
        }
        this.table.getRow(rowIndex).getCell(TB_DISCOUNTCOND).setValue(null);
        MaterialInfo materialInfo = null;
        materialInfo = ((SCMBillEntryBaseInfo)this.table.getRow(rowIndex).getUserObject()).getMaterial();
        if (materialInfo == null) {
            return;
        }
        this.table.getRow(rowIndex).getCell(TB_MATERIALNAME).setValue((Object)materialInfo.getName());
        this.table.getRow(rowIndex).getCell(TB_MATERIALSIZE).setValue((Object)materialInfo.getModel());
    }

    private boolean isExecute(int rowIndex) {
        boolean flag = false;
        String[] temp = new String[]{TB_TOTALISSUEQTY, TB_TOTALSHIPPINGQTY, TB_TOTALTRANSFERQTY};
        BigDecimal qty = this.ZERO;
        for (int i = 0; i < temp.length; ++i) {
            qty = this.getBigDecimalValueFromTable(rowIndex, temp[i]);
            if (qty.compareTo(this.ZERO) <= 0) continue;
            flag = true;
            break;
        }
        return flag;
    }

    class Node {
        private SCMBillEntryBaseInfo info = null;
        Node next;
        Node parent;
        List childList = new ArrayList();
        Map fieldMap = new HashMap();
        BigDecimal qty;

        public void setQty(BigDecimal value) {
            this.fieldMap.put(DistributeNodeList.TB_QTY, value);
            this.qty = value;
        }

        public void setTaxAmount(BigDecimal value) {
            this.fieldMap.put(DistributeNodeList.TB_TAXAMOUNT, value);
        }

        public void setPrepayment(BigDecimal value) {
            this.fieldMap.put(DistributeNodeList.TB_PREPAYMENT, value);
        }

        public BigDecimal getValue(String fieldName) {
            BigDecimal rs = DistributeNodeList.this.ZERO;
            rs = (BigDecimal)this.fieldMap.get(fieldName);
            if (rs == null) {
                return DistributeNodeList.this.ZERO;
            }
            return rs;
        }

        public Node(SCMBillEntryBaseInfo info) {
            this.qty = DistributeNodeList.this.ZERO;
            this.info = info;
            this.next = null;
            this.parent = null;
        }

        public String getID() {
            return this.info.getId().toString();
        }

        public void removeChild(Node node) {
            if (node == null) {
                return;
            }
            this.childList.remove(node);
        }

        private boolean isChildNode() {
            return this.parent != null;
        }

        private boolean isParentNode() {
            return this.parent == null;
        }

        private boolean isParentNode(SCMBillEntryBaseInfo info) {
            Node node = DistributeNodeList.this.findParentNodeFromParentList(info);
            return node != null;
        }

        private boolean hasChild() {
            return this.childList.size() != 0;
        }

        private void addChild(Node node) {
            if (!this.isParentNode(this.info)) {
                return;
            }
            node.parent = this;
            this.childList.add(node);
        }

        private Node getChild(String id) {
            Node node2 = null;
            for (Node node2 : this.childList) {
                if (node2.info.getId().toString().equals(id)) break;
                node2 = null;
            }
            return node2;
        }
    }
}

