/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AuxAccountUtils;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroupStandard;
import com.kingdee.eas.basedata.master.cssp.client.F7CustomerTreeDetailListUI;
import com.kingdee.eas.basedata.master.cssp.client.F7SupplierTreeDetailListUI;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.client.F7MaterialTreeListUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.CompanyBizUnitF7;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityCollection;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityFactory;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityInfo;
import com.kingdee.eas.scm.im.inv.IDateOfMinDurability;
import com.kingdee.eas.scm.sd.sale.SaleInvReceivePlanCollection;
import com.kingdee.eas.scm.sd.sale.SaleInvReceivePlanInfo;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;

public abstract class SaleUtil {
    public static final String UNIT = "UNIT";
    public static final String BASEUNIT = "BASEUNIT";
    public static final String ASSISTUNIT = "ASSISTUNIT";
    public static final String EXP = "maturityDate";
    public static final String MFG = "produceDate";
    public static final String LOT = "batchNumber";
    public static final String QTY = "quantity";
    public static final String PERIODVALID = "periodValid";
    public static final String PERIODVALIDUNIT = "periodValidUnit";

    public static String getUIResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)key);
    }

    public static String getReportUIResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SaleReportResource", (String)key);
    }

    public static String getBizResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SaleBizResource", (String)key);
    }

    public static Date getBeginDate(Date d) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static SaleInvoiceInfo getNagtiveAmountInfo(SaleInvoiceInfo saleInvInfo) {
        saleInvInfo.setTotalAmount(SaleUtil.getNagtiveValue(saleInvInfo.getTotalAmount()));
        saleInvInfo.setLocalTotalAmount(SaleUtil.getNagtiveValue(saleInvInfo.getLocalTotalAmount()));
        saleInvInfo.setTotalTax(SaleUtil.getNagtiveValue(saleInvInfo.getTotalTax()));
        saleInvInfo.setTotalTaxAmount(SaleUtil.getNagtiveValue(saleInvInfo.getTotalTaxAmount()));
        saleInvInfo.setLocalTotalTaxAmount(SaleUtil.getNagtiveValue(saleInvInfo.getLocalTotalTaxAmount()));
        SaleInvoiceEntryCollection collection = saleInvInfo.getEntries();
        SaleInvoiceEntryInfo entryInfo = null;
        if (collection != null) {
            int num = collection.size();
            for (int j = 0; j < num; ++j) {
                entryInfo = collection.get(j);
                entryInfo.setQty(SaleUtil.getNagtiveValue(entryInfo.getQty()));
                entryInfo.setBaseQty(SaleUtil.getNagtiveValue(entryInfo.getBaseQty()));
                entryInfo.setAssistQty(SaleUtil.getNagtiveValue(entryInfo.getAssistQty()));
                entryInfo.setWrittenOffQty(SaleUtil.getNagtiveValue(entryInfo.getWrittenOffQty()));
                entryInfo.setWittenOffBaseQty(PurUtil.getNagtiveValue((BigDecimal)entryInfo.getWittenOffBaseQty()));
                entryInfo.setUnwriteOffQty(SaleUtil.getNagtiveValue(entryInfo.getUnwriteOffQty()));
                entryInfo.setUnwriteOffBaseQty(PurUtil.getNagtiveValue((BigDecimal)entryInfo.getUnwriteOffBaseQty()));
                entryInfo.setAmount(SaleUtil.getNagtiveValue(entryInfo.getAmount()));
                entryInfo.setLocalAmount(SaleUtil.getNagtiveValue(entryInfo.getLocalAmount()));
                entryInfo.setTax(SaleUtil.getNagtiveValue(entryInfo.getTax()));
                entryInfo.setLocalTax(SaleUtil.getNagtiveValue(entryInfo.getLocalTax()));
                entryInfo.setTaxAmount(SaleUtil.getNagtiveValue(entryInfo.getTaxAmount()));
                entryInfo.setLocalTaxAmount(SaleUtil.getNagtiveValue(entryInfo.getLocalTaxAmount()));
                entryInfo.setWrittenOffAmount(SaleUtil.getNagtiveValue(entryInfo.getWrittenOffAmount()));
                entryInfo.setLocalWrittenOffAmount(SaleUtil.getNagtiveValue(entryInfo.getLocalWrittenOffAmount()));
                entryInfo.setUnwriteOffAmount(SaleUtil.getNagtiveValue(entryInfo.getUnwriteOffAmount()));
                entryInfo.setLocalUnwriteOffAmount(SaleUtil.getNagtiveValue(entryInfo.getLocalUnwriteOffAmount()));
            }
        }
        SaleInvReceivePlanCollection recePlanCollection = saleInvInfo.getReceivePlans();
        SaleInvReceivePlanInfo receivePlanInfo = null;
        int num = recePlanCollection.size();
        for (int j = 0; j < num; ++j) {
            receivePlanInfo = recePlanCollection.get(j);
            receivePlanInfo.setReceiveAmount(SaleUtil.getNagtiveValue(receivePlanInfo.getReceiveAmount()));
            receivePlanInfo.setLocalReceiveAmount(SaleUtil.getNagtiveValue(receivePlanInfo.getLocalReceiveAmount()));
        }
        return saleInvInfo;
    }

    public static SaleInvoiceInfo getReverseAmountInfo(SaleInvoiceInfo saleInvInfo) {
        saleInvInfo.setTotalAmount(saleInvInfo.getTotalAmount().negate());
        saleInvInfo.setLocalTotalAmount(saleInvInfo.getLocalTotalAmount().negate());
        saleInvInfo.setTotalTax(saleInvInfo.getTotalTax().negate());
        saleInvInfo.setTotalTaxAmount(saleInvInfo.getTotalTaxAmount().negate());
        saleInvInfo.setLocalTotalTaxAmount(saleInvInfo.getLocalTotalTaxAmount().negate());
        SaleInvoiceEntryCollection collection = saleInvInfo.getEntries();
        SaleInvoiceEntryInfo entryInfo = null;
        if (collection != null) {
            int num = collection.size();
            for (int j = 0; j < num; ++j) {
                entryInfo = collection.get(j);
                entryInfo.setQty(entryInfo.getQty().negate());
                entryInfo.setBaseQty(entryInfo.getBaseQty().negate());
                entryInfo.setAssistQty(entryInfo.getAssistQty().negate());
                entryInfo.setWrittenOffQty(entryInfo.getWrittenOffQty().negate());
                entryInfo.setUnwriteOffQty(entryInfo.getUnwriteOffQty().negate());
                entryInfo.setAmount(entryInfo.getAmount().negate());
                entryInfo.setLocalAmount(entryInfo.getLocalAmount().negate());
                entryInfo.setTax(entryInfo.getTax().negate());
                entryInfo.setLocalTax(entryInfo.getLocalTax().negate());
                entryInfo.setTaxAmount(entryInfo.getTaxAmount().negate());
                entryInfo.setLocalTaxAmount(entryInfo.getLocalTaxAmount().negate());
                entryInfo.setWrittenOffAmount(entryInfo.getWrittenOffAmount().negate());
                entryInfo.setLocalWrittenOffAmount(entryInfo.getLocalWrittenOffAmount().negate());
                entryInfo.setUnwriteOffAmount(entryInfo.getUnwriteOffAmount().negate());
                entryInfo.setLocalUnwriteOffAmount(entryInfo.getLocalUnwriteOffAmount().negate());
            }
        }
        SaleInvReceivePlanCollection recePlanCollection = saleInvInfo.getReceivePlans();
        SaleInvReceivePlanInfo receivePlanInfo = null;
        int num = recePlanCollection.size();
        for (int j = 0; j < num; ++j) {
            receivePlanInfo = recePlanCollection.get(j);
            receivePlanInfo.setReceiveAmount(receivePlanInfo.getReceiveAmount().negate());
            receivePlanInfo.setLocalReceiveAmount(receivePlanInfo.getLocalReceiveAmount().negate());
        }
        return saleInvInfo;
    }

    public static boolean isInvoiceCheckOffed(SaleInvoiceInfo saleInvoiceInfo) {
        boolean isCheckoffed = false;
        BigDecimal zero = new BigDecimal("0.00");
        if (saleInvoiceInfo != null) {
            SaleInvoiceEntryCollection collection = saleInvoiceInfo.getEntries();
            SaleInvoiceEntryInfo entryInfo = null;
            int num = collection.size();
            for (int i = 0; i < num; ++i) {
                entryInfo = collection.get(i);
                if (entryInfo.getWrittenOffAmount().compareTo(zero) <= 0) continue;
                isCheckoffed = true;
                break;
            }
        }
        return isCheckoffed;
    }

    public static BigDecimal getNagtiveValue(BigDecimal value) {
        if (value == null) {
            return null;
        }
        if (value.compareTo(new BigDecimal("0.00")) <= 0) {
            return value;
        }
        BigDecimal nagtiveValue = new BigDecimal("0.00");
        nagtiveValue = nagtiveValue.subtract(value);
        return nagtiveValue;
    }

    public static StringBuffer getPermissionOrgRange(Context ctx) throws EASBizException, BOSException {
        StringBuffer orgBuffer = new StringBuffer();
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        FullOrgUnitCollection collection = PermissionFactory.getLocalInstance((Context)ctx).getOrgRanges((IObjectPK)userPK);
        int c = collection.size();
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                orgBuffer.append(",");
            }
            orgBuffer.append("'");
            orgBuffer.append(collection.get(i).getId().toString());
            orgBuffer.append("'");
        }
        return orgBuffer;
    }

    public static FilterInfo getPermissionOrgFilter(Context ctx) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        FilterInfo tmpFilterInfo = new FilterInfo();
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        FullOrgUnitCollection collection = PermissionFactory.getLocalInstance((Context)ctx).getOrgRanges((IObjectPK)userPK);
        int c = collection.size();
        for (int i = 0; i < c; ++i) {
            tmpFilterInfo.getFilterItems().add(new FilterItemInfo("cu", (Object)collection.get(i).getId().toString(), CompareType.EQUALS));
            filterInfo.mergeFilter(tmpFilterInfo, "or");
        }
        return filterInfo;
    }

    public static void setLotInfo(KDTable kdtEntry, String materialCol, SaleReturnsInfo editData) {
        if (materialCol == null) {
            return;
        }
        IRow curRow = null;
        int rows = kdtEntry.getRowCount();
        for (int i = 0; i < rows; ++i) {
            curRow = kdtEntry.getRow(i);
            if (curRow.getCell(LOT).getValue() == null) continue;
            SaleUtil.setLotData(kdtEntry, curRow, (MaterialInfo)curRow.getCell(materialCol).getValue(), curRow.getCell(LOT).getValue().toString(), editData);
        }
    }

    public static void setLotInfo(KDTable kdtEntry, int rowIndex, String materialCol, SaleReturnsInfo editData) {
        if (materialCol == null) {
            return;
        }
        IRow curRow = kdtEntry.getRow(rowIndex);
        SaleUtil.setLotData(kdtEntry, curRow, (MaterialInfo)curRow.getCell(materialCol).getValue(), curRow.getCell(LOT).getValue().toString(), editData);
    }

    private static void setLotData(KDTable kdtEntry, IRow curRow, MaterialInfo materialInfo, String lot, SaleReturnsInfo editData) {
        if (materialInfo == null) {
            curRow.getCell(LOT).setValue(null);
            return;
        }
        curRow.getCell(kdtEntry.getColumnIndex(MFG)).setValue(null);
        curRow.getCell(kdtEntry.getColumnIndex(EXP)).setValue(null);
        if (curRow.getCell(kdtEntry.getColumnIndex("storageOrgUnit")).getValue() == null) {
            return;
        }
        StorageOrgUnitInfo sou = (StorageOrgUnitInfo)curRow.getCell(kdtEntry.getColumnIndex("storageOrgUnit")).getValue();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("storageOrgUnit", (Object)sou.getId().toString(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("material", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("lot", (Object)lot, CompareType.EQUALS));
        evi.setFilter(fi);
        try {
            IDateOfMinDurability ido = DateOfMinDurabilityFactory.getRemoteInstance();
            DateOfMinDurabilityCollection doc = ido.getDateOfMinDurabilityCollection(evi);
            if (doc == null || doc.size() <= 0) {
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).setValue(null);
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).setValue(null);
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setLocked(false);
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setLocked(false);
            } else {
                DateOfMinDurabilityInfo dod = doc.get(0);
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).setValue((Object)dod.getMfg());
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).setValue((Object)dod.getExp());
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setLocked(true);
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setLocked(true);
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static void setMfgAndExp(KDTable kdtEntry, IRow curRow, MaterialInfo materialInfo, String lot, SaleReturnsInfo editData) {
        if (materialInfo == null) {
            curRow.getCell(LOT).setValue(null);
            return;
        }
        if (curRow.getCell(kdtEntry.getColumnIndex("storageOrgUnit")).getValue() == null) {
            return;
        }
        StorageOrgUnitInfo sou = (StorageOrgUnitInfo)curRow.getCell(kdtEntry.getColumnIndex("storageOrgUnit")).getValue();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("storageOrgUnit", (Object)sou.getId().toString(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("material", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("lot", (Object)lot, CompareType.EQUALS));
        evi.setFilter(fi);
        try {
            IDateOfMinDurability ido = DateOfMinDurabilityFactory.getRemoteInstance();
            DateOfMinDurabilityCollection doc = ido.getDateOfMinDurabilityCollection(evi);
            if (doc == null || doc.size() <= 0) {
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setLocked(false);
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setLocked(false);
            } else {
                DateOfMinDurabilityInfo dod = doc.get(0);
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).setValue((Object)dod.getMfg());
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).setValue((Object)dod.getExp());
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setLocked(true);
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setLocked(true);
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static String getCheckReceivedParam(String companyId) throws Exception {
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add(new SelectorItemInfo("value"));
        FilterInfo ff = new FilterInfo();
        ff.getFilterItems().add(new FilterItemInfo("keyID.number", (Object)"SCM_SD_CHECK_RECEIVED_WHILE_POST_ORDER"));
        ff.getFilterItems().add(new FilterItemInfo("keyID.subSysID", (Object)"com.kingdee.eas.scm.sd.sale.sale"));
        ff.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)companyId));
        ev.setFilter(ff);
        ParamItemCollection pc = ParamItemFactory.getRemoteInstance().getParamItemCollection(ev);
        if (pc.size() > 0) {
            ParamItemInfo item = pc.get(0);
            return item.getValue();
        }
        return "";
    }

    public static boolean isCheckReceivedUncontrol(String paramValue) {
        return paramValue == null || paramValue.length() == 0 || "0".equals(paramValue);
    }

    public static boolean isCheckReceivedRefusePost(String paramValue) {
        return "1".equals(paramValue);
    }

    public static boolean isCheckReceivedTip(String paramValue) {
        return "2".equals(paramValue);
    }

    public static boolean arIsStart(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)cmpnyOrgUntInfObj);
    }

    public static PeriodInfo getArCurrentPeriod(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)cmpnyOrgUntInfObj);
    }

    public static PeriodInfo getArStartPeriod(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)cmpnyOrgUntInfObj);
    }

    public static PeriodInfo getApStartPeriod(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (CompanyOrgUnitInfo)cmpnyOrgUntInfObj);
    }

    public static void setAsstActSelector(CoreUIObject ui, KDBizPromptBox bizPromptBox, AsstActTypeInfo asstActTypeInfo, boolean isQueryUI) throws Exception {
        String sCompanyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        SaleUtil.setAsstActSelector(ui, bizPromptBox, asstActTypeInfo, sCompanyId, isQueryUI);
    }

    public static void setAsstActSelector(CoreUIObject ui, KDBizPromptBox bizPromptBox, AsstActTypeInfo asstActTypeInfo, String sCompanyId, boolean isQueryUI) throws Exception {
        int f7DisplayMode = SCMGroupClientUtils.getF7DisplayMode((String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        String cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        SaleUtil.setAsstActSelector(ui, bizPromptBox, asstActTypeInfo, sCompanyId, cuId, false, f7DisplayMode, null, isQueryUI);
    }

    public static void setAsstActSelector(CoreUIObject ui, KDBizPromptBox bizPromptBox, AsstActTypeInfo asstActTypeInfo, String sCompanyId, String cuId, boolean isMultiSelect, int f7DisplayMode, String groupStandardId, boolean isQueryUI) throws Exception {
        bizPromptBox.setEditable(true);
        bizPromptBox.setDisplayFormat("$name$");
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setCommitFormat("$number$");
        bizPromptBox.setSelector(null);
        bizPromptBox.setEntityViewInfo(null);
        bizPromptBox.setFilterInfoProducer(null);
        if (asstActTypeInfo == null) {
            bizPromptBox.setEnabled(false);
            return;
        }
        String relationDataObject = asstActTypeInfo.getRealtionDataObject();
        String queryInfo = asstActTypeInfo.getDefaultQueryName();
        bizPromptBox.setQueryInfo(queryInfo);
        if (StringUtils.isEmpty((String)relationDataObject)) {
            bizPromptBox.setEnabled(false);
            return;
        }
        boolean fCust = relationDataObject.equalsIgnoreCase("T_BD_Customer");
        boolean fSupp = relationDataObject.equalsIgnoreCase("T_BD_Supplier");
        boolean fMaterial = relationDataObject.equalsIgnoreCase("T_BD_Material");
        if (relationDataObject.equalsIgnoreCase("T_BD_AccountBanks")) {
            SaleUtil.setAccountBanksF7(bizPromptBox, sCompanyId, queryInfo, isMultiSelect, isQueryUI);
            bizPromptBox.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$;$name$;$simpleCode$", bizPromptBox));
            bizPromptBox.setDisplayFormat("$name$");
        } else if (fCust) {
            SaleUtil.setCustomerF7(ui, bizPromptBox, sCompanyId, cuId, isMultiSelect, f7DisplayMode, groupStandardId, isQueryUI);
            bizPromptBox.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$;$name$;$mnemonicCode$", bizPromptBox));
            bizPromptBox.setDisplayFormat("$name$");
        } else if (fSupp) {
            SaleUtil.setSupplierF7(ui, bizPromptBox, sCompanyId, cuId, isMultiSelect, f7DisplayMode, groupStandardId, isQueryUI);
            bizPromptBox.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$;$name$;$mnemonicCode$", bizPromptBox));
            bizPromptBox.setDisplayFormat("$name$");
        } else if (fMaterial) {
            SaleUtil.setMaterialF7(ui, bizPromptBox, null, isMultiSelect, f7DisplayMode, false);
            bizPromptBox.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$;$name$;$helpCode$", bizPromptBox));
            bizPromptBox.setDisplayFormat("$name$");
        } else if (relationDataObject.equalsIgnoreCase("T_BD_Person")) {
            SaleUtil.setPersonAllCU((IUIObject)ui, bizPromptBox, isMultiSelect);
            bizPromptBox.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$;$name$;$idNum$", bizPromptBox));
            bizPromptBox.setDisplayFormat("$name$");
        } else if (relationDataObject.equalsIgnoreCase("T_ORG_Company")) {
            CompanyBizUnitF7 selectorAdaptor = new CompanyBizUnitF7((IUIObject)ui);
            selectorAdaptor.disablePerm();
            selectorAdaptor.setIsCUFilter(false, true);
            selectorAdaptor.setRootUnitID("00000000-0000-0000-0000-000000000000CCE7AED4");
            selectorAdaptor.setMultiSelect(isMultiSelect);
            bizPromptBox.setSelector((KDPromptSelector)selectorAdaptor);
            bizPromptBox.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$;$name$;$code$", bizPromptBox));
            bizPromptBox.setDisplayFormat("$name$");
        } else if (relationDataObject.equalsIgnoreCase("T_ORG_CostCenter")) {
            SaleUtil.setOrgUnitF7(bizPromptBox, OrgType.CostCenter, sCompanyId, isMultiSelect);
            bizPromptBox.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$;$name$;$code$", bizPromptBox));
            bizPromptBox.setDisplayFormat("$name$");
        } else if (relationDataObject.equalsIgnoreCase("T_ORG_Admin")) {
            SaleUtil.setOrgUnitF7(bizPromptBox, OrgType.Admin, sCompanyId, isMultiSelect);
            bizPromptBox.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$;$name$;$code$", bizPromptBox));
            bizPromptBox.setDisplayFormat("$name$");
        } else if (relationDataObject.equalsIgnoreCase("T_ORG_Purchase")) {
            SaleUtil.setOrgUnitF7(bizPromptBox, OrgType.Purchase, sCompanyId, isMultiSelect);
            bizPromptBox.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$;$name$;$code$", bizPromptBox));
            bizPromptBox.setDisplayFormat("$name$");
        } else if (relationDataObject.equalsIgnoreCase("T_ORG_Storage")) {
            SaleUtil.setOrgUnitF7(bizPromptBox, OrgType.Storage, sCompanyId, isMultiSelect);
            bizPromptBox.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$;$name$;$code$", bizPromptBox));
            bizPromptBox.setDisplayFormat("$name$");
        } else if (relationDataObject.equalsIgnoreCase("T_ORG_Sale")) {
            SaleUtil.setOrgUnitF7(bizPromptBox, OrgType.Sale, sCompanyId, isMultiSelect);
            bizPromptBox.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$;$name$;$code$", bizPromptBox));
            bizPromptBox.setDisplayFormat("$name$");
        } else if (relationDataObject.equalsIgnoreCase("T_ORG_ProfitCenter")) {
            SaleUtil.setOrgUnitF7(bizPromptBox, OrgType.ProfitCenter, sCompanyId, isMultiSelect);
            bizPromptBox.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$;$name$;$code$", bizPromptBox));
            bizPromptBox.setDisplayFormat("$name$");
        } else if (relationDataObject.equalsIgnoreCase("T_BD_GeneralAsstActType")) {
            SaleUtil.setCustomizeAsstActSelector(ui, bizPromptBox, null, asstActTypeInfo, isMultiSelect);
            bizPromptBox.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$;$name$", bizPromptBox));
            bizPromptBox.setDisplayFormat("$name$");
        } else {
            bizPromptBox.setSelector(null);
            bizPromptBox.setEntityViewInfo(null);
            bizPromptBox.setQueryInfo(queryInfo);
            bizPromptBox.setHasCUDefaultFilter(true);
            bizPromptBox.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$;$name$", bizPromptBox));
            bizPromptBox.setDisplayFormat("$name$");
        }
    }

    private static void setAccountBanksF7(KDBizPromptBox bizPromptBox, String sCompanyId, String queryInfo, boolean isMultiSelect, boolean isQueryUI) {
        bizPromptBox.setSelector(null);
        bizPromptBox.setEntityViewInfo(null);
        bizPromptBox.setQueryInfo(queryInfo);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)sCompanyId));
        filter.getFilterItems().add(new FilterItemInfo("company.id", null));
        if (!isQueryUI) {
            filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
            filter.setMaskString("(#0 OR #1) AND #2");
        } else {
            filter.setMaskString(" #0 OR #1 ");
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        bizPromptBox.setEntityViewInfo(evi);
        bizPromptBox.setEnabledMultiSelection(isMultiSelect);
    }

    public static void setCustomerF7(CoreUIObject ui, KDBizPromptBox bizPromptBox, String sCompanyId, String cuId, boolean isMultiSelect, int f7DisplayMode) throws BOSException, EASBizException {
        ICSSPGroupStandard cSSPGroupStandard = CSSPGroupStandardFactory.getRemoteInstance();
        String groupStandardId = cSSPGroupStandard.getBasicStandardId("1");
        SaleUtil.setCustomerF7(ui, bizPromptBox, sCompanyId, cuId, isMultiSelect, f7DisplayMode, groupStandardId);
    }

    public static void setCustomerF7(CoreUIObject ui, KDBizPromptBox bizPromptBox, String sCompanyId, String cuId, boolean isMultiSelect) throws BOSException, EASBizException {
        int f7DisplayMode = SCMGroupClientUtils.getF7DisplayMode((String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        SaleUtil.setCustomerF7(ui, bizPromptBox, sCompanyId, cuId, false, f7DisplayMode);
    }

    public static void setCustomerF7(CoreUIObject ui, KDBizPromptBox bizPromptBox, String sCompanyId, String cuId, boolean isMultiSelect, int f7DisplayMode, String groupStandardId) throws BOSException, EASBizException {
        SaleUtil.setCustomerF7(ui, bizPromptBox, sCompanyId, cuId, isMultiSelect, f7DisplayMode, groupStandardId, false);
    }

    public static void setCustomerF7(CoreUIObject ui, KDBizPromptBox bizPromptBox, String sCompanyId, String cuId, boolean isMultiSelect, int f7DisplayMode, String groupStandardId, boolean isQueryUI) throws BOSException, EASBizException {
        bizPromptBox.setCommitFormat("$number$;$mnemonicCode$");
        String queryInfo = "com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQuery";
        if (groupStandardId == null) {
            ICSSPGroupStandard cSSPGroupStandard = CSSPGroupStandardFactory.getRemoteInstance();
            groupStandardId = cSSPGroupStandard.getBasicStandardId("1");
        }
        FilterInfo filter = new FilterInfo();
        if (isQueryUI) {
            filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(0), CompareType.GREATER));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("CustomerCompanyInfo.usingStatus", (Object)new Integer(0)));
        }
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)sCompanyId));
        filter.getFilterItems().add(new FilterItemInfo("browseGroup.groupStandard", (Object)groupStandardId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        bizPromptBox.setEntityViewInfo(evi);
        if (f7DisplayMode == 0) {
            SelectorListener[] selectorListener1 = SaleUtil.removePrmtAllSelListener(bizPromptBox);
            GeneralKDPromptSelectorAdaptor selectorLisenterCustomer = null;
            selectorLisenterCustomer = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, F7CustomerTreeDetailListUI.class.getName(), (Object)ui, CSSPGroupInfo.getBosType(), queryInfo, "browseGroup.id", "companyOrgUnit.id");
            selectorLisenterCustomer.setQueryProperty("mnemonicCode", "or");
            SaleUtil.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)selectorLisenterCustomer);
            selectorLisenterCustomer.setIsMultiSelect(isMultiSelect);
            selectorLisenterCustomer.setCUId(cuId);
            SaleUtil.addPrmtAllSelListener(bizPromptBox, selectorListener1);
            bizPromptBox.addSelectorListener((SelectorListener)selectorLisenterCustomer);
        } else {
            bizPromptBox.setQueryInfo(queryInfo);
        }
    }

    private static SelectorListener[] removePrmtAllSelListener(KDBizPromptBox prmtCtrl) {
        SelectorListener[] selListeners = prmtCtrl.getSelectorListeners();
        if (selListeners == null) {
            return selListeners;
        }
        for (int i = 0; i < selListeners.length; ++i) {
            prmtCtrl.removeSelectorListener(selListeners[i]);
        }
        return selListeners;
    }

    public static void assignSelector(KDPromptBox promptBox, KDPromptSelector selector) {
        promptBox.setSelector(selector);
    }

    private static void addPrmtAllSelListener(KDBizPromptBox prmtCtrl, SelectorListener[] selListeners) {
        if (selListeners == null) {
            return;
        }
        for (int i = 0; i < selListeners.length; ++i) {
            prmtCtrl.addSelectorListener(selListeners[i]);
        }
    }

    public static void setSupplierF7(CoreUIObject ui, KDBizPromptBox bizPromptBox, String sCompanyId, String cuId, boolean isMultiSelect) throws BOSException, EASBizException {
        int f7DisplayMode = SCMGroupClientUtils.getF7DisplayMode((String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        SaleUtil.setSupplierF7(ui, bizPromptBox, sCompanyId, cuId, false, f7DisplayMode);
    }

    public static void setSupplierF7(CoreUIObject ui, KDBizPromptBox bizPromptBox, String sCompanyId, String cuId, boolean isMultiSelect, int f7DisplayMode) throws BOSException, EASBizException {
        ICSSPGroupStandard cSSPGroupStandard = CSSPGroupStandardFactory.getRemoteInstance();
        String groupStandardId = cSSPGroupStandard.getBasicStandardId("2");
        SaleUtil.setSupplierF7(ui, bizPromptBox, sCompanyId, cuId, isMultiSelect, f7DisplayMode, groupStandardId);
    }

    public static void setSupplierF7(CoreUIObject ui, KDBizPromptBox bizPromptBox, String sCompanyId, String cuId, boolean isMultiSelect, int f7DisplayMode, String groupStandardId) throws BOSException, EASBizException {
        SaleUtil.setSupplierF7(ui, bizPromptBox, sCompanyId, cuId, isMultiSelect, f7DisplayMode, groupStandardId, false);
    }

    public static void setSupplierF7(CoreUIObject ui, KDBizPromptBox bizPromptBox, String sCompanyId, String cuId, boolean isMultiSelect, int f7DisplayMode, String groupStandardId, boolean isQueryUI) throws BOSException, EASBizException {
        bizPromptBox.setCommitFormat("$number$;$mnemonicCode$");
        String queryInfo = "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQuery";
        if (groupStandardId == null) {
            ICSSPGroupStandard cSSPGroupStandard = CSSPGroupStandardFactory.getRemoteInstance();
            groupStandardId = cSSPGroupStandard.getBasicStandardId("2");
        }
        FilterInfo filter = new FilterInfo();
        if (isQueryUI) {
            filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(0), CompareType.GREATER));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("supplierCompany.usingStatus", (Object)new Integer(0)));
        }
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)sCompanyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("browseGroup.groupStandard", (Object)groupStandardId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        bizPromptBox.setEntityViewInfo(evi);
        if (f7DisplayMode == 0) {
            SelectorListener[] selectorListener1 = SaleUtil.removePrmtAllSelListener(bizPromptBox);
            GeneralKDPromptSelectorAdaptor selectorLisenterSupplier = null;
            selectorLisenterSupplier = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, F7SupplierTreeDetailListUI.class.getName(), (Object)ui, CSSPGroupInfo.getBosType(), queryInfo, "browseGroup.id", "companyOrgUnit.id");
            selectorLisenterSupplier.setQueryProperty("mnemonicCode", "or");
            SaleUtil.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)selectorLisenterSupplier);
            selectorLisenterSupplier.setIsMultiSelect(isMultiSelect);
            selectorLisenterSupplier.setCUId(cuId);
            SaleUtil.addPrmtAllSelListener(bizPromptBox, selectorListener1);
            bizPromptBox.addSelectorListener((SelectorListener)selectorLisenterSupplier);
        } else {
            bizPromptBox.setQueryInfo(queryInfo);
        }
    }

    public static void setMaterialF7(CoreUIObject ui, KDBizPromptBox bizPromptBox, boolean isMultiSelect) {
        SaleUtil.setMaterialF7(ui, bizPromptBox, SysContext.getSysContext().getCurrentFIUnit().getId().toString(), isMultiSelect);
    }

    public static void setMaterialF7(CoreUIObject ui, KDBizPromptBox bizPromptBox, String sCompanyId, boolean isMultiSelect) {
        int f7DisplayMode;
        CompanyOrgUnitInfo companyInfo = null;
        try {
            f7DisplayMode = SCMGroupClientUtils.getF7DisplayMode((String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            if (BOSUuid.isValidLength((String)sCompanyId)) {
                ObjectStringPK companyPk = new ObjectStringPK(sCompanyId);
                companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)companyPk);
            }
        }
        catch (BOSException e) {
            f7DisplayMode = 0;
        }
        catch (EASBizException e) {
            f7DisplayMode = 0;
        }
        SaleUtil.setMaterialF7(ui, bizPromptBox, companyInfo, isMultiSelect, f7DisplayMode, false);
    }

    public static void setMaterialF7(CoreUIObject ui, KDBizPromptBox bizPromptBox, CompanyOrgUnitInfo companyInfo, boolean isMultiSelect, int f7DisplayMode, boolean includeFreezed) {
        bizPromptBox.setDisplayFormat("$name$");
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setCommitFormat("$number$");
        boolean onlySupportQueryViaMaterialNumber = SaleUtil.isOnlySupportQueryViaMaterialNumber();
        if (onlySupportQueryViaMaterialNumber) {
            bizPromptBox.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$", bizPromptBox));
        } else {
            bizPromptBox.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$;$name$;$model$;$helpCode$", bizPromptBox));
        }
        FilterInfo filter = new FilterInfo();
        if (includeFreezed) {
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(0), CompareType.GREATER));
            filter.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)new Integer(0), CompareType.GREATER));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)new Integer(1)));
        }
        if (companyInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)companyInfo.getId(), CompareType.EQUALS));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        bizPromptBox.setEntityViewInfo(evi);
        bizPromptBox.setEnabledMultiSelection(isMultiSelect);
        String queryInfo = "com.kingdee.eas.basedata.master.material.app.F7MaterialFIQuery";
        if (f7DisplayMode == 0) {
            SelectorListener[] selectorListener1 = SaleUtil.removePrmtAllSelListener(bizPromptBox);
            GeneralKDPromptSelectorAdaptor selector = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, F7MaterialTreeListUI.class.getName(), (Object)ui, MaterialGroupInfo.getBosType(), queryInfo, "materialGroup.id", "orgUnit.id", "com.kingdee.eas.basedata.master.material.app.F7MaterialFINoGroupQuery");
            SaleUtil.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)selector);
            selector.setIsMultiSelect(isMultiSelect);
            SaleUtil.addPrmtAllSelListener(bizPromptBox, selectorListener1);
            bizPromptBox.addSelectorListener((SelectorListener)selector);
        } else {
            bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialFINoGroupQuery");
            if (companyInfo != null) {
                bizPromptBox.setCurrentMainBizOrgUnit((OrgUnitInfo)companyInfo, OrgType.Company);
            }
            bizPromptBox.setHasCUDefaultFilter(false);
        }
    }

    public static boolean isOnlySupportQueryViaMaterialNumber() {
        IParamControl ipc = null;
        boolean isOnlySupportQueryViaMaterialNumber = false;
        try {
            ipc = ParamControlFactory.getRemoteInstance();
            String paramvalue = ipc.getParamValue(null, "OnlySupportQueryViaMaterialNumber");
            isOnlySupportQueryViaMaterialNumber = Boolean.valueOf(paramvalue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isOnlySupportQueryViaMaterialNumber;
    }

    public static void setPersonAllCU(IUIObject ui, KDBizPromptBox prmtPerson) {
        SaleUtil.setPersonAllCU(ui, prmtPerson, false);
    }

    public static void setPersonAllCU(IUIObject ui, KDBizPromptBox prmtPerson, boolean fMultiSelection, boolean isDisplayName) {
        HashMap<String, String> map = new HashMap<String, String>();
        prmtPerson.setEditable(true);
        prmtPerson.setEditFormat("$number$");
        prmtPerson.setDisplayFormat("$name$");
        if (isDisplayName) {
            prmtPerson.setCommitFormat("$number$;$idNum$");
        } else {
            prmtPerson.setCommitFormat("$number$");
        }
        PersonPromptBox selector = new PersonPromptBox(ui, map);
        selector.setIsSingleSelect(!fMultiSelection);
        prmtPerson.setSelector((KDPromptSelector)selector);
        prmtPerson.setHasCUDefaultFilter(false);
        map.put("All_Admins", "YES");
        prmtPerson.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
    }

    public static void setPersonAllCU(IUIObject ui, KDBizPromptBox prmtPerson, boolean fMultiSelection) {
        SaleUtil.setPersonAllCU(ui, prmtPerson, fMultiSelection, true);
    }

    public static void setOrgUnitF7(KDBizPromptBox bizPromptBox, OrgType fromUnitType, String sCompanyId, boolean isMultiSelect) throws BOSException, EASBizException {
        ObjectStringPK companyPK = new ObjectStringPK(sCompanyId);
        CompanyOrgUnitInfo companyOrgInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)companyPK);
        F7ContextManager f7manager = null;
        f7manager = new F7ContextManager(null, OrgType.Company);
        if (bizPromptBox.getValue() == null) {
            bizPromptBox.setEnabledMultiSelection(isMultiSelect);
        }
        f7manager.registerBizOrgF7(bizPromptBox, null, (OrgUnitInfo)companyOrgInfo, OrgType.Company, fromUnitType);
        if (fromUnitType.getValue() == 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("adminType.id", (Object)"00000000-0000-0000-0000-00000000000362824988"));
            if (bizPromptBox.getEntityViewInfo() == null || bizPromptBox.getEntityViewInfo().getFilter() == null) {
                EntityViewInfo ev = new EntityViewInfo();
                ev.setFilter(filter);
                bizPromptBox.setEntityViewInfo(ev);
            } else {
                bizPromptBox.getEntityViewInfo().getFilter().mergeFilter(filter, "and");
            }
        }
    }

    private static void setCustomizeAsstActSelector(CoreUIObject ui, KDBizPromptBox prmtCtrl, KDBizPromptBox prmtCtrlTo, AsstActTypeInfo asstActTypeInfo, boolean isMultiSelect) throws BOSException, EASBizException {
        String glAsstActTypeGrpId = null;
        if (asstActTypeInfo.getGlAsstActTypeGrp() == null) {
            IAsstActType asstActType = AsstActTypeFactory.getRemoteInstance();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("glAsstActTypeGrp.id"));
            ObjectUuidPK pk = new ObjectUuidPK(asstActTypeInfo.getId());
            AsstActTypeInfo info = asstActType.getAsstActTypeInfo((IObjectPK)pk, sic);
            if (info.getGlAsstActTypeGrp() == null) {
                MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)"lab_assactid_isnull"));
                SysUtil.abort();
            }
            glAsstActTypeGrpId = info.getGlAsstActTypeGrp().getId().toString();
        } else {
            glAsstActTypeGrpId = asstActTypeInfo.getGlAsstActTypeGrp().getId().toString();
        }
        AuxAccountUtils.assignGeneralBizPromptBox((KDBizPromptBox)prmtCtrl, (String)glAsstActTypeGrpId, (boolean)false, (CoreUIObject)ui);
        prmtCtrl.setHasCUDefaultFilter(true);
        if (prmtCtrlTo != null) {
            AuxAccountUtils.assignGeneralBizPromptBox((KDBizPromptBox)prmtCtrlTo, (String)glAsstActTypeGrpId, (boolean)false, (CoreUIObject)ui);
            prmtCtrlTo.setHasCUDefaultFilter(true);
        }
        prmtCtrl.setEnabledMultiSelection(isMultiSelect);
    }

    public static PeriodInfo getApCurrentPeriod(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (CompanyOrgUnitInfo)cmpnyOrgUntInfObj);
    }

    public static boolean apIsStart(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (CompanyOrgUnitInfo)cmpnyOrgUntInfObj);
    }

    public static boolean arIsStart(Context ctx, Object cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmStsCtrlInf = SaleUtil.getArStatusCtrolInfo(ctx, cmpnyOrgUntInfObj);
        if (systmStsCtrlInf != null) {
            return systmStsCtrlInf.isIsStart();
        }
        return false;
    }

    public static PeriodInfo getArCurrentPeriod(Context ctx, Object cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmStsCtrlInf = SaleUtil.getArStatusCtrolInfo(ctx, cmpnyOrgUntInfObj);
        if (systmStsCtrlInf != null) {
            return systmStsCtrlInf.getCurrentPeriod();
        }
        return null;
    }

    public static SystemStatusCtrolInfo getArStatusCtrolInfo(Context ctx, Object cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmSttsCtrlInf = SaleUtil.getSysStatusCtrolInfo(ctx, cmpnyOrgUntInfObj, SystemEnum.ACCOUNTSRECEIVABLE);
        return systmSttsCtrlInf;
    }

    public static SystemStatusCtrolInfo getSysStatusCtrolInfo(Context ctx, Object cmpnyOrgUntInfObj, SystemEnum system) throws BOSException, EASBizException {
        if (ctx == null) {
            throw new IllegalArgumentException();
        }
        if (!(cmpnyOrgUntInfObj instanceof CompanyOrgUnitInfo)) {
            throw new IllegalArgumentException();
        }
        CompanyOrgUnitInfo cmpnyOrgUntInf = (CompanyOrgUnitInfo)cmpnyOrgUntInfObj;
        String cmpnyOrgUntID = cmpnyOrgUntInf.getId().toString();
        ISystemStatusCtrol systemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        String cndtn0 = "(company='" + cmpnyOrgUntID + "')";
        String cndtn1 = "(systemStatus.name=" + system.getValue() + ")";
        String cndtn = cndtn0 + " and " + cndtn1;
        String oql = "select *,startPeriod.*,currentPeriod.* where " + cndtn;
        SystemStatusCtrolCollection systmStsCtrlCllctn = systemStatusCtrol.getSystemStatusCtrolCollection(oql);
        int size = systmStsCtrlCllctn.size();
        if (size <= 0) {
            return null;
        }
        if (size == 1) {
            SystemStatusCtrolInfo systmStsCtrlInf = systmStsCtrlCllctn.get(0);
            return systmStsCtrlInf;
        }
        throw new IllegalArgumentException();
    }

    public static Date getEndDate(Date da) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(da);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static String getFormatPattern(int scale, boolean isDisplayZero) {
        String pattern = null;
        String temp = "000000000000000000";
        String end = temp.substring(0, scale);
        String zeroStr = null;
        if (scale == 0) {
            pattern = "#,##0";
            zeroStr = "0";
        } else {
            pattern = "#,##0." + end;
            zeroStr = "0." + end;
        }
        pattern = pattern + ";-" + pattern + ";";
        if (isDisplayZero) {
            pattern = pattern + zeroStr;
        }
        return pattern;
    }

    public static OrgUnitInfo getDefaultMainBizOrg(Context ctx, OrgType orgType, String permissionItem) throws BOSException, EASBizException {
        OrgUnitInfo[] mainOrgs = SaleUtil.getMainBizOrgList(ctx, orgType, permissionItem);
        OrgUnitInfo currentMainOrg = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)orgType);
        if (currentMainOrg != null && mainOrgs != null && mainOrgs.length > 0) {
            for (int i = 0; i < mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(mainOrgs[i].getId().toString())) continue;
                return currentMainOrg;
            }
        }
        if (mainOrgs != null && mainOrgs.length > 0) {
            return mainOrgs[0];
        }
        return null;
    }

    public static OrgUnitInfo[] getMainBizOrgList(Context ctx, OrgType orgType, String permissionItem) throws BOSException, EASBizException {
        OrgUnitInfo[] mainOrgs = null;
        mainOrgs = SCMServiceFactory.getLocalInstance((Context)ctx).getAuthorizedBizOrgUnits((IObjectPK)new ObjectUuidPK(ctx.getCaller().toString()), orgType, permissionItem);
        if (mainOrgs == null || mainOrgs.length == 0) {
            return null;
        }
        ArrayList<OrgUnitInfo> tempOrgArray = new ArrayList<OrgUnitInfo>();
        boolean isSealUp = false;
        for (int i = 0; i < mainOrgs.length; ++i) {
            if (mainOrgs[i].get("isSealup") != null) {
                isSealUp = Boolean.valueOf(String.valueOf(mainOrgs[i].get("isSealup")));
            }
            if (!mainOrgs[i].isIsOUSealUp() && !isSealUp) {
                tempOrgArray.add(mainOrgs[i]);
            }
            isSealUp = false;
        }
        mainOrgs = tempOrgArray.toArray(new OrgUnitInfo[tempOrgArray.size()]);
        if (mainOrgs.length > 0) {
            mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, (boolean)true);
        }
        return mainOrgs;
    }
}

