/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.vrule.app.postreq;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.sd.sale.PostRequisitionException;
import com.kingdee.eas.scm.sd.sale.PostRequisitionInfo;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class CheckPostRequisitionAuditVaildVRule
implements IVRule {
    Context ctx = null;

    public CheckPostRequisitionAuditVaildVRule(Context ctx) {
        this.ctx = ctx;
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return PostRequisitionInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        this.valid(bean);
    }

    private void valid(IObjectValue model) throws BOSException, EASBizException {
        PostRequisitionInfo postRequisitionInfo = (PostRequisitionInfo)model;
        ObjectUuidPK[] pks = new ObjectUuidPK[]{new ObjectUuidPK(postRequisitionInfo.getId().toString())};
        Set hasBizFlowValueIDs = SCMServerUtils.getHasBizFlowValueBillID((Context)this.ctx, (String)"t_sd_postrequisitionentry", (IObjectPK[])pks);
        this.doAuditCheck(this.ctx, (IObjectPK[])pks, hasBizFlowValueIDs);
    }

    private void doAuditCheck(Context ctx, IObjectPK[] pks, Set hasBizFlowValueIDs) throws BOSException, EASBizException {
        StringBuffer sqlSB = new StringBuffer(1024);
        String sql = null;
        IRowSet rs = null;
        String params = this.convertToString(pks);
        try {
            sqlSB.append("select FNumber from T_SD_PostRequisition where FID in(").append(params).append(") and FBaseStatus<>2");
            sql = sqlSB.toString();
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next() && rs.getString(1) != null) {
                throw new PostRequisitionException(PostRequisitionException.NOSUBMITED_CANNOTAUDIT);
            }
            sqlSB.delete(0, sqlSB.length());
            sqlSB.append("select pr.FNumber from T_SD_PostRequisition pr");
            sqlSB.append(" inner join T_SD_PostRequisitionEntry pre on pre.FParentID = pr.FID");
            sqlSB.append(" where pr.FID in(").append(params).append(")");
            sqlSB.append(" and pr.FIsReverse=0 and (pre.FSourceBillEntryID is null or len(pre.FSourceBillEntryID)=0)");
            sql = sqlSB.toString();
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next() && rs.getString(1) != null) {
                throw new PostRequisitionException(PostRequisitionException.ERROR_NOTRELATECREATE);
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql Execute Error :", (Throwable)e);
        }
        HashSet<IObjectPK> ids = new HashSet<IObjectPK>();
        int len = pks.length;
        for (int i = 0; i < len; ++i) {
            if (hasBizFlowValueIDs.contains(pks[i].toString())) continue;
            ids.add(pks[i]);
        }
        if (ids.size() > 0) {
            params = SCMServerUtils.getInStringFromSet(ids);
            this.isAudit(ctx, params);
        }
    }

    private String convertToString(Object[] objs) {
        if (objs == null || objs.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int count = objs.length;
        for (int i = 0; i < count; ++i) {
            if (objs[i] == null) continue;
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'");
            sb.append(objs[i].toString());
            sb.append("'");
        }
        return sb.toString();
    }

    private void isAudit(Context ctx, String params) throws BOSException, EASBizException {
        StringBuffer sqlSB = new StringBuffer(1024);
        String sql = null;
        IRowSet rs = null;
        IRowSet rs2 = null;
        try {
            sqlSB.append("select pre.FSourceBillTypeID, pre.FSourceBillEntryID, pr.FNumber, pre.FSeq, pre.FQty, mmu.FQtyPrecision,pre.FUnitID");
            sqlSB.append(" from T_SD_PostRequisition pr");
            sqlSB.append(" inner join T_SD_PostRequisitionEntry pre on pre.FParentID = pr.FID");
            sqlSB.append(" left join T_BD_MultiMeasureUnit mmu on mmu.FMaterialID = pre.FMaterialID and mmu.FMeasureUnitID = pre.FUnitID");
            sqlSB.append(" where pr.FID in(").append(params).append(")");
            sqlSB.append(" and pr.FIsReverse=0 and (pre.FSourceBillEntryID is not null and len(pre.FSourceBillEntryID)>0)");
            sqlSB.append(" order by pre.FSeq,pre.FSourceBillEntryID");
            sql = sqlSB.toString();
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            boolean isQtyUnCtrl = true;
            BigDecimal availQty = SysConstant.BIGZERO;
            BigDecimal totalQty = SysConstant.BIGZERO;
            HashMap<String, BigDecimal> totalQtyMap = new HashMap<String, BigDecimal>();
            HashMap<String, String> postNumberMap = new HashMap<String, String>();
            HashMap<String, String> postSeqMap = new HashMap<String, String>();
            ArrayList<String> soEntryList = new ArrayList<String>();
            String soEntryIDs = "";
            ArrayList<String> toEntryList = new ArrayList<String>();
            String toEntryIDs = "";
            String sourceBillTypeID = null;
            String sourceBillEntryID = null;
            String number = null;
            int seq = 0;
            BigDecimal qty = null;
            int qtyPrecision = 0;
            String multiUnitIDs = "";
            ArrayList<String> mulUnitList = new ArrayList<String>();
            while (rs.next()) {
                BigDecimal overQty;
                String soEID;
                sourceBillTypeID = rs.getString(1);
                sourceBillEntryID = rs.getString(2);
                number = rs.getString(3);
                seq = rs.getInt(4);
                qty = rs.getBigDecimal(5);
                qtyPrecision = rs.getInt(6);
                postNumberMap.put(sourceBillEntryID, number);
                postSeqMap.put(sourceBillEntryID, String.valueOf(seq));
                if (totalQtyMap.containsKey(sourceBillEntryID)) {
                    totalQty = ((BigDecimal)totalQtyMap.get(sourceBillEntryID)).add(qty);
                    totalQtyMap.put(sourceBillEntryID, totalQty);
                } else {
                    if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(sourceBillTypeID)) {
                        soEntryList.add(sourceBillEntryID);
                    } else if ("Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(sourceBillTypeID)) {
                        toEntryList.add(sourceBillEntryID);
                    }
                    totalQtyMap.put(sourceBillEntryID, qty);
                }
                if (rs.getString(7) != null) {
                    mulUnitList.add(rs.getString(7));
                }
                if ((soEntryIDs = CollectionUtil.convertList2String(soEntryList)).length() > 0) {
                    sqlSB.setLength(0);
                    sqlSB.append("select soe.FID, soe.FQuantityUnCtrl, mmu.FQtyPrecision, ");
                    sqlSB.append(" to_decimal(to_decimal(to_decimal(soe.FQty,21,8)*(100.000000+ISNULL(soe.FSendOverRate,0.0000)),21,8)/100,21,8)-to_decimal(soe.FTotalReversedQty,21,8)+to_decimal(soe.FTotalSupplyStockQty,21,8)-to_decimal(soe.FTotalShippingQty,21,8)  availQty");
                    sqlSB.append(" from T_SD_SaleOrderEntry soe");
                    sqlSB.append(" left join T_BD_MultiMeasureUnit mmu on mmu.FMaterialID = soe.FMaterialID and mmu.FMeasureUnitID = soe.FUnitID");
                    sqlSB.append(" where soe.FID in (").append(soEntryIDs).append(")");
                    multiUnitIDs = CollectionUtil.convertList2String(mulUnitList);
                    if (multiUnitIDs.length() > 0) {
                        sqlSB.append(" and mmu.FMeasureUnitID in (").append(multiUnitIDs).append(")");
                    }
                    sqlSB.append(" order by soe.fseq asc ");
                    sql = sqlSB.toString();
                    rs2 = DbUtil.executeQuery((Context)ctx, (String)sql);
                    soEID = null;
                    overQty = null;
                    while (rs2.next()) {
                        soEID = rs2.getString(1);
                        if (soEID == null) continue;
                        isQtyUnCtrl = rs2.getBoolean(2);
                        qtyPrecision = rs2.getInt(3);
                        availQty = rs2.getBigDecimal(4);
                        if (isQtyUnCtrl || (totalQty = (BigDecimal)totalQtyMap.get(soEID)).compareTo(availQty) <= 0) continue;
                        overQty = totalQty.subtract(availQty);
                        overQty = overQty.setScale(qtyPrecision, 4);
                        throw new PostRequisitionException(PostRequisitionException.QTYNOTENOUGH, new String[]{postNumberMap.get(soEID).toString(), postSeqMap.get(soEID).toString(), SCMServerUtils.formatNumberMultiLang((Context)ctx, (BigDecimal)overQty)});
                    }
                }
                if ((toEntryIDs = CollectionUtil.convertList2String(toEntryList)).length() <= 0) continue;
                sqlSB.setLength(0);
                sqlSB.append("select toe.FID, toe.FNotControlQty, mmu.FQtyPrecision,");
                sqlSB.append(" round(toe.FQty*((100.000000+ISNULL(toe.FQtyOverRate,0.0000))/100),mmu.FQtyPrecision)-toe.FTotalIssueQty availQty");
                sqlSB.append(" from T_IM_TransferOrderBillEntry toe");
                sqlSB.append(" left join T_BD_MultiMeasureUnit mmu on mmu.FMaterialID = toe.FMaterialID and mmu.FMeasureUnitID = toe.FUnitID");
                sqlSB.append(" where toe.FID in (").append(toEntryIDs).append(")");
                if (multiUnitIDs.length() > 0) {
                    sqlSB.append(" and mmu.FMeasureUnitID in (").append(multiUnitIDs).append(")");
                }
                sqlSB.append(" order by toe.fseq asc ");
                sql = sqlSB.toString();
                rs2 = DbUtil.executeQuery((Context)ctx, (String)sql);
                soEID = null;
                overQty = null;
                while (rs2.next()) {
                    soEID = rs2.getString(1);
                    if (soEID == null) continue;
                    isQtyUnCtrl = rs2.getBoolean(2);
                    qtyPrecision = rs2.getInt(3);
                    availQty = rs2.getBigDecimal(4);
                    if (isQtyUnCtrl || (totalQty = (BigDecimal)totalQtyMap.get(soEID)).compareTo(availQty) <= 0) continue;
                    overQty = totalQty.subtract(availQty);
                    overQty = overQty.setScale(qtyPrecision, 4);
                    throw new PostRequisitionException(PostRequisitionException.QTYNOTENOUGH, new String[]{postNumberMap.get(soEID).toString(), postSeqMap.get(soEID).toString(), SCMServerUtils.formatNumberMultiLang((Context)ctx, (BigDecimal)overQty)});
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql Execute Error :", (Throwable)e);
        }
    }
}

