/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.vrule.app.postreq;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.sd.sale.IPostRequisitionEntry;
import com.kingdee.eas.scm.sd.sale.ISaleContractEntry;
import com.kingdee.eas.scm.sd.sale.ISaleOrderEntry;
import com.kingdee.eas.scm.sd.sale.OrderException;
import com.kingdee.eas.scm.sd.sale.PostRequisitionEntryCollection;
import com.kingdee.eas.scm.sd.sale.PostRequisitionEntryFactory;
import com.kingdee.eas.scm.sd.sale.PostRequisitionEntryInfo;
import com.kingdee.eas.scm.sd.sale.PostRequisitionException;
import com.kingdee.eas.scm.sd.sale.PostRequisitionFactory;
import com.kingdee.eas.scm.sd.sale.PostRequisitionInfo;
import com.kingdee.eas.scm.sd.sale.SaleContractEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleContractEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import java.math.BigDecimal;
import java.util.HashSet;

public class CheckReverseVRule
implements IVRule {
    Context ctx = null;

    public CheckReverseVRule(Context ctx) {
        this.ctx = ctx;
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return PostRequisitionInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        PostRequisitionInfo postRequisitionInfo = (PostRequisitionInfo)bean;
        if (postRequisitionInfo.isIsReverse()) {
            this.checkReverse((IObjectValue)postRequisitionInfo);
            if (postRequisitionInfo.getSourceBillType() == null) {
                postRequisitionInfo.setSourceBillType(postRequisitionInfo.getBillType());
            }
        }
    }

    private boolean checkReverse(IObjectValue model) throws BOSException, EASBizException {
        PostRequisitionInfo postRequisitionInfo = (PostRequisitionInfo)model;
        PostRequisitionInfo srcPostRequisitionInfo = null;
        if (postRequisitionInfo.getSourceBillType() != null && postRequisitionInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-011bc0a812fd463ED552") && postRequisitionInfo.getSourceBillId() != null && (srcPostRequisitionInfo = PostRequisitionFactory.getLocalInstance(this.ctx).getPostRequisitionInfo("select baseStatus where id='" + postRequisitionInfo.getSourceBillId() + "'")).getBaseStatus() != null && srcPostRequisitionInfo.getBaseStatus().getValue() != 4) {
            throw new PostRequisitionException(PostRequisitionException.ORDER_CANNOT_REVERSE);
        }
        PostRequisitionEntryCollection preCollection = postRequisitionInfo.getEntries();
        PostRequisitionEntryInfo prEntryInfo = null;
        PostRequisitionEntryInfo srcPREntryInfo = null;
        SaleOrderEntryInfo srcSOEntryInfo = null;
        SaleContractEntryInfo srcSCEntryInfo = null;
        IPostRequisitionEntry iPostRequisitionEntry = PostRequisitionEntryFactory.getLocalInstance(this.ctx);
        ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance(this.ctx);
        ISaleContractEntry iSaleContractEntry = SaleContractEntryFactory.getLocalInstance(this.ctx);
        HashSet<String> postBillEID = new HashSet<String>();
        int num = preCollection.size();
        for (int i = 0; i < num; ++i) {
            prEntryInfo = preCollection.get(i);
            if (prEntryInfo.getSourceBillType() == null || !prEntryInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-011bc0a812fd463ED552") || prEntryInfo.getSourceBillEntryId() == null) continue;
            postBillEID.add(prEntryInfo.getSourceBillEntryId());
        }
        PostRequisitionEntryCollection postEColl = null;
        SaleOrderEntryCollection saleOrderEColl = null;
        if (postBillEID.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("baseStatus"));
            view.getSelector().add(new SelectorItemInfo("sourceBillType.id"));
            view.getSelector().add(new SelectorItemInfo("sourceBillEntryId"));
            view.getSelector().add(new SelectorItemInfo("qty"));
            view.getSelector().add(new SelectorItemInfo("totalReversedQty"));
            view.getSelector().add(new SelectorItemInfo("shippedQty"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", postBillEID, CompareType.INCLUDE));
            view.setFilter(filter);
            postEColl = iPostRequisitionEntry.getPostRequisitionEntryCollection(view);
            HashSet<String> soBillEID = new HashSet<String>();
            int size = postEColl.size();
            for (int i = 0; i < size; ++i) {
                srcPREntryInfo = postEColl.get(i);
                if (srcPREntryInfo.getSourceBillType() == null || !srcPREntryInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-0113c0a812fd463ED552") || srcPREntryInfo.getSourceBillEntryId() == null) continue;
                soBillEID.add(srcPREntryInfo.getSourceBillEntryId());
            }
            if (soBillEID.size() > 0) {
                view = new EntityViewInfo();
                view.getSelector().add(new SelectorItemInfo("id"));
                view.getSelector().add(new SelectorItemInfo("baseStatus"));
                view.getSelector().add(new SelectorItemInfo("isLocked"));
                view.getSelector().add(new SelectorItemInfo("sourceBillType.id"));
                view.getSelector().add(new SelectorItemInfo("sourceBillEntryId"));
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", soBillEID, CompareType.INCLUDE));
                view.setFilter(filter);
                saleOrderEColl = iSaleOrderEntry.getSaleOrderEntryCollection(view);
            }
        }
        int num2 = preCollection.size();
        for (int i = 0; i < num2; ++i) {
            prEntryInfo = preCollection.get(i);
            if (prEntryInfo.getSourceBillType() == null || !prEntryInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-011bc0a812fd463ED552") || prEntryInfo.getSourceBillEntryId() == null || postEColl == null) continue;
            int size = postEColl.size();
            for (int j = 0; j < size; ++j) {
                srcPREntryInfo = postEColl.get(j);
                if (!srcPREntryInfo.getId().toString().equals(prEntryInfo.getSourceBillEntryId())) continue;
                if (srcPREntryInfo.getBaseStatus() != null && srcPREntryInfo.getBaseStatus().getValue() != 4) {
                    throw new PostRequisitionException(PostRequisitionException.POST_SRC_ENTRY_CANNOT_REVERSE, new String[]{String.valueOf(i + 1)});
                }
                if (srcPREntryInfo.getSourceBillType() != null && srcPREntryInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-0113c0a812fd463ED552") && srcPREntryInfo.getSourceBillEntryId() != null && saleOrderEColl != null) {
                    int count = saleOrderEColl.size();
                    for (int k = 0; k < count; ++k) {
                        EntryBaseStatusEnum srcSCEntryBaseStatus;
                        srcSOEntryInfo = saleOrderEColl.get(k);
                        if (!srcSOEntryInfo.getId().toString().equals(srcPREntryInfo.getSourceBillEntryId())) continue;
                        EntryBaseStatusEnum srcSOEntryBaseStatus = srcSOEntryInfo.getBaseStatus();
                        if (srcSOEntryInfo != null && srcSOEntryBaseStatus.getValue() != 4) {
                            throw new PostRequisitionException(PostRequisitionException.ORDER_SRC_ENTRY_CANNOT_REVERSE, new String[]{String.valueOf(i + 1)});
                        }
                        if (srcSOEntryInfo.isIsLocked()) {
                            throw new PostRequisitionException(PostRequisitionException.ORDER_SRC_ENTRY_LOCKED_CANNOT_REVERSE, new String[]{String.valueOf(i + 1)});
                        }
                        if (srcSOEntryInfo.getSourceBillType() == null || !srcSOEntryInfo.getSourceBillType().getId().toString().equals("DEZBNUYZRM6ieHZ5GGlRc0Y+1VI=") || srcSOEntryInfo.getSourceBillEntryId() == null || (srcSCEntryBaseStatus = (srcSCEntryInfo = iSaleContractEntry.getSaleContractEntryInfo((IObjectPK)new ObjectUuidPK(srcSOEntryInfo.getSourceBillEntryId()))).getBaseStatus()) == null || srcSCEntryBaseStatus.getValue() == 4 || srcSCEntryBaseStatus.getValue() == 7) continue;
                        throw new OrderException(OrderException.CANTRACT_SRC_ENTRY_CANNOT_REVERSE, new String[]{String.valueOf(i + 1)});
                    }
                }
                BigDecimal reverseQty = SCMUtils.effectualNumeric((BigDecimal)prEntryInfo.getQty()).abs();
                BigDecimal qty = SCMUtils.effectualNumeric((BigDecimal)srcPREntryInfo.getQty());
                BigDecimal totalReversedQty = SCMUtils.effectualNumeric((BigDecimal)srcPREntryInfo.getTotalReversedQty());
                BigDecimal shippedQty = SCMUtils.effectualNumeric((BigDecimal)srcPREntryInfo.getShippedQty());
                BigDecimal availReverseQty = qty.subtract(totalReversedQty).subtract(shippedQty);
                if (reverseQty.compareTo(availReverseQty) <= 0) continue;
                throw new SCMBillException(SCMBillException.REVERSE_QTY_TOO_BIG, (Object[])new String[]{String.valueOf(i + 1)});
            }
        }
        return true;
    }
}

