/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.vrule.app.salereturns;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialSalesCollection;
import com.kingdee.eas.basedata.master.material.MaterialSalesFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.credit.app.processor.CreditUpdateHelper;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.sd.sale.ReceiveDispatcherTypeEnum;
import com.kingdee.eas.scm.sd.sale.SaleReturnsException;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashSet;

public class CheckMaterialCanReturn4SubmitVRule
implements IVRule {
    Context ctx;

    public CheckMaterialCanReturn4SubmitVRule(Context ctx) {
        this.ctx = ctx;
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SaleReturnsInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        SaleReturnsInfo info = (SaleReturnsInfo)bean;
        HashSet<String> idSet = new HashSet<String>();
        if (info.getEntries() != null) {
            for (int i = 0; i < info.getEntries().size(); ++i) {
                ReceiveDispatcherTypeEnum receiveDispatcherType;
                if (info.getEntries().get(i) == null || info.getEntries().get(i).getMaterial() == null || (receiveDispatcherType = info.getEntries().get(i).getReceiveDispatcherType()) != null && receiveDispatcherType.getValue() == 2) continue;
                idSet.add(info.getEntries().get(i).getMaterial().getId().toString());
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("material.number"));
        view.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isReturn", (Object)new Integer(0), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", idSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)info.getSaleOrgUnit().getId().toString(), CompareType.EQUALS));
        view.setFilter(filterInfo);
        MaterialSalesCollection collection = MaterialSalesFactory.getLocalInstance((Context)this.ctx).getMaterialSalesCollection(view);
        if (collection != null && collection.size() > 0) {
            StringBuffer msgStr = new StringBuffer();
            for (int j = 0; j < collection.size(); ++j) {
                if (collection.get(j) == null || collection.get(j).getMaterial() == null) continue;
                msgStr.append(collection.get(j).getMaterial().getNumber()).append(",");
            }
            if (msgStr.length() > 0) {
                msgStr.setLength(msgStr.length() - 1);
            }
            throw new SaleReturnsException(SaleReturnsException.MATERIAL_IS_CANNOT_RETURN, new String[]{msgStr.toString()});
        }
        ObjectUuidPK pk = new ObjectUuidPK(info.getId().toString());
        IRowSet rs = CreditUpdateHelper.getPreUpdateData((Context)this.ctx, (Object[])new Object[]{pk});
        info.put("CreditUpdateData", rs);
    }
}

