/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.vrule.app.salereturns;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;

public class CheckQtyAndBaseqtyVRule
implements IVRule {
    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SaleReturnsInfo.class.isAssignableFrom(clazz);
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        SaleReturnsInfo info = (SaleReturnsInfo)bean;
        SaleReturnsEntryCollection entrys = info.getEntries();
        int len = entrys.size();
        for (int j = 0; j < len; ++j) {
            SaleReturnsEntryInfo entry = (SaleReturnsEntryInfo)entrys.getObject(j);
            if (entry == null || entry.getUnit() == null || entry.getBaseUnit() == null) continue;
            if (entry.getUnit().getId().toString().equals(entry.getBaseUnit().getId().toString()) && entry.getQty().compareTo(entry.getBaseQty()) != 0) {
                throw new SCMBillException(SCMBillException.BASEQTYNOTMATCH, new Object[]{"", String.valueOf(j + 1)});
            }
            if (entry.getQty() == null || SysConstant.BIGZERO.compareTo(entry.getQty()) == 0 || entry.getBaseQty() != null && entry.getBaseQty().compareTo(SysConstant.BIGZERO) != 0) continue;
            throw new SCMBillException(SCMBillException.BASEQTYNULL, new Object[]{String.valueOf(j + 1)});
        }
    }
}

