/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.vrule.app.salereturns;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.sd.sale.ReceiveDispatcherTypeEnum;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsException;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import com.kingdee.eas.scm.sm.pur.PurReqException;
import com.kingdee.eas.scm.sm.pur.PurReturnsException;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CheckValidData4SubmitVRule
implements IVRule {
    Context ctx;

    public CheckValidData4SubmitVRule(Context ctx) {
        this.ctx = ctx;
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SaleReturnsInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        this.checkValidData(bean);
    }

    private void checkValidData(IObjectValue model) throws BOSException, EASBizException {
        SaleReturnsEntryCollection entries;
        SaleReturnsInfo sr = (SaleReturnsInfo)model;
        if (sr.getBaseStatus() != null && sr.getBaseStatus().getValue() == 3) {
            throw new PurReqException(PurReqException.UPDATE_IS_CANCEL);
        }
        if (sr.getSourceBillType() != null || sr.getBizType() == null || "wIZPS7oOQaOl1CeE/8cZOSQHQ1w=".equals(sr.getBizType().getId().toString())) {
            // empty if block
        }
        String paramValue = null;
        if (sr.getSaleOrgUnit() != null) {
            try {
                IParamControl ipc = ParamControlFactory.getLocalInstance((Context)this.ctx);
                paramValue = ipc.getParamValue((IObjectPK)new ObjectUuidPK(sr.getSaleOrgUnit().getId().toString()), "SALEORDER101");
            }
            catch (Exception ipc) {
                // empty catch block
            }
        }
        if (paramValue != null && ("false".equals(paramValue.trim()) || "0".equals(paramValue.trim())) && !CollectionUtil.isEmpty((AbstractObjectCollection)(entries = sr.getEntries()))) {
            SaleReturnsEntryInfo entry = null;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = entries.get(i);
                if (entry.getMaterial() == null || entry.getMaterial().getAssistAttr() == null || entry.getAssistProperty() != null) continue;
                throw new PurReturnsException(PurReturnsException.NULL_ENTRY_ASSISTATTR, new Object[]{i + 1});
            }
        }
        HashMap<Integer, ReceiveDispatcherTypeEnum> receiveDispatcherTypeMap = new HashMap<Integer, ReceiveDispatcherTypeEnum>();
        SaleReturnsEntryCollection entries2 = sr.getEntries();
        CompanyOrgUnitInfo companyOrgInfo = sr.getCompanyOrgUnit();
        ArrayList<String> comIds = new ArrayList<String>();
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)entries2)) {
            SaleReturnsEntryInfo entry = null;
            int size = entries2.size();
            for (int i = 0; i < size; ++i) {
                String companyID;
                Boolean isBetweenCompanySend;
                ReceiveDispatcherTypeEnum value;
                entry = entries2.get(i);
                if (!"7eD9TwIyTMmt7ELiDSC65CQHQ1w=".equals(sr.getBizType().getId().toString()) && ReceiveDispatcherTypeEnum.changeIssue.equals((Object)entry.getReceiveDispatcherType())) {
                    throw new SaleReturnsException(SaleReturnsException.RECEIVEDISPATCHERTYPE_VALID);
                }
                if (!"7eD9TwIyTMmt7ELiDSC65CQHQ1w=".equals(sr.getBizType().getId().toString())) {
                    entry.setReceiveDispatcherType(ReceiveDispatcherTypeEnum.returnInWarehs);
                }
                if (!receiveDispatcherTypeMap.containsValue((Object)(value = entry.getReceiveDispatcherType()))) {
                    receiveDispatcherTypeMap.put(new Integer(receiveDispatcherTypeMap.size()), value);
                }
                if ("7eD9TwIyTMmt7ELiDSC65CQHQ1w=".equals(sr.getBizType().getId().toString()) && (isBetweenCompanySend = Boolean.valueOf(entry.isIsBetweenCompanySend())) != null && isBetweenCompanySend.booleanValue()) {
                    throw new SaleReturnsException(SaleReturnsException.NOT_SUPPORT_CENTRALBALANCE_SRTS);
                }
                if (entry.getCompanyOrgUnit() == null || (companyID = entry.getCompanyOrgUnit().getId().toString()).equals(companyOrgInfo.getId().toString())) continue;
                comIds.add(companyID);
            }
            ArrayList<String> balanceCompanyIDList = new ArrayList<String>();
            if (sr.isIsCentralBalance() && sr.isIsSquareBalance()) {
                CompanyOrgUnitInfo companyInfo = sr.getBalanceCompanyOrgUnit();
                balanceCompanyIDList.add(companyInfo.getId().toString());
                comIds.add(companyInfo.getId().toString());
                boolean isExists = CustomerFactory.getLocalInstance((Context)this.ctx).isExistCustomerByInter(companyInfo.getId().toString());
                if (!isExists) {
                    throw new SaleReturnsException(SaleReturnsException.BALANCECOMPANY_NOHAS_INNERCUST);
                }
            }
            ISupplier iSupplier = null;
            iSupplier = SupplierFactory.getLocalInstance((Context)this.ctx);
            List list = null;
            if (!comIds.isEmpty()) {
                list = iSupplier.isExistSupplierByInter(comIds);
            }
            if (list != null) {
                int size2 = list.size();
                for (int i = 0; i < size2; ++i) {
                    if (list.size() >= size2 && !StringUtils.isEmpty((String)list.get(i).toString()) && comIds.contains(list.get(i).toString())) {
                        comIds.remove(list.get(i).toString());
                    }
                    if (balanceCompanyIDList.size() <= 0) continue;
                    balanceCompanyIDList.remove(list.get(i));
                }
            }
            if (sr.isIsCentralBalance() && sr.isIsSquareBalance() && balanceCompanyIDList.size() > 0) {
                throw new SaleReturnsException(SaleReturnsException.BALANCECOMPANY_NOHAS_INNERSUPPLIER);
            }
            if ("7eD9TwIyTMmt7ELiDSC65CQHQ1w=".equals(sr.getBizType().getId().toString()) && receiveDispatcherTypeMap.size() < 2) {
                throw new SaleReturnsException(SaleReturnsException.BIZTYPE_VALID);
            }
        }
    }
}

