/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.vrule.app.so;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.sd.sale.OrderException;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;

public class CheckCompanyHasInnerCustomerVRule
implements IVRule {
    Context ctx = null;

    public CheckCompanyHasInnerCustomerVRule(Context ctx) {
        this.ctx = ctx;
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SaleOrderInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        boolean isInner;
        assert (bean != null);
        SaleOrderInfo so = (SaleOrderInfo)bean;
        if (so.isIsCentralBalance() && !this.isDirectTransSale(so) && so.getCompanyOrgUnit() != null && !(isInner = CustomerFactory.getLocalInstance((Context)this.ctx).isExistCustomerByInter(so.getCompanyOrgUnit().getId().toString()))) {
            throw new OrderException(OrderException.COMPANYISNOTINNER);
        }
        if (so.isIsCentralBalance() && so.isIsSquareBalance() && so.getBalanceCompanyOrgUnit() != null && !(isInner = CustomerFactory.getLocalInstance((Context)this.ctx).isExistCustomerByInter(so.getBalanceCompanyOrgUnit().getId().toString()))) {
            throw new OrderException(OrderException.BALANCECOMPANYISNOTINNER);
        }
    }

    private boolean isDirectTransSale(SaleOrderInfo so) {
        String bizTypeID;
        boolean isDirectTransSale = false;
        if (so == null) {
            return false;
        }
        if (so.getBizType() != null && "d8e80652-0111-1000-e000-04c5c0a812202407435C".equals(bizTypeID = so.getBizType().getId().toString())) {
            isDirectTransSale = true;
        }
        return isDirectTransSale;
    }
}

