/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.vrule.app.so;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.sd.sale.OrderException;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import java.math.BigDecimal;
import java.util.ArrayList;

public class CheckCompanyHasInnerSupplierVRule
implements IVRule {
    Context ctx = null;

    public CheckCompanyHasInnerSupplierVRule(Context ctx) {
        this.ctx = ctx;
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SaleOrderInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        boolean isInner;
        assert (bean != null);
        SaleOrderInfo so = (SaleOrderInfo)bean;
        SaleOrderEntryCollection col = so.getEntries();
        SaleOrderEntryInfo entry = null;
        CompanyOrgUnitInfo company = so.getCompanyOrgUnit();
        CompanyOrgUnitInfo entryCompany = null;
        ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)this.ctx);
        if (so.isIsCentralBalance() && so.isIsSquareBalance() && !(isInner = iSupplier.isExistSupplierByInter(so.getBalanceCompanyOrgUnit().getId().toString()))) {
            throw new OrderException(OrderException.BALANCECOMPANYISNOTINNERSUPPLIER);
        }
        ArrayList<String> companyList = new ArrayList<String>();
        if (company != null) {
            companyList.add(company.getId().toString());
        }
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            String companyID;
            entry = col.get(i);
            entryCompany = entry.getCompanyOrgUnit();
            if (entryCompany == null || companyList.indexOf(companyID = entryCompany.getId().toString()) >= 0) continue;
            companyList.add(companyID);
            boolean isInner2 = iSupplier.isExistSupplierByInter(companyID);
            if (isInner2) continue;
            throw new OrderException(OrderException.ENTRYCOMPANYISNOTINNERSUPPLIER, new Object[]{i + 1});
        }
        this.calTotalAmount(so);
        this.calTotalTax(so);
        this.calTotalTaxAmount(so);
        this.calLocalTotalAmount(so);
    }

    private void calTotalAmount(SaleOrderInfo so) {
        SaleOrderEntryCollection col = so.getEntries();
        SaleOrderEntryInfo entry = null;
        BigDecimal amount = BigDecimal.ZERO;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            entry = col.get(i);
            amount = amount.add(entry.getAmount() == null ? BigDecimal.ZERO : entry.getAmount());
        }
        so.setTotalAmount(amount);
    }

    private void calTotalTax(SaleOrderInfo so) {
        SaleOrderEntryCollection col = so.getEntries();
        SaleOrderEntryInfo entry = null;
        BigDecimal amount = BigDecimal.ZERO;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            entry = col.get(i);
            amount = amount.add(entry.getTax() == null ? BigDecimal.ZERO : entry.getTax());
        }
        so.setTotalTax(amount);
    }

    private void calTotalTaxAmount(SaleOrderInfo so) {
        BigDecimal amount = BigDecimal.ZERO;
        SaleOrderEntryCollection col = so.getEntries();
        SaleOrderEntryInfo entry = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            entry = col.get(i);
            amount = amount.add(entry.getTaxAmount() == null ? BigDecimal.ZERO : entry.getTaxAmount());
        }
        so.setTotalTaxAmount(amount);
    }

    private void calLocalTotalAmount(SaleOrderInfo so) {
        BigDecimal ZERO = new BigDecimal("0.00");
        BigDecimal newTotalTax = so.getTotalTaxAmount();
        newTotalTax = ZERO;
        if (newTotalTax != null) {
            newTotalTax = ZERO.setScale(newTotalTax.scale());
        }
        BigDecimal newTotalTaxAmount = so.getTotalTaxAmount();
        newTotalTaxAmount = ZERO;
        if (newTotalTaxAmount != null) {
            newTotalTaxAmount = ZERO.setScale(newTotalTax.scale());
        }
        SaleOrderEntryCollection col = so.getEntries();
        SaleOrderEntryInfo entry = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            entry = col.get(i);
            newTotalTax = newTotalTax.add(entry.getLocalAmount() == null ? ZERO : entry.getLocalAmount());
            newTotalTaxAmount = newTotalTaxAmount.add(entry.getLocalTaxAmount() == null ? ZERO : entry.getLocalTaxAmount());
        }
        so.setLocalTotalAmount(newTotalTax);
        so.setLocalTotalTaxAmount(newTotalTaxAmount);
    }
}

