/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.vrule.app.so;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;

public class CheckIsSaleOfPurchaseVRule
implements IVRule {
    Context ctx;

    public CheckIsSaleOfPurchaseVRule(Context ctx) {
        this.ctx = ctx;
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SaleOrderInfo.class.isAssignableFrom(clazz);
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        SaleOrderInfo saleOrder = (SaleOrderInfo)bean;
        if (saleOrder.getBizType().getBizCategory() != null && saleOrder.getBizType().getBizCategory().getId().toString().equals("88a7587a-e017-497b-9f86-b8f00ab2fe72A9389020")) {
            return;
        }
        SaleOrderEntryCollection col = saleOrder.getEntries();
        for (int i = 0; i < col.size(); ++i) {
            SaleOrderEntryInfo saleOrderEntryInfo = col.get(i);
            if (!saleOrderEntryInfo.isIsBySaleOrder() || saleOrder.getPurchaseOrgUnit() != null) continue;
            throw new InvBizException(InvBizException.PURORGUNITCANNOTBENULL);
        }
    }
}

