/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.vrule.app.so;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckMaterialInventoryVRule
extends AbstractServerVRule {
    private static final Logger logger = LoggerFactory.getLogger(CheckMaterialInventoryVRule.class);

    public CheckMaterialInventoryVRule() {
        this(null);
    }

    public CheckMaterialInventoryVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SaleOrderInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        SaleOrderInfo info = (SaleOrderInfo)bean;
        SaleOrderEntryCollection col = info.getEntries();
        StringBuilder errors = new StringBuilder();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            SaleOrderEntryInfo entry = (SaleOrderEntryInfo)col.getObject(i);
            MaterialInfo materialInfo = entry.getMaterial();
            if (materialInfo == null || entry.getStorageOrgUnit() == null) continue;
            String souId = entry.getStorageOrgUnit().getId().toString();
            MaterialInventoryInfo miInfo = this.getMaterialInventoryInfo(materialInfo.getId().toString(), souId);
            if (null != miInfo) continue;
            errors.append(materialInfo.getNumber()).append(",");
        }
        if (errors.length() > 0) {
            errors.setLength(errors.length() - 1);
            throw new InvBizException(InvBizException.MATERIAL_INVENTORY_UNAPPROVE, new Object[]{errors.toString()});
        }
    }

    private MaterialInventoryInfo getMaterialInventoryInfo(String materialId, String souId) throws BOSException {
        assert (!StringUtils.isEmpty((String)souId));
        assert (StringUtils.isEmpty((String)materialId));
        if (this.getDataCache().contain(materialId + souId, DataTypeEnum.MATERIAL_INVENTORY)) {
            return (MaterialInventoryInfo)this.getDataCache().get(materialId + souId, DataTypeEnum.MATERIAL_INVENTORY);
        }
        if (logger.isWarnEnabled()) {
            logger.warn("\u6027\u80fd\u9690\u60a3\uff1a\u83b7\u53d6\u7269\u6599\u5e93\u5b58\u9875\u7b7e\u65f6\uff0c\u6ca1\u6709\u547d\u4e2d\u4e1a\u52a1\u94fe\u7684\u6570\u636e\u7f13\u5b58\u3002class-method: com.kingdee.eas.scm.im.inv.vrule.CheckMaterialInventoryVRule.getMaterialInventoryInfo(String, String)");
        }
        IMaterialInventory iMaterialInventory = MaterialInventoryFactory.getLocalInstance((Context)this.getCtx());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)souId));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)UsedStatusEnum.APPROVED));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("isSequenceNo");
        entityViewInfo.setSelector(selector);
        MaterialInventoryCollection col = iMaterialInventory.getMaterialInventoryCollection(entityViewInfo);
        MaterialInventoryInfo info = null;
        if (col != null && col.size() > 0) {
            info = col.get(0);
        }
        this.getDataCache().put(materialId + souId, (Object)info, DataTypeEnum.MATERIAL_INVENTORY);
        return info;
    }
}

