/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.ws.app.importbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.ws.app.importbill.BillResultInfo;
import com.kingdee.eas.scm.ws.app.importbill.IBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.WSValidationException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;

public abstract class AbstractCommonBillSupport
implements IBillSupport {
    protected Context ctx;
    protected static final String RESOURCE_FILE = "com.kingdee.eas.scm.ws.WS2ARAPResource";

    @Override
    public abstract Class getInfoClass();

    @Override
    public void setContext(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public List<BillResultInfo> save(AbstractObjectCollection col) throws EASBizException, BOSException {
        ArrayList<BillResultInfo> list = new ArrayList<BillResultInfo>();
        CoreBaseCollection legalCollection = new CoreBaseCollection();
        this.processInfo(col);
        this.beforeSaveOrSubmit(col);
        for (int i = 0; i < col.size(); ++i) {
            IObjectValue head = col.getObject(i);
            try {
                this.validateHead(head);
            }
            catch (WSValidationException e) {
                BillResultInfo billResult = new BillResultInfo();
                billResult.setNumber(head.getString("number"));
                billResult.setErrorMsgs(Collections.singletonList(e.getMessage()));
                billResult.setStatus(1);
                list.add(billResult);
                continue;
            }
            legalCollection.addObjectDirect(head);
        }
        return this.invokeMethod(col, this.getSaveMethodName(), this.getSaveParamList());
    }

    private void processInfo(AbstractObjectCollection collection) throws BOSException {
        for (int i = 0; i < collection.size(); ++i) {
            IObjectValue head = collection.getObject(i);
            this.processHead(head);
            AbstractObjectCollection entrys = (AbstractObjectCollection)head.get(this.getEntryName());
            for (int j = 0; j < entrys.size(); ++j) {
                IObjectValue entry = entrys.getObject(j);
                this.processEntry(head, entry);
            }
        }
    }

    protected void verifyData(IObjectValue model, List<String> errorMsg) throws BOSException, EASBizException {
        this.verifyHeadData(model, errorMsg);
        IObjectCollection entries = (IObjectCollection)model.get(this.getEntryName());
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue entryInfo = entries.getObject(i);
            this.verifyEntryData(entryInfo, model, errorMsg);
        }
    }

    protected abstract void validateHead(IObjectValue var1) throws BOSException, EASBizException;

    protected abstract void processHead(IObjectValue var1) throws BOSException;

    protected abstract void processEntry(IObjectValue var1, IObjectValue var2) throws BOSException;

    protected abstract void beforeSaveOrSubmit(AbstractObjectCollection var1) throws BOSException, EASBizException;

    protected abstract String getSaveMethodName();

    protected abstract Class[] getSaveParamList();

    protected abstract IBizCtrl getBizCtrl() throws BOSException;

    protected abstract String getEntryName();

    protected String getNumberField() {
        return "number";
    }

    protected void verifyHeadData(IObjectValue model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    protected void verifyEntryData(IObjectValue entryModel, IObjectValue model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    private List<BillResultInfo> invokeMethod(AbstractObjectCollection collection, String methodName, Class[] paramTypes) throws BOSException {
        IObjectValue info;
        ArrayList<BillResultInfo> results = new ArrayList<BillResultInfo>();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            info = collection.getObject(i);
            ArrayList<String> errorMsg = new ArrayList<String>();
            try {
                this.verifyData(info, errorMsg);
            }
            catch (EASBizException e1) {
                errorMsg.add(e1.getMessage());
            }
            if (errorMsg == null || errorMsg.size() <= 0) continue;
            BillResultInfo result = new BillResultInfo();
            result.setErrorMsgs(errorMsg);
            result.setNumber(info.getString(this.getNumberField()));
            result.setStatus(1);
            results.add(result);
            collection.removeObject(i);
            --i;
            --size;
        }
        if (collection != null && collection.size() > 0) {
            ArrayList<BatchExecuteParamsEntry> paramsList = new ArrayList<BatchExecuteParamsEntry>();
            for (int i = 0; i < collection.size(); ++i) {
                info = collection.getObject(i);
                BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(paramTypes);
                entry.add((Object)info);
                paramsList.add(entry);
            }
            try {
                BatchExecuteResult result = this.getBizCtrl().batchExecute(methodName, paramTypes, paramsList.toArray(new BatchExecuteParamsEntry[0]));
                for (int i = 0; i < result.size(); ++i) {
                    IObjectValue info2 = collection.getObject(i);
                    BillResultInfo billResult = new BillResultInfo();
                    billResult.setNumber(info2.getString(this.getNumberField()));
                    if (result.getException(i) == null) {
                        billResult.setId(result.getReturnValue(i).toString());
                        billResult.setStatus(0);
                    } else {
                        billResult.setErrorMsgs(Collections.singletonList(result.getException(i).getMessage()));
                        billResult.setStatus(1);
                    }
                    results.add(billResult);
                }
            }
            catch (BaseException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return results;
    }

    @Override
    public List<BillResultInfo> submit(AbstractObjectCollection col) throws EASBizException, BOSException {
        this.processInfo(col);
        this.beforeSaveOrSubmit(col);
        return this.invokeMethod(col, "submit", new Class[]{CoreBaseInfo.class});
    }

    @Override
    public List<BillResultInfo> audit(List<BillResultInfo> results) throws EASBizException, BOSException {
        return null;
    }

    @Override
    public boolean isSupportSubmit() {
        return false;
    }

    @Override
    public boolean isSupportAudit() {
        return false;
    }

    protected void fillLinkInfoByNumber(IObjectValue source, String key) throws BOSException {
        Object o = source.get(key);
        if (o instanceof CoreBaseInfo && ((CoreBaseInfo)o).getId() == null) {
            source.put(key, (Object)this.getDataBaseInfoByNumber((CoreBaseInfo)o));
        }
    }

    protected void fillLinkInfoByNumber(IObjectValue source, String key, String companyId) throws BOSException {
        Object o = source.get(key);
        if (o instanceof CoreBaseInfo && ((CoreBaseInfo)o).getId() == null) {
            source.put(key, (Object)this.getDataBaseInfoByNumber((CoreBaseInfo)o, companyId));
        }
    }

    protected void fillLinkInfoByNumber(IObjectValue source, List<String> keys) throws BOSException {
        for (String key : keys) {
            this.fillLinkInfoByNumber(source, key);
        }
    }

    public CoreBaseInfo getDataBaseInfoByNumber(CoreBaseInfo info) throws BOSException {
        return this.getDataBaseInfoByNumber(info, null);
    }

    public CoreBaseInfo getDataBaseInfoByNumber(CoreBaseInfo info, String companyId) throws BOSException {
        CoreBaseCollection collection;
        if (info == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)info.getString("number"))) {
            return null;
        }
        if (info.getId() != null) {
            return info;
        }
        ICoreBase iDataBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)info.getBOSType());
        String oql = AbstractCommonBillSupport.getOql(info, info.getString("number"));
        if (null != companyId) {
            oql = oql + " and companyID = '" + companyId + "'";
        }
        if ((collection = iDataBase.getCollection(oql)) != null && collection.size() > 0) {
            return collection.get(0);
        }
        return null;
    }

    private static String getOql(CoreBaseInfo lInfo, String number) {
        StringBuffer sb = new StringBuffer();
        if (lInfo instanceof CurrencyInfo) {
            sb.append("select id,number,name,precision where number='").append(number).append("'");
        } else if (lInfo instanceof RowTypeInfo) {
            sb.append("select id,number,name,isHasMaterialNumber,precision,destinationtype where number='").append(number).append("'");
        } else if (lInfo instanceof CompanyOrgUnitInfo) {
            sb.append("select id,number,name,baseCurrency.id,baseCurrency.name,baseCurrency.number,baseCurrency.precision,CU.id,CU.name,CU.number,CU.code where number='").append(number).append("'");
        } else {
            sb.append("select id,number,name where number='").append(number).append("'");
        }
        return sb.toString();
    }

    protected final List<String> extractKeys(CoreBaseInfo info) {
        ArrayList<String> keys = new ArrayList<String>();
        Enumeration iterator = info.keys();
        while (iterator.hasMoreElements()) {
            keys.add((String)iterator.nextElement());
        }
        return keys;
    }

    protected String getResourceValue(String key, Object[] params) {
        return ResourceBase.getString((String)RESOURCE_FILE, (String)key, (Locale)this.ctx.getLocale(), (Object[])params);
    }
}

