/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.ws.app.importbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillCollection;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillEntryCollection;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillEntryInfo;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.ws.app.importbill.ScmBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.ScmbillImportUtils;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.util.List;

public class OtherInWarehsBillSupport
extends ScmBillSupport {
    @Override
    public boolean isSupportSubmit() {
        return true;
    }

    @Override
    public boolean isSupportAudit() {
        return true;
    }

    @Override
    public BatchExecuteResult getBatchExecuteResult(BatchExecuteParamsEntry[] paramEntries, Class[] batchMethod, String methodPK) throws BaseException {
        return super.getBatchExecuteResult(paramEntries, batchMethod, methodPK);
    }

    @Override
    public Class<OtherInWarehsBillCollection> getInfoClass() {
        return OtherInWarehsBillCollection.class;
    }

    @Override
    public ISCMBillBase getInterface() throws BOSException {
        return OtherInWarehsBillFactory.getLocalInstance((Context)this.getContext());
    }

    @Override
    protected void setDefaultData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        super.setDefaultData(model, errorMsg);
        OtherInWarehsBillInfo info = (OtherInWarehsBillInfo)model;
        this.setTotalCost(info);
    }

    private void setTotalCost(OtherInWarehsBillInfo info) {
        OtherInWarehsBillEntryCollection entries = info.getEntry();
        BigDecimal totalStandardCost = this.zero;
        BigDecimal totalActualCost = this.zero;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            OtherInWarehsBillEntryInfo entryInfo = entries.get(i);
            if (entryInfo.getStandardCost() != null) {
                totalStandardCost = totalStandardCost.add(entryInfo.getStandardCost());
            }
            if (entryInfo.getActualCost() == null) continue;
            totalActualCost = totalActualCost.add(entryInfo.getActualCost());
        }
        info.setTotalStandardCost(totalStandardCost);
        info.setTotalActualCost(totalActualCost);
    }

    @Override
    protected void setDefaultHeadData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        super.setDefaultHeadData(model, errorMsg);
        OtherInWarehsBillInfo info = (OtherInWarehsBillInfo)model;
        BillTypeInfo billtype = new BillTypeInfo();
        billtype.setId(BOSUuid.read((String)"50957179-0105-1000-e000-017bc0a812fd463ED552"));
        info.setBillType(billtype);
        info.setIsInitBill(false);
        info.setIsReversed(false);
    }

    @Override
    protected void setDefaultEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        OtherInWarehsBillEntryInfo entryInfo = (OtherInWarehsBillEntryInfo)entryModel;
        OtherInWarehsBillInfo info = (OtherInWarehsBillInfo)model;
        entryInfo.setStorageOrgUnit(info.getStorageOrgUnit());
        CompanyOrgUnitInfo cou = ScmbillImportUtils.getCompanyInfo(this.getContext(), (OrgUnitInfo)info.getStorageOrgUnit(), 4);
        entryInfo.setCompanyOrgUnit(cou);
        entryInfo.setBizDate(info.getBizDate());
        if (entryInfo.getMaterial() != null) {
            entryInfo.setBaseUnit(entryInfo.getMaterial().getBaseUnit());
            this.setBaseQty(entryInfo, errorMsg);
            this.setStandardCost(entryInfo, errorMsg);
        }
    }

    private void setBaseQty(OtherInWarehsBillEntryInfo entryInfo, List<String> errorMsg) throws BOSException, EASBizException {
        MaterialInfo material = entryInfo.getMaterial();
        MeasureUnitInfo unit = entryInfo.getUnit();
        MeasureUnitInfo baseunit = entryInfo.getBaseUnit();
        MultiMeasureUnitInfo mmu = ScmbillImportUtils.getMultiMeasureUnit(this.getContext(), material, unit, errorMsg);
        MultiMeasureUnitInfo basemmu = ScmbillImportUtils.getMultiMeasureUnit(this.getContext(), material, baseunit, errorMsg);
        BigDecimal qty = entryInfo.getQty();
        BigDecimal baseQty = this.zero;
        if (qty == null) {
            qty = this.zero;
        }
        if (mmu != null && basemmu != null) {
            qty = qty.setScale(mmu.getQtyPrecision(), 4);
            baseQty = qty.multiply(mmu.getBaseConvsRate()).setScale(basemmu.getQtyPrecision(), 4);
        }
        entryInfo.setQty(qty);
        entryInfo.setBaseQty(baseQty);
        entryInfo.setAssociateQty(qty);
        MeasureUnitInfo assistUnit = entryInfo.getAssistUnit();
        if (assistUnit != null) {
            BigDecimal assisqtyQty = InvAppUtils.getMultiUnitQty((Context)this.getContext(), (MeasureUnitInfo)unit, (MeasureUnitInfo)entryInfo.getAssistUnit(), (MaterialInfo)material, (BigDecimal)qty);
            entryInfo.setAssistQty(assisqtyQty);
        }
    }

    private void setStandardCost(OtherInWarehsBillEntryInfo entryInfo, List<String> errorMsg) throws BOSException, EASBizException {
        MaterialInfo material = entryInfo.getMaterial();
        MeasureUnitInfo unit = entryInfo.getUnit();
        CompanyOrgUnitInfo cou = entryInfo.getCompanyOrgUnit();
        MultiMeasureUnitInfo mmu = ScmbillImportUtils.getMultiMeasureUnit(this.getContext(), material, unit, errorMsg);
        MaterialCompanyInfoInfo materialcompanyInfo = ScmbillImportUtils.getMaterialCompanyInfo(this.getContext(), material, cou, errorMsg);
        if (mmu != null && materialcompanyInfo != null && materialcompanyInfo.getStandardCost() != null) {
            BigDecimal qty = entryInfo.getQty();
            BigDecimal unitStandardCost = materialcompanyInfo.getStandardCost().multiply(mmu.getBaseConvsRate());
            entryInfo.setUnitStandardCost(unitStandardCost);
            entryInfo.setStandardCost(unitStandardCost.multiply(qty));
        }
    }
}

