/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.ws.app.importbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.IPayRequestBill;
import com.kingdee.eas.fi.ap.PayRequestBillCollection;
import com.kingdee.eas.fi.ap.PayRequestBillEntryInfo;
import com.kingdee.eas.fi.ap.PayRequestBillFactory;
import com.kingdee.eas.fi.ap.PayRequestBillInfo;
import com.kingdee.eas.fi.ap.PayRequestSumEntryInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.scm.ws.app.importbill.AbstractCommonBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.WSValidationException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PayRequestBillSupport
extends AbstractCommonBillSupport {
    public Map<String, AsstActTypeInfo> asstActTypeCache = new HashMap<String, AsstActTypeInfo>();
    public static final BigDecimal ZERO = BigDecimal.ZERO;

    @Override
    public Class<PayRequestBillCollection> getInfoClass() {
        return PayRequestBillCollection.class;
    }

    @Override
    protected void validateHead(IObjectValue info) throws BOSException, EASBizException {
        boolean isExist;
        PayRequestBillInfo head = (PayRequestBillInfo)info;
        String number = head.getNumber();
        IPayRequestBill iPayRequestBill = PayRequestBillFactory.getLocalInstance((Context)this.ctx);
        if (!StringUtils.isEmpty((String)number) && null != head.getCompany() && null != head.getCompany().getNumber() && (isExist = iPayRequestBill.exists("select id, number where number = '" + number + "' and company.number = '" + head.getCompany().getNumber() + "'"))) {
            throw new WSValidationException(ResourceBase.getString((String)"com.kingdee.eas.scm.ws.WS2ARAPResource", (String)"001_BILL_NUMBER_DUPLICATE", (Locale)this.ctx.getLocale(), (Object[])new Object[]{number}));
        }
    }

    @Override
    protected void processHead(IObjectValue head) throws BOSException {
        PayRequestBillInfo info = (PayRequestBillInfo)head;
        info.setCompany((CompanyOrgUnitInfo)this.getDataBaseInfoByNumber((CoreBaseInfo)info.getCompany()));
        if (info.getCompany() != null && info.getCompany().getId() != null) {
            info.setAccount((AccountViewInfo)this.getDataBaseInfoByNumber((CoreBaseInfo)info.getAccount(), info.getCompany().getId().toString()));
        }
        this.fillLinkInfoByNumber((IObjectValue)info, this.extractKeys((CoreBaseInfo)info));
    }

    @Override
    protected void processEntry(IObjectValue head, IObjectValue entryValue) throws BOSException {
        DataBaseInfo asstActInfo;
        AsstActTypeInfo asstActTypeInfo;
        PayRequestBillInfo info = (PayRequestBillInfo)head;
        PayRequestBillEntryInfo entry = (PayRequestBillEntryInfo)entryValue;
        if (entry.getAsstActType() != null && null != (asstActTypeInfo = this.queryAsstActType(entry.getAsstActType().getNumber()))) {
            entry.setAsstActType(asstActTypeInfo);
        }
        if (entry.getAsstActType() != null && entry.getAsstActType().getId() != null && null != (asstActInfo = this.getAsstActInfo(entry.getAsstActType(), entry.getAsstActNumber()))) {
            entry.setAsstActID(asstActInfo.getId().toString());
            entry.setAsstActName(asstActInfo.getName());
            entry.setAsstActNumber(asstActInfo.getNumber());
        }
        if (info.getCompany() != null && info.getCompany().getId() != null) {
            entry.setAccount((AccountViewInfo)this.getDataBaseInfoByNumber((CoreBaseInfo)info.getAccount(), info.getCompany().getId().toString()));
        }
        this.fillLinkInfoByNumber((IObjectValue)entry, this.extractKeys((CoreBaseInfo)entry));
    }

    private AsstActTypeInfo queryAsstActType(String asstActTypeNumber) throws BOSException {
        AsstActTypeInfo asstActTypeInfo = null;
        if (StringUtils.isEmpty((String)asstActTypeNumber)) {
            return null;
        }
        if (this.asstActTypeCache.get(asstActTypeNumber) != null) {
            asstActTypeInfo = this.asstActTypeCache.get(asstActTypeNumber);
        } else {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            evi.setFilter(fi);
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)asstActTypeNumber, CompareType.EQUALS));
            AsstActTypeCollection collection = AsstActTypeFactory.getLocalInstance((Context)this.ctx).getAsstActTypeCollection(evi);
            if (!collection.isEmpty()) {
                asstActTypeInfo = collection.get(0);
                this.asstActTypeCache.put(asstActTypeNumber, asstActTypeInfo);
            }
        }
        return asstActTypeInfo;
    }

    private DataBaseInfo getAsstActInfo(AsstActTypeInfo asstActTypeInfo, String asstActNumber) throws BOSException {
        String groupId;
        if (asstActNumber == null) {
            return null;
        }
        String realtionDataObject = asstActTypeInfo.getRealtionDataObject();
        BOSObjectType bostype = null;
        if ("T_BD_GeneralAsstActType".equals(realtionDataObject)) {
            bostype = BOSObjectType.create((String)"F90B0133");
        } else if ("T_BD_Customer".equals(realtionDataObject)) {
            bostype = BOSObjectType.create((String)"BF0C040E");
        } else if ("T_BD_Supplier".equals(realtionDataObject)) {
            bostype = BOSObjectType.create((String)"37C67DFC");
        } else if ("T_BD_Person".equals(realtionDataObject)) {
            bostype = BOSObjectType.create((String)"80EF7DED");
        }
        if (null == bostype) {
            return null;
        }
        IDataBase iDataBase = (IDataBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)bostype);
        String oql = "select id,number,name  where number = '" + asstActNumber + "'";
        String string = groupId = asstActTypeInfo.getGlAsstActTypeGrp() == null ? null : asstActTypeInfo.getGlAsstActTypeGrp().getId().toString();
        if ("T_BD_GeneralAsstActType".equals(realtionDataObject) && null != groupId) {
            asstActNumber = asstActNumber.replaceAll("\\.", "\\!");
            oql = "select id,number,name  where longNumber = '" + asstActNumber + "' and group = '" + groupId + "'";
        }
        DataBaseCollection databaseCol = iDataBase.getDataBaseCollection(oql);
        DataBaseInfo dataBaseInfo = null;
        if (databaseCol != null && databaseCol.size() > 0) {
            dataBaseInfo = databaseCol.get(0);
        }
        return dataBaseInfo;
    }

    @Override
    protected String getSaveMethodName() {
        return "save";
    }

    @Override
    protected Class[] getSaveParamList() {
        return new Class[]{CoreBaseInfo.class};
    }

    @Override
    protected IBizCtrl getBizCtrl() throws BOSException {
        return PayRequestBillFactory.getLocalInstance((Context)this.ctx);
    }

    @Override
    protected String getEntryName() {
        return "entrys";
    }

    @Override
    protected void beforeSaveOrSubmit(AbstractObjectCollection collection) throws BOSException, EASBizException {
        for (int i = 0; i < collection.size(); ++i) {
            IObjectValue obj = collection.getObject(i);
            PayRequestBillInfo billInfo = (PayRequestBillInfo)obj;
            billInfo.getEntrys().sort("seq");
            billInfo.setId(null);
            for (int j = 0; j < billInfo.getEntrys().size(); ++j) {
                PayRequestBillEntryInfo entryInfo = billInfo.getEntrys().get(j);
                entryInfo.setLockAmount(ZERO);
                entryInfo.setLockAmountLoc(ZERO);
                entryInfo.setUnLockAmount(entryInfo.getAuditAmount());
                entryInfo.setUnLockAmountLoc(entryInfo.getAuditAmountLoc());
                entryInfo.setUnpayAmount(entryInfo.getAuditAmount());
            }
            for (int j = 0; j < billInfo.getSumEntry().size(); ++j) {
                PayRequestSumEntryInfo sumEntryInfo = billInfo.getSumEntry().get(j);
                sumEntryInfo.setLockAmount(ZERO);
                sumEntryInfo.setLockAmountLoc(ZERO);
                sumEntryInfo.setUnLockAmount(sumEntryInfo.getAuditAmount());
                sumEntryInfo.setUnLockAmountLoc(sumEntryInfo.getAuditAmountLoc());
                sumEntryInfo.setUnpayAmount(sumEntryInfo.getAuditAmount());
            }
        }
    }

    protected SelectorItemCollection getCompanySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("CU.code"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("CU.longNumber"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        return sic;
    }

    @Override
    protected void verifyHeadData(IObjectValue model, List<String> errorMsg) throws BOSException, EASBizException {
        PayRequestBillInfo info = (PayRequestBillInfo)model;
        String number = info.getNumber();
        if (info.getCompany() == null) {
            errorMsg.add(this.getResourceValue("005_COMPANY_IS_NULL", new Object[]{number}));
        }
        this.verifyBillNumber(info, errorMsg);
        super.verifyHeadData(model, errorMsg);
    }

    protected void verifyBillNumber(PayRequestBillInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        boolean isExist;
        String number = model.getNumber();
        if (!StringUtils.isEmpty((String)number) && null != model.getCompany() && null != model.getCompany().getNumber() && (isExist = PayRequestBillFactory.getLocalInstance((Context)this.ctx).exists("select id, number where number = '" + number + "' and company.number = '" + model.getCompany().getNumber() + "'"))) {
            errorMsg.add(this.getResourceValue("001_BILL_NUMBER_DUPLICATE", new Object[]{number}));
        }
    }

    public static ExchangeRateInfo getExchangeRate(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCur, Date date) throws EASBizException, BOSException {
        ICompanyOrgUnit iCompany = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getId()));
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK destCurrpk = null;
        if (company.getBaseExchangeTable() == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(company.getBaseExchangeTable().getId());
        CurrencyInfo baseCur = company.getBaseCurrency();
        if (baseCur != null) {
            if (baseCur.getId().equals((Object)sourceCur.getId())) {
                return null;
            }
        } else {
            return null;
        }
        destCurrpk = new ObjectUuidPK(baseCur.getId());
        iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(sourceCur.getId());
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        return erInfo;
    }

    public static UserInfo getCurrentUser(Context ctx) throws BOSException {
        UserInfo crntUsr = (UserInfo)ctx.get((Object)"UserInfo");
        return crntUsr;
    }

    @Override
    public boolean isSupportSubmit() {
        return true;
    }
}

