/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.ws.app.importbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.sm.pur.PurRequestCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.ws.app.importbill.ScmBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.ScmbillImportUtils;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.util.List;

public class PurRequestBillSupport
extends ScmBillSupport {
    @Override
    public Class<PurRequestCollection> getInfoClass() {
        return PurRequestCollection.class;
    }

    @Override
    public boolean isSupportSubmit() {
        return true;
    }

    @Override
    public boolean isSupportAudit() {
        return true;
    }

    @Override
    public BatchExecuteResult getBatchExecuteResult(BatchExecuteParamsEntry[] paramEntries, Class[] batchMethod, String methodPK) throws BaseException {
        return super.getBatchExecuteResult(paramEntries, batchMethod, methodPK);
    }

    @Override
    public ISCMBillBase getInterface() throws BOSException {
        return PurRequestFactory.getLocalInstance((Context)this.getContext());
    }

    @Override
    protected void setDefaultData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        super.setDefaultData(model, errorMsg);
        PurRequestInfo info = (PurRequestInfo)model;
        this.setTotalAmount(info);
    }

    @Override
    protected void setDefaultHeadData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        super.setDefaultHeadData(model, errorMsg);
        PurRequestInfo info = (PurRequestInfo)model;
        BillTypeInfo billtype = new BillTypeInfo();
        billtype.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-0107c0a812fd463ED552"));
        info.setBillType(billtype);
        info.setIsMergeBill(false);
        info.setPurchaseType(PurchaseTypeEnum.PURCHASE);
    }

    @Override
    protected void setDefaultEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        super.setDefaultEntryData(entryModel, model, errorMsg);
        PurRequestEntryInfo entryInfo = (PurRequestEntryInfo)entryModel;
        PurRequestInfo info = (PurRequestInfo)model;
        if (info.getCompanyOrgUnit() != null) {
            entryInfo.setCompanyOrgUnit(info.getCompanyOrgUnit().getId().toString());
        }
        entryInfo.setBizDate(info.getBizDate());
        MaterialInfo material = entryInfo.getMaterial();
        if (material != null) {
            entryInfo.setMaterialBaseClass(material.getMaterialGroup().getName());
            entryInfo.setAssistUnit(entryInfo.getMaterial().getAssistUnit());
            entryInfo.setBaseUnit(entryInfo.getMaterial().getBaseUnit());
            entryInfo.setMaterialName(material.getName());
            entryInfo.setNoNumMaterialModel(material.getModel());
            this.setBaseQty(entryInfo, errorMsg);
        } else {
            entryInfo.setBaseQty(entryInfo.getQty());
            entryInfo.setBaseUnit(entryInfo.getUnit());
            entryInfo.setUnOrderedBaseQty(entryInfo.getUnOrderedQty());
        }
        this.setEntryAmount(entryInfo);
        if (entryInfo.getRowType() != null) {
            entryInfo.setDestinationType(entryInfo.getRowType().getDestinationType());
        }
    }

    private void setEntryAmount(PurRequestEntryInfo entryInfo) {
        BigDecimal amount = this.zero;
        BigDecimal locleAmount = this.zero;
        int scale = 4;
        if (entryInfo.getCurrency() != null) {
            scale = entryInfo.getCurrency().getPrecision();
        }
        if (entryInfo.getPrice() != null && entryInfo.getQty() != null) {
            amount = entryInfo.getPrice().multiply(entryInfo.getQty()).setScale(scale, 4);
            if (entryInfo.getExchangeRate() != null) {
                locleAmount = amount.multiply(entryInfo.getExchangeRate()).setScale(scale, 4);
            }
        }
        entryInfo.setAmount(amount);
        entryInfo.setLocalAmount(locleAmount);
    }

    private void setTotalAmount(PurRequestInfo info) {
        PurRequestEntryCollection entries = info.getEntries();
        BigDecimal totalAmount = this.zero;
        BigDecimal totalLocleAmount = this.zero;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            PurRequestEntryInfo entryInfo = entries.get(i);
            if (entryInfo.getAmount() != null) {
                totalAmount = totalAmount.add(entryInfo.getAmount());
            }
            if (entryInfo.getLocalAmount() == null) continue;
            totalLocleAmount = totalLocleAmount.add(entryInfo.getLocalAmount());
        }
        info.setTotalAmount(totalAmount);
        info.setLocalTotalAmount(totalLocleAmount);
    }

    private void setBaseQty(PurRequestEntryInfo entryInfo, List<String> errorMsg) throws BOSException, EASBizException {
        MaterialInfo material = entryInfo.getMaterial();
        MeasureUnitInfo unit = entryInfo.getUnit();
        MeasureUnitInfo baseunit = entryInfo.getBaseUnit();
        MultiMeasureUnitInfo mmu = ScmbillImportUtils.getMultiMeasureUnit(this.getContext(), material, unit, errorMsg);
        MultiMeasureUnitInfo basemmu = ScmbillImportUtils.getMultiMeasureUnit(this.getContext(), material, baseunit, errorMsg);
        BigDecimal qty = entryInfo.getQty();
        BigDecimal baseQty = this.zero;
        BigDecimal unOrderbaseqty = this.zero;
        BigDecimal unOrderqty = entryInfo.getUnOrderedQty();
        if (qty == null) {
            qty = this.zero;
        }
        if (unOrderqty == null) {
            unOrderqty = this.zero;
        }
        if (mmu != null && basemmu != null) {
            qty = qty.setScale(mmu.getQtyPrecision());
            baseQty = qty.multiply(mmu.getBaseConvsRate()).setScale(basemmu.getQtyPrecision(), 4);
            unOrderqty = unOrderqty.setScale(mmu.getConvsPrecision());
            unOrderbaseqty = unOrderqty.multiply(mmu.getBaseConvsRate()).setScale(basemmu.getConvsPrecision(), 4);
        }
        entryInfo.setQty(qty);
        entryInfo.setAssociateQty(qty);
        entryInfo.setBaseQty(baseQty);
        entryInfo.setUnOrderedQty(unOrderqty);
        entryInfo.setUnOrderedBaseQty(unOrderbaseqty);
        MeasureUnitInfo assistUnit = entryInfo.getAssistUnit();
        if (assistUnit != null) {
            BigDecimal assisqtyQty = InvAppUtils.getMultiUnitQty((Context)this.getContext(), (MeasureUnitInfo)unit, (MeasureUnitInfo)entryInfo.getAssistUnit(), (MaterialInfo)material, (BigDecimal)qty);
            entryInfo.setAssistQty(assisqtyQty);
        }
    }

    @Override
    protected void dealWithEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        PurRequestEntryInfo info = (PurRequestEntryInfo)entryModel;
        if (info.getPurchaseGroup() != null && info.getPurchaseOrgUnit() != null && info.getPurchaseOrgUnit().getId() != null) {
            ScmbillImportUtils.setPurchaseGroup(this.getContext(), (CoreBaseInfo)info, errorMsg, "purchaseGroup", info.getPurchaseGroup(), info.getPurchaseOrgUnit().getId().toString());
        }
        if (info.getPurchasePerson() != null && info.getPurchaseGroup() != null && info.getPurchaseGroup().getId() != null) {
            ScmbillImportUtils.setPurchasePerson(this.getContext(), (CoreBaseInfo)info, errorMsg, "purchasePerson", info.getPurchasePerson(), info.getPurchaseGroup().getId().toString());
        }
    }
}

