/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.ws.app.importbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.sd.sale.SaleContractCollection;
import com.kingdee.eas.scm.sd.sale.SaleContractEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleContractFactory;
import com.kingdee.eas.scm.sd.sale.SaleContractInfo;
import com.kingdee.eas.scm.ws.app.importbill.ScmBillSupport;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class SaleContractBillSupport
extends ScmBillSupport {
    @Override
    public Class getInfoClass() {
        return SaleContractCollection.class;
    }

    @Override
    public ISCMBillBase getInterface() throws BOSException {
        return SaleContractFactory.getLocalInstance((Context)this.getContext());
    }

    @Override
    public boolean isSupportSubmit() {
        return true;
    }

    @Override
    public boolean isSupportAudit() {
        return true;
    }

    @Override
    public BatchExecuteResult getBatchExecuteResult(BatchExecuteParamsEntry[] paramEntries, Class[] batchMethod, String methodPK) throws BaseException {
        return super.getBatchExecuteResult(paramEntries, batchMethod, methodPK);
    }

    @Override
    protected void setDefaultHeadData(SCMBillBaseInfo info, List<String> errorMsg) throws BOSException, EASBizException {
    }

    @Override
    protected void setDefaultEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    @Override
    protected void dealWithHeadData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    @Override
    protected void dealWithEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    @Override
    protected void verifyHeadData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        Object transLeadTime;
        Object isInTax;
        SaleContractInfo info = (SaleContractInfo)model;
        this.verifyNumber(info.getNumber(), errorMsg);
        this.verifyDataInfo((DataBaseInfo)info.getBizType(), errorMsg, "BIZ_TYPE_IS_NULL", new Object[0]);
        this.verifyDataInfo((DataBaseInfo)info.getCustomer(), errorMsg, "ORDER_CUSTOMER_IS_NULL", new Object[0]);
        this.verifyDataInfo((DataBaseInfo)info.getContractType(), errorMsg, "CONTRACT_TYPE_IS_NULL", new Object[0]);
        this.verifyDataInfo((DataBaseInfo)info.getSaleOrgUnit(), errorMsg, "SALEORG_IS_NULL", new Object[0]);
        this.verifyDataInfo((DataBaseInfo)info.getDeliveryType(), errorMsg, "DELIVERY_TYPE_IS_NULL", new Object[0]);
        this.verifyDataInfo((DataBaseInfo)info.getCurrency(), errorMsg, "CURR_IS_NULL", new Object[0]);
        this.verifyDataInfo((DataBaseInfo)info.getPaymentType(), errorMsg, "PAYMENT_TYPE_IS_NULL", new Object[0]);
        this.verifyDataInfo((DataBaseInfo)info.getSalePerson(), errorMsg, "SALE_PERSON_IS_NULL", new Object[0]);
        if (info.getBizDate() == null) {
            errorMsg.add(this.getResource("CONTRACT_DATE_IS_NULL", this.getContext(), new Object[0]));
        }
        if (info.getValidTo() == null) {
            errorMsg.add(this.getResource("CONTRACT_VALID_TO_IS_NULL", this.getContext(), new Object[0]));
        }
        if ((isInTax = info.get(FIELD_ISINTAX)) == null) {
            errorMsg.add(this.getResource("IS_IN_TAX_IS_NULL", this.getContext(), new Object[0]));
        }
        if (info.getExchangeRate() == null) {
            errorMsg.add(this.getResource("EXCHANGE_RATE_IS_NULL", this.getContext(), new Object[0]));
        }
        if ((transLeadTime = info.get(FIELD_TRANSLEADTIME)) == null) {
            errorMsg.add(this.getResource("TRANSLEADTIME_IS_NULL", this.getContext(), new Object[0]));
        }
    }

    @Override
    protected void verifyEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        BigDecimal sendOverRate;
        Object sendDeferralDay;
        SaleContractEntryInfo info = (SaleContractEntryInfo)entryModel;
        this.verifyDataInfo((DataBaseInfo)info.getUnit(), errorMsg, "MEASURE_UNIT_IS_NULL", new Object[0]);
        this.verifyDecimal(info.getQty(), errorMsg, "ORDER_QTY_IS_NULL", null);
        Date deliveryDate = info.getDeliveryDate();
        if (deliveryDate == null) {
            errorMsg.add(this.getResource("DELIVERYDATE_IS_NULL", this.getContext(), new Object[0]));
        }
        if ((sendDeferralDay = info.get("sendDeferralDay")) == null) {
            errorMsg.add(this.getResource("SEND_DEFER_DAY_IS_NULL", this.getContext(), new Object[0]));
        }
        if ((sendOverRate = info.getSendOverRate()) == null) {
            errorMsg.add(this.getResource("SENDOVER_RATE_IS_NULL", this.getContext(), new Object[0]));
        }
    }
}

