/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.ws.app.importbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.access.entity.SimpleProperty;
import com.kingdee.bos.metadata.access.entity.SimplePropertyCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.sm.pur.IPurchasePerson;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupCollection;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupFactory;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonCollection;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonFactory;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.scm.ws.app.importbill.DataInfoCache;
import com.kingdee.eas.scm.ws.app.json.MultiLangUtils;
import com.kingdee.eas.util.ResourceBase;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;

public class ScmbillImportUtils {
    public static List<String> setInfoByNumber(Context ctx, CoreBaseInfo info, List<String> errorMsg) throws BOSException {
        return ScmbillImportUtils.setDataInfoByNumber(ctx, info, errorMsg);
    }

    public static List<String> setDataInfoByNumber(Context ctx, CoreBaseInfo info, List<String> errorMsg) throws BOSException {
        Enumeration keys = info.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object obj = info.get(key);
            if (obj != null && obj instanceof MaterialInfo) {
                ScmbillImportUtils.setMaterial(ctx, info, errorMsg, key, obj);
                continue;
            }
            if (obj != null && obj instanceof DataBaseInfo) {
                ScmbillImportUtils.setDataBaseInfo(ctx, info, errorMsg, key, obj);
                continue;
            }
            if (obj != null && obj instanceof CoreBillBaseInfo) {
                ScmbillImportUtils.setCoreBillInfo(ctx, info, errorMsg, key, obj);
                continue;
            }
            if (obj != null && obj instanceof UserInfo) {
                ScmbillImportUtils.setUserInfo(ctx, info, errorMsg, key, obj);
                continue;
            }
            if (obj != null && obj instanceof IObjectCollection) {
                ScmbillImportUtils.setCollection(ctx, errorMsg, obj);
                continue;
            }
            if (obj == null || !(obj instanceof AsstAttrValueInfo)) continue;
            ScmbillImportUtils.setAsstAttrValueInfo(ctx, info, errorMsg, key, obj);
        }
        return errorMsg;
    }

    private static String getOql(DataBaseInfo lInfo, String number) {
        StringBuffer sb = new StringBuffer();
        if (lInfo instanceof CurrencyInfo) {
            sb.append("select id,number,name,precision where number='").append(number).append("'");
        } else if (lInfo instanceof RowTypeInfo) {
            sb.append("select id,number,name,isHasMaterialNumber,precision,destinationtype,projectType,requestOrgType where number='").append(number).append("'");
        } else if (lInfo instanceof StorageOrgUnitInfo) {
            sb.append("select id,number,name,isBizUnit where number='").append(number).append("'");
        } else if (lInfo instanceof WarehouseInfo) {
            sb.append("select id,number,name,hasLocation where number='").append(number).append("'");
        } else {
            sb.append("select id,number,name where number='").append(number).append("'");
        }
        return sb.toString();
    }

    public static void setDataBaseInfo(Context ctx, CoreBaseInfo info, List<String> errorMsg, String key, Object obj) throws BOSException {
        DataBaseCollection databaseCol;
        DataBaseInfo lInfo = (DataBaseInfo)obj;
        String number = lInfo.getNumber();
        if (lInfo.getId() != null || number == null || number.trim().length() <= 0) {
            return;
        }
        String mapKey = number + lInfo.getClass().toString();
        if (DataInfoCache.getInstance().containsKey(mapKey)) {
            info.put(key, DataInfoCache.getInstance().get(mapKey));
            return;
        }
        IDataBase iDataBase = (IDataBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)lInfo.getBOSType());
        String oql = ScmbillImportUtils.getOql(lInfo, number);
        if (lInfo instanceof LocationInfo && info.getObjectValue("warehouse") != null && info.getObjectValue("warehouse").getString("id") != null) {
            oql = oql + " and warehouse = '" + info.getObjectValue("warehouse").getString("id") + "'";
        }
        if ((databaseCol = iDataBase.getDataBaseCollection(oql)) != null && databaseCol.size() > 0) {
            lInfo = databaseCol.get(0);
            DataInfoCache.getInstance().put(mapKey, lInfo);
        } else {
            errorMsg.add(ResourceBase.getString((String)"com.kingdee.eas.scm.ws.WS2ARAPResource", (String)"007_RESOURCE", (Locale)ctx.getLocale(), (Object[])new Object[]{number, ScmbillImportUtils.getAliasName(ctx, info, key)}));
        }
        info.put(key, (Object)lInfo);
    }

    public static void setCollection(Context ctx, List<String> errorMsg, Object obj) throws BOSException {
        IObjectCollection collection = (IObjectCollection)obj;
        for (int i = 0; i < collection.size(); ++i) {
            CoreBaseInfo entryInfo = (CoreBaseInfo)collection.getObject(i);
            ScmbillImportUtils.setDataInfoByNumber(ctx, entryInfo, errorMsg);
        }
    }

    public static void setCoreBillInfo(Context ctx, CoreBaseInfo info, List<String> errorMsg, String key, Object obj) throws BOSException {
        CoreBillBaseInfo lInfo = (CoreBillBaseInfo)obj;
        if (lInfo.getId() != null) {
            return;
        }
        ICoreBillBase iCoreBillBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)lInfo.getBOSType());
        String number = lInfo.getNumber();
        CoreBillBaseCollection databaseCol = iCoreBillBase.getCoreBillBaseCollection("select id,number where number='" + number + "'");
        if (databaseCol != null && databaseCol.size() > 0) {
            lInfo = databaseCol.get(0);
        } else {
            lInfo = null;
            errorMsg.add(ResourceBase.getString((String)"com.kingdee.eas.scm.ws.WS2ARAPResource", (String)"007_RESOURCE", (Locale)ctx.getLocale(), (Object[])new Object[]{number, ScmbillImportUtils.getAliasName(ctx, info, key)}));
        }
        info.put(key, (Object)lInfo);
    }

    public static void setUserInfo(Context ctx, CoreBaseInfo info, List<String> errorMsg, String key, Object obj) throws BOSException {
        UserInfo lInfo = (UserInfo)obj;
        String number = lInfo.getNumber();
        if (lInfo.getId() != null || number == null || number.trim().length() <= 0) {
            return;
        }
        String mapKey = number + lInfo.getClass().toString();
        if (DataInfoCache.getInstance().containsKey(mapKey)) {
            info.put(key, DataInfoCache.getInstance().get(mapKey));
            return;
        }
        IUser iuser = UserFactory.getLocalInstance((Context)ctx);
        UserCollection userCol = iuser.getUserCollection("select id,number ,name where number='" + number + "'");
        if (userCol != null && userCol.size() > 0) {
            lInfo = userCol.get(0);
            DataInfoCache.getInstance().put(mapKey, lInfo);
        } else {
            lInfo = null;
            errorMsg.add(ResourceBase.getString((String)"com.kingdee.eas.scm.ws.WS2ARAPResource", (String)"007_RESOURCE", (Locale)ctx.getLocale(), (Object[])new Object[]{number, ScmbillImportUtils.getAliasName(ctx, info, key)}));
        }
        info.put(key, (Object)lInfo);
    }

    public static void setMaterial(Context ctx, CoreBaseInfo info, List<String> errorMsg, String key, Object obj) throws BOSException {
        MaterialInfo lInfo = (MaterialInfo)obj;
        String number = lInfo.getNumber();
        if (lInfo.getId() != null || number == null || number.trim().length() <= 0) {
            return;
        }
        String mapKey = number + lInfo.getClass().toString();
        if (DataInfoCache.getInstance().containsKey(mapKey)) {
            info.put(key, DataInfoCache.getInstance().get(mapKey));
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(" id"));
        sic.add(new SelectorItemInfo(" name"));
        sic.add(new SelectorItemInfo(" number"));
        sic.add(new SelectorItemInfo(" model"));
        sic.add(new SelectorItemInfo(" pricePrecision"));
        sic.add(new SelectorItemInfo(" baseunit.id"));
        sic.add(new SelectorItemInfo(" assistUnit.id"));
        sic.add(new SelectorItemInfo(" materialGroup.name"));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        viewInfo.setSelector(sic);
        MaterialCollection collection = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            lInfo = collection.get(0);
            DataInfoCache.getInstance().put(mapKey, lInfo);
        } else {
            lInfo = null;
            errorMsg.add(ResourceBase.getString((String)"com.kingdee.eas.scm.ws.WS2ARAPResource", (String)"007_RESOURCE", (Locale)ctx.getLocale(), (Object[])new Object[]{number, ScmbillImportUtils.getAliasName(ctx, info, key)}));
        }
        info.put(key, (Object)lInfo);
    }

    public static void setAsstAttrValueInfo(Context ctx, CoreBaseInfo info, List<String> errorMsg, String key, Object obj) throws BOSException {
        AsstAttrValueInfo lInfo = (AsstAttrValueInfo)obj;
        String number = lInfo.getNumber();
        if (lInfo.getId() != null || number == null || number.trim().length() <= 0) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(" id"));
        sic.add(new SelectorItemInfo(" name"));
        sic.add(new SelectorItemInfo(" number"));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        viewInfo.setSelector(sic);
        AsstAttrValueCollection collection = AsstAttrValueFactory.getLocalInstance((Context)ctx).getAsstAttrValueCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            lInfo = collection.get(0);
        } else {
            lInfo = null;
            errorMsg.add(ResourceBase.getString((String)"com.kingdee.eas.scm.ws.WS2ARAPResource", (String)"007_RESOURCE", (Locale)ctx.getLocale(), (Object[])new Object[]{number, ScmbillImportUtils.getAliasName(ctx, info, key)}));
        }
        info.put(key, (Object)lInfo);
    }

    public static String getAliasName(Context ctx, CoreBaseInfo info, String key) throws BOSException {
        String aliasName = "";
        EntitySelect select = new EntitySelect(info.getBOSType());
        select.propertySelect().select(key, "alias");
        SimpleEntity entity = MetaDataAccessFactory.getLocalInstance((Context)ctx).select(select);
        SimpleProperty propertyObject = entity.property(key);
        aliasName = propertyObject.getString("alias_l2");
        return aliasName;
    }

    public static String getResource(String key, Object[] params) {
        String resource = "";
        return resource;
    }

    public static MultiMeasureUnitInfo getMultiMeasureUnit(Context ctx, MaterialInfo material, MeasureUnitInfo unit, List<String> errorMsg) throws BOSException {
        MultiMeasureUnitInfo mmu = null;
        if (material != null && unit != null) {
            String key = material.getId().toString() + unit.getId().toString();
            if (DataInfoCache.getInstance().containsKey(key)) {
                mmu = (MultiMeasureUnitInfo)DataInfoCache.getInstance().get(key);
            } else {
                mmu = ScmbillImportUtils.getMultiMeasureUnitInfo(ctx, material.getId().toString(), unit.getId().toString());
                if (mmu != null) {
                    DataInfoCache.getInstance().put(key, mmu);
                } else {
                    errorMsg.add(ResourceBase.getString((String)"com.kingdee.eas.scm.ws.WS2ARAPResource", (String)"007_RESOURCE", (Locale)ctx.getLocale(), (Object[])new Object[]{unit.getNumber(), material.getNumber()}));
                }
            }
        }
        return mmu;
    }

    private static MultiMeasureUnitInfo getMultiMeasureUnitInfo(Context ctx, String materialId, String unitId) throws BOSException {
        String oql;
        MultiMeasureUnitInfo mmu = null;
        IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitCollection mulUnits = imultiUnit.getMultiMeasureUnitCollection(oql = " select material.id, measureUnit.id, qtyPrecision,baseConvsRate where measureUnit.id ='" + unitId + "' and material.id ='" + materialId + "'");
        if (mulUnits != null && mulUnits.size() > 0) {
            mmu = mulUnits.get(0);
        }
        return mmu;
    }

    public static MaterialCompanyInfoInfo getMaterialCompanyInfo(Context ctx, MaterialInfo material, CompanyOrgUnitInfo cou, List<String> errorMsg) throws BOSException {
        MaterialCompanyInfoInfo materialcompanyInfo = null;
        if (material != null && cou != null) {
            String key = material.getId().toString() + cou.getId().toString();
            if (DataInfoCache.getInstance().containsKey(key)) {
                materialcompanyInfo = (MaterialCompanyInfoInfo)DataInfoCache.getInstance().get(key);
            } else {
                materialcompanyInfo = ScmbillImportUtils.getMaterialCompanyInfo(ctx, material.getId().toString(), cou.getId().toString());
                if (materialcompanyInfo != null) {
                    DataInfoCache.getInstance().put(key, materialcompanyInfo);
                }
            }
        }
        return materialcompanyInfo;
    }

    private static MaterialCompanyInfoInfo getMaterialCompanyInfo(Context ctx, String materialid, String couID) throws BOSException {
        MaterialCompanyInfoInfo materialcompanyInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mateial", (Object)materialid, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)couID, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("standardCost"));
        MaterialCompanyInfoCollection con = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(viewInfo);
        if (con != null && con.size() >= 1) {
            materialcompanyInfo = con.get(0);
        }
        return materialcompanyInfo;
    }

    public static CompanyOrgUnitInfo getCompanyInfo(Context ctx, OrgUnitInfo orgInfo, int orgType) throws BOSException, EASBizException {
        CompanyOrgUnitInfo couInfo = null;
        if (orgInfo == null) {
            return null;
        }
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCollection = iOrgRelation.getToUnit(orgInfo.getId().toString(), orgType, 1);
        if (orgCollection != null && orgCollection.size() > 0) {
            couInfo = (CompanyOrgUnitInfo)orgCollection.get(0);
        }
        return couInfo;
    }

    public static void getbillMetas(Context ctx, String bosType) {
        SimplePropertyCollection properties = MultiLangUtils.getAllProperties(ctx, BOSObjectType.create((String)bosType));
        for (int i = 0; i < properties.size(); ++i) {
            SimpleProperty sp = properties.get(i);
            String sline = sp.getName() + "; " + sp.getAlias() + "; " + sp.getString("description");
            sline = sp.isOwnProperty() ? sline + "; " + sp.getDataType().getJavaTypeName() : sline + "; " + sp.getRefTypeInfo();
            System.out.println(sline);
        }
    }

    public static void outputBillMetas(Context ctx) {
        System.out.println("com.kingdee.eas.scm.sm.pur.app.PurOrder");
        ScmbillImportUtils.getbillMetas(ctx, "3171BFAD");
        System.out.println("com.kingdee.eas.scm.sm.pur.app.PurOrderEntry");
        ScmbillImportUtils.getbillMetas(ctx, "26041CC5");
        System.out.println("com.kingdee.eas.scm.sm.pur.app.PurOrderExpenseEntry");
        ScmbillImportUtils.getbillMetas(ctx, "D414BF47");
        System.out.println("PurRequest");
        ScmbillImportUtils.getbillMetas(ctx, "25428F2E");
        System.out.println("PurRequestEntry");
        ScmbillImportUtils.getbillMetas(ctx, "2B7DD5E4");
        System.out.println("PurRequestEntryML");
        ScmbillImportUtils.getbillMetas(ctx, "435FF683");
        System.out.println("SaleOrder");
        ScmbillImportUtils.getbillMetas(ctx, "C48A423A");
        System.out.println("SaleOrderEntry");
        ScmbillImportUtils.getbillMetas(ctx, "88882A58");
        System.out.println("TransferOrderBill");
        ScmbillImportUtils.getbillMetas(ctx, "5C2A1F0C");
        System.out.println("TransferOrderBillEntry");
        ScmbillImportUtils.getbillMetas(ctx, "ACCB80C6");
        System.out.println("StockTransferBill");
        ScmbillImportUtils.getbillMetas(ctx, "2239F30A");
        System.out.println("StockTransferBillEntry");
        ScmbillImportUtils.getbillMetas(ctx, "18167B88");
        System.out.println("PurInWarehsBill");
        ScmbillImportUtils.getbillMetas(ctx, "783061E3");
        System.out.println("PurInWarehsEntry");
        ScmbillImportUtils.getbillMetas(ctx, "8E088616");
        System.out.println("SaleIssueBill");
        ScmbillImportUtils.getbillMetas(ctx, "CC3E933B");
        System.out.println("SaleIssueEntry");
        ScmbillImportUtils.getbillMetas(ctx, "BBC07FBE");
        System.out.println("OtherInWarehsBill");
        ScmbillImportUtils.getbillMetas(ctx, "A4D04D23");
        System.out.println("OtherInWarehsBillEntry");
        ScmbillImportUtils.getbillMetas(ctx, "F56602D6");
        System.out.println("OtherIssueBill");
        ScmbillImportUtils.getbillMetas(ctx, "A4D04D24");
        System.out.println("OtherIssueBillEntry");
        ScmbillImportUtils.getbillMetas(ctx, "F56602D7");
        System.out.println("com.kingdee.eas.fi.ar.OtherBill");
        ScmbillImportUtils.getbillMetas(ctx, "FC910EF3");
        System.out.println("com.kingdee.eas.fi.ar.app.OtherBillPlan");
        ScmbillImportUtils.getbillMetas(ctx, "1EE05CBC");
        System.out.println("com.kingdee.eas.fi.ar.app.OtherBillentry");
        ScmbillImportUtils.getbillMetas(ctx, "BC91693F");
        System.out.println("com.kingdee.eas.fi.ap.app.OtherBill");
        ScmbillImportUtils.getbillMetas(ctx, "48DA3A71");
        System.out.println("com.kingdee.eas.fi.ap.app.OtherBillExpApportion");
        ScmbillImportUtils.getbillMetas(ctx, "87E4684C");
        System.out.println("com.kingdee.eas.fi.ap.app.OtherBillPlan");
        ScmbillImportUtils.getbillMetas(ctx, "838B993A");
        System.out.println("com.kingdee.eas.fi.ap.app.OtherBillentry");
        ScmbillImportUtils.getbillMetas(ctx, "ED4DBC81");
    }

    public static void setPurchasePerson(Context ctx, CoreBaseInfo info, List<String> errorMsg, String key, Object obj, String purGroupId) throws BOSException {
        PersonInfo personInfo = (PersonInfo)obj;
        String number = personInfo.getNumber();
        if (personInfo.getId() != null || number == null || number.trim().length() <= 0 || purGroupId == null) {
            return;
        }
        String mapKey = number + personInfo.getClass().toString() + purGroupId;
        if (DataInfoCache.getInstance().containsKey(mapKey)) {
            info.put(key, DataInfoCache.getInstance().get(mapKey));
            return;
        }
        IPurchasePerson ipurPerson = PurchasePersonFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("purGroup.id", (Object)purGroupId, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        PurchasePersonCollection collection = ipurPerson.getPurchasePersonCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            PurchasePersonInfo purchasePerson = collection.get(0);
            if (info != null) {
                info.put(key, (Object)purchasePerson.getPerson());
                DataInfoCache.getInstance().put(mapKey, purchasePerson.getPerson());
            }
        } else {
            info.put(key, null);
            errorMsg.add(ResourceBase.getString((String)"com.kingdee.eas.scm.ws.app.SCMWSResource", (String)"PERSON_IS_ERROR", (Locale)ctx.getLocale(), (Object[])new Object[0]));
        }
    }

    public static void setPurchaseGroup(Context ctx, CoreBaseInfo info, List<String> errorMsg, String key, Object obj, String purOrgId) throws BOSException {
        PurchaseGroupInfo purchaseGroupInfo = (PurchaseGroupInfo)obj;
        String number = purchaseGroupInfo.getNumber();
        if (purchaseGroupInfo.getId() != null || number == null || number.trim().length() <= 0 || purOrgId == null) {
            return;
        }
        String mapKey = number + purchaseGroupInfo.getClass().toString() + purOrgId;
        if (DataInfoCache.getInstance().containsKey(mapKey)) {
            info.put(key, DataInfoCache.getInstance().get(mapKey));
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("purOrg.id", (Object)purOrgId, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        PurchaseGroupCollection collection = PurchaseGroupFactory.getLocalInstance((Context)ctx).getPurchaseGroupCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            purchaseGroupInfo = collection.get(0);
            if (info != null) {
                info.put(key, (Object)purchaseGroupInfo);
                DataInfoCache.getInstance().put(mapKey, purchaseGroupInfo);
            }
        } else {
            info.put(key, null);
            errorMsg.add(ResourceBase.getString((String)"com.kingdee.eas.scm.ws.app.SCMWSResource", (String)"PURGROUP_IS_ERROR", (Locale)ctx.getLocale(), (Object[])new Object[0]));
        }
    }
}

