/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.ws.app.importbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.im.inv.StockReqCollection;
import com.kingdee.eas.scm.im.inv.StockReqEntryInfo;
import com.kingdee.eas.scm.im.inv.StockReqFactory;
import com.kingdee.eas.scm.im.inv.StockReqInfo;
import com.kingdee.eas.scm.im.inv.StockTypeEnum;
import com.kingdee.eas.scm.ws.app.importbill.ScmBillSupport;
import java.util.Date;
import java.util.List;

public class StockReqBillSupport
extends ScmBillSupport {
    @Override
    public ISCMBillBase getInterface() throws BOSException {
        return StockReqFactory.getLocalInstance((Context)this.getContext());
    }

    @Override
    public boolean isSupportSubmit() {
        return true;
    }

    @Override
    public boolean isSupportAudit() {
        return true;
    }

    @Override
    public Class getInfoClass() {
        return StockReqCollection.class;
    }

    @Override
    protected void setDefaultHeadData(SCMBillBaseInfo info, List<String> errorMsg) throws BOSException, EASBizException {
        StockReqInfo stockReqInfo = (StockReqInfo)info;
        Date bizDate = stockReqInfo.getBizDate();
        if (bizDate == null) {
            stockReqInfo.setBizDate(this.today());
        }
        BizTypeInfo bizTypeInfo = new BizTypeInfo();
        bizTypeInfo.setNumber("360");
        stockReqInfo.setBizType(bizTypeInfo);
    }

    @Override
    protected void setDefaultEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        StorageOrgUnitInfo receiveStorage;
        StockReqEntryInfo entryInfo = (StockReqEntryInfo)entryModel;
        StockReqInfo info = (StockReqInfo)model;
        StockTypeEnum stockType = entryInfo.getStockType();
        if (stockType == null) {
            entryInfo.setStockType(StockTypeEnum.STOCK);
        }
        if ((receiveStorage = entryInfo.getReceiveStorage()) == null) {
            entryInfo.setReceiveStorage(info.getReqStorage());
        }
        if (entryInfo.getDeliveryDate() == null) {
            entryInfo.setDeliveryDate(info.getBizDate());
        }
    }

    @Override
    protected void dealWithHeadData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    @Override
    protected void dealWithEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    @Override
    protected void verifyHeadData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        StockReqInfo info = (StockReqInfo)model;
        this.verifyDataInfo((DataBaseInfo)info.getReqStorage(), errorMsg, "REQORG_IS_NULL", new Object[0]);
        this.verifyDataInfo((DataBaseInfo)info.getSupplyStorage(), errorMsg, "SUPORG_IS_NULL", new Object[0]);
    }

    @Override
    protected void verifyEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        StockReqEntryInfo entryInfo = (StockReqEntryInfo)entryModel;
        this.verifyDataInfo((DataBaseInfo)entryInfo.getMaterial(), errorMsg, "MATERIAL_IS_NULL", new Object[0]);
        this.verifyDataInfo((DataBaseInfo)entryInfo.getUnit(), errorMsg, "MEASURE_UNIT_IS_NULL", new Object[0]);
        this.verifyDecimal(entryInfo.getQty(), errorMsg, "QTY_IS_NULL", null);
        this.verifyDecimal(entryInfo.getAuditQty(), errorMsg, "AUDITQTY_IS_NULL", null);
        if (StockTypeEnum.PURCHASE.equals((Object)entryInfo.getStockType())) {
            this.verifyDataInfo((DataBaseInfo)entryInfo.getPurchaseOrgUnit(), errorMsg, "PURORG_IS_NULL", new Object[0]);
        } else if (StockTypeEnum.SALE.equals((Object)entryInfo.getStockType())) {
            this.verifyDataInfo((DataBaseInfo)entryInfo.getSaleOrgUnit(), errorMsg, "SALEORG_IS_NULL", new Object[0]);
        } else if (StockTypeEnum.DIRECTDELIVERY.equals((Object)entryInfo.getStockType())) {
            this.verifyDataInfo((DataBaseInfo)entryInfo.getCustomer(), errorMsg, "CUSTOMER_IS_NULL", new Object[0]);
            this.verifyDataInfo((CoreBaseInfo)entryInfo.getSaleOrder(), errorMsg, "SALEORDER_IS_NULL", new Object[0]);
        }
    }
}

