/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.ws.app.importbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.im.inv.ISupplyRelation;
import com.kingdee.eas.scm.im.inv.SupplyRelationCollection;
import com.kingdee.eas.scm.im.inv.SupplyRelationFactory;
import com.kingdee.eas.scm.im.inv.SupplyRelationInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillCollection;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.ws.app.importbill.ScmBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.ScmbillImportUtils;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransferOrderBillSupport
extends ScmBillSupport {
    private Map<String, Object> mapSupplyRelation = new HashMap<String, Object>(0);

    @Override
    public boolean isSupportSubmit() {
        return true;
    }

    @Override
    public boolean isSupportAudit() {
        return true;
    }

    @Override
    public BatchExecuteResult getBatchExecuteResult(BatchExecuteParamsEntry[] paramEntries, Class[] batchMethod, String methodPK) throws BaseException {
        return super.getBatchExecuteResult(paramEntries, batchMethod, methodPK);
    }

    @Override
    public Class<TransferOrderBillCollection> getInfoClass() {
        return TransferOrderBillCollection.class;
    }

    @Override
    public ISCMBillBase getInterface() throws BOSException {
        return TransferOrderBillFactory.getLocalInstance((Context)this.getContext());
    }

    @Override
    protected void setDefaultHeadData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        super.setDefaultHeadData(model, errorMsg);
        TransferOrderBillInfo info = (TransferOrderBillInfo)model;
        info.setIsInitBill(false);
        BillTypeInfo billtype = new BillTypeInfo();
        billtype.setId(BOSUuid.read((String)"Eg5BUQEVEADgAAABwKgOEEY+1VI="));
        info.setBillType(billtype);
        info.setIsShipment(false);
        if (info.getExchangeRate() == null) {
            info.setExchangeRate(new BigDecimal("1.00"));
        }
    }

    @Override
    protected void setDefaultEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        super.setDefaultEntryData(entryModel, model, errorMsg);
        TransferOrderBillEntryInfo entryInfo = (TransferOrderBillEntryInfo)entryModel;
        TransferOrderBillInfo info = (TransferOrderBillInfo)model;
        this.setDefaultEntryData(entryInfo);
        this.setSupplyRelationInfo(entryInfo, info);
        entryInfo.setReceiveCompanyOrgUnit(info.getReceiptCompanyOrgUnit());
        if (entryInfo.getMaterial() != null) {
            entryInfo.setBaseUnit(entryInfo.getMaterial().getBaseUnit());
            this.setBaseQty(entryInfo, errorMsg);
        }
        this.setLoclePrice(entryInfo, info);
    }

    private void setDefaultEntryData(TransferOrderBillEntryInfo entryInfo) {
        Date issuePlanDate;
        BigDecimal actualTaxPrice;
        BigDecimal actualPrice;
        BigDecimal taxAmount;
        BigDecimal taxPrice;
        BigDecimal tax;
        BigDecimal taxRate;
        Date today = this.today();
        Date receiptPlanDate = entryInfo.getReceiptPlanDate();
        if (receiptPlanDate == null) {
            entryInfo.setReceiptPlanDate(today);
        }
        if ((taxRate = entryInfo.getTaxRate()) == null) {
            entryInfo.setTaxRate(BigDecimal.ZERO);
        }
        if ((tax = entryInfo.getTax()) == null) {
            entryInfo.setTax(BigDecimal.ZERO);
        }
        if ((taxPrice = entryInfo.getTaxPrice()) == null) {
            entryInfo.setTaxPrice(BigDecimal.ZERO);
        }
        if ((taxAmount = entryInfo.getTaxAmount()) == null) {
            entryInfo.setTaxAmount(BigDecimal.ZERO);
        }
        if ((actualPrice = entryInfo.getActualPrice()) == null) {
            entryInfo.setActualPrice(BigDecimal.ZERO);
        }
        if ((actualTaxPrice = entryInfo.getActualTaxPrice()) == null) {
            entryInfo.setActualTaxPrice(BigDecimal.ZERO);
        }
        if ((issuePlanDate = entryInfo.getIssuePlanDate()) == null) {
            entryInfo.setIssuePlanDate(today);
        }
    }

    private void setLoclePrice(TransferOrderBillEntryInfo entryInfo, TransferOrderBillInfo info) {
        BigDecimal amount = this.zero;
        BigDecimal locleAmount = this.zero;
        BigDecimal locleTax = this.zero;
        BigDecimal exchangeRate = info.getExchangeRate();
        int scale = 4;
        if (info.getCurrency() != null) {
            scale = info.getCurrency().getPrecision();
        }
        if (exchangeRate == null) {
            exchangeRate = new BigDecimal("1.00");
        }
        if (entryInfo.getAmount() != null) {
            amount = entryInfo.getAmount();
            locleAmount = amount.multiply(exchangeRate).setScale(scale, 4);
            entryInfo.setLocalAmount(locleAmount);
        }
        if (entryInfo.getTax() != null) {
            locleTax = entryInfo.getTax().multiply(exchangeRate).setScale(scale, 4);
            entryInfo.setLocalTax(locleTax);
        }
        entryInfo.setLocalTaxAmount(locleTax.add(locleAmount));
        if (entryInfo.getDiscountAmount() != null) {
            entryInfo.setLocalDiscountAmount(entryInfo.getDiscountAmount().multiply(exchangeRate).setScale(scale, 4));
        }
    }

    private void setSupplyRelationInfo(TransferOrderBillEntryInfo entryInfo, TransferOrderBillInfo info) throws EASBizException, BOSException {
        if (entryInfo.getIssueStorageOrgUnit() != null && entryInfo.getReceiveStorageOrgUnit() != null && info.getIssueStorageOrgUnit() != null && info.getReceiptStorageOrgUnit() != null) {
            String supplySouId = entryInfo.getIssueStorageOrgUnit().getId().toString();
            String reqSouId = entryInfo.getReceiveStorageOrgUnit().getId().toString();
            String issueSouId = info.getIssueStorageOrgUnit().getId().toString();
            String recSouId = info.getReceiptStorageOrgUnit().getId().toString();
            SupplyRelationInfo supplyRelationInfo = this.getSupplyRelation(supplySouId, reqSouId, issueSouId, recSouId);
            entryInfo.setSupplyRelation(supplyRelationInfo);
        }
    }

    @Override
    protected void verifyHeadData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    @Override
    protected void verifyEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        TransferOrderBillEntryInfo info = (TransferOrderBillEntryInfo)entryModel;
        this.verifyDataInfo((DataBaseInfo)info.getMaterial(), errorMsg, "MATERIAL_IS_NULL", new Object[0]);
        this.verifyDataInfo((DataBaseInfo)info.getUnit(), errorMsg, "MEASURE_UNIT_IS_NULL", new Object[0]);
        this.verifyDecimal(info.getQty(), errorMsg, "QTY_IS_NULL", "QTY_IS_ZERO");
        this.verifyDecimal(info.getPrice(), errorMsg, "PRICE_IS_NULL", "PRICE_IS_ZERO");
        this.verifyDataInfo((DataBaseInfo)info.getIssueStorageOrgUnit(), errorMsg, "ISSUE_STORAGEORG_IS_NULL", new Object[0]);
        this.verifyDataInfo((DataBaseInfo)info.getIssueSaleOrgUnit(), errorMsg, "ISSUESALEORG_IS_NULL", new Object[0]);
        this.verifyDataInfo((DataBaseInfo)info.getReceiveStorageOrgUnit(), errorMsg, "RECSTORAGEORG_IS_NULL", new Object[0]);
    }

    public SupplyRelationInfo getSupplyRelation(String supplySouId, String reqSouId, String issueSouId, String recSouId) throws EASBizException, BOSException {
        if (!this.mapSupplyRelation.containsKey(supplySouId + reqSouId + issueSouId + recSouId)) {
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("supplyStorageOrgUnit", (Object)supplySouId);
            filter.appendFilterItem("requireStorageOrgUnit", (Object)reqSouId);
            filter.appendFilterItem("issueStorageOrgUnit", (Object)issueSouId);
            filter.appendFilterItem("receiveStorageOrgUnit", (Object)recSouId);
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            view.getSelector().addObjectCollection((IObjectCollection)this.getSupplyRelationSelector());
            ISupplyRelation isr = SupplyRelationFactory.getLocalInstance((Context)this.getContext());
            SupplyRelationCollection col = isr.getSupplyRelationCollection(view);
            if (col.size() > 0 && col.get(0) != null) {
                this.mapSupplyRelation.put(supplySouId + reqSouId + issueSouId + recSouId, col.get(0));
            }
        }
        return (SupplyRelationInfo)this.mapSupplyRelation.get(supplySouId + reqSouId + issueSouId + recSouId);
    }

    private SelectorItemCollection getSupplyRelationSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("supplyStorageOrgUnit.id");
        sic.add("supplyStorageOrgUnit.name");
        sic.add("supplyStorageOrgUnit.number");
        sic.add("requireStorageOrgUnit.id");
        sic.add("requireStorageOrgUnit.name");
        sic.add("requireStorageOrgUnit.number");
        sic.add("issueStorageOrgUnit.id");
        sic.add("issueStorageOrgUnit.name");
        sic.add("issueStorageOrgUnit.number");
        sic.add("receiveStorageOrgUnit.id");
        sic.add("receiveStorageOrgUnit.name");
        sic.add("receiveStorageOrgUnit.number");
        sic.add("supplyCompanyOrgUnit.id");
        sic.add("supplyCompanyOrgUnit.name");
        sic.add("supplyCompanyOrgUnit.number");
        sic.add("requireCompanyOrgUnit.id");
        sic.add("requireCompanyOrgUnit.name");
        sic.add("requireCompanyOrgUnit.number");
        sic.add("issueCompanyOrgUnit.id");
        sic.add("issueCompanyOrgUnit.name");
        sic.add("issueCompanyOrgUnit.number");
        sic.add("receiveCompanyOrgUnit.id");
        sic.add("receiveCompanyOrgUnit.name");
        sic.add("receiveCompanyOrgUnit.number");
        return sic;
    }

    private void setBaseQty(TransferOrderBillEntryInfo entryInfo, List<String> errorMsg) throws BOSException, EASBizException {
        MaterialInfo material = entryInfo.getMaterial();
        MeasureUnitInfo unit = entryInfo.getUnit();
        MeasureUnitInfo baseunit = entryInfo.getBaseUnit();
        MultiMeasureUnitInfo mmu = ScmbillImportUtils.getMultiMeasureUnit(this.getContext(), material, unit, errorMsg);
        MultiMeasureUnitInfo basemmu = ScmbillImportUtils.getMultiMeasureUnit(this.getContext(), material, baseunit, errorMsg);
        BigDecimal qty = entryInfo.getQty();
        BigDecimal baseQty = this.zero;
        if (qty == null) {
            qty = this.zero;
        }
        if (mmu != null && basemmu != null) {
            qty = qty.setScale(mmu.getQtyPrecision(), 4);
            entryInfo.setQty(qty);
            baseQty = qty.multiply(mmu.getBaseConvsRate()).setScale(basemmu.getQtyPrecision(), 4);
        }
        entryInfo.setQty(qty);
        entryInfo.setBaseQty(baseQty);
        entryInfo.setAssociateQty(qty);
        entryInfo.setUnIssueBaseQty(qty);
        entryInfo.setArAssociateBaseQty(baseQty);
        entryInfo.setApAssociateBaseQty(baseQty);
        MeasureUnitInfo assistUnit = entryInfo.getAssistUnit();
        if (assistUnit != null) {
            BigDecimal assisqtyQty = InvAppUtils.getMultiUnitQty((Context)this.getContext(), (MeasureUnitInfo)unit, (MeasureUnitInfo)entryInfo.getAssistUnit(), (MaterialInfo)material, (BigDecimal)qty);
            entryInfo.setAssistQty(assisqtyQty);
        }
    }
}

