/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.ws.app.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.json.Kson;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MDHostType;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.access.entity.SimpleProperty;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ep.DataBaseCustomInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.ws.app.json.JSONUtils;
import com.kingdee.eas.scm.ws.app.json.MultiLangUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BosObjectTypeAdapter
implements JsonSerializer<CoreBaseInfo>,
JsonDeserializer<CoreBaseInfo> {
    public static final String DATEFORMAT = "yyyy-MM-dd HH:mm:ss";
    private Map<String, BOSObjectType> customPropBosTypeMap = new HashMap<String, BOSObjectType>();
    private String currentObjInfo = null;
    private static Map<String, Class> typeMap = new ConcurrentHashMap<String, Class>();
    private Context ctx;

    public BosObjectTypeAdapter(Context ctx) {
        this.ctx = ctx;
    }

    public CoreBaseInfo deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        Iterator iterator = jsonObject.entrySet().iterator();
        Map.Entry entry = null;
        JsonElement element = null;
        Type returnType = null;
        String typeStr = null;
        try {
            Class<?> clazz = Class.forName(type.toString().substring(type.toString().indexOf(" ") + 1));
            CoreBaseInfo objectInfo = (CoreBaseInfo)clazz.newInstance();
            if (objectInfo instanceof DataBaseCustomInfo) {
                DataBaseCustomInfo baseInfo = (DataBaseCustomInfo)objectInfo;
                if (this.currentObjInfo != null && this.customPropBosTypeMap.containsKey(this.currentObjInfo) && this.customPropBosTypeMap.get(this.currentObjInfo) != null) {
                    baseInfo.setBOSType(this.customPropBosTypeMap.get(this.currentObjInfo));
                }
            }
            EntityObjectInfo entityInfo = null;
            entityInfo = this.getEntityInfo(objectInfo.getBOSType());
            while (iterator.hasNext()) {
                Object result;
                Method method;
                SimpleDateFormat format;
                String num;
                entry = (Map.Entry)iterator.next();
                element = jsonObject.get((String)entry.getKey());
                if (element.toString().equals("") || element.toString().equals("\"\"") || element.toString().equals("\"null\"") || element.toString().equals("\"undefined\"")) {
                    objectInfo.put(((String)entry.getKey()).toString(), null);
                    continue;
                }
                Class dataType = null;
                PropertyInfo simpleProperty = entityInfo.getPropertyByNameRuntime((String)entry.getKey());
                returnType = this.getValueType(clazz, (String)entry.getKey());
                if (simpleProperty != null) {
                    dataType = this.getMetaDataType(entityInfo, simpleProperty);
                }
                if (dataType == null) {
                    String strRealValue;
                    JsonPrimitive jsonPrimitive;
                    JsonElement extendPropValue = jsonObject.get((String)entry.getKey());
                    Object realValue = null;
                    realValue = extendPropValue.isJsonPrimitive() ? ((jsonPrimitive = (JsonPrimitive)extendPropValue).isNumber() ? extendPropValue.getAsBigDecimal() : (jsonPrimitive.isBoolean() ? Boolean.valueOf(extendPropValue.getAsBoolean()) : ((strRealValue = extendPropValue.getAsString()).startsWith("{") && strRealValue.endsWith("}") ? Kson.getGson().fromJson(strRealValue, HashMap.class) : (strRealValue.equalsIgnoreCase("true") ? Boolean.TRUE : (strRealValue.equalsIgnoreCase("false") ? Boolean.FALSE : strRealValue))))) : (extendPropValue.isJsonObject() ? context.deserialize(extendPropValue, HashMap.class) : extendPropValue.toString());
                    objectInfo.put((String)entry.getKey(), realValue);
                    continue;
                }
                if (returnType == null) {
                    returnType = dataType;
                }
                if (element.isJsonNull()) continue;
                if (this.asSubClass(dataType, String.class)) {
                    if (MultiLangUtils.isMultiLangEntityProperty(this.ctx, objectInfo.getBOSType(), (String)entry.getKey())) {
                        JsonObject jsonValue = null;
                        if (element.isJsonObject()) {
                            jsonValue = element.getAsJsonObject();
                            for (Map.Entry entity : jsonValue.entrySet()) {
                                String key = (String)entity.getKey();
                                Object value = entity.getValue();
                                value = !(value instanceof JsonNull) ? ((JsonPrimitive)value).getAsString() : null;
                                Locale locale = LocaleUtils.getLocale((String)key);
                                if (this.ctx.getLocale().equals(locale)) {
                                    objectInfo.put((String)entry.getKey(), value);
                                }
                                objectInfo.put((String)entry.getKey(), value, locale);
                            }
                            continue;
                        }
                        String strMultiLangValue = element.getAsString();
                        if (MultiLangUtils.isMultiLangValueFormat(strMultiLangValue)) {
                            HashMap multiLangPartValue = JSONUtils.convertJsonToObject(this.ctx, strMultiLangValue);
                            for (String key : multiLangPartValue.keySet()) {
                                Object value = multiLangPartValue.get(key);
                                if (value != null) {
                                    objectInfo.put((String)entry.getKey(), value, LocaleUtils.getLocale((String)key));
                                    continue;
                                }
                                objectInfo.put((String)entry.getKey(), null, LocaleUtils.getLocale((String)key));
                            }
                            continue;
                        }
                        objectInfo.put((String)entry.getKey(), (Object)strMultiLangValue);
                        continue;
                    }
                    objectInfo.put((String)entry.getKey(), (Object)element.getAsString());
                    continue;
                }
                if (this.asSubClass(dataType, Boolean.class)) {
                    try {
                        if (element.getAsInt() != 0) {
                            objectInfo.put((String)entry.getKey(), (Object)true);
                            continue;
                        }
                        objectInfo.put((String)entry.getKey(), (Object)false);
                    }
                    catch (NumberFormatException exception) {
                        objectInfo.put((String)entry.getKey(), (Object)element.getAsBoolean());
                    }
                    continue;
                }
                if (this.asSubClass(dataType, Integer.class)) {
                    num = element.getAsString();
                    if (num.indexOf(".") >= 0) {
                        num = num.substring(0, num.indexOf("."));
                    }
                    objectInfo.put((String)entry.getKey(), (Object)num);
                    continue;
                }
                if (this.asSubClass(dataType, Long.class)) {
                    num = element.getAsString();
                    if (num.indexOf(".") >= 0) {
                        num = num.substring(0, num.indexOf("."));
                    }
                    objectInfo.put((String)entry.getKey(), (Object)num);
                    continue;
                }
                if (this.asSubClass(dataType, Float.class)) {
                    objectInfo.put((String)entry.getKey(), (Object)Float.valueOf(element.getAsFloat()));
                    continue;
                }
                if (this.asSubClass(dataType, Double.class)) {
                    objectInfo.put((String)entry.getKey(), (Object)element.getAsDouble());
                    continue;
                }
                if (this.asSubClass(dataType, BigDecimal.class)) {
                    objectInfo.put((String)entry.getKey(), (Object)element.getAsBigDecimal());
                    continue;
                }
                if (this.asSubClass(dataType, Timestamp.class)) {
                    format = new SimpleDateFormat(DATEFORMAT);
                    objectInfo.put((String)entry.getKey(), (Object)format.parse(element.getAsString()));
                    continue;
                }
                if (this.asSubClass(dataType, Date.class)) {
                    format = new SimpleDateFormat("yyyy-MM-dd");
                    objectInfo.put((String)entry.getKey(), (Object)format.parse(element.getAsString()));
                    continue;
                }
                if (this.asSubClass(dataType, BOSUuid.class)) {
                    if (element.getAsString() == null || element.getAsString().equals("")) continue;
                    objectInfo.put((String)entry.getKey(), (Object)BOSUuid.read((String)element.getAsString()));
                    continue;
                }
                if (this.asSubClass(dataType, IObjectCollection.class)) {
                    IObjectCollection objectCollection = (IObjectCollection)objectInfo.get((String)entry.getKey());
                    if (!element.isJsonArray()) continue;
                    JsonArray jsonArray = element.getAsJsonArray();
                    for (int nIndex = 0; nIndex < jsonArray.size(); ++nIndex) {
                        objectCollection.addObject((IObjectValue)this.deserialize(jsonArray.get(nIndex), this.getEntryValueType(objectCollection), context));
                    }
                    continue;
                }
                if (this.asSubClass(dataType, CoreBaseInfo.class)) {
                    this.setCurrentObjInfo((String)entry.getKey());
                    objectInfo.put((String)entry.getKey(), (Object)this.deserialize(element, returnType, context));
                    continue;
                }
                if (this.asSubClass(dataType, IntEnum.class)) {
                    method = dataType.getMethod("getEnum", Integer.TYPE);
                    result = null;
                    String num2 = null;
                    if (element.isJsonObject()) {
                        num2 = element.getAsJsonObject().get("value").toString();
                        if (num2.indexOf(".") >= 0) {
                            num2 = num2.substring(0, num2.indexOf("."));
                        }
                        result = method.invoke((Object)dataType, Integer.parseInt(num2));
                    } else {
                        num2 = element.getAsString();
                        if (num2.indexOf(".") >= 0) {
                            num2 = num2.substring(0, num2.indexOf("."));
                        }
                        result = method.invoke((Object)dataType, Integer.parseInt(num2));
                    }
                    objectInfo.put((String)entry.getKey(), result);
                    continue;
                }
                if (this.asSubClass(dataType, StringEnum.class)) {
                    method = dataType.getMethod("getEnum", String.class);
                    result = null;
                    result = element.isJsonObject() ? method.invoke((Object)dataType, element.getAsJsonObject().get("value").getAsString()) : method.invoke((Object)dataType, element.getAsString());
                    objectInfo.put((String)entry.getKey(), result);
                    continue;
                }
                if (this.asSubClass(dataType, DynamicEnum.class)) {
                    if (!(simpleProperty instanceof OwnPropertyInfo)) continue;
                    DynamicEnum result2 = null;
                    result2 = element.isJsonObject() ? DynamicEnum.getEnum((String)((OwnPropertyInfo)simpleProperty).getMetaDataRef(), (Object)element.getAsJsonObject().get("value").getAsString()) : DynamicEnum.getEnum((String)((OwnPropertyInfo)simpleProperty).getMetaDataRef(), (Object)element.getAsString());
                    objectInfo.put((String)entry.getKey(), (Object)result2.getValue());
                    continue;
                }
                if (this.asSubClass(dataType, FloatEnum.class)) {
                    method = dataType.getMethod("getEnum", Float.TYPE);
                    result = null;
                    result = element.isJsonObject() ? method.invoke((Object)dataType, Float.valueOf(element.getAsJsonObject().get("value").getAsFloat())) : method.invoke((Object)dataType, Float.valueOf(element.getAsFloat()));
                    objectInfo.put((String)entry.getKey(), result);
                    continue;
                }
                if (!this.asSubClass(dataType, DoubleEnum.class)) continue;
                method = dataType.getMethod("getEnum", Double.TYPE);
                result = null;
                result = element.isJsonObject() ? method.invoke((Object)dataType, Float.valueOf(element.getAsJsonObject().get("value").getAsFloat())) : method.invoke((Object)dataType, element.getAsDouble());
                objectInfo.put((String)entry.getKey(), result);
            }
            return objectInfo;
        }
        catch (Exception uoe) {
            if (!(uoe instanceof JsonParseException)) {
                String err = ResourceBase.getString((String)"com.kingdee.eas.scm.ws.WS2ARAPResource", (String)"010_RESOURCE", (Locale)this.ctx.getLocale());
                if (entry != null) {
                    err = err + ResourceBase.getString((String)"com.kingdee.eas.scm.ws.WS2ARAPResource", (String)"010_RESOURCE", (Locale)this.ctx.getLocale(), (Object[])new Object[]{entry.getKey(), entry.getValue()});
                }
                if (typeStr != null) {
                    err = err + ResourceBase.getString((String)"com.kingdee.eas.scm.ws.WS2ARAPResource", (String)"011_RESOURCE", (Locale)this.ctx.getLocale()) + typeStr;
                }
                throw new JsonParseException(err);
            }
            throw (JsonParseException)uoe;
        }
    }

    private EntityObjectInfo getEntityInfo(BOSObjectType bosType) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entityInfo = loader.getEntity(bosType);
        return entityInfo;
    }

    private boolean asSubClass(Class source, Class desc) {
        try {
            Class result = source.asSubclass(desc);
            if (result == null) {
                return false;
            }
        }
        catch (Exception exeption) {
            return false;
        }
        return true;
    }

    private Type getValueType(Class clazz, String property) {
        if (clazz == null) {
            return null;
        }
        try {
            String strMethod = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
            String strMethodByBoolean = "is" + property.substring(0, 1).toUpperCase() + property.substring(1);
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equalsIgnoreCase(strMethod) && !method.getName().equalsIgnoreCase(strMethodByBoolean)) continue;
                return method.getGenericReturnType();
            }
            return this.getValueType(clazz.getSuperclass(), property);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private String getCustomizedValueType(Context ctx, BOSObjectType bosObjectType, String property) {
        try {
            EntitySelect select = new EntitySelect(bosObjectType);
            select.propertySelect().select(property, "dataType");
            SimpleEntity entity = MetaDataAccessFactory.getLocalInstance((Context)ctx).select(select);
            SimpleProperty propertyObject = entity.property(property);
            if (propertyObject != null) {
                IMetaDataLoader loader;
                EntityObjectInfo entityinfo;
                PropertyInfo propInfo;
                if (propertyObject.isOwnProperty()) {
                    String strDataType = propertyObject.getDataType().getJavaTypeName();
                    strDataType = propertyObject.getDataType() == DataType.OBJECTVALUE ? propertyObject.getRefTypeInfo() : (propertyObject.getDataType() == DataType.ENUM ? propertyObject.getRefTypeInfo() : (propertyObject.getDataType() == DataType.STRING ? "java.lang.String" : (propertyObject.getDataType() == DataType.INTEGER ? "java.lang.Integer" : (propertyObject.getDataType() == DataType.FLOAT ? "java.lang.Float" : (propertyObject.getDataType() == DataType.DOUBLE ? "java.lang.Double" : (propertyObject.getDataType() == DataType.BOOLEAN ? "java.lang.Boolean" : propertyObject.getDataType().getJavaTypeName()))))));
                    return strDataType;
                }
                if (!this.customPropBosTypeMap.containsKey(property) && (propInfo = (entityinfo = (loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx)).getEntity(bosObjectType)).getPropertyByName(property)) instanceof LinkPropertyInfo) {
                    LinkPropertyInfo lpi = (LinkPropertyInfo)propInfo;
                    EntityObjectInfo doi = lpi.getRelationship().getSupplierObject();
                    this.customPropBosTypeMap.put(property, new BOSObjectType(doi.get("bosType").toString()));
                }
                return propertyObject.getRefTypeInfo();
            }
        }
        catch (BOSException exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private Type getEntryValueType(IObjectCollection collection) {
        Class<?> returnType = null;
        String collectionClassName = collection.getClass().getName();
        String entryInfoClassName = collectionClassName.substring(0, collectionClassName.indexOf("Collection"));
        entryInfoClassName = entryInfoClassName + "Info";
        try {
            returnType = Class.forName(entryInfoClassName);
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
        return returnType;
    }

    private Object getObjectValue(Object object, Class objectClass, String property) {
        if (object == null) {
            return null;
        }
        try {
            String strMethod = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
            String strMethodByBoolean = "is" + property.substring(0, 1).toUpperCase() + property.substring(1);
            for (Method method : objectClass.getMethods()) {
                if (!method.getName().equalsIgnoreCase(strMethod) && !method.getName().equalsIgnoreCase(strMethodByBoolean)) continue;
                return method.invoke(object, null);
            }
            return this.getObjectValue(object, objectClass.getSuperclass(), property);
        }
        catch (Exception e) {
            return null;
        }
    }

    public JsonElement serialize(CoreBaseInfo objectValue, Type type, JsonSerializationContext context) {
        JsonPrimitive jsonElement = null;
        if (objectValue == null) {
            return null;
        }
        try {
            jsonElement = new JsonPrimitive(this.convertInfoToJson(objectValue));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jsonElement;
    }

    private String convertInfoToJson(CoreBaseInfo objectValue) throws BOSException {
        String jsonBuffer = "";
        Class<?> objectClazz = objectValue.getClass();
        CoreBaseInfo tempObjectInfo = null;
        try {
            tempObjectInfo = (CoreBaseInfo)objectClazz.newInstance();
            jsonBuffer = jsonBuffer + "${leftbracket_2312415321232}";
            Enumeration enumeration = objectValue.keys();
            while (enumeration.hasMoreElements()) {
                SimpleDateFormat format;
                Type returnType;
                String key = (String)enumeration.nextElement();
                String realKey = this.getRealByEntity(objectValue.getClass(), key);
                if (realKey == null) continue;
                realKey = "${quote_2312415321232}" + realKey + "${quote_2312415321232}";
                Object value = objectValue.get(key);
                if (value == null || (returnType = this.getValueType(objectValue.getClass(), key)) == null) continue;
                String typeStr = returnType.toString().substring(returnType.toString().indexOf(" ") + 1);
                if (typeStr.equals("int")) {
                    typeStr = "java.lang.Integer";
                } else if (typeStr.equals("float")) {
                    typeStr = "java.lang.Float";
                } else if (typeStr.equals("double")) {
                    typeStr = "java.lang.Double";
                } else if (typeStr.equals("boolean")) {
                    typeStr = "java.lang.Boolean";
                }
                Class<?> dataType = Class.forName(typeStr);
                if (this.asSubClass(dataType, String.class)) {
                    if (MultiLangUtils.isMultiLangEntityProperty(this.ctx, objectValue.getBOSType(), key)) {
                        jsonBuffer = jsonBuffer + realKey + ":" + "${leftbracket_2312415321232}";
                        jsonBuffer = objectValue.get(key, LocaleUtils.locale_l1) != null ? jsonBuffer + "${quote_2312415321232}" + LocaleUtils.locale_l1.getDisplayName() + "${quote_2312415321232}" + ":" + "${quote_2312415321232}" + objectValue.get(key, LocaleUtils.locale_l1) + "${quote_2312415321232}" + "," : jsonBuffer + "${quote_2312415321232}" + LocaleUtils.locale_l1.getDisplayName() + "${quote_2312415321232}" + ":null,";
                        jsonBuffer = objectValue.get(key, LocaleUtils.locale_l2) != null ? jsonBuffer + "${quote_2312415321232}" + LocaleUtils.locale_l2.getDisplayName() + "${quote_2312415321232}" + ":" + "${quote_2312415321232}" + objectValue.get(key, LocaleUtils.locale_l2) + "${quote_2312415321232}" + "," : jsonBuffer + "${quote_2312415321232}" + LocaleUtils.locale_l2.getDisplayName() + "${quote_2312415321232}" + ":null,";
                        jsonBuffer = objectValue.get(key, LocaleUtils.locale_l3) != null ? jsonBuffer + "${quote_2312415321232}" + LocaleUtils.locale_l3.getDisplayName() + "${quote_2312415321232}" + ":" + "${quote_2312415321232}" + objectValue.get(key, LocaleUtils.locale_l3) + "${quote_2312415321232}" : jsonBuffer + "${quote_2312415321232}" + LocaleUtils.locale_l3.getDisplayName() + "${quote_2312415321232}" + ":null";
                        jsonBuffer = jsonBuffer + "${rightbracket_2312415321232}";
                    } else {
                        jsonBuffer = jsonBuffer + realKey + ":" + "${quote_2312415321232}" + value.toString() + "${quote_2312415321232}";
                    }
                } else if (this.asSubClass(dataType, Number.class)) {
                    jsonBuffer = jsonBuffer + realKey + ":" + value.toString();
                } else if (this.asSubClass(dataType, CoreBaseInfo.class)) {
                    jsonBuffer = jsonBuffer + realKey + ":" + this.convertInfoToJson((CoreBaseInfo)value);
                } else if (this.asSubClass(dataType, Boolean.class)) {
                    jsonBuffer = jsonBuffer + realKey + ":" + value;
                } else if (this.asSubClass(dataType, IObjectCollection.class)) {
                    IObjectCollection objectCollection = (IObjectCollection)value;
                    jsonBuffer = jsonBuffer + realKey + ":[";
                    for (int nIndex = 0; nIndex < objectCollection.size(); ++nIndex) {
                        IObjectValue entryObject = objectCollection.getObject(nIndex);
                        jsonBuffer = jsonBuffer + this.convertInfoToJson((CoreBaseInfo)entryObject);
                        if (nIndex >= objectCollection.size() - 1) continue;
                        jsonBuffer = jsonBuffer + ",";
                    }
                    jsonBuffer = jsonBuffer + "]";
                } else if (this.asSubClass(dataType, Enum.class)) {
                    Enum result = (Enum)this.getObjectValue(objectValue, objectValue.getClass(), key);
                    if (result == null) continue;
                    jsonBuffer = jsonBuffer + realKey + ":";
                    jsonBuffer = jsonBuffer + "{";
                    jsonBuffer = jsonBuffer + "${quote_2312415321232}isenum${quote_2312415321232}:true,";
                    if (this.asSubClass(dataType, IntEnum.class)) {
                        String strAlias = null;
                        strAlias = this.ctx.getLocale().equals(LocaleUtils.locale_l1) ? ((IntEnum)result).getName() : ((IntEnum)result).getAlias(this.ctx.getLocale());
                        jsonBuffer = jsonBuffer + "${quote_2312415321232}alias${quote_2312415321232}:${quote_2312415321232}" + strAlias + "${quote_2312415321232}" + ",";
                        jsonBuffer = jsonBuffer + "${quote_2312415321232}value${quote_2312415321232}:" + ((IntEnum)result).getValue();
                    } else if (this.asSubClass(dataType, FloatEnum.class)) {
                        String strAlias = null;
                        strAlias = this.ctx.getLocale().equals(LocaleUtils.locale_l1) ? ((FloatEnum)result).getName() : ((FloatEnum)result).getAlias(this.ctx.getLocale());
                        jsonBuffer = jsonBuffer + "${quote_2312415321232}alias${quote_2312415321232}:${quote_2312415321232}" + strAlias + "${quote_2312415321232}" + ",";
                        jsonBuffer = jsonBuffer + "${quote_2312415321232}value${quote_2312415321232}:" + ((FloatEnum)result).getValue();
                    } else if (this.asSubClass(dataType, DoubleEnum.class)) {
                        String strAlias = null;
                        strAlias = this.ctx.getLocale().equals(LocaleUtils.locale_l1) ? ((DoubleEnum)result).getName() : ((DoubleEnum)result).getAlias(this.ctx.getLocale());
                        jsonBuffer = jsonBuffer + "${quote_2312415321232}alias${quote_2312415321232}:${quote_2312415321232}" + strAlias + "${quote_2312415321232}" + ",";
                        jsonBuffer = jsonBuffer + "${quote_2312415321232}value${quote_2312415321232}:" + ((DoubleEnum)result).getValue();
                    } else if (this.asSubClass(dataType, StringEnum.class)) {
                        String strAlias = null;
                        strAlias = this.ctx.getLocale().equals(LocaleUtils.locale_l1) ? ((StringEnum)result).getName() : ((StringEnum)result).getAlias(this.ctx.getLocale());
                        jsonBuffer = jsonBuffer + "${quote_2312415321232}alias${quote_2312415321232}:${quote_2312415321232}" + strAlias + "${quote_2312415321232}" + ",";
                        jsonBuffer = jsonBuffer + "${quote_2312415321232}value${quote_2312415321232}:${quote_2312415321232}" + ((StringEnum)result).getValue() + "${quote_2312415321232}";
                    }
                    jsonBuffer = jsonBuffer + "}";
                } else if (this.asSubClass(dataType, BOSUuid.class)) {
                    jsonBuffer = jsonBuffer + realKey + ":" + "${quote_2312415321232}" + value.toString() + "${quote_2312415321232}";
                } else if (this.asSubClass(dataType, Timestamp.class)) {
                    format = new SimpleDateFormat(DATEFORMAT);
                    jsonBuffer = value instanceof String ? jsonBuffer + realKey + ":" + "${quote_2312415321232}" + value + "${quote_2312415321232}" : jsonBuffer + realKey + ":" + "${quote_2312415321232}" + format.format((Date)value) + "${quote_2312415321232}";
                } else if (this.asSubClass(dataType, Date.class)) {
                    format = new SimpleDateFormat(DATEFORMAT);
                    jsonBuffer = value instanceof String ? jsonBuffer + realKey + ":" + "${quote_2312415321232}" + value + "${quote_2312415321232}" : jsonBuffer + realKey + ":" + "${quote_2312415321232}" + format.format((Date)value) + "${quote_2312415321232}";
                } else {
                    jsonBuffer = jsonBuffer + realKey + ":" + "${quote_2312415321232}" + value.toString() + "${quote_2312415321232}";
                }
                if (!enumeration.hasMoreElements()) continue;
                jsonBuffer = jsonBuffer + ",";
            }
            if (jsonBuffer.trim().endsWith(",")) {
                jsonBuffer = jsonBuffer.substring(0, jsonBuffer.length() - 1);
            }
            jsonBuffer = jsonBuffer + "${rightbracket_2312415321232}";
        }
        catch (Exception exception) {
            throw new BOSException((Throwable)exception);
        }
        return jsonBuffer.toString();
    }

    private String getRealByEntity(Class clazz, String property) {
        if (clazz == null || property == null || property.equals("")) {
            return null;
        }
        Method[] methods = clazz.getDeclaredMethods();
        String strOldKey = "get" + property;
        String strOldKeyByBoolean = "is" + property;
        for (Method method : methods) {
            if (method.getName().equalsIgnoreCase(strOldKey)) {
                String fieldName = method.getName().substring(3);
                return fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
            }
            if (!method.getName().equalsIgnoreCase(strOldKeyByBoolean)) continue;
            String fieldName = method.getName().substring(2);
            return fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
        }
        return this.getRealByEntity(clazz.getSuperclass(), property);
    }

    public String getCurrentObjInfo() {
        return this.currentObjInfo;
    }

    public void setCurrentObjInfo(String currentObjInfo) {
        this.currentObjInfo = currentObjInfo;
    }

    private Class getMetaDataType(EntityObjectInfo parentEntityInfo, PropertyInfo propertyInfo) {
        long s1 = System.currentTimeMillis();
        Class type = null;
        if (propertyInfo instanceof OwnPropertyInfo) {
            OwnPropertyInfo ownP = (OwnPropertyInfo)propertyInfo;
            DataType dataType = ownP.getDataType();
            type = dataType.equals((Object)DataType.STRING) ? String.class : (dataType.equals((Object)DataType.INTEGER) ? Integer.class : (dataType.equals((Object)DataType.FLOAT) ? Float.class : (dataType.equals((Object)DataType.DOUBLE) ? Double.class : (dataType.equals((Object)DataType.BOOLEAN) ? Boolean.class : (dataType.equals((Object)DataType.ENUM) ? (ownP.getEnumType(MDHostType.RUNTIME) == null || ownP.getEnumType(MDHostType.RUNTIME).isDynamic() ? DynamicEnum.class : this.getClass(ownP.getEnumType(MDHostType.RUNTIME).getFullName())) : this.getClass(dataType.getJavaTypeName()))))));
        } else if (propertyInfo instanceof LinkPropertyInfo) {
            LinkPropertyInfo linkP = (LinkPropertyInfo)propertyInfo;
            RelationshipInfo ri = linkP.getRelationship();
            String strDataType = null;
            EntityObjectInfo childInfo = ri.getChildObject(parentEntityInfo);
            CardinalityType cardType = ri.getChildCardinality(parentEntityInfo);
            strDataType = CardinalityType.isUnbounded((CardinalityType)cardType) ? childInfo.getObjectCollectionClass() : childInfo.getObjectValueClass();
            type = this.getClass(strDataType);
        }
        return type;
    }

    private Class getClass(String className) {
        Class<?> type = typeMap.get(className);
        if (type == null) {
            try {
                type = Class.forName(className);
                if (className != null && type != null) {
                    typeMap.put(className, type);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return type;
    }
}

