/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.ws.app.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.ws.app.json.BOSUuidTypeAdapter;
import com.kingdee.eas.scm.ws.app.json.BosObjectCollectionTypeAdapter;
import com.kingdee.eas.scm.ws.app.json.BosObjectTypeAdapter;
import com.kingdee.eas.scm.ws.app.json.DateTypeAdapter;
import com.kingdee.eas.scm.ws.app.json.EnumTypeAdapter;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class JSONUtils {
    protected static Logger logger = Logger.getLogger(JSONUtils.class);
    protected static final String QUOTES_PREFIX = "${quote_2312415321232}";
    protected static final String LEFT_BRACKETS_PREFIX = "${leftbracket_2312415321232}";
    protected static final String RIGHT_BRACKETS_PREFIX = "${rightbracket_2312415321232}";

    public static String convertObjectToJson(Context ctx, Object object) throws BOSException {
        if (object == null || object.equals("")) {
            return "\"\"";
        }
        Gson gson = JSONUtils.getGson(ctx);
        String result = gson.toJson(object);
        if (result == null) {
            return "\"\"";
        }
        result = JSONUtils.processJsonResult(result);
        return result;
    }

    public static String processJsonResult(String result) {
        result = result.replace(QUOTES_PREFIX, "\"");
        result = result.replace("\"${leftbracket_2312415321232}", "{");
        result = result.replace(LEFT_BRACKETS_PREFIX, "{");
        result = result.replace("${rightbracket_2312415321232}\"", "}");
        result = result.replace(RIGHT_BRACKETS_PREFIX, "}");
        return result;
    }

    public static Object convertJsonToObject(Context ctx, String json, Class clz) throws BOSException {
        Gson gson = JSONUtils.getGson(ctx);
        return gson.fromJson(json, clz);
    }

    public static HashMap convertJsonToObject(Context ctx, String json) throws BOSException {
        Gson gson = JSONUtils.getGson(ctx);
        return (HashMap)gson.fromJson(json.toString(), HashMap.class);
    }

    public static String encodeJson(String json) throws BOSException {
        StringBuilder encodedJson = new StringBuilder();
        for (int i = 0; i < json.length(); ++i) {
            char c = json.charAt(i);
            if (c > '\u007f') {
                encodedJson.append("\\u").append(Integer.toHexString(c));
                continue;
            }
            encodedJson.append(c);
        }
        return encodedJson.toString();
    }

    public static Gson getGson(Context ctx) {
        GsonBuilder builder = new GsonBuilder();
        builder.serializeNulls();
        builder.serializeSpecialFloatingPointValues();
        builder.registerTypeHierarchyAdapter(Date.class, (Object)new DateTypeAdapter());
        builder.registerTypeHierarchyAdapter(Timestamp.class, (Object)new DateTypeAdapter());
        builder.registerTypeHierarchyAdapter(BOSUuid.class, (Object)new BOSUuidTypeAdapter());
        builder.registerTypeHierarchyAdapter(CoreBaseInfo.class, (Object)new BosObjectTypeAdapter(ctx));
        builder.registerTypeHierarchyAdapter(IObjectCollection.class, (Object)new BosObjectCollectionTypeAdapter(ctx));
        builder.registerTypeHierarchyAdapter(OrgUnitInfo.class, (Object)new BosObjectTypeAdapter(ctx));
        builder.registerTypeHierarchyAdapter(BizEnumValueDTO.class, (Object)new EnumTypeAdapter(ctx));
        builder.registerTypeHierarchyAdapter(Enum.class, (Object)new EnumTypeAdapter(ctx));
        return builder.create();
    }
}

