/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.sem.mp.CSFCollection;
import com.kingdee.eas.sem.mp.CSFFactory;
import com.kingdee.eas.sem.mp.CSFInfo;
import com.kingdee.eas.sem.mp.ICSF;
import com.kingdee.eas.sem.mp.IKPI;
import com.kingdee.eas.sem.mp.IKPIValueRefStandardValue;
import com.kingdee.eas.sem.mp.IRefGroup;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPIValueCollection;
import com.kingdee.eas.sem.mp.KPIValueInfo;
import com.kingdee.eas.sem.mp.KPIValueRefStandardValueFactory;
import com.kingdee.eas.sem.mp.KPIValueRefStandardValueInfo;
import com.kingdee.eas.sem.mp.KPIWarnParamCollection;
import com.kingdee.eas.sem.mp.KPIWarnParamInfo;
import com.kingdee.eas.sem.mp.RefGroupCollection;
import com.kingdee.eas.sem.mp.RefGroupFactory;
import com.kingdee.eas.sem.mp.RefGroupInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class AssignKPIHandle {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.sem.mp.app.AssignKPIHandle");

    protected List assignDataToChild(Context ctx, List kpis, OrgUnitInfo parentAOU, Set companys) throws EASBizException, BOSException {
        ArrayList<String> resultList = new ArrayList<String>();
        if (kpis == null || kpis.size() <= 0) {
            resultList.add("\u672a\u9009\u62e9\u9700\u8981\u5206\u914d\u7684kpi\uff01");
            return resultList;
        }
        if (parentAOU == null) {
            resultList.add("\u6e90\u516c\u53f8\u4e3a\u7a7a");
            return resultList;
        }
        if (companys == null || companys.size() <= 0) {
            resultList.add("\u672a\u9009\u62e9\u9700\u8981\u5206\u914d\u5230\u7684\u7ec4\u7ec7\uff01");
            return resultList;
        }
        Iterator ite = kpis.iterator();
        KPIInfo tempInfo = null;
        while (ite.hasNext()) {
            tempInfo = KPIFactory.getLocalInstance(ctx).getKPIInfo((IObjectPK)new ObjectUuidPK(ite.next().toString()));
            this.assignDataToChild(ctx, tempInfo, parentAOU, companys, resultList);
        }
        return resultList;
    }

    private void assignDataToChild(Context ctx, KPIInfo kpiInfo, OrgUnitInfo parentAOU, Set companys, List resultList) {
        AdminOrgUnitCollection aouCols = this.getCurrentAOUChilds(ctx, parentAOU, companys);
        if (aouCols != null) {
            for (AdminOrgUnitInfo childAOU : aouCols) {
                this.assignDataToChild(ctx, kpiInfo, parentAOU, childAOU, companys, resultList);
            }
        } else {
            resultList.add(parentAOU.getName() + "\u7684\u76f4\u63a5\u4e0b\u7ea7\u7ec4\u7ec7\u6570\u4e3a\u96f6");
        }
    }

    private void assignDataToChild(Context ctx, KPIInfo parentKpi, OrgUnitInfo parentAdminOrg, AdminOrgUnitInfo childAdminOrg, Set companys, List resultList) {
        KPIInfo tempParentKpi = null;
        try {
            CSFInfo relatedCSFInfo = null;
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            selector.add("kpiValue.*");
            selector.add("kpiValue.warnparam.*");
            selector.add("csf.*");
            selector.add("csf.BSC.*");
            selector.add("measureUnit.*");
            selector.add("edgeGroup.*");
            IKPI iKpi = null;
            ICSF icsf = null;
            boolean hasHandleStandardValue = false;
            icsf = CSFFactory.getLocalInstance(ctx);
            iKpi = KPIFactory.getLocalInstance(ctx);
            ObjectUuidPK tempPk = new ObjectUuidPK(parentKpi.getId());
            KPIInfo kpiInfo = iKpi.getKPIInfo((IObjectPK)tempPk, selector);
            KPIInfo tempKpiInfo = this.getChildKpiInfo(ctx, iKpi, parentKpi.getId().toString(), childAdminOrg.getId());
            if (tempKpiInfo != null) {
                resultList.add(childAdminOrg.getName() + "had import the kpi:" + kpiInfo.getName());
                tempParentKpi = tempKpiInfo;
            } else {
                KPIValueCollection valueCols;
                this.handleRefGroup(ctx, childAdminOrg, parentAdminOrg);
                hasHandleStandardValue = true;
                KPIInfo newKpiInfo = (KPIInfo)kpiInfo.clone();
                String tempNumber = kpiInfo.getNumber() + "-" + childAdminOrg.getNumber();
                newKpiInfo.setNumber(tempNumber);
                newKpiInfo.setLongNumber(kpiInfo.getLongNumber() + "!" + tempNumber);
                newKpiInfo.setId(null);
                newKpiInfo.setParent(kpiInfo);
                newKpiInfo.setCompany(childAdminOrg);
                KPIValueCollection tempValueCols = newKpiInfo.getKpiValue();
                tempValueCols.clear();
                KPIValueInfo valueInfo = this.getKpiValue(kpiInfo.getKpiValue());
                KPIValueInfo tempValueInfo = this.cloneKpiValueInfo(valueInfo);
                tempValueInfo.setParentId(valueInfo.getId().toString());
                String tempNumber1 = valueInfo.getNumber() + childAdminOrg.getNumber();
                tempValueInfo.setId(null);
                tempValueInfo.setNumber(tempNumber1);
                tempValueInfo.setLongnumber(valueInfo.getLongnumber() + "!" + tempNumber1);
                KPIWarnParamCollection warnCols = valueInfo.getWarnparam();
                if (warnCols != null && warnCols.size() > 0) {
                    KPIWarnParamCollection wCols = tempValueInfo.getWarnparam();
                    wCols.clear();
                    int n = warnCols.size();
                    for (int j = 0; j < n; ++j) {
                        KPIWarnParamInfo paramInfo = (KPIWarnParamInfo)warnCols.get(j).clone();
                        paramInfo.setId(null);
                        paramInfo.setKpiValue(tempValueInfo);
                        paramInfo.setParamValue(this.getNewParamValue(ctx, paramInfo.getParamValue(), childAdminOrg));
                        wCols.add(paramInfo);
                    }
                }
                tempValueCols.add(tempValueInfo);
                relatedCSFInfo = kpiInfo.getCsf();
                if (relatedCSFInfo != null) {
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)childAdminOrg.getId().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)relatedCSFInfo.getNumber()));
                    filter.getFilterItems().add(new FilterItemInfo("name", (Object)relatedCSFInfo.getName()));
                    filter.setMaskString(" ( #0 and (#1 or #2)) ");
                    ev.setFilter(filter);
                    CSFCollection csfCols = icsf.getCSFCollection(ev);
                    if (csfCols != null && csfCols.size() > 0) {
                        CSFInfo tempCsfInfo = csfCols.get(0);
                        newKpiInfo.setCsf(tempCsfInfo);
                    } else {
                        HashMap<String, Object> orgMap = new HashMap<String, Object>();
                        orgMap.put("currentAdminOrg", childAdminOrg);
                        orgMap.put("parentAdminOrg", parentAdminOrg);
                        List tempList = icsf.importDataFromParent(new IObjectPK[]{new ObjectUuidPK(relatedCSFInfo.getId())}, orgMap);
                        if (tempList != null && tempList.size() > 0) {
                            String newCsfId = tempList.get(0).toString();
                            CSFInfo tempCsfInfo = icsf.getCSFInfo((IObjectPK)new ObjectUuidPK(newCsfId));
                            newKpiInfo.setCsf(tempCsfInfo);
                        }
                    }
                }
                IObjectPK tempKpi = iKpi.addnew((CoreBaseInfo)newKpiInfo);
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add(new SelectorItemInfo("id"));
                selectors.add(new SelectorItemInfo("kpiValue.id"));
                tempParentKpi = newKpiInfo = KPIFactory.getLocalInstance(ctx).getKPIInfo(tempKpi, selectors);
                if (newKpiInfo != null && (valueCols = newKpiInfo.getKpiValue()) != null && valueCols.size() > 0) {
                    int n = valueCols.size();
                    for (int ii = 0; ii < n; ++ii) {
                        tempValueInfo = valueCols.get(ii);
                        try {
                            this.copyRefGroup(ctx, tempValueInfo, (OrgUnitInfo)childAdminOrg, parentAdminOrg);
                            continue;
                        }
                        catch (SQLException e) {
                            logger.info((Object)"IN THE IMPORTKPIHANDLE,COPYREFGROUP ERROR!");
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            resultList.add("kpi:" + parentKpi.getName() + "\u5206\u914d\u5230\u516c\u53f8:" + childAdminOrg.getName() + "\u5931\u8d25!\u8be6\u7ec6\u4fe1\u606f\u53c2\u8003\u7cfb\u7edf\u65e5\u5fd7");
            e.printStackTrace();
            return;
        }
        this.assignDataToChild(ctx, tempParentKpi, (OrgUnitInfo)childAdminOrg, companys, resultList);
    }

    private void copyRefGroup(Context ctx, KPIValueInfo kpiValueInfo, OrgUnitInfo currentAdminOrg, OrgUnitInfo parentAdminOrg) throws BOSException, EASBizException, SQLException {
        IRefGroup iRefGroup = RefGroupFactory.getLocalInstance(ctx);
        RefGroupCollection refCols = iRefGroup.getRefGroupCollection("select *  where company.id='" + currentAdminOrg.getId().toString() + "'");
        StringBuffer sql = new StringBuffer();
        sql.append(" select t2.FRefValue as refvalue from t_mp_refgroup t1 ");
        sql.append("  inner join T_MP_KPIValueRefStandardValue t2 ");
        sql.append("  on t1.fid=t2.FRefGroupID ");
        sql.append("  and t1.fid=? ");
        if (refCols != null) {
            IKPIValueRefStandardValue iKPIValueRef = KPIValueRefStandardValueFactory.getLocalInstance(ctx);
            int n = refCols.size();
            for (int i = 0; i < n; ++i) {
                StringBuffer tempSql = new StringBuffer();
                tempSql.append(sql);
                RefGroupInfo refInfo = refCols.get(i);
                RefGroupInfo parentRefInfo = refInfo.getParent();
                KPIValueRefStandardValueInfo refStandardInfo = new KPIValueRefStandardValueInfo();
                if (parentRefInfo != null) {
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{parentRefInfo.getId().toString()});
                    if (rowSet != null && rowSet.next()) {
                        refStandardInfo.setRefValue(rowSet.getBigDecimal("refvalue"));
                    } else {
                        refStandardInfo.setRefValue(null);
                    }
                } else {
                    refStandardInfo.setRefValue(null);
                }
                refStandardInfo.setKPIValue(kpiValueInfo);
                refStandardInfo.setRefGroup(refInfo);
                iKPIValueRef.addnew(refStandardInfo);
            }
        } else {
            return;
        }
    }

    private void handleRefGroup(Context ctx, AdminOrgUnitInfo currentAdminOrg, OrgUnitInfo parentAdminOrg) throws BOSException, EASBizException {
        IRefGroup iRefGroup = RefGroupFactory.getLocalInstance(ctx);
        RefGroupCollection refCols = iRefGroup.getRefGroupCollection("select *  where company.id='" + parentAdminOrg.getId().toString() + "'");
        for (int j = 0; refCols != null && j < refCols.size(); ++j) {
            RefGroupInfo refInfo = refCols.get(j);
            if (iRefGroup.exists(" where parent.id='" + refInfo.getId().toString() + "' and  company.id='" + currentAdminOrg.getId().toString() + "'")) continue;
            RefGroupInfo newRefInfo = (RefGroupInfo)refInfo.clone();
            newRefInfo.setCompany(currentAdminOrg);
            newRefInfo.setParent(refInfo);
            newRefInfo.setId(null);
            iRefGroup.addnew((CoreBaseInfo)newRefInfo);
        }
    }

    private KPIValueInfo cloneKpiValueInfo(KPIValueInfo kpiValueInfo) {
        KPIValueInfo tempInfo = null;
        if (kpiValueInfo != null) {
            tempInfo = (KPIValueInfo)kpiValueInfo.clone();
        }
        return tempInfo;
    }

    private KPIValueInfo getKpiValue(KPIValueCollection valueCols) {
        if (valueCols != null && valueCols.size() > 0) {
            return valueCols.get(0);
        }
        return null;
    }

    private KPIInfo getChildKpiInfo(Context ctx, IKPI ikpi, String parentKpiId, BOSUuid currentAdminOrg) throws BOSException, EASBizException {
        KPIInfo kpiInfo = null;
        String sql = "select fid from t_mp_kpi where fparentid=? and FCompanyID=? ";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{parentKpiId, currentAdminOrg.toString()});
            if (rowSet != null && rowSet.next()) {
                kpiInfo = ikpi.getKPIInfo((IObjectPK)new ObjectUuidPK(rowSet.getString("fid")));
            }
        }
        catch (SQLException e) {
            logger.info((Object)"AssignKPIHandle,getCurrentKpiInfo() error!");
            e.printStackTrace();
        }
        return kpiInfo;
    }

    private AdminOrgUnitCollection getCurrentAOUChilds(Context ctx, OrgUnitInfo parentAOU, Set aOUS) {
        if (parentAOU == null) {
            return null;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)parentAOU.getId().toString()));
        StringBuffer mark = new StringBuffer();
        mark.append(" #0 and (");
        if (aOUS != null && aOUS.size() > 0) {
            Iterator ite = aOUS.iterator();
            int i = 1;
            while (ite.hasNext()) {
                String tempAOU = ((AdminOrgUnitInfo)ite.next()).getId().toString();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)tempAOU));
                if (i == 1) {
                    mark.append(" #" + i);
                } else {
                    mark.append(" or #" + i);
                }
                ++i;
            }
            mark.append(") ");
            filter.setMaskString(mark.toString());
            ev.setFilter(filter);
            AdminOrgUnitCollection aouCols = null;
            try {
                aouCols = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(ev);
            }
            catch (BOSException e) {
                logger.info((Object)"getCurrentAOUChilds error!");
                e.printStackTrace();
            }
            return aouCols;
        }
        return null;
    }

    private String getWarnParamValue(Context ctx, String refGroupId, AdminOrgUnitInfo currentAdminOrg) {
        String sql = "select fid from T_MP_RefGroup  where FParentID=? and FCompanyID=? ";
        String tempId = refGroupId;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{refGroupId, currentAdminOrg.getId().toString()});
            if (rowSet != null && rowSet.next()) {
                tempId = rowSet.getString("fid");
            }
        }
        catch (Exception e) {
            logger.info((Object)"ImportKPIHandle,getCurrentKpiInfo() error!");
            e.printStackTrace();
        }
        return tempId;
    }

    private String getNewParamValue(Context ctx, String paramValue, AdminOrgUnitInfo currentAdminOrg) {
        if (paramValue == null) {
            return null;
        }
        String tempParamValue = paramValue;
        String paramFormulaValue = " " + tempParamValue;
        StringTokenizer st = new StringTokenizer(paramFormulaValue, "$");
        StringBuffer formula = new StringBuffer();
        boolean flag = true;
        while (st.hasMoreTokens()) {
            if (flag) {
                formula.append(st.nextToken());
            } else {
                String refGroupId = st.nextToken();
                String tempGroupId = this.getWarnParamValue(ctx, refGroupId, currentAdminOrg);
                tempParamValue = tempParamValue.replaceAll(refGroupId, tempGroupId);
            }
            flag = !flag;
        }
        return tempParamValue;
    }
}

