/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.sem.mp.CSFFactory;
import com.kingdee.eas.sem.mp.ICSF;
import com.kingdee.eas.sem.mp.IKPI;
import com.kingdee.eas.sem.mp.IKPIValueRefStandardValue;
import com.kingdee.eas.sem.mp.IRefGroup;
import com.kingdee.eas.sem.mp.KPIException;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPIValueCollection;
import com.kingdee.eas.sem.mp.KPIValueInfo;
import com.kingdee.eas.sem.mp.KPIValueRefStandardValueFactory;
import com.kingdee.eas.sem.mp.KPIValueRefStandardValueInfo;
import com.kingdee.eas.sem.mp.RefGroupCollection;
import com.kingdee.eas.sem.mp.RefGroupFactory;
import com.kingdee.eas.sem.mp.RefGroupInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class AssignKPIHandleNew {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.sem.mp.app.AssignKPIHandle");
    protected static final String RES = "com.kingdee.eas.sem.mp.MPResource";

    public List assignDataToChild(Context ctx, List kpis, CompanyOrgUnitInfo parentAOU, Set companys, boolean isSkip) throws EASBizException, BOSException {
        ArrayList resultList = new ArrayList();
        if (kpis == null || kpis.size() <= 0) {
            throw new KPIException(KPIException.KPIS_NULL);
        }
        Iterator ite = kpis.iterator();
        KPIInfo tempInfo = null;
        while (ite.hasNext()) {
            try {
                tempInfo = KPIFactory.getLocalInstance(ctx).getKPIInfo((IObjectPK)new ObjectUuidPK(ite.next().toString()));
                this.copyKpiToCompany(ctx, tempInfo, companys, parentAOU, isSkip, resultList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    private void copyKpiToCompany(Context ctx, KPIInfo kpiInfo, Set company, CompanyOrgUnitInfo parentAdminOrg, boolean isSkip, List resultList) {
        for (CompanyOrgUnitInfo tempCompany : company) {
            this.copyKpiToCompany(ctx, kpiInfo, tempCompany, parentAdminOrg, isSkip, resultList);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyKpiToCompany(Context ctx, KPIInfo sourceKpiInfo, CompanyOrgUnitInfo adminInfo, CompanyOrgUnitInfo parentAdminOrg, boolean isSkip, List resultList) {
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            selector.add("parent.id");
            selector.add("refValue.*");
            selector.add("refValue.refGroup.*");
            selector.add("warnParam.*");
            selector.add("warnParam.warnGroup.*");
            selector.add("warnParam.edgeParam.*");
            selector.add("currentWarnStatus.*");
            selector.add("csf.*");
            selector.add("csf.BSC.*");
            selector.add("measureUnit.*");
            selector.add("edgeGroup.*");
            Object relatedCSFInfo = null;
            IKPI iKpi = null;
            ICSF icsf = null;
            icsf = CSFFactory.getLocalInstance(ctx);
            iKpi = KPIFactory.getLocalInstance(ctx);
            KPIInfo kpiInfo = iKpi.getKPIInfo((IObjectPK)new ObjectUuidPK(sourceKpiInfo.getId().toString()), selector);
            KPIInfo tempParentInfo = kpiInfo.getParent();
            String parentId = null;
            if (tempParentInfo != null) {
                parentId = tempParentInfo.getId().toString();
            } else {
                tempParentInfo = kpiInfo;
                parentId = kpiInfo.getId().toString();
            }
            KPIInfo tempKpiInfo = this.getChildKpiInfo(ctx, iKpi, parentId, adminInfo.getId());
            if (tempKpiInfo != null) {
                resultList.add(adminInfo.getName() + "had import the kpi:" + kpiInfo.getName());
                return;
            }
            if (this.isExistSameNumberOrName(ctx, kpiInfo, (OrgUnitInfo)adminInfo) && isSkip) return;
        }
        catch (Exception e) {
            resultList.add("kpi:" + sourceKpiInfo.getName() + "\u5206\u914d\u5230\u516c\u53f8:" + adminInfo.getName() + "\u5931\u8d25!\u8be6\u7ec6\u4fe1\u606f\u53c2\u8003\u7cfb\u7edf\u65e5\u5fd7");
            e.printStackTrace();
            return;
        }
    }

    private boolean isExistSameNumberOrName(Context ctx, KPIInfo kpiInfo, OrgUnitInfo company) throws EASBizException, BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)kpiInfo.getNumber()));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)kpiInfo.getName()));
        filter.getFilterItems().add(new FilterItemInfo("partfi.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)kpiInfo.getId().toString()));
        filter.setMaskString(" (#0 or #1) and #2 and #3 ");
        ev.setFilter(filter);
        return KPIFactory.getLocalInstance(ctx).exists(filter);
    }

    private void copyRefGroup(Context ctx, KPIValueInfo kpiValueInfo, OrgUnitInfo currentAdminOrg, OrgUnitInfo parentAdminOrg) throws BOSException, EASBizException, SQLException {
        IRefGroup iRefGroup = RefGroupFactory.getLocalInstance(ctx);
        RefGroupCollection refCols = iRefGroup.getRefGroupCollection("select *  where company.id='" + currentAdminOrg.getId().toString() + "'");
        StringBuffer sql = new StringBuffer();
        sql.append(" select t2.FRefValue as refvalue from t_mp_refgroup t1 ");
        sql.append("  inner join T_MP_KPIValueRefStandardValue t2 ");
        sql.append("  on t1.fid=t2.FRefGroupID ");
        sql.append("  and t1.fid=? ");
        if (refCols != null) {
            IKPIValueRefStandardValue iKPIValueRef = KPIValueRefStandardValueFactory.getLocalInstance(ctx);
            int n = refCols.size();
            for (int i = 0; i < n; ++i) {
                StringBuffer tempSql = new StringBuffer();
                tempSql.append(sql);
                RefGroupInfo refInfo = refCols.get(i);
                RefGroupInfo parentRefInfo = refInfo.getParent();
                KPIValueRefStandardValueInfo refStandardInfo = new KPIValueRefStandardValueInfo();
                if (parentRefInfo != null) {
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{parentRefInfo.getId().toString()});
                    if (rowSet != null && rowSet.next()) {
                        refStandardInfo.setRefValue(rowSet.getBigDecimal("refvalue"));
                    } else {
                        refStandardInfo.setRefValue(null);
                    }
                } else {
                    refStandardInfo.setRefValue(null);
                }
                refStandardInfo.setKPIValue(kpiValueInfo);
                refStandardInfo.setRefGroup(refInfo);
                iKPIValueRef.addnew(refStandardInfo);
            }
        } else {
            return;
        }
    }

    private Map handleRefGroup(Context ctx, AdminOrgUnitInfo currentAdminOrg, OrgUnitInfo parentAdminOrg, boolean isSkip) throws BOSException, EASBizException {
        HashMap<String, String> refGroup = new HashMap<String, String>();
        IRefGroup iRefGroup = RefGroupFactory.getLocalInstance(ctx);
        RefGroupCollection refCols = iRefGroup.getRefGroupCollection("select *  where company.id='" + parentAdminOrg.getId().toString() + "'");
        for (int j = 0; refCols != null && j < refCols.size(); ++j) {
            RefGroupInfo refInfo = refCols.get(j);
            String whereSql = "where parent.id='" + refInfo.getId().toString() + "' and  company.id='" + currentAdminOrg.getId().toString() + "'";
            RefGroupInfo tempRefInfo = this.getChildRefGroup(ctx, whereSql);
            if (tempRefInfo == null) {
                whereSql = " where ( number='" + refInfo.getNumber() + "' or  name='" + refInfo.getName() + "') and company.id='" + currentAdminOrg.getId().toString() + "'";
                tempRefInfo = this.getChildRefGroup(ctx, whereSql);
                if (tempRefInfo == null) {
                    RefGroupInfo newRefInfo = (RefGroupInfo)refInfo.clone();
                    newRefInfo.setCompany(currentAdminOrg);
                    newRefInfo.setParent(refInfo);
                    newRefInfo.setId(null);
                    IObjectPK tempPk = iRefGroup.addnew((CoreBaseInfo)newRefInfo);
                    refGroup.put(refInfo.getId().toString(), tempPk.toString());
                    continue;
                }
                if (!isSkip) {
                    tempRefInfo.setParent(refInfo);
                    iRefGroup.update((IObjectPK)new ObjectUuidPK(tempRefInfo.getId().toString()), (CoreBaseInfo)tempRefInfo);
                }
                refGroup.put(refInfo.getId().toString(), tempRefInfo.getId().toString());
                continue;
            }
            refGroup.put(refInfo.getId().toString(), tempRefInfo.getId().toString());
        }
        return refGroup;
    }

    private RefGroupInfo getChildRefGroup(Context ctx, String whereSql) {
        RefGroupInfo refInfo = null;
        try {
            IRefGroup iRefGroup = RefGroupFactory.getLocalInstance(ctx);
            RefGroupCollection refCols = iRefGroup.getRefGroupCollection(whereSql);
            if (refCols != null && refCols.size() > 0) {
                refInfo = refCols.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"assign kpi getChildRefGroup error!");
            e.printStackTrace();
        }
        return refInfo;
    }

    private KPIValueInfo cloneKpiValueInfo(KPIValueInfo kpiValueInfo) {
        KPIValueInfo tempInfo = null;
        if (kpiValueInfo != null) {
            tempInfo = (KPIValueInfo)kpiValueInfo.clone();
        }
        return tempInfo;
    }

    private KPIValueInfo getKpiValue(KPIValueCollection valueCols) {
        if (valueCols != null && valueCols.size() > 0) {
            return valueCols.get(0);
        }
        return null;
    }

    private KPIInfo getChildKpiInfo(Context ctx, IKPI ikpi, String parentKpiId, BOSUuid currentAdminOrg) throws BOSException, EASBizException {
        KPIInfo kpiInfo = null;
        String sql = "select fid from t_mp_kpi where ( fparentid=? or fid=? )and FCompanyID=? ";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{parentKpiId, parentKpiId, currentAdminOrg.toString()});
            if (rowSet != null && rowSet.next()) {
                kpiInfo = ikpi.getKPIInfo((IObjectPK)new ObjectUuidPK(rowSet.getString("fid")));
            }
        }
        catch (SQLException e) {
            logger.info((Object)"AssignKPIHandle,getCurrentKpiInfo() error!");
            e.printStackTrace();
        }
        return kpiInfo;
    }

    private String getNewParamValue(Context ctx, String paramValue, AdminOrgUnitInfo currentAdminOrg, Map refGroupMap) {
        if (paramValue == null) {
            return null;
        }
        String tempParamValue = paramValue;
        String paramFormulaValue = " " + tempParamValue;
        StringTokenizer st = new StringTokenizer(paramFormulaValue, "$");
        StringBuffer formula = new StringBuffer();
        boolean flag = true;
        String tempGroupId = "Error";
        while (st.hasMoreTokens()) {
            if (flag) {
                formula.append(st.nextToken());
            } else {
                String refGroupId = st.nextToken();
                Object obj = refGroupMap.get(refGroupId);
                if (obj != null) {
                    tempGroupId = obj.toString();
                }
                tempParamValue = tempParamValue.replaceAll(refGroupId, tempGroupId);
            }
            flag = !flag;
        }
        return tempParamValue;
    }
}

