/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.sem.mp.BSCCollection;
import com.kingdee.eas.sem.mp.BSCFactory;
import com.kingdee.eas.sem.mp.BSCInfo;
import com.kingdee.eas.sem.mp.IBSC;
import com.kingdee.eas.sem.mp.MPException;
import com.kingdee.eas.sem.mp.app.AbstractBSCControllerBean;
import com.kingdee.eas.sem.mp.app.util.BSCAppUtil;
import java.util.ArrayList;
import java.util.List;

public class BSCControllerBean
extends AbstractBSCControllerBean {
    protected void addNewCheck(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        this._checkBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        this._checkNameDup(ctx, model);
        this._checkNumberBlank(ctx, model);
        this._checkNumberDup(ctx, model);
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)dataBaseInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        int mask = 0;
        StringBuffer maskString = new StringBuffer();
        maskString.append("#0");
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            maskString.append(" and #" + ++mask);
        }
        if (((BSCInfo)model).getPartFI() != null) {
            String orgId = ((BSCInfo)model).getPartFI().getId().toString();
            filterItem = new FilterItemInfo("partfi", (Object)orgId);
            filter.getFilterItems().add(filterItem);
            maskString.append(" and #" + ++mask);
        }
        filter.setMaskString(maskString.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, dataBaseInfo, "name") + dataBaseInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        int mask = 0;
        StringBuffer maskString = new StringBuffer();
        maskString.append("#0");
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            maskString.append(" and #" + ++mask);
        }
        if (((BSCInfo)model).getPartFI() != null) {
            String orgId = ((BSCInfo)model).getPartFI().getId().toString();
            filterItem = new FilterItemInfo("partfi", (Object)orgId);
            filter.getFilterItems().add(filterItem);
            maskString.append(" and #" + ++mask);
        }
        filter.setMaskString(maskString.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    private void _checkBlank(Context ctx, IObjectValue model) throws MPException, DataBaseException {
        BSCInfo csf = (BSCInfo)model;
        CompanyOrgUnitInfo companyOrg = csf.getPartFI();
        if (companyOrg == null || companyOrg.getId().toString().length() <= 0) {
            throw new MPException(MPException.COMPANYBLANKEXCEPTION);
        }
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        String number = dataBaseInfo.getNumber();
        if (number == null || number.trim().equals("")) {
            throw new DataBaseException(DataBaseException.NUMBERNOTNULL);
        }
        String name = dataBaseInfo.getName();
        if (name == null || name.trim().equals("")) {
            throw new DataBaseException(DataBaseException.NAMENOTNULL);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addNewCheck(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addNewCheck(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkBlank(ctx, model);
        super._update(ctx, pk, model);
    }

    protected List _importDataFromParent(Context ctx, IObjectPK[] selectedPKs, AdminOrgUnitInfo currentAdminOrgInfo) throws BOSException, EASBizException {
        ArrayList<IObjectPK> list = new ArrayList<IObjectPK>();
        if (currentAdminOrgInfo == null) {
            throw new NullPointerException();
        }
        IBSC ibsc = BSCFactory.getLocalInstance(ctx);
        EntityViewInfo evi0 = new EntityViewInfo();
        FilterInfo filter0 = new FilterInfo();
        filter0.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentAdminOrgInfo.getId()));
        filter0.getFilterItems().add(new FilterItemInfo("isRef", (Object)Boolean.TRUE));
        evi0.setFilter(filter0);
        BSCInfo parentBSC = null;
        BSCInfo newInfo = null;
        BSCCollection bscColl = ibsc.getBSCCollection(evi0);
        if (bscColl.size() > 0) {
            parentBSC = bscColl.get(0);
        }
        int num = selectedPKs.length;
        for (int i = 0; i < num; ++i) {
            BSCInfo parentInfo = (BSCInfo)this.getValue(ctx, selectedPKs[i]);
            if (parentBSC == null) {
                parentBSC = ibsc.getBSCInfo((IObjectPK)new ObjectUuidPK(parentInfo.getParent().getId()));
                parentBSC.setCompany(currentAdminOrgInfo);
                parentBSC.setIsRef(true);
                parentBSC.setId(null);
                parentBSC = ibsc.getBSCInfo(ibsc.addnew((CoreBaseInfo)parentBSC));
            }
            newInfo = (BSCInfo)parentInfo.clone();
            newInfo.setCompany(currentAdminOrgInfo);
            newInfo.setRefBSC(parentInfo);
            newInfo.setParent(parentBSC);
            newInfo.setId(null);
            list.add(this.addnew(ctx, (CoreBaseInfo)newInfo));
        }
        return list;
    }

    protected List _importDataFromParent(Context ctx, IObjectPK[] selectPKs, Object org) throws BOSException, EASBizException {
        if (org != null && org instanceof CompanyOrgUnitInfo) {
            return BSCAppUtil.importDataFromParent(ctx, selectPKs, (CompanyOrgUnitInfo)org);
        }
        return null;
    }
}

