/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.solution.BISolution;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.impl.BIReportTreeUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.portal.IPortalServiceFacade;
import com.kingdee.eas.portal.PortalServiceFacadeFactory;
import com.kingdee.eas.sem.mp.BussAnalysisFacadeFactory;
import com.kingdee.eas.sem.mp.BussAnalysisThemeCollection;
import com.kingdee.eas.sem.mp.BussAnalysisThemeFactory;
import com.kingdee.eas.sem.mp.BussAnalysisThemeInfo;
import com.kingdee.eas.sem.mp.BussAnalysisThemeTreeFactory;
import com.kingdee.eas.sem.mp.BussAnalysisThemeTreeInfo;
import com.kingdee.eas.sem.mp.IBussAnalysisFacade;
import com.kingdee.eas.sem.mp.IBussAnalysisTheme;
import com.kingdee.eas.sem.mp.IBussAnalysisThemeTree;
import com.kingdee.eas.sem.mp.app.AbstractBussAnalysisFacadeControllerBean;
import com.kingdee.eas.sem.mp.app.BussAnalysisThemeTreeUtil;
import com.kingdee.eas.sem.mp.web.BIEasEnvInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class BussAnalysisFacadeControllerBean
extends AbstractBussAnalysisFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.sem.mp.app.BussAnalysisFacadeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap _getNames(Context ctx, String id) throws BOSException {
        HashMap resultMap = null;
        Connection conn = null;
        PreparedStatement preStmt = null;
        ResultSet reSet = null;
        Locale userLocale = ctx.getLocale();
        String localeType = "";
        localeType = userLocale == null ? "L2" : userLocale.getLanguage();
        try {
            conn = this.getConnection(ctx);
            StringBuffer sqlBuff = new StringBuffer();
            sqlBuff.append("select t.FViewerID,t1.FName_").append(localeType).append(" as name from T_MP_BussAnalysisViewer t,T_BD_Person t1").append("\r\n");
            sqlBuff.append("where t.FBqyFileID = ?").append("\r\n");
            sqlBuff.append("and t.FViewerID = t1.FID");
            preStmt = conn.prepareStatement(sqlBuff.toString());
            preStmt.setString(1, id);
            reSet = preStmt.executeQuery();
            ArrayList<String> viewerList = null;
            ArrayList<String> nameList = null;
            if (null != reSet) {
                resultMap = new HashMap();
                viewerList = new ArrayList<String>();
                nameList = new ArrayList<String>();
                while (reSet.next()) {
                    viewerList.add(reSet.getString("FViewerID"));
                    nameList.add(reSet.getString("name"));
                }
                resultMap.put("viewerList", viewerList);
                resultMap.put("nameList", nameList);
            }
            SQLUtils.cleanup((Statement)preStmt, (Connection)conn);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup(preStmt, (Connection)conn);
        }
        return resultMap;
    }

    protected String _getPortletUrl(Context ctx) throws BOSException {
        Configuration bosConfig = Configuration.getInstance();
        ConfigurationItem sln = bosConfig.getConfigItem("PortalInfo");
        StringBuffer portUrl = new StringBuffer();
        if (sln != null) {
            portUrl.append("http://");
            portUrl.append(sln.getProperty("host")).append(":");
            portUrl.append(sln.getProperty("port"));
            portUrl.append(sln.getProperty("contextroot")).append("/");
        }
        return portUrl.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _deleteTopic(Context ctx, String topicID) throws BOSException {
        PreparedStatement preStmt = null;
        StringBuffer sqlBuff = null;
        Connection conn = this.getConnection(ctx);
        try {
            sqlBuff = new StringBuffer();
            sqlBuff.append("select t1.FPortletID from T_MP_BussAnalysisConfig t1,T_MP_BussAnalysisTopics t2").append("\r\n");
            sqlBuff.append("where t1.FTopicID = t2.FID and t2.FID = ?");
            preStmt = conn.prepareStatement(sqlBuff.toString());
            preStmt.setString(1, topicID);
            ResultSet reSet = preStmt.executeQuery();
            ArrayList<String> portletIDList = new ArrayList<String>();
            if (null != reSet) {
                while (reSet.next()) {
                    portletIDList.add(reSet.getString("FPortletID"));
                }
                reSet.close();
            }
            if (portletIDList.size() > 0) {
                IPortalServiceFacade iPortalServiceFacede = PortalServiceFacadeFactory.getLocalInstance((Context)ctx);
                for (int i = 0; i < portletIDList.size(); ++i) {
                    if (null == portletIDList.get(i)) continue;
                    iPortalServiceFacede.deletePortlet((String)portletIDList.get(i));
                }
                iPortalServiceFacede.refreshPortletCache();
            }
            sqlBuff = new StringBuffer();
            sqlBuff.append("delete from T_MP_BussAnalysisViewer").append("\r\n");
            sqlBuff.append("where FBqyFileID in").append("\r\n");
            sqlBuff.append("(select t1.FID from T_MP_BussAnalysisConfig t1,T_MP_BussAnalysisTopics t2").append("\r\n");
            sqlBuff.append("where t1.FTopicID = t2.FID and t2.FID = ?)");
            preStmt = conn.prepareStatement(sqlBuff.toString());
            preStmt.setString(1, topicID);
            preStmt.execute();
            sqlBuff = new StringBuffer();
            sqlBuff.append("delete from T_MP_BussAnalysisConfig").append("\r\n");
            sqlBuff.append("where FID in").append("\r\n");
            sqlBuff.append("(select t1.FID from T_MP_BussAnalysisConfig t1,T_MP_BussAnalysisTopics t2").append("\r\n");
            sqlBuff.append("where t1.FTopicID = t2.FID and t2.FID = ?)");
            preStmt = conn.prepareStatement(sqlBuff.toString());
            preStmt.setString(1, topicID);
            preStmt.execute();
            SQLUtils.cleanup((Statement)preStmt, (Connection)conn);
        }
        catch (Exception e) {
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        finally {
            SQLUtils.cleanup(preStmt, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _isEmptyTree(Context ctx) throws BOSException {
        boolean isEmpty;
        block6: {
            isEmpty = true;
            Connection conn = null;
            ResultSet reSet = null;
            try {
                String size;
                conn = this.getConnection(ctx);
                reSet = conn.createStatement().executeQuery("select count(*) as cnt from T_MP_BussAnalysisTopics");
                if (null != reSet && reSet.next() && null != (size = reSet.getString("cnt")) && Integer.valueOf(size.trim()) > 0) {
                    isEmpty = false;
                }
                SQLUtils.cleanup((ResultSet)reSet);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                SQLUtils.cleanup(reSet);
                SQLUtils.cleanup((Connection)conn);
            }
            SQLUtils.cleanup((Connection)conn);
        }
        return isEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _isTopicExisted(Context ctx, String topicName) throws BOSException {
        boolean iExisted;
        block6: {
            iExisted = false;
            Connection conn = null;
            ResultSet reSet = null;
            StringBuffer sqlBuff = null;
            PreparedStatement preStmt = null;
            try {
                String size;
                conn = this.getConnection(ctx);
                sqlBuff = new StringBuffer("select count(*) as cnt from T_MP_BussAnalysisTopics t").append("\r\n");
                sqlBuff.append("where t.FName_L2 = ? or t.FName_L3 = ?");
                preStmt = conn.prepareStatement(sqlBuff.toString());
                preStmt.setString(1, topicName);
                preStmt.setString(2, topicName);
                reSet = preStmt.executeQuery();
                if (null != reSet && reSet.next() && null != (size = reSet.getString("cnt")) && Integer.valueOf(size.trim()) > 0) {
                    iExisted = true;
                }
                SQLUtils.cleanup((ResultSet)reSet, (Statement)preStmt);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                SQLUtils.cleanup(reSet, preStmt);
                SQLUtils.cleanup((Connection)conn);
            }
            SQLUtils.cleanup((Connection)conn);
        }
        return iExisted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap _getUserBqys(Context ctx, String personID, String localeType) throws BOSException {
        HashMap resultMap;
        block11: {
            resultMap = new HashMap();
            Connection conn = null;
            ResultSet reSet = null;
            PreparedStatement preStmt = null;
            StringBuffer sqlBuff = null;
            try {
                HashMap<String, String> topicMap = new HashMap<String, String>();
                sqlBuff = new StringBuffer();
                sqlBuff.append("select t.FID,t.FName_").append(localeType).append(" as topicName from T_MP_BussAnalysisTopics t");
                conn = this.getConnection(ctx);
                preStmt = conn.prepareStatement(sqlBuff.toString());
                reSet = preStmt.executeQuery();
                if (null != reSet) {
                    while (reSet.next()) {
                        topicMap.put(reSet.getString("FID"), reSet.getString("topicName"));
                    }
                }
                HashMap filesMap = new HashMap();
                if (topicMap.size() > 0) {
                    String[] topicIDs = new String[topicMap.size()];
                    topicMap.keySet().toArray(topicIDs);
                    sqlBuff = new StringBuffer();
                    sqlBuff.append("select t.FFileName as fileName, t.FFilePath as filePath").append("\r\n");
                    sqlBuff.append("from T_MP_BussAnalysisConfig t, T_MP_BussAnalysisViewer t1").append("\r\n");
                    sqlBuff.append("where t1.FViewerID = ? and t1.FBqyFileID = t.FID and t.FTopicID = ?").append("\r\n");
                    HashMap<String, String> fileInfoMap = null;
                    ArrayList filesList = null;
                    for (int i = 0; i < topicIDs.length; ++i) {
                        preStmt = conn.prepareStatement(sqlBuff.toString());
                        preStmt.setString(1, personID);
                        preStmt.setString(2, topicIDs[i]);
                        reSet = preStmt.executeQuery();
                        filesList = new ArrayList();
                        if (null != reSet) {
                            while (reSet.next()) {
                                fileInfoMap = new HashMap<String, String>();
                                fileInfoMap.put("fileName", reSet.getString("fileName"));
                                fileInfoMap.put("filePath", reSet.getString("filePath"));
                                filesList.add(fileInfoMap);
                            }
                        }
                        filesMap.put(topicIDs[i], filesList);
                    }
                }
                resultMap.put("topics", topicMap);
                resultMap.put("files", filesMap);
                SQLUtils.cleanup((ResultSet)reSet, (Statement)preStmt);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                break block11;
            }
            finally {
                SQLUtils.cleanup(reSet, preStmt);
                SQLUtils.cleanup(conn);
            }
            SQLUtils.cleanup((Connection)conn);
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap _getBqysByTopicID(Context ctx, ArrayList topicIDs, String personID) throws BOSException {
        HashMap resultMap;
        block12: {
            resultMap = new HashMap();
            Connection conn = null;
            ResultSet reSet = null;
            PreparedStatement preStmt = null;
            StringBuffer sqlBuff = null;
            String localeType = null;
            localeType = null != ctx.getLocale() ? ctx.getLocale().toString() : "L2";
            try {
                HashMap<String, String> topicMap = new HashMap<String, String>();
                sqlBuff = new StringBuffer();
                sqlBuff.append("select t.FID,t.FName_").append(localeType).append(" as topicName from T_MP_BussAnalysisTopics t").append("\r\n");
                sqlBuff.append("where FID in(");
                for (int i = 0; i < topicIDs.size(); ++i) {
                    sqlBuff.append("'");
                    sqlBuff.append((String)topicIDs.get(i));
                    sqlBuff.append("'");
                    if (topicIDs.size() <= 1 || i >= topicIDs.size() - 1) continue;
                    sqlBuff.append(",");
                }
                sqlBuff.append(")");
                conn = this.getConnection(ctx);
                preStmt = conn.prepareStatement(sqlBuff.toString());
                reSet = preStmt.executeQuery();
                if (null != reSet) {
                    while (reSet.next()) {
                        topicMap.put(reSet.getString("FID"), reSet.getString("topicName"));
                    }
                }
                HashMap filesMap = new HashMap();
                if (topicMap.size() > 0) {
                    sqlBuff = new StringBuffer();
                    sqlBuff.append("select t.FID as id,t.FFileName as fileName, t.FFilePath as filePath").append("\r\n");
                    sqlBuff.append("from T_MP_BussAnalysisConfig t, T_MP_BussAnalysisViewer t1").append("\r\n");
                    sqlBuff.append("where t1.FViewerID = ? and t1.FBqyFileID = t.FID and t.FTopicID = ?").append("\r\n");
                    HashMap<String, String> fileInfoMap = null;
                    ArrayList filesList = null;
                    for (int i = 0; i < topicIDs.size(); ++i) {
                        conn = this.getConnection(ctx);
                        preStmt = conn.prepareStatement(sqlBuff.toString());
                        preStmt.setString(1, personID);
                        preStmt.setString(2, (String)topicIDs.get(i));
                        reSet = preStmt.executeQuery();
                        filesList = new ArrayList();
                        if (null != reSet) {
                            while (reSet.next()) {
                                fileInfoMap = new HashMap<String, String>();
                                fileInfoMap.put("configID", reSet.getString("id"));
                                fileInfoMap.put("fileName", reSet.getString("fileName"));
                                fileInfoMap.put("filePath", reSet.getString("filePath"));
                                filesList.add(fileInfoMap);
                            }
                        }
                        filesMap.put((String)topicIDs.get(i), filesList);
                    }
                }
                resultMap.put("topics", topicMap);
                resultMap.put("files", filesMap);
                SQLUtils.cleanup((ResultSet)reSet, (Statement)preStmt);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                break block12;
            }
            finally {
                SQLUtils.cleanup(reSet, preStmt);
                SQLUtils.cleanup(conn);
            }
            SQLUtils.cleanup((Connection)conn);
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _isUndelConfig(Context ctx, String configID) throws BOSException {
        boolean delTag;
        block6: {
            delTag = true;
            Connection conn = null;
            ResultSet reSet = null;
            PreparedStatement preStmt = null;
            try {
                String size;
                conn = this.getConnection(ctx);
                StringBuffer sqlBuff = new StringBuffer();
                sqlBuff.append("select count(*) as cnt from T_MP_BussAnalysisViewer t").append("\r\n");
                sqlBuff.append("where t.FBqyFileID = ?");
                preStmt = conn.prepareStatement(sqlBuff.toString());
                preStmt.setString(1, configID);
                reSet = preStmt.executeQuery();
                if (null != reSet && reSet.next() && null != (size = reSet.getString("cnt")) && Integer.valueOf(size.trim()) > 0) {
                    delTag = false;
                }
                SQLUtils.cleanup((ResultSet)reSet, (Statement)preStmt);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                SQLUtils.cleanup(reSet, preStmt);
                SQLUtils.cleanup((Connection)conn);
            }
            SQLUtils.cleanup((Connection)conn);
        }
        return delTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _isUndelTopic(Context ctx, String topicID) throws BOSException {
        boolean delTag;
        block6: {
            delTag = true;
            Connection conn = null;
            ResultSet reSet = null;
            PreparedStatement preStmt = null;
            try {
                String size;
                conn = this.getConnection(ctx);
                StringBuffer sqlBuff = new StringBuffer();
                sqlBuff.append("select count(*) as cnt from T_MP_BussAnalysisViewer t").append("\r\n");
                sqlBuff.append("where t.FBqyFileID").append("\r\n");
                sqlBuff.append("in(select t1.FID from T_MP_BussAnalysisConfig t1 where t1.FTopicID = ?)");
                preStmt = conn.prepareStatement(sqlBuff.toString());
                preStmt.setString(1, topicID);
                reSet = preStmt.executeQuery();
                if (null != reSet && reSet.next() && null != (size = reSet.getString("cnt")) && Integer.valueOf(size.trim()) > 0) {
                    delTag = false;
                }
                SQLUtils.cleanup((ResultSet)reSet, (Statement)preStmt);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                SQLUtils.cleanup(reSet, preStmt);
                SQLUtils.cleanup((Connection)conn);
            }
            SQLUtils.cleanup((Connection)conn);
        }
        return delTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList _getPersonsIDByConfigID(Context ctx, String configID) throws BOSException {
        ArrayList<String> pIDList;
        block7: {
            pIDList = new ArrayList<String>();
            Connection conn = null;
            PreparedStatement preStmt = null;
            ResultSet reSet = null;
            try {
                conn = this.getConnection(ctx);
                StringBuffer sqlBuff = new StringBuffer();
                sqlBuff.append("select t.FViewerID from T_MP_BussAnalysisViewer t").append("\r\n");
                sqlBuff.append("where t.FBqyFileID = ?");
                preStmt = conn.prepareStatement(sqlBuff.toString());
                preStmt.setString(1, configID);
                reSet = preStmt.executeQuery();
                if (null != reSet) {
                    while (reSet.next()) {
                        pIDList.add(reSet.getString("FViewerID"));
                    }
                }
                SQLUtils.cleanup((ResultSet)reSet, (Statement)preStmt);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                break block7;
            }
            finally {
                SQLUtils.cleanup(reSet, preStmt);
                SQLUtils.cleanup((Connection)conn);
            }
            SQLUtils.cleanup((Connection)conn);
        }
        return pIDList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] _getConfigIDsDByPersonID(Context ctx, String personID) throws BOSException {
        ArrayList<String> idList;
        String[] configIDs;
        block8: {
            configIDs = null;
            idList = new ArrayList<String>();
            Connection conn = null;
            PreparedStatement preStmt = null;
            ResultSet reSet = null;
            try {
                conn = this.getConnection(ctx);
                StringBuffer sqlBuff = new StringBuffer();
                sqlBuff.append("select t.FBqyFileID from T_MP_BussAnalysisViewer t").append("\r\n");
                sqlBuff.append("where t.FViewerID = ?");
                preStmt = conn.prepareStatement(sqlBuff.toString());
                preStmt.setString(1, personID);
                reSet = preStmt.executeQuery();
                if (null != reSet) {
                    while (reSet.next()) {
                        idList.add(reSet.getString("FBqyFileID"));
                    }
                }
                SQLUtils.cleanup((ResultSet)reSet, (Statement)preStmt);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                break block8;
            }
            finally {
                SQLUtils.cleanup(reSet, preStmt);
                SQLUtils.cleanup((Connection)conn);
            }
            SQLUtils.cleanup((Connection)conn);
        }
        if (idList.size() > 0) {
            configIDs = new String[idList.size()];
            idList.toArray(configIDs);
        }
        return configIDs;
    }

    protected BIEasEnvInfo _getBIEasEnv(Context ctx) throws BOSException, EASBizException {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        OrgUnitInfo ou = ContextUtil.getCurrentOrgUnit((Context)ctx);
        BIEasEnvInfo bieei = new BIEasEnvInfo(ctx, userInfo, ou, cu);
        return bieei;
    }

    protected List _getAllSubject(Context ctx) throws BOSException, EASBizException {
        List subjectList = null;
        BISolution solution = BISystem.getSolution();
        return subjectList;
    }

    protected BussAnalysisThemeCollection _getPermissBussTree(Context ctx) throws BOSException, EASBizException {
        return this.contructPermissionReportTree(ctx, this.getPermissionTree(ctx, this.getPermissonReport(ctx)));
    }

    private IRowSet getPermissonReport(Context ctx) throws BOSException, EASBizException {
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        String strTemp = iPermission.getQueryPermissionSQL(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()), "buss_analysisThemeReport_config");
        IRowSet rowSet = null;
        strTemp = strTemp + " and \"T0\".\"FIsBusiLeaf\" =1 ";
        rowSet = DbUtil.executeQuery((Context)ctx, (String)strTemp);
        return rowSet;
    }

    private BussAnalysisThemeCollection getPermissionTree(Context ctx, IRowSet rowSet) throws BOSException {
        if (rowSet == null || rowSet.size() <= 0) {
            return null;
        }
        BussAnalysisThemeCollection cols = null;
        StringBuffer idBuffer = new StringBuffer("");
        boolean bFlag = false;
        if (rowSet != null) {
            IBussAnalysisTheme ibt = BussAnalysisThemeFactory.getLocalInstance(ctx);
            try {
                while (rowSet.next()) {
                    String strTemp = rowSet.getString("ID");
                    if (bFlag) {
                        idBuffer.append(",");
                    } else {
                        bFlag = true;
                    }
                    idBuffer.append("'").append(strTemp).append("'");
                }
                cols = ibt.getBussAnalysisThemeCollection("select * where id in (" + idBuffer.toString() + ")");
            }
            catch (SQLException e) {
                e.printStackTrace();
                idBuffer = new StringBuffer("");
            }
        }
        return cols;
    }

    private BussAnalysisThemeCollection contructPermissionReportTree(Context ctx, BussAnalysisThemeCollection cols) throws BOSException {
        if (cols == null || cols.size() <= 0) {
            return null;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        int count = cols.size();
        ArrayList longNumberList = new ArrayList();
        for (int i = 0; i < count; ++i) {
            BussAnalysisThemeInfo themeInfo = cols.get(i);
            String longNumber = themeInfo.getLongNumber();
            this.splitLongNumber(longNumber, longNumberList);
        }
        count = longNumberList.size();
        StringBuffer maskString = new StringBuffer(" ( ");
        if (count > 0) {
            for (int j = 0; j < count; ++j) {
                FilterItemInfo filterItem = new FilterItemInfo("longNumber", longNumberList.get(j), CompareType.EQUALS);
                filter.getFilterItems().add(filterItem);
                if (j == 0) {
                    maskString.append(" #" + j);
                    continue;
                }
                maskString.append(" or  #" + j);
            }
            maskString.append(" ) ");
        }
        filter.setMaskString(maskString.toString());
        ev.setFilter(filter);
        ev.getSorter().add(new SorterItemInfo("longNumber"));
        IBussAnalysisTheme ibt = BussAnalysisThemeFactory.getLocalInstance(ctx);
        cols = ibt.getBussAnalysisThemeCollection(ev);
        return cols;
    }

    private void splitLongNumber(String longNumber, List list) {
        int index = 0;
        while ((index = longNumber.indexOf("!", index)) > 0) {
            list.add(longNumber.substring(0, index));
            ++index;
        }
        list.add(longNumber);
    }

    private void test(Context ctx) throws BOSException, EASBizException {
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        String strTemp = iPermission.getQueryPermissionSQL(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()), "buss_analysisThemeReport_config");
        IRowSet rowSet = null;
        StringBuffer idBuffer = new StringBuffer("");
        boolean bFlag = false;
        rowSet = DbUtil.executeQuery((Context)ctx, (String)strTemp);
        if (rowSet != null) {
            try {
                while (rowSet.next()) {
                    strTemp = rowSet.getString("ID");
                    if (bFlag) {
                        idBuffer.append(",");
                    } else {
                        bFlag = true;
                    }
                    idBuffer.append("'").append(strTemp).append("'");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                idBuffer = new StringBuffer("");
            }
        }
        String nodeName = "";
        String nodeId = "";
        IBussAnalysisFacade IBussFacade = BussAnalysisFacadeFactory.getLocalInstance(ctx);
        BussAnalysisThemeCollection cols = IBussFacade.getPermissBussTree();
        if (cols != null) {
            Iterator ite = cols.iterator();
            while (ite.hasNext()) {
                BussAnalysisThemeInfo bussThemeInfo = (BussAnalysisThemeInfo)ite.next();
                nodeName = bussThemeInfo.getDisplayName();
                nodeId = bussThemeInfo.getEntry().getId().toString();
                if (!bussThemeInfo.isIsLeaf()) continue;
            }
        }
    }

    protected TreeModel _getBussReortTreeModel(Context ctx) throws BOSException {
        return BussAnalysisThemeTreeUtil.getBiTreeModel();
    }

    protected synchronized void _sysBussTreeFromBiTree(Context ctx) throws BOSException, EASBizException {
        this.clearBussAnalysisthemeTree(ctx);
        TreeModel treeModel = BussAnalysisThemeTreeUtil.getBiTreeModel();
        Object root = treeModel.getRoot();
        if (root != null) {
            IBussAnalysisThemeTree iBussTree = BussAnalysisThemeTreeFactory.getLocalInstance(ctx);
            this.buildTreeNode(ctx, iBussTree, (DefaultMutableTreeNode)root, null);
        }
    }

    private void clearBussAnalysisthemeTree(Context ctx) throws BOSException {
        String delSql = "delete t_mp_bussanathemetree ";
        DbUtil.execute((Context)ctx, (String)delSql);
    }

    private void buildTreeNode(Context ctx, IBussAnalysisThemeTree iBussTree, DefaultMutableTreeNode sourceNode, BussAnalysisThemeTreeInfo parentInfo) throws BOSException, EASBizException {
        if (sourceNode == null) {
            return;
        }
        BussAnalysisThemeTreeInfo treeInfo = this.createBussTreeInfoByTreeNode(ctx, sourceNode);
        treeInfo.setParent(parentInfo);
        IObjectPK id = iBussTree.addnew((CoreBaseInfo)treeInfo);
        treeInfo.setId(BOSUuid.read((String)id.toString()));
        treeInfo.setParent(parentInfo);
        parentInfo = treeInfo;
        int childCount = sourceNode.getChildCount();
        if (childCount <= 0) {
            return;
        }
        DefaultMutableTreeNode tempNode = null;
        for (int i = 0; i < childCount; ++i) {
            tempNode = (DefaultMutableTreeNode)sourceNode.getChildAt(i);
            if (tempNode.getChildCount() > 0) {
                this.buildTreeNode(ctx, iBussTree, tempNode, parentInfo);
                continue;
            }
            treeInfo = this.createBussTreeInfoByTreeNode(ctx, tempNode);
            treeInfo.setParent(parentInfo);
            iBussTree.addnew((CoreBaseInfo)treeInfo);
        }
    }

    private BussAnalysisThemeTreeInfo createBussTreeInfoByTreeNode(Context ctx, DefaultMutableTreeNode node) throws EASBizException {
        BussAnalysisThemeTreeInfo treeInfo = new BussAnalysisThemeTreeInfo();
        if (node != null) {
            treeInfo.setName(node.getUserObject() == null ? "" : node.getUserObject().toString());
            treeInfo.setNumber(String.valueOf(SysUtil.getAppServerTime((Context)ctx).getTime()));
            treeInfo.setSubName(BIReportTreeUtil.getSubjectName((Object)node));
            treeInfo.setSubPath(BIReportTreeUtil.getReportPath((Object)node));
        }
        return treeInfo;
    }
}

