/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.sem.mp.BussAnalysisThemeFactory;
import com.kingdee.eas.sem.mp.BussAnalysisThemeInfo;
import com.kingdee.eas.sem.mp.BussAnalysisThemeReportCollection;
import com.kingdee.eas.sem.mp.BussAnalysisThemeReportFactory;
import com.kingdee.eas.sem.mp.BussLayoutFactory;
import com.kingdee.eas.sem.mp.BussLayoutInfo;
import com.kingdee.eas.sem.mp.IBussAnalysisThemeReport;
import com.kingdee.eas.sem.mp.IBussLayout;
import com.kingdee.eas.sem.mp.app.AbstractBussAnalysisThemeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class BussAnalysisThemeControllerBean
extends AbstractBussAnalysisThemeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.sem.mp.app.BussAnalysisThemeControllerBean");

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BussAnalysisThemeInfo bussInfo = BussAnalysisThemeFactory.getLocalInstance(ctx).getBussAnalysisThemeInfo(pk);
        BussAnalysisThemeInfo curInfo = (BussAnalysisThemeInfo)model;
        if (bussInfo.isIsBusiLeaf() && !curInfo.isIsBusiLeaf()) {
            this.deleteLinkReport(ctx, pk);
        }
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.deleteLinkReport(ctx, pk);
        super._delete(ctx, pk);
    }

    private void deleteLayout(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        String sql = "select fentryid from t_mp_bussanalysistheme where fid=?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{pk.toString()});
        try {
            String layoutID;
            if (rs != null && rs.next() && (layoutID = rs.getString("fentryid")) != null && !layoutID.equals("")) {
                IBussLayout ibl = BussLayoutFactory.getLocalInstance(ctx);
                BussLayoutInfo layOutInfo = (BussLayoutInfo)ibl.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)layoutID)));
                ibl.delete((IObjectPK)new ObjectUuidPK(layOutInfo.getId()));
            }
        }
        catch (SQLException e) {
            logger.info((Object)"IN THE DELETELAYOUT ERROR");
            e.printStackTrace();
        }
    }

    private void deleteLinkReport(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("theme", (Object)pk.toString(), CompareType.EQUALS));
        filter.setMaskString(" #0 ");
        ev.setFilter(filter);
        IBussAnalysisThemeReport iReport = BussAnalysisThemeReportFactory.getLocalInstance(ctx);
        BussAnalysisThemeReportCollection cols = iReport.getBussAnalysisThemeReportCollection(ev);
        if (cols != null && cols.size() > 0) {
            int size = cols.size();
            IObjectPK[] pks = new IObjectPK[size];
            for (int i = 0; i < size; ++i) {
                pks[i] = new ObjectUuidPK(cols.get(i).getId());
            }
            iReport.delete(pks);
        }
    }
}

