/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.sem.mp.BussAnalyException;
import com.kingdee.eas.sem.mp.BussAnalysisViewerInfo;
import com.kingdee.eas.sem.mp.app.AbstractBussAnalysisViewerControllerBean;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class BussAnalysisViewerControllerBean
extends AbstractBussAnalysisViewerControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.sem.mp.app.BussAnalysisViewerControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    protected void _addBatch(Context ctx, IObjectCollection viewers) throws BOSException, EASBizException {
        if (null != viewers && viewers.size() > 0) {
            String fid = null;
            String creatorID = ctx.getCaller().toString().trim();
            String createTime = null;
            String updateUserID = creatorID;
            String updateTime = null;
            String currCUId = "";
            String bqyFileID = null;
            String viewerID = null;
            String orgID = null;
            BussAnalysisViewerInfo viewer = null;
            try {
                Connection conn = this.getConnection(ctx);
                String insertSql = "insert into T_MP_BussAnalysisViewer(FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FBqyFileID,FViewerID,FOfOrganizationID) values(?,?,?,?,?,?,?,?,?)";
                PreparedStatement preStmt = conn.prepareStatement(insertSql);
                int j = viewers.size();
                for (int i = 0; i < j; ++i) {
                    viewer = (BussAnalysisViewerInfo)viewers.getObject(i);
                    fid = BOSUuid.create((BOSObjectType)viewer.getBOSType()).toString().trim();
                    updateTime = createTime = new Long(System.currentTimeMillis()).toString();
                    bqyFileID = viewer.getBqyFile().getId().toString().trim();
                    viewerID = viewer.getViewer().getId().toString().trim();
                    orgID = viewer.getOfOrganization().getId().toString().trim();
                    preStmt.setString(1, fid);
                    preStmt.setString(2, creatorID);
                    preStmt.setString(3, createTime);
                    preStmt.setString(4, updateUserID);
                    preStmt.setString(5, updateTime);
                    preStmt.setString(6, currCUId);
                    preStmt.setString(7, bqyFileID);
                    preStmt.setString(8, viewerID);
                    preStmt.setString(9, orgID);
                    preStmt.addBatch();
                }
                preStmt.executeBatch();
            }
            catch (SQLException ex) {
                throw new BussAnalyException(BussAnalyException.VIEWERADDEXCEPTION, ex);
            }
        }
    }

    protected void _addViewerBatch(Context ctx, Object[] personObjs, String configID) throws BOSException, EASBizException {
        if (null != personObjs) {
            String creatorID;
            Connection conn = this.getConnection(ctx);
            String insertSql = "insert into T_MP_BussAnalysisViewer(FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FBqyFileID,FViewerID,FOfOrganizationID) values(?,?,?,?,?,?,?,?,?)";
            String fid = null;
            String updateUserID = creatorID = ctx.getCaller().toString().trim();
            String currCUId = "";
            String orgID = null;
            try {
                PreparedStatement preStmt = conn.prepareStatement(insertSql);
                IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
                int j = personObjs.length;
                for (int i = 0; i < j; ++i) {
                    fid = BOSUuid.create((BOSObjectType)new BussAnalysisViewerInfo().getBOSType()).toString().trim();
                    orgID = iPerson.getPrimaryAdminOrgUnit(BOSUuid.read((String)((PersonInfo)personObjs[i]).getId().toString().trim())).getId().toString();
                    preStmt.setString(1, fid);
                    preStmt.setString(2, creatorID);
                    preStmt.setDate(3, new Date(System.currentTimeMillis()));
                    preStmt.setString(4, updateUserID);
                    preStmt.setDate(5, new Date(System.currentTimeMillis()));
                    preStmt.setString(6, currCUId);
                    preStmt.setString(7, configID);
                    preStmt.setString(8, ((PersonInfo)personObjs[i]).getId().toString().trim());
                    preStmt.setString(9, orgID);
                    preStmt.addBatch();
                    logger.debug((Object)("add ->" + i));
                }
                preStmt.executeBatch();
            }
            catch (SQLException ex) {
                throw new BussAnalyException(BussAnalyException.VIEWERADDEXCEPTION, ex);
            }
        }
    }
}

