/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.sem.mp.BSCInfo;
import com.kingdee.eas.sem.mp.CSFCollection;
import com.kingdee.eas.sem.mp.CSFFactory;
import com.kingdee.eas.sem.mp.CSFInfo;
import com.kingdee.eas.sem.mp.MPException;
import com.kingdee.eas.sem.mp.app.AbstractCSFControllerBean;
import com.kingdee.eas.sem.mp.app.util.CSFAppUtil;
import java.util.HashMap;
import java.util.List;

public class CSFControllerBean
extends AbstractCSFControllerBean {
    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)dataBaseInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        int mask = 0;
        StringBuffer maskString = new StringBuffer();
        maskString.append("#0");
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            maskString.append(" and #" + ++mask);
        }
        if (((CSFInfo)model).getPartFi() != null) {
            String orgId = ((CSFInfo)model).getPartFi().getId().toString();
            filterItem = new FilterItemInfo("partfi", (Object)orgId);
            filter.getFilterItems().add(filterItem);
            maskString.append(" and #" + ++mask);
        }
        filter.setMaskString(maskString.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, dataBaseInfo, "name") + dataBaseInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        int mask = 0;
        StringBuffer maskString = new StringBuffer();
        maskString.append("#0");
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            maskString.append(" and #" + ++mask);
        }
        if (((CSFInfo)model).getPartFi() != null) {
            String orgId = ((CSFInfo)model).getPartFi().getId().toString();
            filterItem = new FilterItemInfo("partfi", (Object)orgId);
            filter.getFilterItems().add(filterItem);
            maskString.append(" and #" + ++mask);
        }
        filter.setMaskString(maskString.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected void addNewCheck(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkCompanyBlank(ctx, model);
        this._checkNumberBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        this._checkNameBlank(ctx, model);
        this._checkNameDup(ctx, model);
        this._checkBscBlank(ctx, model);
    }

    private void _checkBscBlank(Context ctx, IObjectValue model) throws MPException {
        CSFInfo csfInfo = (CSFInfo)model;
        BSCInfo bscInfo = csfInfo.getBSC();
        if (bscInfo == null) {
            throw new MPException(MPException.BSCBLANKEXCEPTION);
        }
    }

    private void _checkCompanyBlank(Context ctx, IObjectValue model) throws MPException {
        CSFInfo csf = (CSFInfo)model;
        CompanyOrgUnitInfo company = csf.getPartFi();
        if (company == null || company.getId().toString().length() <= 0) {
            throw new MPException(MPException.COMPANYBLANKEXCEPTION);
        }
        BSCInfo bsc = csf.getBSC();
        if (bsc == null || bsc.getId().toString().length() <= 0) {
            throw new MPException(MPException.BSCBLANKEXCEPTION);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addNewCheck(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addNewCheck(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateCheck(ctx, model);
        super._update(ctx, pk, model);
    }

    private void updateCheck(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        this._checkNumberBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        this._checkNameBlank(ctx, model);
        this._checkNameDup(ctx, model);
        this._checkCompanyBlank(ctx, model);
    }

    protected List _importDataFromParent(Context ctx, IObjectPK[] selectedPKs, HashMap orgMap) throws BOSException, EASBizException {
        return CSFAppUtil.importDataFromParent(ctx, selectedPKs, orgMap);
    }

    private CSFInfo getCsfInfo(Context ctx, String filterSql) throws BOSException {
        CSFInfo csfInfo = null;
        CSFCollection csfCols = CSFFactory.getLocalInstance(ctx).getCSFCollection(filterSql);
        if (csfCols != null && csfCols.size() > 0) {
            csfInfo = csfCols.get(0);
        }
        return csfInfo;
    }
}

