/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.sem.mp.AnalysisItemCollection;
import com.kingdee.eas.sem.mp.AnalysisItemEntryCollection;
import com.kingdee.eas.sem.mp.AnalysisItemEntryInfo;
import com.kingdee.eas.sem.mp.AnalysisItemFactory;
import com.kingdee.eas.sem.mp.AnalysisItemInfo;
import com.kingdee.eas.sem.mp.DWCalculateSchemaCollection;
import com.kingdee.eas.sem.mp.DWCalculateSchemaFactory;
import com.kingdee.eas.sem.mp.DWCalculateSchemaInfo;
import com.kingdee.eas.sem.mp.DWCalculateSchemaItemCollection;
import com.kingdee.eas.sem.mp.DWCalculateSchemaItemInfo;
import com.kingdee.eas.sem.mp.DWCalculateSchemaOrgCollection;
import com.kingdee.eas.sem.mp.DWCalculateSchemaOrgInfo;
import com.kingdee.eas.sem.mp.DWFactKpiCollection;
import com.kingdee.eas.sem.mp.DWFactKpiFactory;
import com.kingdee.eas.sem.mp.DWFactKpiInfo;
import com.kingdee.eas.sem.mp.IAnalysisItem;
import com.kingdee.eas.sem.mp.IDWCalculateSchema;
import com.kingdee.eas.sem.mp.IDWFactKpi;
import com.kingdee.eas.sem.mp.IKPIFacade;
import com.kingdee.eas.sem.mp.KPIFacadeFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPITimeTypeEnum;
import com.kingdee.eas.sem.mp.app.AbstractDWKPIFacadeControllerBean;
import com.kingdee.eas.sem.mp.formulaservice.timeservice.KPITimeHandle;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class DWKPIFacadeControllerBean
extends AbstractDWKPIFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.sem.mp.app.DWKPIFacadeControllerBean");
    private IDWCalculateSchema iSchema = null;
    private IAnalysisItem iAnalysisItem = null;
    private IDWFactKpi factKpi = null;
    private IKPIFacade kpiFacade = null;

    protected void _calculateFactKpi(Context ctx, String schemaID) throws BOSException {
        if (!this.init(ctx)) {
            return;
        }
        DWCalculateSchemaInfo schemaInfo = this.getCalculateSchema(ctx, schemaID);
        if (null != schemaInfo) {
            this._manualCalculateFactKpi(ctx, schemaInfo);
        }
    }

    protected void _manualCalculateFactKpi(Context ctx, DWCalculateSchemaInfo schemaInfo) throws BOSException {
        if (null == schemaInfo) {
            return;
        }
        if (!this.init(ctx)) {
            return;
        }
        DWCalculateSchemaItemCollection itemCols = schemaInfo.getItem();
        DWCalculateSchemaOrgCollection orgCols = schemaInfo.getCompany();
        AnalysisItemInfo analysisItemInfo = null;
        AnalysisItemEntryCollection itemEntryInfo = null;
        Iterator itemIter = itemCols.iterator();
        String companyID = null;
        while (itemIter.hasNext()) {
            DWCalculateSchemaItemInfo calItemInfo = (DWCalculateSchemaItemInfo)itemIter.next();
            analysisItemInfo = this.getAnalysisItemInfo(ctx, calItemInfo);
            itemEntryInfo = analysisItemInfo.getEntries();
            Iterator itemEntryIter = itemEntryInfo.iterator();
            while (itemEntryIter.hasNext()) {
                AnalysisItemEntryInfo entryInfo = (AnalysisItemEntryInfo)itemEntryIter.next();
                companyID = entryInfo.getKpiCompany().getId().toString();
                if (!this.checkCompanyIsExists(companyID, orgCols)) continue;
                entryInfo.getKpi().setPartFI(entryInfo.getKpiCompany());
                this.calculateFactKpi(ctx, schemaInfo, analysisItemInfo, entryInfo.getKpi());
            }
        }
    }

    private void calculateFactKpi(Context ctx, DWCalculateSchemaInfo schemaInfo, AnalysisItemInfo analysisItemInfo, KPIInfo kpiInfo) {
        if (schemaInfo.isIsAutoSchema()) {
            kpiInfo.put("source", true);
            this.autoUpdateSchema(ctx, schemaInfo, analysisItemInfo, kpiInfo);
        } else {
            kpiInfo.put("source", false);
            this.manualUpdteSchema(ctx, schemaInfo, analysisItemInfo, kpiInfo);
        }
    }

    private void autoUpdateSchema(Context ctx, DWCalculateSchemaInfo schemaInfo, AnalysisItemInfo analysisItemInfo, KPIInfo kpiInfo) {
        Date beginTime = new Date();
        Calendar calendarBegin = Calendar.getInstance();
        calendarBegin.setTime(beginTime);
        if (schemaInfo.isIsPreMonth() && schemaInfo.isIsPreMonth()) {
            calendarBegin.add(2, -1);
            beginTime = calendarBegin.getTime();
            this.autoCreateFactKpi(ctx, kpiInfo, analysisItemInfo, beginTime);
        }
        if (schemaInfo.isIsCurMonth() && schemaInfo.isIsPreMonth()) {
            calendarBegin.add(2, 1);
            beginTime = calendarBegin.getTime();
            this.autoCreateFactKpi(ctx, kpiInfo, analysisItemInfo, beginTime);
        }
    }

    private void manualUpdteSchema(Context ctx, DWCalculateSchemaInfo schemaInfo, AnalysisItemInfo analysisItemInfo, KPIInfo kpiInfo) {
        Date beginTime = schemaInfo.getBeginTime();
        Date endTime = schemaInfo.getEndTime();
        KPITimeTypeEnum timeTypeEnum = kpiInfo.getTimeType();
        if (beginTime != null && endTime != null) {
            if (KPITimeTypeEnum.day.equals((Object)timeTypeEnum)) {
                this.autoCreateKpi_day(ctx, kpiInfo, analysisItemInfo, beginTime, endTime);
            } else if (KPITimeTypeEnum.month.equals((Object)timeTypeEnum)) {
                this.autoCreateKpi_month(ctx, kpiInfo, schemaInfo, analysisItemInfo, beginTime, endTime);
            } else if (KPITimeTypeEnum.week.equals((Object)timeTypeEnum)) {
                this.autoCreateKpi_week(ctx, kpiInfo, analysisItemInfo, beginTime, endTime);
            } else if (KPITimeTypeEnum.halfYear.equals((Object)timeTypeEnum)) {
                this.autoCreateKpi_halfyear(ctx, kpiInfo, analysisItemInfo, beginTime, endTime);
            } else if (KPITimeTypeEnum.season.equals((Object)timeTypeEnum)) {
                this.autoCreateKpi_season(ctx, kpiInfo, analysisItemInfo, beginTime, endTime);
            } else if (KPITimeTypeEnum.year.equals((Object)timeTypeEnum)) {
                this.autoCreateKpi_year(ctx, kpiInfo, analysisItemInfo, beginTime, endTime);
            } else {
                logger.info((Object)("batchCreateKpi() the timeType is:" + (Object)((Object)timeTypeEnum)));
            }
        }
    }

    private void autoCreateFactKpi(Context ctx, KPIInfo kpiInfo, AnalysisItemInfo analysisItemInfo, Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        String timeText = KPITimeHandle.getTimeText(kpiInfo.getTimeType(), calendar);
        try {
            this.autoCreateFactKpi(ctx, kpiInfo, analysisItemInfo, time, timeText);
        }
        catch (Exception e) {
            logger.info((Object)"autoCreateKpi kpiCols is null or size <= 0");
            e.printStackTrace();
        }
    }

    private void autoCreateFactKpi(Context ctx, KPIInfo kpiInfo, AnalysisItemInfo analysisItemInfo, Date date, String timeText) throws EASBizException, BOSException {
        try {
            DWFactKpiInfo factKpiInfo = this.getExistKpiValue(ctx, kpiInfo, analysisItemInfo, timeText);
            if (factKpiInfo != null) {
                this.updateFactKpiValue(ctx, kpiInfo, factKpiInfo, date);
            } else {
                this.newFactKpiValue(ctx, kpiInfo, analysisItemInfo, date, timeText);
            }
        }
        catch (Exception e) {
            logger.info((Object)" autoCreateKpi error!");
            e.printStackTrace();
        }
    }

    private void updateFactKpiValue(Context ctx, KPIInfo kpiInfo, DWFactKpiInfo factKpiInfo, Date date) throws EASBizException, BOSException {
        factKpiInfo.setKpiValue(this.calculateFormula(ctx, kpiInfo, date));
        factKpiInfo.setSource((Boolean)kpiInfo.get("source"));
        this.setBizDate(factKpiInfo, kpiInfo.getTimeType(), date);
        factKpiInfo.setName(kpiInfo.getName());
        factKpiInfo.setNumberUnit(kpiInfo.getNumberUnit());
        this.factKpi.update((IObjectPK)new ObjectUuidPK(factKpiInfo.getId().toString()), (CoreBaseInfo)factKpiInfo);
    }

    private void newFactKpiValue(Context ctx, KPIInfo kpiInfo, AnalysisItemInfo analysisItemInfo, Date date, String timeText) throws EASBizException, BOSException {
        DWFactKpiInfo factKpiInfo = new DWFactKpiInfo();
        factKpiInfo.setBiItem(analysisItemInfo);
        factKpiInfo.setCompany(kpiInfo.getPartFI());
        this.setBizDate(factKpiInfo, kpiInfo.getTimeType(), date);
        factKpiInfo.setKpiValue(this.calculateFormula(ctx, kpiInfo, date));
        factKpiInfo.setTimeText(timeText);
        factKpiInfo.setNumberUnit(kpiInfo.getNumberUnit());
        factKpiInfo.setName(kpiInfo.getName());
        factKpiInfo.setSource((Boolean)kpiInfo.get("source"));
        this.factKpi.addnew(factKpiInfo);
    }

    private BigDecimal calculateFormula(Context ctx, KPIInfo kpiInfo, Date date) {
        BigDecimal formulaValue = null;
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("bizDate", date);
            params.put("timeType", (Object)kpiInfo.getTimeType());
            params.put("company", kpiInfo.getPartFI());
            params.put("chkIsUnpassedVoucherIncluded", kpiInfo.isIsUnpassedVoucherIncluded());
            formulaValue = this.kpiFacade.calcFormula(kpiInfo.getFormula(), params);
        }
        catch (Exception e) {
            formulaValue = new BigDecimal("0.00");
        }
        if (null == formulaValue) {
            formulaValue = new BigDecimal("0.00");
        }
        return formulaValue;
    }

    private void setBizDate(DWFactKpiInfo factKpiInfo, KPITimeTypeEnum timeType, Date date) {
        try {
            if (KPITimeTypeEnum.month.equals((Object)timeType)) {
                factKpiInfo.setBizDate(this.getFormatedDate(date, "yyyy-MM", "-01"));
            }
            if (KPITimeTypeEnum.season.equals((Object)timeType)) {
                factKpiInfo.setBizDate(this.getFormatedDate(date, "yyyy", DWKPIFacadeControllerBean.getFormatSeason(date)));
            }
            if (KPITimeTypeEnum.halfYear.equals((Object)timeType)) {
                factKpiInfo.setBizDate(this.getFormatedDate(date, "yyyy", DWKPIFacadeControllerBean.getFormatHalfYear(date)));
            }
            if (KPITimeTypeEnum.year.equals((Object)timeType)) {
                factKpiInfo.setBizDate(this.getFormatedDate(date, "yyyy", DWKPIFacadeControllerBean.getFormatYear(date)));
            } else {
                factKpiInfo.setBizDate(date);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public Date getFormatedDate(Date date, String format, String ext) throws Exception {
        String dateString = null;
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        dateString = sdf.format(date);
        return sdf.parse(dateString + ext);
    }

    private DWFactKpiInfo getExistKpiValue(Context ctx, KPIInfo kpiInfo, AnalysisItemInfo analysisItemInfo, String timeText) {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sc = view.getSelector();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("biItem.id"));
        sc.add(new SelectorItemInfo("company.id"));
        sc.add(new SelectorItemInfo("bizDate"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("biItem.id", (Object)analysisItemInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)kpiInfo.getPartFI().getId()));
        filter.getFilterItems().add(new FilterItemInfo("timeText", (Object)timeText));
        view.setFilter(filter);
        DWFactKpiCollection cols = null;
        try {
            cols = this.factKpi.getDWFactKpiCollection(view);
        }
        catch (BOSException e) {
            logger.info((Object)"getDWFactKpiCollection error!");
            e.printStackTrace();
        }
        if (cols != null && cols.size() > 0) {
            return cols.get(0);
        }
        return null;
    }

    private void autoCreateKpi_day(Context ctx, KPIInfo kpiInfo, AnalysisItemInfo analysisItemInfo, Date beginPeriod, Date endPeriod) {
        Calendar calendarBegin = Calendar.getInstance();
        while (beginPeriod.compareTo(endPeriod) <= 0) {
            this.autoCreateFactKpi(ctx, kpiInfo, analysisItemInfo, beginPeriod);
            calendarBegin.setTime(beginPeriod);
            calendarBegin.add(5, 1);
            beginPeriod = calendarBegin.getTime();
        }
    }

    private void autoCreateKpi_month(Context ctx, KPIInfo kpiInfo, DWCalculateSchemaInfo schemaInfo, AnalysisItemInfo analysisItemInfo, Date beginPeriod, Date endPeriod) {
        Calendar calendarBegin = Calendar.getInstance();
        Calendar calendarEnd = Calendar.getInstance();
        calendarBegin.setTime(beginPeriod);
        if (schemaInfo.isIsPreMonth()) {
            calendarBegin.add(2, -1);
        } else {
            calendarBegin.add(2, 0);
        }
        calendarEnd.setTime(endPeriod);
        if (schemaInfo.isIsCurMonth()) {
            calendarEnd.add(2, 0);
        } else {
            calendarEnd.add(2, -1);
        }
        beginPeriod = calendarBegin.getTime();
        endPeriod = calendarEnd.getTime();
        while (beginPeriod.compareTo(endPeriod) <= 0) {
            this.autoCreateFactKpi(ctx, kpiInfo, analysisItemInfo, beginPeriod);
            calendarBegin.setTime(beginPeriod);
            calendarBegin.add(2, 1);
            beginPeriod = calendarBegin.getTime();
        }
    }

    private void autoCreateKpi_week(Context ctx, KPIInfo kpiInfo, AnalysisItemInfo analysisItemInfo, Date beginPeriod, Date endPeriod) {
        Calendar calendarBegin = Calendar.getInstance();
        Calendar calendarEnd = Calendar.getInstance();
        calendarBegin.setTime(beginPeriod);
        calendarEnd.setTime(endPeriod);
        int weekEnd = calendarEnd.get(3);
        for (int weekBegin = calendarBegin.get(3); weekBegin <= weekEnd && beginPeriod.compareTo(endPeriod) <= 0; ++weekBegin) {
            this.autoCreateFactKpi(ctx, kpiInfo, analysisItemInfo, beginPeriod);
            calendarBegin.setTime(beginPeriod);
            calendarBegin.add(3, 1);
            beginPeriod = calendarBegin.getTime();
        }
    }

    private void autoCreateKpi_season(Context ctx, KPIInfo kpiInfo, AnalysisItemInfo analysisItemInfo, Date beginPeriod, Date endPeriod) {
        Calendar calendarBegin = Calendar.getInstance();
        Calendar calendarEnd = Calendar.getInstance();
        calendarBegin.setTime(beginPeriod);
        calendarEnd.setTime(endPeriod);
        int endSeason = DWKPIFacadeControllerBean.getSeason(calendarEnd.get(2));
        for (int beginSeason = DWKPIFacadeControllerBean.getSeason(calendarBegin.get(2)); beginSeason <= endSeason; ++beginSeason) {
            this.autoCreateFactKpi(ctx, kpiInfo, analysisItemInfo, beginPeriod);
            calendarBegin.setTime(beginPeriod);
            calendarBegin.add(2, 3);
            beginPeriod = calendarBegin.getTime();
        }
    }

    private void autoCreateKpi_halfyear(Context ctx, KPIInfo kpiInfo, AnalysisItemInfo analysisItemInfo, Date beginPeriod, Date endPeriod) {
        Calendar calendarBegin = Calendar.getInstance();
        Calendar calendarEnd = Calendar.getInstance();
        calendarBegin.setTime(beginPeriod);
        calendarEnd.setTime(endPeriod);
        int beginSeason = calendarBegin.get(2) + 1;
        int endSeason = calendarEnd.get(2) + 1;
        if (beginSeason <= 6) {
            if (endSeason > 6) {
                this.autoCreateFactKpi(ctx, kpiInfo, analysisItemInfo, beginPeriod);
                this.autoCreateFactKpi(ctx, kpiInfo, analysisItemInfo, endPeriod);
            } else {
                this.autoCreateFactKpi(ctx, kpiInfo, analysisItemInfo, beginPeriod);
            }
        } else {
            this.autoCreateFactKpi(ctx, kpiInfo, analysisItemInfo, endPeriod);
        }
    }

    private void autoCreateKpi_year(Context ctx, KPIInfo kpiInfo, AnalysisItemInfo analysisItemInfo, Date beginPeriod, Date endPeriod) {
        Calendar calendarBegin = Calendar.getInstance();
        Calendar calendarEnd = Calendar.getInstance();
        calendarBegin.setTime(beginPeriod);
        calendarBegin.add(1, 0);
        beginPeriod = calendarBegin.getTime();
        calendarEnd.setTime(endPeriod);
        calendarEnd.add(1, 0);
        endPeriod = calendarEnd.getTime();
        while (beginPeriod.compareTo(endPeriod) <= 0) {
            this.autoCreateFactKpi(ctx, kpiInfo, analysisItemInfo, beginPeriod);
            calendarBegin.setTime(beginPeriod);
            calendarBegin.add(1, 1);
            beginPeriod = calendarBegin.getTime();
        }
    }

    private boolean checkCompanyIsExists(String id, DWCalculateSchemaOrgCollection orgCols) {
        boolean flag = false;
        Iterator it = orgCols.iterator();
        while (it.hasNext()) {
            DWCalculateSchemaOrgInfo orgInfo = (DWCalculateSchemaOrgInfo)it.next();
            if (!id.equals(orgInfo.getCompany().getId().toString())) continue;
            flag = true;
            return flag;
        }
        return flag;
    }

    private AnalysisItemInfo getAnalysisItemInfo(Context ctx, DWCalculateSchemaItemInfo calItemInfo) throws BOSException {
        EntityViewInfo itemView = new EntityViewInfo();
        itemView.getSelector().add(new SelectorItemInfo("entries.kpi.id"));
        itemView.getSelector().add(new SelectorItemInfo("id"));
        itemView.getSelector().add(new SelectorItemInfo("entries.kpi.name"));
        itemView.getSelector().add(new SelectorItemInfo("entries.kpi.number"));
        itemView.getSelector().add(new SelectorItemInfo("entries.kpi.formulaClob"));
        itemView.getSelector().add(new SelectorItemInfo("entries.kpi.timeType"));
        itemView.getSelector().add(new SelectorItemInfo("entries.kpi.numberUnit"));
        itemView.getSelector().add(new SelectorItemInfo("entries.kpi.isUnpassedVoucherIncluded"));
        itemView.getSelector().add(new SelectorItemInfo("entries.kpiCompany.id"));
        itemView.getSelector().add(new SelectorItemInfo("entries.kpiCompany.name"));
        itemView.getSelector().add(new SelectorItemInfo("entries.kpiCompany.number"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)calItemInfo.getItem().getId()));
        itemView.setFilter(filter);
        AnalysisItemCollection itemInfoCols = this.iAnalysisItem.getAnalysisItemCollection(itemView);
        if (null != itemInfoCols && itemInfoCols.size() > 0) {
            return itemInfoCols.get(0);
        }
        return null;
    }

    private DWCalculateSchemaInfo getCalculateSchema(Context ctx, String schemaID) throws BOSException {
        DWCalculateSchemaCollection schemaCollection = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.company.id"));
        sic.add(new SelectorItemInfo("company.company.name"));
        sic.add(new SelectorItemInfo("company.company.number"));
        sic.add(new SelectorItemInfo("item.id"));
        sic.add(new SelectorItemInfo("item.item.id"));
        sic.add(new SelectorItemInfo("item.item.name"));
        sic.add(new SelectorItemInfo("item.item.number"));
        sic.add(new SelectorItemInfo("isPreMonth"));
        sic.add(new SelectorItemInfo("isCurMonth"));
        sic.add(new SelectorItemInfo("beginTime"));
        sic.add(new SelectorItemInfo("endTime"));
        sic.add(new SelectorItemInfo("isAutoSchema"));
        sic.add(new SelectorItemInfo("intervalSetted"));
        sic.add(new SelectorItemInfo("jobProcessDef"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)schemaID));
        view.setFilter(filter);
        schemaCollection = this.iSchema.getDWCalculateSchemaCollection(view);
        if (null != schemaCollection && schemaCollection.size() > 0) {
            return schemaCollection.get(0);
        }
        return null;
    }

    private static int getSeason(int month) {
        int season = 1;
        switch (month) {
            case 0: {
                season = 1;
                break;
            }
            case 1: {
                season = 1;
                break;
            }
            case 2: {
                season = 1;
                break;
            }
            case 3: {
                season = 2;
                break;
            }
            case 4: {
                season = 2;
                break;
            }
            case 5: {
                season = 2;
                break;
            }
            case 6: {
                season = 3;
                break;
            }
            case 7: {
                season = 3;
                break;
            }
            case 8: {
                season = 3;
                break;
            }
            case 9: {
                season = 4;
                break;
            }
            case 10: {
                season = 4;
                break;
            }
            case 11: {
                season = 4;
                break;
            }
            default: {
                season = 1;
            }
        }
        return season;
    }

    private static String getFormatSeason(Date date) {
        String format = "";
        int season = 0;
        Calendar calendarBegin = Calendar.getInstance();
        calendarBegin.setTime(date);
        season = calendarBegin.get(2) + 1;
        if (season < 4) {
            format = "-01-01";
        }
        if (season > 3 && season < 7) {
            format = "-04-01";
        }
        if (season > 6 && season < 10) {
            format = "-07-01";
        }
        if (season > 9 && season <= 12) {
            format = "-10-01";
        }
        return format;
    }

    private static String getFormatHalfYear(Date date) {
        String format = "";
        int season = 0;
        Calendar calendarBegin = Calendar.getInstance();
        calendarBegin.setTime(date);
        season = calendarBegin.get(2) + 1;
        format = season < 7 ? "-01-01" : "-07-01";
        return format;
    }

    private static String getFormatYear(Date date) {
        String format = "-01-01";
        return format;
    }

    private boolean init(Context ctx) {
        boolean initFlag = false;
        try {
            if (null == this.iAnalysisItem) {
                this.iAnalysisItem = AnalysisItemFactory.getLocalInstance(ctx);
            }
            if (null == this.iSchema) {
                this.iSchema = DWCalculateSchemaFactory.getLocalInstance(ctx);
            }
            if (null == this.kpiFacade) {
                this.kpiFacade = KPIFacadeFactory.getLocalInstance(ctx);
            }
            if (null == this.factKpi) {
                this.factKpi = DWFactKpiFactory.getLocalInstance(ctx);
            }
            initFlag = true;
        }
        catch (Exception e) {
            initFlag = false;
        }
        return initFlag;
    }
}

