/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.sem.mp.DisplaySchemaInfo;
import com.kingdee.eas.sem.mp.DisplaySchemaKPIFactory;
import com.kingdee.eas.sem.mp.IDisplaySchemaKPI;
import com.kingdee.eas.sem.mp.ISchemaKPI;
import com.kingdee.eas.sem.mp.SchemaKPICollection;
import com.kingdee.eas.sem.mp.SchemaKPIFactory;
import com.kingdee.eas.sem.mp.app.AbstractDisplaySchemaControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DisplaySchemaControllerBean
extends AbstractDisplaySchemaControllerBean {
    private static final long serialVersionUID = 861932432114060574L;
    Logger logger = Logger.getLogger((String)"com.kingdee.eas.sem.mp.app.DisplaySchemaControllerBean");

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.deleteDsKpi(ctx, pk);
        this.deleteDsRpt(ctx, pk);
        super._delete(ctx, pk);
    }

    private void deleteDsRpt(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IDisplaySchemaKPI dsKpi = DisplaySchemaKPIFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("displaySchema", pk.getKeyValue("id")));
        dsKpi.delete(filter);
    }

    private void deleteDsKpi(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        ISchemaKPI dsRpt = SchemaKPIFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("displaySchema", pk.getKeyValue("id")));
        dsRpt.delete(filter);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addNewCheck(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addNewCheck(ctx, model);
        super._update(ctx, pk, model);
    }

    protected void addNewCheck(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        this._checkNameBlank(ctx, model);
        this._checkNameDup(ctx, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UserInfo creator;
        DisplaySchemaInfo dsInfo = (DisplaySchemaInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dsInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        int mask = 0;
        StringBuffer maskString = new StringBuffer();
        maskString.append("#0");
        if (dsInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dsInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            maskString.append(" and #" + ++mask);
        }
        if (dsInfo.getCompany() != null) {
            String orgId = dsInfo.getCompany().getId().toString();
            filterItem = new FilterItemInfo("company", (Object)orgId);
            filter.getFilterItems().add(filterItem);
            maskString.append(" and #" + ++mask);
        }
        if ((creator = dsInfo.getCreator()) == null) {
            creator = new UserInfo();
            creator.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        }
        filter.getFilterItems().add(new FilterItemInfo("creator", (Object)creator.getId().toString()));
        maskString.append(" and #" + ++mask);
        filter.setMaskString(maskString.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dsInfo, "number") + dsInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UserInfo creator;
        DisplaySchemaInfo dsInfo = (DisplaySchemaInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)dsInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        int mask = 0;
        StringBuffer maskString = new StringBuffer();
        maskString.append("#0");
        if (dsInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dsInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            maskString.append(" and #" + ++mask);
        }
        if (dsInfo.getCompany() != null) {
            String orgId = dsInfo.getCompany().getId().toString();
            filterItem = new FilterItemInfo("company", (Object)orgId);
            filter.getFilterItems().add(filterItem);
            maskString.append(" and #" + ++mask);
        }
        if ((creator = dsInfo.getCreator()) == null) {
            creator = new UserInfo();
            creator.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        }
        filter.getFilterItems().add(new FilterItemInfo("creator", (Object)creator.getId().toString()));
        maskString.append(" and #" + ++mask);
        filter.setMaskString(maskString.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, dsInfo, "name") + dsInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    protected List _getPermCollection(Context ctx, String userId, String companyId) throws BOSException, EASBizException {
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        String strTemp = iPermission.getQueryPermissionSQL(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), "mp_SchemaDisplay_View");
        ArrayList<DisplaySchemaInfo> list = new ArrayList<DisplaySchemaInfo>();
        StringBuffer bSql = new StringBuffer();
        bSql.append("select distinct a.FID,a.FNumber,a.FName_L1,a.FName_L2,a.FName_L3,");
        bSql.append("a.FDescription_L1,a.FDescription_L2,a.FDescription_L3,a.FLastUpdateTime ");
        bSql.append(" from T_MP_DisplaySchema a ");
        bSql.append(" inner join ( ");
        bSql.append(strTemp).append(" ) b on a.fid=b.id");
        bSql.append(" where a.fpartfi='").append(companyId).append("' ");
        bSql.append(" order by a.FLastUpdateTime desc ");
        Object[] params = new Object[]{companyId == null ? "" : companyId, userId == null ? "" : userId, userId == null ? "" : userId};
        DisplaySchemaInfo info = null;
        String temp = null;
        try {
            IRowSet rowsets = DbUtil.executeQuery((Context)ctx, (String)bSql.toString());
            while (rowsets.next()) {
                info = new DisplaySchemaInfo();
                temp = rowsets.getString("FID");
                if (temp != null) {
                    info.setId(BOSUuid.read((String)temp));
                }
                temp = rowsets.getString("FNumber");
                info.setNumber(temp);
                temp = rowsets.getString("FName_L1");
                info.setName(temp, new Locale("L1"));
                temp = rowsets.getString("FName_L2");
                info.setName(temp, new Locale("L2"));
                temp = rowsets.getString("FName_L3");
                info.setName(temp, new Locale("L3"));
                temp = rowsets.getString("FDescription_L1");
                info.setDescription(temp, new Locale("L1"));
                temp = rowsets.getString("FDescription_L2");
                info.setDescription(temp, new Locale("L2"));
                temp = rowsets.getString("FDescription_L3");
                info.setDescription(temp, new Locale("L3"));
                list.add(info);
            }
        }
        catch (Exception e) {
            this.logger.info((Object)e);
            e.printStackTrace();
        }
        return list;
    }

    protected SchemaKPICollection _getSelectedKPI(Context ctx, String schemaId) throws BOSException, EASBizException {
        SchemaKPICollection schemaKpiClos = null;
        if (null != schemaId && schemaId.trim().length() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("displaySchema", (Object)schemaId));
            SelectorItemCollection selector = view.getSelector();
            selector.add("selectedKPI.id");
            selector.add("selectedKPI.number");
            selector.add("selectedKPI.name");
            selector.add("selectedKPI.CSF.id");
            selector.add("selectedKPI.CSF.name");
            selector.add("selectedKPI.CSF.BSC");
            selector.add("selectedKPI.CSF.BSC.name");
            selector.add("selectedKPI.isWarnable");
            selector.add("selectedKPI.partFI.id");
            selector.add("selectedKPI.partFI.name");
            selector.add("selectedKPI.refValue.refGroup.name");
            selector.add("selectedKPI.refValue.refValue");
            selector.add("selectedKPI.numberUnit");
            selector.add("selectedKPI.refValue.refGroup");
            selector.add("selectedKPI.partFI");
            selector.add("selectedKPI.formula");
            selector.add("selectedKPI.displayPrecision");
            selector.add("selectedKPI.kpiValue.id");
            selector.add("selectedKPI.kpiValue.timeText");
            selector.add("selectedKPI.kpiValue.name");
            selector.add("selectedKPI.kpiValue.kpiValue");
            selector.add("selectedKPI.kpiValue.displayName");
            selector.add("selectedKPI.kpiValue.currentWarnStatus.*");
            selector.add("selectedKPI.isUnpassedVoucherIncluded");
            SorterItemInfo sort = new SorterItemInfo("kpiOrder");
            sort.setSortType(SortType.ASCEND);
            view.getSorter().add(sort);
            schemaKpiClos = SchemaKPIFactory.getLocalInstance(ctx).getSchemaKPICollection(view);
        }
        return schemaKpiClos;
    }
}

