/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.sem.mp.IKPI;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPIValueCollection;
import com.kingdee.eas.sem.mp.KPIValueInfo;
import com.kingdee.eas.sem.mp.KPIWarnParamCollection;
import com.kingdee.eas.sem.mp.KPIWarnParamInfo;
import com.kingdee.eas.sem.mp.util.CreateRandomString;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ImportKPIHandle {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.sem.mp.app.ImportKPIHandle");

    protected List importDataFromParent(Context ctx, String[] selectKpiId, CompanyOrgUnitInfo currentAdminOrg, CompanyOrgUnitInfo parentAdminOrg, HashMap orgMap) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("kpiValue.*");
        selector.add("kpiValue.warnparam.*");
        selector.add("CSF.*");
        selector.add("CSF.BSC.*");
        selector.add("measureUnit.*");
        selector.add("edgeGroup.*");
        IKPI iKpi = KPIFactory.getLocalInstance(ctx);
        for (int i = 0; i < selectKpiId.length; ++i) {
            String tempStr = selectKpiId[i];
            String[] strs = tempStr.split("!");
            String kpiId = strs[0];
            ObjectUuidPK tempPk = new ObjectUuidPK(BOSUuid.read((String)kpiId));
            KPIInfo kpiInfo = iKpi.getKPIInfo((IObjectPK)tempPk, selector);
            KPIInfo tempKpiInfo = this.getCurrentKpiInfo(ctx, iKpi, kpiId, currentAdminOrg.getId());
            if (tempKpiInfo != null) continue;
            KPIInfo parentKpiInfo = null;
            parentKpiInfo = kpiInfo.getParent() != null ? kpiInfo.getParent() : kpiInfo;
        }
        return null;
    }

    protected KPIValueCollection cloneKpiValueCols(KPIValueCollection sourceCols, KPIValueCollection targetCols) {
        if (sourceCols == null) {
            return null;
        }
        if (targetCols == null) {
            return null;
        }
        targetCols.clear();
        Iterator ite = sourceCols.iterator();
        while (ite.hasNext()) {
            String tempNumber = CreateRandomString.getRandomString();
            KPIValueInfo tempValueInfo = (KPIValueInfo)ite.next();
            KPIValueInfo newValueInfo = (KPIValueInfo)tempValueInfo.clone();
            newValueInfo.setNumber(tempNumber);
            newValueInfo.setId(null);
            newValueInfo.setKpi(null);
            newValueInfo.setLongnumber(tempValueInfo.getLongnumber() + "!" + tempNumber);
            this.cloneKpiWarnParam(tempValueInfo.getWarnparam(), newValueInfo.getWarnparam());
            targetCols.add(newValueInfo);
        }
        return targetCols;
    }

    protected KPIWarnParamCollection cloneKpiWarnParam(KPIWarnParamCollection sourceCols, KPIWarnParamCollection targetCols) {
        if (sourceCols == null) {
            return null;
        }
        if (targetCols == null) {
            return null;
        }
        targetCols.clear();
        Iterator ite = sourceCols.iterator();
        while (ite.hasNext()) {
            KPIWarnParamInfo tempInfo = (KPIWarnParamInfo)ite.next();
            KPIWarnParamInfo newInfo = (KPIWarnParamInfo)tempInfo.clone();
            newInfo.setKpiValue(null);
            newInfo.setId(null);
            targetCols.add(newInfo);
        }
        return targetCols;
    }

    protected List importDataFromParent(Context ctx, String[] selectKpiId, HashMap orgMap) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currentAdminOrg = (CompanyOrgUnitInfo)orgMap.get("currentAdminOrg");
        CompanyOrgUnitInfo parentAdminOrg = (CompanyOrgUnitInfo)orgMap.get("parentAdminOrg");
        return this.importDataFromParent(ctx, selectKpiId, currentAdminOrg, parentAdminOrg, orgMap);
    }

    private KPIInfo getCurrentKpiInfo(Context ctx, IKPI ikpi, String kpiId, BOSUuid currentAdminOrg) throws BOSException, EASBizException {
        KPIInfo kpiInfo = null;
        String sql = "select fid from t_mp_kpi where fparentid=? and FCompanyID=? ";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{kpiId, currentAdminOrg.toString()});
            if (rowSet != null && rowSet.next()) {
                kpiInfo = ikpi.getKPIInfo((IObjectPK)new ObjectUuidPK(rowSet.getString("fid")));
            }
        }
        catch (SQLException e) {
            logger.info((Object)"ImportKPIHandle,getCurrentKpiInfo() error!");
            e.printStackTrace();
        }
        return kpiInfo;
    }
}

