/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.sem.mp.IKPIValue;
import com.kingdee.eas.sem.mp.IKPIValueRefStandardValue;
import com.kingdee.eas.sem.mp.IKPIWarnParam;
import com.kingdee.eas.sem.mp.IRefGroup;
import com.kingdee.eas.sem.mp.IWarnGroup;
import com.kingdee.eas.sem.mp.KPICollection;
import com.kingdee.eas.sem.mp.KPIFacadeFactory;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewCollection;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewInfo;
import com.kingdee.eas.sem.mp.KPITimeTypeEnum;
import com.kingdee.eas.sem.mp.KPIValueCollection;
import com.kingdee.eas.sem.mp.KPIValueFactory;
import com.kingdee.eas.sem.mp.KPIValueInfo;
import com.kingdee.eas.sem.mp.KPIValueRefStandardValueCollection;
import com.kingdee.eas.sem.mp.KPIValueRefStandardValueFactory;
import com.kingdee.eas.sem.mp.KPIValueRefStandardValueInfo;
import com.kingdee.eas.sem.mp.KPIWarnParamFactory;
import com.kingdee.eas.sem.mp.KPIWarnParamInfo;
import com.kingdee.eas.sem.mp.KPIWarnParamNewCollection;
import com.kingdee.eas.sem.mp.KPIWarnParamNewInfo;
import com.kingdee.eas.sem.mp.RefGroupCollection;
import com.kingdee.eas.sem.mp.RefGroupFactory;
import com.kingdee.eas.sem.mp.RefGroupInfo;
import com.kingdee.eas.sem.mp.UpdateSchemaInfo;
import com.kingdee.eas.sem.mp.UpdateSchemaKPIRelaCollection;
import com.kingdee.eas.sem.mp.WarnGroupCollection;
import com.kingdee.eas.sem.mp.WarnGroupFactory;
import com.kingdee.eas.sem.mp.WarnGroupInfo;
import com.kingdee.eas.sem.mp.app.KPIAutoCreateInterface;
import com.kingdee.eas.sem.mp.formulaservice.timeservice.KPITimeHandle;
import com.kingdee.eas.sem.mp.util.CreateRandomString;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.ScriptUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class KPIAutoCreateKpiHandler
implements KPIAutoCreateInterface {
    Logger logger = Logger.getLogger((String)"com.kingdee.eas.sem.mp.app.KPIAutoCreateKpiHandler");
    private HashMap refGroupIdToName;
    private HashMap refGroupNameToId;
    protected static final String RES = "com.kingdee.eas.sem.mp.MPResource";

    public void batchCreateKpi(Context ctx, UpdateSchemaInfo updateInfo) {
        UpdateSchemaInfo updateSchemaInfo = updateInfo;
        if (updateSchemaInfo == null) {
            this.logger.info((Object)"In the createOrUpdateKPI() updateSchemaInfo is null!");
            return;
        }
        String updateAction = updateSchemaInfo.getActionType();
        boolean isManual = false;
        if ("MenuCreateKpi".equals(updateAction)) {
            isManual = true;
        } else if (ctx != null) {
            ctx.put((Object)"caclType", (Object)"backSche");
        }
        UpdateSchemaKPIRelaCollection updateSchemaKPIRelaCollection = updateInfo.getSolutionRela();
        List companyIDs = this.getRelaCompany(ctx, updateInfo);
        if (companyIDs == null || companyIDs.size() <= 0) {
            this.logger.info((Object)" batchCreateKpi , getRelaCompany is null ");
            return;
        }
        if (updateSchemaKPIRelaCollection == null || updateSchemaKPIRelaCollection.size() <= 0) {
            this.logger.info((Object)"In the KPIHandle,createOrUpdateKPI(),the updateSchemaKPIRelaCollection is null or size <= 0");
            return;
        }
        if (companyIDs == null || companyIDs.size() <= 0) {
            this.logger.info((Object)"In the KPIHandle,createOrUpdateKPI(),the updateSchemaCompanyCols is null or size <= 0");
            return;
        }
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("refValue.*"));
        sc.add(new SelectorItemInfo("currentWarnStatus.*"));
        sc.add(new SelectorItemInfo("warnParam.*"));
        Date beginPeriod = null;
        Date endPeriod = null;
        KPIInfo kpiInfo = null;
        KPICollection kpiCols = null;
        int size = updateSchemaKPIRelaCollection.size();
        for (int i = 0; i < size; ++i) {
            KPIInfo tempKpiInfo = updateSchemaKPIRelaCollection.get(i).getKPI();
            try {
                kpiInfo = KPIFactory.getLocalInstance(ctx).getKPIInfo((IObjectPK)new ObjectUuidPK(tempKpiInfo.getId()), sc);
            }
            catch (Exception e) {
                this.logger.info((Object)" get kpi error");
                e.printStackTrace();
            }
            if (kpiInfo == null) continue;
            KPITimeTypeEnum timeTypeEnum = kpiInfo.getTimeType();
            beginPeriod = updateInfo.getBeginPeriod();
            endPeriod = updateInfo.getEndPeriod();
            kpiCols = this.getExistKpiInfo(ctx, kpiInfo.getId().toString(), companyIDs);
            if (isManual) {
                if (beginPeriod != null && endPeriod != null) {
                    if (KPITimeTypeEnum.day.equals((Object)timeTypeEnum)) {
                        this.autoCreateKpi_day(ctx, kpiCols, timeTypeEnum, beginPeriod, endPeriod);
                        continue;
                    }
                    if (KPITimeTypeEnum.month.equals((Object)timeTypeEnum)) {
                        this.autoCreateKpi_month(ctx, kpiCols, timeTypeEnum, beginPeriod, endPeriod);
                        continue;
                    }
                    if (KPITimeTypeEnum.week.equals((Object)timeTypeEnum)) {
                        this.autoCreateKpi_week(ctx, kpiCols, timeTypeEnum, beginPeriod, endPeriod);
                        continue;
                    }
                    if (KPITimeTypeEnum.halfYear.equals((Object)timeTypeEnum)) {
                        this.autoCreateKpi_halfyear(ctx, kpiCols, timeTypeEnum, beginPeriod, endPeriod);
                        continue;
                    }
                    if (KPITimeTypeEnum.season.equals((Object)timeTypeEnum)) {
                        this.autoCreateKpi_season(ctx, kpiCols, timeTypeEnum, beginPeriod, endPeriod);
                        continue;
                    }
                    if (KPITimeTypeEnum.year.equals((Object)timeTypeEnum)) {
                        this.autoCreateKpi_year(ctx, kpiCols, timeTypeEnum, beginPeriod, endPeriod);
                        continue;
                    }
                    this.logger.info((Object)("batchCreateKpi() the timeType is:" + (Object)((Object)timeTypeEnum)));
                    continue;
                }
                if (beginPeriod != null) {
                    this.autoCreateKpi(ctx, kpiCols, timeTypeEnum, beginPeriod);
                    continue;
                }
                this.autoCreateKpi(ctx, kpiCols, timeTypeEnum, endPeriod);
                continue;
            }
            this.autoCreateKpi(ctx, kpiCols, timeTypeEnum, new Date());
        }
    }

    private void autoCreateKpi(Context ctx, KPICollection kpiCols, KPITimeTypeEnum timeType, Date time) {
        if (kpiCols == null || kpiCols.size() <= 0) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        String timeText = KPITimeHandle.getTimeText(timeType, calendar);
        try {
            this.autoCreateKpi(ctx, kpiCols, timeType, time, timeText);
        }
        catch (Exception e) {
            this.logger.info((Object)"autoCreateKpi kpiCols is null or size <= 0");
            e.printStackTrace();
        }
    }

    private void autoCreateKpi(Context ctx, KPICollection kpiCols, KPITimeTypeEnum timeType, Date date, String timeText) throws EASBizException, BOSException {
        if (kpiCols == null || kpiCols.size() <= 0) {
            return;
        }
        int size = kpiCols.size();
        for (int i = 0; i < size; ++i) {
            try {
                KPIInfo kpiInfo = kpiCols.get(i);
                this.initRefGroupIdToName(ctx, (OrgUnitInfo)kpiInfo.getPartFI());
                KPIValueInfo kpiValueInfo = this.getExistKpiValue(ctx, kpiInfo, timeText);
                if (kpiValueInfo != null) {
                    this.updateKpiValue(ctx, kpiInfo, kpiValueInfo, timeType, date);
                    continue;
                }
                this.newKpiValue(ctx, kpiInfo, timeType, date, timeText);
                continue;
            }
            catch (Exception e) {
                throw new BOSException("autoCreateKpi exception..");
            }
        }
    }

    private void newKpiValue(Context ctx, KPIInfo kpiInfo, KPITimeTypeEnum timeType, Date date, String timeText) throws EASBizException, BOSException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("bizDate", date);
        params.put("timeType", (Object)timeType);
        params.put("company", kpiInfo.getCompany());
        params.put("IncludePosted", kpiInfo.isIsUnpassedVoucherIncluded());
        params.put("IncludeLeaf", kpiInfo.isIsDetailItemBalanceInclude());
        params.put("IncludeSub", kpiInfo.isIsSubItemBalanceInclude());
        BigDecimal formulaValue = KPIFacadeFactory.getLocalInstance(ctx).calcFormula(kpiInfo.getFormula(), params);
        if (formulaValue == null) {
            this.logger.info((Object)(kpiInfo.getName() + ":formula config error!"));
            return;
        }
        KPIValueInfo valueInfo = new KPIValueInfo();
        valueInfo.setBizDate(date);
        valueInfo.setId(null);
        Timestamp tempTime = this.getTime();
        valueInfo.setCreateTime(tempTime);
        valueInfo.setLastUpdateTime(tempTime);
        valueInfo.setLastComputeTime(this.getTime());
        String tempNumber = CreateRandomString.getRandomString();
        valueInfo.setNumber(tempNumber);
        valueInfo.setLongnumber(tempNumber);
        valueInfo.setTimeText(timeText);
        valueInfo.setKpi(kpiInfo);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String tempDisplayName = KPITimeHandle.getTimeDisplay(timeType, calendar, LocaleUtils.getLocale((String)"L1"));
        valueInfo.setName(tempDisplayName, LocaleUtils.getLocale((String)"L1"));
        valueInfo.setDisplayName(tempDisplayName, LocaleUtils.getLocale((String)"L1"));
        tempDisplayName = KPITimeHandle.getTimeDisplay(timeType, calendar, LocaleUtils.getLocale((String)"L2"));
        valueInfo.setName(tempDisplayName, LocaleUtils.getLocale((String)"L2"));
        valueInfo.setDisplayName(tempDisplayName, LocaleUtils.getLocale((String)"L2"));
        tempDisplayName = KPITimeHandle.getTimeDisplay(timeType, calendar, LocaleUtils.getLocale((String)"L3"));
        valueInfo.setDisplayName(tempDisplayName, LocaleUtils.getLocale((String)"L3"));
        valueInfo.setName(tempDisplayName, LocaleUtils.getLocale((String)"L3"));
        valueInfo.setKpiValue(formulaValue);
        KPIWarnParamNewCollection tempWarnCols = kpiInfo.getWarnParam();
        if (kpiInfo.isIsWarnable()) {
            this.setKpiValueCurrentWarn(ctx, kpiInfo, valueInfo, tempWarnCols);
        } else {
            valueInfo.setCurrentWarnStatus(null);
        }
        IObjectPK newValuePk = KPIValueFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)valueInfo);
        KPIValueInfo newValueInfo = KPIValueFactory.getLocalInstance(ctx).getKPIValueInfo(newValuePk);
        this.newKPIValueEntries(ctx, kpiInfo, newValueInfo, params);
    }

    private void updateKpiValue(Context ctx, KPIInfo kpiInfo, KPIValueInfo valueInfo, KPITimeTypeEnum timeType, Date date) throws EASBizException, BOSException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("bizDate", date);
        params.put("timeType", (Object)timeType);
        params.put("company", kpiInfo.getCompany());
        params.put("IncludePosted", kpiInfo.isIsUnpassedVoucherIncluded());
        params.put("IncludeLeaf", kpiInfo.isIsDetailItemBalanceInclude());
        params.put("IncludeSub", kpiInfo.isIsSubItemBalanceInclude());
        BigDecimal formulaValue = KPIFacadeFactory.getLocalInstance(ctx).calcFormula(kpiInfo.getFormula(), params);
        if (null == formulaValue) {
            this.logger.info((Object)(kpiInfo.getName() + ":formula config error!"));
            return;
        }
        valueInfo.setKpiValue(formulaValue);
        if (kpiInfo.isIsWarnable()) {
            this.setKpiValueCurrentWarn(ctx, kpiInfo, valueInfo, kpiInfo.getWarnParam());
        } else {
            valueInfo.setCurrentWarnStatus(null);
        }
        KPIValueFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(valueInfo.getId().toString()), (CoreBaseInfo)valueInfo);
        String tempKpiValueId = valueInfo.getId().toString();
        this.deleteCollection(ctx, tempKpiValueId);
        this.newKPIValueEntries(ctx, kpiInfo, valueInfo, params);
    }

    private void newKPIValueEntries(Context ctx, KPIInfo kpiInfo, KPIValueInfo valueInfo, Map params) throws BOSException {
        try {
            BigDecimal formulaValue = null;
            KPIRefStandardValueNewCollection standardValueCols = kpiInfo.getRefValue();
            IKPIValueRefStandardValue iREF = KPIValueRefStandardValueFactory.getLocalInstance(ctx);
            KPIValueRefStandardValueCollection tempCols = new KPIValueRefStandardValueCollection();
            for (int i = 0; i < standardValueCols.size(); ++i) {
                KPIValueRefStandardValueInfo rfsInfo = new KPIValueRefStandardValueInfo();
                KPIRefStandardValueNewInfo svn = standardValueCols.get(i);
                if (null != svn.getRefValue()) {
                    formulaValue = KPIFacadeFactory.getLocalInstance(ctx).calcFormula(svn.getRefValue(), params);
                    rfsInfo.setRefValue(formulaValue);
                }
                rfsInfo.setRefParam(svn.getRefValue());
                rfsInfo.setKPIValue(valueInfo);
                rfsInfo.setRefGroup(svn.getRefGroup());
                iREF.addnew(rfsInfo);
                tempCols.add(rfsInfo);
            }
            KPIWarnParamNewCollection tempWarnCols = kpiInfo.getWarnParam();
            IKPIWarnParam iWarnparam = KPIWarnParamFactory.getLocalInstance(ctx);
            for (int i = 0; i < tempWarnCols.size(); ++i) {
                KPIWarnParamNewInfo wpnf = tempWarnCols.get(i);
                KPIWarnParamInfo warnParamInfo = new KPIWarnParamInfo();
                warnParamInfo.setEdgeParam(wpnf.getEdgeParam());
                warnParamInfo.setWarnGroup(wpnf.getWarnGroup());
                warnParamInfo.setWarnSchema(wpnf.getWarnSchema());
                warnParamInfo.setParamValue(wpnf.getParamValue());
                if (null != wpnf.getParamValue()) {
                    formulaValue = this.calculateWarnParamCurrentValue(tempCols, wpnf.getParamValue());
                    warnParamInfo.setCurrentValue(formulaValue);
                }
                warnParamInfo.setKpiValue(valueInfo);
                iWarnparam.addnew(warnParamInfo);
            }
        }
        catch (Exception e) {
            throw new BOSException("newKPIValueEntries exception");
        }
    }

    private KPIValueInfo getFirstKPIValue(Context ctx, KPIInfo kpiInfo) throws BOSException {
        if (kpiInfo == null) {
            return null;
        }
        IKPIValue kpiValue = KPIValueFactory.getLocalInstance(ctx);
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection selector = ev.getSelector();
        selector.add("*");
        selector.add("warnparam.*");
        selector.add("warnparam.warnGroup.*");
        selector.add("currentWarnStatus.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("kpi.id", (Object)kpiInfo.getId().toString()));
        ev.setFilter(filter);
        SorterItemInfo sorterInfo = new SorterItemInfo("bizDate");
        sorterInfo.setSortType(SortType.DESCEND);
        ev.getSorter().add(sorterInfo);
        KPIValueCollection cols = kpiValue.getKPIValueCollection(ev);
        if (cols != null && cols.size() > 0) {
            return cols.get(0);
        }
        return null;
    }

    private KPICollection getExistKpiInfo(Context ctx, String parentId, List companyIDs) {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("warnParam.*"));
        view.getSelector().add(new SelectorItemInfo("refValue.*"));
        view.getSelector().add(new SelectorItemInfo("currentWarnStatus.*"));
        StringBuffer mask = new StringBuffer();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)parentId));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)parentId));
        mask.append(" (#0 or #1) and (");
        Iterator ite = companyIDs.iterator();
        if (ite.hasNext()) {
            filter.getFilterItems().add(new FilterItemInfo("partFI.id", (Object)ite.next().toString()));
            mask.append(" #2 ");
        }
        int i = 3;
        while (ite.hasNext()) {
            filter.getFilterItems().add(new FilterItemInfo("partFI.id", (Object)ite.next().toString()));
            mask.append(" or #").append(i++);
        }
        mask.append(" ) ");
        filter.setMaskString(mask.toString());
        view.setFilter(filter);
        SorterItemInfo sorterInfo = new SorterItemInfo("partFI.longNumber");
        sorterInfo.setSortType(SortType.ASCEND);
        view.getSorter().add(sorterInfo);
        KPICollection cols = null;
        try {
            cols = KPIFactory.getLocalInstance(ctx).getKPICollection(view);
        }
        catch (BOSException e) {
            this.logger.info((Object)"getExistKpiInfo error!");
            e.printStackTrace();
        }
        return cols;
    }

    private KPIValueInfo getExistKpiValue(Context ctx, KPIInfo kpiInfo, String timeText) {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sc = view.getSelector();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("warnparam.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("kpi.id", (Object)kpiInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("timeText", (Object)timeText));
        view.setFilter(filter);
        KPIValueInfo kpiValueInfo = null;
        KPIValueCollection cols = null;
        try {
            cols = KPIValueFactory.getLocalInstance(ctx).getKPIValueCollection(view);
        }
        catch (BOSException e) {
            this.logger.info((Object)"getExistKpiValue error!");
            e.printStackTrace();
        }
        if (cols != null && cols.size() > 0) {
            kpiValueInfo = cols.get(0);
        }
        return kpiValueInfo;
    }

    private void autoCreateKpi_day(Context ctx, KPICollection kpiCols, KPITimeTypeEnum timeTypeEnum, Date beginPeriod, Date endPeriod) {
        Calendar calendarBegin = Calendar.getInstance();
        while (beginPeriod.compareTo(endPeriod) <= 0) {
            this.autoCreateKpi(ctx, kpiCols, timeTypeEnum, beginPeriod);
            calendarBegin.setTime(beginPeriod);
            calendarBegin.add(5, 1);
            beginPeriod = calendarBegin.getTime();
        }
    }

    private void autoCreateKpi_month(Context ctx, KPICollection kpiCols, KPITimeTypeEnum timeTypeEnum, Date beginPeriod, Date endPeriod) {
        Calendar calendarBegin = Calendar.getInstance();
        Calendar calendarEnd = Calendar.getInstance();
        calendarBegin.setTime(beginPeriod);
        calendarBegin.add(2, 0);
        calendarEnd.setTime(endPeriod);
        calendarEnd.add(2, 0);
        beginPeriod = calendarBegin.getTime();
        endPeriod = calendarEnd.getTime();
        while (beginPeriod.compareTo(endPeriod) <= 0) {
            this.autoCreateKpi(ctx, kpiCols, timeTypeEnum, beginPeriod);
            calendarBegin.setTime(beginPeriod);
            calendarBegin.add(2, 1);
            beginPeriod = calendarBegin.getTime();
        }
    }

    private void autoCreateKpi_week(Context ctx, KPICollection kpiCols, KPITimeTypeEnum timeTypeEnum, Date beginPeriod, Date endPeriod) {
        Calendar calendarBegin = Calendar.getInstance();
        Calendar calendarEnd = Calendar.getInstance();
        calendarBegin.setTime(beginPeriod);
        calendarEnd.setTime(endPeriod);
        int weekEnd = calendarEnd.get(3);
        for (int weekBegin = calendarBegin.get(3); weekBegin <= weekEnd && beginPeriod.compareTo(endPeriod) <= 0; ++weekBegin) {
            this.autoCreateKpi(ctx, kpiCols, timeTypeEnum, beginPeriod);
            calendarBegin.setTime(beginPeriod);
            calendarBegin.add(3, 1);
            beginPeriod = calendarBegin.getTime();
        }
    }

    private void autoCreateKpi_season(Context ctx, KPICollection kpiCols, KPITimeTypeEnum timeTypeEnum, Date beginPeriod, Date endPeriod) {
        Calendar calendarBegin = Calendar.getInstance();
        Calendar calendarEnd = Calendar.getInstance();
        calendarBegin.setTime(beginPeriod);
        calendarEnd.setTime(endPeriod);
        int endSeason = this.getSeason(calendarEnd.get(2));
        for (int beginSeason = this.getSeason(calendarBegin.get(2)); beginSeason <= endSeason; ++beginSeason) {
            this.autoCreateKpi(ctx, kpiCols, timeTypeEnum, beginPeriod);
            calendarBegin.setTime(beginPeriod);
            calendarBegin.add(2, 3);
            beginPeriod = calendarBegin.getTime();
        }
    }

    private void autoCreateKpi_halfyear(Context ctx, KPICollection kpiCols, KPITimeTypeEnum timeTypeEnum, Date beginPeriod, Date endPeriod) {
        Calendar calendarBegin = Calendar.getInstance();
        Calendar calendarEnd = Calendar.getInstance();
        calendarBegin.setTime(beginPeriod);
        calendarEnd.setTime(endPeriod);
        int beginSeason = calendarBegin.get(2) + 1;
        int endSeason = calendarEnd.get(2) + 1;
        if (beginSeason <= 6) {
            if (endSeason > 6) {
                this.autoCreateKpi(ctx, kpiCols, timeTypeEnum, beginPeriod);
                this.autoCreateKpi(ctx, kpiCols, timeTypeEnum, endPeriod);
            } else {
                this.autoCreateKpi(ctx, kpiCols, timeTypeEnum, beginPeriod);
            }
        } else {
            this.autoCreateKpi(ctx, kpiCols, timeTypeEnum, endPeriod);
        }
    }

    private void autoCreateKpi_year(Context ctx, KPICollection kpiCols, KPITimeTypeEnum timeTypeEnum, Date beginPeriod, Date endPeriod) {
        Calendar calendarBegin = Calendar.getInstance();
        Calendar calendarEnd = Calendar.getInstance();
        calendarBegin.setTime(beginPeriod);
        calendarBegin.add(1, 0);
        beginPeriod = calendarBegin.getTime();
        calendarEnd.setTime(endPeriod);
        calendarEnd.add(1, 0);
        endPeriod = calendarEnd.getTime();
        while (beginPeriod.compareTo(endPeriod) <= 0) {
            this.autoCreateKpi(ctx, kpiCols, timeTypeEnum, beginPeriod);
            calendarBegin.setTime(beginPeriod);
            calendarBegin.add(1, 1);
            beginPeriod = calendarBegin.getTime();
        }
    }

    private List getRelaCompany(Context ctx, UpdateSchemaInfo updateInfo) {
        StringBuffer sele = new StringBuffer();
        sele.append(" select t1.fid,t1.flongnumber from t_org_company t1 ");
        sele.append(" inner join T_MP_UpdateSchemaCompanyRela t2 on t1.fid=t2.FPARTID ");
        sele.append(" where t2.FSchemaID=? ");
        sele.append(" order by t1.flongnumber asc ");
        ArrayList<String> companys = new ArrayList<String>();
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sele.toString(), (Object[])new String[]{updateInfo.getId().toString()});
            if (rowSet != null) {
                while (rowSet.next()) {
                    companys.add(rowSet.getString("fid"));
                }
            }
        }
        catch (Exception e) {
            this.logger.info((Object)" get getRelaCompany error !");
            e.printStackTrace();
        }
        return companys;
    }

    private void setKpiValueCurrentWarn(Context ctx, KPIInfo kpiInfo, KPIValueInfo valueInfo, KPIWarnParamNewCollection params) throws BOSException, EASBizException {
        if (params == null) {
            return;
        }
        if (params != null) {
            BigDecimal kpiValue = valueInfo.getKpiValue();
            HashMap<String, BigDecimal> paramsMap = new HashMap<String, BigDecimal>();
            int paramCount = params.size();
            for (int i = 0; i < paramCount; ++i) {
                KPIWarnParamNewInfo paramInfo = params.get(i);
                paramsMap.put(paramInfo.getEdgeParam().getId().toString() + paramInfo.getWarnGroup().getId().toString(), paramInfo.getCurrentValue());
            }
            String egFormula = " " + kpiInfo.getCurrentWarnStatus().getFormula();
            IWarnGroup warnGroup = WarnGroupFactory.getLocalInstance(ctx);
            EntityViewInfo wgevi = new EntityViewInfo();
            SorterItemInfo sort = new SorterItemInfo("periority");
            sort.setSortType(SortType.ASCEND);
            wgevi.getSorter().add(sort);
            WarnGroupCollection wgs = warnGroup.getWarnGroupCollection(wgevi);
            if (wgs != null) {
                int i;
                int wgCount = wgs.size();
                for (i = 0; i < wgCount - 1; ++i) {
                    WarnGroupInfo wgInfo = wgs.get(i);
                    StringTokenizer st = new StringTokenizer(egFormula, "$");
                    StringBuffer scriptFormula = new StringBuffer();
                    boolean flag = true;
                    while (st.hasMoreTokens()) {
                        if (flag) {
                            scriptFormula.append(st.nextToken());
                        } else {
                            String token = st.nextToken();
                            if (token.equalsIgnoreCase("CURRENTVALUE")) {
                                scriptFormula.append(kpiValue);
                            } else {
                                token = token + wgInfo.getId().toString();
                                BigDecimal paramValue = (BigDecimal)paramsMap.get(token);
                                scriptFormula.append(paramValue);
                            }
                        }
                        flag = !flag;
                    }
                    boolean result = (Boolean)ScriptUtil.evalExpr((String)scriptFormula.toString(), null);
                    if (result) break;
                }
                if (i < wgCount) {
                    valueInfo.setCurrentWarnStatus(wgs.get(i));
                }
            }
        }
    }

    private KPIWarnParamInfo getKPIWarnParamInfo(Context ctx, KPIWarnParamInfo warnParamInfo) throws EASBizException, BOSException {
        if (warnParamInfo == null) {
            return null;
        }
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("warnGroup.*"));
        sc.add(new SelectorItemInfo("edgeParam.*"));
        return KPIWarnParamFactory.getLocalInstance(ctx).getKPIWarnParamInfo((IObjectPK)new ObjectUuidPK(warnParamInfo.getId()), sc);
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private int getSeason(int month) {
        int season = 1;
        switch (month) {
            case 0: {
                season = 1;
                break;
            }
            case 1: {
                season = 1;
                break;
            }
            case 2: {
                season = 1;
                break;
            }
            case 3: {
                season = 2;
                break;
            }
            case 4: {
                season = 2;
                break;
            }
            case 5: {
                season = 2;
                break;
            }
            case 6: {
                season = 3;
                break;
            }
            case 7: {
                season = 3;
                break;
            }
            case 8: {
                season = 3;
                break;
            }
            case 9: {
                season = 4;
                break;
            }
            case 10: {
                season = 4;
                break;
            }
            case 11: {
                season = 4;
                break;
            }
            default: {
                season = 1;
            }
        }
        return season;
    }

    public void singleCreateKpi(Context ctx, KPIInfo kpiInfo, Date date) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            String timeText = KPITimeHandle.getTimeText(kpiInfo.getTimeType(), calendar);
            KPIValueInfo kpiValueInfo = this.getExistKpiValue(ctx, kpiInfo, timeText);
            this.initRefGroupIdToName(ctx, (OrgUnitInfo)kpiInfo.getPartFI());
            if (kpiValueInfo != null) {
                this.updateKpiValue(ctx, kpiInfo, kpiValueInfo, kpiInfo.getTimeType(), date);
            } else {
                this.newKpiValue(ctx, kpiInfo, kpiInfo.getTimeType(), date, timeText);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initRefGroupIdToName(Context ctx, OrgUnitInfo company) throws BOSException {
        this.refGroupIdToName = new HashMap();
        this.refGroupNameToId = new HashMap();
        IRefGroup refGroup = RefGroupFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("partFI.id", (Object)company.getId().toString()));
        evi.setFilter(filter);
        RefGroupCollection refGroupInfos = refGroup.getRefGroupCollection(evi);
        int count = refGroupInfos.size();
        for (int i = 0; i < count; ++i) {
            RefGroupInfo refGroupInfo = refGroupInfos.get(i);
            this.refGroupIdToName.put(refGroupInfo.getId().toString(), refGroupInfo.getName());
            this.refGroupNameToId.put(refGroupInfo.getName(), refGroupInfo.getId().toString());
        }
    }

    private StringBuffer convertNameToId(String nameFormula) {
        StringTokenizer st = new StringTokenizer(" " + nameFormula, "$");
        StringBuffer formulaBuffer = new StringBuffer();
        boolean flag = true;
        while (st.hasMoreTokens()) {
            if (flag) {
                formulaBuffer.append(st.nextToken());
            } else {
                formulaBuffer.append("$");
                formulaBuffer.append(this.refGroupNameToId.get(st.nextToken()));
                formulaBuffer.append("$");
            }
            flag = !flag;
        }
        formulaBuffer = formulaBuffer.deleteCharAt(0);
        return formulaBuffer;
    }

    private BigDecimal calculateWarnParamCurrentValue(KPIValueRefStandardValueCollection tempCols, String ParamValue) throws BOSException {
        return this.execParamValue(tempCols, ParamValue);
    }

    private BigDecimal execParamValue(KPIValueRefStandardValueCollection tempCols, String paramValue) throws BOSException {
        paramValue = " " + paramValue;
        StringTokenizer st = new StringTokenizer(paramValue, "$");
        StringBuffer formula = new StringBuffer();
        boolean flag = true;
        BigDecimal value = null;
        while (st.hasMoreTokens()) {
            if (flag) {
                formula.append(st.nextToken());
            } else {
                String refGroupId = st.nextToken();
                Iterator it = tempCols.iterator();
                while (it.hasNext()) {
                    KPIValueRefStandardValueInfo refValue = (KPIValueRefStandardValueInfo)it.next();
                    if (!refValue.getRefGroup().getId().toString().equalsIgnoreCase(refGroupId)) continue;
                    value = refValue.getRefValue();
                }
                if (value != null) {
                    formula.append(value);
                }
            }
            flag = !flag;
        }
        BigDecimal currentValue = null;
        try {
            currentValue = new BigDecimal(ScriptUtil.evalExpr((String)formula.toString(), null).toString());
        }
        catch (Exception e) {
            throw new BOSException(this.getClass() + " execParamValue exceptin");
        }
        return currentValue;
    }

    private void deleteCollection(Context ctx, String kpiValueID) throws BOSException {
        try {
            String sql = "delete from T_MP_KPIWarnParam where fkpiValue=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{kpiValueID});
            sql = "delete from T_MP_KPIValueRefStandardValue where fkpiValueid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{kpiValueID});
        }
        catch (Exception e) {
            throw new BOSException("delete exception");
        }
    }
}

