/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.sem.mp.IKPIRefStandardValueNew;
import com.kingdee.eas.sem.mp.IKPIRefValue;
import com.kingdee.eas.sem.mp.IKPIValue;
import com.kingdee.eas.sem.mp.IWarnGroup;
import com.kingdee.eas.sem.mp.KPICollection;
import com.kingdee.eas.sem.mp.KPIException;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewCollection;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewFactory;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewInfo;
import com.kingdee.eas.sem.mp.KPIRefValueFactory;
import com.kingdee.eas.sem.mp.KPIValueCollection;
import com.kingdee.eas.sem.mp.KPIValueFactory;
import com.kingdee.eas.sem.mp.KPIValueInfo;
import com.kingdee.eas.sem.mp.KPIValueRefStandardValueInfo;
import com.kingdee.eas.sem.mp.KPIWarnParamInfo;
import com.kingdee.eas.sem.mp.KPIWarnParamNewCollection;
import com.kingdee.eas.sem.mp.KPIWarnParamNewInfo;
import com.kingdee.eas.sem.mp.MPException;
import com.kingdee.eas.sem.mp.TimeDimensionEnum;
import com.kingdee.eas.sem.mp.WarnGroupCollection;
import com.kingdee.eas.sem.mp.WarnGroupFactory;
import com.kingdee.eas.sem.mp.WarnGroupInfo;
import com.kingdee.eas.sem.mp.app.AbstractKPIControllerBean;
import com.kingdee.eas.sem.mp.app.util.KPIAssignAppHandle;
import com.kingdee.eas.sem.mp.app.util.KPICopyHandle;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.ScriptUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class KPIControllerBean
extends AbstractKPIControllerBean {
    private static final long serialVersionUID = 5794797556993299615L;

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.deleteRefValue(ctx, pk);
        super._delete(ctx, pk);
    }

    private void deleteRefValue(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IKPIRefValue kpiRv = KPIRefValueFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("KPI", pk.getKeyValue("id")));
        kpiRv.delete(filter);
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)dataBaseInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        int mask = 0;
        StringBuffer maskString = new StringBuffer();
        maskString.append("#0");
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            maskString.append(" and #" + ++mask);
        }
        if (((KPIInfo)model).getPartFI() != null) {
            String orgId = ((KPIInfo)model).getPartFI().getId().toString();
            filterItem = new FilterItemInfo("partfi", (Object)orgId);
            filter.getFilterItems().add(filterItem);
            maskString.append(" and #" + ++mask);
        }
        filter.setMaskString(maskString.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, dataBaseInfo, "name") + dataBaseInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        int mask = 0;
        StringBuffer maskString = new StringBuffer();
        maskString.append("#0");
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            maskString.append(" and #" + ++mask);
        }
        if (((KPIInfo)model).getPartFI() != null) {
            String orgId = ((KPIInfo)model).getPartFI().getId().toString();
            filterItem = new FilterItemInfo("partfi", (Object)orgId);
            filter.getFilterItems().add(filterItem);
            maskString.append(" and #" + ++mask);
        }
        filter.setMaskString(maskString.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected void addNewCheck(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        this._checkNumberBlank(ctx, model);
        this._checkCompanyBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        this._checkNameBlank(ctx, model);
        this._checkNameDup(ctx, model);
        this._checkCsfBlank(ctx, model);
        KPIInfo kpiInfo = (KPIInfo)model;
        if (kpiInfo.getParent() == null) {
            kpiInfo.setLongNumber(kpiInfo.getNumber());
        }
    }

    private void _checkCompanyBlank(Context ctx, IObjectValue model) throws MPException {
        KPIInfo kpiInfo = (KPIInfo)model;
        if (kpiInfo.getPartFI() == null) {
            throw new MPException(MPException.COMPANYBLANKEXCEPTION);
        }
    }

    private void _checkCsfBlank(Context ctx, IObjectValue model) throws MPException {
        KPIInfo kpiInfo = (KPIInfo)model;
        if (kpiInfo.getCsf() == null) {
            throw new MPException(MPException.CSFBLANKEXCEPTION);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addNewCheck(ctx, model);
        KPIInfo kpiInfo = (KPIInfo)model;
        if (kpiInfo.getDeletedStatus() == null) {
            kpiInfo.setInt("deletedStatus", 1);
        }
        kpiInfo = (KPIInfo)model;
        KPIValueCollection valueCols = kpiInfo.getKpiValue();
        KPIValueInfo valueInfo = null;
        if (valueCols != null && valueCols.size() > 0) {
            UserInfo userInfo = this.getUserInfo(ctx);
            Iterator ite = valueCols.iterator();
            while (ite.hasNext()) {
                valueInfo = (KPIValueInfo)ite.next();
                if (valueInfo.getCreator() == null) {
                    valueInfo.setCreator(userInfo);
                }
                Timestamp createtime = this.getTime();
                if (valueInfo.getCreateTime() == null) {
                    valueInfo.setCreateTime(createtime);
                }
                valueInfo.setLastUpdateUser(userInfo);
                valueInfo.setLastUpdateTime(createtime);
                valueInfo.setLastComputeTime(createtime);
            }
            TimeDimensionEnum timeDimension = valueInfo == null || valueInfo.getTimeDeminsion() == null ? TimeDimensionEnum.NoTime : valueInfo.getTimeDeminsion();
            kpiInfo.setTimeDimension(timeDimension);
        }
        IObjectPK returnPK = super._addnew(ctx, (IObjectValue)kpiInfo);
        return returnPK;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateCheck(ctx, model);
        KPIInfo kpiInfo = (KPIInfo)model;
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("parent.*"));
        KPIInfo tempInfo = KPIFactory.getLocalInstance(ctx).getKPIInfo(pk, sc);
        if (tempInfo != null && tempInfo.getParent() != null) {
            kpiInfo.setLongNumber(tempInfo.getParent().getLongNumber() + "!" + kpiInfo.getNumber());
        } else {
            kpiInfo.setLongNumber(kpiInfo.getNumber());
        }
        KPIValueCollection valueCols = kpiInfo.getKpiValue();
        KPIValueInfo valueInfo = null;
        if (valueCols != null && valueCols.size() > 0) {
            UserInfo userInfo = this.getUserInfo(ctx);
            Iterator ite = valueCols.iterator();
            while (ite.hasNext()) {
                valueInfo = (KPIValueInfo)ite.next();
                if (valueInfo.getCreator() == null) {
                    valueInfo.setCreator(userInfo);
                }
                Timestamp createtime = this.getTime();
                if (valueInfo.getCreateTime() == null) {
                    valueInfo.setCreateTime(createtime);
                }
                valueInfo.setLastUpdateUser(userInfo);
                valueInfo.setLastUpdateTime(createtime);
                valueInfo.setLastComputeTime(createtime);
            }
            TimeDimensionEnum timeDimension = valueInfo == null || valueInfo.getTimeDeminsion() == null ? TimeDimensionEnum.NoTime : valueInfo.getTimeDeminsion();
            kpiInfo.setTimeDimension(timeDimension);
        }
        super._update(ctx, pk, (IObjectValue)kpiInfo);
    }

    private void updateCheck(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        this._checkNumberBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        this._checkNameBlank(ctx, model);
        this._checkNameDup(ctx, model);
        this._checkCompanyBlank(ctx, model);
    }

    protected BigDecimal _calcFormula(Context ctx, String formula, boolean isvoucherInclueed, OrgUnitInfo company) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo;
        BigDecimal value = new BigDecimal("0");
        if (formula == null || formula.length() == 0) {
            return value;
        }
        ReportInfo reportInfo = new ReportInfo();
        OrgUnitInfo ou = company;
        String companyid = ou.getId().toString();
        if (!ou.isIsCompanyOrgUnit() && (ou = NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx).getDelegateUnit(companyid, OrgType.Company)) != null) {
            companyid = ou.getId().toString();
        }
        PeriodInfo periodInfo = ctx.get((Object)"caclType") != null && ctx.get((Object)"caclType").equals("backSche") ? InitDataFacadaFactory.getLocalInstance((Context)ctx).getCurrentFiscal((IObjectPK)new ObjectUuidPK(companyid)) : InitDataFacadaFactory.getLocalInstance((Context)ctx).getCurrentFiscal();
        reportInfo.setYear(periodInfo.getPeriodYear());
        reportInfo.setPeriod(new Integer(periodInfo.getPeriodNumber()).shortValue());
        reportInfo.setStartDate(periodInfo.getBeginDate());
        reportInfo.setEndDate((Date)periodInfo.getEndDate());
        reportInfo.setPeriodType(RptPeriodTypeEnum.MONTHLY);
        if (ou == null) {
            companyInfo = RptUtilForServer.getCurrentCompany((Context)ctx);
        } else {
            companyInfo = new CompanyOrgUnitInfo();
            companyInfo.setId(ou.getId());
            companyInfo.setNumber(ou.getNumber());
        }
        SelectorItemCollection scc = new SelectorItemCollection();
        scc.add(new SelectorItemInfo("id"));
        scc.add(new SelectorItemInfo("number"));
        scc.add(new SelectorItemInfo("name"));
        scc.add(new SelectorItemInfo("reportCurrency.*"));
        scc.add(new SelectorItemInfo("baseCurrency.*"));
        companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()), scc);
        reportInfo.setCompany(companyInfo);
        CurrencyInfo currencyInfo = new CurrencyInfo();
        currencyInfo = companyInfo.isIsOnlyUnion() ? companyInfo.getReportCurrency() : companyInfo.getBaseCurrency();
        reportInfo.setCurrency(currencyInfo);
        RptSheetParamInfo rptSheetParamInfo = new RptSheetParamInfo();
        rptSheetParamInfo.setIsIncludingUnposted(isvoucherInclueed);
        rptSheetParamInfo.setCurrency(currencyInfo);
        RptSheetParamCollection sheetParams = new RptSheetParamCollection();
        sheetParams.add(rptSheetParamInfo);
        reportInfo.getSheetParam().addCollection(sheetParams);
        BigDecimal calcResult = null;
        formula = formula.trim();
        if (!formula.startsWith("=")) {
            formula = "=" + formula;
        }
        if (formula.endsWith(";")) {
            formula = formula.substring(0, formula.length() - 1);
        }
        if ((calcResult = ReportFactory.getLocalInstance((Context)ctx).calcFomula((IObjectValue)reportInfo, formula)) == null) {
            return new BigDecimal("0");
        }
        return calcResult;
    }

    protected BigDecimal _calcFormula(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo;
        BigDecimal value = new BigDecimal("0");
        if (pk == null) {
            return value;
        }
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("formula"));
        sc.add(new SelectorItemInfo("partFI.id"));
        sc.add(new SelectorItemInfo("partFI.number"));
        sc.add(new SelectorItemInfo("partFI.isCompanyOrgUnit"));
        sc.add(new SelectorItemInfo("isUnpassedVoucherIncluded"));
        KPIInfo kpiInfo = this.getKPIInfo(ctx, pk, sc);
        String formula = kpiInfo.getFormula();
        boolean isvoucherInclueed = kpiInfo.isIsUnpassedVoucherIncluded();
        if (formula == null || formula.length() == 0) {
            return value;
        }
        ReportInfo reportInfo = new ReportInfo();
        AdminOrgUnitInfo ou = kpiInfo.getCompany();
        String companyid = ou.getId().toString();
        if (!ou.isIsCompanyOrgUnit() && (ou = NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx).getDelegateUnit(companyid, OrgType.Company)) != null) {
            companyid = ou.getId().toString();
        }
        PeriodInfo periodInfo = ctx.get((Object)"caclType") != null && ctx.get((Object)"caclType").equals("backSche") ? InitDataFacadaFactory.getLocalInstance((Context)ctx).getCurrentFiscal((IObjectPK)new ObjectUuidPK(companyid)) : InitDataFacadaFactory.getLocalInstance((Context)ctx).getCurrentFiscal();
        reportInfo.setYear(periodInfo.getPeriodYear());
        reportInfo.setPeriod(new Integer(periodInfo.getPeriodNumber()).shortValue());
        reportInfo.setStartDate(periodInfo.getBeginDate());
        reportInfo.setEndDate((Date)periodInfo.getEndDate());
        reportInfo.setPeriodType(RptPeriodTypeEnum.MONTHLY);
        if (ou == null) {
            companyInfo = RptUtilForServer.getCurrentCompany((Context)ctx);
        } else {
            companyInfo = new CompanyOrgUnitInfo();
            companyInfo.setId(ou.getId());
            companyInfo.setNumber(ou.getNumber());
        }
        SelectorItemCollection scc = new SelectorItemCollection();
        scc.add(new SelectorItemInfo("id"));
        scc.add(new SelectorItemInfo("number"));
        scc.add(new SelectorItemInfo("name"));
        scc.add(new SelectorItemInfo("reportCurrency.*"));
        scc.add(new SelectorItemInfo("baseCurrency.*"));
        companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()), scc);
        reportInfo.setCompany(companyInfo);
        CurrencyInfo currencyInfo = new CurrencyInfo();
        currencyInfo = companyInfo.isIsOnlyUnion() ? companyInfo.getReportCurrency() : companyInfo.getBaseCurrency();
        reportInfo.setCurrency(currencyInfo);
        RptSheetParamInfo rptSheetParamInfo = new RptSheetParamInfo();
        rptSheetParamInfo.setIsIncludingUnposted(isvoucherInclueed);
        rptSheetParamInfo.setCurrency(currencyInfo);
        RptSheetParamCollection sheetParams = new RptSheetParamCollection();
        sheetParams.add(rptSheetParamInfo);
        reportInfo.getSheetParam().addCollection(sheetParams);
        BigDecimal calcResult = null;
        formula = formula.trim();
        if (!formula.startsWith("=")) {
            formula = "=" + formula;
        }
        if (formula.endsWith(";")) {
            formula = formula.substring(0, formula.length() - 1);
        }
        if ((calcResult = ReportFactory.getLocalInstance((Context)ctx).calcFomula((IObjectValue)reportInfo, formula)) == null) {
            return new BigDecimal("0");
        }
        return calcResult;
    }

    protected void updateKPIValue(Context ctx, IObjectPK pk, Object value) throws BOSException {
        StringBuffer _sql = new StringBuffer("update T_MP_KPI set");
        _sql.append(" FCurrentValue = ? where FId = ?");
        Object[] params = new Object[]{value, pk.toString()};
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
    }

    protected IObjectCollection _drillChildKpi(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean hasChildren = true;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("partFI.*"));
        KPIInfo kpiInfo = this.getKPIInfo(ctx, pk, selector);
        ArrayList orgIds = this.getChildrenUnit(ctx, (IObjectPK)new ObjectUuidPK(kpiInfo.getPartFI().getId()));
        FilterInfo filter = new FilterInfo();
        if (kpiInfo.getParent() == null) {
            filter.getFilterItems().add(new FilterItemInfo("parent", (Object)kpiInfo.getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("parent", (Object)kpiInfo.getParent().getId().toString()));
        }
        StringBuffer mask = new StringBuffer();
        mask.append("#0");
        if (orgIds != null) {
            int count = orgIds.size();
            if (count == 0) {
                hasChildren = false;
            }
            for (int i = 0; i < count; ++i) {
                filter.getFilterItems().add(new FilterItemInfo("partFI", (Object)((String)orgIds.get(i))));
                if (i == 0) {
                    mask.append(" and ( #" + (i + 1));
                } else {
                    mask.append(" or #" + (i + 1));
                }
                if (i != count - 1) continue;
                mask.append(")");
            }
            filter.setMaskString(mask.toString());
        }
        if (hasChildren) {
            SelectorItemCollection selector1 = new SelectorItemCollection();
            selector1.add(new SelectorItemInfo("*"));
            selector1.add(new SelectorItemInfo("partFI.id"));
            selector1.add(new SelectorItemInfo("partFI.name"));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            evi.setSelector(selector1);
            KPICollection kpiCols = this.getKPICollection(ctx, evi);
            if (kpiCols != null) {
                Iterator ite = kpiCols.iterator();
                while (ite.hasNext()) {
                    KPIInfo tempInfo = (KPIInfo)ite.next();
                    tempInfo.getKpiValue().clear();
                    tempInfo.getKpiValue().addCollection(this.getKpiValuesByOrder(ctx, tempInfo.getId().toString()));
                }
            }
            return kpiCols;
        }
        return null;
    }

    private KPIValueCollection getKpiValuesByOrder(Context ctx, String kpiId) throws BOSException {
        IKPIValue kpiValue = KPIValueFactory.getLocalInstance(ctx);
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection selector = ev.getSelector();
        selector.add("*");
        selector.add("warnparam.*");
        selector.add("warnparam.warnGroup.*");
        selector.add("currentWarnStatus.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("kpi.id", (Object)kpiId));
        ev.setFilter(filter);
        SorterItemInfo sorterInfo = new SorterItemInfo("bizDate");
        sorterInfo.setSortType(SortType.DESCEND);
        ev.getSorter().add(sorterInfo);
        KPIValueCollection cols = kpiValue.getKPIValueCollection(ev);
        return cols;
    }

    private ArrayList getChildrenUnit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        ArrayList<String> unitIds = new ArrayList<String>();
        IAdminOrgUnit orgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitInfo org = orgUnit.getAdminOrgUnitInfo(pk);
        String longNumber = org.getLongNumber();
        StringTokenizer st = new StringTokenizer(longNumber, "!");
        int level = 0;
        while (st.hasMoreTokens()) {
            ++level;
            st.nextToken();
        }
        IOrgStructure orgStructure = OrgStructureFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + OrgUtils.SEPERATOR + "%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(level + 1), CompareType.EQUALS));
        evi.setFilter(filter);
        evi.getSelector().add("unit.id");
        OrgStructureCollection orgStructures = orgStructure.getOrgStructureCollection(evi);
        int count = orgStructures.size();
        for (int i = 0; i < count; ++i) {
            unitIds.add(orgStructures.get(i).getUnit().getId().toString());
        }
        return unitIds;
    }

    protected List _importDataFromParent(Context ctx, IObjectPK[] selectedPKs, HashMap orgMap) throws BOSException, EASBizException {
        return null;
    }

    protected List _importDataFromParent(Context ctx, String[] selectKpiId, HashMap orgMap) throws BOSException, EASBizException {
        KPICopyHandle.importDataFromParent(ctx, selectKpiId, orgMap);
        return null;
    }

    protected void _updateFormulaValue(Context ctx) throws BOSException, EASBizException {
        KPICollection c = this.getKPICollection(ctx);
        Iterator it = c.iterator();
        while (it.hasNext()) {
            KPIInfo kpiInfo = (KPIInfo)it.next();
            this._update(ctx, (IObjectPK)new ObjectUuidPK(kpiInfo.getId()), (IObjectValue)kpiInfo);
        }
    }

    protected void _updateWithoutExecuteWarn(Context ctx, IObjectPK pk, Object model) throws BOSException, EASBizException {
        this.updateCheck(ctx, (IObjectValue)model);
        super._update(ctx, pk, (IObjectValue)model);
    }

    protected IObjectPK _addKPIValue(Context ctx, IObjectValue model, Map kpiStandardMap) throws BOSException, EASBizException {
        IObjectPK kpiPk = this._submit(ctx, model);
        return kpiPk;
    }

    private void submitKPIValueRefStandardValue(Context ctx, KPIInfo kpiInfo, KPIRefStandardValueNewCollection kPIRefStandardValueNewCollection) throws BOSException, EASBizException {
        this.deleteKPIValueRefStandardValue(ctx, kpiInfo);
        IKPIRefStandardValueNew iStandardValue = KPIRefStandardValueNewFactory.getLocalInstance(ctx);
        Iterator ite = kPIRefStandardValueNewCollection.iterator();
        while (ite.hasNext()) {
            iStandardValue.addnew((KPIRefStandardValueNewInfo)ite.next());
        }
    }

    private void deleteKPIValueRefStandardValue(Context ctx, KPIInfo kpiInfo) throws BOSException {
        String sql = "delete T_MP_KPIRefStandardValueNew where FKPIID=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{kpiInfo.getId().toString()});
    }

    private List getKpiValueCurrentWarn(Context ctx, KPIInfo kpiInfo, KPIValueInfo valueInfo, Map standardValueMap) throws BOSException, EASBizException {
        Object obj;
        if (standardValueMap != null && standardValueMap.size() > 0 && (obj = standardValueMap.get(valueInfo.getId().toString())) != null && obj instanceof List) {
            return (List)obj;
        }
        return null;
    }

    private void setKpiValueCurrentWarnNull(KPIInfo kpiInfo) throws BOSException {
        if (kpiInfo == null) {
            return;
        }
        KPIValueCollection valueCols = kpiInfo.getKpiValue();
        if (valueCols != null) {
            for (int i = 0; i < valueCols.size(); ++i) {
                valueCols.get(i).setCurrentWarnStatus(null);
            }
        }
    }

    private void setKpiValueCurrentWarn(Context ctx, KPIInfo kpiInfo, KPIValueInfo valueInfo, List cols) throws BOSException, EASBizException {
        KPIWarnParamNewCollection params = kpiInfo.getWarnParam();
        if (params != null) {
            BigDecimal kpiValue = valueInfo.getKpiValue();
            HashMap<String, BigDecimal> paramsMap = new HashMap<String, BigDecimal>();
            int paramCount = params.size();
            for (int i = 0; i < paramCount; ++i) {
                KPIWarnParamNewInfo paramInfo = params.get(i);
                paramsMap.put(paramInfo.getEdgeParam().getId().toString() + paramInfo.getWarnGroup().getId().toString(), paramInfo.getCurrentValue());
            }
            String egFormula = " " + kpiInfo.getCurrentWarnStatus().getFormula();
            IWarnGroup warnGroup = WarnGroupFactory.getLocalInstance(ctx);
            EntityViewInfo wgevi = new EntityViewInfo();
            SorterItemInfo sort = new SorterItemInfo("periority");
            sort.setSortType(SortType.ASCEND);
            wgevi.getSorter().add(sort);
            WarnGroupCollection wgs = warnGroup.getWarnGroupCollection(wgevi);
            if (wgs != null) {
                int i;
                int wgCount = wgs.size();
                for (i = 0; i < wgCount - 1; ++i) {
                    WarnGroupInfo wgInfo = wgs.get(i);
                    StringTokenizer st = new StringTokenizer(egFormula, "$");
                    StringBuffer scriptFormula = new StringBuffer();
                    boolean flag = true;
                    while (st.hasMoreTokens()) {
                        if (flag) {
                            scriptFormula.append(st.nextToken());
                        } else {
                            String token = st.nextToken();
                            if (token.equalsIgnoreCase("CURRENTVALUE")) {
                                scriptFormula.append(kpiValue);
                            } else {
                                token = token + wgInfo.getId().toString();
                                BigDecimal paramValue = (BigDecimal)paramsMap.get(token);
                                scriptFormula.append(paramValue);
                            }
                        }
                        flag = !flag;
                    }
                    boolean result = (Boolean)ScriptUtil.evalExpr((String)scriptFormula.toString(), null);
                    if (result) break;
                }
                if (i < wgCount) {
                    valueInfo.setCurrentWarnStatus(wgs.get(i));
                }
            }
        }
    }

    protected void calcCurrentValue(Context ctx, KPIWarnParamInfo kpiWarnParamInfo, List kpiRefValueInfos) throws BOSException, EASBizException {
        String paramValue = " " + kpiWarnParamInfo.getParamValue();
        StringTokenizer st = new StringTokenizer(paramValue, "$");
        StringBuffer formula = new StringBuffer();
        boolean flag = true;
        while (st.hasMoreTokens()) {
            if (flag) {
                formula.append(st.nextToken());
            } else {
                KPIValueRefStandardValueInfo kpiRefValueInfo = (KPIValueRefStandardValueInfo)kpiRefValueInfos.get(0);
                if (kpiRefValueInfo == null) {
                    throw new MPException(MPException.WARNSCHEMAPARAMERROR);
                }
                BigDecimal value = kpiRefValueInfo.getRefValue();
                formula.append(value);
            }
            flag = !flag;
        }
        Object obj = ScriptUtil.evalExpr((String)formula.toString(), null);
        BigDecimal currentValue = obj == null ? new BigDecimal("0") : new BigDecimal(obj.toString());
        kpiWarnParamInfo.setCurrentValue(currentValue);
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private UserInfo getUserInfo(Context ctx) throws BOSException {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    protected List _assignKPI(Context ctx, OrgUnitInfo parentOrg, List kpis, List companys, Map assignParams) throws BOSException, EASBizException {
        if (companys == null || companys.size() <= 0) {
            throw new KPIException(KPIException.COMPANY_IS_NULL);
        }
        if (kpis == null || kpis.size() <= 0) {
            throw new KPIException(KPIException.KPIS_NULL);
        }
        CompanyOrgUnitInfo parentInfo = this.getParentCompanyOrg(ctx, parentOrg);
        if (parentInfo != null) {
            return KPIAssignAppHandle.assignDataToChild(ctx, kpis, parentInfo, companys, assignParams, true);
        }
        return null;
    }

    private CompanyOrgUnitInfo getParentCompanyOrg(Context ctx, OrgUnitInfo parentOrg) {
        CompanyOrgUnitInfo parentInfo = null;
        try {
            parentInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(parentOrg.getId().toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return parentInfo;
    }

    protected IObjectValue _getValue(Context ctx, String oql) throws BOSException, EASBizException {
        return super._getValue(ctx, oql);
    }
}

