/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.IContextHandler;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.eas.sem.mp.DateContextHandler;
import com.kingdee.eas.sem.mp.EdgeParamCollection;
import com.kingdee.eas.sem.mp.EdgeParamFactory;
import com.kingdee.eas.sem.mp.EdgeParamInfo;
import com.kingdee.eas.sem.mp.IEdgeParam;
import com.kingdee.eas.sem.mp.IKPI;
import com.kingdee.eas.sem.mp.IKPIRefStandardValueNew;
import com.kingdee.eas.sem.mp.IKPIValue;
import com.kingdee.eas.sem.mp.IKPIValueRefStandardValue;
import com.kingdee.eas.sem.mp.IKPIWarnParam;
import com.kingdee.eas.sem.mp.IKPIWarnParamNew;
import com.kingdee.eas.sem.mp.KPICollection;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewCollection;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewFactory;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewInfo;
import com.kingdee.eas.sem.mp.KPITimeTypeEnum;
import com.kingdee.eas.sem.mp.KPIValueCollection;
import com.kingdee.eas.sem.mp.KPIValueFactory;
import com.kingdee.eas.sem.mp.KPIValueInfo;
import com.kingdee.eas.sem.mp.KPIValueRefStandardValueCollection;
import com.kingdee.eas.sem.mp.KPIValueRefStandardValueFactory;
import com.kingdee.eas.sem.mp.KPIValueRefStandardValueInfo;
import com.kingdee.eas.sem.mp.KPIWarnParamCollection;
import com.kingdee.eas.sem.mp.KPIWarnParamFactory;
import com.kingdee.eas.sem.mp.KPIWarnParamNewCollection;
import com.kingdee.eas.sem.mp.KPIWarnParamNewFactory;
import com.kingdee.eas.sem.mp.TempStandardValueInfo;
import com.kingdee.eas.sem.mp.TimeDimensionInfo;
import com.kingdee.eas.sem.mp.app.AbstractKPIFacadeControllerBean;
import com.kingdee.eas.sem.mp.app.KPIAutoCreateKpiNewHandler;
import com.kingdee.eas.sem.mp.util.KPIValueStructure;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class KPIFacadeControllerBean
extends AbstractKPIFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.sem.mp.app.KPIFacadeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KPIValueStructure _getKPIAndValueByOrgid(Context ctx, String orgid) throws BOSException {
        KPIValueStructure kpiValueStruct = null;
        Connection conn = null;
        PreparedStatement preStmt = null;
        ResultSet reSet = null;
        Locale userLocale = ctx.getLocale();
        String localeType = "";
        localeType = userLocale == null ? "L2" : userLocale.getLanguage();
        String currentValueName = "\u5b9e\u9645\u503c";
        String warnColor = "\u9884\u8b66\u989c\u8272";
        String measureUnitName = "KPI\u5355\u4f4d";
        StringBuffer sqlBuff = null;
        HashMap<String, String> kpiMap = null;
        HashMap<String, String> currValueMap = null;
        HashMap kpiWarnColorMap = null;
        HashMap<String, String> refGroupMap = null;
        HashMap<String, String> kpiUnitMap = null;
        try {
            conn = this.getConnection(ctx);
            sqlBuff = new StringBuffer();
            sqlBuff.append("select FID,FCurrentValue,FNumberUnit_").append(localeType).append(" as unit,FName_").append(localeType).append(" as name from T_MP_KPI").append("\r\n");
            sqlBuff.append("where FCompanyID = ?");
            preStmt = conn.prepareStatement(sqlBuff.toString());
            preStmt.setString(1, orgid);
            reSet = preStmt.executeQuery();
            if (null != reSet) {
                kpiMap = new HashMap<String, String>();
                currValueMap = new HashMap<String, String>();
                kpiUnitMap = new HashMap<String, String>();
                while (reSet.next()) {
                    kpiMap.put(reSet.getString("FID"), reSet.getString("name"));
                    kpiUnitMap.put(reSet.getString("FID"), reSet.getString("unit"));
                    currValueMap.put(reSet.getString("FID"), reSet.getString("FCurrentValue"));
                }
            }
            sqlBuff = new StringBuffer();
            sqlBuff.append("select FID,FName_").append(localeType).append(" as name from T_MP_RefGroup").append("\r\n");
            sqlBuff.append("where FCompanyID = ?");
            preStmt = conn.prepareStatement(sqlBuff.toString());
            preStmt.setString(1, orgid);
            reSet = preStmt.executeQuery();
            if (null != reSet) {
                refGroupMap = new HashMap<String, String>();
                while (reSet.next()) {
                    refGroupMap.put(reSet.getString("FID"), reSet.getString("name"));
                }
            }
            if (null != kpiMap && 0 < kpiMap.size() && null != refGroupMap && 0 < refGroupMap.size() && null != currValueMap && currValueMap.size() > 0 && null != kpiUnitMap && kpiUnitMap.size() > 0) {
                String[] kpiKeySet = new String[kpiMap.size()];
                kpiMap.keySet().toArray(kpiKeySet);
                kpiValueStruct = new KPIValueStructure(kpiMap.size(), refGroupMap.size() + 3);
                kpiValueStruct.setKpiIds(kpiKeySet);
                for (int i = 1; i <= kpiValueStruct.getTLength(); ++i) {
                    kpiValueStruct.setRowTitle(i, (String)kpiMap.get(kpiKeySet[i - 1]));
                }
                String[] refGroupKeySet = new String[refGroupMap.size()];
                refGroupMap.keySet().toArray(refGroupKeySet);
                kpiValueStruct.setColumnTitle(1, currentValueName);
                kpiValueStruct.setColumnTitle(2, warnColor);
                kpiValueStruct.setColumnTitle(3, measureUnitName);
                for (int j = 4; j <= kpiValueStruct.getTWidth(); ++j) {
                    kpiValueStruct.setColumnTitle(j, (String)refGroupMap.get(refGroupKeySet[j - 4]));
                }
                for (int l = 1; l <= kpiKeySet.length; ++l) {
                    kpiValueStruct.setValueByRowAndColun((String)currValueMap.get(kpiKeySet[l - 1]), l, 1);
                }
                kpiWarnColorMap = new HashMap();
                sqlBuff = new StringBuffer();
                sqlBuff.append("select t1.FColor from T_MP_KPI t,T_MP_WarnGroup t1").append("\r\n");
                sqlBuff.append("where t.FID = ? and t.FCurrentWarnStatus = t1.FID");
                for (int k = 1; k <= kpiKeySet.length; ++k) {
                    preStmt = conn.prepareStatement(sqlBuff.toString());
                    preStmt.setString(1, kpiKeySet[k - 1]);
                    reSet = preStmt.executeQuery();
                    if (null != reSet && reSet.next()) {
                        kpiValueStruct.setValueByRowAndColun(reSet.getString("FColor"), k, 2);
                        continue;
                    }
                    kpiValueStruct.setValueByRowAndColun(null, k, 2);
                }
                for (int i = 1; i <= kpiKeySet.length; ++i) {
                    kpiValueStruct.setValueByRowAndColun((String)kpiUnitMap.get(kpiKeySet[i - 1]), i, 3);
                }
                sqlBuff = new StringBuffer();
                sqlBuff.append("select FRefValue from T_MP_KPI t,T_BD_MeasureUnit t1").append("\r\n");
                sqlBuff.append("where FKPIID = ? and FRefGroupID = ?");
                for (int m = 1; m <= kpiValueStruct.getTLength(); ++m) {
                    for (int n = 4; n <= kpiValueStruct.getTWidth(); ++n) {
                        preStmt = conn.prepareStatement(sqlBuff.toString());
                        preStmt.setString(1, kpiKeySet[m - 1]);
                        preStmt.setString(2, refGroupKeySet[n - 4]);
                        reSet = preStmt.executeQuery();
                        if (null == reSet || !reSet.next()) continue;
                        kpiValueStruct.setValueByRowAndColun(new Integer(reSet.getInt("FRefValue")).toString(), m, n);
                    }
                }
            }
            SQLUtils.cleanup((Statement)preStmt, (Connection)conn);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup(preStmt, (Connection)conn);
        }
        return kpiValueStruct;
    }

    protected List _initWarnGropAndStandardValue(Context ctx, BOSUuid kpiId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("kpiValue.*"));
        sic.add(new SelectorItemInfo("kpiValue.warnparam.*"));
        sic.add(new SelectorItemInfo("kpiValue.warnparam.warnGroup.*"));
        sic.add(new SelectorItemInfo("kpiValue.warnparam.edgeParam.*"));
        IKPI iKpi = KPIFactory.getLocalInstance(ctx);
        KPIInfo kpiInfo = iKpi.getKPIInfo((IObjectPK)new ObjectUuidPK(kpiId), sic);
        HashMap<String, Map> kpiStandardMap = new HashMap<String, Map>();
        HashMap<String, KPIWarnParamCollection> kpiWarnParamMap = new HashMap<String, KPIWarnParamCollection>(4);
        if (kpiInfo != null) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SorterItemCollection sorters = ev.getSorter();
            SorterItemInfo sorter = new SorterItemInfo("edgeParam.number");
            sorter.setSortType(SortType.ASCEND);
            sorters.add(sorter);
            sorter = new SorterItemInfo("warnGroup.periority");
            sorter.setSortType(SortType.DESCEND);
            sorters.add(sorter);
            SelectorItemCollection sic1 = ev.getSelector();
            sic1.add(new SelectorItemInfo("*"));
            sic1.add(new SelectorItemInfo("warnGroup.*"));
            sic1.add(new SelectorItemInfo("edgeParam.*"));
            KPIValueInfo kpiValueInfo = null;
            IKPIValueRefStandardValue iKpiVRS = KPIValueRefStandardValueFactory.getLocalInstance(ctx);
            IKPIWarnParam iKpiWarnParam = KPIWarnParamFactory.getLocalInstance(ctx);
            KPIValueRefStandardValueCollection kpiVRSCols = null;
            KPIWarnParamCollection kpiWarnParamCols = null;
            KPIValueCollection kpiValueCols = kpiInfo.getKpiValue();
            Iterator ite = kpiValueCols.iterator();
            while (ite.hasNext()) {
                kpiValueInfo = (KPIValueInfo)ite.next();
                kpiVRSCols = iKpiVRS.getKPIValueRefStandardValueCollection("where kPIValue='" + kpiValueInfo.getId().toString() + "'");
                if (kpiVRSCols != null && kpiVRSCols.size() > 0) {
                    kpiStandardMap.put(kpiValueInfo.getId().toString(), this.reTypeData(kpiVRSCols));
                }
                filter.getFilterItems().clear();
                filter.getFilterItems().add(new FilterItemInfo("kpiValue", (Object)kpiValueInfo.getId().toString()));
                ev.setFilter(filter);
                kpiWarnParamCols = iKpiWarnParam.getKPIWarnParamCollection(ev);
                if (kpiWarnParamCols == null || kpiWarnParamCols.size() <= 0) continue;
                kpiWarnParamMap.put(kpiValueInfo.getId().toString(), kpiWarnParamCols);
            }
        }
        ArrayList<HashMap<String, Object>> backList = new ArrayList<HashMap<String, Object>>();
        backList.add(kpiStandardMap);
        backList.add(kpiWarnParamMap);
        return backList;
    }

    private Map reTypeData(KPIValueRefStandardValueCollection kpiVRSCols) {
        Iterator ite = kpiVRSCols.iterator();
        KPIValueRefStandardValueInfo refInfo = null;
        TempStandardValueInfo tempInfo = null;
        HashMap<String, TempStandardValueInfo> tempMap = new HashMap<String, TempStandardValueInfo>();
        while (ite.hasNext()) {
            refInfo = (KPIValueRefStandardValueInfo)ite.next();
            tempInfo = new TempStandardValueInfo();
            tempInfo.setStandardTypeId(refInfo.getRefGroup().getId().toString());
            tempInfo.setStandardValue(refInfo.getRefValue());
            tempMap.put(refInfo.getRefGroup().getId().toString(), tempInfo);
        }
        return tempMap;
    }

    private Map reTypeDataNew(KPIRefStandardValueNewCollection kpiVRSCols) {
        Iterator ite = kpiVRSCols.iterator();
        KPIRefStandardValueNewInfo refInfo = null;
        HashMap<String, KPIRefStandardValueNewInfo> tempMap = new HashMap<String, KPIRefStandardValueNewInfo>();
        while (ite.hasNext()) {
            refInfo = (KPIRefStandardValueNewInfo)ite.next();
            tempMap.put(refInfo.getRefGroup().getId().toString(), refInfo);
        }
        return tempMap;
    }

    private void init() {
    }

    protected BigDecimal _calcFormula(Context ctx, String formula, boolean isvoucherInclueed, OrgUnitInfo company) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo;
        BigDecimal value = new BigDecimal("0");
        if (formula == null || formula.length() == 0) {
            return value;
        }
        ReportInfo reportInfo = new ReportInfo();
        OrgUnitInfo ou = company;
        String companyid = ou.getId().toString();
        if (!ou.isIsCompanyOrgUnit() && (ou = NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx).getDelegateUnit(companyid, OrgType.Company)) != null) {
            companyid = ou.getId().toString();
        }
        PeriodInfo periodInfo = ctx.get((Object)"caclType") != null && ctx.get((Object)"caclType").equals("backSche") ? InitDataFacadaFactory.getLocalInstance((Context)ctx).getCurrentFiscal((IObjectPK)new ObjectUuidPK(companyid)) : InitDataFacadaFactory.getLocalInstance((Context)ctx).getCurrentFiscal();
        reportInfo.setYear(periodInfo.getPeriodYear());
        reportInfo.setPeriod(new Integer(periodInfo.getPeriodNumber()).shortValue());
        reportInfo.setStartDate(periodInfo.getBeginDate());
        reportInfo.setEndDate((Date)periodInfo.getEndDate());
        reportInfo.setPeriodType(RptPeriodTypeEnum.MONTHLY);
        if (ou == null) {
            companyInfo = RptUtilForServer.getCurrentCompany((Context)ctx);
        } else {
            companyInfo = new CompanyOrgUnitInfo();
            companyInfo.setId(ou.getId());
            companyInfo.setNumber(ou.getNumber());
        }
        SelectorItemCollection scc = new SelectorItemCollection();
        scc.add(new SelectorItemInfo("id"));
        scc.add(new SelectorItemInfo("number"));
        scc.add(new SelectorItemInfo("name"));
        scc.add(new SelectorItemInfo("reportCurrency.*"));
        scc.add(new SelectorItemInfo("baseCurrency.*"));
        companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()), scc);
        reportInfo.setCompany(companyInfo);
        CurrencyInfo currencyInfo = new CurrencyInfo();
        currencyInfo = companyInfo.isIsOnlyUnion() ? companyInfo.getReportCurrency() : companyInfo.getBaseCurrency();
        reportInfo.setCurrency(currencyInfo);
        RptSheetParamInfo rptSheetParamInfo = new RptSheetParamInfo();
        rptSheetParamInfo.setIsIncludingUnposted(isvoucherInclueed);
        rptSheetParamInfo.setCurrency(currencyInfo);
        RptSheetParamCollection sheetParams = new RptSheetParamCollection();
        sheetParams.add(rptSheetParamInfo);
        reportInfo.getSheetParam().addCollection(sheetParams);
        Object calcResult = null;
        formula = formula.trim();
        if (!formula.startsWith("=")) {
            formula = "=" + formula;
        }
        if (formula.endsWith(";")) {
            formula = formula.substring(0, formula.length() - 1);
        }
        HashMap<String, Number> context = new HashMap<String, Number>();
        context.put("IContextHandler_period", new Short(2));
        context.put("IContextHandler_period_type", (Number)RptPeriodTypeEnum.MONTHLY);
        context.put("IContextHandler_year", new Integer(2008));
        ArrayList<String> list = new ArrayList<String>();
        list.add(formula);
        Variant[] tempResult = ReportFactory.getLocalInstance((Context)ctx).calcFormulas(context, list);
        return null;
    }

    protected List _calcFormulas(Context ctx, String[] formulas, boolean isvoucherInclueed, OrgUnitInfo company) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo;
        if (formulas == null || formulas.length <= 0) {
            return null;
        }
        ReportInfo reportInfo = new ReportInfo();
        OrgUnitInfo ou = company;
        String companyid = ou.getId().toString();
        if (!ou.isIsCompanyOrgUnit() && (ou = NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx).getDelegateUnit(companyid, OrgType.Company)) != null) {
            companyid = ou.getId().toString();
        }
        PeriodInfo periodInfo = ctx.get((Object)"caclType") != null && ctx.get((Object)"caclType").equals("backSche") ? InitDataFacadaFactory.getLocalInstance((Context)ctx).getCurrentFiscal((IObjectPK)new ObjectUuidPK(companyid)) : InitDataFacadaFactory.getLocalInstance((Context)ctx).getCurrentFiscal();
        reportInfo.setYear(periodInfo.getPeriodYear());
        reportInfo.setPeriod(new Integer(periodInfo.getPeriodNumber()).shortValue());
        reportInfo.setStartDate(periodInfo.getBeginDate());
        reportInfo.setEndDate((Date)periodInfo.getEndDate());
        reportInfo.setPeriodType(RptPeriodTypeEnum.MONTHLY);
        if (ou == null) {
            companyInfo = RptUtilForServer.getCurrentCompany((Context)ctx);
        } else {
            companyInfo = new CompanyOrgUnitInfo();
            companyInfo.setId(ou.getId());
            companyInfo.setNumber(ou.getNumber());
        }
        SelectorItemCollection scc = new SelectorItemCollection();
        scc.add(new SelectorItemInfo("id"));
        scc.add(new SelectorItemInfo("number"));
        scc.add(new SelectorItemInfo("name"));
        scc.add(new SelectorItemInfo("reportCurrency.*"));
        scc.add(new SelectorItemInfo("baseCurrency.*"));
        companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()), scc);
        reportInfo.setCompany(companyInfo);
        CurrencyInfo currencyInfo = new CurrencyInfo();
        currencyInfo = companyInfo.isIsOnlyUnion() ? companyInfo.getReportCurrency() : companyInfo.getBaseCurrency();
        reportInfo.setCurrency(currencyInfo);
        RptSheetParamInfo rptSheetParamInfo = new RptSheetParamInfo();
        rptSheetParamInfo.setIsIncludingUnposted(isvoucherInclueed);
        rptSheetParamInfo.setCurrency(currencyInfo);
        RptSheetParamCollection sheetParams = new RptSheetParamCollection();
        sheetParams.add(rptSheetParamInfo);
        reportInfo.getSheetParam().addCollection(sheetParams);
        BigDecimal calcResult = null;
        String formula = null;
        ArrayList<BigDecimal> formulaValues = new ArrayList<BigDecimal>(formulas.length);
        IReport iReport = ReportFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < formulas.length; ++i) {
            formula = formulas[i].trim();
            if (!formula.startsWith("=")) {
                formula = "=" + formula;
            }
            if (formula.endsWith(";")) {
                formula = formula.substring(0, formula.length() - 1);
            }
            if ((calcResult = iReport.calcFomula((IObjectValue)reportInfo, formula)) == null) {
                formulaValues.add(new BigDecimal("0"));
                logger.info((Object)("calculate formula error(result is null),formula is:" + formula));
                continue;
            }
            formulaValues.add(calcResult);
        }
        return formulaValues;
    }

    protected IRowSet _getReport(Context ctx, String[] companys, String[] kpiIDs, String[] kpiValueIDs) throws BOSException {
        String tempTable = this.createTempTable(ctx);
        IRowSet rowSet = null;
        try {
            System.out.println(System.currentTimeMillis());
            this.insertDataSql(ctx, companys, kpiIDs, kpiValueIDs[0], tempTable);
            System.out.println(System.currentTimeMillis());
            StringBuffer selectSql = new StringBuffer();
            selectSql.append("select * from " + tempTable + " order by companylongnumber asc,kpilongnumber asc ");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return rowSet;
    }

    private String createTempTable(Context ctx) {
        String tempTableName = "";
        StringBuffer createSql = new StringBuffer();
        createSql.append(" create table aa");
        createSql.append(" (FId varchar(44) not null primary key,");
        createSql.append("\tcolor nvarchar(20),");
        createSql.append("\tKPILONGNUMBER varchar(200),");
        createSql.append("\tNAME varchar(200),");
        createSql.append(" \tSIMPLENAME nvarchar(200),");
        createSql.append("  KPIVALUE NUMERIC(28,10),");
        createSql.append("  COMPANYNAME nvarchar(100),");
        createSql.append("  COMPANYLONGNUMBER nvarchar(400),");
        createSql.append("  COMPANYSIMPLENAME nvarchar(100),");
        createSql.append("  KPIID varchar(44),");
        createSql.append("  COMPANYID varchar(100),");
        createSql.append(" \tlevel int,");
        createSql.append(" \tcompanyNumber nvarchar(100),");
        createSql.append(" \tisLeaf int,");
        createSql.append("  KPIVALUEID varchar(44) ) ");
        TempTablePool tempPool = TempTablePool.getInstance((Context)ctx);
        try {
            tempTableName = tempPool.createTempTable(createSql.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tempTableName;
    }

    private void insertDataSql(Context ctx, String[] companys, String[] kpiIDs, String timeDimension, String tempTableName) throws BOSException, SQLException {
        KPIInfo kpiInfo = new KPIInfo();
        BOSObjectType bosType = kpiInfo.getBOSType();
        String[] kpiLongNumber = this.getKPILongNumber(ctx, kpiIDs);
        StringBuffer sql = new StringBuffer();
        sql.append("select kpiValue.flongnumber as flongnumber, ");
        sql.append(" warngroup.fcolor as color,");
        sql.append(" kpi.fname_l2 as name, ");
        sql.append(" kpi.flongnumber as kpilongnumber,");
        sql.append(" kpi.fsimplename as simplename ,");
        sql.append(" kpiValue.fkpivalue as kpivalue, ");
        sql.append(" company.fname_l2 as companyname, ");
        sql.append(" company.flongnumber as companylongnumber, ");
        sql.append(" company.fsimplename as companysimplename, ");
        sql.append(" kpi.fid as kpiid, ");
        sql.append(" company.fid as companyid, ");
        sql.append(" company.flevel as level, ");
        sql.append(" company.fnumber as companyNumber, ");
        sql.append(" company.fisleaf as isleaf, ");
        sql.append(" kpiValue.fid as kpivalueid ");
        sql.append(" from T_ORG_Admin company ");
        sql.append(" inner join t_mp_kpi kpi ");
        sql.append(" on company.fid=kpi.fcompanyid ");
        sql.append(" inner join t_mp_kpivalue kpiValue ");
        sql.append(" on kpi.fid = kpiValue.fkpiid ");
        sql.append(" inner join t_mp_warngroup warngroup ");
        sql.append(" on kpiValue.fcurrentwarnstatus = warngroup.fid ");
        sql.append(" where kpiValue.ftimetext='" + timeDimension + "' ");
        StringBuffer tempCheckSql = new StringBuffer();
        StringBuffer checkSql = this.getCheckeSql();
        for (int j = 0; j < companys.length; ++j) {
            String companyId = companys[j];
            for (int i = 0; i < kpiLongNumber.length; ++i) {
                StringBuffer insertSql;
                StringBuffer tempSql = new StringBuffer();
                tempSql.append(sql);
                tempSql.append(" and company.fid='" + companyId + "'");
                tempSql.append(" and kpi.flongnumber like '" + kpiLongNumber[i] + "%'");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)tempSql.toString());
                if (rowSet != null && rowSet.next()) {
                    insertSql = new StringBuffer();
                    insertSql.append(" insert into " + tempTableName + " values(");
                    insertSql.append("'");
                    insertSql.append(BOSUuid.create((BOSObjectType)bosType).toString());
                    insertSql.append("','");
                    insertSql.append(rowSet.getString("color"));
                    insertSql.append("','");
                    insertSql.append(rowSet.getString("kpilongnumber"));
                    insertSql.append("','");
                    insertSql.append(rowSet.getString("name"));
                    insertSql.append("','");
                    insertSql.append(rowSet.getString("simplename"));
                    insertSql.append("',");
                    BigDecimal tempBigDecimal = rowSet.getBigDecimal("kpivalue");
                    if (tempBigDecimal == null) {
                        insertSql.append("NULL");
                    } else {
                        String tempStr = tempBigDecimal.toString();
                        if ("0E-10".equals(tempStr)) {
                            insertSql.append(0.0);
                        } else {
                            insertSql.append(tempBigDecimal);
                        }
                    }
                    insertSql.append(",'");
                    insertSql.append(rowSet.getString("companyname"));
                    insertSql.append("','");
                    insertSql.append(rowSet.getString("companylongnumber"));
                    insertSql.append("','");
                    insertSql.append(rowSet.getString("companysimplename"));
                    insertSql.append("','");
                    insertSql.append(rowSet.getString("kpiid"));
                    insertSql.append("','");
                    insertSql.append(rowSet.getString("companyid"));
                    insertSql.append("',");
                    insertSql.append(rowSet.getInt("level"));
                    insertSql.append(",'");
                    insertSql.append(rowSet.getString("companyNumber"));
                    insertSql.append("',");
                    insertSql.append(rowSet.getInt("isleaf"));
                    insertSql.append(",null)");
                    DbUtil.execute((Context)ctx, (String)insertSql.toString());
                    continue;
                }
                tempCheckSql = new StringBuffer();
                tempCheckSql.append(checkSql);
                tempCheckSql.append(" where t1.flongnumber like '" + kpiLongNumber[i] + "%' ) kpi");
                tempCheckSql.append(" on company.fid=kpi.companyid ");
                tempCheckSql.append(" where company.fid='" + companyId + "'");
                IRowSet checkRowSet = DbUtil.executeQuery((Context)ctx, (String)tempCheckSql.toString());
                if (checkRowSet == null || !checkRowSet.next()) continue;
                insertSql = new StringBuffer();
                insertSql.append(" insert into " + tempTableName + " values(");
                insertSql.append("'");
                insertSql.append(BOSUuid.create((BOSObjectType)bosType).toString());
                insertSql.append("','null','");
                String tempLongNumber = checkRowSet.getString("kpilongnumber");
                if (tempLongNumber == null || "".equals(tempLongNumber)) {
                    insertSql.append(kpiLongNumber[i] + "!" + i);
                } else {
                    insertSql.append(tempLongNumber);
                }
                insertSql.append("','");
                insertSql.append(checkRowSet.getString("name"));
                insertSql.append("','");
                insertSql.append(checkRowSet.getString("simplename"));
                insertSql.append("',NULL,'");
                insertSql.append(checkRowSet.getString("companyname"));
                insertSql.append("','");
                insertSql.append(checkRowSet.getString("companylongnumber"));
                insertSql.append("','");
                insertSql.append(checkRowSet.getString("companysimplename"));
                insertSql.append("','");
                insertSql.append(checkRowSet.getString("kpiid"));
                insertSql.append("','");
                insertSql.append(checkRowSet.getString("companyid"));
                insertSql.append("',");
                insertSql.append(checkRowSet.getInt("level"));
                insertSql.append(",'");
                insertSql.append(checkRowSet.getString("companyNumber"));
                insertSql.append("',");
                insertSql.append(checkRowSet.getInt("isleaf"));
                insertSql.append(",'");
                insertSql.append(checkRowSet.getString("kpivalueid"));
                insertSql.append("')");
                DbUtil.execute((Context)ctx, (String)insertSql.toString());
            }
        }
    }

    private StringBuffer getCheckeSql() {
        StringBuffer checkSql = new StringBuffer();
        checkSql.append("select kpi.kpivaluelongnumber as flongnumber, ");
        checkSql.append(" kpi.longnumber as kpilongnumber,");
        checkSql.append(" kpi.kpiname as name, ");
        checkSql.append(" kpi.kpisimplename as simplename, ");
        checkSql.append(" kpi.kpivalue as kpivalue, ");
        checkSql.append(" company.fname_l2 as companyname, ");
        checkSql.append(" company.flongnumber as companylongnumber, ");
        checkSql.append(" company.fsimplename as companysimplename, ");
        checkSql.append(" kpi.kpiid as kpiid, ");
        checkSql.append(" company.fid as companyid ,");
        checkSql.append(" company.flevel as level, ");
        checkSql.append(" company.fnumber as companyNumber, ");
        checkSql.append(" company.fisleaf as isleaf, ");
        checkSql.append(" kpi.kpivalueid as kpivalueid ");
        checkSql.append(" from T_ORG_Admin company ");
        checkSql.append(" left outer join ");
        checkSql.append("( select t1.fid as kpiid,t1.flongnumber as longnumber,t1.fname_l2 as kpiname,");
        checkSql.append(" \tt1.fsimplename as kpisimplename ,t1.fcompanyid as companyid,");
        checkSql.append("  \tt2.fkpivalue as kpivalue,t2.fid as kpivalueid,t2.flongnumber as kpivaluelongnumber ");
        checkSql.append(" \tfrom t_mp_kpi t1 inner join t_mp_kpivalue t2 ");
        checkSql.append(" \ton t1.fid=t2.fkpiid ");
        return checkSql;
    }

    private StringBuffer getReportSql(String[] companys, String[] kpiIDs) {
        if (companys == null || kpiIDs == null) {
            // empty if block
        }
        return null;
    }

    private void getReportNew(Context ctx, String[] companys, String[] kpiLongNumber, String[] kpiValueLongNumber) {
        ArrayList dateList = new ArrayList();
        ArrayList tempList = new ArrayList();
        for (int i = 0; i < companys.length; ++i) {
            for (int j = 0; j < kpiLongNumber.length; ++j) {
            }
        }
    }

    private String[] getKPIValueLongNumber(Context ctx, String[] kpiIDs, String time) throws BOSException, SQLException {
        String[] longNumbers = new String[kpiIDs.length];
        StringBuffer sql = new StringBuffer();
        sql.append("select kpiValue.flongnumber as flongnumber ");
        sql.append(" from t_mp_kpi kpi ");
        sql.append(" inner join t_mp_kpivalue kpiValue ");
        sql.append(" on kpi.fid = kpiValue.fkpiid ");
        sql.append(" where kpi.fid=? ");
        for (int i = 0; i < kpiIDs.length; ++i) {
            String flongnumber;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{kpiIDs[i]});
            if (rowSet == null || !rowSet.next()) continue;
            longNumbers[i] = flongnumber = rowSet.getString("flongnumber");
        }
        return longNumbers;
    }

    private String[] getKPILongNumber(Context ctx, String[] kpiIDs) throws BOSException, SQLException {
        String[] longNumbers = new String[kpiIDs.length];
        String sql = "select flongnumber from t_mp_kpi where fid=? ";
        for (int i = 0; i < kpiIDs.length; ++i) {
            String flongnumber;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{kpiIDs[i]});
            if (rowSet == null || !rowSet.next()) continue;
            longNumbers[i] = flongnumber = rowSet.getString("flongnumber");
        }
        return longNumbers;
    }

    private void getKPICollectionByLongNumber(Context ctx, String[] companys, String longNumber) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer marking = new StringBuffer();
        filter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)longNumber, CompareType.LIKE));
        marking.append(" #0 and ( ");
        for (int i = 0; i < companys.length; ++i) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companys[i], CompareType.EQUALS));
            if (i == 0) {
                marking.append(" #" + i);
                continue;
            }
            marking.append(" or #" + i);
        }
    }

    private KPIValueInfo _getWarnparam(Context ctx, String kpiValueId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        IKPIValue iKpiValue = KPIValueFactory.getLocalInstance(ctx);
        return iKpiValue.getKPIValueInfo((IObjectPK)new ObjectUuidPK(kpiValueId), sic);
    }

    private StringBuffer getReportSql(String[] companys, String[] kpiLongNumber, String[] kpiValueLongNumber) {
        StringBuffer sql = this.getReportBaseSql(kpiLongNumber, kpiValueLongNumber);
        sql.append(" where ");
        sql.append(" COMPANY.FID in (''");
        for (int i = 0; i < companys.length; ++i) {
            sql.append(",'" + companys[i] + "'");
        }
        sql.append(" ) ");
        sql.append(this.getReportSortSql());
        return sql;
    }

    private StringBuffer getReportSortSql() {
        StringBuffer sortSql = new StringBuffer();
        sortSql.append(" ORDER BY COMPANY.FLONGNUMBER,KPI.FLONGNUMBER ");
        return sortSql;
    }

    private StringBuffer getReportBaseSql(String[] kpiLongNumber, String[] kpiValueLongNumber) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ");
        sql.append(" KPI.FName_l2 AS NAME, ");
        sql.append(" KPI.FSimpleName AS SIMPLENAME,");
        sql.append(" KPIVALUE.FKpiValue AS KPIVALUE,");
        sql.append(" COMPANY.FSimpleName AS COMPANYNAME,");
        sql.append(" COMPANY.FSimpleName AS COMPANYSIMPLENAME,");
        sql.append(" KPIVALUE.FID AS KPIVALUEID,");
        sql.append(" KPI.FID AS KPIID,");
        sql.append(" COMPANY.FID AS COMPANYID");
        sql.append(" FROM T_ORG_Admin AS COMPANY ");
        sql.append(" LEFT OUTER JOIN ");
        sql.append(this.getKPISql(kpiLongNumber).toString());
        sql.append(" AS KPI");
        sql.append(" ON KPI.FCompanyID = COMPANY.FID");
        sql.append(" LEFT OUTER JOIN ");
        sql.append(this.getKPIValueSql(kpiValueLongNumber).toString());
        sql.append(" AS KPIVALUE ");
        sql.append(" ON KPI.FID = KPIVALUE.FKpiID ");
        return sql;
    }

    private StringBuffer getKPIValueSql(String[] kpiValueLongNumber) {
        StringBuffer sql = new StringBuffer();
        sql.append(" ( SELECT t2.* FROM T_MP_KPIVALUE  t2 WHERE ");
        for (int i = 0; i < kpiValueLongNumber.length; ++i) {
            if (i == 0) {
                sql.append("t2.FLONGNUMBER like'");
                sql.append(kpiValueLongNumber[i]);
                sql.append("'");
                continue;
            }
            sql.append(" or t2.FLONGNUMBER like'");
            sql.append(kpiValueLongNumber[i]);
            sql.append("'");
        }
        sql.append(" )");
        return sql;
    }

    private StringBuffer getKPISql(String[] kpiLongNumber) {
        StringBuffer sql = new StringBuffer();
        sql.append(" ( SELECT t1.* FROM T_MP_KPI  t1 WHERE ");
        for (int i = 0; i < kpiLongNumber.length; ++i) {
            if (i == 0) {
                sql.append("t1.FLONGNUMBER like'");
                sql.append(kpiLongNumber[i]);
                sql.append("'");
                continue;
            }
            sql.append(" or t1.FLONGNUMBER like'");
            sql.append(kpiLongNumber[i]);
            sql.append("'");
        }
        sql.append(" )");
        return sql;
    }

    private StringBuffer getReportBaseSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ");
        sql.append(" KPI.FName_l2 AS NAME, ");
        sql.append(" KPI.FSimpleName AS SIMPLENAME,");
        sql.append(" KPIVALUE.FKpiValue AS KPIVALUE,");
        sql.append(" COMPANY.FName_l2 AS COMPANYNAME,");
        sql.append(" COMPANY.FSimpleName AS COMPANYSIMPLENAME,");
        sql.append(" KPIVALUE.FID AS KPIVALUEID,");
        sql.append(" KPI.FID AS KPIID,");
        sql.append(" COMPANY.FID AS COMPANYID");
        sql.append(" FROM T_MP_KPI AS KPI ");
        sql.append(" LEFT OUTER JOIN T_MP_KPIValue AS KPIVALUE ");
        sql.append(" ON KPI.FID = KPIVALUE.FKpiID ");
        sql.append(" RIGHT OUTER JOIN T_ORG_Admin AS COMPANY ");
        sql.append(" ON KPI.FCompanyID = COMPANY.FID");
        return sql;
    }

    protected void _getReportByEntity(Context ctx) throws BOSException {
    }

    protected IObjectCollection _getKPICols(Context ctx, String[] kpiIDs) throws BOSException, EASBizException {
        SelectorItemCollection scc = new SelectorItemCollection();
        scc.add(new SelectorItemInfo("id"));
        scc.add(new SelectorItemInfo("number"));
        scc.add(new SelectorItemInfo("name"));
        scc.add(new SelectorItemInfo("reportCurrency.*"));
        scc.add(new SelectorItemInfo("baseCurrency.*"));
        return null;
    }

    protected KPIInfo _getKpiIdByKpiValueId(Context ctx, String kpiValueId, SelectorItemCollection selector) throws BOSException, EASBizException {
        String sql = "select fkpiid from t_mp_kpivalue where fid=? ";
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{kpiValueId});
        String kpiId = null;
        KPIInfo kpiInfo = null;
        if (iRowSet != null) {
            try {
                if (iRowSet.next()) {
                    kpiId = iRowSet.getString("fkpiid");
                }
            }
            catch (SQLException e) {
                logger.info((Object)"IN THE KPIFACADECONTROLLERBEN ,GET KPI ERROR");
                e.printStackTrace();
            }
        }
        if (kpiId != null) {
            kpiInfo = KPIFactory.getLocalInstance(ctx).getKPIInfo((IObjectPK)new ObjectUuidPK(kpiId), selector);
        }
        return kpiInfo;
    }

    protected List _getTimeDimensions(Context ctx, String reportSetId) throws BOSException, EASBizException {
        ArrayList<TimeDimensionInfo> timeDimensions = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct t4.fname_l2 as displayName,t4.ftimetext as timeText ");
        sql.append(" from t_mp_kpianalysisreportset t1 ");
        sql.append(" inner join t_mp_kpianalysisreportofkpi t2 on t1.fid=t2.FAnalysisSetID");
        sql.append(" inner join t_mp_kpi t3 on t2.fkpiid = t3.fid");
        sql.append(" inner join t_mp_kpivalue t4 on t3.fid=t4.fkpiid");
        sql.append(" where t1.fid=?");
        sql.append(" and  t1.freporttype=t3.ftimetype ");
        sql.append(" order by t4.ftimetext desc ");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{reportSetId});
        if (iRowSet != null) {
            timeDimensions = new ArrayList<TimeDimensionInfo>();
            try {
                while (iRowSet.next()) {
                    TimeDimensionInfo timeInfo = new TimeDimensionInfo();
                    timeInfo.setKey(iRowSet.getString("timeText"));
                    timeInfo.setValue(iRowSet.getString("displayName"));
                    timeDimensions.add(timeInfo);
                }
            }
            catch (SQLException e) {
                logger.info((Object)"IN THE KPIFACADECONTROLLERBEN ,GET KPI ERROR");
                e.printStackTrace();
            }
        }
        return timeDimensions;
    }

    private List getTimeDimensionHandle(Context ctx, String reportSetId) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct kpivalue.fname_l2 as timename,");
        sql.append("   kpivalue.ftimetext as timevalue ");
        sql.append(" from t_mp_kpianalysisreportset reportset ");
        sql.append(" inner join t_mp_kpianalysisreportofkpi ofkpi ");
        sql.append(" on reportset.fid=ofkpi.fanalysissetid ");
        sql.append(" inner join t_mp_kpi kpi ");
        sql.append(" on ofkpi.fkpiid=kpi.fid ");
        sql.append(" inner join t_mp_kpivalue kpivalue ");
        sql.append(" on kpi.fid=kpivalue.fkpiid ");
        sql.append(" where reportset.fid=? ");
        sql.append(" order by timevalue desc ");
        ArrayList<TimeDimensionInfo> timeDimensions = null;
        IRowSet rowSet = null;
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{reportSetId});
        if (rowSet != null) {
            timeDimensions = new ArrayList<TimeDimensionInfo>();
            while (rowSet.next()) {
                TimeDimensionInfo timeInfo = new TimeDimensionInfo();
                timeInfo.setKey(rowSet.getString("timevalue"));
                timeInfo.setValue(rowSet.getString("timename"));
                timeDimensions.add(timeInfo);
            }
        }
        return timeDimensions;
    }

    protected boolean _isFromUnifyKpi(Context ctx, String kpiNumber, String sourceKpiNumber) throws BOSException, EASBizException {
        return true;
    }

    protected boolean _isFromUnifyKpi(Context ctx, String kpiLongNumber, String soureceKpiLongNumber, String timeText) throws BOSException, EASBizException {
        if (kpiLongNumber == null || soureceKpiLongNumber == null || kpiLongNumber.startsWith(soureceKpiLongNumber)) {
            // empty if block
        }
        return false;
    }

    protected boolean _isWarn(Context ctx, String kpiValueId, String nowDate, int beforeTime) throws BOSException, EASBizException {
        SelectorItemCollection cols = new SelectorItemCollection();
        cols.add(new SelectorItemInfo("*"));
        cols.add(new SelectorItemInfo("kpi.timeType"));
        KPIValueInfo kpiValueInfo = KPIValueFactory.getLocalInstance(ctx).getKPIValueInfo((IObjectPK)new ObjectUuidPK(kpiValueId), cols);
        boolean isWarn = false;
        if (kpiValueInfo != null) {
            KPIInfo kpiInfo = kpiValueInfo.getKpi();
            KPITimeTypeEnum timeType = kpiInfo.getTimeType();
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date curDate = format.parse(nowDate);
                Date beginDate = new Date();
                int j = Math.abs(beforeTime);
                j = -j;
                calendar.setTime(curDate);
                if (KPITimeTypeEnum.day.equals((Object)timeType)) {
                    calendar.add(6, j);
                    beginDate = calendar.getTime();
                } else if (KPITimeTypeEnum.week.equals((Object)timeType)) {
                    calendar.add(3, j);
                    beginDate = calendar.getTime();
                } else if (KPITimeTypeEnum.month.equals((Object)timeType)) {
                    calendar.add(2, j);
                    beginDate = calendar.getTime();
                } else if (KPITimeTypeEnum.season.equals((Object)timeType)) {
                    beginDate = this.getBeginDate_season(calendar, j);
                } else if (KPITimeTypeEnum.halfYear.equals((Object)timeType)) {
                    beginDate = this.getBeginDate_halfYear(calendar, j);
                } else if (KPITimeTypeEnum.year.equals((Object)timeType)) {
                    calendar.add(1, j);
                    beginDate = calendar.getTime();
                }
                Date valueDate = kpiValueInfo.getBizDate();
                if (valueDate != null && (valueDate = format.parse(format.format(valueDate))).compareTo(beginDate = format.parse(format.format(beginDate))) >= 0 && valueDate.compareTo(curDate) <= 0) {
                    isWarn = true;
                }
            }
            catch (Exception e) {
                logger.info((Object)"_isWarn is error!");
                e.printStackTrace();
            }
        }
        System.out.println("isWarn:" + isWarn);
        return isWarn;
    }

    protected void _updateKpi(Context ctx) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection sic = ev.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("kpiValue.formula"));
        IKPI ikpi = KPIFactory.getLocalInstance(ctx);
        KPICollection kpiCols = ikpi.getKPICollection(ev);
        if (kpiCols != null) {
            Iterator ite = kpiCols.iterator();
            String sql = "update t_mp_kpi set fformula=? where fid=?";
            while (ite.hasNext()) {
                KPIInfo kpiInfo = (KPIInfo)ite.next();
                KPIValueCollection vCols = kpiInfo.getKpiValue();
                if (vCols == null || vCols.size() <= 0) continue;
                KPIValueInfo vInfo = vCols.get(0);
                kpiInfo.setFormula(vInfo.getFormula());
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{vInfo.getFormula(), kpiInfo.getId().toString()});
            }
        }
    }

    protected List _getCompanyLevel(Context ctx) throws BOSException, EASBizException {
        String sql = " select distinct flevel from t_org_admin order by flevel ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet != null) {
            ArrayList<Integer> level = new ArrayList<Integer>();
            try {
                while (rowSet.next()) {
                    level.add(new Integer(rowSet.getInt("flevel")));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return level;
        }
        return null;
    }

    protected BigDecimal _calcFormula(Context ctx, String formula, Map params) throws BOSException, EASBizException {
        if (formula == null) {
            logger.info((Object)"sem_mp error: formula is null!");
            return null;
        }
        if (params == null) {
            logger.info((Object)"sem_mp error: params is null!");
            return null;
        }
        Map context = this.initCaculateParam(ctx, params);
        ArrayList<String> list = new ArrayList<String>();
        if (!(formula = formula.trim()).startsWith("=")) {
            formula = "=" + formula;
        }
        if (formula.endsWith(";")) {
            formula = formula.substring(0, formula.length() - 1);
        }
        list.add(formula);
        DateContextHandler handler = new DateContextHandler();
        Variant[] tempResult = ReportFactory.getLocalInstance((Context)ctx).calcFormulas(context, list, (IContextHandler)handler);
        if (tempResult == null && tempResult.length <= 0) {
            logger.info((Object)("calculate formula error(result is null),formula is:" + formula));
            return new BigDecimal(0);
        }
        Variant variant = tempResult[0];
        Object obj = variant.getValue();
        if (obj != null && obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj != null && obj instanceof Integer) {
            return new BigDecimal(obj.toString());
        }
        if (obj instanceof SyntaxErrorException) {
            Object tempExc = ((SyntaxErrorException)obj).getExtData();
            if (tempExc instanceof EASBizException) {
                throw (EASBizException)((Object)tempExc);
            }
            return null;
        }
        if (obj instanceof EASBizException) {
            throw (EASBizException)((Object)obj);
        }
        if (obj instanceof BOSException) {
            throw (BOSException)((Object)obj);
        }
        return null;
    }

    protected List _calcFormulas(Context ctx, String[] formulas, Map params) throws BOSException, EASBizException {
        if (formulas == null || formulas.length <= 0) {
            logger.info((Object)"sem_mp error: formulas is null or formulas's length < 0!");
            return null;
        }
        if (params == null) {
            logger.info((Object)"sem_mp error: params is null!");
            return null;
        }
        Map context = this.initCaculateParam(ctx, params);
        Variant[] tempResult = null;
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<Variant[]> formulaValues = new ArrayList<Variant[]>();
        for (int i = 0; i < formulas.length; ++i) {
            String formula = formulas[i];
            if (null != formula) {
                if (!formula.startsWith("=")) {
                    formula = "=" + formula;
                }
                if (formula.endsWith(";")) {
                    formula = formula.substring(0, formula.length() - 1);
                }
            }
            list.add(formula);
        }
        DateContextHandler handler = new DateContextHandler();
        tempResult = ReportFactory.getLocalInstance((Context)ctx).calcFormulas(context, list, (IContextHandler)handler);
        formulaValues.add(tempResult);
        return formulaValues;
    }

    protected List _calcFormulas(Context ctx, Date[] times, String formula, Map params) throws BOSException, EASBizException {
        if (formula == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        if (!formula.startsWith("=")) {
            formula = "=" + formula;
        }
        if (formula.endsWith(";")) {
            formula = formula.substring(0, formula.length() - 1);
        }
        list.add(formula);
        HashMap<String, Object> context = new HashMap<String, Object>();
        Calendar calendar = Calendar.getInstance();
        IReport iReport = ReportFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = null;
        CurrencyInfo currencyInfo = null;
        OrgUnitInfo tempCompany = null;
        Object obj = params.get("company");
        if (obj != null && obj instanceof OrgUnitInfo) {
            tempCompany = (OrgUnitInfo)obj;
            companyInfo = this.getCompanyInfo(ctx, tempCompany);
            currencyInfo = this.getCurrency(companyInfo);
        }
        DateContextHandler handler = new DateContextHandler();
        context.put("IContextHandler_company", companyInfo);
        context.put("IContextHandler_currency", currencyInfo);
        ArrayList<BigDecimal> formulaValues = new ArrayList<BigDecimal>();
        for (int i = 0; i < times.length; ++i) {
            BigDecimal calcResult;
            Date bizDate = times[i];
            context.put("DateContextHandler_date", bizDate);
            Variant[] tempResult = iReport.calcFormulas(context, list, (IContextHandler)handler);
            if (tempResult == null && tempResult.length <= 0) {
                logger.info((Object)("*** calculate formula error(result is null),formula is:" + formula));
                calcResult = new BigDecimal(0);
            } else {
                Variant variant = tempResult[0];
                obj = variant.getValue();
                calcResult = obj != null && obj instanceof BigDecimal ? (BigDecimal)obj : new BigDecimal(0);
            }
            formulaValues.add(calcResult);
        }
        return formulaValues;
    }

    private CompanyOrgUnitInfo getCompanyInfo(Context ctx, OrgUnitInfo company) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo;
        OrgUnitInfo ou = company;
        String companyid = ou.getId().toString();
        if (!ou.isIsCompanyOrgUnit() && (ou = NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx).getDelegateUnit(companyid, OrgType.Company)) != null) {
            companyid = ou.getId().toString();
        }
        if (ou == null) {
            companyInfo = RptUtilForServer.getCurrentCompany((Context)ctx);
        } else {
            companyInfo = new CompanyOrgUnitInfo();
            companyInfo.setId(ou.getId());
            companyInfo.setNumber(ou.getNumber());
        }
        SelectorItemCollection scc = new SelectorItemCollection();
        scc.add(new SelectorItemInfo("id"));
        scc.add(new SelectorItemInfo("number"));
        scc.add(new SelectorItemInfo("name"));
        scc.add(new SelectorItemInfo("reportCurrency.*"));
        scc.add(new SelectorItemInfo("baseCurrency.*"));
        companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()), scc);
        return companyInfo;
    }

    private CurrencyInfo getCurrency(CompanyOrgUnitInfo companyInfo) {
        CurrencyInfo currencyInfo = new CurrencyInfo();
        if (companyInfo == null) {
            return currencyInfo;
        }
        currencyInfo = companyInfo.isIsOnlyUnion() ? companyInfo.getReportCurrency() : companyInfo.getBaseCurrency();
        return currencyInfo;
    }

    protected KPICollection _getKPIInfoForBeacon(Context ctx, List kpiIDs) throws BOSException, EASBizException {
        if (kpiIDs == null || kpiIDs.size() <= 0) {
            return null;
        }
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection selector = ev.getSelector();
        selector.add("id");
        selector.add("name");
        selector.add("currentValue");
        selector.add("currentWarnStatus.color");
        selector.add("lastComputeTime");
        selector.add("formula");
        selector.add("numberUnit");
        selector.add("isPercent");
        selector.add("displayPrecision");
        selector.add("isUnpassedVoucherIncluded");
        selector.add("kpiValue.*");
        selector.add("kpiValue.currentWarnStatus.*");
        selector.add("kpiValue.warnparam.*");
        selector.add("kpiValue.warnparam.warnGroup.color");
        FilterInfo filter = new FilterInfo();
        int index = 0;
        Iterator ite = kpiIDs.iterator();
        StringBuffer mark = new StringBuffer();
        while (ite.hasNext()) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ite.next().toString()));
            if (index == 0) {
                mark.append(" #").append(index);
            } else {
                mark.append(" or #").append(index);
            }
            ++index;
        }
        filter.setMaskString(mark.toString());
        ev.setFilter(filter);
        SorterItemInfo sorter = new SorterItemInfo("kpiValue.bizDate");
        sorter.setSortType(SortType.DESCEND);
        ev.getSorter().add(sorter);
        KPICollection kpiCols = KPIFactory.getLocalInstance(ctx).getKPICollection(ev);
        return kpiCols;
    }

    protected KPICollection _getKpiInfoForDial(Context ctx, List kpiIDs) throws BOSException, EASBizException {
        if (kpiIDs == null || kpiIDs.size() <= 0) {
            return null;
        }
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection selector = ev.getSelector();
        selector.add("id");
        selector.add("name");
        selector.add("currentValue");
        selector.add("currentWarnStatus.color");
        selector.add("lastComputeTime");
        selector.add("formula");
        selector.add("numberUnit");
        selector.add("isPercent");
        selector.add("displayPrecision");
        selector.add("isUnpassedVoucherIncluded");
        FilterInfo filter = new FilterInfo();
        int index = 0;
        Iterator ite = kpiIDs.iterator();
        StringBuffer mark = new StringBuffer();
        while (ite.hasNext()) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ite.next().toString()));
            if (index == 0) {
                mark.append(" #").append(index);
            } else {
                mark.append(" or #").append(index);
            }
            ++index;
        }
        filter.setMaskString(mark.toString());
        ev.setFilter(filter);
        KPICollection kpiCols = KPIFactory.getLocalInstance(ctx).getKPICollection(ev);
        this.refreshKPICollection(ctx, kpiCols);
        return kpiCols;
    }

    private void refreshKPICollection(Context ctx, KPICollection kpiCols) throws BOSException {
        if (kpiCols == null || kpiCols.size() <= 0) {
            return;
        }
        Iterator ite = kpiCols.iterator();
        while (ite.hasNext()) {
            KPIInfo kpiInfo = (KPIInfo)ite.next();
            KPIValueCollection valueCols = this.getKpiValuesByOrder(ctx, kpiInfo.getId().toString());
            kpiInfo.getKpiValue().clear();
            kpiInfo.getKpiValue().addCollection(valueCols);
        }
    }

    private KPIValueCollection getKpiValuesByOrder(Context ctx, String kpiId) throws BOSException {
        IKPIValue kpiValue = KPIValueFactory.getLocalInstance(ctx);
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection selector = ev.getSelector();
        selector.add("*");
        selector.add("warnparam.*");
        selector.add("warnparam.warnGroup.*");
        selector.add("currentWarnStatus.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("kpi.id", (Object)kpiId));
        ev.setFilter(filter);
        SorterItemInfo sorterInfo = new SorterItemInfo("bizDate");
        sorterInfo.setSortType(SortType.DESCEND);
        ev.getSorter().add(sorterInfo);
        KPIValueCollection cols = kpiValue.getKPIValueCollection(ev);
        return cols;
    }

    private Date getBeginDate_halfYear(Calendar calendar, int step) {
        step = Math.abs(step);
        int month = -step * 6;
        calendar.add(2, month);
        int halfYear = this.getHalfYear(calendar.get(2));
        return this.getHalfYearFirstDay(calendar, halfYear);
    }

    private Date getBeginDate_season(Calendar calendar, int step) {
        step = Math.abs(step);
        int month = -step * 3;
        calendar.add(2, month);
        int tempSeason = this.getSeason(calendar.get(2));
        return this.getSeasonFirstDay(calendar, tempSeason);
    }

    private Date getHalfYearFirstDay(Calendar calendar, int halfYear) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = "";
        dateString = halfYear == 1 ? calendar.get(1) + "-00-01" : (halfYear == 2 ? calendar.get(1) + "-05-01" : calendar.get(1) + "-00-01");
        try {
            return format.parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return calendar.getTime();
        }
    }

    private Date getSeasonFirstDay(Calendar calendar, int season) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = "";
        if (season == 1) {
            dateString = calendar.get(1) + "-00-01";
        } else if (season == 2) {
            dateString = calendar.get(1) + "-03-01";
        } else if (season == 3) {
            dateString = calendar.get(1) + "-06-01";
        } else if (season == 4) {
            dateString = calendar.get(1) + "-09-01";
        }
        try {
            return format.parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return calendar.getTime();
        }
    }

    private int getHalfYear(int month) {
        int halfYear = 1;
        if (month >= 6) {
            halfYear = 2;
        }
        return halfYear;
    }

    private int getSeason(int month) {
        int season = 1;
        switch (month) {
            case 0: {
                season = 1;
                break;
            }
            case 1: {
                season = 1;
                break;
            }
            case 2: {
                season = 1;
                break;
            }
            case 3: {
                season = 2;
                break;
            }
            case 4: {
                season = 2;
                break;
            }
            case 5: {
                season = 2;
                break;
            }
            case 6: {
                season = 3;
                break;
            }
            case 7: {
                season = 3;
                break;
            }
            case 8: {
                season = 3;
                break;
            }
            case 9: {
                season = 4;
                break;
            }
            case 10: {
                season = 4;
                break;
            }
            case 11: {
                season = 4;
                break;
            }
            default: {
                season = 1;
            }
        }
        return season;
    }

    protected List _initWarnGroupAndStandardValueNew(Context ctx, BOSUuid kpiID) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("kpiValue.*"));
        sic.add(new SelectorItemInfo("kpiValue.warnparam.*"));
        sic.add(new SelectorItemInfo("kpiValue.warnparam.warnGroup.*"));
        sic.add(new SelectorItemInfo("kpiValue.warnparam.edgeParam.*"));
        IKPI iKpi = KPIFactory.getLocalInstance(ctx);
        KPIInfo kpiInfo = null;
        try {
            kpiInfo = iKpi.getKPIInfo((IObjectPK)new ObjectUuidPK(kpiID), sic);
        }
        catch (Exception e) {
            logger.info((Object)"get kpiInfo error");
        }
        HashMap<String, Map> kpiStandardMap = new HashMap<String, Map>();
        HashMap<String, KPIWarnParamNewCollection> kpiWarnParamMap = new HashMap<String, KPIWarnParamNewCollection>(4);
        if (kpiInfo != null) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SorterItemCollection sorters = ev.getSorter();
            SorterItemInfo sorter = new SorterItemInfo("edgeParam.number");
            sorter.setSortType(SortType.ASCEND);
            sorters.add(sorter);
            sorter = new SorterItemInfo("warnGroup.periority");
            sorter.setSortType(SortType.DESCEND);
            sorters.add(sorter);
            SelectorItemCollection sic1 = ev.getSelector();
            sic1.add(new SelectorItemInfo("*"));
            sic1.add(new SelectorItemInfo("warnGroup.*"));
            sic1.add(new SelectorItemInfo("edgeParam.*"));
            IKPIRefStandardValueNew iKpiVRS = KPIRefStandardValueNewFactory.getLocalInstance(ctx);
            IKPIWarnParamNew iKpiWarnParam = KPIWarnParamNewFactory.getLocalInstance(ctx);
            KPIRefStandardValueNewCollection kpiVRSCols = null;
            KPIWarnParamNewCollection kpiWarnParamCols = null;
            kpiVRSCols = iKpiVRS.getKPIRefStandardValueNewCollection("where kpi='" + kpiInfo.getId().toString() + "'");
            if (kpiVRSCols != null && kpiVRSCols.size() > 0) {
                kpiStandardMap.put(kpiInfo.getId().toString(), this.reTypeDataNew(kpiVRSCols));
            }
            filter.getFilterItems().clear();
            filter.getFilterItems().add(new FilterItemInfo("kpi", (Object)kpiInfo.getId().toString()));
            ev.setFilter(filter);
            kpiWarnParamCols = iKpiWarnParam.getKPIWarnParamNewCollection(ev);
            if (kpiWarnParamCols != null && kpiWarnParamCols.size() > 0) {
                kpiWarnParamMap.put(kpiInfo.getId().toString(), kpiWarnParamCols);
            }
        }
        ArrayList<HashMap<String, Object>> backList = new ArrayList<HashMap<String, Object>>();
        backList.add(kpiStandardMap);
        backList.add(kpiWarnParamMap);
        return backList;
    }

    private Map initCaculateParam(Context ctx, Map params) throws EASBizException, BOSException {
        Object obj = params.get("timeType");
        obj = params.get("bizDate");
        if (obj == null || !(obj instanceof Date)) {
            logger.info((Object)"_calcFormula ,the bizDate is null ");
            return null;
        }
        Date bizDate = (Date)obj;
        CompanyOrgUnitInfo companyInfo = null;
        CurrencyInfo currencyInfo = null;
        OrgUnitInfo tempCompany = null;
        obj = params.get("company");
        if (obj != null && obj instanceof OrgUnitInfo) {
            tempCompany = (OrgUnitInfo)obj;
            companyInfo = this.getCompanyInfo(ctx, tempCompany);
            currencyInfo = this.getCurrency(companyInfo);
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("DateContextHandler_date", bizDate);
        context.put("IContextHandler_company", companyInfo);
        context.put("IContextHandler_currency", currencyInfo);
        context.put("timetype", params.get("timeType"));
        obj = params.get("IncludePosted");
        if (obj != null && obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            context.put("IContextHandler_INCLUDE_POSTED", "Y");
        } else {
            context.put("IContextHandler_INCLUDE_POSTED", "N");
        }
        obj = params.get("IncludeLeaf");
        if (obj != null && obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            context.put("IContextHandler_INCLUDE_LEAF", "Y");
        } else {
            context.put("IContextHandler_INCLUDE_LEAF", "N");
        }
        obj = params.get("IncludeSub");
        if (obj != null && obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            context.put("IContextHandler_INCLUDE_SUB", "Y");
        } else {
            context.put("IContextHandler_INCLUDE_SUB", "N");
        }
        return context;
    }

    protected void _singleCreateKPI(Context ctx, KPIInfo kpiInfo, Date date) throws BOSException {
        KPIAutoCreateKpiNewHandler autoCreate = new KPIAutoCreateKpiNewHandler();
        autoCreate.singleCreateKpi(ctx, kpiInfo, date);
    }

    protected IObjectCollection _getWarnParam(Context ctx, String warnGroupId) throws BOSException, EASBizException {
        EdgeParamCollection edgeCols = new EdgeParamCollection();
        try {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            evi.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)warnGroupId));
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.sem.mp.app.EdgeGroupParamQuery"));
            exec.setObjectView(evi);
            IRowSet rsParam = exec.executeQuery();
            EdgeParamInfo edgeParamInfo = null;
            IEdgeParam edgeParma = EdgeParamFactory.getLocalInstance(ctx);
            while (rsParam.next()) {
                edgeParamInfo = edgeParma.getEdgeParamInfo((IObjectPK)new ObjectUuidPK(rsParam.getString("edgeParam.id")));
                edgeCols.add(edgeParamInfo);
            }
        }
        catch (SQLException e) {
            logger.info((Object)"In the KPIFacadeControllerBean getWarnParam error!");
            e.printStackTrace();
        }
        return edgeCols;
    }
}

