/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.sem.mp.CSFCollection;
import com.kingdee.eas.sem.mp.CSFFactory;
import com.kingdee.eas.sem.mp.EdgeGroupCollection;
import com.kingdee.eas.sem.mp.EdgeGroupFactory;
import com.kingdee.eas.sem.mp.EdgeGroupInfo;
import com.kingdee.eas.sem.mp.EdgeParamFactory;
import com.kingdee.eas.sem.mp.EdgeParamInfo;
import com.kingdee.eas.sem.mp.IEdgeParam;
import com.kingdee.eas.sem.mp.IRefGroup;
import com.kingdee.eas.sem.mp.IWarnGroup;
import com.kingdee.eas.sem.mp.KPICollection;
import com.kingdee.eas.sem.mp.KPIFacadeFactory;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewCollection;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewInfo;
import com.kingdee.eas.sem.mp.KPITimeTypeEnum;
import com.kingdee.eas.sem.mp.KPIValueCollection;
import com.kingdee.eas.sem.mp.KPIValueFactory;
import com.kingdee.eas.sem.mp.KPIWarnParamNewCollection;
import com.kingdee.eas.sem.mp.KPIWarnParamNewInfo;
import com.kingdee.eas.sem.mp.RefGroupCollection;
import com.kingdee.eas.sem.mp.RefGroupFactory;
import com.kingdee.eas.sem.mp.RefGroupInfo;
import com.kingdee.eas.sem.mp.WarnGroupCollection;
import com.kingdee.eas.sem.mp.WarnGroupFactory;
import com.kingdee.eas.sem.mp.WarnGroupInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.ScriptUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

public class KPIHandle {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.sem.mp.app.KPIHandle");
    protected static final String RES = "com.kingdee.eas.sem.mp.app.KPIAppResource";
    KPIInfo newKpiInfo = null;
    private Map fileStdValueMap = new HashMap();
    Map fileMap = new HashMap();
    private Map refGroupNameToId;

    public CoreBaseInfo transmitMini(Hashtable hsData, Context ctx, boolean isUpdate) throws TaskExternalException {
        this.init();
        CompanyOrgUnitInfo orgUnitInfo = null;
        boolean processFlag = false;
        KPIInfo kpiInfo = null;
        kpiInfo = KPIHandle.getExistKpiInfo(ctx, hsData);
        if (null != kpiInfo && !isUpdate) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"kpi_has_exist"));
        }
        try {
            BeanUtils.copyProperties((Object)this.newKpiInfo, (Object)kpiInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        orgUnitInfo = this.getExistCompanyInfo(ctx, hsData);
        this.newKpiInfo.setPartFI(orgUnitInfo);
        if (null == orgUnitInfo) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"not_exist_org"));
        }
        processFlag = this.checkStandardValueColumn(hsData, ctx, orgUnitInfo);
        if (!processFlag) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"standardvalue_error"));
        }
        processFlag = this.checkKpiFormula(ctx, hsData, orgUnitInfo);
        if (!processFlag) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"kpi_formula_error"));
        }
        processFlag = this.checkKpiValue(ctx, hsData, orgUnitInfo);
        if (!processFlag) {
            throw new TaskExternalException("KPI Define Error.");
        }
        if (!isUpdate) {
            if (null != kpiInfo) {
                return null;
            }
            this.newKpiInfo.setId(null);
            return this.setKpiObject(ctx, hsData);
        }
        if (null != kpiInfo) {
            if (!this.compareKpiTimeType(kpiInfo, ctx, hsData) && this.checkIsExistKpiValue(kpiInfo, ctx)) {
                return null;
            }
            this.setDefalutId(this.newKpiInfo, kpiInfo);
        } else {
            this.newKpiInfo.setId(null);
        }
        return this.setKpiObject(ctx, hsData);
    }

    private void setDefalutId(KPIInfo newKpiInfo, KPIInfo kpiInfo) {
        KPIRefStandardValueNewCollection refCols = kpiInfo.getRefValue();
        KPIRefStandardValueNewCollection refNewCols = newKpiInfo.getRefValue();
        Iterator it = refCols.iterator();
        while (it.hasNext()) {
            KPIRefStandardValueNewInfo info = (KPIRefStandardValueNewInfo)it.next();
            Iterator newIt = refNewCols.iterator();
            while (newIt.hasNext()) {
                KPIRefStandardValueNewInfo newInfo = (KPIRefStandardValueNewInfo)newIt.next();
                if (!info.getRefGroup().getName().equals(newInfo.getRefGroup().getName())) continue;
                newInfo.setId(info.getId());
            }
        }
        KPIWarnParamNewCollection warnParamCols = kpiInfo.getWarnParam();
        KPIWarnParamNewCollection warnParamNewCols = newKpiInfo.getWarnParam();
        Iterator it2 = warnParamCols.iterator();
        while (it2.hasNext()) {
            KPIWarnParamNewInfo info = (KPIWarnParamNewInfo)it2.next();
            Iterator newIt = warnParamNewCols.iterator();
            while (newIt.hasNext()) {
                KPIWarnParamNewInfo newInfo = (KPIWarnParamNewInfo)newIt.next();
                if (!(info.getWarnGroup().getName() + info.getEdgeParam().getName()).equals(newInfo.getWarnGroup().getName() + newInfo.getEdgeParam().getName())) continue;
                newInfo.setId(info.getId());
            }
        }
    }

    private CompanyOrgUnitInfo getExistCompanyInfo(Context ctx, Hashtable hsData) throws TaskExternalException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        String companyNumber = hsData.get("company.number").toString();
        String companyName = hsData.get("company.name").toString();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        StringBuffer mask = new StringBuffer();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)companyInfo.getNumber(), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(companyInfo.getNumber() + "!%"), CompareType.LIKE));
        mask.append(" #0 or #1 ");
        filter.setMaskString(mask.toString());
        view.setFilter(filter);
        SorterItemInfo sorterInfo = new SorterItemInfo("longNumber");
        sorterInfo.setSortType(SortType.ASCEND);
        view.getSorter().add(sorterInfo);
        CompanyOrgUnitCollection cols = null;
        try {
            cols = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
            if (cols.size() > 0) {
                for (CompanyOrgUnitInfo orgUnitInfo : cols) {
                    if (!companyNumber.equals(orgUnitInfo.getNumber()) || !companyName.equals(orgUnitInfo.getName())) continue;
                    return orgUnitInfo;
                }
                return null;
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("getExistCompanyInfo exception..");
        }
        return null;
    }

    private boolean checkStandardValueColumn(Hashtable hsData, Context ctx, CompanyOrgUnitInfo orgUnitInfo) throws TaskExternalException {
        RefGroupCollection refCols = null;
        this.refGroupNameToId = new HashMap();
        try {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("partFI.id", (Object)orgUnitInfo.getId()));
            evi.setFilter(filter);
            IRefGroup refGroup = RefGroupFactory.getLocalInstance(ctx);
            refCols = refGroup.getRefGroupCollection(evi);
            int count = refCols.size();
            for (int i = 0; i < count; ++i) {
                RefGroupInfo refGroupInfo = refCols.get(i);
                this.refGroupNameToId.put(refGroupInfo.getName(), refGroupInfo.getId().toString());
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.toString());
        }
        if (refCols == null) {
            return false;
        }
        String currentValue = "";
        int fileStdSize = 0;
        int tempSize = 5;
        if (refCols.size() < 6) {
            tempSize = 5;
        } else if (refCols.size() < 11) {
            tempSize = 10;
        } else if (refCols.size() < 16) {
            tempSize = 15;
        } else if (refCols.size() < 21) {
            tempSize = 20;
        }
        for (int j = 1; j <= tempSize; ++j) {
            currentValue = hsData.get("stdValue.name" + j).toString();
            if (currentValue.equals("")) continue;
            ++fileStdSize;
            this.fileStdValueMap.put(currentValue, hsData.get("stdValue.value" + j).toString());
        }
        KPITimeTypeEnum timeType = KPITimeTypeEnum.getEnum(hsData.get("timeType").toString());
        HashMap<String, Object> params = new HashMap<String, Object>();
        String formula = null;
        params.put("bizDate", new Date());
        params.put("timeType", (Object)timeType);
        params.put("company", orgUnitInfo);
        if (fileStdSize == refCols.size()) {
            Iterator it = refCols.iterator();
            while (it.hasNext()) {
                RefGroupInfo refGroup = (RefGroupInfo)it.next();
                String refGroupName = refGroup.getName();
                if (null == this.fileStdValueMap.get(refGroupName)) {
                    return false;
                }
                KPIRefStandardValueNewInfo refValue = new KPIRefStandardValueNewInfo();
                refValue.setKpi(this.newKpiInfo);
                refValue.setRefGroup(refGroup);
                formula = (String)this.fileStdValueMap.get(refGroupName);
                refValue.setRefValue(formula);
                refValue.setCurrentValue(this.checkFormula(ctx, formula, params));
                this.newKpiInfo.getRefValue().add(refValue);
            }
            boolean tempFlag = false;
            for (String name : this.fileStdValueMap.keySet()) {
                it = refCols.iterator();
                while (it.hasNext()) {
                    RefGroupInfo refGroup = (RefGroupInfo)it.next();
                    String refGroupName = refGroup.getName();
                    if (!refGroupName.equals(name)) continue;
                    tempFlag = true;
                }
                if (tempFlag) {
                    tempFlag = !tempFlag;
                    continue;
                }
                return false;
            }
            return this.checkStandardValueFormula(ctx, hsData, orgUnitInfo);
        }
        return false;
    }

    public static KPIInfo getExistKpiInfo(Context ctx, Hashtable hsData) throws TaskExternalException {
        String companyNumber = hsData.get("company.number").toString();
        String companyName = hsData.get("company.name").toString();
        String kpiNumber = hsData.get("number").toString();
        String kpiName = hsData.get("name").toString();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("partFI.*"));
        view.getSelector().add(new SelectorItemInfo("warnParam.*"));
        view.getSelector().add(new SelectorItemInfo("warnParam.edgeParam.*"));
        view.getSelector().add(new SelectorItemInfo("warnParam.warnGroup.*"));
        view.getSelector().add(new SelectorItemInfo("currentWarnStatus.*"));
        view.getSelector().add(new SelectorItemInfo("refValue.*"));
        view.getSelector().add(new SelectorItemInfo("refValue.refGroup.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("partFI.number", (Object)companyNumber));
        filter.getFilterItems().add(new FilterItemInfo("partFI.name", (Object)companyName));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)kpiNumber));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)kpiName));
        StringBuffer masking = new StringBuffer();
        masking.append(" #0 and #1 and ( #2 or #3 ) ");
        filter.setMaskString(masking.toString());
        view.setFilter(filter);
        KPICollection kpiCols = null;
        try {
            kpiCols = KPIFactory.getLocalInstance(ctx).getKPICollection(view);
        }
        catch (Exception e) {
            throw new TaskExternalException("getExistKpiInfo exception..");
        }
        if (null != kpiCols && kpiCols.size() > 0) {
            return kpiCols.get(0);
        }
        return null;
    }

    private KPIInfo setKpiObject(Context ctx, Hashtable hsData) throws TaskExternalException {
        String tempData = null;
        tempData = hsData.get("description").toString();
        this.newKpiInfo.setDescription(tempData);
        tempData = hsData.get("number").toString();
        this.newKpiInfo.setNumber(this.checkIsNull(tempData));
        tempData = hsData.get("name").toString();
        this.newKpiInfo.setName(this.checkIsNull(tempData));
        return this.newKpiInfo;
    }

    private String checkIsNull(String tempData) throws TaskExternalException {
        if (null == tempData || "".equals(tempData)) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"kpi_number_name_null"));
        }
        return tempData;
    }

    private boolean compareKpiTimeType(KPIInfo kpiinfo, Context ctx, Hashtable hsData) throws TaskExternalException {
        KPITimeTypeEnum timeType = KPITimeTypeEnum.getEnum(hsData.get("timeType").toString());
        return null != timeType && timeType.equals((Object)kpiinfo.getTimeType());
    }

    private boolean checkIsExistKpiValue(KPIInfo kpiinfo, Context ctx) throws TaskExternalException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("kpi", (Object)kpiinfo.getId().toString()));
        view.setFilter(filter);
        KPIValueCollection kpiValueCols = null;
        try {
            kpiValueCols = KPIValueFactory.getLocalInstance(ctx).getKPIValueCollection(view);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.toString());
        }
        return null != kpiValueCols && kpiValueCols.size() > 0;
    }

    private BigDecimal checkFormula(Context ctx, String formula, Map params) throws TaskExternalException {
        try {
            BigDecimal value = KPIFacadeFactory.getLocalInstance(ctx).calcFormula(formula, params);
            return value;
        }
        catch (Exception e) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"standardvalue_error"));
        }
    }

    private boolean checkStandardValueFormula(Context ctx, Hashtable hsData, CompanyOrgUnitInfo orgUnitInfo) throws TaskExternalException {
        Iterator itMap = this.fileStdValueMap.keySet().iterator();
        KPITimeTypeEnum timeType = KPITimeTypeEnum.getEnum(hsData.get("timeType").toString());
        String formula = null;
        boolean exitFlag = false;
        HashMap<String, Object> params = new HashMap<String, Object>();
        BigDecimal value = null;
        params.put("bizDate", new Date());
        params.put("timeType", (Object)timeType);
        params.put("company", orgUnitInfo);
        while (itMap.hasNext()) {
            formula = (String)this.fileStdValueMap.get(itMap.next());
            if ("".equals(formula.trim())) continue;
            value = this.checkFormula(ctx, formula, params);
            if (value != null) {
                exitFlag = true;
            }
            if (exitFlag) {
                exitFlag = false;
                continue;
            }
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"kpi_standard_formula_permission_error"));
        }
        return true;
    }

    private boolean checkKpiFormula(Context ctx, Hashtable hsData, CompanyOrgUnitInfo orgUnitInfo) throws TaskExternalException {
        KPITimeTypeEnum timeType = KPITimeTypeEnum.getEnum(hsData.get("timeType").toString());
        String formula = hsData.get("formula").toString();
        boolean exitFlag = true;
        HashMap<String, Object> params = new HashMap<String, Object>();
        BigDecimal value = null;
        params.put("bizDate", new Date());
        params.put("timeType", (Object)timeType);
        params.put("company", orgUnitInfo);
        value = this.checkFormula(ctx, formula, params);
        if (null != value) {
            exitFlag = true;
        }
        this.newKpiInfo.setFormula(formula);
        this.newKpiInfo.setCurrentValue(value);
        if (exitFlag) {
            return true;
        }
        throw new TaskExternalException(EASResource.getString((String)RES, (String)"kpi_formula_permission_error"));
    }

    private boolean checkKpiValue(Context ctx, Hashtable hsData, CompanyOrgUnitInfo orgUnitInfo) throws TaskExternalException {
        KPITimeTypeEnum timeType = KPITimeTypeEnum.getEnum(hsData.get("timeType").toString());
        if (null == timeType) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"kpi_timeType_error"));
        }
        this.newKpiInfo.setTimeType(timeType);
        if (!this.checkCsfBsc(ctx, hsData, orgUnitInfo)) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"kpi_csf_bsc_error"));
        }
        if (!this.checkWarnParam(ctx, hsData)) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"kpi_edge_warnparam_error"));
        }
        this.newKpiInfo.setNumberUnit(hsData.get("numberUnit").toString());
        String tempData = null;
        tempData = hsData.get("isWarnable").toString();
        if ("".equals(tempData) || !this.checkBooleanType(tempData)) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"is_warnable_error"));
        }
        this.newKpiInfo.setIsWarnable(Boolean.valueOf(tempData));
        tempData = hsData.get("isModifiable").toString();
        if ("".equals(tempData) || !this.checkBooleanType(tempData)) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"is_modifiable_error"));
        }
        this.newKpiInfo.setIsModifiable(Boolean.valueOf(tempData));
        tempData = hsData.get("atomFormula").toString();
        if ("".equals(tempData) || !this.checkBooleanType(tempData)) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"is_atomFormula_error"));
        }
        this.newKpiInfo.setIsAtomFormula(Boolean.valueOf(tempData));
        tempData = hsData.get("isPercent").toString();
        if ("".equals(tempData) || !this.checkBooleanType(tempData)) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"is_percent_error"));
        }
        this.newKpiInfo.setIsPercent(Boolean.valueOf(tempData));
        tempData = hsData.get("isUnpassedVoucherIncluded").toString();
        if ("".equals(tempData) || !this.checkBooleanType(tempData)) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"is_UnpassedVoucherIncluded"));
        }
        this.newKpiInfo.setIsUnpassedVoucherIncluded(Boolean.valueOf(tempData));
        tempData = hsData.get("isDetailItemBalance").toString();
        if ("".equals(tempData) || !this.checkBooleanType(tempData)) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"is_DetailItemBalance"));
        }
        this.newKpiInfo.setIsDetailItemBalanceInclude(Boolean.valueOf(tempData));
        tempData = hsData.get("isSubItemBalance").toString();
        if ("".equals(tempData) || !this.checkBooleanType(tempData)) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"is_SubItemBalance"));
        }
        this.newKpiInfo.setIsSubItemBalanceInclude(Boolean.valueOf(tempData));
        tempData = hsData.get("displayPrecision").toString();
        try {
            int temp;
            if (null != tempData && "" != tempData) {
                temp = new Integer(tempData);
                if (temp < 2 || temp > 10) {
                    throw new TaskExternalException(EASResource.getString((String)RES, (String)"display_Precision_x"));
                }
            } else {
                throw new TaskExternalException(EASResource.getString((String)RES, (String)"display_Precision_x"));
            }
            this.newKpiInfo.setDisplayPrecision(temp);
        }
        catch (Exception e) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"display_Precision_x"));
        }
        return true;
    }

    private boolean checkBooleanType(String tempData) {
        if (null != tempData && "" != tempData) {
            return (tempData = tempData.toLowerCase()).equals("true") || tempData.equals("false");
        }
        return true;
    }

    private boolean checkCsfBsc(Context ctx, Hashtable hsData, CompanyOrgUnitInfo orgUnitInfo) throws TaskExternalException {
        String csf = hsData.get("csf").toString();
        String bsc = hsData.get("bsc").toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)csf));
        filter.getFilterItems().add(new FilterItemInfo("partFI.id", (Object)orgUnitInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("BSC.name", (Object)bsc));
        view.setFilter(filter);
        try {
            CSFCollection csfCols = CSFFactory.getLocalInstance(ctx).getCSFCollection(view);
            if (null != csfCols && csfCols.size() > 0) {
                this.newKpiInfo.setCsf(csfCols.get(0));
                return true;
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.toString());
        }
        return false;
    }

    private boolean checkWarnParam(Context ctx, Hashtable hsData) throws TaskExternalException {
        String edgeName = hsData.get("currentWarnStatus").toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        EdgeGroupCollection edgeCols = null;
        EdgeGroupInfo edgeGroupInfo = null;
        HashMap<String, String> edgeParamMap = new HashMap<String, String>();
        for (int i = 1; i < 5; ++i) {
            String wp = hsData.get("warnParam.name" + i).toString();
            if (null == wp || "" == wp) continue;
            if (null != hsData.get("warnParam.value" + i)) {
                this.fileMap.put(wp, hsData.get("warnParam.value" + i).toString());
                continue;
            }
            return false;
        }
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)edgeName));
        view.setFilter(filter);
        try {
            edgeCols = EdgeGroupFactory.getLocalInstance(ctx).getEdgeGroupCollection(view);
            if (null != edgeCols && edgeCols.size() > 0) {
                edgeGroupInfo = edgeCols.get(0);
                this.newKpiInfo.setCurrentWarnStatus(edgeGroupInfo);
                filter.getFilterItems().clear();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)edgeGroupInfo.getId().toString()));
                IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.sem.mp.app.EdgeGroupParamQuery"));
                exec.setObjectView(view);
                IRowSet rsParam = exec.executeQuery();
                IWarnGroup warnGroup = WarnGroupFactory.getLocalInstance(ctx);
                WarnGroupCollection warnGroupCol = warnGroup.getWarnGroupCollection("order by periority desc");
                WarnGroupInfo wgInfo = null;
                int warnCount = warnGroupCol.size();
                for (int i = 0; i < warnCount; ++i) {
                    wgInfo = warnGroupCol.get(i);
                    if (wgInfo.getPeriority() != 2) continue;
                    warnGroupCol.remove(wgInfo);
                    break;
                }
                IEdgeParam edgeParma = EdgeParamFactory.getLocalInstance(ctx);
                EdgeParamInfo edgeParamInfo = null;
                WarnGroupInfo warnGroupInfo = null;
                rsParam.beforeFirst();
                int warnGroupCount = warnGroupCol.size();
                String formalu = null;
                while (rsParam.next()) {
                    for (int i = 0; i < warnGroupCount; ++i) {
                        warnGroupInfo = warnGroupCol.get(i);
                        edgeParamInfo = edgeParma.getEdgeParamInfo((IObjectPK)new ObjectUuidPK(rsParam.getString("edgeParam.id")));
                        edgeParamMap.put(warnGroupInfo.getName() + edgeParamInfo.getName(), warnGroupInfo.getName() + edgeParamInfo.getName());
                        KPIWarnParamNewInfo warnParamNew = new KPIWarnParamNewInfo();
                        warnParamNew.setEdgeParam(edgeParamInfo);
                        warnParamNew.setWarnGroup(warnGroupInfo);
                        formalu = (String)this.fileMap.get(warnGroupInfo.getName() + edgeParamInfo.getName());
                        warnParamNew.setParamValue(formalu);
                        warnParamNew.setCurrentValue(this.calculateWarnParamCurrentValue(formalu));
                        warnParamNew.setKpi(this.newKpiInfo);
                        this.newKpiInfo.getWarnParam().add(warnParamNew);
                    }
                }
                if (edgeParamMap.size() == this.fileMap.size()) {
                    Iterator edgeParamMapIt = edgeParamMap.keySet().iterator();
                    while (edgeParamMapIt.hasNext()) {
                        Object obj = this.fileMap.get(edgeParamMapIt.next());
                        if (null != obj) continue;
                        return false;
                    }
                    Iterator fileMapIt = this.fileMap.keySet().iterator();
                    while (fileMapIt.hasNext()) {
                        Object obj = edgeParamMap.get(fileMapIt.next());
                        if (null != obj) continue;
                        return false;
                    }
                    if (!this.checkWarnParamValue(hsData)) {
                        throw new TaskExternalException(EASResource.getString((String)RES, (String)"kpivalue_warnparam_error") + ":" + EASResource.getString((String)RES, (String)"warnparam_edge_value_error"));
                    }
                    return true;
                }
                return false;
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"kpivalue_warnparam_error"));
        }
        return false;
    }

    private boolean checkWarnParamValue(Hashtable hsData) throws TaskExternalException {
        EdgeGroupInfo edgeInfo = this.newKpiInfo.getCurrentWarnStatus();
        KPIWarnParamNewCollection cols = this.newKpiInfo.getWarnParam();
        int left = edgeInfo.getFormula().indexOf(">");
        int right = edgeInfo.getFormula().indexOf("<");
        try {
            if (left > -1 && right > -1) {
                this.checkImportValue(hsData, 0);
                BigDecimal warnHigh = cols.get(0).getCurrentValue();
                BigDecimal errorHigh = cols.get(1).getCurrentValue();
                BigDecimal warnLow = cols.get(2).getCurrentValue();
                BigDecimal errorLow = cols.get(3).getCurrentValue();
                if (errorHigh.compareTo(warnHigh) <= 0 || warnHigh.compareTo(warnLow) <= 0 || warnLow.compareTo(errorLow) <= 0) {
                    return false;
                }
            } else if (left > -1 && right == -1) {
                this.checkImportValue(hsData, 1);
                BigDecimal warnHigh = cols.get(0).getCurrentValue();
                BigDecimal errorHigh = cols.get(1).getCurrentValue();
                if (errorHigh.compareTo(warnHigh) <= 0) {
                    return false;
                }
            } else if (left == -1 && right > -1) {
                this.checkImportValue(hsData, 1);
                BigDecimal warnLow = cols.get(0).getCurrentValue();
                BigDecimal errorLow = cols.get(1).getCurrentValue();
                if (warnLow.compareTo(errorLow) <= 0) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"kpivalue_warnparam_error"));
        }
        return true;
    }

    private void checkImportValue(Hashtable hsData, int i) throws TaskExternalException {
        if (i == 0) {
            String wpName1 = hsData.get("warnParam.name1").toString();
            String wpName2 = hsData.get("warnParam.name2").toString();
            String wpName3 = hsData.get("warnParam.name3").toString();
            String wpName4 = hsData.get("warnParam.name4").toString();
            if ("".equals(wpName1) || "".equals(wpName2) || "".equals(wpName3) || "".equals(wpName4)) {
                throw new TaskExternalException(EASResource.getString((String)RES, (String)"kpivalue_warnparam_name_error"));
            }
        } else if (i == 1) {
            String wpName1 = hsData.get("warnParam.name1").toString();
            String wpName2 = hsData.get("warnParam.name2").toString();
            if ("".equals(wpName1) || "".equals(wpName2)) {
                throw new TaskExternalException(EASResource.getString((String)RES, (String)"kpivalue_warnparam_name_error"));
            }
        }
    }

    private StringBuffer convertNameToId(String nameFormula) throws TaskExternalException {
        StringTokenizer st = new StringTokenizer(" " + nameFormula, "$");
        StringBuffer formulaBuffer = new StringBuffer();
        boolean flag = true;
        while (st.hasMoreTokens()) {
            if (flag) {
                formulaBuffer.append(st.nextToken());
            } else {
                Object obj = this.refGroupNameToId.get(st.nextToken());
                if (null != obj) {
                    formulaBuffer.append("$");
                    formulaBuffer.append(obj.toString());
                    formulaBuffer.append("$");
                } else {
                    throw new TaskExternalException(EASResource.getString((String)RES, (String)"standardvalue_error"));
                }
            }
            flag = !flag;
        }
        formulaBuffer = formulaBuffer.deleteCharAt(0);
        return formulaBuffer;
    }

    private BigDecimal calculateWarnParamCurrentValue(String ParamValue) throws TaskExternalException {
        ParamValue = this.convertNameToId(ParamValue).toString();
        return this.execParamValue(ParamValue);
    }

    private BigDecimal execParamValue(String paramValue) throws TaskExternalException {
        paramValue = " " + paramValue;
        StringTokenizer st = new StringTokenizer(paramValue, "$");
        StringBuffer formula = new StringBuffer();
        BigDecimal value = null;
        boolean flag = true;
        while (st.hasMoreTokens()) {
            if (flag) {
                formula.append(st.nextToken());
            } else {
                String refGroupId = st.nextToken();
                KPIRefStandardValueNewCollection cols = this.newKpiInfo.getRefValue();
                Iterator it = cols.iterator();
                while (it.hasNext()) {
                    KPIRefStandardValueNewInfo refValue = (KPIRefStandardValueNewInfo)it.next();
                    if (!refValue.getRefGroup().getId().toString().equalsIgnoreCase(refGroupId)) continue;
                    value = refValue.getCurrentValue();
                }
                if (value != null) {
                    formula.append(value);
                } else {
                    formula.append(0);
                }
            }
            flag = !flag;
        }
        BigDecimal currentValue = null;
        try {
            currentValue = new BigDecimal(ScriptUtil.evalExpr((String)formula.toString(), null).toString());
        }
        catch (Exception e) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"edge_value_error"));
        }
        return currentValue;
    }

    private void init() {
        this.newKpiInfo = new KPIInfo();
        this.fileStdValueMap.clear();
        this.fileMap.clear();
    }
}

