/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.sem.mp.KPIAnalysisReportSetFactory;
import com.kingdee.eas.sem.mp.KPIAnalysisReportSetInfo;
import com.kingdee.eas.sem.mp.app.CompanyForWebTempInfo;
import com.kingdee.eas.sem.mp.app.KPIForWebTempInfo;
import com.kingdee.eas.sem.mp.formulaservice.timeservice.KPITimeHandle;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class KPINewReportHandle {
    Logger logger = Logger.getLogger((String)"KPIReportHandle");
    private static final String NULLMARK = "#########$$$$$$$$$";

    public Map getReportData(Context ctx, KPIForWebTempInfo[] kpis, Date displayDate) {
        long beginDate = System.currentTimeMillis();
        StringBuffer dataTable = new StringBuffer();
        StringBuffer baseSql = null;
        dataTable.append(" ISNULL(t3.fwebcolor,'#000000') as FColor, t1.fisPercent as fispercent, ");
        dataTable.append(" t1.FDisplayPrecision as fdisplayprecision, ");
        dataTable.append(" t2.fkpivalue as fkpivalue,t1.fid as fkpiid,t1.fpartfi from ");
        dataTable.append(" t_mp_kpi t1 ");
        dataTable.append(" inner join t_mp_kpiValue t2 on t1.fid = t2.fkpiid ");
        dataTable.append(" left outer join t_mp_warngroup t3 ");
        dataTable.append(" on t2.fcurrentwarnstatus = t3.fid ");
        dataTable.append(" where ( ");
        baseSql = new StringBuffer();
        Calendar calenar = Calendar.getInstance();
        for (int i = 0; i < kpis.length; ++i) {
            KPIForWebTempInfo kpiWebInfo = kpis[i];
            calenar.clear();
            calenar.setTime(displayDate);
            String timeText = KPITimeHandle.getTimeText(kpiWebInfo.getTimeType(), calenar);
            if (i == 0) {
                baseSql.append(" select t1.fid,t1.FPartFI || '");
            } else {
                baseSql.append(" union select t1.fid,t1.FPartFI || '");
            }
            baseSql.append(kpis[i].getKpiId()).append("' as newId,");
            baseSql.append(dataTable);
            baseSql.append("  t1.fid='").append(kpis[i].getKpiId()).append("'");
            baseSql.append("  or t1.fparentid='").append(kpis[i].getKpiId()).append("'");
            baseSql.append(" ) and t2.ftimeText='").append(timeText).append("'");
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)baseSql.toString());
            if (rowSet != null) {
                HashMap<String, String[]> dataMap = new HashMap<String, String[]>();
                while (rowSet.next()) {
                    String[] datas = new String[]{rowSet.getString("FColor"), rowSet.getString("fkpivalue"), rowSet.getString("fkpiid"), rowSet.getString("fispercent"), rowSet.getString("fdisplayprecision")};
                    dataMap.put(rowSet.getString("newId"), datas);
                }
                return dataMap;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("<<gui cost Time>>:" + (System.currentTimeMillis() - beginDate));
        return null;
    }

    public Map getReportData(Context ctx, KPIForWebTempInfo[] kpis, String timeDimension) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date bPeriod = null;
        try {
            if (timeDimension != null && timeDimension.trim().length() > 0) {
                bPeriod = format.parse(timeDimension);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (bPeriod != null) {
            return this.getReportData(ctx, kpis, bPeriod);
        }
        return null;
    }

    public Map getReportData(Context ctx, String[] kpiLongnumber, String[] kpiIds, String timeDimension) {
        long beginDate = System.currentTimeMillis();
        StringBuffer dataTable = new StringBuffer();
        StringBuffer baseSql = null;
        dataTable.append(" t3.fintcolor as FColor, ");
        dataTable.append(" t2.fkpivalue as fkpivalue,t1.fid as fkpiid,t1.fcompanyid from ");
        dataTable.append(" t_mp_kpi t1 ");
        dataTable.append(" inner join t_mp_kpiValue t2 on t1.fid = t2.fkpiid ");
        dataTable.append(" inner join t_mp_warngroup t3 ");
        dataTable.append(" on t2.fcurrentwarnstatus = t3.fid ");
        dataTable.append(" where ( ");
        baseSql = new StringBuffer();
        for (int i = 0; i < kpiLongnumber.length; ++i) {
            if (i == 0) {
                baseSql.append(" select t1.fid,t1.fcompanyid || '");
            } else {
                baseSql.append(" union select t1.fid,t1.fcompanyid || '");
            }
            baseSql.append(kpiIds[i]).append("' as newId,");
            baseSql.append(dataTable);
            baseSql.append("  t1.flongnumber like '").append(kpiLongnumber[i]).append("%'");
            baseSql.append(" ) and t2.ftimeText='").append(timeDimension).append("'");
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)baseSql.toString());
            if (rowSet != null) {
                HashMap<String, String[]> dataMap = new HashMap<String, String[]>();
                while (rowSet.next()) {
                    String[] datas = new String[]{rowSet.getString("FColor"), rowSet.getString("fkpivalue"), rowSet.getString("fkpiid")};
                    dataMap.put(rowSet.getString("newId"), datas);
                }
                return dataMap;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("<<gui cost Time>>:" + (System.currentTimeMillis() - beginDate));
        return null;
    }

    public KPIForWebTempInfo[] getReportSetRelaKpi(Context ctx, String setId) throws BOSException {
        String loc = this.getLoc(ctx);
        StringBuffer kpiSelect = new StringBuffer();
        kpiSelect.append(" select t2.fid,t2.flongnumber,t2.ftimetype,t2.fname_").append(loc).append(" as fname ");
        kpiSelect.append(" from t_mp_kpianalysisreportofkpi t1 ");
        kpiSelect.append(" inner join t_mp_kpi t2 ");
        kpiSelect.append(" on t1.FKpiID = t2.fid ");
        kpiSelect.append(" where t1.FAnalysisSetID = ?");
        kpiSelect.append(" order by t1.findex ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)kpiSelect.toString(), (Object[])new String[]{setId});
            if (rowSet != null) {
                KPIForWebTempInfo[] kpiInfos = new KPIForWebTempInfo[rowSet.size()];
                int i = 0;
                while (rowSet.next()) {
                    KPIForWebTempInfo tempInfo = new KPIForWebTempInfo();
                    tempInfo.setKpiId(rowSet.getString("fid"));
                    tempInfo.setKpiName(rowSet.getString("fname"));
                    tempInfo.setKpiLongnumber(rowSet.getString("flongnumber"));
                    tempInfo.setTimeType(rowSet.getString("ftimetype"));
                    kpiInfos[i] = tempInfo;
                    ++i;
                }
                return kpiInfos;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public CompanyForWebTempInfo[] getReportSetRelaCompany(Context ctx, String setId) throws BOSException {
        KPIAnalysisReportSetInfo setInfo;
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("*"));
        try {
            setInfo = KPIAnalysisReportSetFactory.getLocalInstance(ctx).getKPIAnalysisReportSetInfo((IObjectPK)new ObjectUuidPK(setId), selectors);
        }
        catch (EASBizException e2) {
            e2.printStackTrace();
            return null;
        }
        boolean displaySimpleName = false;
        if (setInfo == null) {
            return null;
        }
        displaySimpleName = setInfo.isIsDisplayCompanySimpleName();
        OrgRangeCollection tempOrg = null;
        try {
            tempOrg = this.getOrgRange(ctx, ctx.getCaller());
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
        String loc = this.getLoc(ctx);
        String name_loc = "fname_" + loc;
        StringBuffer companySelect = new StringBuffer();
        companySelect.append(" select a.fid,a.fname,a.fsimplename,a.fnumber,a.flongnumber,a.flevel,a.fisleaf, ");
        companySelect.append(" 0 as fisleaf_new from( ");
        if (displaySimpleName) {
            companySelect.append(" select distinct tt2.fid,tt2.").append(name_loc);
            companySelect.append(" as fname,ISNULL(tt2.fsimplename,tt2.").append(name_loc).append(")");
            companySelect.append(" as fsimplename, tt2.fnumber,tt2.flongnumber, ");
        } else {
            companySelect.append(" select distinct tt2.fid,tt2.").append(name_loc);
            companySelect.append(" as fname,tt2.fname_l2 as fsimplename, tt2.fnumber,tt2.flongnumber, ");
        }
        companySelect.append(" tt2.fisleaf,tt2.flevel ");
        companySelect.append(" from T_MP_KPIAnalysisReportCompany tt1 ");
        companySelect.append(" inner join t_org_company tt2 on tt1.fpartfi = tt2.fid ");
        companySelect.append(" where tt1.FAnalysisSetID = ? ");
        if (tempOrg != null && tempOrg.size() > 0) {
            int n = tempOrg.size();
            for (int i = 0; i < n; ++i) {
                if (i == 0) {
                    companySelect.append(" and (");
                    companySelect.append(" tt2.fid='");
                    companySelect.append(tempOrg.get(i).getOrg().getId().toString()).append("'");
                    continue;
                }
                companySelect.append(" or tt2.fid='");
                companySelect.append(tempOrg.get(i).getOrg().getId().toString()).append("'");
            }
            companySelect.append(" ) ");
        }
        companySelect.append(" ) a order by flongnumber asc ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)companySelect.toString(), (Object[])new String[]{setId});
            if (rowSet != null) {
                CompanyForWebTempInfo[] companys = new CompanyForWebTempInfo[rowSet.size()];
                int i = 0;
                int count = 0;
                while (rowSet.next()) {
                    CompanyForWebTempInfo tempInfo = new CompanyForWebTempInfo();
                    tempInfo.setCompanyId(rowSet.getString("fid"));
                    tempInfo.setCompanyName(rowSet.getString("fname"));
                    tempInfo.setCompanySimpleName(rowSet.getString("fsimpleName"));
                    tempInfo.setLevel(rowSet.getInt("flevel"));
                    count = rowSet.getInt("fisleaf_new");
                    if (count == 0) {
                        tempInfo.setLeaf(true);
                    } else {
                        tempInfo.setLeaf(false);
                    }
                    tempInfo.setCompanyLongnumber(rowSet.getString("flongnumber"));
                    tempInfo.setCompanyNumber(rowSet.getString("fnumber"));
                    companys[i] = tempInfo;
                    ++i;
                }
                this.setCurLeafState(companys);
                return companys;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void setCurLeafState(CompanyForWebTempInfo[] companys) {
        StringBuffer longNumberStr = new StringBuffer();
        for (int i = 0; i < companys.length; ++i) {
            longNumberStr.append(companys[i].getCompanyLongnumber()).append("@@@");
        }
        int index = -1;
        for (int i = 0; i < companys.length; ++i) {
            index = longNumberStr.indexOf(companys[i].getCompanyLongnumber());
            if (index <= -1) continue;
            index = longNumberStr.indexOf(companys[i].getCompanyLongnumber(), index + companys[i].getCompanyLongnumber().length());
            if (index > -1) {
                companys[i].setCurLeaf(false);
                continue;
            }
            companys[i].setCurLeaf(true);
        }
    }

    public String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    private OrgRangeCollection getOrgRange(Context ctx, IObjectPK userId) throws EASBizException, BOSException {
        return PermissionRangeHelper.getUserOrgRange((Context)ctx, (IObjectPK)userId, (OrgRangeType)OrgRangeType.BIZ_ORG_TYPE);
    }
}

