/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.sem.mp.AbstractKPIInfo;
import com.kingdee.eas.sem.mp.IKPIAnalysisReportSet;
import com.kingdee.eas.sem.mp.KPIAnalysisReportOfCompanyCollection;
import com.kingdee.eas.sem.mp.KPIAnalysisReportOfCompanyInfo;
import com.kingdee.eas.sem.mp.KPIAnalysisReportOfKPICollection;
import com.kingdee.eas.sem.mp.KPIAnalysisReportOfKPIInfo;
import com.kingdee.eas.sem.mp.KPIAnalysisReportSetFactory;
import com.kingdee.eas.sem.mp.KPIAnalysisReportSetInfo;
import com.kingdee.eas.sem.mp.KPIException;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPITimeTypeEnum;
import com.kingdee.eas.sem.mp.KPIValueCollection;
import com.kingdee.eas.sem.mp.KPIValueInfo;
import com.kingdee.eas.sem.mp.app.AbstractKPIReportFacadeControllerBean;
import com.kingdee.eas.sem.mp.formulaservice.timeservice.KPITimeHandle;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class KPIReportFacadeControllerBean
extends AbstractKPIReportFacadeControllerBean {
    private static final String NULLMARK = "#########$$$$$$$$$";
    private static final long serialVersionUID = -4099856533539911407L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.sem.mp.app.KPIReportFacadeControllerBean");

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        SchemaSource schemaSource = new SchemaSource();
        schemaSource.setCaller(KPIReportFacadeControllerBean.class);
        KPIAnalysisReportSetInfo setInfo = null;
        Object obj = params.getObject("reportConfig");
        if (obj != null) {
            setInfo = this.getReportConfig(ctx, obj.toString());
        }
        schemaSource.setFilename("KPIReportAnalysis_company.xml");
        Object dateObj = params.getObject("TimeDimension");
        Date displayDate = dateObj != null && dateObj instanceof Date ? (Date)dateObj : new Date();
        int displayLevel = 2;
        Object tempLevel = params.getObject("displayLevel");
        if (tempLevel != null && tempLevel instanceof Integer) {
            displayLevel = (Integer)tempLevel;
        }
        StringBuffer mdx = new StringBuffer();
        String loc = KPIReportFacadeControllerBean.getLoc((Context)ctx);
        this.setCompanySql(ctx, schemaSource, loc, setInfo);
        List[] tempList = this.handleKpiType(ctx, schemaSource, loc, setInfo, displayDate);
        List kpiValueList = tempList[0];
        List noValueList = tempList[1];
        String tempTableName = "";
        StringBuffer createSql = new StringBuffer();
        createSql.append(" create table aa");
        createSql.append(" (FId varchar(44) not null primary key,");
        createSql.append("\tFBizID varchar(44),");
        createSql.append(" \tFNumber nvarchar(200),");
        createSql.append("  FCompanyID varchar(44),");
        createSql.append("  FCurrentValue NUMERIC(28,10),");
        createSql.append("  Fcolor NUMERIC(28,0) ,FFormat varchar(100) ) ");
        TempTablePool tempPool = TempTablePool.getInstance((Context)ctx);
        try {
            tempTableName = tempPool.createTempTable(createSql.toString());
        }
        catch (Exception e) {
            logger.info((Object)"create temptable error!");
            e.printStackTrace();
        }
        this.setTempTable(ctx, tempTableName, schemaSource, loc, kpiValueList, noValueList, displayDate);
        StringBuffer sqlKPI = new StringBuffer();
        sqlKPI.append(" select ");
        sqlKPI.append("\tFBizID,FID,FNumber,FCompanyID,");
        sqlKPI.append(" FCurrentValue,FColor,FFormat ");
        sqlKPI.append(" from ");
        sqlKPI.append(tempTableName);
        schemaSource.setDataItem("Fact", sqlKPI.toString(), null);
        mdx.append(" select { [KpiType].members }");
        mdx.append(" on columns,");
        mdx.append(" filter([Company].members,Company.currentmember.level.ordinal<").append(displayLevel).append(") on rows ");
        mdx.append(" from Fact where Measures.[FCurrentValue]");
        schemaSource.setMdx(mdx.toString());
        return schemaSource;
    }

    private void setCompanySql(Context ctx, SchemaSource schemaSource, String loc, KPIAnalysisReportSetInfo setInfo) throws KPIException {
        StringBuffer sqlCompany = new StringBuffer();
        if (setInfo.isIsDisplayCompanySimpleName()) {
            sqlCompany.append(" select FID,ISNULL(FSimpleName,FName_").append(loc).append(")");
        } else {
            sqlCompany.append(" select FID,FName_" + loc);
        }
        sqlCompany.append(" as FName , flongnumber,FParentID from t_org_company");
        if (setInfo == null) {
            sqlCompany.append(" where fid = '#########$$$$$$$$$' ");
        } else {
            HashSet<String> companyIDSet = new HashSet<String>();
            HashSet<String> reportCompanySet = new HashSet<String>();
            HashSet<String> userCompanySet = new HashSet<String>();
            KPIAnalysisReportOfCompanyCollection companyCols = setInfo.getOfCompany();
            if (companyCols != null && companyCols.size() > 0) {
                Iterator iteCompany = companyCols.iterator();
                while (iteCompany.hasNext()) {
                    KPIAnalysisReportOfCompanyInfo tempOfCompanyInfo = (KPIAnalysisReportOfCompanyInfo)iteCompany.next();
                    if (tempOfCompanyInfo.getPartFI() == null) {
                        throw new KPIException(KPIException.COMPANY_IS_NULL);
                    }
                    reportCompanySet.add(tempOfCompanyInfo.getPartFI().getId().toString());
                }
            }
            FullOrgUnitCollection userOrgCol = null;
            try {
                userOrgCol = this.getUserOrgCol(ctx, ctx.getCaller());
            }
            catch (Exception e) {
                logger.info((Object)" getUserOrgCol error!");
                e.printStackTrace();
            }
            if (userOrgCol != null && userOrgCol.size() > 0) {
                int n = userOrgCol.size();
                for (int i = 0; i < n; ++i) {
                    userCompanySet.add(userOrgCol.get(i).getId().toString());
                }
            }
            if (reportCompanySet.size() <= 0 || userCompanySet.size() <= 0) {
                sqlCompany.append(" where fid = '#########$$$$$$$$$' ");
            } else {
                for (Object e : reportCompanySet) {
                    String companyId;
                    if (e == null || !userCompanySet.contains(companyId = e.toString())) continue;
                    companyIDSet.add(companyId);
                }
                if (companyIDSet.size() > 0) {
                    sqlCompany.append(" where  ");
                    Iterator ite = companyIDSet.iterator();
                    int i = 0;
                    while (ite.hasNext()) {
                        if (i == 0) {
                            sqlCompany.append(" fid='");
                            sqlCompany.append(ite.next().toString());
                            sqlCompany.append("' ");
                        } else {
                            sqlCompany.append(" or fid='");
                            sqlCompany.append(ite.next().toString());
                            sqlCompany.append("' ");
                        }
                        ++i;
                    }
                } else {
                    sqlCompany.append(" where fid = '#########$$$$$$$$$' ");
                }
            }
        }
        schemaSource.setDataItem("Company", sqlCompany.toString(), null);
    }

    private void setTempTable(Context ctx, String tempTableName, SchemaSource schemaSource, String loc, List kpiValues, List noValueList1, Date displayDate) throws BOSException {
        StringBuffer tempSql = new StringBuffer();
        Iterator ite = kpiValues.iterator();
        int i = 0;
        Calendar calenar = Calendar.getInstance();
        while (ite.hasNext()) {
            KPIValueInfo kpiValueInfo = (KPIValueInfo)ite.next();
            KPIInfo kpiInfo = kpiValueInfo.getKpi();
            calenar.clear();
            calenar.setTime(displayDate);
            String timeText = KPITimeHandle.getTimeText(kpiInfo.getTimeType(), calenar);
            if (i == 0) {
                tempSql.append(" insert into ").append(tempTableName);
            }
            if (i > 0) {
                tempSql.append(" union ");
            }
            tempSql.append(" select t1.FID,'");
            tempSql.append(kpiValueInfo.getId().toString());
            tempSql.append("' as FBizID,t0.FNumber,t0.FPartfi,");
            tempSql.append("t1.Fkpivalue,ISNULL(t2.fintcolor,0) as FColor");
            tempSql.append(",'").append(this.getFormatString(kpiInfo.isIsPercent(), kpiInfo.getDisplayPrecision())).append("' ");
            tempSql.append(" from t_mp_kpi t0");
            tempSql.append(" inner join t_mp_kpivalue t1 ");
            tempSql.append(" on t0.fid = t1.fkpiid ");
            tempSql.append(" left outer join t_mp_warngroup t2 ");
            tempSql.append(" on t1.fcurrentwarnstatus = t2.fid ");
            tempSql.append(" where  (t0.fid ='").append(kpiInfo.getId().toString()).append("' ");
            tempSql.append(" or t0.fparentid='").append(kpiInfo.getId().toString()).append("') ");
            tempSql.append(" and t1.ftimetext ='").append(timeText).append("'");
            ++i;
        }
        if (tempSql.length() > 0) {
            DbUtil.execute((Context)ctx, (String)tempSql.toString());
        }
    }

    private List[] handleKpiType(Context ctx, SchemaSource schemaSource, String loc, KPIAnalysisReportSetInfo setInfo, Date displayDate) throws BOSException {
        ArrayList<KPIValueInfo> kpiValueList = new ArrayList<KPIValueInfo>();
        ArrayList list = new ArrayList();
        ArrayList<KPIInfo> kpiList = new ArrayList<KPIInfo>();
        StringBuffer sqlKpiType = new StringBuffer();
        sqlKpiType.append(" select t1.FID as FID,t2.fnumber as fnumber,");
        sqlKpiType.append("t2.fname_");
        sqlKpiType.append(loc);
        sqlKpiType.append(" as FName,t3.FIndex as findex,fispercent as fpercent,FDISPLAYPRECISION as fdisprecision from t_mp_kpivalue t1 ");
        sqlKpiType.append(" inner join t_mp_kpi t2 on t1.fkpiid = t2.fid ");
        sqlKpiType.append(" inner join T_MP_KPIAnalysisReportOfKPI t3 on t3.FKpiID = t2.fid ");
        StringBuffer whereSql = new StringBuffer();
        if (setInfo == null) {
            sqlKpiType.append(" where t1.fid = '#########$$$$$$$$$' ");
        } else {
            KPIAnalysisReportOfKPICollection ofKpiCols = setInfo.getOfKPI();
            if (ofKpiCols != null && ofKpiCols.size() > 0) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("*");
                selector.add("kpiValue.*");
                AbstractKPIInfo tempKpiInfo = null;
                Iterator ite = ofKpiCols.iterator();
                KPIValueCollection kpiValueCols = null;
                Calendar calendar = Calendar.getInstance();
                boolean isFirst = true;
                while (ite.hasNext()) {
                    KPIAnalysisReportOfKPIInfo ofKpiInfo = (KPIAnalysisReportOfKPIInfo)ite.next();
                    KPIInfo kpiInfo = ofKpiInfo.getKpi();
                    calendar.clear();
                    calendar.setTime(displayDate);
                    String timeDimension = KPITimeHandle.getTimeText(kpiInfo.getTimeType(), calendar);
                    kpiList.add(kpiInfo);
                    try {
                        tempKpiInfo = KPIFactory.getLocalInstance(ctx).getKPIInfo((IObjectPK)new ObjectUuidPK(kpiInfo.getId().toString()), selector);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (tempKpiInfo != null) {
                        kpiValueCols = tempKpiInfo.getKpiValue();
                    }
                    if (kpiValueCols == null || kpiValueCols.size() <= 0) continue;
                    KPIValueInfo tempValueInfo = this.getKpiValueInfo(kpiValueCols, timeDimension);
                    if (tempValueInfo == null) {
                        tempValueInfo = kpiValueCols.get(0);
                    }
                    tempValueInfo.setKpi((KPIInfo)tempKpiInfo);
                    kpiValueList.add(tempValueInfo);
                    if (isFirst) {
                        whereSql.append(" t1.fid = '");
                        isFirst = false;
                    } else {
                        whereSql.append(" or t1.fid = '");
                    }
                    whereSql.append(tempValueInfo.getId().toString());
                    whereSql.append("' ");
                }
                if (whereSql.length() <= 0) {
                    sqlKpiType.append(" where  t1.fid = '#########$$$$$$$$$' ");
                } else {
                    sqlKpiType.append(" where t3.fanalysissetid='").append(setInfo.getId().toString()).append("' and ( ");
                    sqlKpiType.append(whereSql);
                    sqlKpiType.append(" ) ");
                }
            } else {
                sqlKpiType.append(" where t1.fid = '#########$$$$$$$$$' ");
            }
        }
        int n = list.size();
        if (n > 0) {
            StringBuffer sqlKpiType1 = new StringBuffer();
            sqlKpiType1.append(" select  t1.FID as fid,t1.fnumber as fnumber,t1.fname_");
            sqlKpiType1.append(loc);
            sqlKpiType1.append(" as FName,t2.FIndex as findex ,fispercent as fpercent,FDISPLAYPRECISION as fdisprecision from t_mp_kpi t1");
            sqlKpiType1.append(" inner join T_MP_KPIAnalysisReportOfKPI t2 on t1.fid = t2.fkpiid ");
            sqlKpiType1.append(" where t2.fanalysissetid='").append(setInfo.getId().toString()).append("' and (");
            for (int i = 0; i < n; ++i) {
                KPIInfo tempKpiInfo = (KPIInfo)list.get(i);
                if (i == 0) {
                    sqlKpiType1.append(" t1.fid='");
                } else {
                    sqlKpiType1.append(" or t1.fid='");
                }
                sqlKpiType1.append(tempKpiInfo.getId().toString());
                sqlKpiType1.append("'");
            }
            sqlKpiType1.append(" ) ");
            sqlKpiType.append(" union ");
            sqlKpiType.append(sqlKpiType1);
        }
        schemaSource.setDataItem("KpiType", sqlKpiType.toString(), null);
        List[] newList = new List[]{kpiValueList, list};
        return newList;
    }

    private KPIAnalysisReportSetInfo getReportConfig(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("ofCompany.partfi.*"));
        sic.add(new SelectorItemInfo("ofKPI.kpi.*"));
        sic.add(new SelectorItemInfo("ofKPI.kpi.kpiValue.fid"));
        sic.add(new SelectorItemInfo("ofKPI.kpi.kpiValue.flongnumber"));
        IKPIAnalysisReportSet iSet = KPIAnalysisReportSetFactory.getLocalInstance(ctx);
        KPIAnalysisReportSetInfo tempInfo = iSet.getKPIAnalysisReportSetInfo((IObjectPK)new ObjectUuidPK(id), sic);
        return tempInfo;
    }

    private KPIValueInfo getKpiValueInfo(KPIValueCollection cols, String timeDimension) {
        KPIValueInfo valueInfo = null;
        int n = cols.size();
        for (int i = 0; i < n; ++i) {
            valueInfo = cols.get(i);
            if (!timeDimension.equals(valueInfo.getTimeText())) continue;
            return valueInfo;
        }
        return null;
    }

    protected KPITimeTypeEnum _getReportType(Context ctx, String reportSetId) throws BOSException, EASBizException {
        KPIAnalysisReportSetInfo setInfo = KPIAnalysisReportSetFactory.getLocalInstance(ctx).getKPIAnalysisReportSetInfo((IObjectPK)new ObjectUuidPK(reportSetId));
        if (setInfo != null) {
            return setInfo.getReportType();
        }
        return null;
    }

    private FullOrgUnitCollection getUserOrgCol(Context ctx, IObjectPK userId) throws EASBizException, BOSException {
        return PermissionRangeHelper.getUserOrgCol((Context)ctx, (IObjectPK)userId, (OrgRangeType)OrgRangeType.BIZ_ORG_TYPE);
    }

    private String getFormatString(boolean isPercent, int displayPrecision) {
        String formatString = "#,##0.00";
        if (isPercent) {
            formatString = "#,##0.00%";
        }
        return formatString;
    }
}

