/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.sem.mp.IKPIAnalysisReportSet;
import com.kingdee.eas.sem.mp.KPIAnalysisReportOfCompanyCollection;
import com.kingdee.eas.sem.mp.KPIAnalysisReportOfCompanyInfo;
import com.kingdee.eas.sem.mp.KPIAnalysisReportOfKPICollection;
import com.kingdee.eas.sem.mp.KPIAnalysisReportOfKPIInfo;
import com.kingdee.eas.sem.mp.KPIAnalysisReportSetFactory;
import com.kingdee.eas.sem.mp.KPIAnalysisReportSetInfo;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class KPIReportHandle {
    Logger logger = Logger.getLogger((String)"KPIReportHandle");
    private static final String NULLMARK = "#########$$$$$$$$$";

    public IRowSet getKPIReportData(Context ctx, String setInfoId, String timeDemision) throws BOSException {
        if (setInfoId == null) {
            return null;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("ofCompany.company.id"));
        selector.add(new SelectorItemInfo("ofKPI.kpi.id"));
        selector.add(new SelectorItemInfo("ofKPI.kpi.number"));
        selector.add(new SelectorItemInfo("ofKPI.kpi.longnumber"));
        IKPIAnalysisReportSet iSet = KPIAnalysisReportSetFactory.getLocalInstance(ctx);
        try {
            KPIAnalysisReportSetInfo setInfo = iSet.getKPIAnalysisReportSetInfo((IObjectPK)new ObjectUuidPK(setInfoId), selector);
            return this.getKPIReportData(ctx, setInfo, timeDemision);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public IRowSet getKPIReportData(Context ctx, KPIAnalysisReportSetInfo setInfo, String timeDemision) throws BOSException {
        String loc = this.getLoc(ctx);
        String sql = this.getKPIReportSelect(setInfo, timeDemision, loc);
        if (sql == null) {
            return null;
        }
        this.logger.info((Object)("***********************" + sql));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        return rowSet;
    }

    private String getKPIReportSelect(KPIAnalysisReportSetInfo setInfo, String timeDemision, String loc) {
        StringBuffer selectData = new StringBuffer();
        StringBuffer companySql = this.getCompanySql(loc, setInfo);
        KPIAnalysisReportOfKPICollection ofKpiCols = setInfo.getOfKPI();
        if (ofKpiCols == null || ofKpiCols.size() <= 0) {
            return null;
        }
        int n = ofKpiCols.size();
        for (int i = 0; i < n && i != 1; ++i) {
            KPIAnalysisReportOfKPIInfo ofKpiInfo = ofKpiCols.get(i);
            KPIInfo kpiInfo = ofKpiInfo.getKpi();
            StringBuffer kpiSql = this.getKPIType(kpiInfo.getLongNumber(), timeDemision, loc);
            if (i == 0) {
                selectData.append(" select tt1.fid as companyid,tt1.fname as companyname,");
                selectData.append(" tt1.flongnumber as companylongnumber,");
                selectData.append(" tt1.flevel as level,tt1.fnumber as companyNumber,");
                selectData.append(" tt1.fisleaf as isleaf, ");
                selectData.append(" tt2.fcolor as color,tt2.fname as name,tt2.flongnumber as kpilongnumber, ");
                selectData.append(" tt2.fkpivalue as kpivalue,tt2.fkpiid as kpiid,tt2.fkpivalueid as kpivalueid ");
                selectData.append(" from (").append(companySql).append(" ) tt1 ");
                selectData.append(" left join ( ").append(kpiSql).append(" ) tt2 ");
                selectData.append(" on tt1.fid=tt2.fcompanyid ");
                continue;
            }
            selectData.append(" union ");
            selectData.append(" select tt1.fid as companyid,tt1.fname as companyname,");
            selectData.append(" tt1.flongnumber as companylongnumber,");
            selectData.append(" tt1.flevel as level,tt1.fnumber as companyNumber,");
            selectData.append(" tt1.fisleaf as isleaf, ");
            selectData.append(" tt2.fcolor as color,tt2.fname as name,tt2.flongnumber as kpilongnumber, ");
            selectData.append(" tt2.fkpivalue as kpivalue,tt2.fkpiid as kpiid,tt2.fkpivalueid as kpivalueid ");
            selectData.append(" from (").append(companySql).append(" ) tt1 ");
            selectData.append(" left join ( ").append(kpiSql).append(" ) tt2 ");
            selectData.append(" on tt1.fid=tt2.fcompanyid ");
        }
        StringBuffer lastSql = new StringBuffer();
        lastSql.append(" select z0.companyid,z0.companyname,");
        lastSql.append(" z0.companylongnumber,");
        lastSql.append(" z0.level,z0.companyNumber,");
        lastSql.append(" z0.isleaf, ");
        lastSql.append(" z0.color,z0.name, z0.kpilongnumber, ");
        lastSql.append(" z0.kpivalue,z0.kpiid,z0.kpivalueid ");
        lastSql.append("  from ( ").append(selectData).append(" ) z0 ");
        lastSql.append("  order by z0.companylongnumber asc,z0.kpilongnumber ");
        return lastSql.toString();
    }

    private StringBuffer getKPIType(String kpiLongnumber, String timeDemision, String loc) {
        StringBuffer dataTable = new StringBuffer();
        dataTable.append(" select t3.fintcolor as FColor, ");
        dataTable.append(" t2.fkpivalue as fkpivalue,t1.fid as fkpiid,t1.fcompanyid from ");
        dataTable.append(" t_mp_kpi t1 ");
        dataTable.append(" inner join t_mp_kpiValue t2 on t1.fid = t2.fkpiid ");
        dataTable.append(" inner join t_mp_warngroup t3 ");
        dataTable.append(" on t2.fcurrentwarnstatus = t3.fid ");
        dataTable.append(" where t1.flongnumber like '").append(kpiLongnumber).append("%' ");
        dataTable.append(" and t2.ftimeText='").append(timeDemision).append("' ");
        return dataTable;
    }

    private StringBuffer getCompanySql(String loc, KPIAnalysisReportSetInfo setInfo) {
        if (setInfo == null) {
            return null;
        }
        StringBuffer sqlCompany = null;
        KPIAnalysisReportOfCompanyCollection companyCols = setInfo.getOfCompany();
        ArrayList<AdminOrgUnitInfo> companyList = new ArrayList<AdminOrgUnitInfo>();
        if (companyCols != null && companyCols.size() > 0) {
            Iterator iteCompany = companyCols.iterator();
            while (iteCompany.hasNext()) {
                KPIAnalysisReportOfCompanyInfo tempOfCompanyInfo = (KPIAnalysisReportOfCompanyInfo)iteCompany.next();
                companyList.add(tempOfCompanyInfo.getCompany());
            }
        }
        if (companyList.size() > 0) {
            sqlCompany = new StringBuffer();
            sqlCompany.append(" select fid ,flongnumber from t_org_company ");
            sqlCompany.append(" where ");
            Iterator ite = companyList.iterator();
            int i = 0;
            while (ite.hasNext()) {
                AdminOrgUnitInfo ouInfo = (AdminOrgUnitInfo)ite.next();
                if (i == 0) {
                    sqlCompany.append(" fid='");
                    sqlCompany.append(ouInfo.getId().toString());
                    sqlCompany.append("' ");
                } else {
                    sqlCompany.append(" or fid='");
                    sqlCompany.append(ouInfo.getId().toString());
                    sqlCompany.append("' ");
                }
                ++i;
            }
        }
        return sqlCompany;
    }

    public String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    public IRowSet[] getReportData(Context ctx, KPIAnalysisReportSetInfo setInfo, String timeText) throws BOSException {
        String loc = "l2";
        StringBuffer companySql = this.getCompanySql(loc, setInfo);
        if (companySql == null) {
            this.logger.info((Object)" The KPIAnalysisReportSetInfo is null!");
            return null;
        }
        KPIAnalysisReportOfKPICollection ofKpiCols = setInfo.getOfKPI();
        if (ofKpiCols == null || ofKpiCols.size() <= 0) {
            return null;
        }
        StringBuffer selectData = new StringBuffer();
        IRowSet[] rowSets = new IRowSet[ofKpiCols.size()];
        long beginDate = System.currentTimeMillis();
        int n = ofKpiCols.size();
        for (int i = 0; i < n; ++i) {
            IRowSet rowSet;
            KPIAnalysisReportOfKPIInfo ofKpiInfo = ofKpiCols.get(i);
            KPIInfo kpiInfo = ofKpiInfo.getKpi();
            StringBuffer kpiSql = this.getKPIType(kpiInfo.getLongNumber(), timeText, loc);
            selectData.append(" select ");
            selectData.append(" tt2.fcolor as color, ");
            selectData.append(" tt2.fkpivalue as kpivalue,tt2.fkpiid as kpiid ");
            selectData.append(" from (").append(companySql).append(" ) tt1 ");
            selectData.append(" left join ( ").append(kpiSql).append(" ) tt2 ");
            selectData.append(" on tt1.fid=tt2.fcompanyid  ");
            selectData.append(" order by tt1.flongnumber asc ");
            rowSets[i] = rowSet = DbUtil.executeQuery((Context)ctx, (String)selectData.toString());
        }
        System.out.println("<<gui cost Time>>:" + (System.currentTimeMillis() - beginDate));
        return rowSets;
    }
}

