/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.sem.mp.IKPIRefStandardValueNew;
import com.kingdee.eas.sem.mp.IKPIWarnParamNew;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewCollection;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewFactory;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewInfo;
import com.kingdee.eas.sem.mp.KPIWarnParamNewCollection;
import com.kingdee.eas.sem.mp.KPIWarnParamNewFactory;
import com.kingdee.eas.sem.mp.KPIWarnParamNewInfo;
import com.kingdee.eas.sem.mp.app.KPIHandle;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Hashtable;
import java.util.Iterator;

public class KPITransmission
extends AbstractDataTransmission {
    private KPIHandle kpiHandle = new KPIHandle();
    protected static final String RES = "com.kingdee.eas.sem.mp.app.KPIAppResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return KPIFactory.getLocalInstance(ctx);
        }
        catch (Exception e) {
            throw new TaskExternalException("BOSException: KPITransmission getLocalInstance", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        return this.kpiHandle.transmitMini(hsData, ctx, this.isSltImportUpdate());
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        super.submit(coreBaseInfo, ctx);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            String kpiID = rs.getString("id");
            result.put("number", rs.getString("number"));
            result.put("name", rs.getString("name"));
            result.put("timeType", rs.getString("timeType"));
            result.put("csf", KPITransmission.nullToString(rs.getString("csf.name")));
            result.put("bsc", KPITransmission.nullToString(rs.getString("bsc.name")));
            result.put("currentWarnStatus", rs.getString("currentWarnStatus.name"));
            result.put("numberUnit", KPITransmission.nullToString(rs.getString("numberUnit")));
            result.put("isWarnable", new Boolean(rs.getBoolean("isWarnable")));
            result.put("formula", KPITransmission.nullToString(rs.getString("formula")));
            result.put("isModifiable", new Boolean(rs.getBoolean("isModifiable")));
            result.put("atomFormula", new Boolean(rs.getBoolean("isAtomFormula")));
            result.put("isPercent", new Boolean(rs.getBoolean("isPercent")));
            result.put("displayPrecision", new Integer(rs.getInt("displayPrecision")));
            result.put("isUnpassedVoucherIncluded", new Boolean(rs.getBoolean("isUnpassedVoucherIncluded")));
            result.put("isDetailItemBalance", new Boolean(rs.getBoolean("isDetailItemBalanceInclude")));
            result.put("isSubItemBalance", new Boolean(rs.getBoolean("isSubItemBalanceInclude")));
            result.put("description", KPITransmission.nullToString(rs.getString("description")));
            result.put("company.number", rs.getString("partFI.number"));
            result.put("company.name", rs.getString("partFI.name"));
            this.setStandardValueColumn(kpiID, result, ctx);
            this.setWarnParamColumn(kpiID, result, ctx);
        }
        catch (Exception e) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"kpi_exportTransmit_error") + e.toString());
        }
        return result;
    }

    private void setWarnParamColumn(String kpiID, Hashtable result, Context ctx) throws TaskExternalException {
        EntityViewInfo vi = new EntityViewInfo();
        vi.getSelector().add(new SelectorItemInfo("*"));
        vi.getSelector().add(new SelectorItemInfo("warnGroup.*"));
        vi.getSelector().add(new SelectorItemInfo("edgeParam.*"));
        FilterInfo filter = new FilterInfo();
        vi.getSorter().add(new SorterItemInfo("warnGroup.name"));
        vi.getSorter().add(new SorterItemInfo("edgeParam.name"));
        filter.getFilterItems().add(new FilterItemInfo("kpi", (Object)kpiID));
        vi.setFilter(filter);
        KPIWarnParamNewCollection cols = null;
        try {
            IKPIWarnParamNew warnParam = KPIWarnParamNewFactory.getLocalInstance(ctx);
            cols = warnParam.getKPIWarnParamNewCollection(vi);
            Iterator it = cols.iterator();
            int i = 1;
            while (it.hasNext()) {
                KPIWarnParamNewInfo info = (KPIWarnParamNewInfo)it.next();
                result.put("warnParam.name" + i, KPITransmission.nullToString(info.getWarnGroup().getName() + info.getEdgeParam().getName()));
                result.put("warnParam.value" + i, KPITransmission.nullToString(info.getParamValue()));
                ++i;
            }
        }
        catch (Exception e) {
            throw new TaskExternalException("setStandardValueColumn exception " + e.toString());
        }
    }

    private void setStandardValueColumn(String kpiID, Hashtable result, Context ctx) throws TaskExternalException {
        EntityViewInfo vi = new EntityViewInfo();
        vi.getSelector().add(new SelectorItemInfo("*"));
        vi.getSelector().add(new SelectorItemInfo("refGroup.*"));
        vi.getSelector().add(new SelectorItemInfo("refGroup.name"));
        FilterInfo filter = new FilterInfo();
        vi.getSorter().add(new SorterItemInfo("refGroup.name"));
        filter.getFilterItems().add(new FilterItemInfo("kpi", (Object)kpiID));
        vi.setFilter(filter);
        KPIRefStandardValueNewCollection cols = null;
        try {
            IKPIRefStandardValueNew refValueNew = KPIRefStandardValueNewFactory.getLocalInstance(ctx);
            cols = refValueNew.getKPIRefStandardValueNewCollection(vi);
            Iterator it = cols.iterator();
            int i = 1;
            while (it.hasNext()) {
                KPIRefStandardValueNewInfo info = (KPIRefStandardValueNewInfo)it.next();
                result.put("stdValue.name" + i, info.getRefGroup().getName());
                result.put("stdValue.value" + i, KPITransmission.nullToString(info.getRefValue()));
                ++i;
            }
        }
        catch (Exception e) {
            throw new TaskExternalException("setStandardValueColumn exception " + e.toString());
        }
    }

    private static Object nullToString(Object value) {
        if (null != value) {
            return value;
        }
        return "";
    }
}

