/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.base.myeas.PersonalParamFactory;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.sem.mp.CSFFactory;
import com.kingdee.eas.sem.mp.CSFInfo;
import com.kingdee.eas.sem.mp.EdgeGroupFactory;
import com.kingdee.eas.sem.mp.EdgeGroupInfo;
import com.kingdee.eas.sem.mp.IRefGroup;
import com.kingdee.eas.sem.mp.IWarnGroup;
import com.kingdee.eas.sem.mp.KPIFacadeFactory;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.RefGroupFactory;
import com.kingdee.eas.sem.mp.WarnGroupFactory;
import com.kingdee.eas.sem.mp.app.AbstractKPITreeListNewUIHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Map;

public class KPITreeListNewUIHandler
extends AbstractKPITreeListNewUIHandler {
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
    }

    private void getKPIInfo(String kpiId, Context context) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("parent.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)kpiId));
        evi.setFilter(filter);
        KPIFactory.getLocalInstance(context).getKPICollection(evi);
    }

    protected void _handleActionImport(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionEnable(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionDisable(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionAutoCalculate(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionAssign(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionEdit(RequestContext request, ResponseContext response, Context context) throws Exception {
        String kpiId = request.getId();
        if (null != kpiId) {
            super._handleActionEdit(request, response, context);
            this.prepareEdit(kpiId, request, context);
        }
    }

    protected void _handleActionView(RequestContext request, ResponseContext response, Context context) throws Exception {
        String kpiId = request.getId();
        if (null != kpiId) {
            super._handleActionView(request, response, context);
            this.prepareEdit(kpiId, request, context);
        }
    }

    protected void _handleActionAddNew(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionAddNew(request, response, context);
        this.prepareAddNew(request, context);
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isModifiable"));
        sic.add(new SelectorItemInfo("isWarnable"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("partFI.*"));
        sic.add(new SelectorItemInfo("measureUnit.*"));
        sic.add(new SelectorItemInfo("csf.*"));
        sic.add(new SelectorItemInfo("csf.BSC.name"));
        sic.add(new SelectorItemInfo("isAtomFormula"));
        sic.add(new SelectorItemInfo("numberUnit"));
        sic.add(new SelectorItemInfo("currentWarnStatus.*"));
        sic.add(new SelectorItemInfo("warnParam.edgeParam.name"));
        sic.add(new SelectorItemInfo("warnParam.warnGroup.name"));
        sic.add(new SelectorItemInfo("warnParam.paramValue"));
        sic.add(new SelectorItemInfo("formula"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("timeType"));
        sic.add(new SelectorItemInfo("refValue.id"));
        sic.add(new SelectorItemInfo("refValue.kpi.id"));
        sic.add(new SelectorItemInfo("refValue.refGroup.name"));
        sic.add(new SelectorItemInfo("refValue.refValue"));
        sic.add(new SelectorItemInfo("refValue.currentValue"));
        sic.add(new SelectorItemInfo("isPercent"));
        sic.add(new SelectorItemInfo("displayPrecision"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("isUnpassedVoucherIncluded"));
        sic.add(new SelectorItemInfo("isDetailItemBalanceInclude"));
        sic.add(new SelectorItemInfo("isSubItemBalanceInclude"));
        sic.add(new SelectorItemInfo("formula"));
        sic.add(new SelectorItemInfo("CSF.BSC.*"));
        sic.add(new SelectorItemInfo("parent.isModifiable"));
        sic.add(new SelectorItemInfo("refValue.refGroup.number"));
        return sic;
    }

    private void prepareAddNew(RequestContext request, Context context) {
        try {
            Object obj = request.get("companyId");
            String userId = (String)request.get("userId");
            if (null != obj) {
                String companyId = (String)obj;
                this.initCompany(companyId, context);
                this.initRefGroup(companyId, context);
                this.initWarnParam(context);
                KPIInfo kpiInfo = this.setDefaultValue(obj.toString(), context);
                if (null != kpiInfo) {
                    this.initKpiInfoDetail(kpiInfo, context);
                }
                this.initCu(userId, context);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prepareEdit(String kpiId, RequestContext request, Context context) throws Exception {
        KPIInfo kpiInfo = (KPIInfo)KPIFactory.getLocalInstance(context).getValue((IObjectPK)new ObjectUuidPK(kpiId), this.getSelectors());
        try {
            if (null == kpiInfo.getPartFI()) return;
            String userId = (String)request.get("userId");
            String operate = (String)request.get("operate");
            String companyId = kpiInfo.getPartFI().getId().toString();
            this.initCompany(companyId, context);
            this.initRefGroup(companyId, context);
            this.initWarnParam(context);
            this.initKpiInfoDetail(kpiInfo, context);
            this.initCu(userId, context);
            if (null != operate && !operate.equals("EDIT")) return;
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private KPIInfo setDefaultValue(String orgId, Context context) {
        KPIInfo kpiInfo = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SorterItemInfo sortInfo1 = new SorterItemInfo("number");
        sortInfo1.setSortType(SortType.DESCEND);
        SorterItemInfo sortInfo = new SorterItemInfo("createTime");
        sortInfo.setSortType(SortType.DESCEND);
        evi.getSorter().add(sortInfo1);
        evi.getSorter().add(sortInfo);
        filter.getFilterItems().add(new FilterItemInfo("partFI.id", (Object)orgId));
        evi.setFilter(filter);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.sem.mp.app.KPINewQuery"));
        exec.setObjectView(evi);
        IRowSet rowSet = null;
        SelectorItemCollection selector = null;
        CSFInfo csfInfo = null;
        EdgeGroupInfo groupInfo = null;
        try {
            Map execMap = exec.doAllQueryTask(exec.openQuery(), 0, 2, null, true);
            rowSet = (IRowSet)execMap.get("rowSet");
            if (rowSet.next()) {
                kpiInfo = new KPIInfo();
                selector = new SelectorItemCollection();
                selector.add("BSC.name");
                selector.add("BSC.id");
                selector.add("*");
                csfInfo = (CSFInfo)CSFFactory.getLocalInstance(context).getValue((IObjectPK)new ObjectUuidPK(rowSet.getString("CSF.ID")), selector);
                kpiInfo.setCsf(csfInfo);
                groupInfo = (EdgeGroupInfo)EdgeGroupFactory.getLocalInstance(context).getValue((IObjectPK)new ObjectUuidPK(rowSet.getString("CURRENTWARNSTATUS.ID")));
                kpiInfo.setCurrentWarnStatus(groupInfo);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return kpiInfo;
    }

    private void initCompany(String companyId, Context context) throws Exception {
        CompanyOrgUnitFactory.getLocalInstance((Context)context).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
    }

    private void initRefGroup(String companyId, Context context) throws Exception {
        IRefGroup iRefGroup = RefGroupFactory.getLocalInstance(context);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("partFI.id", (Object)companyId));
        evi.setFilter(filter);
        iRefGroup.getRefGroupCollection(evi);
    }

    private void initWarnParam(Context context) throws Exception {
        IWarnGroup warnGroup = WarnGroupFactory.getLocalInstance(context);
        warnGroup.getWarnGroupCollection("order by periority desc");
    }

    private void initKpiInfoDetail(KPIInfo kpiInfo, Context context) throws Exception {
        if (null != kpiInfo.getCurrentWarnStatus()) {
            KPIFacadeFactory.getLocalInstance(context).getWarnParam(kpiInfo.getCurrentWarnStatus().getId().toString());
        }
        if (null != kpiInfo.getCsf()) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("BSC.name");
            CSFFactory.getLocalInstance(context).getCSFInfo((IObjectPK)new ObjectUuidPK(kpiInfo.getCsf().getId().toString()), selector);
        }
    }

    private void initCu(String userId, Context context) throws Exception {
        PersonalParamFactory.getLocalInstance((Context)context).getPersonalParamCollection("where user.id='" + userId + "'");
    }

    private void mutexServiceControl(String kpiId, Context context) throws Exception {
        MutexServiceControlFactory.getLocalInstance((Context)context).releaseObjIDForUpdate(kpiId);
        MutexServiceControlFactory.getLocalInstance((Context)context).requestObjIDForUpdate(kpiId);
    }
}

