/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.sem.mp.IKPIValue;
import com.kingdee.eas.sem.mp.KPIFacadeFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPITimeTypeEnum;
import com.kingdee.eas.sem.mp.KPIValueCollection;
import com.kingdee.eas.sem.mp.KPIValueFactory;
import com.kingdee.eas.sem.mp.KPIValueInfo;
import com.kingdee.eas.sem.mp.KPIWarnParamCollection;
import com.kingdee.eas.sem.mp.KPIWarnParamFactory;
import com.kingdee.eas.sem.mp.KPIWarnParamInfo;
import com.kingdee.eas.sem.mp.app.AbstractKPIValueControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class KPIValueControllerBean
extends AbstractKPIValueControllerBean {
    protected static final String RES = "com.kingdee.eas.sem.mp.app.KPIAppResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.sem.mp.app.KPIValueControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._addnew(ctx, pk, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected boolean _isRef(Context ctx, String id) throws BOSException {
        String sql = "select fid from t_mp_kpivalue where fparentid=?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{id});
        return rowSet != null && rowSet.size() > 0;
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private UserInfo getUserInfo(Context ctx) throws BOSException {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    protected KPIValueInfo _calculateFormula(Context ctx, String kpiValueId) throws BOSException, EASBizException {
        SelectorItemCollection scc1 = new SelectorItemCollection();
        scc1.add(new SelectorItemInfo("*"));
        scc1.add("warnparam.*");
        scc1.add("currentWarnStatus.*");
        scc1.add("warnparam.warnGroup.color");
        scc1.add(new SelectorItemInfo("kpi.id"));
        scc1.add(new SelectorItemInfo("kpi.timeType"));
        scc1.add(new SelectorItemInfo("kpi.name"));
        scc1.add(new SelectorItemInfo("kpi.numberUnit"));
        scc1.add(new SelectorItemInfo("kpi.isPercent"));
        scc1.add(new SelectorItemInfo("kpi.displayPrecision"));
        scc1.add(new SelectorItemInfo("kpi.company.*"));
        scc1.add(new SelectorItemInfo("kpi.isUnpassedVoucherIncluded"));
        IKPIValue iKPIValue = KPIValueFactory.getLocalInstance(ctx);
        KPIValueInfo valueInfo = iKPIValue.getKPIValueInfo((IObjectPK)new ObjectUuidPK(kpiValueId), scc1);
        if (valueInfo != null) {
            KPIInfo kpiInfo = valueInfo.getKpi();
            String formula = valueInfo.getFormula();
            if (formula == null || formula.length() == 0) {
                return valueInfo;
            }
            if (!(formula = formula.trim()).startsWith("=")) {
                formula = "=" + formula;
            }
            if (formula.endsWith(";")) {
                formula = formula.substring(0, formula.length() - 1);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("bizDate", valueInfo.getBizDate());
            params.put("timeType", (Object)kpiInfo.getTimeType());
            params.put("company", kpiInfo.getCompany());
            params.put("chkIsUnpassedVoucherIncluded", kpiInfo.isIsUnpassedVoucherIncluded());
            BigDecimal tempValue = KPIFacadeFactory.getLocalInstance(ctx).calcFormula(formula, params);
            if (tempValue == null) {
                tempValue = new BigDecimal(0.0);
            }
            valueInfo.setKpiValue(tempValue);
            valueInfo.setLastUpdateTime(this.getTime());
            valueInfo.setLastComputeTime(this.getTime());
            iKPIValue.update((IObjectPK)new ObjectUuidPK(valueInfo.getId()), (CoreBaseInfo)valueInfo);
        }
        return valueInfo;
    }

    private void setPosition(Map columnMap, IRowSet rowSet, String[] arr) {
        int i = 0;
        try {
            Iterator it = columnMap.keySet().iterator();
            while (it.hasNext()) {
                if (rowSet.getString("frefgroupid").equalsIgnoreCase(it.next().toString())) {
                    arr[i] = rowSet.getString("frefvalue");
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected IObjectCollection _getKpiValueDetail(Context ctx, EntityViewInfo view, Map params) throws BOSException {
        KPIValueCollection kpiValueCollection = new KPIValueCollection();
        KPIValueInfo kpiValues = null;
        ArrayList<Object> list = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        LinkedHashMap columnMap = (LinkedHashMap)params.get("standardMap");
        String[] warnArr = (String[])params.get("warnparam");
        ev.setFilter(filter);
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        IRowSet standardValueRow = null;
        String sql = "select frefgroupid,frefvalue,fkpivalueid from T_MP_KPIValueRefStandardValue where fkpivalueid=?";
        try {
            exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.sem.mp.app.KPICalculateResultQuery"));
            exec.setObjectView(view);
            rowSet = exec.executeQuery();
            String currentKpiValueId = null;
            int i = 0;
            Object obj = null;
            Object value = null;
            while (rowSet.next()) {
                i = 0;
                kpiValues = new KPIValueInfo();
                list = new ArrayList<Object>(30);
                obj = rowSet.getObject("KPI.DISPLAYPRECISION");
                list.add(i++, rowSet.getString("NAME"));
                list.add(i++, rowSet.getString("KPI.NUMBER"));
                list.add(i++, rowSet.getString("KPI.NAME"));
                list.add(i++, (Object)KPITimeTypeEnum.getEnum(rowSet.getString("KPI.TIMETYPE")));
                list.add(i++, rowSet.getString("KPI.NUMBERUNIT"));
                list.add(i++, rowSet.getObject("CURRENTWARNSTATUS.NAME"));
                value = rowSet.getObject("KPIVALUE");
                if (value == null) {
                    list.add(i++, new Integer(0));
                } else if (value instanceof BigDecimal) {
                    list.add(i++, KPIValueControllerBean.cutString(value.toString(), obj));
                } else {
                    list.add(i++, new Integer(0));
                }
                currentKpiValueId = rowSet.getString("ID");
                String[] arr = new String[columnMap.size()];
                standardValueRow = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{currentKpiValueId});
                while (standardValueRow.next()) {
                    this.setPosition(columnMap, standardValueRow, arr);
                }
                for (int j = 0; j < arr.length; ++j) {
                    if (arr[j] == null) {
                        list.add(i++, null);
                        continue;
                    }
                    list.add(i++, KPIValueControllerBean.cutString(arr[j], obj));
                }
                list.add(i++, rowSet.getString("EDGEGROUP.NAME"));
                ev.getSelector().clear();
                filter.getFilterItems().clear();
                ev.getSelector().add("*");
                ev.getSelector().add("warnGroup.*");
                ev.getSelector().add("edgeParam.*");
                filter.getFilterItems().add(new FilterItemInfo("kpivalue", (Object)currentKpiValueId));
                KPIWarnParamCollection cols = KPIWarnParamFactory.getLocalInstance(ctx).getKPIWarnParamCollection(ev);
                boolean exist = false;
                if (null != cols && cols.size() > 0) {
                    for (int m = 0; m < warnArr.length; ++m) {
                        for (int k = 0; k < cols.size(); ++k) {
                            KPIWarnParamInfo warnParam = cols.get(k);
                            String str = warnParam.getWarnGroup().getName() + warnParam.getEdgeParam().getName();
                            if (!str.equalsIgnoreCase(warnArr[m])) continue;
                            if (null != warnParam.getCurrentValue()) {
                                list.add(i++, KPIValueControllerBean.cutString(warnParam.getCurrentValue().toString(), obj));
                            } else {
                                list.add(i++, null);
                            }
                            exist = true;
                        }
                        if (!exist) {
                            list.add(i++, null);
                        }
                        exist = false;
                    }
                } else {
                    for (int n = 0; n < warnArr.length; ++n) {
                        list.add(i++, null);
                    }
                }
                list.add(i++, rowSet.getString("PARTFI.NAME"));
                kpiValues.put("list", list);
                kpiValueCollection.add(kpiValues);
            }
        }
        catch (Exception e) {
            throw new BOSException(EASResource.getString((String)RES, (String)"getKpiValueDetail_exception"));
        }
        return kpiValueCollection;
    }

    private static String cutString(String refValue, Object obj) {
        if (null != refValue) {
            try {
                int length = 0;
                if (null != obj) {
                    length = (Integer)obj;
                }
                if (length == 0) {
                    length = 2;
                }
                BigDecimal value = new BigDecimal(refValue);
                return value.setScale(length, 4).toString();
            }
            catch (Exception e) {
                logger.fatal((Object)"error in cutString");
            }
        } else {
            return refValue;
        }
        return null;
    }
}

